define([
    'backbone',
    '../collections/product-images.js',
    'text!../templates/paginator.html',
    'text!../templates/product-images-row.html',
    'i18n!../../../nls/config_'+$('#product-additional-images-language').val()+'_ln.js'
], function(Backbone,
            ProductImagesCollection, PaginatorTmpl, ProductImagesRowTmpl, i18n
){

    var ProductImagesGridView = Backbone.View.extend({
        el: $('#additional-product-images-list'),
        events: {
            'click a[data-role=delete]': 'deleteProductImage',
            'click td.additional-product-images-paginator a.page': 'navigate'
        },
        templates: {
            paginator: _.template(PaginatorTmpl)
        },
        initialize: function(options) {
            this.productImages = new ProductImagesCollection();
            this.$el =  $('#additional-product-images-list');
            this.productImages.on('reset', this.renderProductImages, this);
            this.productImages.on('add', this.renderProductImages, this);
        },
        render: function()
        {
            this.productImages.server_api.product_id =  $('#current-product-id-addition-image').val();
            this.productImages.pager();
        },
        renderProductImages: function()
        {
            this.$el.find('#additional-product-images-list-list').empty();
            this.productImages.each(this.renderProductImage, this);
            this.productImages.info()['i18n'] = i18n;
            if((this.productImages.length == 0) && (this.productImages.currentPage != 0)){
                this.productImages.requestPreviousPage();
            }
            //this.$('td.additional-product-images-paginator').html(this.templates.paginator(this.productImages.information));
        },
        renderProductImage: function(productAdditionalImagesData)
        {
            this.$el.find('#additional-product-images-list-list').append(_.template(ProductImagesRowTmpl, {'productAdditionalImagesData': productAdditionalImagesData}));
            return false;
        },
        deleteProductImage: function(e) {
            var self = this,
                cid = $(e.currentTarget).data('cid'),
                model = this.productImages.get(cid);

            showConfirmCustom(_.isUndefined(i18n['Are you sure want to delete'])?'Are you sure want to delete':i18n['Are you sure want to delete'], _.isUndefined(i18n['Yes'])?'Yes':i18n['Yes'], _.isUndefined(i18n['No'])?'No':i18n['No'], function(){
                if (model){
                    model.destroy({
                        success: function() {
                            showMessage(_.isUndefined(i18n['Image has been deleted'])?'Image has been deleted':i18n['Image has been deleted']);
                            self.render();
                        }
                    });
                }
            });
        },
        navigate: function(e){
            e.preventDefault();

            var page = $(e.currentTarget).data('page');
            if ($.isNumeric(page)){
                this.productImages.goTo(page);
            } else {
                switch(page){
                    case 'first':
                        this.productImages.goTo(this.productImages.firstPage);
                        break;
                    case 'last':
                        this.productImages.goTo(this.productImages.information.lastPage);
                        break;
                    case 'prev':
                        this.productImages.requestPreviousPage();
                        break;
                    case 'next':
                        this.productImages.requestNextPage();
                        break;
                }
            }
        }
    });

    return ProductImagesGridView;
});