<?php

class Widgets_Productimages_Productimages extends Widgets_Abstract
{

    const DEFAULT_THUMB_SIZE = 250;

    const DEFAULT_THUMB_SIZE_HEIGHT = 166;

    /**
     * Website helper
     *
     * @var null
     */
    protected $_websiteHelper = null;

    /**
     * @var bool
     */
    protected $_cacheable = false;

    /**
     * Session helper
     *
     * @var bool
     */
    protected $_sessionHelper = false;

    /**
     * @var null
     */
    protected $_layout = null;

    protected function _init()
    {
        parent::_init();
        $this->_view = new Zend_View(array(
            'scriptPath' => __DIR__ . '/views/'
        ));


        $this->_layout = new Zend_Layout();
        $this->_layout->setLayoutPath(Zend_Layout::getMvcInstance()->getLayoutPath());

        $this->_websiteHelper = Zend_Controller_Action_HelperBroker::getStaticHelper('website');
        $this->_view->websiteUrl = $this->_websiteHelper->getUrl();
        $this->_websiteUrl = $this->_websiteHelper->getUrl();
        $this->_translator = Zend_Registry::get('Zend_Translate');

        $this->_view->setHelperPath(APPLICATION_PATH . '/views/helpers/');
        $this->_view->addHelperPath('ZendX/JQuery/View/Helper/', 'ZendX_JQuery_View_Helper');
        $this->_view->addScriptPath($this->_websiteHelper->getPath() . 'seotoaster_core/application/views/scripts/');
        // init helpers
        $this->_configHelper = Zend_Controller_Action_HelperBroker::getStaticHelper('config');
        $this->_sessionHelper = Zend_Controller_Action_HelperBroker::getStaticHelper('session');
    }

    protected function _load()
    {

        $pageId = $this->_toasterOptions['id'];
        $productModel = Models_Mapper_ProductMapper::getInstance()->findByPageId($pageId);
        if (!$productModel instanceof Models_Model_Product) {
            return $this->_translator->translate('You must use this widget only on the product page');
        }

        $productId = $productModel->getId();
        $folder = $productId;

        $productImagesMapper = Productimages_Mapper_ProductImagesMapper::getInstance();

        $productImages = $productImagesMapper->findByProductId($productId);
        if (empty($productImages)) {
            return '';
        }

        $setWidth = !empty($this->_options[0]) ? filter_var($this->_options[0],
            FILTER_SANITIZE_STRING) : self::DEFAULT_THUMB_SIZE;

        $config = Zend_Controller_Action_HelperBroker::getStaticHelper('config')->getConfig();

        $cropParams         = $this->_getCropParams();

        $subFolderPath = $this->_websiteHelper->getPath() . 'plugins/productimages/web/images/product-images/' . $folder;

        if (!empty($cropParams)) {
            $subFolderPath .= DIRECTORY_SEPARATOR. 'crop' . DIRECTORY_SEPARATOR . $cropParams['subfolder'] . DIRECTORY_SEPARATOR;
            Tools_Filesystem_Tools::mkdir($subFolderPath);
        }


        foreach ($productImages as $key => $productImage) {
            if (!is_numeric($setWidth)) {
                if (empty($cropParams)) {
                    if (!empty($folder) && !empty($productImage['file_name'])) {
                        $imgType = 'img' . ucfirst($setWidth);
                        if ($imgType == 'imgOriginal') {
                            $imgWebPath = $this->_websiteHelper->getUrl() . 'plugins/productimages/web/images/product-images/' . $folder . '/original/' . $productImage['file_name'];
                            $imgData = getimagesize(
                                $this->_websiteHelper->getPath() . 'plugins/productimages/web/images/product-images/' . $folder . '/original/' . $productImage['file_name']
                            );
                            $width = $imgData[0];
                            $height = $imgData[1];
                        } elseif ($imgType == 'imgCrop') {
                            $imgWebPath = $this->_websiteHelper->getUrl() . 'plugins/productimages/web/images/product-images/' . $folder . '/crop/' . $productImage['file_name'];
                            $imgData = getimagesize(
                                $this->_websiteHelper->getPath() . 'plugins/productimages/web/images/product-images/' . $folder . '/crop/' . $productImage['file_name']
                            );
                            $width = $imgData[0];
                            $height = $imgData[1];
                        } elseif (!empty($config[$imgType])) {
                            $imgWebPath = $this->_websiteHelper->getUrl() . 'plugins/productimages/web/images/product-images/' . $folder . '/' . $setWidth . '/' . $productImage['file_name'];
                            $imgData = getimagesize(
                                $this->_websiteHelper->getPath() . 'plugins/productimages/web/images/product-images/' . $folder . '/' . $setWidth . '/' . $productImage['file_name']
                            );
                            $width = $imgData[0];
                            $height = $imgData[1];
                        } else {
                            $width = self::DEFAULT_THUMB_SIZE;
                            $height = self::DEFAULT_THUMB_SIZE_HEIGHT;
                            $imgWebPath = $this->_websiteHelper->getUrl() . 'plugins/productimages/web/images/product-images/' . $folder . '/' . self::DEFAULT_THUMB_SIZE . '/' . $productImage['file_name'];
                        }
                    }
                } else {
                    $originalFolder = $this->_websiteHelper->getPath() . 'plugins/productimages/web/images/product-images/' . $folder . DIRECTORY_SEPARATOR . Tools_Image_Tools::FOLDER_ORIGINAL . DIRECTORY_SEPARATOR;
                    $previews = Tools_Filesystem_Tools::findFilesByExtension(
                        $originalFolder,
                        'jpg|png|jpeg|gif',
                        true,
                        true,
                        true
                    );

                    foreach ($previews as $pathFile) {
                        if (!is_readable($subFolderPath.basename($pathFile))) {
                            Tools_Image_Tools::resizeByParameters(
                                $pathFile,
                                $cropParams['width'],
                                $cropParams['height'],
                                true,
                                $subFolderPath,
                                true
                            );
                        }

                        $width = $cropParams['width'];
                        $height = $cropParams['height'];
                        $imgWebPath = $this->_websiteHelper->getUrl() . 'plugins/productimages/web/images/product-images'  . DIRECTORY_SEPARATOR . $folder . DIRECTORY_SEPARATOR. 'crop' . DIRECTORY_SEPARATOR . $cropParams['subfolder'] . DIRECTORY_SEPARATOR . $productImage['file_name'];
                    }
                }
            } elseif (is_numeric($setWidth)) {
                $subFolder = Productimages_Tools_Filesystem::getSubFolderByWidth($setWidth);
                if (!empty($folder) && !empty($productImage['file_name'])) {
                    $imgWebPath = $this->_websiteHelper->getUrl() . 'plugins/productimages/web/images/product-images/' . $folder . '/' . $subFolder . '/' . $productImage['file_name'];
                    $imgData = getimagesize(
                        $this->_websiteHelper->getPath() . 'plugins/productimages/web/images/product-images/' . $folder . '/' . $subFolder . '/' . $productImage['file_name']
                    );
                    $imgDataWidth = $imgData[0];
                    $imgDataHeight = $imgData[1];
                    $customWidth = $setWidth;
                    $width = $setWidth;

                    $resultHeight = $imgDataHeight / ($imgDataWidth / $customWidth);
                    $height = round($resultHeight);
                } else {
                    $width = self::DEFAULT_THUMB_SIZE;
                    $height = self::DEFAULT_THUMB_SIZE_HEIGHT;
                    $imgWebPath = $this->_websiteHelper->getUrl() . 'plugins/productimages/web/images/product-images/' . $folder . '/' . self::DEFAULT_THUMB_SIZE . '/' . $productImage['file_name'];
                }
            }
            $productImages[$key]['width'] = $width;
            $productImages[$key]['height'] = $height;
            $productImages[$key]['imgWebPath'] = $imgWebPath;
        }

        $imagesWebPathOriginal = $this->_websiteHelper->getUrl() . 'plugins/productimages/web/images/product-images/' . $productId . '/original/';
        $this->_view->productImages = $productImages;
        $this->_view->imagesWebPathOriginal = $imagesWebPathOriginal;

        return $this->_view->render('product-images.phtml');

    }


    /**
     * Returns the crop params
     *
     * @return array
     */
    private function _getCropParams()
    {
        $params = array();
        if (isset($this->_options[0]) && strpos($this->_options[0], Tools_Image_Tools::FOLDER_CROP . '-') !== false) {
            preg_match('/^' . Tools_Image_Tools::FOLDER_CROP . '-([0-9]+)x?([0-9]*)/i', $this->_options[0],
                $cropParams);
            if (isset($cropParams[1], $cropParams[2]) && is_numeric($cropParams[1]) && empty($cropParams[2])) {
                $cropParams[2] = $cropParams[1];
            }
            unset($cropParams[0]);
            $params['width'] = $cropParams[1];
            $params['height'] = $cropParams[2];
            $params['subfolder'] = implode('-', $cropParams);
        }

        return $params;
    }

}
