<?php

class Productimages_Tools_Filesystem
{
    const IMG_SMALL = 'small';
    const IMG_MEDIUM = 'medium';
    const IMG_LARGE = 'large';
    const IMG_ORIGINAL = 'original';
    const IMG_THUMBNAILS = 'thumbnails';
    const IMG_CROP = 'crop';
    const DEFAULT_THUMB_SIZE = '250';

    /**
     * Allowed image types
     *
     * @var array
     */
    public static $_allowedImageSizes = array(
        self::IMG_SMALL,
        self::IMG_MEDIUM,
        self::IMG_LARGE,
        self::IMG_ORIGINAL,
        self::IMG_THUMBNAILS,
        self::IMG_CROP
    );

    /**
     * @param $width
     * @return string
     */
    public static function getSubFolderByWidth($width)
    {
        $config = Zend_Controller_Action_HelperBroker::getStaticHelper('config')->getConfig();

        if ($width <= $config['imgSmall']) {
            return self::IMG_SMALL;
        }
        if ($width <= $config['imgMedium']) {
            return self::IMG_MEDIUM;
        }
        if ($width <= $config['imgLarge']) {
            return self::IMG_LARGE;
        }

        return self::IMG_ORIGINAL;
    }

    /**
     * Get js translation file translation path
     *
     *
     * @param string $pluginName plugin name
     * @param string $translationPrefix translation sub folder
     * @return string
     * @throws Zend_Exception
     */
    public static function getJsTranslationLanguage($pluginName, $translationPrefix = '')
    {
        $miscConfig = Zend_Registry::get('misc');
        $websiteHelper = Zend_Controller_Action_HelperBroker::getStaticHelper('website');
        $translator = Zend_Registry::get('Zend_Translate');
        $locale = $translator->getLocale();
        $translationFolderFilePath = $websiteHelper->getPath() . $miscConfig['pluginsPath'] . $pluginName . DIRECTORY_SEPARATOR . 'web' . DIRECTORY_SEPARATOR . 'js' . DIRECTORY_SEPARATOR . 'nls' . DIRECTORY_SEPARATOR;
        if (!empty($translationPrefix)) {
            $translationFolderFilePath .= $translationPrefix . '_';
        }
        $translationFolderFilePath = $translationFolderFilePath . $locale . '_ln.js';
        if (!file_exists($translationFolderFilePath)) {
            return 'en_US';
        }

        return $locale;

    }

    /**
     * Method get a 'folder' name from request array and checks if this folder exists.
     * If not it creates this folder
     * @param string $folder image folder path
     * @param string $subPath sub path for images
     * @return string directory path or false if error
     */
    public static function getSavePath($folder, $subPath = '')
    {
        $websiteHelper = Zend_Controller_Action_HelperBroker::getStaticHelper('website');
        if (!$folder || empty($folder)) {
            return array('error' => true, 'result' => 'No files uploaded. Please select folder.');
        }
        $folder = trim($folder, ' \/');
        $folderValidator = new Zend_Validate_Regex('~^[^\x00-\x1F"<>\|:\*\?/]+$~');
        if (!$folderValidator->isValid($folder)) {
            return false;
        }

        $savePath = $websiteHelper->getPath() . 'plugins' . DIRECTORY_SEPARATOR . 'productimages' . DIRECTORY_SEPARATOR . 'web' . DIRECTORY_SEPARATOR . 'images' . DIRECTORY_SEPARATOR . 'product-images' . DIRECTORY_SEPARATOR . $folder . DIRECTORY_SEPARATOR;
        if (!empty($subPath)) {
            $savePath = $savePath . $subPath . DIRECTORY_SEPARATOR;
        }

        if (!is_dir($savePath)) {
            try {
                Tools_Filesystem_Tools::mkDir($savePath);
            } catch (Exceptions_SeotoasterException $e) {
                error_log($e->getMessage());

                return false;
            }
        }

        return realpath($savePath);
    }

    /**
     * Method removes images with given name in the given directory via recursive scan of subfolders
     * such as, small, medium, etc.
     * @param string $imageName Name of image to be deleted
     * @param string $folderName Name of folder where image is
     * @return mixed  Boolean true on success of all operations array with errors, Boolean false on empty parameters given, Array with errors if something went wrong
     * @throws Exceptions_SeotoasterException
     * @throws Zend_Exception
     */
    public static function removeImageFromFilesystem($imageName, $folderName)
    {
        $imageName = trim($imageName);
        $folderName = trim($folderName);
        if (empty ($imageName) || empty ($folderName)) {
            return false;
        }

        $websiteHelper = Zend_Controller_Action_HelperBroker::getStaticHelper('website');

        $folderPath = $websiteHelper->getPath() . 'plugins' . DIRECTORY_SEPARATOR . 'productimages' . DIRECTORY_SEPARATOR . 'web' . DIRECTORY_SEPARATOR . 'images' . DIRECTORY_SEPARATOR . 'product-images' . DIRECTORY_SEPARATOR . $folderName;
        if (!is_dir($folderPath)) {
            throw new Exceptions_SeotoasterException('Wrong folder name specified');
        }

        $errorCount = 0;
        $subFoldersList = array_merge(Tools_Image_Tools::$imgResizedFolders, array(Tools_Image_Tools::FOLDER_ORIGINAL));
        //list of file that can be removed
        $removable = array();
        foreach ($subFoldersList as $key => $subFolder) {
            $pathSubFolder = $folderPath . DIRECTORY_SEPARATOR . $subFolder;

            if (!is_dir($pathSubFolder)) {
                error_log('Not a folder:' . $pathSubFolder);
                unset($subFoldersList[$key]);
                continue;
            }

            $filename = $pathSubFolder . DIRECTORY_SEPARATOR . $imageName;
            //checking if enough permission to remove file
            if (is_file($filename)) {
                array_push($removable, $filename);
            }

            // checking cropped images to remove file
            if ($subFolder == Tools_Image_Tools::FOLDER_CROP) {
                $subFolders = Tools_Filesystem_Tools::scanDirectory($pathSubFolder, false, false);
                foreach ($subFolders as $folder) {
                    if (!is_dir($pathSubFolder . DIRECTORY_SEPARATOR . $folder)) {
                        continue;
                    }
                    $filename = $pathSubFolder . DIRECTORY_SEPARATOR . $folder . DIRECTORY_SEPARATOR . $imageName;
                    if (is_file($filename)) {
                        array_push($removable, $filename);
                    }
                }
            }
        }

        /**
         * checking if we can remove all files at once
         * if not - returning with error
         */

        foreach ($removable as $file) {
            if (!is_writable($file)) {
                return 'Permission denied';
            }
        }

        foreach ($removable as $file) {
            try {
                Tools_Filesystem_Tools::deleteFile($file);
            } catch (Exceptions_SeotoasterException $e) {
                $errorCount++;
                error_log($file . ': ' . $e->getMessage());
            }
        }
        if ($errorCount) {
            return false;
        }

        return true;
    }



}