<?php

/**
 * ProductImagesMapper.php
 *
 *
 * @method Productimages_Mapper_ProductImagesMapper   getInstance()   getInstance()   Returns an instance of itself
 * @method Zend_Db_Table    getDbTable()    getDbTable()    Returns an instance of DbTable
 */
class Productimages_Mapper_ProductImagesMapper extends Application_Model_Mappers_Abstract
{

    protected $_model = 'Productimages_Model_ProductImagesModel';

    protected $_dbTable = 'Productimages_DbTable_ProductImagesDbTable';

    /**
     * Save product image to DB
     * @param $model Productimages_Model_ProductImagesModel
     * @return Productimages_Model_ProductImagesModel
     */
    public function save($model)
    {
        if (!$model instanceof $this->_model) {
            $model = new $this->_model($model);
        }

        $data = array(
            'product_id' => $model->getProductId(),
            'file_name' => $model->getFileName(),
            'order_number' => $model->getOrderNumber()
        );

        $id = $model->getId();
        if (!empty($id)) {
            $where = $this->getDbTable()->getAdapter()->quoteInto('id = ?', $id);
            $this->getDbTable()->update($data, $where);
        } else {
            $id = $this->getDbTable()->insert($data);
            $model->setId($id);
        }

        return $model;
    }

    /**
     * Get product images data with info
     *
     * @param string $where SQL where clause
     * @param string $order OPTIONAL An SQL ORDER clause.
     * @param int $limit OPTIONAL An SQL LIMIT count.
     * @param int $offset OPTIONAL An SQL LIMIT offset.
     * @param bool $withoutCount without count flag
     * @param bool $singleRecord return single record
     * @return array
     */
    public function fetchAll(
        $where = null,
        $order = null,
        $limit = null,
        $offset = null,
        $withoutCount = false,
        $singleRecord = false
    ) {
        $select = $this->getDbTable()->getAdapter()->select()
            ->from(array('ppf' => 'plugin_productimages_files'),
                array(
                    'ppf.id',
                    'ppf.product_id',
                    'ppf.file_name',
                    'ppf.order_number'
                )
            );

        if (!empty($order)) {
            $select->order($order);
        }

        if (!empty($where)) {
            $select->where($where);
        }

        $select->limit($limit, $offset);

        if ($singleRecord) {
            $data = $this->getDbTable()->getAdapter()->fetchRow($select);
        } else {
            $data = $this->getDbTable()->getAdapter()->fetchAll($select);
        }

        if ($withoutCount === false) {
            $select->reset(Zend_Db_Select::COLUMNS);
            $select->reset(Zend_Db_Select::FROM);
            $select->reset(Zend_Db_Select::LIMIT_OFFSET);
            $select->reset(Zend_Db_Select::GROUP);

            $select->from(array('ppf' => 'plugin_productimages_files'), array('count' => 'COUNT(ppf.id)'));
            $count = $this->getDbTable()->getAdapter()->fetchRow($select);

            return array(
                'totalRecords' => $count['count'],
                'data' => $data,
                'offset' => $offset,
                'limit' => $limit
            );
        }

        return $data;
    }

    /**
     * Find by file name
     * @param int $productId product id
     * @param string $fileName image name
     * @return Productimages_Model_ProductImagesModel
     */
    public function findByFileName($productId, $fileName)
    {
        $where = $this->getDbTable()->getAdapter()->quoteInto('file_name = ?', $fileName);
        $where .= ' AND ' . $this->getDbTable()->getAdapter()->quoteInto('product_id = ?', $productId);

        return $this->_findWhere($where);
    }

    /**
     * Find by product id
     * @param int $productId product id
     * @return Productimages_Model_ProductImagesModel
     */
    public function findByProductId($productId)
    {
        $where = $this->getDbTable()->getAdapter()->quoteInto('product_id = ?', $productId);
        $select = $this->getDbTable()->getAdapter()->select()->from('plugin_productimages_files',
                array('id', 'product_id', 'file_name', 'order_number'))->where($where);

        return $this->getDbTable()->getAdapter()->fetchAssoc($select);
    }


    /**
     * Delete product image
     *
     * @param int $id product image id
     * @return mixed
     * @throws Exception
     */
    public function delete($id)
    {
        $where = $this->getDbTable()->getAdapter()->quoteInto('id = ?', $id);

        return $this->getDbTable()->getAdapter()->delete('plugin_productimages_files', $where);

    }

}
