<?php

class Api_Productimages_Productimages extends Api_Service_Abstract
{


    const PRODUCT_IMAGES_SECURE_TOKEN = 'ProductimagesToken';

    /**
     * Website helper
     *
     * @var null
     */
    private $_websiteHelper = null;

    /**
     * System response helper
     *
     * @var null
     */
    protected $_responseHelper = null;

    /**
     * Mandatory fields
     *
     * @var array
     */
    protected $_mandatoryParams = array('product_id');


    protected $_accessList = array(
        Tools_Security_Acl::ROLE_USER => array('allow' => array('get', 'post', 'put', 'delete')),
        Tools_Security_Acl::ROLE_SUPERADMIN => array('allow' => array('get', 'post', 'put', 'delete')),
        Tools_Security_Acl::ROLE_ADMIN => array('allow' => array('get', 'post', 'put', 'delete')),
        Shopping::ROLE_SALESPERSON => array('allow' => array('get', 'post', 'put', 'delete'))
    );

    public function init()
    {
        $this->_websiteHelper = Zend_Controller_Action_HelperBroker::getStaticHelper('website');
        $this->_responseHelper = Zend_Controller_Action_HelperBroker::getStaticHelper('response');
    }


    public function getAction()
    {
        $limit = filter_var($this->_request->getParam('limit'), FILTER_SANITIZE_NUMBER_INT);
        $offset = filter_var($this->_request->getParam('offset'), FILTER_SANITIZE_NUMBER_INT);
        $sortOrder = filter_var($this->_request->getParam('order'), FILTER_SANITIZE_STRING);
        $id = filter_var($this->_request->getParam('id'), FILTER_SANITIZE_NUMBER_INT);
        $productId = filter_var($this->_request->getParam('product_id'), FILTER_SANITIZE_NUMBER_INT);

        $productImagesMapper = Productimages_Mapper_ProductImagesMapper::getInstance();
        if ($id) {
            $where = $productImagesMapper->getDbTable()->getAdapter()->quoteInto('ppf.id = ?', $id);
            $data = $productImagesMapper->fetchAll($where, $sortOrder, $limit, $offset);
        } elseif ($productId) {
            $where = $productImagesMapper->getDbTable()->getAdapter()->quoteInto('ppf.product_id = ?', $productId);
            $data = $productImagesMapper->fetchAll($where, $sortOrder, $limit, $offset);
        } else {
            $data = $productImagesMapper->fetchAll(null, $sortOrder, $limit, $offset);
        }

        return $data;

    }

    /**
     * Upload an image
     *
     */
    public function postAction()
    {
        $imageData = $this->_request->getParams();

        $tokenToValidate = $this->_request->getParam(Tools_System_Tools::CSRF_SECURE_TOKEN, false);
        $tokenValid = Tools_System_Tools::validateToken($tokenToValidate, self::PRODUCT_IMAGES_SECURE_TOKEN);
        $translator = Zend_Registry::get('Zend_Translate');
        if (!$tokenValid) {
            $this->_responseHelper->fail($translator->translate('invalid token'));
        }

        if (empty($imageData['folder'])) {
            $this->_responseHelper->fail($translator->translate('empty product folder'));
        }

        if (empty($imageData['name'])) {
            $this->_responseHelper->fail($translator->translate('empty image name'));
        }

        if (empty($imageData['productId'])) {
            $this->_responseHelper->fail($translator->translate('empty product id'));
        }

        $productImagesMapper = Productimages_Mapper_ProductImagesMapper::getInstance();
        $productId = filter_var($imageData['productId'], FILTER_SANITIZE_NUMBER_INT);
        $imageFolder = trim(preg_replace('~[^\w]+|[\s\-]+~ui', '-', filter_var($imageData['folder'], FILTER_SANITIZE_STRING)), '-');
        $clearPathToDirectory = Productimages_Tools_Filesystem::getSavePath($imageFolder);
        $pathToDirectory = Productimages_Tools_Filesystem::getSavePath($imageFolder, Productimages_Tools_Filesystem::IMG_ORIGINAL);
        if (!$pathToDirectory) {
            $this->_responseHelper->fail($translator->translate('directory doesn\'t exist'));
        }

        $miscConfig = Zend_Registry::get('misc');
        $uploadHandler = new Zend_File_Transfer_Adapter_Http();
        $uploadHandler->clearValidators()
            ->addValidator('Extension', false, array('jpeg', 'jpg', 'png', 'gif', 'webp'))
            ->addValidator('ImageSize', false,
                array('maxwidth' => $miscConfig['imgMaxWidth'], 'maxheight' => $miscConfig['imgMaxWidth']));

        if (extension_loaded('fileinfo')) {
            $uploadHandler->addValidator(new Validators_MimeType(array(
                'image/gif',
                'image/jpeg',
                'image/jpg',
                'image/png',
                'image/webp'
            )), false);
        }

        if ($uploadHandler->isUploaded() && $uploadHandler->isValid()) {
            if (!$uploadHandler->hasFilter('Rename')) {
                $filterChain = new Zend_Filter();
                $filterChain->addFilter(new Zend_Filter_StringTrim())
                    ->addFilter(new Zend_Filter_StringToLower('UTF-8'))
                    ->addFilter(new Zend_Filter_PregReplace(array('match' => '/[^\w\d_]+/u', 'replace' => '-')));

                $fileInfo = current($uploadHandler->getFileInfo());
                $fullFileName = $fileInfo['name'];
                $fileName = pathinfo($fullFileName, PATHINFO_FILENAME);
                $fileExt = strtolower(pathinfo($fullFileName, PATHINFO_EXTENSION));
                if (!in_array($fileExt, array('jpeg', 'jpg', 'png', 'gif', 'webp'))) {
                    $this->_responseHelper->fail($translator->translate('Wrong file extension'));
                }

                $newImageName = $filterChain->filter($fileName);

                if (false !== ($newImageName)) {
                    $newImageNameWithExtension =  $newImageName . '.' . $fileExt;
                    $productImagesModel = $productImagesMapper->findByFileName($productId, $newImageNameWithExtension);
                    if ($productImagesModel instanceof Productimages_Model_ProductImagesModel) {
                        $this->_responseHelper->fail($translator->translate('Image with such name already exists'));
                    }
                    $uploadHandler->addFilter('Rename', array(
                        'target' => $pathToDirectory . DIRECTORY_SEPARATOR. $newImageNameWithExtension,
                        'overwrite' => true
                    ));
                } else {
                    $this->_responseHelper->fail($translator->translate('Wrong file name'));
                }
            }
            if (!$uploadHandler->receive()) {
                $errorTxt = $translator->translate('Error during image upload') . '<br>';
                $errorMsg = $uploadHandler->getMessages();

                if(!empty($errorMsg)) {
                    foreach ($errorMsg as $error) {
                        $errorTxt .= $error . '<br>';
                    }
                }
                $this->_responseHelper->fail($errorTxt);
            }
        } else {
            $errorTxt = $translator->translate('Error during image upload') . '<br>';
            $errorMsg = $uploadHandler->getMessages();

            if(!empty($errorMsg)) {
                foreach ($errorMsg as $error) {
                    $errorTxt .= $error . '<br>';
                }
            }
            $this->_responseHelper->fail($errorTxt);
        }

        $status = Tools_Image_Tools::batchResize($pathToDirectory . DIRECTORY_SEPARATOR. $newImageNameWithExtension, $clearPathToDirectory. DIRECTORY_SEPARATOR);

        $thumbnailsDirectory = Productimages_Tools_Filesystem::getSavePath($imageFolder. DIRECTORY_SEPARATOR, Productimages_Tools_Filesystem::IMG_THUMBNAILS);
        $cropDirectory = Productimages_Tools_Filesystem::getSavePath($imageFolder. DIRECTORY_SEPARATOR, Productimages_Tools_Filesystem::IMG_CROP);

        $useCrop = true;
        $thumbSize = Productimages_Tools_Filesystem::DEFAULT_THUMB_SIZE;

        Tools_Image_Tools::resizeByParameters(
            $pathToDirectory . DIRECTORY_SEPARATOR . $newImageNameWithExtension,
            $thumbSize,
            'auto',
            !($useCrop),
            $thumbnailsDirectory,
            $useCrop
        );

        Tools_Image_Tools::resizeByParameters(
            $pathToDirectory . DIRECTORY_SEPARATOR . $newImageNameWithExtension,
            $thumbSize,
            'auto',
            !($useCrop),
            $cropDirectory,
            $useCrop
        );

        $productImagesModel = new Productimages_Model_ProductImagesModel();
        $productImagesModel->setFileName($newImageNameWithExtension);
        $productImagesModel->setOrderNumber(0);
        $productImagesModel->setProductId($productId);
        $productImagesMapper->save($productImagesModel);

        $this->_responseHelper->success($translator->translate('Image has been uploaded'));
    }

    public function putAction()
    {
    }

    /**
     * Delete image
     *
     */
    public function deleteAction()
    {
        $translator = Zend_Registry::get('Zend_Translate');
        $id = filter_var($this->getRequest()->getParam('id', false), FILTER_SANITIZE_NUMBER_INT);
        if (empty($id)) {
            $this->_error($translator->translate('Id is missing'));
        }

        $productImagesMapper = Productimages_Mapper_ProductImagesMapper::getInstance();
        $productImagesModel = $productImagesMapper->find($id);
        if ($productImagesModel instanceof Productimages_Model_ProductImagesModel) {
            $productImageName = $productImagesModel->getFileName();
            $productId = $productImagesModel->getProductId();
            $folderPath = Productimages_Tools_Filesystem::getSavePath($productId. DIRECTORY_SEPARATOR);
            try {
                // removing image from filesystem
                if (($result = Productimages_Tools_Filesystem::removeImageFromFilesystem($productImageName,
                        $productId)) !== true
                ) {
                    $this->_error($translator->translate($result));
                }

                $productImagesMapper->delete($id);
                //cleaning up the file system if needed
                $folderContent = Tools_Filesystem_Tools::scanDirectory($folderPath, false, true);
                if (empty($folderContent)) {
                    try {
                        Tools_Filesystem_Tools::deleteDir($folderPath);
                    } catch (Exception $e) {
                        $this->_error($e->getMessage());
                    }
                }
            } catch (Exceptions_SeotoasterException $e) {
                error_log($e->getMessage() . PHP_EOL . $e->getTraceAsString());
                $this->_error($e->getMessage());
            }
        }   else {

        }


    }

}
