<?php

class Productimages extends Tools_Plugins_Abstract
{

    /**
     * Product images secure token
     */
    const PRODUCT_IMAGES_SECURE_TOKEN = 'ProductimagesToken';

    /**
     * product tab name
     *
     */
    const DISPLAY_NAME = 'Additional images';

    /**
     * Product config tab order
     */
    const TAB_ORDER = '2';


    /**
     * Disable merchandising tab
     */
    const WITHOUT_TAB = true;

    /**
     * System layout
     *
     * @var null
     */
    protected $_layout = null;

    /**
     * Website config
     *
     * @var null
     */
    protected $_websiteConfig = null;

    /**
     * depends on plugins list
     *
     * @var array
     */
    protected $_dependsOn = array(
        'shopping',
        'cart',
        'quote'
    );

    public $acceptedFileTypesArray = array(
        'jpeg',
        'jpg',
        'png',
        'gif',
        'webp',
    );

    /**
     * Init
     *
     * @throws Exceptions_SeotoasterPluginException
     * @throws Zend_Exception
     */
    protected function _init()
    {
        $missedPlugins = array_diff($this->_dependsOn, Tools_Plugins_Tools::getEnabledPlugins(true));

        if (!empty($missedPlugins)) {
            throw new Exceptions_SeotoasterPluginException($this->_translator->translate('Required plugins should be enabled') . ': <b>' . implode(',',
                    $missedPlugins) . '</b>');
        }
        $this->_websiteConfig = Zend_Registry::get('website');

        $this->_layout = new Zend_Layout();
        $this->_layout->setLayoutPath(Zend_Layout::getMvcInstance()->getLayoutPath());

        if ($viewScriptPath = Zend_Layout::getMvcInstance()->getView()->getScriptPaths()) {
            $this->_view->setScriptPath($viewScriptPath);
        }
        $this->_view->addScriptPath(__DIR__ . '/system/views/');
    }

    /**
     * Configuration tab
     *
     * @throws Exceptions_SeotoasterPluginException
     */
    public function tabAction()
    {
        if (!Tools_Security_Acl::isAllowed(Shopping::RESOURCE_STORE_MANAGEMENT)) {
            throw new Exceptions_SeotoasterPluginException('Forbidden');
        }

        $pid = filter_var($this->_request->getParam('productId'), FILTER_SANITIZE_NUMBER_INT);
        if ($pid) {
            $this->_view->currentProductId = $pid;
        }

        $this->_view->mimeTypes = $this->acceptedFileTypesArray;
        $uploadMaxSize = ini_get('upload_max_filesize');
        $this->_view->uploadMaxSize = !empty($uploadMaxSize) ? $uploadMaxSize : '';

        $enableSeosambaPosPlugin = false;
        $enabledSeosambaPosPlugin = Application_Model_Mappers_PluginMapper::getInstance()->findByName('seosambapos');
        if ($enabledSeosambaPosPlugin != null) {
            if ($enabledSeosambaPosPlugin->getStatus() == Application_Model_Models_Plugin::ENABLED) {
                $enableSeosambaPosPlugin = true;
            }
        }

        $isDefaultProduct = false;
        if($enableSeosambaPosPlugin){
            $defaultProductSettingsMapper = Seosambapos_Models_Mappers_SeosambaposDefaultproductSettingMapper::getInstance();
            $defaultProductId = $defaultProductSettingsMapper->getConfigParam('defaultProductId');

            if(!empty($defaultProductId) && $pid == $defaultProductId) {
                $isDefaultProduct = true;
            }
        }

        $this->_view->isDefaultProduct = $isDefaultProduct;

        echo $this->_view->render('tab.phtml');
    }


}

