define([
    'backbone',
    'moment',
    'text!../templates/filter-lead-organization-custom-params-field-row.html',
    'i18n!../../../nls/dashboard_'+$('#main-dashboard-system-language').val()+'_ln'
], function(Backbone, moment, LeadOrganizationCustomParamFieldRowTmpl, i18n){
    var LeadOrganizationFilterPresetView = Backbone.View.extend({
        el: $('#lead-organization-additional-filters'),
        events: {
            'click #save-filter-preset': 'saveFilterPreset',
            'change #lead-organization-predefined-filter-list': 'changeFilterPreset',
            'click #delete-filter-preset': 'deleteFilterPreset'
        },
        templates: {

        },
        initialize: function(){
            this.$el = $('#lead-organization-additional-filters');
        },
        render: function(){
            return this;
        },
        saveFilterPreset: function(e)
        {
            e.preventDefault();
            var leadOrganizationFilterPresetName = $('#lead-organization-filter-preset-name').val(),
                leadOrganizationFilterPresetDefault = 0,
                leadOrganizationFilterAllowPreset = 'individual',
                requestType = 'POST',
                leadPresetId = $('#lead-organization-preset-id').val(),
                filterPresetData = {},
                notAllowedSymbols = false,
                self = this;

            if (!_.isEmpty(leadOrganizationFilterPresetName)) {
                if (leadOrganizationFilterPresetName.match(/[^\w\s]/)) {
                    notAllowedSymbols = true;
                }

                if(notAllowedSymbols) {
                    showMessage(_.isUndefined(i18n['Special symbols like !.,?-@:; can\'t be used for names'])?'Special symbols like !.,?"@:; can\'t be used for names':i18n['Special symbols like !.,?"@:; can\'t be used for names'], true, 5000);
                    return false;
                }

                if ($('#lead-organization-filter-preset-default').is(':checked')) {
                    leadOrganizationFilterPresetDefault = 1;
                }
                if ($('#lead-organization-filter-preset-allow').is(':checked')) {
                    leadOrganizationFilterAllowPreset = 'all';
                }
                if (!_.isEmpty(leadPresetId)) {
                    requestType = 'PUT';
                }

                filterPresetData = {'created_at_from' : ($('#lead-organization-filter-from-date').val()) ? $.datepicker.formatDate('yy-mm-dd', $('#lead-organization-filter-from-date').datepicker("getDate")): '',
                    'created_at_to': ($('#lead-organization-filter-to-date').val()) ? $.datepicker.formatDate('yy-mm-dd', $('#lead-organization-filter-to-date').datepicker("getDate")): '',
                    'range_creation_option': $('#range-creation-option').val(),
                    'customer_group_id':$('#lead-organization-filter-by-group').val(),
                    'organization_zip': $('#lead-filter-organization-zip').val(),
                    'organization_country': $('#lead-organization-filter-country').val(),
                    'organization_country_state': $('#lead-organization-filter-country-state').val(),
                    'organization_city': $('#lead-filter-organization-city').val(),
                    'total_opportunity_amount_from': $('#lead-filter-total-opportunity-amount-from').val(),
                    'total_opportunity_amount_to': $('#lead-filter-total-opportunity-amount-to').val(),
                    'organization_by_industry':$('#lead-organization-filter-by-industry').val(),
                    'last_interaction_id':$('#lead-organization-filter-by-last-interaction').val(),
                    'industry_id':$('#lead-organization-filter-by-industry').val(),
                    'created_at': $('#switch-created-date:checked').val(),
                    'last_updated': $('#switch-updated-date:checked').val(),
                    'lead_opportunity_stages': $('#lead-filter-organization-opportunity-stage').val(),
                    'opportunity_type_id':$('#lead-filter-by-opportunity-type').val(),
                    'lead_score_from':$('#lead-organization-filter-score-from').val(),
                    'lead_score_to':$('#lead-organization-filter-score-to').val(),
                    'organization_sentiment_weighted_score_from':$('#lead-organization-filter-sentiment-score-from').val(),
                    'organization_sentiment_weighted_score_to':$('#lead-organization-filter-sentiment-score-to').val(),
                    'special_filter_type': $('input[name=leadOrganizationFilterBySpecialType]:checked').val(),
                    'lead_filter_total_spent_purchase_amount_from': $('#lead-organization-filter-total-spent-purchase-amount-from').val(),
                    'lead_filter_total_spent_purchase_amount_to': $('#lead-organization-filter-total-spent-purchase-amount-to').val(),
                    'custom_organization_params_search': self.getOrganizationCustomParams(),
                    'outbound_emails_sub_type': $('#outbound-emails-sub-types').val(),
                    'organization_tags': $('#organization-filter-tag').val(),
                    'organization_tags_exclude': $('#organization-filter-tag-exclude').val(),
                    'organization_without_leads': ($('#lead-organization-without-leads').is(':checked') ? 1 : 0)

                };

                var formParams = {'filter_preset_type': $('#filter-preset-type').val(), 'filter_preset_name':leadOrganizationFilterPresetName,'is_default': leadOrganizationFilterPresetDefault,
                    'access': leadOrganizationFilterAllowPreset, 'filter_preset_data': filterPresetData, 'secureToken': $('#lead-organization-grid-token').val()
                    };
                if (requestType === 'PUT') {
                    formParams.id = leadPresetId;
                    formParams = JSON.stringify(formParams);
                }

                $.ajax({
                    'url': $('#website_url').val() + 'api/leads/leadfilterpreset/',
                    'type' : requestType,
                    'dataType': 'json',
                    'data': formParams
                }).done(function(response){
                    $('#lead-organization-preset-id').val('');
                    $('#lead-organization-filter-preset-default').prop('checked', false);
                    $('#lead-organization-filter-preset-allow').prop('checked', false);
                    $('#lead-organization-filter-preset-name').val('');
                    $('#range-creation-option').val(0);
                    if (requestType === 'POST') {
                        $('#lead-organization-predefined-filter-list').append('<option value="' + response.responseText.id + '">' + leadOrganizationFilterPresetName + '</option>');
                    } else {
                        $('#lead-organization-predefined-filter-list option:selected').text(leadOrganizationFilterPresetName);
                    }
                    $('#lead-organization-predefined-filter-list').val(0);
                    $('#lead-organization-filter-by-last-interaction').closest('div').removeClass('grid_6').addClass('grid_12');
                    $('#delete-filter-preset').hide();
                    showMessage(response.responseText.message, false, 5000);
                    $('#lead-organization-filter-reset').trigger('click');
                }).fail(function(response) {
                    showMessage(response.responseJSON, true, 5000);
                });
            }
        },
        getOrganizationCustomParams: function()
        {
            var customParamsData = [],
                fieldType = '',
                year = '',
                month = '',
                day = '',
                value = '';

            $.each($('#custom-organization-attribute-field-row-block').find('.custom-field-row-block'), function () {
                    var fieldType = $(this).data('field-type'),
                    operator = $(this).find('.field-operator-value').val();

                if (fieldType !== 'date') {
                    customParamsData.push({
                        'name': $(this).data('field-name'),
                        'operator': $(this).find('.field-operator-value').val(),
                        'value': $(this).find('.custom-field-row-value').val(),
                        'type': $(this).data('field-type'),
                        'subtype': $(this).data('field-subtype'),
                        'id': $(this).data('field-id'),
                        'label': $(this).data('field-label')
                    });
                } else {
                    year = $(this).find('.custom-field-row-value-year').val();
                    month = $(this).find('.custom-field-row-value-month').val();
                    day = $(this).find('.custom-field-row-value-day').val();
                    value = JSON.stringify({'year':year, 'month':month, 'day':day});
                    customParamsData.push({
                        'name': $(this).data('field-name'),
                        'operator': $(this).find('.field-operator-value').val(),
                        'value': value,
                        'type': $(this).data('field-type'),
                        'subtype': $(this).data('field-subtype'),
                        'id': $(this).data('field-id'),
                        'label': $(this).data('field-label')
                    });
                }
            });

            return customParamsData;
        },
        deleteFilterPreset: function(e) {
            var presetId = $('#lead-organization-predefined-filter-list').val();

            if (_.isEmpty(presetId)) {
                return false;
            }

            showConfirm(_.isUndefined(i18n['Are you sure want to delete'])?'Are you sure want to delete':i18n['Are you sure want to delete'], function(){
                $.ajax({
                    url: $('#website_url').val() + 'api/leads/leadfilterpreset/id/' + presetId,
                    type: 'DELETE'
                }).done(function(response){
                    if(response.error == 1) {
                        showMessage(response.responseText, true, 5000);
                    } else {
                        $('#lead-organization-preset-id').val('');
                        $('#lead-organization-filter-preset-default').prop('checked', false);
                        $('#lead-organization-filter-preset-allow').prop('checked', false);
                        $('#lead-organization-filter-preset-name').val('');
                        $('#range-creation-option').val(0);
                        $('#lead-organization-predefined-filter-list').val(0);
                        $('#lead-organization-predefined-filter-list option[value="'+ presetId +'"]').remove();
                        $('#delete-filter-preset').hide();
                        $('#lead-organization-filter-by-last-interaction').closest('div').removeClass('grid_6').addClass('grid_12');
                        $('#inbound-emails-sub-types').val(0);

                        showMessage(response.responseText, false, 5000);
                        $('#lead-organization-filter-reset').trigger('click');
                    }
                });
            });
        },
        changeFilterPreset:function(e)
        {
            var presetId = $(e.currentTarget).val();
            self = this;
            if (_.isEmpty(presetId)) {
                return false;
            }

            if (presetId == '0') {
                $('#lead-organization-preset-id').val('');
                $('#lead-organization-filter-reset').trigger('click');
                $('#switch-search-filter-label').text((_.isUndefined(i18n['OR'])?'OR':i18n['OR']));
                $('#delete-filter-preset').hide();
                return false;
            }

            $('#switch-search-filter-label').text((_.isUndefined(i18n['Modify preset name'])?'Modify preset name':i18n['Modify preset name']));

            $.ajax({
                'url': $('#website_url').val()+'api/leads/leadfilterpreset/',
                'type':'GET',
                'dataType':'json',
                'data': {'id': presetId, 'secureToken': $('#lead-grid-token').val()}
            }).done(function(responseData){

                var createdAtFrom = '',
                    createdAtTo = '';

                if (responseData.isDefault == '1') {
                    $('#lead-organization-filter-preset-default').prop('checked', true);
                } else {
                    $('#lead-organization-filter-preset-default').prop('checked', false);
                }
                if (responseData.access === 'individual') {
                    $('#lead-organization-filter-preset-allow').prop('checked', false);
                } else {
                    $('#lead-organization-filter-preset-allow').prop('checked', true);
                }
                var filtersData = JSON.parse(responseData.filterPresetData);

                if (!_.isUndefined(filtersData.range_creation_option)) {
                    $('#range-creation-option').val(filtersData.range_creation_option);
                    $('.rangeCreationOptions').trigger('change');
                } else {
                    $('#range-creation-option').val(0);
                }

                if (!_.isUndefined(filtersData.created_at_from) && filtersData.created_at_from !== '') {
                    createdAtFrom = $.datepicker.formatDate('d-M-yy', new Date(filtersData.created_at_from));
                }
                if (!_.isUndefined(filtersData.created_at_to) && filtersData.created_at_to !== '') {
                    createdAtTo = $.datepicker.formatDate('d-M-yy', new Date(filtersData.created_at_to));
                }

                if (!_.isUndefined(filtersData.created_at_from)) {
                    $('#lead-organization-filter-from-date').val(createdAtFrom);
                }

                if (!_.isUndefined(filtersData.created_at_to)) {
                    $('#lead-organization-filter-to-date').val(createdAtTo);
                }

                if (filtersData.customer_group_id) {
                    $('#lead-organization-filter-by-group').val(filtersData.customer_group_id);
                } else {
                    $('#lead-organization-filter-by-group').val(0);
                }

                if (filtersData.last_interaction_id) {
                    $('#lead-organization-filter-by-last-interaction').val(filtersData.last_interaction_id);
                } else {
                    $('#lead-organization-filter-by-last-interaction').val(0);
                }
                if (filtersData.industry_id) {
                    $('#lead-organization-filter-by-industry').val(filtersData.industry_id);
                } else {
                    $('#lead-organization-filter-by-industry').val(0);
                }
                $('#lead-filter-total-opportunity-amount-from').val(filtersData.total_opportunity_amount_from);
                $('#lead-filter-total-opportunity-amount-to').val(filtersData.total_opportunity_amount_to);
                $('#lead-filter-organization-city').val(filtersData.organization_city);
                $('#lead-organization-filter-score-from').val(filtersData.lead_score_from);

                if (typeof filtersData.organization_sentiment_weighted_score_from !== 'undefined') {
                    $('#lead-organization-filter-sentiment-score-from').val(filtersData.organization_sentiment_weighted_score_from);
                }
                if (typeof filtersData.organization_sentiment_weighted_score_to !== 'undefined') {
                    $('#lead-organization-filter-sentiment-score-to').val(filtersData.organization_sentiment_weighted_score_to);
                }

                $('#lead-organization-filter-score-to').val(filtersData.lead_score_to);
                $('#lead-filter-organization-zip').val(filtersData.organization_zip);
                if (filtersData.organization_country) {
                    $('#lead-organization-filter-country').val(filtersData.organization_country);
                } else {
                    $('#lead-organization-filter-country').val(0);
                }

                self.setLeadOrganizationStateOptions();
                if (filtersData.organization_country_state) {
                    $('#lead-organization-filter-country-state').val(filtersData.organization_country_state).trigger("chosen:updated");
                } else {
                    $('#lead-organization-filter-country-state').val(0).trigger("chosen:updated");
                }

                $('#lead-organization-filter-preset-name').val(responseData.filterPresetName);
                $('#lead-organization-preset-id').val(presetId);

                if (filtersData.opportunity_type_id) {
                    $('#lead-filter-by-opportunity-type').val(filtersData.opportunity_type_id);
                } else {
                    $('#lead-filter-by-opportunity-type').val(0);
                }
                if (!_.isUndefined(filtersData.last_updated) && filtersData.last_updated === 'last_updated') {
                    $('#switch-updated-date').prop('checked', true);
                } else {
                    $('#switch-updated-date').prop('checked', false);
                    $('#switch-created-date').prop('checked', true);
                }

                if (!_.isUndefined(filtersData.lead_opportunity_stages) && !_.isEmpty(filtersData.lead_opportunity_stages)) {
                    $('#lead-filter-organization-opportunity-stage').val(filtersData.lead_opportunity_stages).trigger("chosen:updated");
                } else {
                    $('#lead-filter-organization-opportunity-stage').val(0).trigger("chosen:updated");
                }

                if (!_.isUndefined(filtersData.organization_without_leads) && filtersData.organization_without_leads != '0') {
                    $('#lead-organization-without-leads').prop('checked', true);
                } else {
                    $('#lead-organization-without-leads').prop('checked', false);
                }

                if (!_.isUndefined(filtersData.special_filter_type) && filtersData.special_filter_type === 'existing_client') {
                    $('#lead-organization-filter-by-special-type-existing-client').prop('checked', true);
                } else  if (!_.isUndefined(filtersData.special_filter_type) && filtersData.special_filter_type === 'prospect') {
                    $('#lead-organization-filter-by-special-type-prospect').prop('checked', true);
                } else  if (!_.isUndefined(filtersData.special_filter_type) && filtersData.special_filter_type === 'no_email') {
                    $('#lead-organization-filter-by-special-type-no-email').prop('checked', true);
                } else {
                    $('#lead-organization-filter-by-special-type-existing-client').prop('checked', false);
                    $('#lead-organization-filter-by-special-type-prospect').prop('checked', false);
                    $('#lead-organization-filter-by-special-type-no-email').prop('checked', false);
                }

                if(!_.isUndefined(filtersData.last_interaction_id) && !_.isEmpty(filtersData.last_interaction_id)) {
                     $('#lead-organization-filter-by-last-interaction').val(filtersData.last_interaction_id);
                        if(!_.isUndefined(filtersData.lead_last_interaction_name) && !_.isEmpty(filtersData.lead_last_interaction_name) && filtersData.outbound_emails_sub_type != 0) {
                            $('#outbound-emails-sub-types').val(filtersData.outbound_emails_sub_type);
                            $('#email-sub-type-filter').removeClass('close').addClass('open').show();
                        } else {
                            $('#outbound-emails-sub-types').val(0);
                            $('#email-sub-type-filter').removeClass('open').addClass('close').hide();
                        }
                } else {
                    $('#outbound-emails-sub-types').val(0);
                    $('#email-sub-type-filter').removeClass('open').addClass('close').hide();
                }

                if (!_.isUndefined(filtersData.organization_tags) && !_.isEmpty(filtersData.organization_tags)) {
                    $('#organization-filter-tag').val(filtersData.organization_tags).trigger("chosen:updated");
                } else {
                    $('#organization-filter-tag').val(0).trigger("chosen:updated");
                }

                if (!_.isUndefined(filtersData.organization_tags_exclude) && !_.isEmpty(filtersData.organization_tags_exclude)) {
                    $('#organization-filter-tag-exclude').val(filtersData.organization_tags_exclude).trigger("chosen:updated");
                } else {
                    $('#organization-filter-tag-exclude').val(0).trigger("chosen:updated");
                }

                var filterByLastInteractionEl = $('#lead-organization-filter-by-last-interaction').closest('div');

                if(typeof filtersData.outbound_emails_sub_type !== 'undefined' && !_.isEmpty(filtersData.outbound_emails_sub_type)) {
                    $('#outbound-emails-sub-types').val(filtersData.outbound_emails_sub_type);
                }

                if (filterByLastInteractionEl.hasClass('grid_12') && $('#email-sub-type-filter').hasClass('open')) {
                    filterByLastInteractionEl.removeClass('grid_12').addClass('grid_6');
                } else if(filterByLastInteractionEl.hasClass('grid_6') && $('#email-sub-type-filter').hasClass('close')) {
                    filterByLastInteractionEl.removeClass('grid_6').addClass('grid_12');
                }

                if(filtersData.special_filter_type === 'existing_client') {
                    $('#spent-purchase-block').show();

                    if (!_.isUndefined(filtersData.lead_filter_total_spent_purchase_amount_from)) {
                        $('#lead-organization-filter-total-spent-purchase-amount-from').val(filtersData.lead_filter_total_spent_purchase_amount_from);
                    } else {
                        $('#lead-organization-filter-total-spent-purchase-amount-from').val('');
                    }

                    if (!_.isUndefined(filtersData.lead_filter_total_spent_purchase_amount_to)) {
                        $('#lead-organization-filter-total-spent-purchase-amount-to').val(filtersData.lead_filter_total_spent_purchase_amount_to);
                    } else {
                        $('#lead-organization-filter-total-spent-purchase-amount-to').val('');
                    }
                } else {
                    $('#spent-purchase-block').hide();
                }


                if (!_.isUndefined(filtersData.custom_organization_params_search) && !_.isEmpty(filtersData.custom_organization_params_search)) {
                    var yearsList = self.generateCustomParamsYears();

                    _.each(filtersData.custom_organization_params_search, function(param) {
                        var fieldName = param.name,
                            fieldLabel = param.label,
                            fieldType = param.type,
                            paramId = param.id,
                            fieldValue = param.value,
                            fieldKey = fieldType + '-' + fieldName.replace(/\s/g, ''),
                            blockFields = false,
                            customComparisonOperators = [],
                            specialElType = [],
                            flagMultiSelect = false,
                            placeholder = '',
                            operator = param.operator;

                        if(fieldType == 'date') {
                            placeholder = 'YYYY-MM-DD';
                            fieldValue = JSON.parse(fieldValue);
                        }

                        $('#custom-organization-attribute-field-row-block').append(_.template(LeadOrganizationCustomParamFieldRowTmpl, {
                            'fieldKey': fieldKey,
                            'fieldName': fieldName,
                            'fieldLabel': fieldLabel,
                            'fieldType': fieldType,
                            'fieldSubtype': '',
                            'moment': moment,
                            'i18n': i18n,
                            'blockFields': blockFields,
                            'customComparisonOperators': customComparisonOperators,
                            'fieldValue': fieldValue,
                            'specialElType': specialElType,
                            'placeholder': placeholder,
                            'paramId':paramId,
                            'operator': operator,
                            'yearsList':yearsList
                        }));
                    });
                }

                $('#delete-filter-preset').show();


                $('#lead-organization-filter-apply').trigger('click');
            }).fail(function(response) {
                showMessage(response.responseJSON, true, 5000);
            });
        },
        setLeadOrganizationStateOptions : function() {
            let countriesWithStates = JSON.parse($('#countries-with-states').val());
            $('#lead-organization-filter-country-state option').remove();
            if (typeof countriesWithStates[$('#lead-organization-filter-country').val()] !== 'undefined') {
                for (const [key, value] of Object.entries(countriesWithStates[$('#lead-organization-filter-country').val()])) {
                    $('#lead-organization-filter-country-state').append($('<option></option>').val(key).text(value));
                }
                $('#lead-organization-filter-country-state').closest('div').show();
            } else {
                $('#lead-organization-filter-country-state').closest('div').hide();
            }
        },
        generateCustomParamsYears()
        {
            var max = parseInt(new Date().getFullYear()) +10;
            var min = max - 99;
            var years = [];
            for (var i = max; i >= min; i--) {
                years.push(i);
            }
            return years;
        }
    });

    return LeadOrganizationFilterPresetView;
});
