define([
    'backbone',
    'text!../templates/detailed-view.html',
    'text!../../leads/templates/lead-states-list.html',
    './organization-custom-params',
    '../../leads/views/lead-recently-viewed',
    './organization-timeline-log',
    './organization-timeline-upcoming',
    './organization-timeline-today',
    './organization-timeline-filter',
    'i18n!../../../nls/dashboard_'+$('#main-dashboard-system-language').val()+'_ln',
    'moment',
    'accounting',
    './organization-grid',
    './lead-form',
    'text!../templates/organization-contacts.html',
    'text!../../leads/templates/lead-call-transcription-dialog.html',
    'text!../../leads/templates/lead-call-summary-dialog.html',
    'text!../../leads/templates/lead-email-conversation.html',
    '../models/organization',
    'plupload',
    'pluploadhtml5',
    'pluploadflash',
    'pluploadhtml4',
    'c3',
    'd3',
], function(Backbone, DetailedViewTmpl, OrganizationStatesListTmpl, OrganizationCustomParamsView, OrganizationRecentlyViewedView,
            OrganizationTimelineLogView, OrganizationTimelineUpcomingView, OrganizationTimelineTodayView, OrganizationTimelineFilter,
            i18n, moment, accounting, OrganizationGridView, LeadFormView, OrganizationContactTmpl, LeadCallTranscriptionDialogTmpl, LeadCallSummaryDialogTmpl, LeadEmailConversationTmpl, OrganizationModel,
            plupload, pluploadhtml5, pluploadflash, pluploadhtml4, c3, d3
){

    var LeadOrganizationDetailedView = Backbone.View.extend({
        el: $('#lead-organization-block-detailed-view'),
        events: {
            'click #switch-lead-creation': 'toggleLeadCreation',
            'blur .lead-organization-detailed-view-param': 'changeLeadOrganizationAttribute',
            'change .lead-organization-select-detailed-view': 'changeSelectedValueOrganization',
            'change select.organization-country-detailed-view': 'changeOrganizationCountry',
            'click #lead-organization-detailed-view-statistics-tabs-tab li': 'showOrganizationStatisticsTabs',
            'click .lead-log-details-info-email-conversation': 'detailsInfoEmailConversationInfo',
            'click .show-email-conversation-section-content':'showEmailConversationDetails',
            'change .primary-contact-name': 'assignPrimaryContactName',
            'click #lead-organization-grid-back': 'hideLeadOrganizationDetailsScreen',
            'change .lead-organization-countries-codes' : 'changeMobileDesktopMask',
            'click .lead-log-details-info, .lead-call-log-additional-info-link': 'displayGridDetailedInfo',
            'click .lead-log-additional-details-info': 'addAdditionalInfoForMeeting',
            'click #go-to-lead-profile, a[data-role=lead-detailed-view]': 'showLeadDetailsScreen',
            'click #general-organization-notes-switcher': 'displayNotes',
            'blur textarea.add-additional-call-info': 'addAdditionalInfoForCall',
            'click #lead-organization-detailed-view-config-tabs-tab a': 'showOrganizationDetailedTabs',
            'click #view-additional-info-short-link': 'viewAdditionalInfoShortInfo',
            'click #organization-address-info-switch': 'addressInfoEdit',
            'click #organization-address-info-switch-close': 'addressInfoEditClose',
            'click #upload-logo': 'triggerUpload',
            'click .remove-organization-logo': 'removeLogo',
            'change .set-meeting-status':'setMeetingStatus',
            'click .call-transcript-details-link':'switchTranscriptionDetails',
            'click .call-summary-details-link':'switchCallSummaryDetails',
            'click .cron-path':'copyCronPath'
        },
        templates: {
        },
        initialize: function(leadOrganizationModel){
            if (_.isEmpty(leadOrganizationModel)) {
                return false;
            }
            this.leadOrganizationModel = leadOrganizationModel;

            this.timelineLog = new OrganizationTimelineLogView(this.leadOrganizationModel);
            this.timelineToday = new OrganizationTimelineTodayView(this.leadOrganizationModel);
            this.timelineUpcoming =  new OrganizationTimelineUpcomingView(this.leadOrganizationModel);
            this.timelineFilter = new OrganizationTimelineFilter(this.leadOrganizationModel);
        },
        render: function() {
            var self = this;
            self.$el.empty();
            self.leadOrganizationModel.industries = self.alphabeticalSort(self.leadOrganizationModel.get('industries'));
            self.leadOrganizationModel.groups = self.alphabeticalSort(self.leadOrganizationModel.get('groups'));
            self.$el.html( _.template(DetailedViewTmpl, {'leadOrganizationModel': self.leadOrganizationModel, 'moment':moment,  'accounting': accounting, 'i18n': i18n}));
            self.$el.find('#leads-belong-to-organization-block').html( _.template(OrganizationContactTmpl, {'leadOrganizationModel': this.leadOrganizationModel, 'i18n': i18n}));

            flexkit._chooseBoxStyle();//from flexkit theme
            var mobileMasks = this.leadOrganizationModel.get('mobileMasks'),
                desktopMasks = this.leadOrganizationModel.get('desktopMasks'),
                mobileCountryCode = this.leadOrganizationModel.get('organization_mobile_country_code'),
                desktopCountryCode = this.leadOrganizationModel.get('organization_phone_country_code');

            if (typeof mobileMasks[mobileCountryCode] !== 'undefined') {
                $('.organization-mobile-detailed-view').mask(mobileMasks[mobileCountryCode].mask_value, {autoclear: false});
            } else {
                $('.organization-mobile-detailed-view').mask('(999) 999 9999', {autoclear: false});
            }

            if (typeof desktopMasks[desktopCountryCode] !== 'undefined') {
                $('.organization-phone-detailed-view').mask(desktopMasks[desktopCountryCode].mask_value, {autoclear: false});
            } else {
                $('.organization-phone-detailed-view').mask('(999) 999 9999', {autoclear: false});
            }

            $('#lead-organization-detailed-view-statistics-tab-timeline-tab').trigger('click');

            this.LeadForm = new LeadFormView();

            this.assign({
                '#organization-timeline-log' : this.timelineLog,
                '#organization-timeline-today': this.timelineToday,
                '#organization-timeline-upcoming-events' : this.timelineUpcoming,
                '#lead-organization-timeline-filter-block': this.timelineFilter,
                '#lead-form': this.LeadForm
            });

            this.timelineFilter.$el.on('TimelineLog:created', _.bind(this.timelineLog.render, this.timelineLog));
            this.timelineFilter.$el.on('TimelineToday:created', _.bind(this.timelineToday.render, this.timelineToday));
            this.timelineFilter.$el.on('TimelineUpcoming:created', _.bind(this.timelineUpcoming.render, this.timelineUpcoming));

            this.initOrganizationLogoUploader();

            $('.tooltip').tooltip();

            this.createGauge();

            return this;
        },
        triggerUpload: function() {
            $('#organization-uploader-pickfiles').trigger('click');
        },
        removeLogo: function() {
            showConfirm(_.isUndefined(i18n['Are you sure want to delete'])?'Are you sure want to delete':i18n['Are you sure want to delete'], function() {
                var organizationId = window.OrganizationDetailed.leadOrganizationModel.get('id');

                $.ajax({
                    'url': $('#website_url').val()+'plugin/leads/run/removeOrganizationLogo/',
                    'type':'POST',
                    'dataType': 'json',
                    'data': {'organizationId' : organizationId, 'secureToken' : $('#lead-organization-grid-token').val()}
                }).done(function(response){
                    if (response.error == '1') {
                        showMessage(response.responseText, true, 5000);
                    } else {
                        var src = $('#website_url').val() + 'plugins/leads/web/images/upload-image.png';
                        $('#upload-organization-logo').find('img').attr('src', src);

                        $('.upload-image-preview-text').show();
                        $('.orglogo-tooltip').addClass('hide');
                        $('.remove-organization-logo').hide();

                        showMessage(response.responseText, false, 3000);
                    }
                });
            });
        },
        createGauge: function() {
            let score = parseFloat(this.leadOrganizationModel.get('organization_sentiment_score')).toFixed(1);
            let columnName = "";
            let self = this;

            if (isNaN(score) || score < 1) {
                columnName = "N/A";
            }
            else if (score >= 1 && score <= 2) columnName = _.isUndefined(i18n['Very Negative'])?'Very Negative':i18n['Very Negative'];
            else if (score > 2 && score <= 4) columnName = _.isUndefined(i18n['Negative'])?'Negative':i18n['Negative'];
            else if (score > 4 && score <= 6) columnName = _.isUndefined(i18n['Neutral'])?'Neutral':i18n['Neutral'];
            else if (score > 6 && score <= 8) columnName = _.isUndefined(i18n['Positive'])?'Positive':i18n['Positive'];
            else columnName = _.isUndefined(i18n['Very Positive'])?'Very Positive':i18n['Very Positive']

            this.sentimentChart = c3.generate({
                bindto: '#sentiment-ai-chart',
                data: {
                    columns: [
                        [columnName, parseFloat(this.leadOrganizationModel.get('organization_sentiment_score')).toFixed(1)]
                    ],
                    type: "gauge",
                    color: function(color, d) {
                        if (d === (_.isUndefined(i18n['Very Negative'])?'Very Negative':i18n['Very Negative'])) return "#F15C5C";
                        if (d === (_.isUndefined(i18n['Negative'])?'Negative':i18n['Negative'])) return "#F4C94C";
                        if (d === (_.isUndefined(i18n['Neutral'])?'Neutral':i18n['Neutral'])) return "#8CC4F7";
                        if (d === (_.isUndefined(i18n['Positive'])?'Positive':i18n['Positive'])) return "#4A90E2";
                        return "#7ED321";
                    }
                },
                gauge: {
                    min: 1,
                    max: 10,
                    label: {
                        format: function(value) {
                            let desc = "";
                            if (value < 1) {
                                desc = "";
                                return `${desc}`;
                            }
                            else if (value >= 1 && value <= 2) columnName = _.isUndefined(i18n['Very Negative'])?'Very Negative':i18n['Very Negative'];
                            else if (value > 2 && value <= 4) columnName = _.isUndefined(i18n['Negative'])?'Negative':i18n['Negative'];
                            else if (value > 4 && value <= 6) columnName = _.isUndefined(i18n['Neutral'])?'Neutral':i18n['Neutral'];
                            else if (value > 6 && value <= 8) columnName = _.isUndefined(i18n['Positive'])?'Positive':i18n['Positive'];
                            else desc = _.isUndefined(i18n['Very Positive'])?'Very Positive':i18n['Very Positive'];
                            return `${value.toFixed(1)}`;
                        }
                    }
                },
                legend: { show: columnName !== "N/A" }, // hide legend if N/A
                size: { height: 150 },
            });

            // Increase legend font size after render
            d3.selectAll('.c3-legend-item text')
                .style('font-size', '14px');

        },
        copyCronPath: function () {
            var cronPath = this.leadOrganizationModel.get('aiSentimentCronPath');

            if (document.queryCommandSupported("copy")) {
                let copyFromEl = $('<textarea/>');
                copyFromEl.text(cronPath);
                $('body').append(copyFromEl);
                copyFromEl.select();
                document.execCommand('copy', true);
                copyFromEl.remove();
                showMessage(_.isUndefined(i18n['Has been copied to clipboard.'])?'Has been copied to clipboard.':i18n['Has been copied to clipboard.'], false, 2000);
            }

            return true;
        },
        initOrganizationLogoUploader: function() {
            var options = {
                runtimes: 'html5',
                browse_button: 'organization-uploader-pickfiles',
                container: 'organization-logo-uploader',
                max_file_count : 1,
                multi_selection: false,
                max_file_size: '100mb',
                url: $('#website_url').val()+'plugin/leads/run/uploadOrganizationLogo/',
                filters: [
                    {title : "Image files", extensions : "jpeg,jpg,gif,png"}
                ],
                multipart_params: {
                    secureToken: '',
                    folder:'',
                    organizationId:''
                }
            };

            if(_.isUndefined(this.logoUploader)) {
                this.uploaderOrganizationLogoFolder = 'organization-logos';

                this.logoUploader = new plupload.Uploader(options);

                this.logoUploader.init();

                this.logoUploader.bind('BeforeUpload', _.bind(this.beforeUpload, this));
                this.logoUploader.bind('FilesAdded', _.bind(this.filesAdded, this));
                this.logoUploader.bind('UploadProgress', _.bind(this.uploadProgress, this));
                this.logoUploader.bind('FileUploaded', _.bind(this.fileUploaded, this));
                this.logoUploader.bind('Error', _.bind(this.handleUploadErrors, this));
            }
        },
        beforeUpload: function(up, file)
        {

        },
        filesAdded: function(up, files)
        {
            this.logoUploader.settings.multipart_params.secureToken = $('#lead-organization-lead-grid-token').val();
            this.logoUploader.settings.multipart_params.folder = this.uploaderOrganizationLogoFolder;
            this.logoUploader.settings.multipart_params.organizationId = window.OrganizationDetailed.leadOrganizationModel.get('id');
            this.logoUploader.start();
        },
        uploadProgress: function(up, file)
        {

        },
        fileUploaded: function(up, file, info)
        {
            var response = jQuery.parseJSON(info.response),
                websiteUrl = $('#website_url').val(),
                timestamp = new Date().getTime(),
                imageName = response.responseText.fileStoredName,
                src = websiteUrl+'plugins/leads/web/images/'+this.uploaderOrganizationLogoFolder+'/'+imageName+'?'+timestamp,
                self = this;

            $('#upload-organization-logo').find('img').attr('src', src);

            $('.upload-image-preview-text').hide();
            $('.orglogo-tooltip').removeClass('hide');
            $('.remove-organization-logo').show();

            showMessage(_.isUndefined(i18n['Image has been uploaded'])?'Image has been uploaded':i18n['Image has been uploaded'], false, 3000);
        },
        handleUploadErrors: function()
        {
        },
        switchTranscriptionDetails: function (e) {

            var el = $(e.currentTarget),
                self = this,
                callLogId = $(e.currentTarget).data('call-log-id');

            $.ajax({
                url: $('#website_url').val() + 'plugin/leads/run/getLeadCallInfo/callLogId/' + callLogId,
                type: 'GET',
                dataType: 'json'
            }).done(function (response) {
                if (response.error == '0') {
                    var dialog = _.template(LeadCallTranscriptionDialogTmpl, {
                        i18n: i18n,
                        callSid: response.responseText.callSid,
                        callTranscription: response.responseText.callTranscription,
                        callTranscriptionDetails: response.responseText.callTranscriptionDetails,
                    });

                    $(dialog).dialog({
                        dialogClass: 'seotoaster',
                        width: '30%',
                        resizable: false,
                        open: function (event, ui) {
                            var dialogEl = $(this);
                        },
                        close: function (event, ui) {
                            el.prop('checked', false);
                            $(this).dialog('close').remove();
                        }
                    });
                } else {
                    el.prop('checked', false);
                    showMessage(response.responseText, true, 3000);
                }
            });
        },
        switchCallSummaryDetails: function (e) {

            var el = $(e.currentTarget),
                self = this,
                callLogId = $(e.currentTarget).data('call-log-id');

            $.ajax({
                url: $('#website_url').val() + 'plugin/leads/run/getLeadCallInfo/callLogId/' + callLogId,
                type: 'GET',
                dataType: 'json'
            }).done(function (response) {
                if (response.error == '0') {
                    var dialog = _.template(LeadCallSummaryDialogTmpl, {
                        i18n: i18n,
                        callSid: response.responseText.callSid,
                        callSummary: response.responseText.callSummary
                    });

                    $(dialog).dialog({
                        dialogClass: 'seotoaster',
                        width: '30%',
                        resizable: false,
                        open: function (event, ui) {
                            var dialogEl = $(this);
                        },
                        close: function (event, ui) {
                            el.prop('checked', false);
                            $(this).dialog('close').remove();
                        }
                    });
                } else {
                    el.prop('checked', false);
                    showMessage(response.responseText, true, 3000);
                }
            });
        },
        assign: function (selector, view) {
            var selectors;
            if (_.isObject(selector)) {
                selectors = selector;
            }
            else {
                selectors = {};
                selectors[selector] = view;
            }
            if (!selectors) return;
            _.each(selectors, function (view, selector) {
                view.setElement(this.$(selector)).render();
            }, this);
        },
        toggleLeadCreation: function(e){
            e.preventDefault();
            $('#lead-form').slideToggle();
        },
        showLeadDetailsScreen: function(e) {
            e.preventDefault();
            window.location.href = $('#website_url').val()+'dashboard/leads/#lead/'+$(e.currentTarget).data('cid');
        },
        updateOrganizationContactList: function()
        {
            var organizationId = window.OrganizationDetailed.leadOrganizationModel.get('id'),
                organizationModel =  new OrganizationModel(),
                self = this;

            organizationModel.set('id', organizationId);
            organizationModel.fetch({data: { isGrid: true, detailedInfo:true},
                'success': function(OrganizationModel){
                    if(_.isUndefined(OrganizationModel.get('organization_name'))) {
                        window.location.href = window.location.pathname;
                    } else {
                        self.$el.find('#leads-belong-to-organization-block').html( _.template(OrganizationContactTmpl, {'leadOrganizationModel': OrganizationModel, 'i18n': i18n}));
                    }
                }
            });
        },
        assignPrimaryContactName: function(e)
        {
            e.preventDefault();
            var el = $(e.currentTarget),
                isChecked = el.is(':checked'),
                leadId = el.closest('.leads-belong-to-organization-row').data('lead-id');

            if (isChecked) {
                $('.primary-contact-name').prop('checked', false);
                $('.leads-belong-to-organization-row').find('.tooltip').attr('title', '');
                el.closest('.tooltip').attr('title', 'Primary contact');
                el.prop('checked', true);
                this.leadOrganizationModel.set('primary_contact_id', leadId);
                this.leadOrganizationModel.set('secureToken', $('#lead-organization-grid-token').val());
                this.leadOrganizationModel.save(null, {
                    success: function(model, response){
                        //showMessage(response.responseText, false, 5000);
                    },
                    error: function(model, response){
                        showMessage(response.responseJSON, true, 5000);
                    }
                });

            }
        },
        alphabeticalSort: function(obj){
            // convert object into array
            var sortable=[];
            for(var key in obj)
                if(obj.hasOwnProperty(key))
                    sortable.push([key, obj[key]]); // each item is an array in format [key, value]

            // sort items by value
            sortable.sort(function(a, b)
            {
                var x=a[1].toLowerCase(),
                    y=b[1].toLowerCase();
                return x<y ? -1 : x>y ? 1 : 0;
            });
            return sortable; // array in format [ [ key1, val1 ], [ key2, val2 ], ... ]
        },
        setMeetingStatus: function(e)
        {
            e.preventDefault();

            var currentEl = $(e.currentTarget),
                selectedValue = currentEl.val(),
                oldValue = currentEl.data('old-value'),
                meetingLogId = currentEl.data('meeting-log-id'),
                additionalMeetingNotes = currentEl.closest('td').find('.add-additional-meeting-info').data('old-additional-data');

            if (oldValue === selectedValue) {
                return false;
            }

            if (selectedValue === 'completed' && additionalMeetingNotes === '') {
                $(e.currentTarget).val(oldValue);
                showMessage(_.isUndefined(i18n['Add your meeting notes now to save that status'])?'Add your meeting notes now to save that status':i18n['Add your meeting notes now to save that status'], true, 3000);
                return false;
            }

            $.ajax({
                url: $('#website_url').val()+'api/leads/leadmeetinglog/',
                type: 'PUT',
                data: JSON.stringify({'id':meetingLogId, 'type':'changeStatus', 'status':selectedValue, 'secureToken':$('#lead-organization-lead-grid-token').val()}),
                dataType: 'json'
            }).done(function(response) {
                showMessage(response.responseText, false, 5000);
                currentEl.data('old-value', selectedValue);
            }).fail(function(response){
                showMessage(response.responseJSON, true, 5000);
            });
        },
        displayNotes: function(e)
        {
            e.preventDefault();
            if ($('#general-organization-notes').hasClass('hidden')) {
                $('#general-organization-notes').removeClass('hidden');
                $('#general-organization-notes-switcher').text((_.isUndefined(i18n['Hide notes'])?'Hide notes':i18n['Hide notes']));
            } else {
                $('#general-organization-notes').addClass('hidden');
                $('#general-organization-notes-switcher').text((_.isUndefined(i18n['View notes'])?'View notes':i18n['View notes']));
            }
        },
        changeMobileDesktopMask: function(e)
        {
            var selectionType = $(e.currentTarget).data('type'),
                value =  $(e.currentTarget).val();

            var mobileMasks = this.leadOrganizationModel.get('mobileMasks'),
                desktopMasks = this.leadOrganizationModel.get('desktopMasks');

            if (selectionType === 'mobile') {
                if (typeof mobileMasks[value] !== 'undefined') {
                    $('.organization-mobile-detailed-view').mask(mobileMasks[value].mask_value, {autoclear: false});
                } else {
                    $('.organization-mobile-detailed-view').mask('(999) 999 9999', {autoclear: false});
                }
            }

            if (selectionType === 'desktop') {
                if (typeof desktopMasks[value] !== 'undefined') {
                    $('.organization-phone-detailed-view').mask(desktopMasks[value].mask_value, {autoclear: false});
                } else {
                    $('.organization-phone-detailed-view').mask('(999) 999 9999', {autoclear: false});
                }
            }
        },
        detailsInfoEmailConversationInfo: function(e)
        {
            var currentEl = $(e.currentTarget),
                dataBlock = currentEl.closest('tr').find('.lead-log-details-info-block-email-conversation'),
                emailReplyId = currentEl.data('email-reply-id'),
                self = this;

            currentEl.closest('tr').find('.lead-log-details-info-block-email-conversation').empty();

            if(dataBlock.hasClass('hidden')) {
                $.ajax({
                    'url': $('#website_url').val()+'plugin/leads/run/getEmailConversation/',
                    'type':'POST',
                    'dataType': 'json',
                    'data': {'emailReplyId':emailReplyId, 'secureToken': $('#lead-organization-grid-token').val()}
                }).done(function(response){
                    if (response.error == '1') {
                        showMessage(response.responseText, true, 5000);
                    } else {
                        _.each(response.responseText, function(emailInfo) {
                            currentEl.closest('tr').find('.lead-log-details-info-block-email-conversation').append( _.template(LeadEmailConversationTmpl, {'emailInfo': emailInfo, 'i18n':i18n, 'moment': moment, 'userTimezoneOffset': self.leadOrganizationModel.get('userTimezoneOffset')}));
                        });
                        currentEl.closest('tr').find('.lead-log-details-info-block-email-conversation').removeClass('hidden');
                        currentEl.addClass('open');
                        currentEl.removeClass('close');
                    }

                });
            } else {
                currentEl.addClass('closed');
                currentEl.removeClass('open');
            }
            dataBlock.toggleClass('hidden');
        },
        showEmailConversationDetails: function(e)
        {
            var el = $(e.currentTarget),
                emailMessageId = el.data('email-message-id');

            el.closest('td').find('div[data-email-message-id="'+emailMessageId+'"]').toggleClass('hidden');

        },
        changeLeadOrganizationAttribute: function(e)
        {
            var el = $(e.currentTarget),
                attributeName = el.data('lead-attr'),
                oldVal = el.data('lead-old-val'),
                currentVal = el.val();

            if (oldVal == currentVal) {
                return false;
            }

            this.updateLeadOrganizationAttribute(el, attributeName, currentVal);
        },
        changeSelectedValueOrganization: function(e)
        {
            var el = $(e.currentTarget),
                attributeName = el.data('lead-attr'),
                currentVal = el.val();

            this.updateLeadOrganizationAttribute(el, attributeName, currentVal);

        },
        updateLeadOrganizationAttribute: function(el, attributeName, currentVal)
        {
            var self = this;

            if((attributeName == 'organization_country_code') && (currentVal == 'US' || currentVal == 'CA' || currentVal == 'AU')) {
                this.leadOrganizationModel.set('organization_state_code', '');
            }

            this.leadOrganizationModel.set(attributeName, currentVal);
            this.leadOrganizationModel.set('secureToken', $('#lead-organization-grid-token').val());
            this.leadOrganizationModel.save(null,{
                success: function(model, response){
                    if (response.error == '1') {
                        if (typeof response.responseText.duplicatedOrganizationName !== 'undefined') {
                            showConfirm(response.responseText.message+' '+(_.isUndefined(i18n['Would you like to merge both records?']) ? 'Would you like to merge both records?':i18n['Would you like to merge both records?']), function() {
                                var mergeToId = response.responseText.mergeToId;
                                self.leadOrganizationModel.set('mergeRecordWithId', mergeToId);
                                self.leadOrganizationModel.save(null,{
                                    success: function(model, response){
                                        window.location = $('#website_url').val()+'dashboard/organizations/#organization/'+mergeToId
                                    },
                                    error: function(model, response){
                                        self.leadOrganizationModel.set('mergeRecordWithId', '');
                                        self.leadOrganizationModel.set(attributeName, el.data('lead-old-val'));
                                        showMessage(response.responseJSON, true, 5000);
                                        el.val(el.data('lead-old-val'));
                                        return false;
                                    }
                                });
                            }, function(){
                                self.leadOrganizationModel.set(attributeName, el.data('lead-old-val'));
                                el.val(el.data('lead-old-val'));
                            });
                        } else {
                            showMessage(response.responseText.message, true, 5000);
                        }
                    } else {
                        showMessage(response.responseText.message, false, 5000);
                        el.data('lead-old-val', currentVal);
                        if (attributeName === 'organization_website') {
                            if (!_.isEmpty(response.responseText.organizationModel.organizationWebsite)) {
                                $('#organization-website-link').prop('href', response.responseText.organizationModel.organizationWebsite).removeClass('hidden');
                            } else {
                                $('#organization-website-link').addClass('hidden');
                            }
                        }

                        if (attributeName === 'organization_website1') {
                            if (!_.isEmpty(response.responseText.organizationModel.organizationWebsite1)) {
                                $('#organization-website-link1').prop('href', response.responseText.organizationModel.organizationWebsite1).removeClass('hidden');
                            } else {
                                $('#organization-website-link1').addClass('hidden');
                            }
                        }
                    }
                },
                error: function(model, response){
                    showMessage(response.responseJSON, true, 5000);
                }
            });
        },
        showOrganizationStatisticsTabs: function(e)
        {
            var el = $(e.currentTarget),
                tabBlockContentId = el.data('tab-id'),
                tabContentName = el.data('tab-name'),
                tabBlockContentEl = $('#'+tabBlockContentId),
                self = this,
                tabContentBlock = el.closest('#lead-organization-detailed-view-statistics-tabs').find('.lead-organization-detailed-view-statistics-tabs-content'),
                organizationId = $('#lead-organization-detailed-view-statistics-tabs').data('organization-id');

            if (el.hasClass('current')) {
                return false;
            }

            if (tabBlockContentEl.hasClass('hidden')) {
                if (tabContentName === 'custom-params') {
                    if(!_.isUndefined(this.OrganizationCustomParams)) {
                        this.OrganizationCustomParams.$el.unbind();
                    }
                    this.OrganizationCustomParams = new OrganizationCustomParamsView(organizationId, {'grid':true});
                    self.assign({
                        '#lead-organization-detailed-view-statistics-tab-custom-params': this.OrganizationCustomParams
                    });
                    self.hideTab(tabBlockContentEl, el);
                }
            }
            tabContentBlock.addClass('hidden');
            $('#lead-organization-detailed-view-statistics-tabs').find('li').removeClass('current');
            this.hideTab(tabBlockContentEl, el);
        },
        viewAdditionalInfoShortInfo: function (e)
        {
            $('#lead-organization-detailed-view-statistics-tab-custom-params-tab').trigger('click');

            var el = $('#lead-organization-detailed-view-statistics-tabs');

            $('body,html').animate({
                scrollTop: $(el).offset().top
            }, 1000);
        },
        addressInfoEdit: function(e)
        {
            $('#organization-address-info-switch').hide();
            $('#organization-address-info-switch-close').show();
            $('.address-info').show();
        },
        addressInfoEditClose: function()
        {
            $('#organization-address-info-switch').show();
            $('#organization-address-info-switch-close').hide();
            $('.address-info').hide();
        },
        showOrganizationDetailedTabs: function(e)
        {
            var el = $(e.currentTarget),
                displayTab = false,
                tabBlockContentId = el.data('tab-id'),
                tabBlockCustomTabId = el.data('custom-tab-id'),
                tabBlockContentEl = $('#'+tabBlockContentId),
                self = this,
                tabContentBlock = el.closest('#lead-organization-detailed-view-config-tabs').find('.lead-organization-detailed-view-config-tabs-content'),
                liElements = $('#lead-organization-detailed-view-config-tabs-tab').find('li'),
                organizationId = $('#lead-organization-detailed-view-statistics-tabs').data('organization-id');
            if (tabBlockContentEl.hasClass('hidden')) {
                displayTab = true;
            }

            if (el.hasClass('remoteOpen')) {
                el.removeClass('remoteOpen');
                displayTab = true;
            }

            tabContentBlock.addClass('hidden');
            if (displayTab) {
                if (tabBlockContentId === 'lead-organization-detailed-view-custom-fields-tabs') {
                    if(!_.isUndefined(this.OrganizationCustomTabsParams)) {
                        this.OrganizationCustomTabsParams.$el.unbind();
                    }
                    this.OrganizationCustomTabsParams = new OrganizationCustomParamsView(organizationId, {'grid': true, 'customTabId': tabBlockCustomTabId});
                    self.assign({
                        '#lead-organization-detailed-view-custom-fields-tabs': this.OrganizationCustomTabsParams
                    });

                    liElements.removeClass('current');
                    if(el.hasClass('opened')) {
                        //tabBlockContentEl.addClass('hidden');
                        liElements.find('a').removeClass('opened');
                    } else if (tabBlockContentEl.hasClass('hidden')) {
                        self.hideTab(tabBlockContentEl, el);
                        liElements.find('a').removeClass('opened');
                        el.addClass('opened');
                    } else {
                        tabBlockContentEl.removeClass('hidden');
                    }

                    el.addClass('remoteOpen');
                } else {
                    liElements.removeClass('current');
                    this.hideTab(tabBlockContentEl, el);
                }
            } else {
                liElements.removeClass('current');
            }
        },
        hideTab: function (tabBlockContentEl, el){
            tabBlockContentEl.removeClass('hidden');
            el.closest('li').addClass('current');
        },
        changeOrganizationCountry: function (e)
        {

            var el = $(e.currentTarget),
                currentVal = $(e.currentTarget).val(),
                attributeName = el.data('lead-attr');

            if (currentVal) {
                $.ajax({
                    'url': $('#website_url').val()+'plugin/leads/run/getStateByCountryCode/',
                    'type':'POST',
                    'dataType': 'json',
                    'data': {
                        'countryCode': currentVal,
                        'secureToken': $('#lead-organization-grid-token').val()
                    }
                }).done(function(response){
                    if(response.error === 1){
                        $(".organization-state-detailed-view").addClass('hidden');
                        $(".organization-detailed-view-states-list-label").addClass('hidden');
                        el.closest('p').removeClass('grid_6').addClass('grid_12');
                    } else {
                        $('#organization-detailed-view-states-list').empty().html(_.template(OrganizationStatesListTmpl, {'statesList':response.responseText.statesList}));
                        $(".organization-state-detailed-view").removeClass('hidden');
                        $(".organization-detailed-view-states-list-label").removeClass('hidden');
                        el.closest('p').removeClass('grid_12').addClass('grid_6');
                    }
                });
            }
            this.updateLeadOrganizationAttribute(el, attributeName, currentVal);
        },
        hideLeadOrganizationDetailsScreen: function(e)
        {
            var href = $(e.currentTarget).attr('href');
            if (href.match(/http(.*)/)) {
                window.location.href = href;
            } else {
                $('#lead-organization-block-detailed-view').empty();
                $('#lead-organization-table-block').show();
                $('.lead-organization-filters').show();
                $('#lead-organization-grid-back-link').addClass('hidden');
                $('#lead-organization-additional-filters').show();
                this.recentlyViewed = new OrganizationRecentlyViewedView();
                this.recentlyViewed.render();
                $('#recently-viewed-switcher').removeClass('icon-arrow-up2').addClass('icon-arrow-down2');
                $('#lead-organization-filters-switch').removeClass('icon-arrow-up2').addClass('icon-arrow-down2');
                //$('#lead-organizations-recently-viewed-block').removeClass('hidden');
                $('.filter-configuration-elements').removeClass('hidden');
            }

            this.currentStateOrganizationsPaginator();
        },
        currentStateOrganizationsPaginator: function () {
            this.OrganizationGrid = window.appLeadOrganizationRouter.OrganizationGrid;

            var currentPage = $('td.lead-organization-grid-paginator span.page').data('page-orig');

            this.OrganizationGrid.specialPageNavigator(currentPage);
        },
        displayGridDetailedInfo: function(e){
            var currentEl = $(e.currentTarget),
                dataBlock = currentEl.closest('tr').find('.lead-log-details-info-block'),
                conversationLink = currentEl.closest('tr').find('.lead-log-details-info-email-conversation');
            if(dataBlock.hasClass('hidden')) {
                if (conversationLink && conversationLink.hasClass('open')) {
                    conversationLink.trigger('click');
                }
                currentEl.addClass('open');
                currentEl.removeClass('closed');
            } else {
                currentEl.addClass('closed');
                currentEl.removeClass('open');
            }
            dataBlock.toggleClass('hidden');
        },
        addAdditionalInfoForMeeting: function(e)
        {
            $(e.currentTarget).closest('tr').find('.lead-log-additional-info-block').toggleClass('hidden');
        },
        addAdditionalInfoForCall: function(e)
        {
            var el = $(e.currentTarget),
                data = {
                    'secureToken': $('#lead-organization-grid-token').val(),
                    'id': el.data('call-log-id'),
                    'details': el.val()
                },
                type = 'call';

            $.ajax({
                'url': $('#website_url').val()+'api/leads/leadCall/',
                'type':'PUT',
                'dataType': 'json',
                'data': JSON.stringify(data)
            }).done(function(response){
                showMessage(response.responseText, false, 5000);
                if (typeof el.data('attr-type') !== 'undefined') {
                    type = el.data('attr-type');
                }

                if (type == 'sms') {
                    if (data.details.length > 1) {
                        el.closest('td').find('.lead-call-log-additional-info-link').text(_.isUndefined(i18n['View sms']) ? 'View sms' : i18n['View sms']);
                    } else {
                        el.closest('td').find('.lead-call-log-additional-info-link').text(_.isUndefined(i18n['Add sms']) ? 'Add sms' : i18n['Add sms']);
                    }
                } else {
                    if (data.details.length > 1) {
                        el.closest('td').find('.lead-call-log-additional-info-link').text(_.isUndefined(i18n['View call notes']) ? 'View call notes' : i18n['View call notes']);
                    } else {
                        el.closest('td').find('.lead-call-log-additional-info-link').text(_.isUndefined(i18n['Add call details']) ? 'Add call details' : i18n['Add call details']);
                    }
                }
            });
        }
    });

    return LeadOrganizationDetailedView;
});
