define([
    'backbone',
    'text!../templates/lead-task-detailed-tab.html',
    'i18n!../../../nls/dashboard_'+$('#main-dashboard-system-language').val()+'_ln',
    'tinyMCE',
    'leadshortcode',
], function(Backbone, leadTaskTmpl, i18n, tinymce, leadshortcode){
    var LeadTaskFormView = Backbone.View.extend({
        el: $('#lead-detailed-view-config-tab-task'),
        events: {
            'submit form': 'submit',
            'change #lead-task-start-immediate': 'switchImmediate',
            'keyup #lead-task-type-detailed-view': 'checkMandatory',
            'change #lead-task-date-detailed-view': 'checkMandatory',
            'change #lead-task-due-date-detailed-view': 'checkMandatory',
            'change #task-preset':'changeTaskPreset',
            'change #lead-task-start-time':'changeStartTime',
            'change #choose-assign-user':'changeAssignUser'
        },
        templates: {

        },
        initialize: function(leadModel, leadTaskDataModel){
            this.leadModel = leadModel;
            this.leadTaskDataModel = leadTaskDataModel;
        },
        render: function(){
            this.$el.empty();
            tinymce.remove();

            this.leadTaskDataModel.taskPresets = this.alphabeticalSort(this.leadTaskDataModel.get('taskPresets'));
            this.leadTaskDataModel.owners = this.alphabeticalSort(this.leadTaskDataModel.get('owners'));

            this.$el.append(_.template(leadTaskTmpl, {'leadModel': this.leadModel, 'taskPresetsList':this.leadTaskDataModel.taskPresets, 'taskOwners':this.leadTaskDataModel.owners, 'leadTaskDataModel': this.leadTaskDataModel, 'i18n' : i18n}));
            this.$el.find('form').attr('action', $('#website_url').val()+'api/leads/leadtask');
            this.$el.find('#add-lead-task-action').prop('disabled', true);

            var leadTaskStartDateDetailed = $('#lead-task-date-detailed-view'),
                leadTaskEndDateDetailed = $('#lead-task-due-date-detailed-view');

            leadTaskStartDateDetailed.val('yy-mm-dd', $.datepicker.formatDate(new Date()));

            leadTaskStartDateDetailed.datepicker({
                dateFormat: 'd-M-yy',
                defaultDate: "+1w",
                changeMonth: true,
                changeYear: true,
                yearRange: "c-5:c+5",
                minDate: 0,
                onSelect: function(selectedDate) {
                    if (leadTaskEndDateDetailed.val() === '') {
                        leadTaskEndDateDetailed.datepicker("setDate", selectedDate);
                    }
                    if (selectedDate !== '') {
                        leadTaskEndDateDetailed.datepicker("option", "minDate", selectedDate);
                    }

                    var leadTaskStartTime = parseInt($('#lead-task-start-time').val());
                    if (leadTaskStartTime < 23) {
                        $('#lead-task-due-time').val(leadTaskStartTime + 1);
                    } else if (leadTaskStartTime === 23) {
                        $('#lead-task-due-time').val(23);
                    }
                }
            });

            leadTaskStartDateDetailed.datepicker( "setDate", new Date());

            leadTaskEndDateDetailed.datepicker({
                dateFormat: 'd-M-yy',
                defaultDate: "+1w",
                changeMonth: true,
                changeYear: true,
                yearRange: "c-5:c+5",
                minDate: 0,
                onSelect: function(selectedDate) {
                    if (selectedDate !== '') {
                        leadTaskStartDateDetailed.datepicker("option", "maxDate", selectedDate);
                    }
                }
            });

            leadTaskEndDateDetailed.datepicker( "setDate", new Date());

            this.initTiny();
            setTimeout(function () {
                if (!_.isNull(tinymce.activeEditor) && '' === tinymce.activeEditor.getContent()) {
                    tinymce.activeEditor.setContent('Hello! ' +
                        'You have a task for this lead: {$lead:leadfullnamelink} from {$lead:organizationnamelink}.');
                }
            }, 500);
            return this;
        },
        changeAssignUser:function(e)
        {
            var userId = $(e.currentTarget).val(),
                self = this;

            $.ajax({
                url: $('#website_url').val()+'plugin/leads/run/getUserTimezone/',
                type: 'POST',
                data: {'userId':userId},
                dataType: 'json'
            }).done(function(response) {
                if (parseInt(response.error) === 1) {
                    showMessage(response.message, true, 5000);
                }

                self.$el.find('.task-timezone-info').text(response.timezoneAbbreviation);
                self.$el.find('#timezone_abbr').val(response.timezoneAbbreviation);
                self.$el.find('#timezone_full').val(response.timezoneFull);
            }).fail(function(response){
                showMessage(response.responseJSON, true, 5000);
            });

        },
        changeStartTime:function()
        {
            var leadTaskStartTime = parseInt($('#lead-task-start-time').val());
            if (leadTaskStartTime < 23) {
                $('#lead-task-due-time').val(leadTaskStartTime + 1);
            } else if (leadTaskStartTime === 23) {
                $('#lead-task-due-time').val(23);
            }
        },
        alphabeticalSort: function(obj){
            // convert object into array
            var sortable=[];
            for(var key in obj)
                if(obj.hasOwnProperty(key))
                    sortable.push([key, obj[key]]); // each item is an array in format [key, value]

            // sort items by value
            sortable.sort(function(a, b)
            {
                var x=a[1].toLowerCase(),
                    y=b[1].toLowerCase();
                return x<y ? -1 : x>y ? 1 : 0;
            });
            return sortable; // array in format [ [ key1, val1 ], [ key2, val2 ], ... ]
        },
        submit: function(e){
            e.preventDefault();

            var self = this,
                form = $(e.currentTarget),
                isValid = true,
                startTime = $('#lead-task-start-time').val(),
                dueTime = $('#lead-task-due-time').val(),
                startTimeMinutes = $('#lead-task-start-time-minutes').val(),
                endTimeMinutes = $('#lead-task-end-time-minutes').val();

            _.each(form.find('.required'), function(el){
                if (!$(el).val()){
                    isValid = false;
                }
            });

            if (!isValid){
                showMessage(_.isUndefined(i18n['Missing required field'])?'Missing required field':i18n['Missing required field'], true);
                return false;
            }


            form.find('input[name=expired_at]').val(($('#lead-task-date-detailed-view').val()) ? $.datepicker.formatDate('yy-mm-dd', $('#lead-task-date-detailed-view').datepicker("getDate"))+' '+startTime+':'+startTimeMinutes+':00': '');

            form.find('input[name=due_date]').val(($('#lead-task-due-date-detailed-view').val()) ? $.datepicker.formatDate('yy-mm-dd', $('#lead-task-due-date-detailed-view').datepicker("getDate"))+' '+dueTime+':'+endTimeMinutes+':00': '');

            var immediate = 0,
                immediateEmail = 0;

            if ($('#lead-task-start-immediate').is(':checked')) {
                immediate = 1;
            }

            if ($('#lead-task-immediate-notification').is(':checked')) {
                immediateEmail = 1;
            }

            var formParams = form.serialize()+'&secureToken='+$('#lead-grid-token').val()+'&immediate='+immediate+'&immediateEmail='+immediateEmail;


            $.ajax({
                url: form.attr('action'),
                type: 'POST',
                data: formParams,
                dataType: 'json'
            }).done(function(response) {
                showMessage(response.responseText, false, 5000);
                self.render();
            }).fail(function(response){
                showMessage(response.responseJSON, true, 5000);
            });
            return false;

        },
        changeTaskPreset: function(e) {
            var taskPresets = this.leadTaskDataModel.get('taskPresetsFull'),
                chosenPresetId = $(e.currentTarget).val();

            if (taskPresets.hasOwnProperty(chosenPresetId) === true) {
                $('#lead-task-type-detailed-view').val(taskPresets[chosenPresetId]['task_title']);
                this.checkMandatory();
            } else {
                $('#lead-task-type-detailed-view').val('');
            }
        },
        switchImmediate: function(e)
        {
            var self = this;

            if ($(e.currentTarget).is(':checked')) {
                $('#lead-task-date-detailed-view').prop('disabled', true);
                $('#lead-task-start-time').prop('disabled', true);
                $('#lead-task-immediate-notification-block').addClass('hidden');
                $('#lead-task-start-time-minutes').prop('disabled', true);
                $.ajax({
                    url: $('#website_url').val()+'plugin/leads/run/getCurrentDate/',
                    type: 'POST',
                    data: {},
                    dataType: 'json'
                }).done(function(response) {
                    if ($('#lead-task-date-detailed-view').val() == '') {
                        $('#lead-task-date-detailed-view').val(response.responseText.currentDate);
                    }

                    if ($('#lead-task-due-date-detailed-view').val() == '') {
                        $('#lead-task-due-date-detailed-view').val(response.responseText.currentDate);
                    }

                    $('#lead-task-due-time').val(response.responseText.dateDue);

                    self.checkMandatory();
                }).fail(function(response){
                    showMessage(response.responseJSON, true, 5000);
                });

            } else {
                $('#lead-task-date-detailed-view').prop('disabled', false);
                $('#lead-task-start-time').prop('disabled', false);
                $('#lead-task-immediate-notification-block').removeClass('hidden');
                $('#lead-task-start-time-minutes').prop('disabled', false);
            }
            this.checkMandatory();
        },
        checkMandatory: function () {

            var elementStatus = true;

            if (($('#lead-task-type-detailed-view').val().trim() != '' && $('#lead-task-date-detailed-view').val() != '') || ($('#lead-task-type-detailed-view').val().trim() != '' && $('#lead-task-start-immediate').is(':checked'))) {
                elementStatus = false;
            }

            if (!$('#lead-task-start-immediate').is(':checked') && $('#lead-task-due-date-detailed-view').val() == '') {
                elementStatus = true;
            }

            if ($('#lead-task-start-immediate').is(':checked') && $('#lead-task-due-date-detailed-view').val() == '') {
                elementStatus = true;
            }

            $('#add-lead-task-action').prop('disabled', elementStatus);

        },
        initTiny: function (){
            var websiteUrl = $('#website_url').val(), self = this;
            tinymce.init({
                script_url              : websiteUrl+'system/js/external/tinymce/tinymce.gzip.php',
                selector                : "#task_notes",
                skin                    : 'seotoaster',
                menubar                 : false,
                browser_spellcheck      : true,
                resize                  : false,
                convert_urls            : false,
                relative_urls           : false,
                statusbar               : false,
                allow_script_urls       : false,
                force_p_newlines        : false,
                forced_root_block       : false,
                entity_encoding         : "raw",
                plugins                 :  ["leadshortcode fullscreen code link"],
                toolbar1                : "leadshortcode | fullscreen | code | link unlink ",
                image_advtab            : false,
                extended_valid_elements : false,
                setup                   : function(ed){
                    var keyTime = null;
                    ed.on('change blur keyup', function(ed, e){
                        self.dispatchEditorKeyup(ed, e, keyTime);
                        this.save();
                    });
                }
            });
            $('#task_notes').html('<span></span>').trigger('keyup');
            this.tinimce = tinymce;
        },
        dispatchEditorKeyup: function(editor, event, keyTime) {
            var keyTimer = keyTime;
            if(keyTimer === null) {
                keyTimer = setTimeout(function() {
                    keyTimer = null;
                }, 1000)
            }
        }
    });

    return LeadTaskFormView;
});
