define([
    'backbone',
    './lead-grid',
    'moment',
    'text!../templates/filter-custom-params-field-row.html',
    'text!../templates/filter-lead-organization-custom-params-field-row.html',
    'i18n!../../../nls/dashboard_'+$('#main-dashboard-system-language').val()+'_ln'
], function(Backbone, LeadGridView, moment, LeadCustomParamFieldRowTmpl, LeadOrganizationCustomParamFieldRowTmpl, i18n
){

    var LeadsGridView = Backbone.View.extend({
        el: $('#lead-block'),
        events: {
            'click #switch-lead-creation': 'toggleLeadCreation',
            'click #lead-filters-switch': 'toggleLeadAdditionalFilters',
            'click #lead-filter-apply': 'applyFilter',
            'click #lead-filter-reset': 'resetFilter',
            'click #lead-filter-reset-top': 'resetFilter',
            'click #recently-viewed-switcher': 'showHideRecentlyViewed',
            'click #go-to-lead-profile, a[data-role=lead-detailed-view]': 'showLeadDetailsScreen',
            'submit #filters-form':'applyFilter',
            'click #lead-filter-by-special-type, #lead-filter-by-special-type':'changeFilterSpecialType',
            'change select.lead-filter-by-source-type': 'callDurationFilter',
            'change .rangeActivityOptions': 'changePeriod',
            'change .rangeCreationOptions': 'changePeriod',
            'click input[name=searchByKeyword]' : 'searchByKeyword',
            'change #search-includes-notes' : 'focusLeadFilterBy',
            'change #search-includes-custom-lead-fields' : 'focusLeadFilterBy',
            'click #lead-filter-by-special-type-existing-client, #lead-filter-by-special-type-prospect' : 'displaySpentPurchase',
            'change #lead_phone_country_code': 'changePhoneMask',
            'change select.lead-filter-by-last-interaction': 'lastInteractionInboundEmailFilter',
            'change #custom-attribute-selection': 'selectCustomAttribute',
            'change #organization-custom-attribute-selection': 'selectOrganizationCustomAttribute',
            'click #add-custom-attribute': 'addField',
            'click #add-organization-custom-attribute': 'addOrganizationCustomField',
            'click .custom-field-row-delete': 'deleteCustomFieldSearchRow',
            'change .field-operator-value' : 'changeRuleOperator',
            'change #lead-filter-by-interaction': 'applyFilter',
            'change #lead-filter-by-email-sms-sequence':'changeSequenceFilter',
            'change #lead-filter-by-email-sequence-type': 'changeSequenceTypeFilter',
            'change select.lead-filter-by-email-validation': 'emailValidationFilter',
            'click .clear-input': 'clearInput',
            'change .change-operator-for-custom-search':'changeOperatorLeadCustomParam',
            'change .switch-last-next-activity-date':'switchActivityFilter',
            'change select.lead-filter-by-source-type-and-utm': 'leadFilterBySourceTypeAndUtm',

        },
        templates: {},
        initialize: function(options){

        },
        render: function(){

        },
        changeRuleOperator: function(e) {
            var el = $(e.currentTarget),
                ruleOperator = el.val(),
                valueEl = el.closest('div').find('.field-operator-value'),
                infoTooltip = window.appLeadRouter.leadTooltipInfo(ruleOperator);

            el.prop('title', infoTooltip);
        },
        switchActivityFilter: function(e)
        {
            if ($(e.currentTarget).val() === 'next-activity-date') {
                $('.last-activity-option').addClass('hidden');
                $('.next-activity-option').removeClass('hidden');
            } else {
                $('.last-activity-option').removeClass('hidden');
                $('.next-activity-option').addClass('hidden');
            }

            $('#range-activity-option').val(0);
            $('#lead-filter-activity-date').val('');
            $('#lead-filter-activity-to-date').val('');
        },
        showHideRecentlyViewed: function()
        {
            if ($('#lead-organizations-recently-viewed-block').hasClass('hidden')) {
                $('#lead-organizations-recently-viewed-block').removeClass('hidden');
                $('#lead-additional-filters').addClass('hidden');
            } else {
                $('#lead-organizations-recently-viewed-block').addClass('hidden');
            }

            $('#lead-filters-switch').removeClass('icon-arrow-up2').addClass('icon-arrow-down2');

            if ($('#recently-viewed-switcher').hasClass('icon-arrow-down2')) {
                $('#recently-viewed-switcher').removeClass('icon-arrow-down2').addClass('icon-arrow-up2');
            } else {
                $('#recently-viewed-switcher').removeClass('icon-arrow-up2').addClass('icon-arrow-down2');
            }


        },
        changeSequenceFilter: function()
        {
            if (!_.isNull($('#lead-filter-by-email-sms-sequence').val()) && $('#lead-filter-by-email-sms-sequence').val().length > 0) {
                $('#email-sequence-sub-filter-block').removeClass('hidden');
                $('#email-sequence-sub-filter-block-second-part').removeClass('hidden');
            } else {
                $('#email-sequence-sub-filter-block').addClass('hidden');
                $('#email-sequence-sub-filter-block-second-part').addClass('hidden');
            }

            if ($('#lead-filter-by-email-sequence-type').val() === 'all') {
                $('#lead-filter-by-email-sequence-type-action').attr('disabled', 'true');
                $('#lead-filter-by-email-sequence-type-period').attr('disabled', 'true');
            } else {
                $('#lead-filter-by-email-sequence-type-action').removeAttr('disabled');
                $('#lead-filter-by-email-sequence-type-period').removeAttr('disabled');
            }
        },
        changeSequenceTypeFilter: function ()
        {
            if ($('#lead-filter-by-email-sequence-type').val() === 'all') {
                $('#lead-filter-by-email-sequence-type-action').attr('disabled', 'true');
                $('#lead-filter-by-email-sequence-type-action').val('all');
                $('#lead-filter-by-email-sequence-type-period').attr('disabled', 'true');
            } else {
                $('#lead-filter-by-email-sequence-type-action').removeAttr('disabled');
                $('#lead-filter-by-email-sequence-type-period').removeAttr('disabled');
                if ($('#lead-filter-by-email-sequence-type').val() === 'sms') {
                    var leadFilterByEmailSequenceTypeAction = $('#lead-filter-by-email-sequence-type-action').val();
                    if (leadFilterByEmailSequenceTypeAction !== 'all' && leadFilterByEmailSequenceTypeAction !== 'sent') {
                        $('#lead-filter-by-email-sequence-type-action').val('sent');
                    }
                    $("#lead-filter-by-email-sequence-type-action option[value*='open']").prop('disabled', true);
                    $("#lead-filter-by-email-sequence-type-action option[value*='click']").prop('disabled', true);
                } else {
                    $("#lead-filter-by-email-sequence-type-action option[value*='open']").prop('disabled', false);
                    $("#lead-filter-by-email-sequence-type-action option[value*='click']").prop('disabled', false);
                }
            }


        },
        changeOperatorLeadCustomParam: function(e) {
            var el = $(e.currentTarget),
                textInput = el.closest('div').find('.custom-field-row-value');

            if (el.val() === 'in') {
                textInput.prop('placeholder', _.isUndefined(i18n['separate the values with commas']) ? 'separate the values with commas' : i18n['separate the values with commas']);
            } else if(el.closest('div').data('field-type') === 'date' && el.val() !== 'like') {
                textInput.prop('placeholder', 'YYYY-MM-DD');
            }
            else {
                textInput.prop('placeholder', '');
            }
        },
        callDurationFilter: function(e){
            e.preventDefault();

            var el = $(e.currentTarget),
                filterBysourceTypeEl = $('#lead-filter-by-source-type').closest('div'),
                selectedCallType = '';

            if(!_.isUndefined(el)) {
                selectedCallType = el.find(':selected').data('type-name');
            }

            if(selectedCallType == 'inbound_call' || selectedCallType == 'outbound_call') {
                if(filterBysourceTypeEl.hasClass('grid_12')) {
                    filterBysourceTypeEl.removeClass('grid_12').addClass('grid_5');
                }
                $('#call-duration-filter').removeClass('close').addClass('open').show();
            } else {
                if(filterBysourceTypeEl.hasClass('grid_5')) {
                    filterBysourceTypeEl.removeClass('grid_5').addClass('grid_12');
                }
                $('#call-duration-filter').removeClass('open').addClass('close').hide();
            }
        },
        leadFilterBySourceTypeAndUtm: function(e){
            e.preventDefault();

            var el = $(e.currentTarget),
                sourceUtmValueFilterEl = $('#lead-filter-by-source-utm-value').closest('div'),
                campaignUtmValueFilterEl = $('#lead-filter-by-campaign-utm-value').closest('div'),
                selectedSourceTypes = '';

            if(!_.isUndefined(el)) {
                selectedSourceTypes = el.val();
            }

            if(selectedSourceTypes.length) {
                if(selectedSourceTypes.includes('3')) {
                    sourceUtmValueFilterEl.removeClass('close').addClass('open').show();
                } else {
                    sourceUtmValueFilterEl.removeClass('open').addClass('close').hide();
                    $('#lead-filter-by-source-utm-value').val('0').trigger('chosen:updated');
                }

                if(selectedSourceTypes.includes('5')) {
                    campaignUtmValueFilterEl.removeClass('close').addClass('open').show();
                } else {
                    campaignUtmValueFilterEl.removeClass('open').addClass('close').hide();
                    $('#lead-filter-by-campaign-utm-value').val('0').trigger('chosen:updated');
                }
            } else {
                sourceUtmValueFilterEl.removeClass('open').addClass('close').hide();
                $('#lead-filter-by-source-utm-value').val('0').trigger('chosen:updated');

                campaignUtmValueFilterEl.removeClass('open').addClass('close').hide();
                $('#lead-filter-by-campaign-utm-value').val('0').trigger('chosen:updated');
            }

        },
        lastInteractionInboundEmailFilter: function(e) {
            e.preventDefault();

            var el = $(e.currentTarget),
                filterByLastInteractionEl = $('#lead-filter-by-last-interaction').closest('div'),
                lastInteractionType = '';

            if(!_.isUndefined(el)) {
                lastInteractionType = el.find(':selected').data('type-name');
            }

            if(lastInteractionType == 'outbound_email') {
                if(filterByLastInteractionEl.hasClass('grid_12')) {
                    filterByLastInteractionEl.removeClass('grid_12').addClass('grid_6');
                }
                $('#email-sub-type-filter').removeClass('close').addClass('open').show();
            } else {
                if(filterByLastInteractionEl.hasClass('grid_6')) {
                    filterByLastInteractionEl.removeClass('grid_6').addClass('grid_12');
                }
                $('#email-sub-type-filter').removeClass('open').addClass('close').hide();
                $('#outbound-emails-sub-types').val(0);
            }
        },
        searchByKeyword: function(e) {
            if(typeof e !== 'undefined'){
                if(!$(e.currentTarget).hasClass('active') && $('#lead-attribute').val() != '') {
                    $('input[name=searchByKeyword]').removeClass('active');
                    $(e.currentTarget).addClass('active');
                    this.applyFilter();
                }
            }

            var searchByKeywordValue = $('input[name=searchByKeyword]:checked').val(),
                searchIncludesNotes = $('#search-includes-notes'),
                searchIncludesCustomLeadFields = $('#search-includes-custom-lead-fields'),
                customFieldNameLead = _.isUndefined(i18n['Include custom lead fields']) ? 'Include custom lead fields' : i18n['Include custom lead fields'],
                customFieldNameOrganization = _.isUndefined(i18n['Include custom organization fields']) ? 'Include custom organization fields' : i18n['Include custom organization fields'];

            if(searchByKeywordValue == 'organization') {
                $('.custom-fields-name').text(customFieldNameOrganization);
            }

            if(searchByKeywordValue == 'attributes') {
                $('.custom-fields-name').text(customFieldNameLead);
            }

            if(searchIncludesNotes.is(':checked')){
                searchIncludesNotes.val(1);
            } else {
                searchIncludesNotes.val(0);
            }
            if(searchIncludesCustomLeadFields.is(':checked')){
                searchIncludesCustomLeadFields.val(1);
            } else {
                searchIncludesCustomLeadFields.val(0);
            }
        },
        focusLeadFilterBy: function() {
            $('#lead-attribute').focus();
        },
        changePeriod: function(e){
            var el = $(e.currentTarget),
                elDataParam = el.data('type'),
                currentBlock = el.closest('.'+ elDataParam +'-option-date');

            this.setDateRange(el.val(), currentBlock, elDataParam);
        },
        setDateRange: function(switchValue, currentBlock, elDataParam) {
            var startDate = $('[name="leadFilter'+ elDataParam +'Date"]', currentBlock),
                endDate = $('[name="LeadFilter'+ elDataParam +'ToDate"]', currentBlock),
                date = moment($('#user-time').val());

            switch (switchValue) {
                case "1"://Today
                    startDate.datepicker('setDate', date.startOf('day').toDate());
                    endDate.datepicker('setDate', date.endOf('day').toDate());
                    break;
                case "2"://Yesterday
                    startDate.datepicker('setDate', date.subtract(1, 'days').startOf('day').toDate());
                    endDate.datepicker('setDate', date.endOf('day').toDate());
                    break;
                case "3"://Last week
                    startDate.datepicker('setDate', date.subtract(7, 'days').startOf('week').toDate());
                    endDate.datepicker('setDate', date.endOf('week').toDate());
                    break;
                case "4"://Last month
                    startDate.datepicker('setDate', date.endOf('month').subtract(date.daysInMonth() + 1, 'days').startOf('month').toDate());
                    endDate.datepicker('setDate', date.endOf('month').toDate());
                    break;
                case "5"://Last 7 days
                    endDate.datepicker('setDate', date.subtract(0, 'days').endOf('day').toDate());
                    startDate.datepicker('setDate', date.subtract(7, 'days').startOf('day').toDate());
                    break;
                case "6"://Last 30 days
                    endDate.datepicker('setDate', date.subtract(0, 'days').endOf('day').toDate());
                    startDate.datepicker('setDate', date.subtract(30, 'days').startOf('day').toDate());
                    break;
                case "7"://Tomorrow
                    startDate.datepicker('setDate', date.add(1, 'days').startOf('day').toDate());
                    endDate.datepicker('setDate', date.endOf('day').toDate());
                    break;
                case "8"://Next week
                    startDate.datepicker('setDate', date.add(7, 'days').startOf('week').toDate());
                    endDate.datepicker('setDate', date.endOf('week').toDate());
                    break;
                case "9"://Next month
                    startDate.datepicker('setDate', date.startOf('month').add(date.daysInMonth() + 1, 'days').startOf('month').toDate());
                    endDate.datepicker('setDate', date.endOf('month').toDate());
                    break;
                case "10"://Next 7 days
                    startDate.datepicker('setDate', date.add(0, 'days').startOf('day').toDate());
                    endDate.datepicker('setDate', date.add(7, 'days').endOf('day').toDate());
                    break;
                case "11"://Next 30 days
                    startDate.datepicker('setDate', date.add(0, 'days').startOf('day').toDate());
                    endDate.datepicker('setDate', date.add(30, 'days').endOf('day').toDate());
                    break;
                default:
                    startDate.datepicker('setDate', null);
                    endDate.datepicker('setDate', null);
                    break;
            }
        },
        toggleLeadCreation: function(e){
            e.preventDefault();
            $('#lead-form').slideToggle();
            if ($('#switch-lead-creation').hasClass('icon-arrow-down2')) {
                $('#switch-lead-creation').removeClass('icon-arrow-down2').addClass('icon-arrow-up2');
            } else {
                $('#switch-lead-creation').removeClass('icon-arrow-up2').addClass('icon-arrow-down2');
            }
        },
        changePhoneMask: function(){
            this.LeadGrid = window.appLeadRouter.LeadGrid;

            var desktopMasks = this.LeadGrid.leads.desktopMasks,
                desktopCountryCode = $('#lead-form').find('#lead_phone_country_code').val();

            if (typeof desktopCountryCode !== 'undefined') {
                $('#lead-form').find('#lead-phone').mask(desktopMasks[desktopCountryCode].mask_value, {autoclear: false});
            } else {
                $('#lead-form').find('#lead-phone').mask('(999) 999 9999', {autoclear: false});
            }
        },
        toggleLeadAdditionalFilters: function(){
            $("#lead-additional-filters").toggleClass('hidden');
            this.setDateRange($('.rangeActivityOptions').val(), $('.activity-option-date'));
            this.setDateRange($('.rangeCreationOptions').val(), $('.creation-option-date'));
            $('#lead-organizations-recently-viewed-block').addClass('hidden');
            if ($('#lead-filters-switch').hasClass('icon-arrow-down2')) {
                $('#lead-filters-switch').removeClass('icon-arrow-down2').addClass('icon-arrow-up2');
            } else {
                $('#lead-filters-switch').removeClass('icon-arrow-up2').addClass('icon-arrow-down2');
            }

            $('#recently-viewed-switcher').removeClass('icon-arrow-up2').addClass('icon-arrow-down2');

        },
        clearInput: function () {
            $('#filters-form').find('input#lead-attribute').val('').trigger('submit');
        },
        applyFilter: function(e) {
            if(typeof e !== 'undefined'){
                e.preventDefault();
            }

            if(!$('#lead-filter-by-special-type-existing-client').prop('checked')) {
                $('#lead-filter-total-spent-purchase-amount-from').val('');
                $('#lead-filter-total-spent-purchase-amount-to').val('');
            }

            $('#lead-filter-apply').prop('disabled', true);
            $('#lead-attribute').prop('disabled', true);
            this.showLoader();

            this.searchByKeyword();

            this.LeadGrid = window.appLeadRouter.LeadGrid;
            //this.LeadGrid = new LeadGridView();
            this.LeadGrid.leadsChecked = [];
            this.LeadGrid.leads.currentPage = 0;
            this.LeadGrid.leads.perPage = 10;
            this.LeadGrid.render({'resetCheckedLeads':'1'});
        },
        showLoader: function () {
            this.$el.find('#lead-grid-table-body').html('<tr><td class="text-center" colspan="15" style="text-align: center;"><img src="' + $('#website_url').val() + 'system/images/spinner-small.gif" border="0" alt="loading..." /></td></tr>');
        },
        changeFilterSpecialType: function(e)
        {
            var el = $(e.currentTarget),
                currentStatus = el.data('checked');

            $('.leadFilterBySpecialType').prop('checked', false).data('checked', false);
            if (currentStatus === true) {
                el.prop('checked', false);
                el.data('checked', false);
            } else {
                el.prop('checked', true);
                el.data('checked', true);
            }
        },
        resetFilter: function(e){
            e.preventDefault();
            var $el = $('#lead-additional-filters');
            $el.find('input:text').val('');
            $el.find('select.filter').val('0').trigger('chosen:updated');
            $('#lead-filter-by-interaction').val('created_at');
            $('#lead-filter-by-special-type-existing-client').prop('checked', false);
            $('#lead-filter-by-special-type-prospect').prop('checked', false);
            $('#lead-filter-by-special-type-no-email').prop('checked', false);
            $('#switch-created-date').prop('checked', true);
            $('#switch-updated-date').prop('checked', false);
            $('#switch-expected-date').prop('checked', true);
            $('#switch-creation-date').prop('checked', false);
            $('#switch-stage-change-date').prop('checked', false);
            $('#lead-attribute').val('');
            $('#search-includes-notes').prop('checked', false);
            $('#search-includes-custom-lead-fields').prop('checked', false);
            $('#lead-search-by-keyword1').prop('checked', true);
            $('#lead-search-by-keyword2').prop('checked', false);
            $('#call-duration-filter').removeClass('open').hide();
            $('#lead-filter-by-source-type').closest('div').removeClass('grid_5').addClass('grid_12');
            $('#lead-filter-by-last-interaction').closest('div').removeClass('grid_6').addClass('grid_12');
            $('#inbound-emails-sub-types').val(0);
            $('#email-sub-type-filter').removeClass('open').hide();
            $('#range-activity-option').val(0);
            $('#range-creation-option').val(0);
            $('#spent-purchase-block').hide();
            $('#custom-attribute-field-row-block').empty();
            $('#custom-attribute-selection').val(0);
            $('#custom-organization-attribute-field-row-block').empty();
            $('#organization-custom-attribute-selection').val(0);
            $('#lead-filter-title-operator').val('equal');
            $('#lead-filter-nps-score').val('');
            $('#lead-filter-by-email-validation').val(0).removeClass('grid_5').addClass('grid_12').removeClass('field-rule-row-first');
            $('#lead-filter-nps-score-operator').val('equal');
            $('#lead-filter-by-email-sequence-type').val('all');
            $('#lead-filter-by-email-sequence-type-action').val('all');
            $('#lead-filter-country-state').closest('div').hide();
            $('#email-sequence-sub-filter-block').addClass('hidden');
            $('#email-sequence-sub-filter-block-second-part').addClass('hidden');
            $('#lead-filter-by-email-validation-date-block').removeClass('open').addClass('close').addClass('hidden');
            $('#lead-predefined-filter-list').val(0);
            $('#delete-filter-preset').hide();
            $('#lead-filter-preset-default').prop('checked', false);
            $('.clear-input').addClass('hidden');
            this.applyFilter();
        },
        displaySpentPurchase: function (e) {
            if($('#lead-filter-by-special-type-existing-client').prop('checked')) {
                $('#spent-purchase-block').show();
            } else {
                $('#spent-purchase-block').hide();
            }
        },
        showLeadDetailsScreen: function(e)
        {
            var leadId = $(e.currentTarget).data('cid');
            if (!leadId) {
                return false;
            }
            window.appLeadRouter.leadDetails(leadId);
        },
        deleteCustomFieldSearchRow(e)
        {
            $(e.currentTarget).closest('.form-field-row-block').remove();
        },
        selectCustomAttribute: function(e)
        {
            if ($(e.currentTarget).val() != '0') {
                $('#add-custom-attribute').removeClass('hidden');
            } else {
                $('#add-custom-attribute').addClass('hidden');
            }
        },
        selectOrganizationCustomAttribute: function(e)
        {
            if ($(e.currentTarget).val() != '0') {
                $('#add-organization-custom-attribute').removeClass('hidden');
            } else {
                $('#add-organization-custom-attribute').addClass('hidden');
            }
        },
        addOrganizationCustomField: function()
        {
            var fieldName = $('#organization-custom-attribute-selection').val(),
                fieldLabel = $('#organization-custom-attribute-selection').find(':selected').data('field-label'),
                fieldType = $('#organization-custom-attribute-selection').find(':selected').data('field-type'),
                paramId = $('#organization-custom-attribute-selection').find(':selected').data('field-id'),
                fieldKey = fieldType + '-' + fieldName.replace(/\s/g, ''),
                blockFields = false,
                customComparisonOperators = [],
                specialElType = [],
                flagMultiSelect = false,
                placeholder = '',
                yearsList = this.generateCustomParamsYears();

            if(fieldType == 'date') {
                placeholder = 'YYYY-MM-DD';
            }

            if ($('#custom-organization-attribute-field-row-block' + '-' + fieldKey).length == '0') {
                $('#custom-organization-attribute-field-row-block').append(_.template(LeadOrganizationCustomParamFieldRowTmpl, {
                    'fieldKey': fieldKey,
                    'fieldName': fieldName,
                    'fieldLabel': fieldLabel,
                    'fieldType': fieldType,
                    'fieldSubtype': '',
                    'moment': moment,
                    'i18n': i18n,
                    'blockFields': blockFields,
                    'customComparisonOperators': customComparisonOperators,
                    'fieldValue': '',
                    'specialElType': specialElType,
                    'placeholder': placeholder,
                    'paramId':paramId,
                    'yearsList':yearsList
                }));

                if (flagMultiSelect === true) {
                    $('#custom-organization-attribute-field-row-block-' + fieldKey).find('.custom-field-row-value').chosen();
                }
            } else {
                showMessage(_.isUndefined(i18n['Field already exists']) ? 'Field already exists' : i18n['Field already exists'], true, 5000);
            }
        },
        addField: function () {
            var fieldName = $('#custom-attribute-selection').val(),
                fieldLabel = $('#custom-attribute-selection').find(':selected').data('field-label'),
                fieldType = $('#custom-attribute-selection').find(':selected').data('field-type'),
                paramId = $('#custom-attribute-selection').find(':selected').data('field-id'),
                fieldKey = fieldType + '-' + fieldName.replace(/\s/g, ''),
                blockFields = false,
                customComparisonOperators = [],
                specialElType = [],
                flagMultiSelect = false,
                placeholder = '',
                yearsList = this.generateCustomParamsYears();

            if(fieldType == 'date') {
                placeholder = 'YYYY-MM-DD';
            }

            if ($('#custom-attribute-field-row-block' + '-' + fieldKey).length == '0') {
                $('#custom-attribute-field-row-block').append(_.template(LeadCustomParamFieldRowTmpl, {
                    'fieldKey': fieldKey,
                    'fieldName': fieldName,
                    'fieldLabel': fieldLabel,
                    'fieldType': fieldType,
                    'fieldSubtype': '',
                    'moment': moment,
                    'i18n': i18n,
                    'blockFields': blockFields,
                    'customComparisonOperators': customComparisonOperators,
                    'fieldValue': '',
                    'specialElType': specialElType,
                    'placeholder': placeholder,
                    'paramId':paramId,
                    'yearsList':yearsList
                }));

                if (flagMultiSelect === true) {
                    $('#custom-attribute-field-row-block-' + fieldKey).find('.custom-field-row-value').chosen();
                }
            } else {
                showMessage(_.isUndefined(i18n['Field already exists']) ? 'Field already exists' : i18n['Field already exists'], true, 5000);
            }
        },
        generateCustomParamsYears()
        {
            var max = parseInt(new Date().getFullYear()) +10;
            var min = max - 99;
            var years = [];

            for (var i = max; i >= min; i--) {
                years.push(i);
            }

            return years;
        },
        emailValidationFilter: function(e){
            e.preventDefault();

            var el = $(e.currentTarget),
                filterByEmailValidationEl = $('#lead-filter-by-email-validation'),
                selectedEmailValidationType = '';

            if(!_.isUndefined(el)) {
                selectedEmailValidationType = el.find(':selected').val();
            }

            if(selectedEmailValidationType == 'valid' ) {
                if(filterByEmailValidationEl.hasClass('grid_12')) {
                    filterByEmailValidationEl.removeClass('grid_12').addClass('grid_5').addClass('field-rule-row-first');
                }
                $('#lead-filter-by-email-validation-date-block').removeClass('close').addClass('open').removeClass('hidden');
            } else {
                if(filterByEmailValidationEl.hasClass('grid_5')) {
                    filterByEmailValidationEl.removeClass('grid_5').addClass('grid_12').removeClass('field-rule-row-first');
                }
                $('#lead-filter-by-email-validation-date-block').removeClass('open').addClass('close').addClass('hidden');

                if($('#lead-predefined-filter-list').val() == 0) {
                    $('#lead-filter-by-email-validated-to-date').val('');
                }
            }
        },

    });

    return LeadsGridView;
});
