define([
    'backbone',
    'i18n!../../../nls/dashboard_'+$('#main-dashboard-system-language').val()+'_ln',
    '../models/lead-documents-data',
    '../collections/lead-documents-data',
    'text!../templates/lead-document-row.html',
    'text!../templates/paginator.html',
    'moment'
], function(Backbone, i18n, LeadDocumentsDataModel, LeadDocumentsDataCollection, leadDocumentRowTmpl, PaginatorTmpl, moment){
    var LeadDocumentsView = Backbone.View.extend({
        el: $('#lead-detailed-view-config-tab-documents'),
        events: {
            'click .remove-document' : 'removeDocument',
            'click td.documents-paginator a.page': 'navigate'
        },
        templates: {
            paginator: _.template(PaginatorTmpl)
        },
        initialize: function(leadModel, LeadDocumentsDataCollection){
            this.leadModel = leadModel;
            this.LeadDocumentsDataCollection = LeadDocumentsDataCollection;

            this.$el =  $('#lead-detailed-view-config-tab-documents');

            this.LeadDocumentsDataCollection.on('reset', this.renderDocuments, this);
            this.LeadDocumentsDataCollection.on('add', this.renderDocuments, this);
            this.LeadDocumentsDataCollection.on('destroy', this.renderDocuments, this);
        },
        renderDocuments: function(){
            this.$el.find('tbody').empty();
            this.LeadDocumentsDataCollection.each(this.renderDocumentItem, this);
            this.LeadDocumentsDataCollection.info()['i18n'] = i18n;
            if((this.LeadDocumentsDataCollection.length == 0) && (this.LeadDocumentsDataCollection.currentPage != 0)){
                this.LeadDocumentsDataCollection.requestPreviousPage();
            }

            this.$('td.documents-paginator').html(this.templates.paginator(this.LeadDocumentsDataCollection.information));

            $('._lbox').magnificPopup({type: 'image'});
        },
        renderDocumentItem: function(DocumentItemData) {
            var fileStoredName = DocumentItemData.get('fileStoredName'),
                fileExtension = fileStoredName.split('.').pop(),
                showMagnificPopup = false;

            if(this.LeadDocumentsDataCollection.imageMagnificPopupExtensions.includes(fileExtension)) {
                showMagnificPopup = true;
            }
            this.$el.find('tbody').append(_.template(leadDocumentRowTmpl, {'documentItemData': DocumentItemData, 'moment': moment, 'i18n':i18n, 'userTimezoneOffset': this.leadModel.get('userTimezoneOffset'), 'showMagnificPopup' : showMagnificPopup}));
            return false;
        },
        render: function(){
            this.LeadDocumentsDataCollection.server_api.lead_id = this.leadModel.get('id');
            this.LeadDocumentsDataCollection.pager();
        },
        navigate: function(e){
            e.preventDefault();

            var page = $(e.currentTarget).data('page');
            if ($.isNumeric(page)){
                this.LeadDocumentsDataCollection.goTo(page);
            } else {
                switch(page){
                    case 'first':
                        this.LeadDocumentsDataCollection.goTo(this.LeadDocumentsDataCollection.firstPage);
                        break;
                    case 'last':
                        this.LeadDocumentsDataCollection.goTo(this.LeadDocumentsDataCollection.information.lastPage);
                        break;
                    case 'prev':
                        this.LeadDocumentsDataCollection.requestPreviousPage();
                        break;
                    case 'next':
                        this.LeadDocumentsDataCollection.requestNextPage();
                        break;
                }
            }
        },
        removeDocument: function (e) {
            var currentEl = $(e.currentTarget),
                documentId = currentEl.data('did'),
                self = this,
                model = self.LeadDocumentsDataCollection.get(documentId);

            showConfirm(_.isUndefined(i18n['Are you sure want to delete'])?'Are you sure want to delete':i18n['Are you sure want to delete'], function(){
                if (model){
                    model.destroy();

                    showMessage(_.isUndefined(i18n['Deleted'])?'Deleted':i18n['Deleted'], false, 500);

                    self.LeadDocumentsDataCollection.server_api.lead_id = self.leadModel.get('id');
                    self.LeadDocumentsDataCollection.pager();
                }
            });
        }
    });

    return LeadDocumentsView;
});
