define([
    'backbone',
    'text!../templates/detailed-view.html',
    'text!../templates/review-request-block.html',
    './lead-notes',
    './lead-notes-form',
    './lead-call-form',
    './lead-task-form',
    './lead-meeting-form',
    './lead-email-form',
    './lead-sms-form',
    '../models/lead-email-data',
    '../models/lead-sms-data',
    '../collections/lead-documents-data',
    './lead-documents-data',
    './lead-opportunity-form',
    './lead-timeline-log',
    './lead-timeline-upcoming',
    './lead-timeline-today',
    '../models/lead-task-data',
    './lead-timeline-filter',
    '../collections/lead-custom-params',
    './lead-custom-params',
    './lead-opportunity-timeline',
    'text!../templates/lead-states-list.html',
    'text!../templates/lead-detailed-stats-block.html',
    '../collections/lead-opportunities',
    './lead-profile',
    './lead-email-sequence',
    './lead-recently-viewed',
    './lead-call-form',
    'text!../templates/lead-timeline-log-task-completed-dialog.html',
    'text!../templates/lead-call-transcription-dialog.html',
    'text!../templates/lead-call-summary-dialog.html',
    'text!../templates/lead-email-conversation.html',
    'i18n!../../../nls/dashboard_'+$('#main-dashboard-system-language').val()+'_ln',
    'moment',
    'chosen',
    'accounting',
    './lead-grid',
    'plupload',
    'pluploadhtml5',
    'pluploadflash',
    'pluploadhtml4'
], function(Backbone, DetailedViewTmpl, ReviewRequestViewTmpl, LeadNotesView, LeadNotesForm, LeadCallForm, LeadTaskForm, LeadMeetingForm, LeadEmailForm, LeadSmsForm, LeadEmailTemplateDataModel, LeadSmsTemplateDataModel, LeadDocumentsDataCollection, LeadDocumentsData,
            LeadOpportunityForm, LeadTimelineLogView, LeadTimelineUpcomingView, LeadTimelineTodayView, LeadTaskDataModel, LeadTimelineFilter, LeadCustomParamsCollection,
            LeadCustomParamsView, LeadOpportunityTimelineView, LeadStatesListTmpl, LeadDetailedStatsBlockTmpl, LeadOpportunityCollection, LeadProfileView, LeadEmailSequenceView, LeadRecentlyViewedView, LeadCallFormView,
            LeadTimelineLogTaskCompletedDialogTmpl, LeadCallTranscriptionDialogTmpl, LeadCallSummaryDialogTmpl, LeadEmailConversationTmpl, i18n, moment, chosen, accounting, LeadGridView, plupload, pluploadhtml5, pluploadflash, pluploadhtml4
){

    var LeadDetailedView = Backbone.View.extend({
        el: $('#lead-block-detailed-view'),
        events: {
            'click #lead-detailed-view-config-tabs-tab a': 'showLeadDetailedTabs',
            'blur .lead-detailed-view-param': 'changeLeadAttribute',
            'change .lead-group-detailed-view, #lead-detailed-view-states-list, #lead-mobile-countries-codes, #lead-phone-countries-codes, #lead-lifecycle-stage': 'changeLeadGroup',
            'click #lead-detailed-view-statistics-tabs-tab li': 'showLeadStatisticsTabs',
            'click .lead-log-details-info, .lead-call-log-additional-info-link': 'displayGridDetailedInfo',
            'click .lead-log-details-info': 'displayTaskCompletionDetailedInfo',
            'click .lead-log-details-info-email-conversation': 'detailsInfoEmailConversationInfo',
            'click .lead-log-additional-details-info': 'addAdditionalInfoForMeeting',
            'click .show-email-conversation-section-content':'showEmailConversationDetails',
            'change select.lead-country-detailed-view': 'changeLeadCountry',
            'blur textarea.add-additional-call-info': 'addAdditionalInfoForCall',
            'click #lead-tags-detailed-view-block a': 'removeLeadTag',
            'click #add-tag-to-lead': 'addTagToLead',
            'click .social-service':'toggleSocialServiceLink',
            'click #lead-grid-back': 'hideLeadDetailsScreen',
            'blur .lead-social-service-link': 'editSocialServiceLink',
            'click #lead-last-activity-data': 'goToTimeLineItemLastActivity',
            'click #lead-next-activity-data': 'goToTimeLineItemNextActivity',
            'click #view-additional-info-short-link': 'viewAdditionalInfoShortInfo',
            'change .lead-countries-codes' : 'changeMobileDesktopMask',
            'change #organization-address-status-switch': 'switchOrganizationAddress',
            'click #lead-detailed-name-info-switch' : 'switchDetailedNameView',
            'click #lead-detailed-name-info-switch-to-readonly' : 'switchDetailedNameViewReadOnly',
            'change select.lead-owner-selection' : 'changeLeadOwner',
            'change #lead-detailed-view-statistics-tabs input.lead-complete-task': 'completeTask',
            'click #add-edit-merchandising': 'addEditMerchandisingScreen',
            'click #calculate-lead-score': 'calculateLeadScore',
            'click #lead-source-info-switch': 'sourceInfoEdit',
            'blur input.lead-edit-attribute': 'editLeadAttribute',
            'click #lead-address-info-switch': 'addressInfoEdit',
            'click #lead-address-info-switch-close': 'addressInfoEditClose',
            'click #send-nps-review-request': 'sendNpsReviewRequest',
            'click #send-review-request': 'sendReviewRequest',
            'click .review-request-left-or-not' : 'confirmReview',
            'change .review-platform-date': 'saveReviewDate',
            'change #call-from-device-type': 'changeCallFromDeviceType',
            'click #total-open-opportunities-block': 'gotoOpportunitiesTab',
            'click #total-lost-opportunities-block': 'gotoOpportunitiesTab',
            'click #total-won-opportunities-block': 'gotoOpportunitiesTab',
            'click a.copy-path-link-information-info': 'imapCopyPathInfo',
            'click #validate-lead-email': 'validateLeadEmail',
            'click #upload-file-button-dragdrop': 'clearFailedFilesUploadAdditional',
            'click .clear-input-autocomplete': 'clearInputAutocomplete',
            'change .set-meeting-status':'setMeetingStatus',
            'click .call-transcript-details-link':'switchTranscriptionDetails',
            'click .call-summary-details-link':'switchCallSummaryDetails',
        },
        templates: {
        },
        failedFilesUpload: [],
        failedFilesUploadAdditional: {},
        initialize: function(leadModel){
            if (_.isEmpty(leadModel)) {
                return false;
            }
            this.leadModel = leadModel;

            this.leadNotes = new LeadNotesView();
            this.leadNotes.notes.lead_id = leadModel.get('id');

            this.leadNotesForm = new LeadNotesForm();
            this.leadCallForm = new LeadCallForm(this.leadModel);

            this.leadTaskForm = new LeadTaskForm(this.leadModel);
            this.leadMeetingForm = new LeadMeetingForm(this.leadModel);

            this.timelineUpcoming =  new LeadTimelineUpcomingView(this.leadModel);
            this.timelineToday = new LeadTimelineTodayView(this.leadModel);
            this.timelineLog = new LeadTimelineLogView(this.leadModel);
            this.timelineFilter = new LeadTimelineFilter({'isQuizzEnabled': leadModel.get('isQuizzEnabled')});

        },
        render: function() {
            this.$el.empty();
            this.leadModel.groups = this.alphabeticalSort(this.leadModel.get('groups'));
            this.leadModel.stages = this.alphabeticalSort(this.leadModel.get('stages'));
            this.$el.html( _.template(DetailedViewTmpl, {'leadModel': this.leadModel, 'stages': this.leadModel.stages, 'moment': moment, 'accounting': accounting, 'i18n':i18n}));

            var self = this;

            this.$el.find('#lead-detailed-view-tags-list').chosen(/*{max_selected_options: 1}*/).change(function(e){
                e.preventDefault();
                var searchChoice = $(".chosen-choices li.search-choice");
                if(searchChoice.length) {
                    _.each(searchChoice, function (cName, key) {
                        if($(cName).find('span').length == 1) {
                            $(cName).find('span')[0].textContent = self.truncateString($(cName).find('span')[0].textContent, 20);
                        }
                    });
                }
            });
            this.$el.find('#lead-detailed-view-opportunities').remove();
            this.$el.find('#lead-detailed-view-sales').remove();
            this.$el.find('#lead-additional-information-block').after(_.template(LeadDetailedStatsBlockTmpl, {
                'leadModel': this.leadModel,
                'stages': this.leadModel.stages,
                'moment': moment,
                'accounting': accounting,
                'i18n': i18n
            }));

            $(document).find('#nps-and-review-request-block').html(_.template(ReviewRequestViewTmpl, {'leadModel': this.leadModel.toJSON(), 'moment': moment, 'i18n':i18n}));

            _.each(this.leadModel.get('reviewSystems'), function(reviewPlatformName, reviewPlatform) {
                var reviewDate = $(document).find('#review-request-date-manual-'+reviewPlatform);
                reviewDate.datepicker({
                    dateFormat: 'd-M-yy',
                    defaultDate: "+1w",
                    changeMonth: true,
                    changeYear: true,
                    yearRange: "c-5:c+5"
                });
            });

            var mobileMasks = this.leadModel.get('mobileMasks'),
                desktopMasks = this.leadModel.get('desktopMasks'),
                mobileCountryCode = this.leadModel.get('lead_mobile_country_code'),
                desktopCountryCode = this.leadModel.get('lead_phone_country_code'),
                organizationModel = this.leadModel.get('organizationModel'),
                params = this.leadModel.customDataParams;

            if (typeof mobileMasks[mobileCountryCode] !== 'undefined') {
                $('.lead-mobile-detailed-view').mask(mobileMasks[mobileCountryCode].mask_value, {autoclear: false});
            } else {
                $('.lead-mobile-detailed-view').mask('(999) 999 9999', {autoclear: false});
            }

            if (typeof desktopMasks[desktopCountryCode] !== 'undefined') {
                $('.lead-phone-detailed-view').mask(desktopMasks[desktopCountryCode].mask_value, {autoclear: false});
            } else {
                $('.lead-phone-detailed-view').mask('(999) 999 9999', {autoclear: false});
            }

            if (typeof organizationModel.organizationPhoneCountryCode !== 'undefined') {
                $('.lead-organization-phone-number-detailed-view').mask(desktopMasks[organizationModel.organizationPhoneCountryCode].mask_value, {autoclear: false});
            } else {
                $('.lead-organization-phone-number-detailed-view').mask('(999) 999 9999', {autoclear: false});
            }

            var leadId = this.leadModel.get('id');

            this.assign({
                '#lead-notes-list': this.leadNotes,
                '#lead-notes-form': this.leadNotesForm,
                '#lead-detailed-view-config-tab-call': this.leadCallForm,
                '#lead-detailed-view-config-tab-meeting': this.leadMeetingForm,
                '#lead-timeline-log' : this.timelineLog,
                '#lead-timeline-upcoming-events' : this.timelineUpcoming,
                '#lead-timeline-today': this.timelineToday,
                '#lead-timeline-filter-block': this.timelineFilter
            });

            this.leadNotesForm.$el.on('LeadNotesForm:created', _.bind(this.leadNotes.render, this.leadNotes));
            this.timelineFilter.$el.on('TimelineLog:created', _.bind(this.timelineLog.render, this.timelineLog));
            this.timelineFilter.$el.on('TimelineToday:created', _.bind(this.timelineToday.render, this.timelineToday));
            this.timelineFilter.$el.on('TimelineUpcoming:created', _.bind(this.timelineUpcoming.render, this.timelineUpcoming));

            // $("#lead-detailed-view-tags-list").on("keydown", function(event) {
            //     var clearInputAutocomplete = $("#lead-detailed-view-tags-list").closest('.search-block-element-autocomplete').find('.clear-input-autocomplete');
            //     if(typeof clearInputAutocomplete !== 'undefined') {
            //         clearInputAutocomplete.addClass('hidden');
            //     }
            //
            //     if ( event.keyCode === $.ui.keyCode.TAB &&
            //         $(this).autocomplete( "instance" ).menu.active) {
            //         event.preventDefault();
            //     }
            //
            //     if (event.keyCode === 13) {
            //         $("#lead-detailed-view-tags-list").trigger('keydown');
            //     }
            // }).autocomplete({
            //     source: function(request, response) {
            //         $.ajax({
            //             'url': $('#website_url').val()+'api/leads/leadtags/',
            //             'type':'GET',
            //             'dataType':'json',
            //             'data': {searchTerm: request.term}
            //         }).done(function(responseData){
            //             if (!_.isEmpty(responseData)) {
            //                 response($.map(responseData, function (responseData) {
            //                     return {
            //                         label: responseData.tag_name,
            //                         value: responseData.tag_name
            //                     };
            //                 }));
            //             }
            //         });
            //     },
            //     select: function(event, ui) {
            //         var clearInputEl = $("#lead-detailed-view-tags-list").closest('.search-block-element-autocomplete').find('span.clear-input-autocomplete');
            //         if(typeof clearInputEl !== 'undefined') {
            //             if(ui.item.value.length > 0) {
            //                 $(clearInputEl).removeClass('hidden');
            //             } else {
            //                 $(clearInputEl).addClass('hidden');
            //             }
            //         }
            //     }
            // });

            $("#lead-organization-detailed-view").on("keydown", function(event) {
                if ( event.keyCode === $.ui.keyCode.TAB &&
                    $(this).autocomplete( "instance" ).menu.active) {
                    event.preventDefault();
                }
            }).autocomplete({
                source: function(request, response) {
                    $.ajax({
                        'url': $('#website_url').val()+'api/leads/leadorganization/',
                        'type':'GET',
                        'dataType':'json',
                        'data': {searchTerm: request.term}
                    }).done(function(responseData){
                        if (!_.isEmpty(responseData)) {
                            response($.map(responseData, function (responseData) {
                                return {
                                    label: responseData.organization_name,
                                    value: responseData.organization_name
                                };
                            }));
                        }
                    });
                },
                messages: {
                    noResults: '',
                    results: function() {}
                }
            });

            if (!_.isUndefined(params)) {
                if(!_.isUndefined(params.openTabName) && params.openTabName === 'email'){
                    $('#lead-detailed-view-config-tabs').find('[data-tab-id="lead-detailed-view-config-tab-email"]').trigger('click');
                    $('body,html').animate({
                        scrollTop: $('#lead-detailed-view-config-tabs').offset().top - 300
                    }, 1000);
                } else if(!_.isUndefined(params.prefilterbytasks) && params.prefilterbytasks === '1'){
                    $('#timeline-filter-by-outbound').trigger('click');
                    $('#filter-action-log-type-outbound_task').trigger('click');

                    $('body,html').animate({
                        scrollTop: $('#lead-detailed-view-statistics-tabs').offset().top - 0
                    }, 1000);
                } else if(!_.isUndefined(params.prefilterbyprofile) && params.prefilterbyprofile === '1' && !_.isUndefined(params.visitId)){
                    var visitLogId = params.visitId,
                        positionInGridLeadId = leadId;

                    $.ajax({
                        url: $('#website_url').val()+'api/leads/leadprofile/',
                        type: 'GET',
                        data: {'visitLogId':visitLogId, 'calculatePositionInGrid':true, 'positionInGridLeadId':positionInGridLeadId},
                        dataType: 'json'
                    }).done(function(response) {
                        $('body,html').animate({
                            scrollTop: $('#lead-detailed-view-statistics-tabs').offset().top - 50
                        }, 1000);
                        window.LeadDetailedView.showVisitInProfile(response.visitPageNumber, visitLogId);
                    }).fail(function(response){
                        showMessage(response.responseJSON, true, 3000);
                    });
                } else if(!_.isUndefined(params.opportunityId)){
                    $('.detailed-view-statistics-tab-opportunity').trigger('click');
                    var  opportunityTabEl = $('#lead-detailed-view-config-tabs-tab').find('[data-tab-id="lead-detailed-view-config-tab-opportunity"]');
                    opportunityTabEl.addClass('remoteOpen').data('checked-opportunity-id', params.opportunityId).trigger('click');
                    $('body,html').animate({
                        scrollTop: $('#lead-detailed-view-config-tabs-tab').offset().top - 300
                    }, 1000);

                }
            }

            $(".lead-edit-source").on("keydown", function(event) {
                if ( event.keyCode === $.ui.keyCode.TAB &&
                    $(this).autocomplete("instance").menu.active) {
                    event.preventDefault();
                }
            }).autocomplete({
                source: function(request, response) {
                    $.ajax({
                        'url': $('#website_url').val()+'api/leads/leadsource/',
                        'type':'GET',
                        'dataType':'json',
                        'data': {searchTerm: request.term, 'autocomplete':true}
                    }).done(function(responseData){
                        if (!_.isEmpty(responseData)) {
                            response($.map(responseData, function (responseData) {
                                return {
                                    label: responseData.source_name,
                                    value: responseData.source_name
                                };
                            }));
                        }
                    });
                },
                search: function() {},
                focus: function() {
                    return false;
                },
                select: function(event, ui) {}
            });

            return this;
        },
        renderOpportunityStatsOnly: function ()
        {
            var self = this;

            $.ajax({
                'url': $('#website_url').val()+'plugin/leads/run/getOpportunityStatsOnly/',
                'type':'POST',
                'dataType':'json',
                'data': {
                    'secureToken':$('#lead-grid-token').val(),
                    'leadId':self.leadModel.get('id')
                }
            }).done(function(responseData){
                if (!_.isEmpty(responseData)) {
                    if (typeof responseData.responseText.leadOpportunityStats !== 'undefined') {

                        self.leadModel.set('leadOpportunityStats', responseData.responseText.leadOpportunityStats);

                        self.$el.find('#lead-detailed-view-opportunities').remove();
                        self.$el.find('#lead-detailed-view-sales').remove();
                        self.$el.find('#lead-additional-information-block').after(_.template(LeadDetailedStatsBlockTmpl, {
                            'leadModel': self.leadModel,
                            'stages': self.leadModel.stages,
                            'moment': moment,
                            'accounting': accounting,
                            'i18n': i18n
                        }));
                    }
                }
            });
        },
        calculateLeadScore: function(e)
        {
            e.preventDefault();
            $.ajax({
                'url': $('#website_url').val() + 'plugin/leads/run/calculateLeadScore/',
                'type': 'POST',
                'dataType': 'json',
                data: {
                    'secureToken':$('#lead-grid-token').val(),
                    'leadId' : $(e.currentTarget).data('calculate-score-lead-id')
                }
            }).done(function(responseData){
                if (responseData.error == '0') {
                    showMessage(responseData.responseText.message, false, 5000);
                    $('#lead-score-view-detailed-view').text(parseInt(responseData.responseText.score));
                } else {
                    showMessage(responseData.responseText, true, 5000);
                }

            });

        },
        sourceInfoEdit: function(e)
        {
            $('#lead-source-info-switch').hide();
            $('#lead-source-info-switch-close').show();
            $('.lead-edit-source').show();

        },
        addressInfoEdit: function(e)
        {
            $('#lead-address-info-switch').hide();
            $('#lead-address-info-switch-close').show();
            $('.address-info').show();
        },
        addressInfoEditClose: function()
        {
            $('#lead-address-info-switch').show();
            $('#lead-address-info-switch-close').hide();
            $('.address-info').hide();
        },
        editLeadAttribute: function(e)
        {
            var currentAttribute = $(e.currentTarget),
                currentValue = currentAttribute.val();

            if ($('#lead-grid-back').attr('href').match(/http(.*)/)) {
                this.LeadGrid = new LeadGridView();
            } else {
                this.LeadGrid = window.appLeadRouter.LeadGrid;
            }

            this.LeadGrid.editLeadAttribute(e, this.leadModel);
            $('.lead-source-info').prop('title', currentValue);
            // this.sourceInfoEditClose();

        },
        addEditMerchandisingScreen: function(e)
        {
            $('body,html').animate({
                scrollTop: $('#lead-detailed-view-general-info').offset().top - 100
            }, 2000);
        },
        switchDetailedNameView: function(e)
        {
            e.preventDefault();

            $('#lead-detailed-name-info-block').removeClass('hidden');
            $('#lead-tags').addClass('hidden');
            $('#lead-detailed-name-info-switch-block').addClass('hidden');
            $('#lead-scoring-result').addClass('hidden');

        },
        showEmailConversationDetails: function(e)
        {
            var el = $(e.currentTarget),
                emailMessageId = el.data('email-message-id');

            el.closest('td').find('div[data-email-message-id="'+emailMessageId+'"]').toggleClass('hidden');

        },
        switchDetailedNameViewReadOnly: function(e)
        {
            e.preventDefault();

            var leadDetailedNameInfoBlockEl = $('#lead-detailed-name-info-block'),
                prefix = leadDetailedNameInfoBlockEl.find('input[name="lead-prefix-detailed-view"]').val(),
                firstName = leadDetailedNameInfoBlockEl.find('input[name="lead-first-name-detailed-view"]').val(),
                middleName = leadDetailedNameInfoBlockEl.find('input[name="lead-middle-name-detailed-view"]').val(),
                lastName = leadDetailedNameInfoBlockEl.find('input[name="lead-last-name-detailed-view"]').val();

            $('#lead-detailed-name-info-block').addClass('hidden');
            $('#lead-tags').removeClass('hidden');
            $('#full-lead-name-info').text(prefix + ' ' + firstName + ' ' + middleName + ' ' + lastName);
            $('#lead-detailed-name-info-switch-block').removeClass('hidden');
            $('#lead-scoring-result').removeClass('hidden');
        },
        alphabeticalSort: function(obj){
            // convert object into array
            var sortable=[];
            for(var key in obj)
                if(obj.hasOwnProperty(key))
                    sortable.push([key, obj[key]]); // each item is an array in format [key, value]

            // sort items by value
            sortable.sort(function(a, b)
            {
                var x=a[1].toLowerCase(),
                    y=b[1].toLowerCase();
                return x<y ? -1 : x>y ? 1 : 0;
            });
            return sortable; // array in format [ [ key1, val1 ], [ key2, val2 ], ... ]
        },
        switchOrganizationAddress: function(e)
        {
            e.preventDefault();
            var organizationId = $('#icon-profile-ext').data('organization-id'),
                model = this.leadModel,
                addressBlock =  $('#lead-address-block-data'),
                self = this,
                triggerStatus = 0;

            if ($(e.currentTarget).is(':checked')) {
                triggerStatus = 1;
                this.updateOrganizationLeadAddress(addressBlock, organizationId);
            } else {
                this.disableAddressBlockAttributes(addressBlock, model);
            }

            this.leadModel.set('use_organization_address', triggerStatus);
            this.leadModel.set('secureToken', $('#lead-grid-token').val());
            this.leadModel.save(null,{
                success: function(model, response){
                },
                error: function(model, response){
                    showMessage(response.responseJSON, true, 3000);
                }
            });

            self.assign({
                '#lead-detailed-view-config-tab-call': this.leadCallForm
            });
        },
        disableAddressBlockAttributes: function(addressBlock, model){
            addressBlock.find('.organization-phone-number').hide();
            addressBlock.find('.lead-address-detailed-view').prop('disabled', false).val(model.get('lead_address'));
            addressBlock.find('.lead-address1-detailed-view').prop('disabled', false).val(model.get('lead_address1'));
            addressBlock.find('.lead-city-detailed-view').prop('disabled', false).val(model.get('lead_city'));
            addressBlock.find('.lead-zip-detailed-view').prop('disabled', false).val(model.get('lead_zip'));
            addressBlock.find('.lead-country-detailed-view').prop('disabled', false).val(model.get('lead_country_code'));
            addressBlock.find('.lead-state-detailed-view').prop('disabled', false);
            this.changeLeadCountryCode(model.get('lead_country_code'), $('select.lead-country-detailed-view'), model.get('lead_state_code'));
            $('.organization-industry').addClass('hidden');
        },
        updateOrganizationLeadAddress: function(addressBlock, organizationId)
        {
            var self = this;

            $.ajax({
                'url': $('#website_url').val()+'api/leads/leadorganization/',
                'dataType' : 'json',
                'type' : 'GET',
                'data': {
                    'id': organizationId
                }
            }).done(function(response){


                addressBlock.find('.lead-address-detailed-view').prop('disabled', true).val(response.organizationAddress);
                addressBlock.find('.lead-address1-detailed-view').prop('disabled', true).val(response.organizationAddress1);
                addressBlock.find('.lead-city-detailed-view').prop('disabled', true).val(response.organizationCity);
                addressBlock.find('.lead-zip-detailed-view').prop('disabled', true).val(response.organizationZip);
                addressBlock.find('.lead-country-detailed-view').prop('disabled', true).val(response.organizationCountryCode);
                addressBlock.find('.lead-state-detailed-view').prop('disabled', true);
                addressBlock.find('.lead-organization-phone-countries-code').prop('disabled', true).val(response.organizationPhoneCountryCode);
                addressBlock.find('.lead-organization-phone-number-detailed-view').prop('disabled', true).val(response.organizationPhone);

                var desktopMasks = self.leadModel.get('desktopMasks');

                if (typeof response.organizationPhoneCountryCode !== 'undefined') {
                    $('.lead-organization-phone-number-detailed-view').mask(desktopMasks[response.organizationPhoneCountryCode].mask_value, {autoclear: false});
                } else {
                    $('.lead-organization-phone-number-detailed-view').mask('(999) 999 9999', {autoclear: false});
                }

                addressBlock.find('.organization-phone-number').show();

                self.changeLeadCountryCode(response.organizationCountryCode, $('select.lead-country-detailed-view'), response.organizationStateCode);
                $('.organization-industry').removeClass('hidden');

            }).fail(function(response){

            });
        },
        changeMobileDesktopMask: function(e)
        {
            var selectionType = $(e.currentTarget).data('type'),
                value =  $(e.currentTarget).val();

            var mobileMasks = this.leadModel.get('mobileMasks'),
                desktopMasks = this.leadModel.get('desktopMasks');

            if (selectionType === 'mobile') {
                if (typeof mobileMasks[value] !== 'undefined') {
                    $('.lead-mobile-detailed-view').mask(mobileMasks[value].mask_value, {autoclear: false});
                } else {
                    $('.lead-mobile-detailed-view').mask('(999) 999 9999', {autoclear: false});
                }
            }

            if (selectionType === 'desktop') {
                if (typeof desktopMasks[value] !== 'undefined') {
                    $('.lead-phone-detailed-view').mask(desktopMasks[value].mask_value, {autoclear: false});
                } else {
                    $('.lead-phone-detailed-view').mask('(999) 999 9999', {autoclear: false});
                }
            }
        },
        hideLeadDetailsScreen: function(e)
        {
            var href = $(e.currentTarget).attr('href');
            if (href.match(/http(.*)/)) {
                window.location.href = href;
            } else {
                $('#lead-block-detailed-view').empty();
                $('#lead-table-block').show();
                $('.filters').show();
                $('#lead-grid-back-link').addClass('hidden');
                $('#lead-additional-filters').show();
                this.recentlyViewed = new LeadRecentlyViewedView();
                this.recentlyViewed.render();
                $('#recently-viewed-switcher').removeClass('icon-arrow-up2').addClass('icon-arrow-down2');
                $('#lead-organization-filters-switch').removeClass('icon-arrow-up2').addClass('icon-arrow-down2');
                //$('#lead-organizations-recently-viewed-block').removeClass('hidden');
                $('.filter-configuration-elements').removeClass('hidden');

                this.currentStateLeadsPaginator();
            }
        },
        currentStateLeadsPaginator: function () {
            this.LeadGrid = window.appLeadRouter.LeadGrid;

            var currentPage = $('td.lead-grid-paginator span.page').data('page-orig');

            this.LeadGrid.specialPageNavigator(currentPage);
        },
        removeLeadTag: function(e){
            e.preventDefault();

            var el = $(e.currentTarget),
                tagId = el.data('tag-id'),
                tagLabel = el.data('tag-label'),
                leadId = el.closest('ul').data('lead-id'),
                self = this;

            showConfirm(_.isUndefined(i18n['Are you sure want to delete'])?'Are you sure want to delete':i18n['Are you sure want to delete'], function(){
                $.ajax({
                    'url': $('#website_url').val()+'api/leads/leadhastags/lead_id/'+leadId+'/tag_id/'+tagId,
                    'type':'DELETE',
                    'dataType':'json'
                }).done(function(responseData){
                    el.closest('li').remove();
                    if(!_.isEmpty(self.leadModel.get('tags'))) {
                        $('#lead-detailed-view-tags-list').append('<option value="'+tagId+'">'+tagLabel+'</option>');
                        $('#lead-detailed-view-tags-list').val(0).trigger("chosen:updated");
                    }
                });
            });
        },
        goToTimeLineItemLastActivity: function(e){
            $('#lead-detailed-view-statistics-tab-timeline-tab').trigger('click');
            var el = $('#lead-timeline-log'),
                type = $(e.currentTarget).data('timeline-type'),
                subType = $(e.currentTarget).data('timeline-type-subtype'),
                mainType = 'inbound';

            if (type.match(/outbound/gi) !== null) {
                mainType = 'outbound';
            }

            if (!_.isEmpty(subType) && !_.isNull(subType)) {
                type = mainType.replace(/_(.*)/gi, '') + '_' + subType;
            }

            if (type !== '') {
                setTimeout(function () {
                    if (!$('#timeline-filter-by-'+mainType).is(':checked')) {
                        $('#timeline-filter-by-'+mainType).trigger('click');
                    }
                }, 200);

                setTimeout(function () {
                    if (!$('#filter-action-log-type-' + type).hasClass('current')) {
                        $('#filter-action-log-type-' + type).trigger('click');
                    } else {
                        $('#filter-action-log-type-' + type).trigger('click');
                        $('#filter-action-log-type-' + type).trigger('click');
                    }
                }, 300);

                $('body,html').animate({
                    scrollTop: $(el).offset().top
                }, 1000);
            }
            return false;
        },
        gotoOpportunitiesTab: function(e) {
            $('.detailed-view-statistics-tab-opportunity').trigger('click');
            var el = $('#lead-detailed-view-statistics-tabs-tab');

            $('body,html').animate({
                scrollTop: $(el).offset().top
            }, 1000);
        },
        goToTimeLineItemNextActivity: function(e){
            $('#lead-detailed-view-statistics-tab-timeline-tab').trigger('click');
            var el = $('#lead-timeline-today'),
                type = $(e.currentTarget).data('timeline-type');

            if (type !== '') {
                setTimeout(function () {
                    if (!$('#timeline-filter-by-outbound').is(':checked')) {
                        $('#timeline-filter-by-outbound').trigger('click');
                        $('#timeline-filter-by-outbound').trigger('click');
                    }
                }, 200);

                setTimeout(function () {
                    if (!$('#filter-action-log-type-outbound_' + type).hasClass('current')) {
                        $('#filter-action-log-type-outbound_' + type).trigger('click');
                    } else {
                        $('#filter-action-log-type-outbound_' + type).trigger('click');
                        $('#filter-action-log-type-outbound_' + type).trigger('click');
                    }
                }, 300);

                $('body,html').animate({
                    scrollTop: $(el).offset().top
                }, 1000);
            }

            return false;
        },
        viewAdditionalInfoShortInfo: function (e)
        {
            $('#lead-detailed-view-statistics-tab-custom-params-tab').trigger('click');

            var el = $('#lead-detailed-view-statistics-tabs-tab');

            $('body,html').animate({
                scrollTop: $(el).offset().top
            }, 1000);
        },
        toggleSocialServiceLink: function(e)
        {

            e.preventDefault();
            var el = $(e.currentTarget),
                socialServiceBlock = el.closest('.lead-social-services-listing').find("[data-service-id='" + el.data('service-link-id') + "']").closest('div'),
                hiddenStatus = socialServiceBlock.hasClass('hidden'),
                imageUrl = el.data('image-url');

            $('.lead-social-service-info').addClass('hidden');
            if (hiddenStatus) {
                socialServiceBlock.removeClass('hidden');
                socialServiceBlock.find('.input-service-image').attr('src', imageUrl);
            }

            var socialServiceLink = socialServiceBlock.find('.lead-social-service-link').val();

            if (socialServiceLink === '') {
                socialServiceBlock.find('.lead-service-link-out').addClass('hidden');
            } else {
                socialServiceBlock.find('.lead-service-link-out').removeClass('hidden');
            }
        },
        editSocialServiceLink: function(e)
        {
            e.preventDefault();
            var el = $(e.currentTarget),
                oldValue = el.data('old-value'),
                currentValue = el.val(),
                leadId = el.closest('.lead-social-services-listing').data('lead-id'),
                serviceId = el.data('service-id');

            if (oldValue !== currentValue) {
                var data = {'lead_id':leadId, 'service_id':serviceId, 'secureToken': $('#lead-grid-token').val(), 'service_link':currentValue};
                $.ajax({
                    'url': $('#website_url').val()+'api/leads/leadhassocialservice/',
                    'type':'PUT',
                    'dataType':'json',
                    'data': JSON.stringify(data)
                }).done(function(responseData){
                    showMessage(responseData.responseText, false, 5000);
                    el.closest('.lead-social-service-info').find('.lead-service-link-out').attr('href', currentValue);
                    el.data('old-value', currentValue);
                    if (currentValue === '') {
                        $(".lead-social-services-listing").find("[data-service-link-id='" + serviceId + "']").addClass('social-service-empty');
                        el.closest('.lead-social-services-listing').find('.lead-service-link-out').addClass('hidden');
                    } else {
                        $(".lead-social-services-listing").find("[data-service-link-id='" + serviceId + "']").removeClass('social-service-empty');
                        el.closest('.lead-social-services-listing').find('.lead-service-link-out').removeClass('hidden');
                    }
                });
            }

        },
        addTagToLead: function(e)
        {
            e.preventDefault();
            var newTagName = $('#create-new-tag').val(),
                tagIds = $('#lead-detailed-view-tags-list').val(),
                leadId = $(e.currentTarget).data('lead-id'),
                self = this,
                assignedTagMsg = (_.isUndefined(i18n['Tag has been assigned'])?'Tag has been assigned':i18n['Tag has been assigned']);

            newTagName = newTagName.trim();
            if(newTagName == '' && _.isEmpty(tagIds)) {
                showMessage(_.isUndefined(i18n['Nothing to assign']) ? 'Nothing to assign' : i18n['Nothing to assign'], false, 2000);
                return false;
            }

            if (newTagName) {
                $.ajax({
                    'url': $('#website_url').val()+'api/leads/leadtags/searchByTagName/'+newTagName,
                    'type':'GET',
                    'dataType':'json'
                }).done(function(responseData){
                    if (_.isEmpty(responseData)) {
                        $.ajax({
                            'url': $('#website_url').val()+'api/leads/leadtags/',
                            'type':'POST',
                            'dataType':'json',
                            'data': {'lead_id':leadId, 'tag_name':newTagName, 'label':newTagName, 'secureToken': $('#lead-grid-token').val()}
                        }).done(function(responseData){
                            self.attachTagToLead(leadId, responseData.responseText.tagInfo.id, responseData.responseText.tagInfo.label, responseData.responseText.tagInfo.tagName);
                            $('#create-new-tag').val('');
                        }).fail(function(response){
                            showMessage(JSON.parse(response.responseText), true, 5000);
                        });
                    } else{
                        self.attachTagToLead(leadId, responseData.id, responseData.label, responseData.tagName);
                        $('#create-new-tag').val('');
                        $("#lead-detailed-view-tags-list option[value='"+ responseData.id +"']").remove();
                        $('#lead-detailed-view-tags-list').val(0).trigger("chosen:updated");
                    }
                });
            }

            if(tagIds) {
                var tagSelectedList = $('#lead-detailed-view-tags-list').find('option:selected');
                _.each(tagIds, function (tagId, key) {
                    var tagLabel = tagSelectedList[key].label;
                    self.attachTagToLead(leadId, tagId, tagLabel);
                    $("#lead-detailed-view-tags-list option[value='"+ tagId +"']").remove();
                });

                $('#lead-detailed-view-tags-list').val(0).trigger("chosen:updated");

                if(tagIds.length > 1) {
                    assignedTagMsg = (_.isUndefined(i18n['Tags have been assigned'])?'Tags have been assigned':i18n['Tags have been assigned']);
                }
            }

            showMessage(assignedTagMsg, false, 2000);

        },
        attachTagToLead: function(leadId, tagId, tagLabel, tagName)
        {
            var data = {'lead_id':leadId, 'tag_id':tagId, 'secureToken': $('#lead-grid-token').val()};
            $.ajax({
                'url': $('#website_url').val()+'api/leads/leadhastags/',
                'type':'PUT',
                'dataType':'json',
                'data': JSON.stringify(data)
            }).done(function(responseData){
                var tagExists = $('#lead-tags-detailed-view-block').find("a[data-tag-id='" + tagId + "']");
                if (tagExists.length < 1) {
                    $('#lead-tags-detailed-view-block').append('<li>'+tagLabel+'<a class="ticon-close error" data-role="delete" data-tag-id="'+tagId+'" data-tag-label="'+tagLabel+'" href="javascript:;"></a></li>');
                }
            });
        },
        showVisitInProfile: function(profilePageId, visitId)
        {
            var el = $('#lead-detailed-view-statistics-tab-profile-tab'),
                self = this,
                tabBlockContentEl = $('#lead-detailed-view-statistics-tab-profile'),
                tabContentBlock = el.closest('#lead-detailed-view-statistics-tabs').find('.lead-detailed-view-statistics-tabs-content'),
                leadId = $('#lead-detailed-view-statistics-tabs').data('lead-id');

            if(!_.isUndefined(this.leadProfileView)) {
                this.leadProfileView.$el.unbind();
            }
            this.leadProfileView = new LeadProfileView(leadId, profilePageId, visitId);
            self.assign({
                '#lead-detailed-view-statistics-tab-profile': this.leadProfileView
            });
            tabContentBlock.addClass('hidden');
            $('#lead-detailed-view-statistics-tabs').find('li').removeClass('current');
            this.hideTab(tabBlockContentEl, el);
        },
        showLeadStatisticsTabs: function(e)
        {
            var el = $(e.currentTarget),
                tabBlockContentId = el.data('tab-id'),
                tabContentName = el.data('tab-name'),
                tabBlockContentEl = $('#'+tabBlockContentId),
                self = this,
                tabContentBlock = el.closest('#lead-detailed-view-statistics-tabs').find('.lead-detailed-view-statistics-tabs-content'),
                leadId = $('#lead-detailed-view-statistics-tabs').data('lead-id');

            if (el.hasClass('current')) {
                return false;
            }

            if (tabBlockContentEl.hasClass('hidden')) {
                if (tabContentName === 'custom-params') {
                    if(!_.isUndefined(this.LeadCustomParams)) {
                        this.LeadCustomParams.$el.unbind();
                    }
                    this.LeadCustomParams = new LeadCustomParamsView(leadId, {'grid':true});
                    self.assign({
                        '#lead-detailed-view-statistics-tab-custom-params': this.LeadCustomParams
                    });
                    self.hideTab(tabBlockContentEl, el);
                }

                if (tabContentName === 'opportunity') {
                    if(!_.isUndefined(this.opportunitiesQuotes)) {
                        this.opportunitiesQuotes.$el.unbind();
                    }
                    this.opportunitiesQuotes = new LeadOpportunityTimelineView(leadId);
                    self.assign({
                        '#lead-detailed-view-statistics-tab-opportunity': this.opportunitiesQuotes
                    });
                    this.opportunitiesQuotes.$el.on('opportunitiesQuotes:created', _.bind(this.opportunitiesQuotes.render, this.opportunitiesQuotes));
                    self.hideTab(tabBlockContentEl, el);
                }

                if (tabContentName === 'email-sequence') {
                    if(!_.isUndefined(this.leadEmailSequenceView)) {
                        this.leadEmailSequenceView.$el.unbind();
                        this.leadEmailSequenceView.emailSequenceFilterTopView.$el.unbind();
                        this.leadEmailSequenceView.emailSequenceFilterTopView.$el.empty();
                        this.leadEmailSequenceView.emailSequenceFilterBottomView.$el.unbind();
                        this.leadEmailSequenceView.emailSequenceFilterBottomView.$el.empty();
                        this.leadEmailSequenceView.emailSequenceSubscribeView.$el.unbind();
                        this.leadEmailSequenceView.emailSequenceLogView.$el.unbind();
                    }
                    this.leadEmailSequenceView = new LeadEmailSequenceView(leadId);
                    self.assign({
                        '#lead-detailed-view-statistics-tab-email-sequence': this.leadEmailSequenceView
                    });
                    self.hideTab(tabBlockContentEl, el);
                }

                if (tabContentName === 'profile') {
                    if(!_.isUndefined(this.leadProfileView)) {
                        this.leadProfileView.$el.unbind();
                    }
                    this.leadProfileView = new LeadProfileView(leadId);
                    self.assign({
                        '#lead-detailed-view-statistics-tab-profile': this.leadProfileView
                    });
                }
            }
            tabContentBlock.addClass('hidden');
            $('#lead-detailed-view-statistics-tabs').find('li').removeClass('current');
            this.hideTab(tabBlockContentEl, el);
        },
        showLeadDetailedTabs: function(e)
        {
            var el = $(e.currentTarget),
                displayTab = false,
                tabBlockContentId = el.data('tab-id'),
                tabBlockCustomTabId = el.data('custom-tab-id'),
                tabBlockContentEl = $('#'+tabBlockContentId),
                self = this,
                tabContentBlock = el.closest('#lead-detailed-view-config-tabs').find('.lead-detailed-view-config-tabs-content'),
                liElements = $('#lead-detailed-view-config-tabs-tab').find('li'),
                leadId = $('#lead-detailed-view-statistics-tabs').data('lead-id');

            if (tabBlockContentEl.hasClass('hidden')) {
                displayTab = true;
            }

            if (el.hasClass('remoteOpen')) {
                el.removeClass('remoteOpen');
                displayTab = true;
            }

            tabContentBlock.addClass('hidden');
            if (displayTab) {
                if (tabBlockContentId === 'lead-detailed-view-config-tab-email') {
                    this.leadEmailTemplatesModel = new LeadEmailTemplateDataModel();
                    this.leadEmailTemplatesModel.fetch({data: {'lead_id': self.leadModel.get('id')},
                        'success': function(emailTabDataModel){
                            if(!_.isUndefined(this.leadEmailForm)) {
                                this.leadEmailForm.$el.unbind();
                            }
                            this.leadEmailForm = new LeadEmailForm(self.leadModel, emailTabDataModel);

                            self.assign({
                                '#lead-detailed-view-config-tab-email': this.leadEmailForm
                            });
                            liElements.removeClass('current');
                            self.hideTab(tabBlockContentEl, el);
                        }
                    });
                } else if(tabBlockContentId === 'lead-detailed-view-config-tab-task') {
                    this.leadTaskDataModel = new LeadTaskDataModel();
                    this.leadTaskDataModel.fetch({data: {},
                        'success': function(taskTabDataModel){
                            if(!_.isUndefined(this.leadTaskForm)) {
                                this.leadTaskForm.$el.unbind();
                            }
                            this.leadTaskForm = new LeadTaskForm(self.leadModel, taskTabDataModel);

                            self.assign({
                                '#lead-detailed-view-config-tab-task':this.leadTaskForm
                            });
                            liElements.removeClass('current');
                            self.hideTab(tabBlockContentEl, el);
                        }
                    });

                } else if (tabBlockContentId === 'lead-detailed-view-config-tab-sms') {
                    this.leadSmsTemplatesModel = new LeadSmsTemplateDataModel();
                    this.leadSmsTemplatesModel.fetch({
                        data: {'lead_id': self.leadModel.get('id')},
                        'success': function (smsTabDataModel) {
                            if (!_.isUndefined(this.leadSmsForm)) {
                                this.leadSmsForm.$el.unbind();
                            }
                            this.leadSmsForm = new LeadSmsForm(self.leadModel, smsTabDataModel);

                            self.assign({
                                '#lead-detailed-view-config-tab-sms': this.leadSmsForm
                            });
                            liElements.removeClass('current');
                            self.hideTab(tabBlockContentEl, el);
                        }
                    });
                } else if(tabBlockContentId === 'lead-detailed-view-config-tab-opportunity') {
                    this.leadOpportunityDataModel = new LeadOpportunityCollection();
                    this.leadOpportunityDataModel.fetch({data: {'excludeEmptyOpportunityStages':true, 'lead_id': self.leadModel.get('id')},
                        'success': function(leadOpportunityDataModel){
                            if(!_.isUndefined(this.LeadOpportunityForm)) {
                                this.LeadOpportunityForm.$el.unbind();
                            }

                            leadOpportunityDataModel.checkedOpportunityId = el.data('checked-opportunity-id');

                            this.LeadOpportunityForm = new LeadOpportunityForm(self.leadModel, leadOpportunityDataModel);
                            self.assign({
                                '#lead-detailed-view-config-tab-opportunity': this.LeadOpportunityForm
                            });

                            self.leadOpportunityForm = this.LeadOpportunityForm;
                            
                            liElements.removeClass('current');
                            if (tabBlockContentEl.hasClass('hidden')) {
                                self.hideTab(tabBlockContentEl, el);
                            } else {
                                tabBlockContentEl.removeClass('hidden');
                            }
                        }
                    });
                } else if(tabBlockContentId === 'lead-detailed-view-config-tab-documents') {
                    this.LeadDocumentsDataCollection = new LeadDocumentsDataCollection();
                    this.LeadDocumentsDataCollection.fetch({data: {'lead_id': self.leadModel.get('id')},
                        'success': function(documentTabDataModel){
                            if(!_.isUndefined(this.LeadDocumentsData)) {
                                this.LeadDocumentsData.$el.unbind();
                            }
                            this.LeadDocumentsData = new LeadDocumentsData(self.leadModel, documentTabDataModel);

                            self.assign({
                                '#lead-detailed-view-config-tab-documents': this.LeadDocumentsData
                            });

                            var allowedUploadData = self.leadModel.get('allowedUploadData');

                            self.initDocumentsUploader(allowedUploadData);
                            liElements.removeClass('current');
                            self.hideTab(tabBlockContentEl, el);
                        }
                    });
                } else if(tabBlockContentId === 'lead-detailed-view-config-tab-custom-fields-tabs') {
                    if(!_.isUndefined(this.LeadCustomTabsParams)) {
                        this.LeadCustomTabsParams.$el.unbind();
                    }
                    this.LeadCustomTabsParams = new LeadCustomParamsView(leadId, {'grid': true, 'customTabId': tabBlockCustomTabId});
                    self.assign({
                        '#lead-detailed-view-config-tab-custom-fields-tabs': this.LeadCustomTabsParams
                    });

                    liElements.removeClass('current');
                    if(el.hasClass('opened')) {
                        //tabBlockContentEl.addClass('hidden');
                        liElements.find('a').removeClass('opened');
                    } else if (tabBlockContentEl.hasClass('hidden')) {
                        self.hideTab(tabBlockContentEl, el);
                        liElements.find('a').removeClass('opened');
                        el.addClass('opened');
                    } else {
                        tabBlockContentEl.removeClass('hidden');
                    }

                    el.addClass('remoteOpen');
                } else if (tabBlockContentId === 'lead-detailed-view-config-tab-call') {
                    self.assign({
                        '#lead-detailed-view-config-tab-call': this.leadCallForm
                    });
                    liElements.removeClass('current');
                    this.hideTab(tabBlockContentEl, el);
                } else if (tabBlockContentId === 'lead-detailed-view-config-tab-meeting') {
                    self.assign({
                        '#lead-detailed-view-config-tab-meeting': this.leadMeetingForm
                    });
                    liElements.removeClass('current');
                    this.hideTab(tabBlockContentEl, el);
                } else {
                    liElements.removeClass('current');
                    this.hideTab(tabBlockContentEl, el);
                }
            } else {
                liElements.removeClass('current');
            }
        },
        reRenderOpportunityTab: function() {
            var self = this;
            this.leadOpportunityDataModel = new LeadOpportunityCollection();
            this.leadOpportunityDataModel.fetch({data: {'excludeEmptyOpportunityStages':true, 'lead_id': self.leadModel.get('id')},
                'success': function(leadOpportunityDataModel){
                    if (typeof window.LeadDetailedView.leadOpportunityForm !== 'undefined') {
                        window.LeadDetailedView.leadOpportunityForm.leadOpportunitiesData = leadOpportunityDataModel;
                        window.LeadDetailedView.leadOpportunityForm.render();
                    }
                }
            });
        },
        clearFailedFilesUploadAdditional: function () {
            this.failedFilesUploadAdditional = {};
        },
        initDocumentsUploader: function(allowedUploadData) {
            var options = {
                runtimes: 'html5,flash,html4',
                browse_button: 'upload-file-button-dragdrop',
                container: 'uploader-documents-block',
                rename         : true,
                max_file_size  : allowedUploadData.fileSize+'mb',
                max_file_count : allowedUploadData.fileUploads,
                url: $('#website_url').val()+'api/leads/leaddocuments/',
                multipart_params: {
                    secureToken: $('#lead-grid-token').val(),
                    leadId:      this.leadModel.get('id')
                },
                multi_selection: true,
                unique_names: false,
                dragdrop: true,
                drop_element: 'upload-file-button-dragdrop',
            };

            if(_.isUndefined(this.documentsUploader)) {

                this.documentsUploader = new plupload.Uploader(options);

                this.documentsUploader.init();

                this.documentsUploader.bind('BeforeUpload', _.bind(this.beforeUpload, this));
                this.documentsUploader.bind('FilesAdded', _.bind(this.filesAdded, this));
                this.documentsUploader.bind('UploadProgress', _.bind(this.uploadProgress, this));
                this.documentsUploader.bind('FileUploaded', _.bind(this.fileUploaded, this));
                this.documentsUploader.bind('Error', _.bind(this.handleUploadErrors, this));
                this.documentsUploader.bind('UploadComplete', _.bind(this.uploadComplete, this));
            }
        },
        beforeUpload: function(up, file) {
            $('#progressbar-uploader-documents-file').fadeIn().progressbar({value: 0});
            $('#progressbar-uploader-documents-text').fadeIn();
        },
        filesAdded: function(up, files) {
            var failedFilesUploadAdditionalFiltered = [];

            if(files.length) {
                _.each(this.failedFilesUploadAdditional, function (fileName, key) {
                    _.each(files, function (fileN, k) {
                        if(fileN.id == key) {
                            failedFilesUploadAdditionalFiltered.push(fileName);
                        }
                    });

                });

                if(failedFilesUploadAdditionalFiltered.length) {
                    this.failedFilesUploadAdditional = failedFilesUploadAdditionalFiltered;
                } else {
                    this.failedFilesUploadAdditional = {};
                }
            }

            this.documentsUploader.settings.multipart_params.multipleFiles = 0;
            if(files.length > 1) {
                this.documentsUploader.settings.multipart_params.multipleFiles = 1;
            }
            this.documentsUploader.settings.multipart_params.secureToken = $('#lead-grid-token').val();
            this.failedFilesUpload = [];
            this.documentsUploader.start();
        },
        uploadProgress: function(up, file) {
            $('#progressbar-uploader-documents-file').progressbar({value: file.percent}).text(file.name);
            $('#progressbar-uploader-documents-text').text(' ' +(_.isUndefined(i18n['is uploading']) ? 'is uploading' : i18n['is uploading']) + ' (' + file.percent + '%)');
        },
        fileUploaded: function(up, file, info) {
            var response = jQuery.parseJSON(info.response),
                self = this;
            if (response.error == '0') {
                if(!this.documentsUploader.settings.multipart_params.multipleFiles) {
                    showMessage(response.message, false, 500);
                }

                self.LeadDocumentsDataCollection.server_api.lead_id = self.leadModel.get('id');
                self.LeadDocumentsDataCollection.pager();
            } else {
                if(typeof response.fileName !== 'undefined' && response.fileName != '') {
                    var errorMessage = '';
                    if  (typeof(response.message) == 'object') {
                        for (var i in response.message) {
                            errorMessage += '<li>'+response.message[i]+'</li>';
                        }
                    } else {
                        errorMessage += '<li> ' + (_.isUndefined(i18n['File']) ? 'File' : i18n['File']) + ' \'' + response.fileName + '\' (' + response.message + ')'+'</li>';
                    }
                    self.failedFilesUpload.push(errorMessage);
                }
                //showMessage(response.message.result, true, 3000);
            }
        },
        handleUploadErrors: function(up, err) {
            var errorMessage = '<li> ' + (_.isUndefined(i18n['File']) ? 'File' : i18n['File']) + ' \'' + (err.file ? err.file.name : "") + '\' (' + err.message + ')'+'</li>';
            this.failedFilesUploadAdditional[err.file.id] = errorMessage;
        },
        uploadComplete: function(up, files) {
            $('#progressbar-uploader-documents-file').delay(800).fadeOut();
            $('#progressbar-uploader-documents-text').delay(800).fadeOut();
            if(this.failedFilesUploadAdditional.length) {
                var msg = _.isUndefined(i18n['Files uploaded']) ? 'Files uploaded' : i18n['Files uploaded'];
                msg += ' </br>' +(_.isUndefined(i18n['Except:']) ? 'Except:' : i18n['Except:']) + '</br>';
                msg += '<ul>';
                _.each(this.failedFilesUploadAdditional, function (fileName, key) {
                    msg += fileName;
                });

                if(this.failedFilesUpload.length) {
                    _.each(this.failedFilesUpload, function (fileName, key) {
                        msg += fileName;
                    });
                }
                msg += '</ul>';
                showMessage(msg, true, 500);
            } else {
                if(this.failedFilesUpload.length) {
                    if(up.files.length == this.failedFilesUpload.length) {
                        if(up.files.length > 1) {
                            var msg = (_.isUndefined(i18n['Files not uploaded.']) ? 'Files not uploaded.' : i18n['Files not uploaded.']) + '</br>';
                        } else {
                            var msg = (_.isUndefined(i18n['File not uploaded.']) ? 'File not uploaded.' : i18n['File not uploaded.']) + '</br>';
                        }

                        msg += '<ul>';
                        _.each(this.failedFilesUpload, function (fileName, key) {
                            msg += fileName;
                        });
                        msg += '</ul>';

                        showMessage(msg, true, 500);
                    } else if (up.files.length > this.failedFilesUpload.length) {
                        var msg = _.isUndefined(i18n['Files uploaded']) ? 'Files uploaded' : i18n['Files uploaded'];
                        msg += ' </br>' +(_.isUndefined(i18n['Except:']) ? 'Except:' : i18n['Except:']) + '</br>';
                        msg += '<ul>';
                        _.each(this.failedFilesUpload, function (fileName, key) {
                            msg += fileName;
                        });
                        msg += '</ul>';
                        showMessage(msg, true, 500);
                    }
                } else {
                    showMessage(_.isUndefined(i18n['Files uploaded']) ? 'Files uploaded' : i18n['Files uploaded'], false, 500);
                }
            }

            this.failedFilesUploadAdditional = {};
            this.documentsUploader.splice();
        },
        hideTab: function (tabBlockContentEl, el){
            tabBlockContentEl.removeClass('hidden');
            el.closest('li').addClass('current');
        },
        assign: function (selector, view) {
            var selectors;
            if (_.isObject(selector)) {
                selectors = selector;
            }
            else {
                selectors = {};
                selectors[selector] = view;
            }
            if (!selectors) return;
            _.each(selectors, function (view, selector) {
                view.setElement(this.$(selector)).render();
            }, this);
        },
        changeLeadAttribute: function(e)
        {
            var el = $(e.currentTarget),
                attributeName = el.data('lead-attr'),
                oldVal = el.data('lead-old-val'),
                currentVal = el.val();

            if (oldVal == currentVal) {
                return false;
            }

            this.updateLeadAttribute(el, attributeName, currentVal);
        },
        changeLeadCountry: function (e)
        {

            var el = $(e.currentTarget),
                currentVal = $(e.currentTarget).val(),
                attributeName = el.data('lead-attr');

            this.changeLeadCountryCode(currentVal, el);

            this.updateLeadAttribute(el, attributeName, currentVal);
        },
        changeLeadCountryCode: function(currentVal, el, state)
        {
            if (currentVal) {
                $.ajax({
                    'url': $('#website_url').val()+'plugin/leads/run/getStateByCountryCode/',
                    'type':'POST',
                    'dataType': 'json',
                    'data': {
                        'countryCode': currentVal,
                        'secureToken': $('#lead-grid-token').val()
                    }
                }).done(function(response){
                    if(response.error === 1){
                        $(".lead-state-detailed-view").addClass('hidden');
                        $(".lead-detailed-view-states-list-label").addClass('hidden');
                        el.closest('p').removeClass('grid_6').addClass('grid_12');
                    } else {
                        $('#lead-detailed-view-states-list').empty().html(_.template(LeadStatesListTmpl, {'statesList':response.responseText.statesList}));
                        $(".lead-state-detailed-view").removeClass('hidden');
                        $(".lead-detailed-view-states-list-label").removeClass('hidden');
                        el.closest('p').removeClass('grid_12').addClass('grid_6');
                    }

                    if (typeof state !== 'undefined') {
                        $('.lead-state-detailed-view').val(state);
                    }
                });
            }
        },
        changeLeadGroup: function(e)
        {
            var el = $(e.currentTarget),
                attributeName = el.data('lead-attr'),
                currentVal = el.val();

            this.updateLeadAttribute(el, attributeName, currentVal);

        },
        processMergeLeads: function(mergeToIdParam, mergeBasedOnParam, leadModelParam, attributeNameParam, el) {
            var mergeToId = mergeToIdParam,
                mergeBasedOn = mergeBasedOnParam,
                leadModel = leadModelParam,
                attributeName = attributeNameParam;

            leadModel.leadModel.set('mergeRecordWithId', mergeToId);
            leadModel.leadModel.set('mergeBasedOn', mergeBasedOn);
            leadModel.leadModel.save(null, {
                success: function (model, response) {
                    window.location = $('#website_url').val() + 'dashboard/leads/#lead/' + mergeToId
                },
                error: function (model, response) {
                    leadModel.leadModel.set('mergeRecordWithId', '');
                    leadModel.leadModel.set('mergeBasedOn', '');
                    leadModel.leadModel.set(attributeName, el.data('lead-old-val'));
                    showMessage(response.responseJSON, true, 3000);
                    el.val(el.data('lead-old-val'));
                    return false;
                }
            });
        },
        updateLeadAttribute: function(el, attributeName, currentVal)
        {
            var self = this;

            if((attributeName == 'lead_country_code') && (currentVal == 'US' || currentVal == 'CA' || currentVal == 'AU')) {
                this.leadModel.set('lead_state_code', '');
            }

            this.leadModel.set(attributeName, currentVal);
            this.leadModel.set('secureToken', $('#lead-grid-token').val());
            this.leadModel.save(null,{
                success: function(model, response){
                    if (attributeName == 'organization_name') {
                        $('.icon-profile-ext').remove();
                        if (!_.isEmpty(currentVal)) {
                            $('.icon-profile-organization').closest('span').before('<a target="_blank" id="icon-profile-ext" data-organization-id="'+response.responseText.model.organizationId+'" class="icon-profile-ext fl-right" href="'+$('#website_url').val()+'dashboard/organizations/#organization/'+response.responseText.model.organizationId+'"></a>');
                            $('#organization-address-status-switch-block').removeClass('hidden');
                            if ($('#organization-address-status-switch').is(':checked')) {
                                self.updateOrganizationLeadAddress($('#lead-address-block-data'), response.responseText.model.organizationId);
                            }
                        } else {
                            if ($('#organization-address-status-switch').is(':checked')) {
                                $('#organization-address-status-switch').trigger('click');
                            }
                            $('#organization-address-status-switch-block').addClass('hidden');
                        }
                    }

                    if (response.error == '1') {
                        if (typeof response.responseText.duplicatedLeadEmail !== 'undefined') {
                            showConfirm(response.responseText.message + ' ' + (_.isUndefined(i18n['Would you like to merge both records?']) ? 'Would you like to merge both records?' : i18n['Would you like to merge both records?']), function () {
                                self.processMergeLeads(response.responseText.mergeToId, response.responseText.mergeBasedOn, self, attributeName, el);


                                /**
                                 * @todo Remove commented code
                                    var mergeToId = response.responseText.mergeToId,
                                    mergeBasedOn = response.responseText.mergeBasedOn;
                                    self.leadModel.set('mergeRecordWithId', mergeToId);
                                    self.leadModel.set('mergeBasedOn', mergeBasedOn);
                                    self.leadModel.save(null, {
                                        success: function (model, response) {
                                            window.location = $('#website_url').val() + 'dashboard/leads/#lead/' + mergeToId
                                        },
                                        error: function (model, response) {
                                            self.leadModel.set('mergeRecordWithId', '');
                                            self.leadModel.set('mergeBasedOn', '');
                                            self.leadModel.set(attributeName, el.data('lead-old-val'));
                                            showMessage(response.responseJSON, true, 5000);
                                            el.val(el.data('lead-old-val'));
                                            return false;
                                        }
                                    });
                                 */
                            }, function () {
                                self.leadModel.set(attributeName, el.data('lead-old-val'));
                                el.val(el.data('lead-old-val'));
                            });
                        } else if(typeof response.responseText.duplicatedLeadPhone !== 'undefined') {
                            showConfirm(response.responseText.message + ' ' + (_.isUndefined(i18n['Would you like to merge both records?']) ? 'Would you like to merge both records?' : i18n['Would you like to merge both records?']), function () {
                                self.processMergeLeads(response.responseText.mergeToId, response.responseText.mergeBasedOn, self, attributeName, el);
                            }, function () {
                                self.leadModel.set(attributeName, el.data('lead-old-val'));
                                el.val(el.data('lead-old-val'));
                            });
                        } else if(typeof response.responseText.duplicatedLeadMobile !== 'undefined') {
                            showConfirm(response.responseText.message + ' ' + (_.isUndefined(i18n['Would you like to merge both records?']) ? 'Would you like to merge both records?' : i18n['Would you like to merge both records?']), function () {
                                self.processMergeLeads(response.responseText.mergeToId, response.responseText.mergeBasedOn, self, attributeName, el);
                            }, function () {
                                self.leadModel.set(attributeName, el.data('lead-old-val'));
                                el.val(el.data('lead-old-val'));
                            });
                        } else {
                            showMessage(response.responseText.message, true, 500);
                        }
                    } else {
                        el.data('lead-old-val', currentVal);
                        if (!_.isEmpty(response.responseText.model.leadEmail)) {
                            $('#validate-lead-email').attr('disabled', false);
                        } else {
                            $('#validate-lead-email').attr('disabled', true);
                        }
                        showMessage(response.responseText.message, false, 500);
                    }
                },
                error: function(model, response){
                    el.data('lead-old-val', currentVal);
                    showMessage(response.responseJSON, true, 3000);
                }
            });
        },
        setMeetingStatus: function(e)
        {
            e.preventDefault();

            var currentEl = $(e.currentTarget),
                selectedValue = currentEl.val(),
                oldValue = currentEl.data('old-value'),
                meetingLogId = currentEl.data('meeting-log-id'),
                additionalMeetingNotes = currentEl.closest('td').find('.add-additional-meeting-info').data('old-additional-data');

            if (oldValue === selectedValue) {
                return false;
            }

            if (selectedValue === 'completed' && additionalMeetingNotes === '') {
                $(e.currentTarget).val(oldValue);
                showMessage(_.isUndefined(i18n['Add your meeting notes now to save that status'])?'Add your meeting notes now to save that status':i18n['Add your meeting notes now to save that status'], true, 3000);
                return false;
            }

            $.ajax({
                url: $('#website_url').val()+'api/leads/leadmeetinglog/',
                type: 'PUT',
                data: JSON.stringify({'id':meetingLogId, 'type':'changeStatus', 'status':selectedValue, 'secureToken':$('#lead-grid-token').val()}),
                dataType: 'json'
            }).done(function(response) {
                showMessage(response.responseText, false, 5000);
                currentEl.data('old-value', selectedValue);
            }).fail(function(response){
                showMessage(response.responseJSON, true, 5000);
            });

        },
        displayGridDetailedInfo: function(e){
           var currentEl = $(e.currentTarget),
               dataBlock = currentEl.closest('tr').find('.lead-log-details-info-block'),
               conversationLink = currentEl.closest('tr').find('.lead-log-details-info-email-conversation');
               if(dataBlock.hasClass('hidden')) {
                    if (conversationLink && conversationLink.hasClass('open')) {
                        conversationLink.trigger('click');
                    }
                    currentEl.addClass('open');
                    currentEl.removeClass('closed');
                } else {
                    currentEl.addClass('closed');
                    currentEl.removeClass('open');
                }
            dataBlock.toggleClass('hidden');
        },
        displayTaskCompletionDetailedInfo: function(e){
            var currentEl = $(e.currentTarget),
                dataBlock = currentEl.closest('tr').find('.lead-log-task-completion-info-block');

            if (dataBlock.length > 0) {
                if (dataBlock.hasClass('hidden')) {
                    currentEl.addClass('open');
                    currentEl.removeClass('closed');
                } else {
                    currentEl.addClass('closed');
                    currentEl.removeClass('open');
                }
                dataBlock.toggleClass('hidden');
            }
        },
        detailsInfoEmailConversationInfo: function(e)
        {
            var currentEl = $(e.currentTarget),
                dataBlock = currentEl.closest('tr').find('.lead-log-details-info-block-email-conversation'),
                emailReplyId = currentEl.data('email-reply-id'),
                emailBlockLink = currentEl.closest('tr').find('.lead-log-details-info'),
                self = this;

            currentEl.closest('tr').find('.lead-log-details-info-block-email-conversation').empty();

            if(dataBlock.hasClass('hidden')) {
                $.ajax({
                    'url': $('#website_url').val()+'plugin/leads/run/getEmailConversation/',
                    'type':'POST',
                    'dataType': 'json',
                    'data': {'emailReplyId':emailReplyId, 'secureToken': $('#lead-grid-token').val()}
                }).done(function(response){
                    if (response.error == '1') {
                        showMessage(response.responseText, true, 3000);
                    } else {
                        _.each(response.responseText, function(emailInfo) {
                            currentEl.closest('tr').find('.lead-log-details-info-block-email-conversation').append( _.template(LeadEmailConversationTmpl, {'emailInfo': emailInfo, 'i18n':i18n, 'moment': moment, 'userTimezoneOffset': self.leadModel.get('userTimezoneOffset')}));
                        });
                        currentEl.closest('tr').find('.lead-log-details-info-block-email-conversation').removeClass('hidden');
                        currentEl.addClass('open');
                        currentEl.removeClass('closed');
                        if (emailBlockLink && emailBlockLink.hasClass('open')) {
                            emailBlockLink.trigger('click');
                        }
                    }

                });
            } else {
                currentEl.addClass('closed');
                currentEl.removeClass('open');
            }
            dataBlock.toggleClass('hidden');
        },
        addAdditionalInfoForMeeting: function(e)
        {
            $(e.currentTarget).closest('tr').find('.lead-log-additional-info-block').toggleClass('hidden');
        },
        addAdditionalInfoForCall: function(e)
        {
            var el = $(e.currentTarget),
                data = {
                    'secureToken': $('#lead-grid-token').val(),
                    'id': el.data('call-log-id'),
                    'details': el.val()
                },
                type = 'call';


            $.ajax({
                'url': $('#website_url').val()+'api/leads/leadCall/',
                'type':'PUT',
                'dataType': 'json',
                'data': JSON.stringify(data)
            }).done(function(response){
                showMessage(response.responseText, false, 500);
                if (typeof el.data('attr-type') !== 'undefined') {
                    type = el.data('attr-type');
                }

                if (type == 'sms') {
                    if (data.details.length > 1) {
                        el.closest('td').find('.lead-call-log-additional-info-link').text(_.isUndefined(i18n['View sms']) ? 'View sms' : i18n['View sms']);
                    } else {
                        el.closest('td').find('.lead-call-log-additional-info-link').text(_.isUndefined(i18n['Add sms']) ? 'Add sms' : i18n['Add sms']);
                    }
                } else {
                    if (data.details.length > 1) {
                        el.closest('td').find('.lead-call-log-additional-info-link').text(_.isUndefined(i18n['View call notes']) ? 'View call notes' : i18n['View call notes']);
                    } else {
                        el.closest('td').find('.lead-call-log-additional-info-link').text(_.isUndefined(i18n['Add call details']) ? 'Add call details' : i18n['Add call details']);
                    }
                }
            });
        },
        changeLeadOwner: function (e) {
            var el = $(e.currentTarget),
                leadOwnerId = el.val();

            if (leadOwnerId == '0' || leadOwnerId == null)  {
                showMessage(_.isUndefined(i18n['Please choose lead owner'])?'Please choose lead owner':i18n['Please choose lead owner'], true, 5000);
                // $('.error').css({'z-index': 10000});
                return false;
            }

            $.ajax({
                'url': $('#website_url').val()+'plugin/leads/run/assignLeadOwner/',
                'type': 'POST',
                'dataType':'json',
                'data': {
                    'leadIds': el.data('lead-id'),
                    'leadOwnerId' : leadOwnerId,
                    'secureToken': $('#lead-grid-token').val()
                }
            }).done(function(response){
                if(response.error === 1){
                    showMessage(response.responseText, true, 3000);
                }else{
                    showMessage(response.responseText, false, 500);
                }
            });
        },
        completeTask: function (e) {
            var isClosed = 0,
                el = $(e.currentTarget),
                self = this,
                taskId = $(e.currentTarget).data('task-id');

            if ($(e.currentTarget).is(':checked')) {
                isClosed = 1;
            }

            if (isClosed == 1) {
                $.ajax({
                    url: $('#website_url').val()+'plugin/leads/run/getTaskInfo/taskId/'+taskId,
                    type: 'GET',
                    dataType: 'json'
                }).done(function(response) {
                    if (response.error == '0') {
                        var dialog = _.template(LeadTimelineLogTaskCompletedDialogTmpl, {
                            i18n: i18n,
                            taskTitle: response.responseText.title,
                            notificationEmails: response.responseText.notificationEmails
                        });
                        $(dialog).dialog({
                            dialogClass: 'seotoaster',
                            width: '30%',
                            resizable: false,
                            open: function (event, ui) {
                                var dialogEl = $(this);
                                $('#lead-timeline-task-completed-dialog-complete-task').on('submit', function (e) {
                                    e.preventDefault();
                                    var additionalComment = $(this).find('#lead-timeline-task-completed-dialog-comment').val(),
                                        notificationEmails = $.trim($(this).find('#lead-timeline-task-completed-dialog-emails-notify').val()).split(','),
                                        emailValidation = /^(([^<>()\[\]\.,;:\s@\"]+(\.[^<>()\[\]\.,;:\s@\"]+)*)|(\".+\"))@(([^<>()[\]\.,;:\s@\"]+\.)+[^<>()[\]\.,;:\s@\"]{2,})$/i,
                                        errorStatus = false;

                                    if (_.isEmpty(notificationEmails) || notificationEmails === '') {
                                        showMessage(_.isUndefined(i18n['Please specify email']) ? 'Please specify email' : i18n['Please specify email'], true, false);
                                        // $('.error').css({'z-index': 10000});
                                        return false;
                                    }

                                    $.each(notificationEmails, function(key, email){
                                        var status = emailValidation.test(email);
                                        if (status === false) {
                                            showMessage(_.isUndefined(i18n['Please specify valid email address']) ? 'Please specify valid email address' : i18n['Please specify valid email address'], true, false);
                                            // $('.error').css({'z-index': 10000});
                                            errorStatus = true;
                                            return false;
                                        }

                                    });

                                    if (errorStatus === false) {
                                        self.changeTaskStatus(taskId, isClosed, el, additionalComment, notificationEmails);
                                        dialogEl.dialog('destroy');
                                    }
                                });
                            },
                            close: function (event, ui) {
                                el.prop('checked', false);
                                $(this).dialog('close').remove();
                            }
                        });
                    } else {
                        el.prop('checked', false);
                        showMessage(response.responseText, true, 3000);
                    }
                });
            } else {
                showConfirm(_.isUndefined(i18n['Are you sure want to re-open task'])?'Are you sure want to re-open task':i18n['Are you sure want to re-open task'], function(){
                    self.changeTaskStatus(taskId, isClosed, el);
                }, function(){
                    el.prop('checked', true);
                });
            }


        },
        changeTaskStatus: function(taskId, isClosed, el, additionalComment, notificationEmails)
        {
            var taskReopenMessage = _.isUndefined(i18n['Check to complete task'])?'Check to complete task':i18n['Check to complete task'],
                taskCompletedMessage = _.isUndefined(i18n['Task completed'])?'Task completed':i18n['Task completed'];

            $.ajax({
                'url': $('#website_url').val()+'plugin/leads/run/changeTaskStatus/',
                'type': 'POST',
                'dataType':'json',
                'data': {'secureToken': $('#lead-grid-token').val(), 'isClosed': isClosed, 'taskId': taskId,
                    'additionalComment': additionalComment, 'notificationEmails': notificationEmails}
            }).done(function(response){
                if (response.error == '0') {
                    window.LeadDetailedView.timelineFilter.applyFilter();
                    showMessage(response.responseText, false, 500);
                } else {
                    showMessage(response.responseText, true, 3000);
                }
            });
        },
        sendNpsReviewRequest: function (e)
        {
            $.ajax({
                'url': $('#website_url').val()+'plugin/leads/run/sendNpsReviewRequest/',
                'type': 'POST',
                'dataType':'json',
                'data': {
                    'secureToken': $('#lead-grid-token').val(),
                    'leadId': this.leadModel.get('id'),
                    'sendRequestAgain' : $(e.currentTarget).data('send-request-again')
                }
            }).done(function(response){
                if (response.error == '0') {
                    var npsBlockReview =  $(document).find('#nps-and-review-request-block');

                    npsBlockReview.html(_.template(ReviewRequestViewTmpl, {'leadModel': response.responseText.leadData, 'moment': moment, 'i18n':i18n}));

                    _.each(response.responseText.leadData.reviewSystems, function(reviewPlatformName, reviewPlatform) {
                        var reviewDate = $(document).find('#review-request-date-manual-'+reviewPlatform);
                        reviewDate.datepicker({
                            dateFormat: 'd-M-yy',
                            defaultDate: "+1w",
                            changeMonth: true,
                            changeYear: true,
                            yearRange: "c-5:c+5"
                        });
                    });
                    showMessage(response.responseText.message, false, 500);
                } else {
                    showMessage(response.responseText, true, 3000);
                }
            });
        },
        sendReviewRequest: function (e)
        {
            $.ajax({
                'url': $('#website_url').val()+'plugin/leads/run/sendReviewRequest/',
                'type': 'POST',
                'dataType':'json',
                'data': {
                    'secureToken': $('#lead-grid-token').val(),
                    'leadId': this.leadModel.get('id'),
                    'sendRequestAgain' : $(e.currentTarget).data('send-request-again')
                }
            }).done(function(response){
                if (response.error == '0') {
                    var npsBlockReview =  $(document).find('#nps-and-review-request-block');
                    npsBlockReview.html(_.template(ReviewRequestViewTmpl, {'leadModel': response.responseText.leadData, 'moment': moment, 'i18n':i18n}));
                    _.each(response.responseText.leadData.reviewSystems, function(reviewPlatformName, reviewPlatform) {
                        var reviewDate = $(document).find('#review-request-date-manual-'+reviewPlatform);
                        reviewDate.datepicker({
                            dateFormat: 'd-M-yy',
                            defaultDate: "+1w",
                            changeMonth: true,
                            changeYear: true,
                            yearRange: "c-5:c+5"
                        });
                    });

                    showMessage(response.responseText.message, false, 500);
                } else {
                    showMessage(response.responseText.message, true, 3000);
                }
            });
        },
        validateLeadEmail: function(e)
        {

            var model = this.leadModel;

            $.ajax({
                'url': $('#website_url').val()+'plugin/leads/run/validateEmail/',
                'type': 'POST',
                'dataType':'json',
                'data': {
                    'secureToken': $('#lead-grid-token').val(),
                    'leadId': this.leadModel.get('id')
                }
            }).done(function(response){
                if (response.error == '0') {

                    var emailValidateDate = response.responseText.leadModel.emailValidatedDate,
                        emailValidateDatePrepared = (moment(emailValidateDate, 'YYYY-MM-DD HH:mm:ss').format('DD MMMM YYYY') === 'Invalid date') ? '': moment(emailValidateDate, 'YYYY-MM-DD HH:mm:ss').format('DD MMM YYYY'),
                        validateStatus = response.responseText.leadModel.email_validated_status,
                        emailStatusLabel = _.isUndefined(i18n['Not Validated'])?'Not Validated':i18n['Not Validated'];

                    $('#email-validated-date').text(emailValidateDatePrepared);
                    $('#email-validated-date').removeClass('hidden');

                    if (validateStatus === 'valid') {
                        emailStatusLabel = _.isUndefined(i18n['Valid'])?'Valid':i18n['Valid'];
                    }

                    if (validateStatus === 'invalid') {
                        emailStatusLabel = _.isUndefined(i18n['Invalid'])?'Invalid':i18n['Invalid']
                    }

                    if (validateStatus === 'risky') {
                        emailStatusLabel = _.isUndefined(i18n['Risky'])?'Risky':i18n['Risky']
                    }

                    model.set('email_validated_status', validateStatus);
                    model.set('email_validated_date', response.responseText.leadModel.email_validated_date);
                    model.set('email_validated_score', response.responseText.leadModel.email_validated_score);

                    $('#validate-email-status').text(emailStatusLabel+' - '+emailValidateDatePrepared+' ');
                    $('#validate-email-status').removeClass('email-validate-status-risky');
                    $('#validate-email-status').removeClass('email-validate-status-valid');
                    $('#validate-email-status').removeClass('email-validate-status-not_verified');
                    $('#validate-email-status').removeClass('email-validate-status-invalid');
                    $('#validate-email-status').addClass('email-validate-status-'+validateStatus);

                    showMessage(response.responseText.message, false, 1000);
                } else {
                    showMessage(response.responseText.message, true, 3000);
                }
            });
        },
        confirmReview: function (e)
        {
            var confirmAnswer = $(e.currentTarget).data('request-answer');
            if (confirmAnswer == '1') {
                $.ajax({
                    'url': $('#website_url').val()+'plugin/leads/run/sendNpsReviewRequest/',
                    'type': 'POST',
                    'dataType':'json',
                    'data': {'secureToken': $('#lead-grid-token').val(), 'leadId': this.leadModel.get('id')}
                }).done(function(response){
                    if (response.error == '0') {
                        var npsBlockReview =  $(document).find('#nps-and-review-request-block'),
                            fillReviewInfo = '1';


                        npsBlockReview.html(_.template(ReviewRequestViewTmpl, {'leadModel': response.responseText.leadData, 'moment': moment, 'i18n':i18n, 'fillReviewInfo': fillReviewInfo}));

                        var reviewDate = $(document).find('#review-request-date-manual');
                        reviewDate.datepicker({
                            dateFormat: 'd-M-yy',
                            defaultDate: "+1w",
                            changeMonth: true,
                            changeYear: true,
                            yearRange: "c-5:c+5"
                        });
                    }
                });
            }
        },
        saveReviewDate: function(e)
        {
            e.preventDefault();

            var el = $(e.currentTarget);

            $.ajax({
                'url': $('#website_url').val()+'plugin/leads/run/saveReviewRequestManual/',
                'type': 'POST',
                'dataType':'json',
                'data': {
                    'secureToken': $('#lead-grid-token').val(),
                    'leadId': this.leadModel.get('id'),
                    'reviewDate' : (el.val()) ? $.datepicker.formatDate('yy-mm-dd', el.datepicker("getDate")): '',
                    'reviewPlatform': el.data('platform-type')
                }
            }).done(function(response){
                if (response.error == '0') {
                    var npsBlockReview =  $(document).find('#nps-and-review-request-block');
                    npsBlockReview.html(_.template(ReviewRequestViewTmpl, {'leadModel': response.responseText.leadData, 'moment': moment, 'i18n':i18n}));
                    _.each(response.responseText.leadData.reviewSystems, function(reviewPlatformName, reviewPlatform) {
                        var reviewDate = $(document).find('#review-request-date-manual-'+reviewPlatform);
                        reviewDate.datepicker({
                            dateFormat: 'd-M-yy',
                            defaultDate: "+1w",
                            changeMonth: true,
                            changeYear: true,
                            yearRange: "c-5:c+5"
                        });
                    });

                    showMessage(response.responseText.message, false, 500);
                } else {
                    showMessage(response.responseText.message, true, 3000);
                }
            });
        },
        changeCallFromDeviceType: function (e) {
            e.preventDefault();

            var deviceTypeEl = $(e.currentTarget),
                deviceType = deviceTypeEl.val();

            $('#call-lead-action').removeClass('grid_10').addClass('grid_12');
            $('#zoiper-img').hide();

            if (deviceType === 'voip-phone') {
                $('#call-lead-action').removeClass('grid_12').addClass('grid_10');
                $('#zoiper-img').show();
            }

        },
        switchTranscriptionDetails: function (e) {

            var el = $(e.currentTarget),
                self = this,
                callLogId = $(e.currentTarget).data('call-log-id');

            $.ajax({
                url: $('#website_url').val() + 'plugin/leads/run/getLeadCallInfo/callLogId/' + callLogId,
                type: 'GET',
                dataType: 'json'
            }).done(function (response) {
                if (response.error == '0') {
                    var dialog = _.template(LeadCallTranscriptionDialogTmpl, {
                        i18n: i18n,
                        callSid: response.responseText.callSid,
                        callTranscription: response.responseText.callTranscription,
                        callTranscriptionDetails: response.responseText.callTranscriptionDetails,
                    });

                    $(dialog).dialog({
                        dialogClass: 'seotoaster',
                        width: '30%',
                        resizable: false,
                        open: function (event, ui) {
                            var dialogEl = $(this);
                        },
                        close: function (event, ui) {
                            el.prop('checked', false);
                            $(this).dialog('close').remove();
                        }
                    });
                } else {
                    el.prop('checked', false);
                    showMessage(response.responseText, true, 3000);
                }
            });
        },
        switchCallSummaryDetails: function (e) {

            var el = $(e.currentTarget),
                self = this,
                callLogId = $(e.currentTarget).data('call-log-id');

            $.ajax({
                url: $('#website_url').val() + 'plugin/leads/run/getLeadCallInfo/callLogId/' + callLogId,
                type: 'GET',
                dataType: 'json'
            }).done(function (response) {
                if (response.error == '0') {
                    var dialog = _.template(LeadCallSummaryDialogTmpl, {
                        i18n: i18n,
                        callSid: response.responseText.callSid,
                        callSummary: response.responseText.callSummary
                    });

                    $(dialog).dialog({
                        dialogClass: 'seotoaster',
                        width: '30%',
                        resizable: false,
                        open: function (event, ui) {
                            var dialogEl = $(this);
                        },
                        close: function (event, ui) {
                            el.prop('checked', false);
                            $(this).dialog('close').remove();
                        }
                    });
                } else {
                    el.prop('checked', false);
                    showMessage(response.responseText, true, 3000);
                }
            });
        },
        imapCopyPathInfo: function(e)
        {
            e.preventDefault();
            if (document.queryCommandSupported("copy")) {
                var copyFromEl = $('<textarea/>');
                copyFromEl.text($(e.currentTarget).data('element-id'));
                $('body').append(copyFromEl);
                copyFromEl.select();
                document.execCommand('copy', true);
                copyFromEl.remove();
                showMessage('Has been copied to clipboard.', false, 2000);
            }
        },
        clearInputAutocomplete:function (e) {
            var searchInput = $(e.currentTarget).closest('.search-block-element-autocomplete').find('input.search-input-autocomplete');

            if(typeof searchInput !== 'undefined') {
                searchInput.val('').focus();
                $(e.currentTarget).addClass('hidden');
            }
        },
        truncateString: function (str, num) {
            if (str.length <= num) {
                return str;
            }
            return str.slice(0, num) + '...';
        }

    });

    return LeadDetailedView;
});
