define([
    'backbone',
    '../models/lead',
    'backbone.paginator'
], function(Backbone, LeadModel){

    var LeadsCollection = Backbone.Paginator.requestPager.extend({
        model: LeadModel,
        paginator_core: {
            type: 'GET',
            dataType: 'json',
            url: function(){
                return $('#website_url').val() + 'api/leads/leads/';
            }
        },
        paginator_ui: {
            firstPage:    0,
            currentPage:  0,
            perPage:     10,
            totalPages:  10
        },
        server_api: {
            count: true,
            limit: function() { return this.perPage; },
            offset: function() { return this.currentPage * this.perPage },
            key: function(){ return this.key; },
            isGrid: function(){ return this.isGrid; },
            customPaginate: function(){ return this.customPaginate; },
            detailedInfo: function(){ return this.detailedInfo; }

        },
        parse: function(response, xhr){
            if (this.server_api.count){
                this.totalRecords = response.totalRecords;
            } else {
                this.totalRecords = response.length;
            }

            if(this.customPaginate) {
                this.perPage = this.customPaginate;
            }

            this.filterUsed = response.filterUsed;
            this.userTimezoneOffset = response.userTimezoneOffset;
            this.limitedAccess = response.limitedAccess;
            this.leadOrganizationModel = response.organizationModel;
            this.phoneCountryCodes = response.phoneCountryCodes;
            this.desktopMasks = response.desktopMasks;
            this.mobileMasks = response.mobileMasks;
            this.moneyFormat = response.moneyFormat;
            this.customerGroups = response.groups;
            this.leadStages = response.stages;
            this.leadTypes = response.types;
            this.socialServices = response.socialServices;
            this.totalPages = Math.floor(this.totalRecords / this.perPage);
            this.currentDesktopCountryCode = response.currentDesktopCountryCode;
            this.currentDesktopPhone = response.currentDesktopPhone;
            this.currentMobileCountryCode = response.currentMobileCountryCode;
            this.currentMobilePhone = response.currentMobilePhone;
            this.currentVoipPhone = response.currentVoipPhone;
            this.interactionParam = (response.interactionParam) ? response.interactionParam : '';
            return this.server_api.count ? response.data : response;
        }

    });

    return LeadsCollection;
});
