define([
    'backbone',
    'text!../templates/score-rules/score-rules-form.html',
    'text!../templates/score-rules/score-rules-field-row.html',
    '../collections/score-rules',
    'moment',
    'i18n!../../../nls/dashboard_'+$('#main-dashboard-system-language').val()+'_ln'
], function(Backbone, LeadScoreRulesFormViewTmpl, LeadScoreRulesFieldRowTmpl, LeadScoreConfigCollection, moment, i18n){
    var LeadScoreRulesView = Backbone.View.extend({
        el: $('#lead-score-form-block'),
        events: {
            'change #score-for-rules' : 'changeRule',
            'click #add-score-field-attribute': 'addField',
            'click .score-field-rules-row-delete': 'deleteFieldRow',
            'click #create-lead-score-rule': 'createScoreRule',
            'change .score-field-operator-value' : 'changeRuleOperator',
            'change #score-field-action-selection': 'getActionTypesAttributes',
            'click #add-score-action-field-attribute': 'addActionField',
            'click #close-score-config-form': 'hideShowConfigForm',
            'change .phone-countries-codes' : 'changeDesktopMask'
        },
        templates: {

        },
        initialize: function(){
            this.$el.unbind();
            this.$el = $('#lead-score-form-block');
            this.$el.attr('action', $('#website_url').val()+'api/leads/leads');

            this.scoreForm = new LeadScoreConfigCollection();
            this.scoreForm.isGrid = true;
            this.scoreForm.on('reset', this.renderConfigForm, this);
            this.scoreForm.on('add', this.renderConfigForm, this);
            this.scoreForm.on('destroy', this.renderConfigForm, this);
        },
        render: function(){
            this.scoreForm.pager();
        },
        renderConfigForm: function()
        {
            this.scoreForm.leadOwnersData = this.alphabeticalSort(this.scoreForm.leadOwners);
            this.scoreForm.lifecycleStagesData = this.scoreForm.stages;
            this.scoreForm.customerGroupsData = this.alphabeticalSort(this.scoreForm.customerGroups);
            this.scoreForm.countryCodesData = this.alphabeticalSort(this.scoreForm.countryCodes);
            this.scoreForm.industriesData = this.alphabeticalSort(this.scoreForm.industries);
            this.scoreForm.leadTagsData = this.alphabeticalSort(this.scoreForm.leadTags);
            this.scoreForm.opportunityStagesData = this.alphabeticalSort(this.scoreForm.opportunityStages);
            this.scoreForm.opportunityTypesData = this.alphabeticalSort(this.scoreForm.opportunityTypes);
            this.scoreForm.emailSequenciesData = this.alphabeticalSort(this.scoreForm.emailSequencies);

            this.$el.html(_.template(LeadScoreRulesFormViewTmpl, {
                'i18n':i18n,
                'scorePropertyActions': this.scoreForm.scorePropertyActions,
                'scoreActions' : this.scoreForm.scoreActions,
                'cronScriptPath': this.scoreForm.cronScriptPath,
                'cronScriptPathAudiences': this.scoreForm.cronScriptPathAudiences,
                'limitedAccess' : this.scoreForm.limitedAccess
            }));

        },
        hideShowConfigForm: function(e)
        {
            var el = $(e.currentTarget);

            if (el.hasClass('open')) {
                el.removeClass('open');
                el.addClass('closed');
                $('#score-conditions-block').find('.box-content').slideToggle('fast');
            } else {
                el.removeClass('closed');
                el.addClass('open');
                $('#score-conditions-block').find('.box-content').slideToggle('fast');
            }
        },
        changeRule: function(e)
        {
            var el = $(e.currentTarget),
                type = el.val(),
                self = this;

            if (el.val() == '0') {
                $('#score-field-attribute-selection-block').addClass('hidden');
                $('#score-field-action-selection-block').addClass('hidden');
                $('#score-field-action-attribute-selection-block').addClass('hidden');
                return false;
            }

            if (type === 'lead_attribute' || type === 'organization_attribute' || type === 'lead_opportunities'
                ||  type === 'lead_custom_attributes' || type === 'organization_custom_attributes') {
                this.getAttributes(type);
            } else if(type === 'action_type') {
                $('#score-field-attribute-selection-block').addClass('hidden');
                $('#score-field-action-selection-block').removeClass('hidden');
            }

        },
        getActionTypesAttributes(e) {
            var el = $(e.currentTarget),
                actionType = el.val(),
                self = this;

            if (actionType == '0') {
                $('#score-field-action-attribute-selection-block').addClass('hidden');
                return false;
            }

            $.ajax({
                url: $('#website_url').val()+'plugin/leads/run/getActionAttributesForScore',
                type: 'POST',
                data: {'actionType' : actionType, 'excludeField':'email_received_imap,email_received_imap_from'},
                dataType: 'json'
            }).done(function(response) {
                var options = '';
                $('#score-field-action-attribute-selection-block').removeClass('hidden');
                $.each(response.responseText, function(fieldValue, fieldLabel){
                    options += '<option data-field-label="'+fieldLabel+'" value="'+fieldValue+'">'+fieldLabel+'</option>';
                });
                $('#score-field-action-attribute-selection').empty().append(options);
            }).fail(function(response){
                showMessage(response.responseJSON, true, 5000);
            });
            return false;
        },
        getAttributes(type){
            var self = this;
            $.ajax({
                url: $('#website_url').val()+'plugin/leads/run/getAttributesForScore',
                type: 'POST',
                data: {'attributesType' : type},
                dataType: 'json'
            }).done(function(response) {
                $('#score-field-attribute-selection-block').removeClass('hidden');
                $('#score-field-action-selection-block').addClass('hidden');
                $('#score-field-action-attribute-selection').empty();
                $('#score-field-action-attribute-selection-block').addClass('hidden');
                var options = '';
                $.each(self.alphabeticalSort(response.responseText), function(id, fieldValue){
                    options += '<option data-field-label="'+fieldValue[1]+'" value="'+fieldValue[0]+'">'+fieldValue[1]+'</option>';
                });
                $('#score-field-attribute-selection').empty().append(options);
            }).fail(function(response){
                showMessage(response.responseJSON, true, 5000);
            });
            return false;
        },
        createScoreRule: function(e)
        {
            e.preventDefault();
            var ruleConfigBlocks = $('#score-conditions-block').find('.score-field-rule-row-block'),
                error = false,
                fieldsConfigData = [],
                self = this,
                scoreRuleName = $('#score-rule-name-general').val(),
                ruleSetScoreSign = $('#rule-set-score-sign').val(),
                ruleSetScore = parseInt($('#rule-set-score').val());



            if (ruleConfigBlocks.length === 0) {
                showMessage(_.isUndefined(i18n['Please create at least one rule']) ? 'Please create at least one rule' : i18n['Please create at least one rule'], true, false);
                return false;
            }

            $.each(ruleConfigBlocks, function(ruleConfigBlock) {
                var fieldValue = $(this).find('.score-field-rules-row-value').val(),
                    self = $(this),
                    countryCode = '';

                if($(this).data('field-name') == 'lead_phone' || $(this).data('field-name') == 'tracking_number') {
                    if($(this).find('.score-field-operator-value').val() == 'equal' || $(this).find('.score-field-operator-value').val() == 'notequal') {
                        countryCode = $('.phone-countries-codes-'+ $(this).data('field-name')).val();
                        fieldValue = fieldValue.replace(/[^0-9]/g, '');
                    } else if($(this).find('.score-field-operator-value').val() == 'in') {
                        var phoneNambers = $.trim(fieldValue).split(',');
                        if(phoneNambers.length) {
                            $.each(phoneNambers, function (key, number){
                                number = $.trim(number);

                                if(number.indexOf('+') !== 0) {
                                    showMessage($(self).data('field-name') + ' ' + (_.isUndefined(i18n[' must start with country code']) ? ' must start with country code' : i18n[' must start with country code']), true, false);
                                    error = true;
                                    return false;
                                }
                            });
                        }
                    }
                }

                fieldsConfigData.push({'field_name': $(this).data('field-name'), 'rule_comparison_operator' : $(this).find('.score-field-operator-value').val(), 'field_value' : fieldValue, 'rule_type':$(this).data('field-type'), 'rule_subtype': $(this).data('field-subtype'), 'country_code': countryCode});
            });

            if (error === true) {
                return false;
            }

            if (isNaN(ruleSetScore) || ruleSetScore === '') {
                showMessage(_.isUndefined(i18n['Please specify rule score']) ? 'Please specify rule score' : i18n['Please specify rule score'], true, false);
                return false;
            }

            if (scoreRuleName === '') {
                showMessage(_.isUndefined(i18n['Please specify rule name']) ? 'Please specify rule name' : i18n['Please specify rule name'], true, false);
                return false;
            }

            var data = {'secureToken': $('#tools-leads-grid-token').val(), 'rule_name': scoreRuleName, 'score_sign':ruleSetScoreSign, 'score':ruleSetScore, 'fieldsData' : fieldsConfigData};

            $.ajax({
                url: $('#website_url').val()+'api/leads/leadscorerules',
                type: 'POST',
                data: data,
                dataType: 'json'
            }).done(function(response) {
                self.renderConfigForm();
                self.$el.trigger('LeadScoreFormGrid:created');
                showMessage(response.responseText.message, false, 5000);
            }).fail(function(response){
                showMessage(response.responseJSON, true, 5000);
            });
            return false;
        },
        changeRuleOperator: function(e)
        {
            var el = $(e.currentTarget),
                ruleOperator = el.val(),
                valueEl = el.closest('div').find('.score-field-rules-row-value'),
                infoTooltip = window.appLeadToolsRouter.leadTooltipInfo(ruleOperator),
                rowType = el.closest('div').data('field-name'),
                placeholder = (_.isUndefined(i18n['separate the values with commas']) ? 'separate the values with commas' : i18n['separate the values with commas']),
                desctopMaskClass = '';

            el.prop('title', infoTooltip);

            if(rowType == 'lead_phone' || rowType == 'tracking_number') {
                desctopMaskClass = 'score-field-rules-row-value-desctop-mask-'+rowType;

                if(ruleOperator === 'like') {
                    placeholder = (_.isUndefined(i18n['+18774509...']) ? '+18774509...' : i18n['+18774509...']);
                    $('.score-field-rules-row-value-desctop-mask-'+rowType).prop('placeholder', placeholder);
                }

                if(ruleOperator === 'in') {
                    placeholder = (_.isUndefined(i18n['separate the values with commas and enter phone with country code ex: +18774509...']) ? 'separate the values with commas and enter phone with country code ex: +18774509...' : i18n['separate the values with commas and enter phone with country code ex: +18774509...'])
                }
            }

            if ((ruleOperator === 'in' || ruleOperator === 'notin') && (valueEl.is('input') || valueEl.is('textarea'))) {
                valueEl.replaceWith('<textarea placeholder="'+ placeholder +'" class="score-field-rules-row-value ' + desctopMaskClass + ' grid_5 alpha omega" name="'+valueEl.prop('name')+'">'+valueEl.val()+'</textarea>');
            } else if(!valueEl.is('input') && !valueEl.is('select')) {
                valueEl.replaceWith('<input type="text" '+ placeholder +' class="score-field-rules-row-value ' + desctopMaskClass + ' grid_5 alpha omega" name="'+valueEl.prop('name')+'" value="'+valueEl.val()+'" />');
            }

            /*if (valueEl.is('select') && ruleOperator === 'in') {
                //valueEl.prop('multiple', 'multiple').chosen();
            }

            if (valueEl.is('select') && ruleOperator !== 'in') {
                //valueEl.prop('multiple', '').chosen('destroy');
            }*/

            if(rowType == 'lead_phone' || rowType == 'tracking_number') {
                if(ruleOperator == 'equal' || ruleOperator == 'notequal') {
                    $('.score-field-rules-row-value-desctop-mask-'+rowType).prop('placeholder', '');

                    var desktopMasks = this.scoreForm.desktopMasks,
                        defaultDesktopCountryCode = this.scoreForm.userDefaultPhoneMobileCode,
                        selectedCountryCode = $('.phone-countries-codes-'+rowType).val();

                    if(selectedCountryCode == '' || selectedCountryCode == null) {
                        selectedCountryCode = defaultDesktopCountryCode;
                    }

                    if (typeof desktopMasks[selectedCountryCode] !== 'undefined') {
                        $('.score-field-rules-row-value-desctop-mask-'+rowType).mask(desktopMasks[selectedCountryCode].mask_value, {autoclear: false});
                    } else {
                        $('.score-field-rules-row-value-desctop-mask-'+rowType).mask('(999) 999 9999', {autoclear: false});
                    }

                    $('.phone-countries-codes-'+rowType).show();
                } else {
                    $('.phone-countries-codes-'+rowType).hide();

                    $('.score-field-rules-row-value-desctop-mask-'+rowType).unmask();
                    var valueElClean = valueEl.val().replace(/[^+0-9]/g, '');
                    $('.score-field-rules-row-value-desctop-mask-'+rowType).val(valueElClean);
                }
            }
        },
        addField: function()
        {
           var fieldName = $('#score-field-attribute-selection').val(),
               fieldLabel = $('#score-field-attribute-selection').find(':selected').data('field-label'),
               fieldType = $('#score-for-rules').val(),
               fieldKey = fieldType+'-'+fieldName.replace(/\s/g, ''),
               blockFields = false,
               customComparisonOperators = [],
               specialElType = [],
               flagMultiSelect = false,
               placeholder = '';

           if (fieldName === 'organization_employees' || fieldName === 'opportunity_amount_cumulative' || fieldName === 'opportunity_amount') {
               customComparisonOperators['greaterthan'] = _.isUndefined(i18n['Greater Than']) ? 'Greater Than' : i18n['Greater Than'];
               customComparisonOperators['lessthan'] = _.isUndefined(i18n['Less Than']) ? 'Less Than' : i18n['Less Than'];
           }

           if (fieldName === 'last_activity_inbound' || fieldName === 'last_activity_outbound' || fieldName === 'opportunity_close_date') {
               blockFields = true;
           }

           if (fieldName === 'lead_state_code' || fieldName === 'lead_position' || fieldName === 'organization_state_code' || fieldName === 'lead_phone') {
                customComparisonOperators['equal'] = _.isUndefined(i18n['Equal']) ? 'Equal' : i18n['Equal'];
                customComparisonOperators['notequal'] = _.isUndefined(i18n['Not Equal']) ? 'Not Equal' : i18n['Not Equal'];
                customComparisonOperators['like'] = _.isUndefined(i18n['Contains']) ? 'Contains' : i18n['Contains'];
                customComparisonOperators['in'] = _.isUndefined(i18n['Any']) ? 'Any' : i18n['Any'];
           }

           if ((fieldName === 'lead_customer_group_id' || fieldName === 'organization_customer_group_id') && typeof this.scoreForm.customerGroupsData !== 'undefined') {
               specialElType['elementValues'] = this.scoreForm.customerGroupsData;
               flagMultiSelect = true;
           }

           if ((fieldName === 'lead_country_code' || fieldName === 'organization_country_code') && typeof this.scoreForm.countryCodesData !== 'undefined') {
               specialElType['elementValues'] = this.scoreForm.countryCodesData;
               flagMultiSelect = true;
           }

           if ((fieldName === 'owner_id') && typeof this.scoreForm.leadOwnersData !== 'undefined') {
               specialElType['elementValues'] = this.scoreForm.leadOwnersData;
               flagMultiSelect = true;
           }

           if ((fieldName === 'stage_id') && typeof this.scoreForm.lifecycleStagesData !== 'undefined') {
               specialElType['elementValues'] = this.scoreForm.lifecycleStagesData;
               flagMultiSelect = true;
           }

           if ((fieldName === 'lead_tags') && typeof this.scoreForm.leadTagsData !== 'undefined') {
               specialElType['elementValues'] = this.scoreForm.leadTagsData;
               flagMultiSelect = true;
           }

            if ((fieldName === 'organization_industry_id') && typeof this.scoreForm.industriesData !== 'undefined') {
                specialElType['elementValues'] = this.scoreForm.industriesData;
                flagMultiSelect = true;
            }

           if ((fieldName === 'opportunity_stage') && typeof this.scoreForm.opportunityStagesData !== 'undefined') {
               specialElType['elementValues'] = this.scoreForm.opportunityStagesData;
               flagMultiSelect = true;
           }

           if ((fieldName === 'opportunity_type') && typeof this.scoreForm.opportunityTypesData !== 'undefined') {
               specialElType['elementValues'] = this.scoreForm.opportunityTypesData;
               flagMultiSelect = true;
           }

           if (flagMultiSelect === true) {
               specialElType['elementType'] = 'multiselect';
               customComparisonOperators['in'] = _.isUndefined(i18n['Any']) ? 'Any' : i18n['Any'];
               customComparisonOperators['notin'] = _.isUndefined(i18n['Excluding']) ? 'Excluding' : i18n['Excluding'];
           }

           if (fieldName === 'lead_state_code' || fieldName === 'organization_state_code') {
               placeholder = (_.isUndefined(i18n['Ex: AL']) ? 'Ex: AL' : i18n['Ex: AL']);
           }

           if (fieldName === 'last_activity_inbound') {
               specialElType['elementType'] = 'select';
               specialElType['elementValues'] = this.scoreForm.leadsPredefinedValues['last_activity_inbound'];
               customComparisonOperators['equal'] = _.isUndefined(i18n['Equal']) ? 'Equal' : i18n['Equal'];
           }

            if (fieldName === 'last_activity_outbound') {
                specialElType['elementType'] = 'select';
                specialElType['elementValues'] = this.scoreForm.leadsPredefinedValues['last_activity_outbound'];
                customComparisonOperators['equal'] = _.isUndefined(i18n['Equal']) ? 'Equal' : i18n['Equal'];
            }

           if (fieldName === 'opportunity_close_date') {
               specialElType['elementType'] = 'select';
               specialElType['elementValues'] = this.scoreForm.leadsPredefinedValues['opportunity_close_date'];
               customComparisonOperators['equal'] = _.isUndefined(i18n['Equal']) ? 'Equal' : i18n['Equal'];
           }

           if (fieldName === 'lead_source') {
               customComparisonOperators['like'] = _.isUndefined(i18n['Contains']) ? 'Contains' : i18n['Contains'];
           }

           $('#score-field-rules-configuration-block-label').removeClass('hidden');
           if ($('#score-field-rule-row-block-'+fieldKey).length == '0') {
               $('#score-field-rules-configuration-block-rows').append( _.template(LeadScoreRulesFieldRowTmpl, {
                   'fieldKey': fieldKey,
                   'fieldName': fieldName,
                   'fieldLabel':fieldLabel,
                   'fieldType':fieldType,
                   'fieldSubtype': '',
                   'moment': moment,
                   'i18n':i18n,
                   'blockFields': blockFields,
                   'customComparisonOperators': customComparisonOperators,
                   'specialElType': specialElType,
                   'placeholder' : placeholder,
                   'phoneCountryCodes' : this.scoreForm.phoneCountryCodes,
                   'defaultDesktopCountryCode' : this.scoreForm.userDefaultPhoneMobileCode
               }));

               var desktopMasks = this.scoreForm.desktopMasks,
                   defaultDesktopCountryCode = this.scoreForm.userDefaultPhoneMobileCode;

               if (typeof desktopMasks[defaultDesktopCountryCode] !== 'undefined') {
                   $('.score-field-rules-row-value-desctop-mask-'+fieldName).mask(desktopMasks[defaultDesktopCountryCode].mask_value, {autoclear: true});
               } else {
                   $('.score-field-rules-row-value-desctop-mask-'+fieldName).mask('(999) 999 9999', {autoclear: false});
               }

               if (flagMultiSelect === true) {
                   $('#score-field-rule-row-block-'+fieldKey).find('.score-field-rules-row-value').chosen();
               }

           } else {
               showMessage(_.isUndefined(i18n['Field already exists']) ? 'Field already exists' : i18n['Field already exists'], true, 5000);
           }
        },
        addActionField: function()
        {
            var fieldName = $('#score-field-action-attribute-selection').val(),
                fieldSubtype = $('#score-field-action-selection').val(),
                fieldLabel = $('#score-field-action-attribute-selection').find(':selected').data('field-label'),
                fieldType = $('#score-for-rules').val(),
                blockFields = false,
                customComparisonOperators = [],
                fieldKey = fieldName.replace(/\s/g, '')+fieldSubtype.replace(/\s/g, ''),
                placeholder = '',
                specialElType = [],
                flagMultiSelect = false;

            if (fieldName === 'quote_requested' || fieldName === 'quote_view' || fieldName === 'registered' || fieldName === 'quote_sent' || fieldName === 'website_last_action_date_time') {
                blockFields = true;
            }

            if (fieldName === 'duration_placed' || fieldName === 'duration_received'
                || fieldName === 'purchase_amount_single' || fieldName === 'purchase_amount_cumulative' || fieldName === 'visit_duration'
                || fieldName === 'visit_duration_latest' || fieldName === 'action_number'
                || fieldName === 'action_number_latest' || fieldName === 'quote_amount_single'
            || fieldName === 'quote_amount_cumulative' || fieldName === 'email_sent' || fieldName === 'email_received') {
                customComparisonOperators['greaterthan'] = _.isUndefined(i18n['Greater Than']) ? 'Greater Than' : i18n['Greater Than'];
                customComparisonOperators['lessthan'] = _.isUndefined(i18n['Less Than']) ? 'Less Than' : i18n['Less Than'];
            }

            if (fieldName === 'email_opened') {
                customComparisonOperators['equal'] = _.isUndefined(i18n['Equal']) ? 'Equal' : i18n['Equal'];
                placeholder = (_.isUndefined(i18n['Opened \'Number of days\' ago']) ? 'Opened \'Number of days\' ago' : i18n['Opened \'Number of days\' ago']);
            }

            if (fieldName === 'email_link_clicked') {
                customComparisonOperators['equal'] = _.isUndefined(i18n['Equal']) ? 'Equal' : i18n['Equal'];
                placeholder = (_.isUndefined(i18n['Clicked \'Number of days\' ago']) ? 'Clicked \'Number of days\' ago' : i18n['Clicked \'Number of days\' ago']);
            }

            if (fieldName === 'email_link_clicked_in_sequence') {
                specialElType['elementValues'] = this.scoreForm.emailSequenciesData;
                flagMultiSelect = true;
            }

            if (fieldName === 'duration_placed' || fieldName === 'duration_received' || fieldName === 'visit_duration' || fieldName === 'visit_duration_latest') {
                placeholder = (_.isUndefined(i18n['in seconds']) ? 'in seconds' : i18n['in seconds']);
            }

            if (fieldName === 'purchase_products_sku') {
                customComparisonOperators['in'] = _.isUndefined(i18n['Any']) ? 'Any' : i18n['Any'];
                customComparisonOperators['notin'] = _.isUndefined(i18n['Excluding']) ? 'Excluding' : i18n['Excluding'];
                specialElType['elementType'] = 'textarea';
            }

            if (fieldName === 'file_name' || fieldName === 'tracking_number') {
                customComparisonOperators['equal'] = _.isUndefined(i18n['Equal']) ? 'Equal' : i18n['Equal'];
                customComparisonOperators['notequal'] = _.isUndefined(i18n['Not Equal']) ? 'Not Equal' : i18n['Not Equal'];
                customComparisonOperators['like'] = _.isUndefined(i18n['Contains']) ? 'Contains' : i18n['Contains'];
                customComparisonOperators['in'] = _.isUndefined(i18n['Any']) ? 'Any' : i18n['Any'];
            }

            if (fieldName === 'website_last_action_date_time') {
                specialElType['elementType'] = 'select';
                specialElType['elementValues'] = this.scoreForm.leadsPredefinedValues['website_last_action_date_time'];
                customComparisonOperators['equal'] = _.isUndefined(i18n['Equal']) ? 'Equal' : i18n['Equal'];
            }

            if (fieldName === 'quote_view' || fieldName === 'quote_requested' || fieldName === 'registered' || fieldName === 'quote_sent') {
                specialElType['elementType'] = 'select';
                specialElType['elementValues'] = this.scoreForm.leadsPredefinedValues['yes_no_block'];
                customComparisonOperators['equal'] = _.isUndefined(i18n['Equal']) ? 'Equal' : i18n['Equal'];
            }

            if (fieldName === 'quote_expiration_date') {
                specialElType['elementType'] = 'select';
                specialElType['elementValues'] = this.scoreForm.leadsPredefinedValues['quote_expiration_date'];
                customComparisonOperators['equal'] = _.isUndefined(i18n['Equal']) ? 'Equal' : i18n['Equal'];
            }

            if (fieldName === 'sms_keyword_sent' || fieldName === 'sms_keyword_received'  || fieldName === 'transcribed_conversation') {
                customComparisonOperators['like'] = _.isUndefined(i18n['Contains']) ? 'Contains' : i18n['Contains'];
            }

            if (flagMultiSelect === true) {
                specialElType['elementType'] = 'multiselect';
                customComparisonOperators['in'] = _.isUndefined(i18n['Any']) ? 'Any' : i18n['Any'];
                customComparisonOperators['notin'] = _.isUndefined(i18n['Excluding']) ? 'Excluding' : i18n['Excluding'];
            }

            if (fieldName === 'email_link_clicked_in_sequence') {
                customComparisonOperators = [];
                customComparisonOperators['in'] = _.isUndefined(i18n['Any']) ? 'Any' : i18n['Any'];
            }

            $('#score-field-rules-configuration-block-label').removeClass('hidden');
            if ($('#score-field-rule-row-block-'+fieldKey).length == '0') {
                $('#score-field-rules-configuration-block-rows').append( _.template(LeadScoreRulesFieldRowTmpl, {
                    'fieldKey': fieldKey,
                    'fieldName': fieldName,
                    'fieldLabel':fieldLabel,
                    'fieldType':fieldType,
                    'fieldSubtype': fieldSubtype,
                    'moment': moment,
                    'i18n':i18n,
                    'blockFields': blockFields,
                    'customComparisonOperators': customComparisonOperators,
                    'placeholder': placeholder,
                    'specialElType': specialElType,
                    'phoneCountryCodes' : this.scoreForm.phoneCountryCodes,
                    'defaultDesktopCountryCode' : this.scoreForm.userDefaultPhoneMobileCode
                }));

                if (flagMultiSelect === true) {
                    $('#score-field-rule-row-block-'+fieldKey).find('.score-field-rules-row-value').chosen();
                }

                var desktopMasks = this.scoreForm.desktopMasks,
                    defaultDesktopCountryCode = this.scoreForm.userDefaultPhoneMobileCode;

                if (typeof desktopMasks[defaultDesktopCountryCode] !== 'undefined') {
                    $('.score-field-rules-row-value-desctop-mask-'+fieldName).mask(desktopMasks[defaultDesktopCountryCode].mask_value, {autoclear: true});
                } else {
                    $('.score-field-rules-row-value-desctop-mask-'+fieldName).mask('(999) 999 9999', {autoclear: false});
                }
            } else {
                showMessage(_.isUndefined(i18n['Field already exists']) ? 'Field already exists' : i18n['Field already exists'], true, 5000);
            }
        },
        deleteFieldRow: function(e)
        {
            e.preventDefault();
            showConfirm(_.isUndefined(i18n['Are you sure want to delete?']) ? 'Are you sure want to delete?' : i18n['Are you sure want to delete?'], function () {
                $(e.currentTarget).closest('.score-field-rule-row-block').remove();
            });

        },
        alphabeticalSort: function(obj){
            // convert object into array
            var sortable=[];
            for(var key in obj)
                if(obj.hasOwnProperty(key))
                    sortable.push([key, obj[key]]); // each item is an array in format [key, value]

            // sort items by value
            sortable.sort(function(a, b)
            {
                var x=a[1].toLowerCase(),
                    y=b[1].toLowerCase();
                return x<y ? -1 : x>y ? 1 : 0;
            });
            return sortable; // array in format [ [ key1, val1 ], [ key2, val2 ], ... ]
        },
        changeDesktopMask: function(e)
        {
            var selectionType = $(e.currentTarget).data('type'),
                fieldName = $(e.currentTarget).data('field-name'),
                value =  $(e.currentTarget).val();

            var //mobileMasks = this.workflowForm.mobileMasks,
                desktopMasks = this.scoreForm.desktopMasks;

            if (selectionType === 'mobile') {
                /*if (typeof mobileMasks[value] !== 'undefined') {
                    $('.lead-mobile-detailed-view').mask(mobileMasks[value].mask_value, {autoclear: false});
                } else {
                    $('.lead-mobile-detailed-view').mask('(999) 999 9999', {autoclear: false});
                }*/
            }

            if (selectionType === 'desktop') {
                if (typeof desktopMasks[value] !== 'undefined') {
                    $('.score-field-rules-row-value-desctop-mask-'+fieldName).mask(desktopMasks[value].mask_value, {autoclear: false});
                } else {
                    $('.score-field-rules-row-value-desctop-mask-'+fieldName).mask('(999) 999 9999', {autoclear: false});
                }
            }
        },
    });

    return LeadScoreRulesView;
});
