define([
    'backbone',
    'text!../templates/lead-workflows/workflow-rules-form.html',
    'text!../templates/lead-workflows/workflow-rules-field-row.html',
    'text!../templates/lead-workflows/workflow-rules-field-score-row.html',
    '../collections/lead-workflows',
    'moment',
    'i18n!../../../nls/dashboard_'+$('#main-dashboard-system-language').val()+'_ln',
    'tinyMCE',
    'leadshortcode',
], function(Backbone, LeadWorkflowFormViewTmpl, LeadWorkflowFieldRowTmpl, LeadWorkflowFieldScoreRowTmpl, LeadWorkflowCollection, moment, i18n, tinymce, leadshortcode){
    var LeadWorkflowRulesView = Backbone.View.extend({
        el: $('#lead-workflow-form-block'),
        events: {
            'change #score-for-rules' : 'changeRule',
            'click #add-score-field-attribute': 'addField',
            'click .score-field-rules-row-delete': 'deleteFieldRow',
            'click #create-lead-score-rule': 'createScoreRule',
            'change .score-field-operator-value' : 'changeRuleOperator',
            'change #score-field-action-selection': 'getActionTypesAttributes',
            'click #add-score-action-field-attribute': 'addActionField',
            'click #close-score-config-form': 'hideShowConfigForm',
            'change #form-action-assign-task-immediate': 'switchImmediate',
            'change #form-action-assign-task-number-of-before-action-units': 'switchTaskUnits',
            'change #form-action-assign-task-due-number-of-before-action-units': 'switchTaskDueUnits',
            'click input.switcher' : 'switcherAction',
            'change #marketing-services': 'getServicesLists',
            'click #form-actions-list-block li a': 'changeFormAction',
            'change .phone-countries-codes' : 'changeDesktopMask',
            'change #marketing-campaigns': 'getMarketingCampaigns',
            'click #add-list-form-save': 'createNewAdList',
            'change #form-action-assign-task-preset-to':'changeTaskPreset'
        },
        templates: {

        },
        beforeSelectedCampaign: {
            'campaign': ''
        },
        campaignSelectedListsIds: {},
        campaignSelectedListsLabels: {},
        initialize: function(){
            this.$el.unbind();
            this.$el = $('#lead-workflow-form-block');
            this.$el.attr('action', $('#website_url').val()+'api/leads/leads');

            this.workflowForm = new LeadWorkflowCollection();
            this.workflowForm.isGrid = true;
            this.workflowForm.on('reset', this.renderConfigForm, this);
            this.workflowForm.on('add', this.renderConfigForm, this);
            this.workflowForm.on('destroy', this.renderConfigForm, this);
        },
        render: function(){
            this.workflowForm.pager();
        },
        renderConfigForm: function()
        {
            this.workflowForm.taskPresetsList = this.alphabeticalSort(this.workflowForm.taskPresets);
            this.workflowForm.leadOwnersData = this.alphabeticalSort(this.workflowForm.leadOwners);
            this.workflowForm.lifecycleStagesData = this.workflowForm.stages;
            this.workflowForm.customerGroupsData = this.alphabeticalSort(this.workflowForm.customerGroups);
            this.workflowForm.countryCodesData = this.alphabeticalSort(this.workflowForm.countryCodes);
            this.workflowForm.formsData = this.alphabeticalSort(this.workflowForm.forms);
            this.workflowForm.industriesData = this.alphabeticalSort(this.workflowForm.industries);
            this.workflowForm.leadTagsData = this.alphabeticalSort(this.workflowForm.leadTags);
            this.workflowForm.opportunityStagesData = this.alphabeticalSort(this.workflowForm.opportunityStages);
            this.workflowForm.opportunityTypesData = this.alphabeticalSort(this.workflowForm.opportunityTypes);
            this.workflowForm.emailSequenciesData = this.alphabeticalSort(this.workflowForm.emailSequencies);
            this.workflowForm.emailTemplatesData = this.alphabeticalSort(this.workflowForm.emailTemplates);
            tinymce.remove();
            this.$el.empty();
            this.$el.html(_.template(LeadWorkflowFormViewTmpl, {
                'i18n':i18n,
                'scorePropertyActions': this.workflowForm.scorePropertyActions,
                'taskPresetsList': this.workflowForm.taskPresetsList,
                'scoreActions' : this.workflowForm.scoreActions,
                'cronScriptPath': this.workflowForm.cronScriptPath,
                'cronScriptPathAudiences': this.workflowForm.cronScriptPathAudiences,
                'leadOwners': this.workflowForm.leadOwnersData,
                'userTimezone':this.workflowForm.userTimezone,
                'timezoneOffset':this.workflowForm.userTimezoneOffset,
                'currentUserId':this.workflowForm.currentUserId,
                'leadTags':this.workflowForm.leadTagsData,
                'lifecycleStages':this.workflowForm.lifecycleStagesData,
                'emailSequencies':this.workflowForm.emailSequenciesData,
                'emailServices':this.workflowForm.emailServices,
                'emailTemplates':this.workflowForm.emailTemplatesData,
                'limitedAccess' : this.workflowForm.limitedAccess,
                'advertisingList' : this.workflowForm.advertisingList
            }));

            $('#select-assign-lead-tags').chosen();
            $('#select-remove-lead-tags').chosen();
        },
        changeTaskPreset: function(e) {
            var taskPresets = this.workflowForm.taskPresetsFull,
                chosenPresetId = $(e.currentTarget).val();
            if (taskPresets.hasOwnProperty(chosenPresetId) === true) {
                $('#form-action-assign-task-title').val(taskPresets[chosenPresetId]['task_title']);
            } else {
                $('#form-action-assign-task-title').val('');
            }
        },
        hideShowConfigForm: function(e)
        {
            var el = $(e.currentTarget);

            if (el.hasClass('open')) {
                el.removeClass('open');
                el.addClass('closed');
                $('#score-conditions-block').find('.box-content').slideToggle('fast');
            } else {
                el.removeClass('closed');
                el.addClass('open');
                $('#score-conditions-block').find('.box-content').slideToggle('fast');
            }
        },
        changeRule: function(e)
        {
            var el = $(e.currentTarget),
                type = el.val(),
                self = this;

            if (el.val() == '0') {
                $('#score-field-attribute-selection-block').addClass('hidden');
                $('#score-field-action-selection-block').addClass('hidden');
                $('#score-field-action-attribute-selection-block').addClass('hidden');
                return false;
            }

            if (type === 'lead_attribute' || type === 'organization_attribute' || type === 'lead_opportunities'
                ||  type === 'lead_custom_attributes' || type === 'organization_custom_attributes' || type === 'form_name') {
                this.getAttributes(type);
            } else if(type === 'action_type') {
                $('#score-field-attribute-selection-block').addClass('hidden');
                $('#score-field-action-selection-block').removeClass('hidden');
            }

        },
        getActionTypesAttributes(e) {
            var el = $(e.currentTarget),
                actionType = el.val(),
                self = this;

            if (actionType == '0') {
                $('#score-field-action-attribute-selection-block').addClass('hidden');
                return false;
            }

            $.ajax({
                url: $('#website_url').val()+'plugin/leads/run/getActionAttributesForScore',
                type: 'POST',
                data: {'actionType' : actionType},
                dataType: 'json'
            }).done(function(response) {
                var options = '';
                $('#score-field-action-attribute-selection-block').removeClass('hidden');
                $.each(response.responseText, function(fieldValue, fieldLabel){
                    options += '<option data-field-label="'+fieldLabel+'" value="'+fieldValue+'">'+fieldLabel+'</option>';
                });
                $('#score-field-action-attribute-selection').empty().append(options);
            }).fail(function(response){
                showMessage(response.responseJSON, true, 5000);
            });
            return false;
        },
        getAttributes(type){
            var self = this;
            $.ajax({
                url: $('#website_url').val()+'plugin/leads/run/getAttributesForScore',
                type: 'POST',
                data: {'attributesType' : type},
                dataType: 'json'
            }).done(function(response) {
                $('#score-field-attribute-selection-block').removeClass('hidden');
                $('#score-field-action-selection-block').addClass('hidden');
                $('#score-field-action-attribute-selection').empty();
                $('#score-field-action-attribute-selection-block').addClass('hidden');
                var options = '';
                $.each(self.alphabeticalSort(response.responseText), function(id, fieldValue){
                    options += '<option data-field-label="'+fieldValue[1]+'" value="'+fieldValue[0]+'">'+fieldValue[1]+'</option>';
                });
                $('#score-field-attribute-selection').empty().append(options);
            }).fail(function(response){
                showMessage(response.responseJSON, true, 5000);
            });
            return false;
        },
        createScoreRule: function(e)
        {
            e.preventDefault();

            var ruleConfigBlocks = $('#score-conditions-block').find('.score-field-rule-row-block'),
                self = this,
                scoreRuleName = $('#score-rule-name-general').val(),
                ruleSetScoreSign = $('#workflow-set-score-sign').val(),
                ruleSetScore = parseInt($('#workflow-score-value').val()),
                actionSwitchers = $('#form-actions-list-block').find('input.switcher'),
                switchersChosen = false,
                error = false,
                fieldsConfigData = [],
                actionsData = [],
                assignLeadOwnerId = $('#select-assign-lead-owner').val(),
                assignTaskBy = $('#form-action-assign-task-by').val(),
                assignTaskTo = $('#form-action-assign-task-to').val(),
                assignTaskNotes = $('#form-action-assign-task-notes-workflow').val(),
                assignTaskTitle = $('#form-action-assign-task-title').val(),
                assignTaskStartTime = $('#lead-task-start-time').val(),
                assignTaskDueTime = $('#lead-task-due-time').val(),
                taskDelayDueUnits = $('#form-action-assign-task-due-number-of-before-action-units').val(),
                taskDueDelay= parseInt($('#form-action-assign-task-due-number-of-before-action').val()),
                taskImmediate = 0,
                taskDelayUnits = $('#form-action-assign-task-number-of-before-action-units').val(),
                taskDelay= parseInt($('#form-action-assign-task-number-of-before-action').val()),
                taskTimezone = $('#user-task-timezone').val(),
                assignTaskStart = 0,
                assignDueTime = 0,
                userTimezoneOffset = $('#task-rule-user-timezone-offset').val(),
                tagIds =  $('#select-assign-lead-tags').val(),
                removeTagIds =  $('#select-remove-lead-tags').val(),
                lifeCycleId = $('#select-assign-lead-lifecycle').val(),
                sequenceId = $('#select-assign-lead-sequence').val(),
                triggerNewLeadOnly = 0,
                unassignSequence = 0,
                emailsToCopyRow = self.$el.find('#email-copy-emails').val(),
                emailsToCopyFrom = self.$el.find('#email-copy-from').val(),
                emailsToCopySubject = self.$el.find('#email-copy-subject').val(),
                emailsToCopyTemplate = self.$el.find('#select-email-copy-template').val(),
                emailsToCopyMessage = self.$el.find('#copy-email-message-workflow').val(),
                emailServiceName = $("#marketing-services").val(),
                checkedLists = $('#subscribe-list').find("input.subscribe-to-email-service-list:checked"),
                remarketingServiceName = $("#marketing-campaigns").val(),
                checkedRemarketingLists = $('#subscribe-remarketing-list').find("input.subscribe-to-remarketing-list:checked");


            if (ruleConfigBlocks.length === 0) {
                showMessage(_.isUndefined(i18n['Please create at least one rule']) ? 'Please create at least one rule' : i18n['Please create at least one rule'], true, false);
                return false;
            }

            $.each(ruleConfigBlocks, function(ruleConfigBlock) {
                var fieldValue = $(this).find('.score-field-rules-row-value').val(),
                    self = $(this),
                    countryCode = '';

                if($(this).data('field-name') == 'lead_phone' || $(this).data('field-name') == 'tracking_number') {
                    if($(this).find('.score-field-operator-value').val() == 'equal' || $(this).find('.score-field-operator-value').val() == 'notequal') {
                        countryCode = $('.phone-countries-codes-'+ $(this).data('field-name')).val();
                        fieldValue = fieldValue.replace(/[^0-9]/g, '');
                    } else if($(this).find('.score-field-operator-value').val() == 'in') {
                        var phoneNambers = $.trim(fieldValue).split(',');
                        if(phoneNambers.length) {
                            $.each(phoneNambers, function (key, number){
                                number = $.trim(number);

                                if(number.indexOf('+') !== 0) {
                                    showMessage($(self).data('field-name') + ' ' + (_.isUndefined(i18n[' must start with country code']) ? ' must start with country code' : i18n[' must start with country code']), true, false);
                                    error = true;
                                    return false;
                                }
                            });
                        }
                    }
                }

                fieldsConfigData.push({'field_name': $(this).data('field-name'), 'rule_comparison_operator' : $(this).find('.score-field-operator-value').val(), 'field_value' : fieldValue, 'rule_type':$(this).data('field-type'), 'rule_subtype': $(this).data('field-subtype'), 'country_code': countryCode});
            });

            if (error === true) {
                return false;
            }

            if (isNaN(ruleSetScore) || ruleSetScore === '') {
                ruleSetScore = '';
            }

            if (scoreRuleName === '') {
                showMessage(_.isUndefined(i18n['Please specify rule name']) ? 'Please specify rule name' : i18n['Please specify rule name'], true, false);
                return false;
            }

            $.each(actionSwitchers, function(switcher) {
                if ($(this).is(':checked') === true) {
                    var actionType = $(this).data('action-type');
                    switchersChosen = true;
                    if (actionType === 'assign_owner') {
                        if (assignLeadOwnerId == '0') {
                            showMessage(_.isUndefined(i18n['Please choose lead owner for the assign owner action']) ? 'Please choose lead owner for the assign owner action' : i18n['Please choose lead owner for the assign owner action'], true, false);
                            error = true;
                            return false;
                        } else {
                            triggerNewLeadOnly = 0;
                            if ($('#assign-lead-owner-only-for-new-lead').is(':checked')) {
                                triggerNewLeadOnly = 1;
                            }
                            actionsData.push({'assign_to' : assignLeadOwnerId, 'actionType': actionType, 'triggerNewLeadOnly': triggerNewLeadOnly});
                        }
                    }

                    if (actionType === 'assign_task') {

                        if (assignTaskTitle === '') {
                            showMessage(_.isUndefined(i18n['Please provide task title']) ? 'Please provide task title' : i18n['Please provide task title'], true, false);
                            error = true;
                            return false;
                        }

                        if (taskDueDelay === '' || _.isNaN(taskDueDelay)) {
                            showMessage(_.isUndefined(i18n['Please specify due delay']) ? 'Please specify due delay' : i18n['Please specify due delay'], true, false);
                            error = true;
                            return false;
                        }

                        if (assignTaskDueTime === '' || _.isNaN(assignTaskDueTime)) {
                            showMessage(_.isUndefined(i18n['Please specify task due time']) ? 'Please specify task due time' : i18n['Please specify task due time'], true, false);
                            error = true;
                            return false;
                        }

                        if ($('#form-action-assign-task-immediate').is(':checked')) {
                            taskImmediate = 1;
                        } else if (isNaN(taskDelay)) {
                            showMessage(_.isUndefined(i18n['Please enter task delay amount']) ? 'Please enter task delay amount' : i18n['Please enter task delay amount'], true, false);
                            error = true;
                            return false;
                        }

                        if (assignTaskStartTime.length == 1) {
                            assignTaskStart = '0' + assignTaskStartTime+':00:00';
                        } else {
                            assignTaskStart = assignTaskStartTime+':00:00';
                        }

                        if (assignTaskDueTime.length == 1) {
                            assignDueTime = '0' + assignTaskDueTime+':00:00';
                        } else {
                            assignDueTime = assignTaskDueTime+':00:00';
                        }

                        triggerNewLeadOnly = 0;
                        if ($('#assign-task-only-for-new-lead').is(':checked')) {
                            triggerNewLeadOnly = 1;
                        }

                        actionsData.push({
                            'actionType': actionType,
                            'creator_id': assignTaskBy,
                            'user_id': assignTaskTo,
                            'notes': assignTaskNotes,
                            'title': assignTaskTitle,
                            'taskImmediate': taskImmediate,
                            'taskDelayUnits': taskDelayUnits,
                            'taskDelay': taskDelay,
                            'assignTaskDueTime': assignTaskDueTime,
                            'taskDueDelay': taskDueDelay,
                            'taskDelayDueUnits': taskDelayDueUnits,
                            'assignTaskTime': assignTaskStart,
                            'assignDueTime': assignDueTime,
                            'assignTaskStartTime': assignTaskStartTime,
                            'taskTimezone' : taskTimezone,
                            'userTimezoneOffset' : userTimezoneOffset,
                            'triggerNewLeadOnly' : triggerNewLeadOnly
                        });
                    }

                    if (actionType === 'send_review_request') {
                        actionsData.push({'actionType': actionType, 'sendReviewRequest':'1'});
                    }

                    if (actionType === 'assign_tags') {
                        if (tagIds.length === 0 && removeTagIds.length === 0) {
                            showMessage(_.isUndefined(i18n['Please choose at least one tag']) ? 'Please choose at least one tag' : i18n['Please choose at least one tag'], true, false);
                            error = true;
                            return false;
                        } else {
                            triggerNewLeadOnly = 0;
                            if ($('#assign-tags-only-for-new-lead').is(':checked')) {
                                triggerNewLeadOnly = 1;
                            }
                            actionsData.push({'tagIds' : tagIds, 'removeTagIds': removeTagIds,'actionType': actionType, 'triggerNewLeadOnly':triggerNewLeadOnly});
                        }
                    }

                    if (actionType === 'assign_lifecycle') {
                        if (lifeCycleId == '0') {
                            showMessage(_.isUndefined(i18n['Please choose lifecycle']) ? 'Please choose lifecycle' : i18n['Please choose lifecycle'], true, false);
                            error = true;
                            return false;
                        } else {
                            triggerNewLeadOnly = 0;
                            if ($('#assign-lifecycle-only-for-new-lead').is(':checked')) {
                                triggerNewLeadOnly = 1;
                            }
                            actionsData.push({'lifecycleId' : lifeCycleId, 'actionType': actionType, 'triggerNewLeadOnly':triggerNewLeadOnly});
                        }
                    }
                    if (actionType === 'assign_sequence') {
                        if (sequenceId == '0') {
                            showMessage(_.isUndefined(i18n['Please choose email/sms sequence']) ? 'Please choose email/sms sequence' : i18n['Please choose email/sms sequence'], true, false);
                            error = true;
                            return false;
                        } else {
                            triggerNewLeadOnly = 0;
                            if ($('#assign-sequence-only-for-new-lead').is(':checked')) {
                                triggerNewLeadOnly = 1;
                            }
                            unassignSequence = 0;
                            if ($('#unassign-sequence').is(':checked')) {
                                unassignSequence = 1;
                            }
                            actionsData.push({'sequenceId' : sequenceId, 'actionType': actionType, 'triggerNewLeadOnly':triggerNewLeadOnly, 'unassignSequence':unassignSequence});
                        }
                    }
                    if(actionType === 'assign_email_list') {
                        if(emailServiceName == 'select'){
                            showMessage(_.isUndefined(i18n['Please choose service'])?'Please choose service':i18n['Please choose service'], true, 5000);
                            error = true;
                            return false;
                        }
                        var lists = [];
                        var listsLabels = [];
                        var listsToString = '',
                            unsubscribe = 0;

                        if ($('#unsubscribe-email-marketing').is(':checked')) {
                            unsubscribe = 1;
                        }

                        if(checkedLists.length > 0){
                            checkedLists.each(function(key, value) {
                                lists.push($(this).val());
                                listsLabels.push($(this).data('list-name'));
                            });
                            listsToString = lists.join(',');
                            listsLabels = listsLabels.join(',');
                        }

                        var requestType = 'assign';
                        if ($('#unassign-email-marketing').is(':checked')) {
                            requestType = 'unassign';
                        }

                        actionsData.push({
                            'actionType': actionType,
                            'type': 'email',
                            'serviceName' : emailServiceName,
                            'lists' : listsToString,
                            'listsLabels' : listsLabels,
                            'requestType' : requestType,
                            'unsubscribe' : unsubscribe
                        });
                    }

                    if(actionType === 'assign_remarketing_list') {
                        if(remarketingServiceName == 'select'){
                            showMessage(_.isUndefined(i18n['Please choose remarketing service'])?'Please choose remarketing service':i18n['Please choose remarketing service'], true, 5000);
                            error = true;
                            return false;
                        }

                        self.campaignSelectedListsIds[remarketingServiceName] = [];
                        self.campaignSelectedListsLabels[remarketingServiceName] = [];

                        var lists = [],
                            audinceListsIds = [],
                            audinceListsLabels = [];

                        checkedRemarketingLists.each(function() {
                            var listId = $(this).val(),
                                listLabel = $(this).data('label');
                            audinceListsIds.push(listId);
                            audinceListsLabels.push(listLabel);
                        });

                        self.campaignSelectedListsIds[remarketingServiceName] = audinceListsIds;
                        self.campaignSelectedListsLabels[remarketingServiceName] = audinceListsLabels;

                        lists['ids'] = self.campaignSelectedListsIds;
                        lists['names'] = self.campaignSelectedListsLabels;

                        var requestType = 'assign';
                        if ($('#unassign-remarketing').is(':checked')) {
                            requestType = 'unassign';
                        }

                        actionsData.push({'actionType': actionType, 'serviceName' : remarketingServiceName, 'lists' : JSON.stringify(lists['ids']), 'listsLabels' : JSON.stringify(lists['names']), 'requestType' : requestType});
                    }

                    if (actionType === 'assign_email_copy') {
                        var emailsToCopy = $.trim(emailsToCopyRow).split(',');
                        var emailValidation = /^(([^<>()\[\]\.,;:\s@\"]+(\.[^<>()\[\]\.,;:\s@\"]+)*)|(\".+\"))@(([^<>()[\]\.,;:\s@\"]+\.)+[^<>()[\]\.,;:\s@\"]{2,})$/i;
                        $.each(emailsToCopy, function(key, email){
                            email = $.trim(email);
                            var status = emailsToCopyRow === '{leadowner:email}' ? true : emailValidation.test(email);
                            if (status === false) {
                                var emailErrMsg = (_.isUndefined(i18n['The']) ? 'The' : i18n['The']) + ' ' + email + ' ' + (_.isUndefined(i18n['isn\'t valid.']) ? 'isn\'t valid.' : i18n['isn\'t valid.']) + ' ';
                                var validEmailAddressMsg = _.isUndefined(i18n['Please specify valid email address']) ? 'Please specify valid email address' : i18n['Please specify valid email address'];

                                showMessage(emailErrMsg + validEmailAddressMsg, true, false);
                                error = true;
                                return false;
                            }
                        });

                        if (_.isEmpty(emailsToCopyFrom) || emailsToCopyFrom === '') {
                            showMessage(_.isUndefined(i18n['Please specify email from']) ? 'Please specify email from' : i18n['Please specify email from'], true, false);
                            error = true;
                            return false;
                        }

                        if (_.isEmpty(emailsToCopySubject) || emailsToCopySubject === '') {
                            showMessage(_.isUndefined(i18n['Please specify email subject']) ? 'Please specify email subject' : i18n['Please specify email subject'], true, false);
                            error = true;
                            return false;
                        }

                        if (emailsToCopyTemplate == '0') {
                            showMessage(_.isUndefined(i18n['Please specify email template']) ? 'Please specify email template' : i18n['Please specify email template'], true, false);
                            error = true;
                            return false;
                        }

                        if (_.isEmpty(emailsToCopy) || emailsToCopy === '') {
                            showMessage(_.isUndefined(i18n['Please specify email']) ? 'Please specify email' : i18n['Please specify email'], true, false);
                            error = true;
                            return false;
                        } else {
                            triggerNewLeadOnly = 0;
                            if ($('#assign-email-copy-only-for-new-lead').is(':checked')) {
                                triggerNewLeadOnly = 1;
                            }

                            actionsData.push({
                                'emailsToCopy': emailsToCopyRow,
                                'actionType': actionType,
                                'emailTemplate': emailsToCopyTemplate,
                                'emailSubject': emailsToCopySubject,
                                'emailFrom': emailsToCopyFrom,
                                'emailMessage': emailsToCopyMessage,
                                'triggerNewLeadOnly':triggerNewLeadOnly
                            });
                        }
                    }
                }
            });

            if (error === true) {
                return false;
            }

            if (switchersChosen === false) {
                showMessage(_.isUndefined(i18n['Please activate at least one action']) ? 'Please activate at least one action' : i18n['Please activate at least one action'], true, false);
                return false;
            }

            self.beforeSelectedCampaign.campaign = '';
            self.campaignSelectedListsIds = {};
            self.campaignSelectedListsLabels = {};

            var data = {'secureToken': $('#form-leads-grid-token').val(), 'rule_name': scoreRuleName, 'score_comparison_operator':ruleSetScoreSign, 'score':ruleSetScore, 'fieldsData' : fieldsConfigData, 'actionsData' :actionsData};

            $.ajax({
                url: $('#website_url').val()+'api/leads/leadworkflow',
                type: 'POST',
                data: data,
                dataType: 'json'
            }).done(function(response) {
                self.renderConfigForm();
                self.$el.trigger('LeadWorkflowFormGrid:created');
                showMessage(response.responseText.message, false, 5000);
            }).fail(function(response){
                showMessage(response.responseJSON, true, 5000);
            });
            return false;
        },
        changeRuleOperator: function(e)
        {
            var el = $(e.currentTarget),
                ruleOperator = el.val(),
                valueEl = el.closest('div').find('.score-field-rules-row-value'),
                infoTooltip = window.appLeadFormRouter.leadTooltipInfo(ruleOperator),
                rowType = el.closest('div').data('field-name'),
                placeholder = '',
                desctopMaskClass = '';

            el.prop('title', infoTooltip);

            if(rowType == 'lead_phone' || rowType == 'tracking_number') {
                desctopMaskClass = 'score-field-rules-row-value-desctop-mask-'+rowType;

                if(ruleOperator === 'like') {
                    placeholder = (_.isUndefined(i18n['+18774509...']) ? '+18774509...' : i18n['+18774509...']);
                   $('.score-field-rules-row-value-desctop-mask-'+rowType).prop('placeholder', placeholder);
                }

                if(ruleOperator === 'in') {
                    placeholder = (_.isUndefined(i18n['separate the values with commas and enter phone with country code ex: +18774509...']) ? 'separate the values with commas and enter phone with country code ex: +18774509...' : i18n['separate the values with commas and enter phone with country code ex: +18774509...'])
                }
            }

            if (ruleOperator === 'in') {
                placeholder = (_.isUndefined(i18n['separate the values with commas']) ? 'separate the values with commas' : i18n['separate the values with commas']);
            }

            if (ruleOperator === 'dategreaterthan' || ruleOperator === 'datelessthan') {
                placeholder = 'YYYY-MM-DD HH:mm:ss';
            }

            if ((ruleOperator === 'in' || ruleOperator === 'notin') && (valueEl.is('input') || valueEl.is('textarea'))) {
                valueEl.replaceWith('<textarea placeholder="'+ placeholder +'" class="score-field-rules-row-value ' + desctopMaskClass + ' grid_5 alpha omega" name="'+valueEl.prop('name')+'">'+valueEl.val()+'</textarea>');
            } else if(!valueEl.is('input') && !valueEl.is('select')) {
                valueEl.replaceWith('<input type="text" placeholder="'+ placeholder +'" class="score-field-rules-row-value ' + desctopMaskClass + ' grid_5 alpha omega" name="'+valueEl.prop('name')+'" value="'+valueEl.val()+'" />');
            } else if(valueEl.is('input')) {
                valueEl.replaceWith('<input type="text" placeholder="'+ placeholder +'" class="score-field-rules-row-value ' + desctopMaskClass + ' grid_5 alpha omega" name="'+valueEl.prop('name')+'" value="'+valueEl.val()+'" />');
            }

            /*if (valueEl.is('select') && ruleOperator === 'in') {
                //valueEl.prop('multiple', 'multiple').chosen();
            }

            if (valueEl.is('select') && ruleOperator !== 'in') {
                //valueEl.prop('multiple', '').chosen('destroy');
            }*/

            if(rowType == 'lead_phone' || rowType == 'tracking_number') {
                if(ruleOperator == 'equal' || ruleOperator == 'notequal') {
                    $('.score-field-rules-row-value-desctop-mask-'+rowType).prop('placeholder', '');

                    var desktopMasks = this.workflowForm.desktopMasks,
                        defaultDesktopCountryCode = this.workflowForm.userDefaultPhoneMobileCode,
                        selectedCountryCode = $('.phone-countries-codes-'+rowType).val();

                    if(selectedCountryCode == '' || selectedCountryCode == null) {
                        selectedCountryCode = defaultDesktopCountryCode;
                    }

                    if (typeof desktopMasks[selectedCountryCode] !== 'undefined') {
                        $('.score-field-rules-row-value-desctop-mask-'+rowType).mask(desktopMasks[selectedCountryCode].mask_value, {autoclear: false});
                    } else {
                        $('.score-field-rules-row-value-desctop-mask-'+rowType).mask('(999) 999 9999', {autoclear: false});
                    }

                    $('.phone-countries-codes-'+rowType).show();
                } else {
                    $('.phone-countries-codes-'+rowType).hide();

                    $('.score-field-rules-row-value-desctop-mask-'+rowType).unmask();
                    var valueElClean = valueEl.val().replace(/[^+0-9]/g, '');
                    $('.score-field-rules-row-value-desctop-mask-'+rowType).val(valueElClean);
                }
            }
        },
        addField: function()
        {
           var fieldName = $('#score-field-attribute-selection').val(),
               fieldLabel = $('#score-field-attribute-selection').find(':selected').data('field-label'),
               fieldType = $('#score-for-rules').val(),
               fieldKey = fieldType+'-'+fieldName.replace(/\s/g, ''),
               blockFields = false,
               customComparisonOperators = [],
               specialElType = [],
               flagMultiSelect = false,
               placeholder = '';

           if (fieldName === 'organization_employees' || fieldName === 'opportunity_amount_cumulative' || fieldName === 'opportunity_amount') {
               customComparisonOperators['greaterthan'] = _.isUndefined(i18n['Greater Than']) ? 'Greater Than' : i18n['Greater Than'];
               customComparisonOperators['lessthan'] = _.isUndefined(i18n['Less Than']) ? 'Less Than' : i18n['Less Than'];
           }

           if (fieldName === 'last_activity_inbound' || fieldName === 'last_activity_outbound' || fieldName === 'opportunity_close_date') {
               blockFields = true;
           }

           if (fieldName === 'lead_state_code' || fieldName === 'lead_position' || fieldName === 'organization_state_code' || fieldName === 'lead_phone') {
                customComparisonOperators['equal'] = _.isUndefined(i18n['Equal']) ? 'Equal' : i18n['Equal'];
                customComparisonOperators['notequal'] = _.isUndefined(i18n['Not Equal']) ? 'Not Equal' : i18n['Not Equal'];
                customComparisonOperators['like'] = _.isUndefined(i18n['Contains']) ? 'Contains' : i18n['Contains'];
                customComparisonOperators['in'] = _.isUndefined(i18n['Any']) ? 'Any' : i18n['Any'];
           }

           if (fieldType === 'lead_custom_attributes' || fieldType === 'organization_custom_attributes') {
               customComparisonOperators['equal'] = _.isUndefined(i18n['Equal']) ? 'Equal' : i18n['Equal'];
               customComparisonOperators['notequal'] = _.isUndefined(i18n['Not Equal']) ? 'Not Equal' : i18n['Not Equal'];
               customComparisonOperators['like'] = _.isUndefined(i18n['Contains']) ? 'Contains' : i18n['Contains'];
               customComparisonOperators['in'] = _.isUndefined(i18n['Any']) ? 'Any' : i18n['Any'];
               customComparisonOperators['greaterthan'] = _.isUndefined(i18n['Greater Than']) ? 'Greater Than' : i18n['Greater Than'];
               customComparisonOperators['lessthan'] = _.isUndefined(i18n['Less Than']) ? 'Less Than' : i18n['Less Than'];
               customComparisonOperators['datebefore'] = _.isUndefined(i18n['Days before']) ? 'Days before' : i18n['Days before'];
               customComparisonOperators['dateafter'] = _.isUndefined(i18n['Days after']) ? 'Days after' : i18n['Days after'];
               customComparisonOperators['dategreaterthan'] = _.isUndefined(i18n['Date greater than']) ? 'Date greater than' : i18n['Date greater than'];
               customComparisonOperators['datelessthan'] = _.isUndefined(i18n['Date less than']) ? 'Date less than' : i18n['Date less than'];
           }

           if ((fieldName === 'lead_customer_group_id' || fieldName === 'organization_customer_group_id') && typeof this.workflowForm.customerGroupsData !== 'undefined') {
               specialElType['elementValues'] = this.workflowForm.customerGroupsData;
               flagMultiSelect = true;
           }

           if ((fieldName === 'lead_country_code' || fieldName === 'organization_country_code') && typeof this.workflowForm.countryCodesData !== 'undefined') {
               specialElType['elementValues'] = this.workflowForm.countryCodesData;
               flagMultiSelect = true;
           }

           if ((fieldName === 'form_name') && typeof this.workflowForm.formsData !== 'undefined') {
                specialElType['elementValues'] = this.workflowForm.formsData;
                flagMultiSelect = true;
           }

           if ((fieldName === 'owner_id') && typeof this.workflowForm.leadOwnersData !== 'undefined') {
               specialElType['elementValues'] = this.workflowForm.leadOwnersData;
               flagMultiSelect = true;
           }

           if (fieldName === 'nps_review_score') {
               var npsReviewScoreValues = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10];
               specialElType['elementType'] = 'select';
               specialElType['elementValues'] = npsReviewScoreValues;
               customComparisonOperators['equal'] = _.isUndefined(i18n['Equal']) ? 'Equal' : i18n['Equal'];
               customComparisonOperators['greaterthan'] = _.isUndefined(i18n['Greater Than']) ? 'Greater Than' : i18n['Greater Than'];
               customComparisonOperators['lessthan'] = _.isUndefined(i18n['Less Than']) ? 'Less Than' : i18n['Less Than'];
               $('#form-action-send-review-list-el').removeClass('hidden');
           }

           if ((fieldName === 'stage_id') && typeof this.workflowForm.lifecycleStagesData !== 'undefined') {
               specialElType['elementValues'] = this.workflowForm.lifecycleStagesData;
               flagMultiSelect = true;
           }

           if ((fieldName === 'lead_tags') && typeof this.workflowForm.leadTagsData !== 'undefined') {
               specialElType['elementValues'] = this.workflowForm.leadTagsData;
               flagMultiSelect = true;
           }

            if ((fieldName === 'organization_industry_id') && typeof this.workflowForm.industriesData !== 'undefined') {
                specialElType['elementValues'] = this.workflowForm.industriesData;
                flagMultiSelect = true;
            }

           if ((fieldName === 'opportunity_stage') && typeof this.workflowForm.opportunityStagesData !== 'undefined') {
               specialElType['elementValues'] = this.workflowForm.opportunityStagesData;
               flagMultiSelect = true;
           }

           if ((fieldName === 'opportunity_type') && typeof this.workflowForm.opportunityTypesData !== 'undefined') {
               specialElType['elementValues'] = this.workflowForm.opportunityTypesData;
               flagMultiSelect = true;
           }

           if (flagMultiSelect === true) {
               specialElType['elementType'] = 'multiselect';
               customComparisonOperators['in'] = _.isUndefined(i18n['Any']) ? 'Any' : i18n['Any'];
               customComparisonOperators['notin'] = _.isUndefined(i18n['Excluding']) ? 'Excluding' : i18n['Excluding'];
           }

           if (fieldName === 'lead_state_code' || fieldName === 'organization_state_code') {
               placeholder = (_.isUndefined(i18n['Ex: AL']) ? 'Ex: AL' : i18n['Ex: AL']);
           }

           if (fieldName === 'last_activity_inbound') {
               specialElType['elementType'] = 'select';
               specialElType['elementValues'] = this.workflowForm.leadsPredefinedValues['last_activity_inbound'];
               customComparisonOperators['equal'] = _.isUndefined(i18n['Equal']) ? 'Equal' : i18n['Equal'];
           }

            if (fieldName === 'last_activity_outbound') {
                specialElType['elementType'] = 'select';
                specialElType['elementValues'] = this.workflowForm.leadsPredefinedValues['last_activity_outbound'];
                customComparisonOperators['equal'] = _.isUndefined(i18n['Equal']) ? 'Equal' : i18n['Equal'];
            }

           if (fieldName === 'opportunity_close_date') {
               specialElType['elementType'] = 'select';
               specialElType['elementValues'] = this.workflowForm.leadsPredefinedValues['opportunity_close_date'];
               customComparisonOperators['equal'] = _.isUndefined(i18n['Equal']) ? 'Equal' : i18n['Equal'];
           }

            if (fieldName === 'sms_keyword_sent' || fieldName === 'sms_keyword_received' || fieldName === 'lead_source' || fieldName === 'transcribed_conversation') {
                customComparisonOperators['like'] = _.isUndefined(i18n['Contains']) ? 'Contains' : i18n['Contains'];
            }

           $('#score-field-rules-configuration-block-label').removeClass('hidden');
           if ($('#score-field-rule-row-block-'+fieldKey).length == '0') {
               $('#score-field-rules-configuration-block-rows').append( _.template(LeadWorkflowFieldRowTmpl, {
                   'fieldKey': fieldKey,
                   'fieldName': fieldName,
                   'fieldLabel':fieldLabel,
                   'fieldType':fieldType,
                   'fieldSubtype': '',
                   'moment': moment,
                   'i18n':i18n,
                   'blockFields': blockFields,
                   'customComparisonOperators': customComparisonOperators,
                   'specialElType': specialElType,
                   'placeholder' : placeholder,
                   'phoneCountryCodes' : this.workflowForm.phoneCountryCodes,
                   'defaultDesktopCountryCode' : this.workflowForm.userDefaultPhoneMobileCode
               }));
               if ($('#workflow-score-row-block').find('#workflow-score-row').length == 0) {
                   $('#workflow-score-row-block').append(_.template(LeadWorkflowFieldScoreRowTmpl, {'i18n': i18n}));
               }

              var desktopMasks = this.workflowForm.desktopMasks,
                  defaultDesktopCountryCode = this.workflowForm.userDefaultPhoneMobileCode;

               if (typeof desktopMasks[defaultDesktopCountryCode] !== 'undefined') {
                   $('.score-field-rules-row-value-desctop-mask-'+fieldName).mask(desktopMasks[defaultDesktopCountryCode].mask_value, {autoclear: true});
               } else {
                   $('.score-field-rules-row-value-desctop-mask-'+fieldName).mask('(999) 999 9999', {autoclear: false});
               }

               if (flagMultiSelect === true) {
                   $('#score-field-rule-row-block-'+fieldKey).find('.score-field-rules-row-value').chosen();
               }

           } else {
               showMessage(_.isUndefined(i18n['Field already exists']) ? 'Field already exists' : i18n['Field already exists'], true, 5000);
           }
        },
        addActionField: function()
        {
            var fieldName = $('#score-field-action-attribute-selection').val(),
                fieldSubtype = $('#score-field-action-selection').val(),
                fieldLabel = $('#score-field-action-attribute-selection').find(':selected').data('field-label'),
                fieldType = $('#score-for-rules').val(),
                blockFields = false,
                customComparisonOperators = [],
                fieldKey = fieldName.replace(/\s/g, '')+fieldSubtype.replace(/\s/g, ''),
                placeholder = '',
                specialElType = [],
                fieldTooltip = '',
                flagMultiSelect = false;

            if (fieldName === 'quote_requested' || fieldName === 'quote_view' || fieldName === 'registered' || fieldName === 'quote_sent') {
                blockFields = true;
            }

            if (fieldName === 'duration_placed' || fieldName === 'duration_received'
                || fieldName === 'purchase_amount_single' || fieldName === 'purchase_amount_cumulative' || fieldName === 'visit_duration'
                || fieldName === 'visit_duration_latest' || fieldName === 'action_number'
                || fieldName === 'action_number_latest' || fieldName === 'quote_amount_single'
            || fieldName === 'quote_amount_cumulative' || fieldName === 'email_sent' || fieldName === 'email_received') {
                customComparisonOperators['greaterthan'] = _.isUndefined(i18n['Greater Than']) ? 'Greater Than' : i18n['Greater Than'];
                customComparisonOperators['lessthan'] = _.isUndefined(i18n['Less Than']) ? 'Less Than' : i18n['Less Than'];
            }

            if (fieldName === 'email_opened') {
                customComparisonOperators['equal'] = _.isUndefined(i18n['Equal']) ? 'Equal' : i18n['Equal'];
                placeholder = (_.isUndefined(i18n['Opened \'Number of days\' ago']) ? 'Opened \'Number of days\' ago' : i18n['Opened \'Number of days\' ago']);
            }

            if (fieldName === 'email_link_clicked_in_sequence') {
                specialElType['elementValues'] = this.workflowForm.emailSequenciesData;
                flagMultiSelect = true;
            }

            if (fieldName === 'email_link_clicked') {
                customComparisonOperators['equal'] = _.isUndefined(i18n['Equal']) ? 'Equal' : i18n['Equal'];
                placeholder = (_.isUndefined(i18n['Clicked \'Number of days\' ago']) ? 'Clicked \'Number of days\' ago' : i18n['Clicked \'Number of days\' ago']);
            }

            if (fieldName === 'duration_placed' || fieldName === 'duration_received' || fieldName === 'visit_duration' || fieldName === 'visit_duration_latest') {
                placeholder = (_.isUndefined(i18n['in seconds']) ? 'in seconds' : i18n['in seconds']);
            }

            if (fieldName === 'file_name' || fieldName === 'tracking_number') {
                customComparisonOperators['equal'] = _.isUndefined(i18n['Equal']) ? 'Equal' : i18n['Equal'];
                customComparisonOperators['notequal'] = _.isUndefined(i18n['Not Equal']) ? 'Not Equal' : i18n['Not Equal'];
                customComparisonOperators['like'] = _.isUndefined(i18n['Contains']) ? 'Contains' : i18n['Contains'];
                customComparisonOperators['in'] = _.isUndefined(i18n['Any']) ? 'Any' : i18n['Any'];
            }

            if (fieldName === 'purchase_products_sku') {
                customComparisonOperators['in'] = _.isUndefined(i18n['Any']) ? 'Any' : i18n['Any'];
                customComparisonOperators['notin'] = _.isUndefined(i18n['Excluding']) ? 'Excluding' : i18n['Excluding'];
                specialElType['elementType'] = 'textarea';
            }

            if (fieldName === 'quote_view' || fieldName === 'quote_requested' || fieldName === 'registered' || fieldName === 'quote_sent'  || fieldName === 'website_last_action_date_time') {
                specialElType['elementType'] = 'select';
                specialElType['elementValues'] = this.workflowForm.leadsPredefinedValues['yes_no_block'];
                customComparisonOperators['equal'] = _.isUndefined(i18n['Equal']) ? 'Equal' : i18n['Equal'];
            }

            if (fieldName === 'website_last_action_date_time') {
                specialElType['elementType'] = 'select';
                specialElType['elementValues'] = this.workflowForm.leadsPredefinedValues['website_last_action_date_time'];
                customComparisonOperators['equal'] = _.isUndefined(i18n['Equal']) ? 'Equal' : i18n['Equal'];
            }

            if (fieldName === 'quote_expiration_date') {
                specialElType['elementType'] = 'select';
                specialElType['elementValues'] = this.workflowForm.leadsPredefinedValues['quote_expiration_date'];
                customComparisonOperators['equal'] = _.isUndefined(i18n['Equal']) ? 'Equal' : i18n['Equal'];
            }

            if (fieldName === 'sms_keyword_sent' || fieldName === 'sms_keyword_received' || fieldName === 'transcribed_conversation') {
                customComparisonOperators['like'] = _.isUndefined(i18n['Contains']) ? 'Contains' : i18n['Contains'];
            }

            if (fieldName === 'email_received_imap') {
                fieldTooltip = _.isUndefined(i18n['Rule will apply only for newly created leads. Rule will apply when email received via the IMAP only. No action will be taken for existing leads!!!']) ? 'Rule will apply only for newly created leads. Rule will apply when email received via the IMAP only. No action will be taken for existing leads!!!' : i18n['Rule will apply only for newly created leads. Rule will apply when email received via the IMAP only. No action will be taken for existing leads!!!'];
                customComparisonOperators['like'] = _.isUndefined(i18n['Contains']) ? 'Contains' : i18n['Contains'];
            }

            if (fieldName === 'email_received_imap_from') {
                fieldTooltip = _.isUndefined(i18n['Rule will apply only for newly created leads. Rule will apply when email received via the IMAP only. No action will be taken for existing leads!!!']) ? 'Rule will apply only for newly created leads. Rule will apply when email received via the IMAP only. No action will be taken for existing leads!!!' : i18n['Rule will apply only for newly created leads. Rule will apply when email received via the IMAP only. No action will be taken for existing leads!!!'];
                customComparisonOperators['equal'] = _.isUndefined(i18n['Equal']) ? 'Equal' : i18n['Equal'];
            }

            if (flagMultiSelect === true) {
                specialElType['elementType'] = 'multiselect';
                customComparisonOperators['in'] = _.isUndefined(i18n['Any']) ? 'Any' : i18n['Any'];
                customComparisonOperators['notin'] = _.isUndefined(i18n['Excluding']) ? 'Excluding' : i18n['Excluding'];
            }

            if (fieldName === 'email_link_clicked_in_sequence') {
                customComparisonOperators = [];
                customComparisonOperators['in'] = _.isUndefined(i18n['Any']) ? 'Any' : i18n['Any'];
            }

            $('#score-field-rules-configuration-block-label').removeClass('hidden');
            if ($('#score-field-rule-row-block-'+fieldKey).length == '0') {
                $('#score-field-rules-configuration-block-rows').append( _.template(LeadWorkflowFieldRowTmpl, {
                    'fieldKey': fieldKey,
                    'fieldName': fieldName,
                    'fieldLabel':fieldLabel,
                    'fieldType':fieldType,
                    'fieldSubtype': fieldSubtype,
                    'fieldTooltip': fieldTooltip,
                    'moment': moment,
                    'i18n':i18n,
                    'blockFields': blockFields,
                    'customComparisonOperators': customComparisonOperators,
                    'placeholder': placeholder,
                    'specialElType': specialElType,
                    'phoneCountryCodes' : this.workflowForm.phoneCountryCodes,
                    'defaultDesktopCountryCode' : this.workflowForm.userDefaultPhoneMobileCode

                }));
                if ($('#workflow-score-row-block').find('#workflow-score-row').length == 0) {
                    $('#workflow-score-row-block').append(_.template(LeadWorkflowFieldScoreRowTmpl, {'i18n': i18n}));
                }

                var desktopMasks = this.workflowForm.desktopMasks,
                    defaultDesktopCountryCode = this.workflowForm.userDefaultPhoneMobileCode;

                if (typeof desktopMasks[defaultDesktopCountryCode] !== 'undefined') {
                    $('.score-field-rules-row-value-desctop-mask-'+fieldName).mask(desktopMasks[defaultDesktopCountryCode].mask_value, {autoclear: true});
                } else {
                    $('.score-field-rules-row-value-desctop-mask-'+fieldName).mask('(999) 999 9999', {autoclear: false});
                }

                if (flagMultiSelect === true) {
                    $('#score-field-rule-row-block-'+fieldKey).find('.score-field-rules-row-value').chosen();
                }
            } else {
                showMessage(_.isUndefined(i18n['Field already exists']) ? 'Field already exists' : i18n['Field already exists'], true, 5000);
            }
        },
        deleteFieldRow: function(e)
        {
            e.preventDefault();
            showConfirm(_.isUndefined(i18n['Are you sure want to delete?']) ? 'Are you sure want to delete?' : i18n['Are you sure want to delete?'], function () {
                $(e.currentTarget).closest('.score-field-rule-row-block').remove();
                if($('#score-field-rules-configuration-block-rows').find('.form-field-rules-row-delete').length == 0) {
                    $('#workflow-score-row-block').empty();
                }

                if($('#score-field-rules-configuration-block-rows').find('#score-field-rule-row-block-lead_attribute-nps_review_score').length == 0) {
                    $('#form-action-send-review-list-el').addClass('hidden');
                }
            });

        },
        alphabeticalSort: function(obj){
            // convert object into array
            var sortable=[];
            for(var key in obj)
                if(obj.hasOwnProperty(key))
                    sortable.push([key, obj[key]]); // each item is an array in format [key, value]

            // sort items by value
            sortable.sort(function(a, b)
            {
                var x=a[1].toLowerCase(),
                    y=b[1].toLowerCase();
                return x<y ? -1 : x>y ? 1 : 0;
            });
            return sortable; // array in format [ [ key1, val1 ], [ key2, val2 ], ... ]
        },
        switchTaskUnits: function(e)
        {
            if ($(e.currentTarget).val() == 'hour') {
                $('#lead-task-start-time').prop('disabled', true).addClass('exclude-from-disable');
            } else {
                $('#lead-task-start-time').prop('disabled', false).removeClass('exclude-from-disable');
            }
        },
        switchTaskDueUnits: function(e)
        {
            if ($(e.currentTarget).val() == 'hour') {
                $('#lead-task-due-time').prop('disabled', true).addClass('exclude-from-disable');
            } else {
                $('#lead-task-due-time').prop('disabled', false).removeClass('exclude-from-disable');
            }
        },
        switchImmediate: function(e)
        {
            var taskUnitsType = $('#form-action-assign-task-number-of-before-action-units').val();
            if ($(e.currentTarget).is(':checked')) {
                $('.disable-immediate').prop('disabled', true);
                $('#lead-task-start-time').prop('disabled', true);
                $('#form-action-assign-task-number-of-before-action').addClass('exclude-from-disable');
                $('#form-action-assign-task-number-of-before-action-units').addClass('exclude-from-disable');
            } else {
                $('.disable-immediate').prop('disabled', false);
                if (taskUnitsType === 'hour') {
                    $('#lead-task-start-time').prop('disabled', true);
                } else {
                    $('#lead-task-start-time').prop('disabled', false);
                }
                $('#form-action-assign-task-number-of-before-action').removeClass('exclude-from-disable');
                $('#form-action-assign-task-number-of-before-action-units').removeClass('exclude-from-disable');
            }
        },
        switcherAction:function (e) {
            var el      = $(e.currentTarget),
                tabId        = el.closest('li').find('a').data('tab-id'),
                currentTabEl = $('#'+tabId),
                actionType   = currentTabEl.data('action-type'),
                elSwitcher   = el,
                elSelect     = currentTabEl.find('select'),
                elInput      = currentTabEl.find('input'),
                elTextarea   = currentTabEl.find('textarea');

            this.disabledAction(elSwitcher, actionType, elSelect, elInput, elTextarea);
        },
        disabledAction: function (elSwitcher, actionType, elSelect, elInput, elTextarea) {
            var elTags  = $('#select_assign_lead_tags_chosen .chosen-results'),
                rmTags = $('#select_remove_lead_tags_chosen .chosen-results');

            if(elSwitcher.is(':checked')){
                if(actionType == 'assign_tags'){
                    elTags.css({'display' : ''});
                    rmTags.css({'display' : ''});
                    if(elInput.length > 0 && elInput.attr('type') === 'checkbox'){
                        elInput.prop('disabled', false);
                    }
                }else{
                    if(elSelect.length > 0){
                        _.each(elSelect, function(elSel){
                            if (!$(elSel).hasClass('exclude-from-disable')) {
                                $(elSel).prop('disabled', false);
                            }
                        });
                    }
                    if(elInput.length > 0){
                        _.each(elInput, function(elInp){
                            if (!$(elInp).hasClass('exclude-from-disable')) {
                                $(elInp).prop('disabled', false);
                            }
                        });
                    }
                    if(elTextarea.length > 0){
                        elTextarea.prop('disabled', false);
                    }
                }
            }else {
                if(actionType == 'assign_tags'){
                    elTags.css({'display' : 'none'});
                    rmTags.css({'display' : 'none'});
                    if(elInput.length > 0 && elInput.attr('type') === 'checkbox'){
                        elInput.prop('disabled', true);
                    }
                }else{
                    if(elSelect.length > 0){
                        elSelect.prop('disabled', true);
                    }
                    if(elInput.length > 0){
                        elInput.prop('disabled', true);
                    }
                    if(elTextarea.length > 0){
                        elTextarea.prop('disabled', true);
                    }
                }
            }
        },
        getServicesLists: function (e) {
            var cuurentElValue = $(e.currentTarget).val(),
                self = this;
            $.ajax({
                url: $('#website_url').val()+'plugin/leads/run/getAppsService/serviceName/'+cuurentElValue,
                type: 'GET',
                dataType: 'json'
            }).done(function(response) {
                $('#subscribe-list').remove();
                if(response.error != 1){
                    var subscribeList = '<div class="grid_12 mt10px scroll" id="subscribe-list" style="height:265px;">',
                        list = self.alphabeticalSort(response.responseText.list);

                    if(list.length > 0) {
                        $.each(list, function(value, listName){
                            subscribeList += '<label class="mr30px pointer"> <input type="checkbox" class="subscribe-to-email-service-list" name="list" data-list-name="'+ listName[1] +'" value="'+ listName[0] +'"/> <span>'+ listName[1] +'</span> </label>'
                        });
                    } else {
                        if($('#marketing-services').val() == 'constantContact') {
                            if(response.responseText.hasError) {
                                subscribeList += (_.isUndefined(i18n['<p><b>Can not get any data.</b></p> '+response.responseText.message])?'<p><b>Can not get any data.</b></p> '+response.responseText.message:i18n['<p><b>Can not get any data.</b></p> '+response.responseText.message]);
                            } else {
                                subscribeList += (_.isUndefined(i18n['<p><b>No list is available.</b></p> Please make sure if the list is created and you can get access to it.'])?'<p><b>No list is available.</b></p> Please make sure if the list is created and you can get access to it.':i18n['<p><b>No list is available.</b></p> Please make sure if the list is created and you can get access to it.']);
                            }
                        } else {
                            subscribeList += (_.isUndefined(i18n['<p><b>No list is available.</b></p> Private lists are not shown here. Make sure your lists are set as "shared" or "managed" types in your Marketing Operating System so that we can display them here for you to select.'])?'<p><b>No list is available.</b></p> Private lists are not shown here. Make sure your lists are set as "shared" or "managed" types in your Marketing Operating System so that we can display them here for you to select.':i18n['<p><b>No list is available.</b></p> Private lists are not shown here. Make sure your lists are set as "shared" or "managed" types in your Marketing Operating System so that we can display them here for you to select.']);
                        }
                    }

                    subscribeList += '</div>';

                    $('#email-service-detailed-info').val(response.responseText.detailedInfo);

                    $('#marketing-services').after(subscribeList);
                }
            });
        },
        getMarketingCampaigns: function (e) {
            e.stopImmediatePropagation();
            var cuurentElValue = $(e.currentTarget).val(),
                self = this,
                checkedListsEl = $("input.subscribe-to-remarketing-list:checked");

            var audinceListsIds = [],
                audinceListsLabels = [];
            checkedListsEl.each(function() {
                var listId = $(this).val(),
                    listLabel = $(this).data('label');
                audinceListsIds.push(listId);
                audinceListsLabels.push(listLabel);
            });

            self.campaignSelectedListsIds[self.beforeSelectedCampaign.campaign] = audinceListsIds;
            self.campaignSelectedListsLabels[self.beforeSelectedCampaign.campaign] = audinceListsLabels;

            if(cuurentElValue !== 'select') {
                self.beforeSelectedCampaign.campaign = $('#marketing-campaigns').val();
            } else {
                self.beforeSelectedCampaign.campaign = '';
            }

            $('#add-new-lists').addClass('hidden');
            if (cuurentElValue != 'select') {
                $.ajax({
                    url: $('#website_url').val()+'plugin/leads/run/getAdvertisingService/serviceName/'+cuurentElValue,
                    type: 'GET',
                    dataType: 'json'
                }).done(function(response) {
                    if(response.error == 1){
                        if(response.responseText.message == 'No ad account assigned to this website') {
                            var googleAdAccount = 'Google Adwords',
                                facebookAdAccount = 'Facebook Ad',
                                accountName = facebookAdAccount;

                            if(cuurentElValue == 'adwords') {
                                accountName = googleAdAccount;
                            }
                            var connectionMessage = (_.isUndefined(i18n['You need first to connect a '+ accountName +' account. Click'])?'You need first to connect a '+ accountName +' account. Click':i18n['You need first to connect a '+ accountName +' account. Click'])
                                + ' ' + '<a href="' + $('#website_url').val() + '/plugin/leads/run/advertiserAccountConfig/" target="_blank" title="Click to open config" style="text-decoration: underline;">' + (_.isUndefined(i18n['here'])?'here':i18n['here']) +'</a>'
                                + ' ' + (_.isUndefined(i18n['to access the configuration panel'])?'to access the configuration panel':i18n['to access the configuration panel']);
                            showMessage(connectionMessage, true, 6000);
                        } else {
                            showMessage(_.isUndefined(i18n[response.responseText.message])?response.responseText.message:i18n[response.responseText.message], false, 1000);
                        }

                        $('#subscribe-remarketing-list').remove();
                        $('#add-new-lists').addClass('hidden');
                        $('#marketing-campaigns').val('select');
                        return false;
                    }else{
                        $('#subscribe-remarketing-list').remove();
                        var subscribeList = '<div class="grid_12 mt10px scroll" id="subscribe-remarketing-list" style="height:250px;">',
                            list = response.responseText.list;

                        if(list !== null && list.length > 0) {
                            $.each(list, function(key, listData){
                                var isChecked = '';
                                if(typeof self.campaignSelectedListsIds[cuurentElValue] !== 'undefined' && self.campaignSelectedListsIds[cuurentElValue].indexOf(listData.id.toString()) !== -1) {
                                    isChecked = 'checked';
                                }
                                subscribeList += '<label class="mr30px pointer"> <input type="checkbox" '+ isChecked +' class="subscribe-to-remarketing-list" name="list" value="'+ listData.id +'" data-label="'+ listData.name +'"/><span>'+ listData.name + ' (id: ' + listData.id + ')' + '</span></label>';
                            });
                        } else {
                            subscribeList += (_.isUndefined(i18n['No available lists'])?'No available lists':i18n['No available lists']);
                        }
                        subscribeList += '</div>';
                        $('#marketing-campaigns').after(subscribeList);
                        $('#add-new-lists').removeClass('hidden');
                    }
                });
            }else{
                $('#subscribe-remarketing-list').remove();
            }
        },
        createNewAdList: function (e)
        {
            e.preventDefault();
            var account = $("#marketing-campaigns").val(),
                listName = $('#list-name').val().replace(/[^a-zA-Z0-9-_ ]/g, '');

            if(listName != '') {
                $('#list-name').val(listName);
                showConfirm(_.isUndefined(i18n['Are you sure want add new list?'])?'Are you sure want add new list?':i18n['Are you sure want add new list?'], function(){
                    $.ajax({
                        'url': $('#website_url').val() + 'plugin/leads/run/addAdvertiserlist/',
                        'type': 'POST',
                        'dataType': 'json',
                        'data': {
                            'secureToken' : $('#form-leads-grid-token').val(),
                            'listName': listName,
                            'account': account
                        }
                    }).done(async function (response) {
                        hideLoader();
                        if (response.error == '1') {
                            showMessage(response.responseText.message, true, 2000);
                            return false;
                        } else {
                            if(typeof response.responseText.listId === 'undefined') {
                                showMessage(response.responseText.message, true, 2000);
                            } else {
                                showMessage('(list: '+response.responseText.listId+') created successfully', false, 2000);
                                var newList = '<label class="mr30px pointer"> <input type="checkbox" class="subscribe-to-remarketing-list" name="list" value="'+ response.responseText.listId +'" data-label="'+ listName +'"/><span>'+ listName + ' (id: ' + response.responseText.listId + ')' + '</span></label>';
                                $('#subscribe-remarketing-list').prepend(newList);
                            }
                            $('#list-name').val('');
                        }

                    }).fail(async function(response){
                        hideLoader();
                        showMessage(_.isUndefined(i18n['Can\'t add list'])?'Can\'t add list':i18n['Can\'t add list'], true, 2000);
                    });
                }, function () {
                    return false;
                });
            } else {
                showMessage(_.isUndefined(i18n['Please enter list name'])?'Please enter list name':i18n['Please enter list name'], true, 2000);
            }
        },
        changeFormAction: function(e)
        {
            e.preventDefault();
            var el           = $(e.currentTarget),
                tabId        = el.data('tab-id'),
                currentTabEl = $('#'+tabId),
                actionType   = currentTabEl.data('action-type'),
                elSwitcher   = el.closest('li').find('input'),
                elSelect     = currentTabEl.find('select'),
                elInput      = currentTabEl.find('input'),
                elTextarea   = currentTabEl.find('textarea');
            if (actionType === 'assign_task' || actionType === 'assign_email_copy') {
                this.initTiny(actionType);
                if(actionType === 'assign_task') {
                    setTimeout(function () {
                        if (!_.isNull(tinymce.activeEditor) && '' === tinymce.activeEditor.getContent()) {
                            tinymce.activeEditor.setContent('Hello! ' +
                                'You have a task for this lead: {$lead:leadfullnamelink} from {$lead:organizationnamelink}.');
                        }
                    }, 500);
                }
                if(actionType === 'assign_email_copy') {
                    setTimeout(function () {
                        if (!_.isNull(tinymce.activeEditor) && '' === tinymce.activeEditor.getContent()) {
                            tinymce.activeEditor.setContent('Hello {$leadowner:fullname},' +
                                'You received a text message from {$lead:leadfullnamelink} at {$lead:organizationnamelink}.');
                        }
                    }, 500);
                }
            }
            this.disabledAction(elSwitcher, actionType, elSelect, elInput, elTextarea);

            $('#form-actions-list-block li').removeClass('current');
            $('.action-single-block').addClass('hidden');
            currentTabEl.removeClass('hidden');
            el.closest('li').addClass('current');
        },

        initTiny: function (actionType){
            var selectorEl = 'form-action-assign-task-notes-workflow';
            if(actionType == 'assign_email_copy') {
                selectorEl = 'copy-email-message-workflow';
            }

            tinymce.remove();
            var websiteUrl = $('#website_url').val(), self = this;
            tinymce.init({
                script_url              : websiteUrl+'system/js/external/tinymce/tinymce.gzip.php',
                selector                : "#"+selectorEl,
                skin                    : 'seotoaster',
                menubar                 : false,
                browser_spellcheck      : true,
                resize                  : false,
                convert_urls            : false,
                relative_urls           : false,
                statusbar               : false,
                allow_script_urls       : false,
                force_p_newlines        : false,
                forced_root_block       : false,
                entity_encoding         : "raw",
                plugins                 :  ["leadshortcode fullscreen code link"],
                toolbar1                : "leadshortcode | fullscreen | code | link unlink ",
                image_advtab            : false,
                extended_valid_elements : false,
                setup                   : function(ed){
                    var keyTime = null;
                    ed.on('change blur keyup', function(ed, e){
                        self.dispatchEditorKeyup(ed, e, keyTime);
                        this.save();
                    });
                }
            });

            $('#form-action-assign-task-notes').html('<span></span>').trigger('keyup');
            this.tinimce = tinymce;
        },
        dispatchEditorKeyup: function(editor, event, keyTime) {
            var keyTimer = keyTime;
            if(keyTimer === null) {
                keyTimer = setTimeout(function() {
                    keyTimer = null;
                }, 1000)
            }
        },
        changeDesktopMask: function(e)
        {
            var selectionType = $(e.currentTarget).data('type'),
                fieldName = $(e.currentTarget).data('field-name'),
                value =  $(e.currentTarget).val();

            var //mobileMasks = this.workflowForm.mobileMasks,
                desktopMasks = this.workflowForm.desktopMasks;

            if (selectionType === 'mobile') {
                /*if (typeof mobileMasks[value] !== 'undefined') {
                    $('.lead-mobile-detailed-view').mask(mobileMasks[value].mask_value, {autoclear: false});
                } else {
                    $('.lead-mobile-detailed-view').mask('(999) 999 9999', {autoclear: false});
                }*/
            }

            if (selectionType === 'desktop') {
                if (typeof desktopMasks[value] !== 'undefined') {
                    $('.score-field-rules-row-value-desctop-mask-'+fieldName).mask(desktopMasks[value].mask_value, {autoclear: false});
                } else {
                    $('.score-field-rules-row-value-desctop-mask-'+fieldName).mask('(999) 999 9999', {autoclear: false});
                }
            }
        },
    });

    return LeadWorkflowRulesView;
});
