define([
    'backbone',
    'plupload',
    'pluploadhtml5',
    'pluploadflash',
    'pluploadhtml4',
    'i18n!../../../nls/config_'+$('#lead-import-leads-config-system-language').val()+'_ln.js'
], function(Backbone, plupload, pluploadhtml5, pluploadflash, pluploadhtml4, i18n){
    var CrmImportLeadsAndOrganizationsConfigMainView = Backbone.View.extend({
        el: $('#lead-crm-leads-and-organizations-config-block'),
        events:{
            'click .extanded-configuration-swicher': 'extandedConfigurationSwicher',
            'click .extended-import-config' : 'extendedImportConfig',
            'click .close-screen': 'closeExtendedImportConfigScreen',
            'click .leads-organizations-pickfiles' : 'leadsOrganizationsPickfilesTrigger'
        },
        templates: {},
        initialize: function(){

            var options = {
                runtimes: 'html5,flash,html4',
                browse_button: 'upload-file-button',
                container: 'lead-crm-leads-and-organizations-config-block',
                max_file_size: '100mb',
                url: $('#website_url').val()+'plugin/leads/run/uploadLeadsOrganizationsCsv/',
                filters: [
                    {title: "Zip files", extensions: "csv"}
                ],
                multipart_params: {
                    secureToken: '',
                    importType:'',
                    updateFields:'',
                    concatFields:'',
                    useExtendedConfiguration: 0
                }
            };

            this.importLeadsOrganizationsUploader = new plupload.Uploader(options);

            this.importLeadsOrganizationsUploader.init();

            this.importLeadsOrganizationsUploader.bind('BeforeUpload', _.bind(this.beforeUpload, this));
            this.importLeadsOrganizationsUploader.bind('FilesAdded', _.bind(this.filesAdded, this));
            this.importLeadsOrganizationsUploader.bind('UploadProgress', _.bind(this.uploadProgress, this));
            this.importLeadsOrganizationsUploader.bind('FileUploaded', _.bind(this.fileUploaded, this));
            this.importLeadsOrganizationsUploader.bind('Error', _.bind(this.handleUploadErrors, this));
            setTimeout(() => $('.ticon-info').tooltip({
                content: function () {
                    return $(this).attr("title");
                }
            }),  100);
        },
        filesAdded: function(up, files)
        {
            var importType = $('input[name=switchImportType]:checked').val();
            if(importType === 'lead' || importType === 'organization'){
                var useExtendedConfiguration = $('input[name=useExtendedConfiguration]:checked').val();
                if(!_.isUndefined(useExtendedConfiguration)){
                    this.importLeadsOrganizationsUploader.settings.multipart_params.useExtendedConfiguration = useExtendedConfiguration;
                }

                this.importLeadsOrganizationsUploader.settings.multipart_params.concatFields = this.processLeadsOrganizationsConcatFields(importType);
                this.importLeadsOrganizationsUploader.settings.multipart_params.updateFields = this.processLeadsOrganizationsUpdateFields(importType);
            }

            this.importLeadsOrganizationsUploader.settings.multipart_params.secureToken = $('#import-leads-organizations-secure-token').val();
            this.importLeadsOrganizationsUploader.settings.multipart_params.importType = $('input[name=switchImportType]:checked').val();
            this.importLeadsOrganizationsUploader.start();
        },
        uploadProgress: function(up, file)
        {
            $('#progressbar').progressbar({value: file.percent}).text(file.percent);
        },
        fileUploaded: function(up, file, info)
        {
            var response = jQuery.parseJSON(info.response),
                websiteUrl = $('#website_url').val(),
                self = this;
            if (response.error == '0') {
                var importType = $('input[name=switchImportType]:checked').val();
                if (importType === 'organization') {
                    $('#extendedImportOrganizationConfig').hide('slide', { direction: 'right'});
                    $('#creating-label').text(_.isUndefined(i18n['Creating organizations'])?'Creating organizations':i18n['Creating organizations']);
                }
                if (importType === 'lead') {
                    $('#extendedImportLeadConfig').hide('slide', { direction: 'right'});
                    $('#creating-label').text(_.isUndefined(i18n['Creating leads'])?'Creating leads':i18n['Creating leads']);
                }

                if (importType === 'lead-tasks') {
                    $('#creating-label').text(_.isUndefined(i18n['Creating tasks'])?'Creating tasks':i18n['Creating tasks']);
                }

                $('#import-leads-organizations-start').toggleClass('hidden');
                this.importProcedure();
            } else {
                showMessage(response.responseText, true, 5000);
            }

            $('#progressbar').delay(800).fadeOut();
        },
        handleUploadErrors: function()
        {

        },
        beforeUpload: function(up, file){

            this.importLeadsOrganizationsUploader.settings.multipart_params.importType = $('input[name=switchImportType]:checked').val();
            $('#progressbar').fadeIn().progressbar({value: 0});
        },
        importProcedure: function()
        {
            var self = this;
            $.ajax({
                url: $('#website_url').val()+'plugin/leads/run/importLeads/',
                dataType: 'json',
                type: 'POST',
                data: {
                    'secureToken': $('#import-leads-organizations-secure-token').val(),
                    'importType': $('input[name=switchImportType]:checked').val()
                }
            }).done(function (response) {
                var importedEl = $('#imported-leads-organizations'),
                    importedQuantity = parseInt(importedEl.text());

                self.importLeadsOrganizationsUploader.settings.multipart_params.importType = '';
                self.importLeadsOrganizationsUploader.settings.multipart_params.updateFields = '';
                self.importLeadsOrganizationsUploader.settings.multipart_params.concatFields = '';
                self.importLeadsOrganizationsUploader.settings.multipart_params.useExtendedConfiguration = 0;
                if (response.error == 0) {
                    var counter = response.responseText.importedQuantity;
                    importedEl.text(counter + importedQuantity);
                    self.importProcedure();
                } else {
                    if (response.responseText.generalError) {
                        $('#leads-organizations-import-log').removeClass('hidden');
                        showMessage(response.responseText.generalError, true, 5000);
                    } else {
                        showMessage(response.responseText, false, 5000);
                        $('#leads-organizations-import-log').addClass('hidden');
                    }
                    $('#leads-organizations-import-log-full').removeClass('hidden');
                    importedEl.text(0);
                    $('#import-leads-organizations-start').toggleClass('hidden');
                }
            });
        },
        extandedConfigurationSwicher: function (e) {
            var importType = $('input[name=switchImportType]:checked').val();
            $('.extended-info').addClass('hidden');
            if(importType === 'lead' || importType === 'organization'){
                $('.extended-import-config').data('import-config', importType);
                $('#extended-info-'+importType).removeClass('hidden');

                setTimeout(() => $('.ticon-info').tooltip({
                    content: function () {
                        return $(this).attr("title");
                    }
                }),  100);
            }else{
                $('.extended-import-config').data('import-config', '');
            }

            if (importType !== 'organization' && importType !== 'lead') {
                $('#extended-configuration-block').addClass('hidden');
            } else {
                $('#extended-configuration-block').removeClass('hidden');
            }
        },
        extendedImportConfig: function (e) {
            e.preventDefault();
            var exImportConfigData = $('.extended-import-config').data('import-config');
            if(exImportConfigData === 'lead'){
                $('#extendedImportLeadConfig').show('slide', { direction: 'right'});
                $('#use-extended-configuration').prop('checked',true);
            }

            if(exImportConfigData === 'organization'){
                $('#extendedImportOrganizationConfig').show('slide', { direction: 'right'});
                $('#use-extended-configuration').prop('checked',true);
            }
        },
        closeExtendedImportConfigScreen: function(e){
            e.preventDefault();
            var importType = $('input[name=switchImportType]:checked').val();

            if(importType === 'lead'){
                $('#extendedImportLeadConfig').hide('slide', { direction: 'right'});
            }

            if(importType === 'organization'){
                $('#extendedImportOrganizationConfig').hide('slide', { direction: 'right'});
            }
        },
        leadsOrganizationsPickfilesTrigger : function (e) {
            e.preventDefault();
            $('#upload-file-button').trigger('click');
        },
        processLeadsOrganizationsUpdateFields: function (importType) {
            var updateFields,
                updateFieldsValues = [];
            if(importType === 'lead'){
                updateFields = $('input.updateLeads:checked');
            }

            if(importType === 'organization'){
                updateFields = $('input.updateOrganizations:checked');
            }

            if(!_.isUndefined(updateFields)){
                _.each(updateFields, function(value, key){
                    updateFieldsValues.push(value.value);
                });
            }
            return updateFieldsValues;
        },
        processLeadsOrganizationsConcatFields: function (importType) {
            var concatFields,
                concatFieldsValues = [];
            if(importType === 'lead'){
                if($('input#lead-notes-concat').is(':checked')){
                    $('input#lead-notes').prop('checked',true);
                }
                if($('input#lead-tags-concat').is(':checked')){
                    $('input#lead-tags').prop('checked',true);
                }
                concatFields = $('input.concatLeads:checked');
            }

            if(!_.isUndefined(concatFields)){
                _.each(concatFields, function(value, key){
                    concatFieldsValues.push(value.value);
                });
            }
            return concatFieldsValues;
        }
    });

    return CrmImportLeadsAndOrganizationsConfigMainView;
});