import {mapGetters} from 'vuex';
import lodash from 'lodash';
import localeMapping from '../../../localizationLanguages';
import { VueDraggableNext } from 'vue-draggable-next'
import opportunities from "../index";

export default {
    data () {
        return {
            loadedScreen: false,
            websiteUrl: $('#website_url').val(),
            editable: true,
            toDraggableStageId: '',
            opportunityId: '',
            enabledUnqualified: false,
            enabledNeedsAssessment: false,
            enabledQualified: false,
            enabledMeetingSet: false,
            enabledMeetingHeld: false,
            enabledProposalSent: false,
            enabledProposalAcknowledged: false,
            enabledObjectionsRaised: false,
            enabledObjectionsOvercame: false,
            enabledLost: false,
            enabledWon: false,
            firstLoadScreen: false,
            localeMapping: localeMapping,
            opportunityStages: [],

        }
    },
    components: {
        draggable:VueDraggableNext,
    },
    computed: {
        ...mapGetters({
            formatDate:                  'formatDate',
            formatTimeOnly:              'formatTimeOnly',
            filterDateFrom:              'getFilterDateFrom',
            filterDateTo:                'getFilterDateTo',
            changedDate:                 'getChangedDate',
            filterPeriodMonths:          'getFilterPeriodMonths',
            selectedUserId:              'getSelectedUserId',
            additionalInfo:              'getAdditionalInfo',
            forecastedSales:             'getForecastedSales',
            pipelineSize:                'getPipelineSize',
            formatOnlyDate:              'formatOnlyDate',
            opportunities:               'getOpportunities',
            opportunitiesAdditionalInfo: 'getOpportunitiesAdditionalInfo',
            toCurrency:                  'toCurrency',
            Unqualified:                 'getUnqualified',
            NeedsAssessment:             'getNeedsAssessment',
            Qualified:                   'getQualified',
            MeetingSet:                  'getMeetingSet',
            MeetingHeld:                 'getMeetingHeld',
            ProposalSent:                'getProposalSent',
            ProposalAcknowledged:        'getProposalAcknowledged',
            ObjectionsRaised:            'getObjectionsRaised',
            ObjectionsOvercame:          'getObjectionsOvercame',
            Lost:                        'getLost',
            Won:                         'getWon',
        }),
        dragOptions() {
            return {
                //animation: 200,
                group: "opportunities",
                ghostClass: "ghost",
                class: "list-group",

            };
        },
        unqualifiedTotal() {
            this.enabledUnqualified = true;
            if(this.Unqualified.length == '0') {
                this.enabledUnqualified = false;
            }

            let total = 0;
            for(let i = 0; i < this.Unqualified.length; i++){
                total += parseInt(this.Unqualified[i].opportunityValue);
            }
            return this.toCurrency(total, 0);
        },
        needsAssessmentTotal() {
            this.enabledNeedsAssessment = true;
            if(this.NeedsAssessment.length == '0') {
                this.enabledNeedsAssessment = false;
            }

            let total = 0;
            for(let i = 0; i < this.NeedsAssessment.length; i++){
                total += parseInt(this.NeedsAssessment[i].opportunityValue);
            }
            return this.toCurrency(total, 0);
        },
        qualifiedTotal() {
            this.enabledQualified = true;
            if(this.Qualified.length == '0') {
                this.enabledQualified = false;
            }

            let total = 0;
            for(let i = 0; i < this.Qualified.length; i++){
                total += parseInt(this.Qualified[i].opportunityValue);
            }
            return this.toCurrency(total, 0);
        },
        meetingSetTotal() {
            this.enabledMeetingSet = true;
            if(this.MeetingSet.length == '0') {
                this.enabledMeetingSet = false;
            }

            let total = 0;
            for(let i = 0; i < this.MeetingSet.length; i++){
                total += parseInt(this.MeetingSet[i].opportunityValue);
            }
            return this.toCurrency(total, 0);
        },
        meetingHeldTotal() {
            this.enabledMeetingHeld = true;
            if(this.MeetingHeld.length == '0') {
                this.enabledMeetingHeld = false;
            }

            let total = 0;
            for(let i = 0; i < this.MeetingHeld.length; i++){
                total += parseInt(this.MeetingHeld[i].opportunityValue);
            }
            return this.toCurrency(total, 0);
        },
        proposalSentTotal() {
            this.enabledProposalSent = true;
            if(this.ProposalSent.length == '0') {
                this.enabledProposalSent = false;
            }

            let total = 0;
            for(let i = 0; i < this.ProposalSent.length; i++){
                total += parseInt(this.ProposalSent[i].opportunityValue);
            }
            return this.toCurrency(total, 0);
        },
        proposalAcknowledgedTotal() {
            this.enabledProposalAcknowledged = true;
            if(this.ProposalAcknowledged.length == '0') {
                this.enabledProposalAcknowledged = false;
            }

            let total = 0;
            for(let i = 0; i < this.ProposalAcknowledged.length; i++){
                total += parseInt(this.ProposalAcknowledged[i].opportunityValue);
            }
            return this.toCurrency(total, 0);
        },
        objectionsRaisedTotal() {
            this.enabledObjectionsRaised = true;
            if(this.ObjectionsRaised.length == '0') {
                this.enabledObjectionsRaised = false;
            }

            let total = 0;
            for(let i = 0; i < this.ObjectionsRaised.length; i++){
                total += parseInt(this.ObjectionsRaised[i].opportunityValue);
            }
            return this.toCurrency(total, 0);
        },
        objectionsOvercameTotal() {
            this.enabledObjectionsOvercame = true;
            if(this.ObjectionsOvercame.length == '0') {
                this.enabledObjectionsOvercame = false;
            }

            let total = 0;
            for(let i = 0; i < this.ObjectionsOvercame.length; i++){
                total += parseInt(this.ObjectionsOvercame[i].opportunityValue);
            }
            return this.toCurrency(total, 0);
        },
        lostTotal() {
            this.enabledLost = true;
            if(this.Lost.length == '0') {
                this.enabledLost = false;
            }

            let total = 0;
            for(let i = 0; i < this.Lost.length; i++){
                total += parseInt(this.Lost[i].opportunityValue);
            }
            return this.toCurrency(total, 0);
        },
        wonTotal() {
            this.enabledWon = true;
            if(this.Won.length == '0') {
                this.enabledWon = false;
            }

            let total = 0;
            for(let i = 0; i < this.Won.length; i++){
                total += parseInt(this.Won[i].opportunityValue);
            }
            return this.toCurrency(total, 0);
        },

    },
    watch: {
        selectedUserId (newUserId, oldUseId) {
            this.applyFilter();
        },
        changedDate () {
            this.applyFilter();
        }
    },
    methods: {
        async applyFilter() {
            const result = await this.$store.dispatch('getGeneralopportunities', {'router':this.$router, 'userId':this.selectedUserId, 'filterDateFrom':this.filterDateFrom, 'filterDateTo':this.filterDateTo});
            if(result.status === 'error') {
                showMessage('Please re-login', true, 3000);
            } else {
                this.loadedScreen = true;
            }
        },
        log: function(evt) {
            if(typeof evt.added !== 'undefined') {
                this.opportunityId = evt.added.element.oppId;
            }
            console.log(evt)
        },
        onEnd: function (evt) {
            this.toDraggableStageId = '';
            if(typeof evt.to.dataset.type !== 'undefined' && evt.to.dataset.type !== '') {
                this.toDraggableStageId = evt.to.dataset.type;
                this.toggleDragFirstEl('end', evt.to.dataset.type);

                this.changeOpportunityStage();

                console.log('data-type', evt.to.dataset.type);
            }
        },
        onStart: function (elType) {
            this.toggleDragFirstEl('start');

            if(elType == '10') {
                if(this.Unqualified.length == '1') {
                    $('.drop-Unqualified').removeClass('hide');
                }
            }

            if(elType == '20') {
                if(this.NeedsAssessment.length == '1') {
                    $('.drop-NeedsAssessment').removeClass('hide');
                }
            }

            if(elType == '30') {
                if(this.Qualified.length == '1') {
                    $('.drop-Qualified').removeClass('hide');
                }
            }

            if(elType == '40') {
                if(this.MeetingSet.length == '1') {
                    $('.drop-MeetingSet').removeClass('hide');
                }
            }

            if(elType == '50') {
                if(this.MeetingHeld.length == '1') {
                    $('.drop-MeetingHeld').removeClass('hide');
                }
            }

            if(elType == '60') {
                if(this.ProposalSent.length == '1') {
                    $('.drop-ProposalSent').removeClass('hide');
                }
            }

            if(elType == '70') {
                if(this.ProposalAcknowledged.length == '1') {
                    $('.drop-ProposalAcknowledged').removeClass('hide');
                }
            }

            if(elType == '80') {
                if(this.ObjectionsRaised.length == '1') {
                    $('.drop-ObjectionsRaised').removeClass('hide');
                }
            }

            if(elType == '90') {
                if(this.ObjectionsOvercame.length == '1') {
                    $('.drop-ObjectionsOvercame').removeClass('hide');
                }
            }

            if(elType == '1') {
                if(this.Lost.length == '1') {
                    $('.drop-Lost').removeClass('hide');
                }
            }

            if(elType == '100') {
                if(this.Won.length == '1') {
                    $('.drop-Won').removeClass('hide');
                }
            }
        },
        toggleDragFirstEl: function (event, toDraggableStageId) {
            let doDragg = true;
            if(event == 'end') {
                doDragg = false;
            }

            if(this.Unqualified.length == '0') {
                this.enabledUnqualified = doDragg;
            } else if (toDraggableStageId == '10') {
                $('.drop-Unqualified').addClass('hide');
            }

            if(this.NeedsAssessment.length == '0') {
                this.enabledNeedsAssessment = doDragg;
            } else if (toDraggableStageId == '20') {
                $('.drop-NeedsAssessment').addClass('hide');
            }

            if(this.Qualified.length == '0') {
                this.enabledQualified = doDragg;
            } else if (toDraggableStageId == '30') {
                $('.drop-Qualified').addClass('hide');
            }

            if(this.MeetingSet.length == '0') {
                this.enabledMeetingSet = doDragg;
            } else if (toDraggableStageId == '40') {
                $('.drop-MeetingSet').addClass('hide');
            }

            if(this.MeetingHeld.length == '0') {
                this.enabledMeetingHeld = doDragg;
            } else if (toDraggableStageId == '50') {
                $('.drop-MeetingHeld').addClass('hide');
            }

            if(this.ProposalSent.length == '0') {
                this.enabledProposalSent = doDragg;
            } else if (toDraggableStageId == '60') {
                $('.drop-ProposalSent').addClass('hide');
            }

            if(this.ProposalAcknowledged.length == '0') {
                this.enabledProposalAcknowledged = doDragg;
            } else if (toDraggableStageId == '70') {
                $('.drop-ProposalAcknowledged').addClass('hide');
            }

            if(this.ObjectionsRaised.length == '0') {
                this.enabledObjectionsRaised = doDragg;
            } else if (toDraggableStageId == '80') {
                $('.drop-ObjectionsRaised').addClass('hide');
            }

            if(this.ObjectionsOvercame.length == '0') {
                this.enabledObjectionsOvercame = doDragg;
            } else if (toDraggableStageId == '90') {
                $('.drop-ObjectionsOvercame').addClass('hide');
            }

            if(this.Lost.length == '0') {
                this.enabledLost = doDragg;
            } else if (toDraggableStageId == '1') {
                $('.drop-Lost').addClass('hide');
            }

            if(this.Won.length == '0') {
                this.enabledWon = doDragg;
            } else if (toDraggableStageId == '100') {
                $('.drop-Won').addClass('hide');
            }
        },
        async changeOpportunityStage() {
            const result = await this.$store.dispatch('changeOpportunityStage', {'router':this.$router, 'opportunityId': this.opportunityId, 'toDraggableStageId': this.toDraggableStageId, 'userId':this.selectedUserId, 'filterDateFrom':this.filterDateFrom, 'filterDateTo':this.filterDateTo});
            if(result.status === 'error') {
                if(result.type != 'nothingChange') {
                    const resultData = await this.$store.dispatch('getGeneralopportunities', {'router':this.$router, 'userId':this.selectedUserId, 'filterDateFrom':this.filterDateFrom, 'filterDateTo':this.filterDateTo});
                    showMessage(result.message, true, 3000);
                }
            } else {
                if(typeof result.status !== 'undefined' && result.status != 'nothingChange') {
                    this.$store.commit('setForecastedSales', result.opportunitiesForecastData.forecastedSales);
                    this.$store.commit('setPipelineSize', result.opportunitiesForecastData.pipelineSize);
                }
                this.loadedScreen = true;
            }
        },
        hideOpportunity(id, opportunityStageId) {
            let areYouSure = this.$t('message.areYouSure'),
                yesValue = this.$t('message.yesValue'),
                noValue = this.$t('message.noValue'),
                opportunitiesHasBeenHidden = this.$t('message.opportunitiesHasBeenHidden');

            if(id == 'hideAll') {
                areYouSure = this.$t('message.areYouSureAll');
                yesValue = this.$t('message.yesValueAll');
                noValue = this.$t('message.noValueAll')
                opportunitiesHasBeenHidden = this.$t('message.opportunitiesHasBeenHiddenAll');
            }

            showConfirmCustom(areYouSure, yesValue, noValue, async () => {
                const result = await this.$store.dispatch('hideOpportunity', {'router':this.$router, 'id': id, 'userId':this.selectedUserId, 'opportunityStageId': opportunityStageId});
                if(result.status === 'error') {
                    showMessage(result.message, true, 3000);
                } else {
                    showMessage(opportunitiesHasBeenHidden, false, 1500);
                }
                const resultData = await this.$store.dispatch('getGeneralopportunities', {'router':this.$router, 'userId':this.selectedUserId, 'filterDateFrom':this.filterDateFrom, 'filterDateTo':this.filterDateTo});

                if(resultData.status === 'error') {
                    showMessage('Please re-login', true, 3000);
                } else {
                    this.loadedScreen = true;
                }
            }, async () => {

            }, 'hide-opportunity-dialog');
        }
    },
    async created(){
        this.applyFilter();
    },
    async updated() {
        this.$nextTick(function () {
            if (typeof checkboxRadioStyle !== 'undefined' && typeof checkboxRadioStyle() === "function") {
                checkboxRadioStyle();
            }

            if(!this.firstLoadScreen) {
                this.firstLoadScreen = true;
                var countColumn = $('.opp-type-draggable-block');

                if(countColumn.length) {
                    $('.scroll-bar').css('width', (countColumn.length * 227) + 'px');
                }

                $('.opportunities-block-scroll').on('scroll', function (e) {
                    $('#opportunities-block').scrollLeft($('.opportunities-block-scroll').scrollLeft());
                });

                $('#opportunities-block').on('scroll', function (e) {
                    $('.opportunities-block-scroll').scrollLeft($('#opportunities-block').scrollLeft());
                });
            }
        });

    }
}
