import {mapGetters} from 'vuex';
import lodash from 'lodash';
import localeMapping from '../../../localizationLanguages';
import moment from 'moment';
import opportunities from '../../opportunities';
import VueDatePicker from '@vuepic/vue-datepicker';
import '@vuepic/vue-datepicker/dist/main.css';

export default {
    data () {
        return {
            loadedScreen: false,
            leadOwnerId: '-2',
            websiteUrl: $('#website_url').val(),
            localeMapping: localeMapping,
            locale: $('#dashboard-system-language').val(),
            filterDate: '1',
            filterDateFrom:'',
            filterDateFromForDatepicker:'',
            filterDateToForDatepicker:'',
            filterDateTo:'',
            filterPeriodMonths:'1',
            disableDatepicker: 1,
            componentKey: 0,
            minDate: null,
            maxDate: null,
        }
    },
    components: {
        opportunities:opportunities,
        VueDatePicker
    },
    computed: {
        ...mapGetters({
            sortByColumn: 'sortByColumn',
            additionalInfo:'getAdditionalInfo',
            toCurrency: 'toCurrency',
            forecastedSales:'getForecastedSales',
            pipelineSize:'getPipelineSize',
            formatDate: 'formatDate',
            formatOnlyDate: 'formatOnlyDate',
            formatTimeOnly: 'formatTimeOnly',
        }),
    },
    methods: {
        async changeOwner()
        {
            this.$store.commit('setSelectedUserId', this.leadOwnerId);
            //this.$store.commit('setSelectedDate', this.filterDate);
            //this.$store.commit('setFilterDateFrom', this.filterDateFrom);
            //this.$store.commit('setFilterDateTo', this.filterDateTo);
            //this.$store.commit('setFilterPeriodMonths', this.filterPeriodMonths);

        },
        selectedDatepickerDate(selectedDate, datepickerType){
            if (datepickerType === 'date-from') {
                this.minDate = selectedDate;
            } else {
                this.maxDate = selectedDate;
            }
            this.componentKey += 1;

        },
        async showOpportunities(){
            this.filterDateFrom = moment(this.filterDateFromForDatepicker).format('YYYY-MM-DD HH:mm:ss');
            this.filterDateTo = moment(this.filterDateToForDatepicker).format('YYYY-MM-DD HH:mm:ss');

            this.$store.commit('setFilterPeriodMonths', this.filterPeriodMonths);
            this.$store.commit('setSelectedDate', this.filterDate);
            this.$store.commit('setFilterDateFrom', this.filterDateFrom);
            this.$store.commit('setFilterDateTo', this.filterDateTo);
            this.$store.commit('setChangedDate', (Date.now() % 1000) / 1000);
        },
        async changeDate()
        {
            let filterDate = this.filterDate,
                userDateFrom = moment(this.additionalInfo.userDate),
                userDateTo = moment(this.additionalInfo.userDate);


            switch (filterDate) {
                case '1'://This month
                    this.filterDateFromForDatepicker = userDateFrom.startOf('month').toDate();
                    this.filterDateToForDatepicker = userDateTo.endOf('month').toDate();
                    this.disableDatepicker = 1;
                    this.filterPeriodMonths = 1;
                    break;
                case '5'://Today
                    this.filterDateFromForDatepicker = userDateFrom.startOf('day').toDate();
                    this.filterDateToForDatepicker = userDateTo.endOf('day').toDate();
                    this.disableDatepicker = 1;
                    this.filterPeriodMonths = 0;
                    break;
                case '6'://Yesterday
                    this.filterDateFromForDatepicker = userDateFrom.subtract(1, 'days').startOf('day').toDate();
                    this.filterDateToForDatepicker = userDateTo.subtract(1, 'days').endOf('day').toDate();
                    this.disableDatepicker = 1;
                    this.filterPeriodMonths = 0;
                    break;
                case "15"://Next month
                    this.filterDateFromForDatepicker = userDateFrom.add(1, 'month').startOf('month').toDate();
                    this.filterDateToForDatepicker = userDateTo.add(1, 'month').endOf('month').toDate();
                    this.disableDatepicker = 1;
                    this.filterPeriodMonths = 1;
                    break;
                case "16"://Next 30 days
                    this.filterDateFromForDatepicker = userDateFrom.startOf('day').toDate();
                    this.filterDateToForDatepicker = userDateTo.add(30, 'days').endOf('day').toDate();
                    this.disableDatepicker = 1;
                    this.filterPeriodMonths = 0;
                    break;
                case "17"://Next 60 days
                    this.filterDateFromForDatepicker = userDateFrom.startOf('day').toDate();
                    this.filterDateToForDatepicker = userDateTo.add(60, 'days').endOf('day').toDate();
                    this.disableDatepicker = 1;
                    this.filterPeriodMonths = 0;
                    break;
                case '8'://Last week
                    this.filterDateFromForDatepicker = userDateFrom.subtract(1, 'weeks').startOf('isoWeek').toDate();
                    this.filterDateToForDatepicker = userDateTo.subtract(1, 'weeks').endOf('isoWeek').toDate();
                    this.disableDatepicker = 1;
                    this.filterPeriodMonths = 0;
                    break;
                case '9'://Last month
                    this.filterDateFromForDatepicker = userDateFrom.subtract(1, 'month').startOf('month').toDate();
                    this.filterDateToForDatepicker = userDateTo.subtract(1, 'month').endOf('month').toDate();
                    this.disableDatepicker = 1;
                    this.filterPeriodMonths = 1;
                    break;
                case '7'://Last 7 days
                    this.filterDateFromForDatepicker = userDateFrom.subtract(7, 'days').startOf('day').toDate();
                    this.filterDateToForDatepicker = userDateTo.endOf('day').toDate();
                    this.disableDatepicker = 1;
                    this.filterPeriodMonths = 0;
                    break;
                case '10'://Last 30 days
                    this.filterDateFromForDatepicker = userDateFrom.subtract(30, 'days').startOf('day').toDate();
                    this.filterDateToForDatepicker = userDateTo.endOf('day').toDate();
                    this.disableDatepicker = 1;
                    this.filterPeriodMonths = 0;
                    break;
                case '2'://This quarter
                    this.filterDateFromForDatepicker = userDateFrom.startOf('quarter').toDate();
                    this.filterDateToForDatepicker = userDateTo.endOf('quarter').toDate();
                    this.disableDatepicker = 1;
                    this.filterPeriodMonths = 3;
                    break;
                case '11'://Last quarter
                    this.filterDateFromForDatepicker = userDateFrom.subtract(1, 'quarter').startOf('quarter').toDate();
                    this.filterDateToForDatepicker = userDateTo.subtract(1, 'quarter').endOf('quarter').toDate();
                    this.disableDatepicker = 1;
                    this.filterPeriodMonths = 3;
                    break;
                case '3'://This year
                    this.filterDateFromForDatepicker = userDateFrom.startOf('year').toDate();
                    this.filterDateToForDatepicker = userDateTo.endOf('year').toDate();
                    this.disableDatepicker = 1;
                    this.filterPeriodMonths = 12;
                    break;
                case '4'://This fiscal year
                    this.filterDateFromForDatepicker = userDateFrom.startOf('year').add(this.additionalInfo.fiscalYearStartMonth -1, 'M').toDate();
                    this.filterDateToForDatepicker = userDateFrom.startOf('year').add(this.additionalInfo.fiscalYearStartMonth -1, 'M').add('1', 'Y').subtract('1', 'd').toDate();
                    this.disableDatepicker = 1;
                    this.filterPeriodMonths = 12;
                    break;
                case '12'://Last year
                    this.filterDateFromForDatepicker = userDateFrom.subtract(1, 'year').startOf('year').toDate();
                    this.filterDateToForDatepicker = userDateTo.subtract(1, 'year').endOf('year').toDate();
                    this.disableDatepicker = 1;
                    this.filterPeriodMonths = 12;
                    break;
                case '13'://Last fiscal year
                    this.filterDateFromForDatepicker = userDateFrom.startOf('year').add(this.additionalInfo.fiscalYearStartMonth -1, 'M').subtract('1', 'Y').toDate();
                    this.filterDateToForDatepicker = userDateFrom.startOf('year').add('1', 'Y').add(this.additionalInfo.fiscalYearStartMonth -1, 'M').subtract('1', 'd').toDate();
                    this.disableDatepicker = 1;
                    this.filterPeriodMonths = 12;
                    break;
                case "14":
                    this.disableDatepicker = 0;
                    this.filterPeriodMonths = 0;
                    this.minDate = this.filterDateFromForDatepicker;
                    this.maxDate = this.filterDateToForDatepicker;
                    this.componentKey += 1;
                    break;
                default:
                    this.disableDatepicker = 1;
                    this.filterPeriodMonths = 0;
                    break;
            }

            this.filterDateFrom = moment(this.filterDateFromForDatepicker).format('YYYY-MM-DD HH:mm:ss');
            this.filterDateTo = moment(this.filterDateToForDatepicker).format('YYYY-MM-DD HH:mm:ss');
        }

    },
    async created(){
        if (typeof this.localeMapping[this.locale] !== 'undefined') {
            this.$i18n.locale = this.localeMapping[this.locale];
        }

        const result = await this.$store.dispatch('getGeneralOpportunitiesScreenData', {'router':this.$router});
        if(result.status === 'error') {
            showMessage('Please re-login', true, 3000);
        } else {
            this.changeDate();
            this.$store.commit('setSelectedDate', this.filterDate);
            this.$store.commit('setFilterDateFrom', this.filterDateFrom);
            this.$store.commit('setFilterDateTo', this.filterDateTo);
            this.$store.commit('setFilterPeriodMonths', this.filterPeriodMonths);
            this.loadedScreen = true;
        }

    },
    async updated() {
        this.$nextTick(function () {
            if (typeof checkboxRadioStyle !== 'undefined' && typeof checkboxRadioStyle() === "function") {
                checkboxRadioStyle();
            }
        })
    }
}
