export const getGeneralUsersScreenData = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        showSpinner('#dashboard-manage-users-screen-config-block', 'dashboard-manage-users-screen-config-spinner dashboard-spinner');
        $.ajax({
            'url': $('#website_url').val()+'api/leadsdashboard/manageusersgeneralinfo/',
            'type': 'GET',
            'dataType': 'json',
            'data': {
                'id': payload.id
            }
        }).done(async  function(response){
            hideSpinner('.dashboard-manage-users-screen-config-spinner');
            if (response.status !== 'error') {
                commit('setConfigDataInfo', response.data);
                commit('setAdditionalInfo', response.additionalInfo);
                resolve(response);
            } else {
                resolve({ name: 'login', 'message': 'Please re-login'});
            }
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};

export const getUsersGridData = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        showSpinner('#manage-users-grid-table-block', 'manage-users-grid-table-block-spinner dashboard-spinner');
        $.ajax({
            'url': $('#website_url').val()+'api/leadsdashboard/manageusers/',
            'type': 'GET',
            'dataType': 'json',
            'data': {
                'limit': state.pagination.manageUsersGrid.itemsPerPage,
                'offset': (state.pagination.manageUsersGrid.currentPage - 1) * state.pagination.manageUsersGrid.itemsPerPage,
                'filter': payload.searchData
            }
        }).done(async  function(response){
            hideSpinner('.manage-users-grid-table-block-spinner');
            if (response.status !== 'error') {
                commit('setUserGridInfo', response.data);
                commit('setUsersAdditionalInfo', response.additionalInfo);
                commit('setPaginationData', {manageUsersGrid: {totalItems: response.totalRecords}});
                resolve(response);
            } else {
                resolve({ name: 'login', 'message': 'Please re-login'});
            }
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};

export const getUserDataInfo = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        showSpinner('#manage-users-grid-table-block', 'manage-users-grid-table-spinner dashboard-spinner');
        $.ajax({
            'url': $('#website_url').val()+'api/leadsdashboard/manageusers/',
            'type': 'GET',
            'dataType': 'json',
            'data': {
                'id': payload.id,
            }
        }).done(async  function(response){
            hideSpinner('.manage-users-grid-table-spinner');
            if (response.status !== 'error') {
                commit('setAdditionalInfoDetailedScreen', response.additionalInfo);
                commit('setCurrencyInfo', response.currencyInfo);
                resolve(response);
            } else {
                resolve({ name: 'login', 'message': 'Please re-login'});
            }
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};

export const createUser = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        showSpinner('#manage-users-mainscreen-dashboard-block', 'manage-users-mainscreen-dashboard-block-spinner dashboard-spinner');
        $.ajax({
            'url': $('#website_url').val() + 'api/leadsdashboard/manageusers/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'secureToken' : $('#dashboard-manage-users-screen-config-token').val(),
                'fullName': payload.fullName,
                'desktopNumber': payload.desktopNumber,
                'userDesktopCountryCode': payload.userDesktopCountryCode,
                'mobileNumber': payload.mobileNumber,
                'userMobileCountryCode': payload.userMobileCountryCode,
                'email': payload.email,
                'sendInvite':payload.sendInvite,
                'voipPhone':payload.voipPhone,
                'userRole':payload.userRole,
                'userPassword':payload.userPassword,
                'userTimezone':payload.userTimezone,
                'avatarLink':payload.avatarLink,
                'userPrefix':payload.userPrefix,
                'signature':payload.signature,
                'userSubscribed':payload.userSubscribed,
                'personalCalendarUrl':payload.personalCalendarUrl
            }
        }).done(async function (response) {
            hideSpinner('.manage-users-mainscreen-dashboard-block-spinner');
            if (response.status === 'error') {
                resolve(response);
            } else {
                resolve(response);
            }

        }).fail(async function(response){
            hideSpinner('.manage-users-mainscreen-dashboard-block-spinner');
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};


export const updateUser = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        showSpinner('#dashboard-manage-users-screen-config-block', 'dashboard-manage-users-screen-config-block-spinner dashboard-spinner');
        $.ajax({
            'url': $('#website_url').val() + 'api/leadsdashboard/manageusers/',
            'type': 'PUT',
            'dataType': 'json',
            'data': JSON.stringify({
                'userId':payload.userId,
                'secureToken' : $('#dashboard-manage-users-screen-config-token').val(),
                'fullName': payload.fullName,
                'desktopNumber': payload.desktopNumber,
                'userDesktopCountryCode': payload.userDesktopCountryCode,
                'mobileNumber': payload.mobileNumber,
                'userMobileCountryCode': payload.userMobileCountryCode,
                'email': payload.email,
                'sendInvite':payload.sendInvite,
                'voipPhone':payload.voipPhone,
                'userRole':payload.userRole,
                'userPassword':payload.userPassword,
                'userTimezone':payload.userTimezone,
                'avatarLink':payload.avatarLink,
                'userPrefix':payload.userPrefix,
                'signature':payload.signature,
                'userSubscribed':payload.userSubscribed,
                'personalCalendarUrl':payload.personalCalendarUrl,
                'userCustomAttributes':payload.userCustomAttributes,
                'listOfCustomAttributes':payload.listOfCustomAttributes,
                'enabledReports':payload.enabledReports,
                'reportCcEmail':payload.reportCcEmail,
                'preferableTime':payload.preferableTime,
                'reportTypes':payload.reportTypes,
                'mfaEnabled':payload.mfaEnabled,
                'enabledExcludeWeekends':payload.enabledExcludeWeekends,
            })
        }).done(async function (response) {
            hideSpinner('.dashboard-manage-users-screen-config-block-spinner');
            if (response.status === 'error') {
                resolve(response);
            } else {
                resolve(response);
            }

        }).fail(async function(response){
            hideSpinner('.dashboard-manage-users-screen-config-block-spinner');
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};

export const reLoginAsUser = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'plugin/leads/run/loginas/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'userId':payload.userId,
                'secureToken': $('#dashboard-manage-users-screen-config-token').val()
            }
        }).done(async  function(response){
            resolve(response);
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};

export const deleteUser = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        showSpinner('#manage-users-mainscreen-dashboard-block', 'manage-users-mainscreen-dashboard-block-spinner dashboard-spinner');
        $.ajax({
            'url': $('#website_url').val()+'api/leadsdashboard/manageusers/id/'+payload.userId,
            'type': 'DELETE',
            'dataType': 'json',
            'data': {

            }
        }).done(async  function(response){
            hideSpinner('.manage-users-mainscreen-dashboard-block-spinner');
            resolve(response);
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};

export const changeTimezone = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'plugin/leads/run/getzoneAbbr/',
            'type': 'GET',
            'dataType': 'json',
            'data': {
                'timezone': payload.timezone
            }
        }).done(async function(response){
            if (response.status !== 'error') {
                resolve(response);
            } else {
                resolve({ name: 'login', 'message': 'Please re-login'});
            }
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};


