import {mapGetters} from 'vuex';
import lodash from 'lodash';
import localeMapping from '../../../localizationLanguages';
import pagination from '../../pagination';
import usersgridtable from '../../usersgridtable';
import moment from 'moment';

import "tinymce/tinymce";
import 'tinymce/models/dom';
import 'tinymce/themes/silver';
import 'tinymce/icons/default';
import 'tinymce/skins/ui/oxide/skin.min.css';
import 'tinymce/skins/ui/oxide/content.min.css';
import 'tinymce/plugins/link';
import 'tinymce/plugins/autolink';
import 'tinymce/plugins/advlist';
import 'tinymce/plugins/image';
import 'tinymce/plugins/lists';
import 'tinymce/plugins/charmap';
import 'tinymce/plugins/preview';
import 'tinymce/plugins/fullscreen';
import 'tinymce/plugins/code';

import Editor from "@tinymce/tinymce-vue";

export default {
    data () {
        return {
            loadedScreen: false,
            websiteUrl: $('#website_url').val(),
            localeMapping: localeMapping,
            locale: $('#dashboard-system-language').val(),
            searchData:[],
            filterByRoleId: 0,
            filterByText:'',
            showRegistrationForm: false,
            userPrefix:'',
            userFullName:'',
            userEmail:'',
            userRole:'',
            userPassword:'',
            userMobileCountryCode:'',
            userMobileNumber:'',
            userDesktopCountryCode:'',
            userDesktopNumber:'',
            userSubscribed:0,
            voipPhone:'',
            userTimezone:'',
            personalCalendarUrl:'',
            avatarLink:'',
            signature:'',
            formProcessing:false
        }
    },
    components: {
        usersgridtable: usersgridtable,
        'editor': Editor

    },
    computed: {
        ...mapGetters({
            formatDate: 'formatDate',
            formatOnlyDate: 'formatOnlyDate',
            formatTimeOnly: 'formatTimeOnly',
            configDataInfo:'getConfigDataInfo',
            additionalInfo:'getAdditionalInfo',
            truncateText: 'truncateText',
            sortByColumn: 'sortByColumn',
            filterData:'getFilterData',
        }),
    },
    methods: {
        async changeActivePlanFilter()
        {
            this.applyFilter();
        },
        async applyFilter()
        {
             this.searchData['byRoleId'] = this.filterByRoleId;
             this.searchData['byText'] = this.filterByText;
             this.$store.commit('setChangeFilter', {
                 'searchData':this.searchData,
             });

            this.$store.commit('setPaginationData', {manageUsersGrid: {
                    currentPage: 1,
                    itemsPerPage: 10,
                    totalItems: 0,
                    visiblePages: 4
            }});

            this.$store.commit('setCheckedItems', {});
        },
        async resetFilter()
        {
            this.searchData = [];
            this.filterByPlanId = 0;
            this.filterByText = '';
            this.applyFilter();
        },
        async changeSearchText()
        {
            this.filterByText = '';
            this.applyFilter();
        },
        addNewUserSwitch()
        {
            if (this.showRegistrationForm === true) {
                this.showRegistrationForm = false;
            } else {
                this.showRegistrationForm = true;

                let self = this;

                setTimeout(() => self.changeMobileCountryCode(),  600);
                setTimeout(() => self.changeDesktopCountryCode(),  600);
            }
        },
        changeMobileCountryCode()
        {
            if (typeof this.additionalInfo.mobileMasks[this.userMobileCountryCode] !== 'undefined') {
                $(document).find('#user-mobile-number').mask(this.additionalInfo.mobileMasks[this.userMobileCountryCode].mask_value, {autoclear: false});
            } else {
                $(document).find('#user-mobile-number').mask('(999) 999 9999', {autoclear: false});
            }
        },
        changeDesktopCountryCode()
        {
            if (typeof this.additionalInfo.desktopMasks[this.userDesktopCountryCode] !== 'undefined') {
                $(document).find('#user-desktop-number').mask(this.additionalInfo.desktopMasks[this.userDesktopCountryCode].mask_value, {autoclear: false});
            } else {
                $(document).find('#user-desktop-number').mask('(999) 999 9999', {autoclear: false});
            }
        },
        async createOnlyUser()
        {
            this.createUser();
        },
        async createUserAndInvite()
        {
            this.createUser(1);
        },
        async createUser(withInvite)
        {
            if (this.formProcessing === true) {
                return false;
            }

            this.formProcessing = true;

            let sendInvite = 0;
            if (withInvite === 1) {
                sendInvite = 1;
            }

            let desktopNumber = $(document).find('#user-desktop-number').val();
                this.userDesktopNumber = desktopNumber;
            let mobileNumber = $(document).find('#user-mobile-number').val();
                this.userMobileNumber = mobileNumber;

            if (this.userFullName === '') {
                showMessage(this.$t('message.pleaseSpecifyFullName'), true, 2000);
                this.formProcessing = false;
                return false;
            }

            if (this.userEmail === '') {
                showMessage(this.$t('message.pleaseSpecifyEmail'), true, 2000);
                this.formProcessing = false;
                return false;
            }

            if (this.userPassword === '') {
                showMessage(this.$t('message.pleaseSpecifyPassword'), true, 2000);
                this.formProcessing = false;
                return false;
            }

            if (this.userRole === '') {
                showMessage(this.$t('message.pleaseSpecifyRole'), true, 2000);
                this.formProcessing = false;
                return false;
            }

            const result = await this.$store.dispatch('createUser', {
                'fullName': this.userFullName,
                'userPrefix':this.userPrefix,
                'desktopNumber': this.userDesktopNumber,
                'userDesktopCountryCode': this.userDesktopCountryCode,
                'mobileNumber': this.userMobileNumber,
                'userMobileCountryCode': this.userMobileCountryCode,
                'email': this.userEmail,
                'sendInvite':sendInvite,
                'voipPhone':this.voipPhone,
                'userRole':this.userRole,
                'userPassword':this.userPassword,
                'userTimezone':this.userTimezone,
                'avatarLink':this.avatarLink,
                'signature':this.signature,
                'userSubscribed':this.userSubscribed,
                'personalCalendarUrl':this.personalCalendarUrl
            });

            if (result.error == '1') {
                showMessage(result.message, true, 2000);
                this.formProcessing = false;
                return false;
            } else {
                showMessage(result.message, false, 2000);
                //this.addNewUserSwitch();
                this.resetUserForm();
                this.resetFilter();
                //this.loadData();
            }

            this.formProcessing = false;
        },
        resetUserForm()
        {
            this.userPrefix = '';
            this.voipPhone = '';
            this.userRole = '';
            this.userPassword = '';
            this.avatarLink = '';
            this.userEmail = '';
            this.userFullName = '';
            this.personalCalendarUrl = '';
            this.signature = '';
            this.userMobileNumber = '';
            this.userDesktopNumber = '';
        },
        async loadData()
        {
            let filterData = this.filterData;
            if (typeof filterData.registrationStatus !== 'undefined') {
                this.searchData = filterData['searchData'];
            }

            const result = await this.$store.dispatch('getGeneralUsersScreenData', {'router':this.$router});
            if(result.status === 'error') {
                showMessage('Please re-login', true, 3000);
            } else {
                this.userMobileCountryCode = this.additionalInfo.userDefaultMobileCountryCode;
                this.userDesktopCountryCode = this.additionalInfo.userDefaultMobileCountryCode;
                this.userTimezone = this.additionalInfo.userDefaultTimezone;
                this.loadedScreen = true;
            }
        }

    },
    async created(){
        if (typeof this.localeMapping[this.locale] !== 'undefined') {
            this.$i18n.locale = this.localeMapping[this.locale];
        }

        this.loadData();
    },
    async updated() {
        this.$nextTick(function () {
            if (typeof checkboxRadioStyle !== 'undefined' && typeof checkboxRadioStyle() === "function") {
                checkboxRadioStyle();
            }
        })
    }
}
