import {mapGetters} from 'vuex';
import lodash from 'lodash';
import localeMapping from '../../../localizationLanguages';
import pagination from '../../pagination';
import moment from 'moment';
import { isProxy, toRaw } from 'vue';
import plupload from "plupload";

import "tinymce/tinymce";
import 'tinymce/models/dom';
import 'tinymce/themes/silver';
import 'tinymce/icons/default';
import 'tinymce/skins/ui/oxide/skin.min.css';
import 'tinymce/skins/ui/oxide/content.min.css';
import 'tinymce/plugins/fullscreen';
import leadshortcode from '../../../../../../tinymce-vue-plugins/leadshortcode/plugin';
import leadtestsms from '../../../../../../tinymce-vue-plugins/leadtestsms/plugin';
import spellcheck from '../../../../../../tinymce-vue-plugins/spellcheck/plugin';
import charlimit from '../../../../../../tinymce-vue-plugins/charlimit/plugin';

import Editor from "@tinymce/tinymce-vue";

export default {
    data () {
        return {
            loadedScreen: false,
            websiteUrl: $('#website_url').val(),
            localeMapping: localeMapping,
            locale: $('#dashboard-system-language').val(),
            applyFullFilterFlag:0,
            itemsQuantity:0,
            totalItemsQuantity:0,
            filter:'',
            configSmsLimit:0,
            smsText:'',
            showBlockChecked:false,
            showBlockUnchecked:true,
            testSmsProcessing:false,
            regularSmsProcessing:false,
            itemsProcessed:0,
            showProcessItems:false,
            showProcessItemsFinished:false,
            showMmsUploader:false,
            mmsPicturesUploader:'',
            uploadedSizeCount:0,
            uploadedFiles:[],
            uploadedFilesList:[],
            failedFilesUpload:[],
            maxUploadedFiles:0
        }
    },
    components: {
        'editor': Editor
    },
    computed: {
        ...mapGetters({
            formatDate: 'formatDate',
            formatOnlyDate: 'formatOnlyDate',
            formatTimeOnly: 'formatTimeOnly',
            configDataInfo:'getConfigDataInfo',
            additionalInfo:'getAdditionalInfo',
            sortByColumn: 'sortByColumn',
            truncateText: 'truncateText',
            unescapeValue:'unescapeValue',
            checkedItemsData:'getCheckedItems',
            totalFoundItems:'getTotalItemsFound',
            filterData:'getFilterData',
            allCheckedItemsTracking:'getAllCheckedItemsTracking',
            ucFirstAllText:'ucFirstAllText',
        })
    },
    watch: {
        // allCheckedItemsTracking (newData, originalData) {
        //     if (this.applyFullFilter === 0) {
        //         if (typeof newData.items !== 'undefined') {
        //             this.totalItemsQuantity = Object.keys(newData.items).length;
        //         } else {
        //             this.totalItemsQuantity = 0;
        //         }
        //     }
        // },
        // totalFoundItems(newData, originalData) {
        //     if (this.applyFullFilter === 1) {
        //         this.totalItemsQuantity = this.totalFoundItems;
        //     }
        // }

    },
    methods: {
        closeMassAction() {
            this.$store.commit('setActiveMassAction', 0);
        },
        async applyFullFilter(e) {
            if (e.target.checked === true) {
                this.applyFullFilterFlag = 1;
            } else {
                this.applyFullFilterFlag = 0;
            }

            await this.countLeads();

            if(this.configSmsLimit && this.configSmsLimit < this.itemsQuantity) {
                showMessage(this.$t('message.smsLimitExceeded'), true, 3000);
            }
        },
        async sendTestSms()
        {

            if (this.testSmsProcessing === true) {
                return false;
            }

            if (this.smsText === '') {
                showMessage(this.$t('message.dialogSmsMessageEmpty'), true, 3000);
                return false;
            }

            if(this.configSmsLimit && this.configSmsLimit < this.itemsQuantity) {
                return false;
            }

            this.testSmsProcessing = true;
            await this.sendSms(1);
            this.testSmsProcessing = false;
        },
        async sendRegularSms()
        {
            if (this.regularSmsProcessing === true) {
                return false;
            }

            if (this.smsText === '') {
                showMessage(this.$t('message.dialogSmsMessageEmpty'), true, 3000);
                return false;
            }

            this.regularSmsProcessing = true;

            await this.sendSms(0, 0, []);
            this.regularSmsProcessing = false;
        },
        async sendSms(testSms, stepSendSms, uniqueMobilesNumbers)
        {
            let quantity = 0,
                uniqueMobilesNumbersData = [],
                mediaFiles = '';

            let testSmsFlag = 0;
            if (testSms) {
                testSmsFlag = 1;
            }

            let stepSms = 0;

            if (stepSendSms) {
                stepSms = stepSendSms;
            }

            let filters = toRaw(this.filterData);

            if (Object.keys(filters).length === 0) {
                filters = 'lead-attribute=&filter=1';
            }

            if (testSmsFlag === 0) {
                this.showProcessItems = true;
            }

            this.showProcessItemsFinished = false;

            if (this.showMmsUploader === true) {
                mediaFiles = this.uploadedFiles.join(',');
            }

            const result = await this.$store.dispatch('sendSms', {
                'router': this.$router,
                'leadIds': Object.keys(this.checkedItemsData).join(','),
                'filters': filters,
                'matchingFilter': this.applyFullFilterFlag,
                'stepSendSms': stepSms,
                'filterQuantity': this.itemsQuantity,
                'smsMessage': this.smsText,
                'uniqueMobilesNumbers': uniqueMobilesNumbers,
                'testSms': testSmsFlag,
                'mediaFiles': mediaFiles,
                'filterAsArray':1
            });

            if (result.error === 1) {
                if (testSmsFlag === 1) {
                    showMessage(result.responseText.message, false, 3000);
                    return false;
                }

                quantity = parseInt(result.responseText.quantity);
                this.itemsProcessed = quantity;
                this.showProcessItemsFinished = true;
                this.showProcessItems = false;
                showMessage(result.responseText.message, false, 3000);
                if (testSmsFlag === 0) {
                    this.smsText = '';
                    this.resetSmsForm();
                }
                return false;
            } else {
                quantity = parseInt(result.responseText.quantity);
                this.itemsProcessed = this.itemsProcessed + quantity;
                uniqueMobilesNumbersData = result.responseText.uniqueMobilesNumbers;
                await this.sendSms(0, stepSms + 1, uniqueMobilesNumbersData);
            }

        },
        resetSmsForm()
        {
            this.showMmsUploader = false;
            this.smsText = '';
            this.uploadedSizeCount = 0;
            this.uploadedFiles = [];
            this.uploadedFilesList = [];
            this.failedFilesUpload = [];
            this.maxUploadedFiles = 0;
            this.mmsPicturesUploader = '';
            $(document).find('#lead-sms-textarea-limit-symbols').text(1600).data('data-maxlength', 1600);
        },
        async countLeads()
        {
            let filters = toRaw(this.filterData);

            if (Object.keys(filters).length === 0) {
                filters = {};
                filters['lead-attribute'] = '';
            }

            const result = await this.$store.dispatch('countLeadsMassAction', {
                'router': this.$router,
                'filters': filters,
                'leadIds': Object.keys(this.checkedItemsData).join(','),
                'existMobileNumber': 1
            });

            if (result.error === 1) {
                showMessage(this.$t('message.smsNoMassActionRecordsFound'), true, 3000);
                this.closeMassAction();
                return false;
            } else {
                if (typeof result.responseText.leadGeneralConfigParams.smsSendingLimit !== 'undefined' && result.responseText.leadGeneralConfigParams.smsSendingLimit != '') {
                    this.configSmsLimit = parseInt(result.responseText.leadGeneralConfigParams.smsSendingLimit);
                }

                if (this.applyFullFilterFlag === 1) {
                    this.totalItemsQuantity = parseInt(result.responseText.quantity);
                    this.itemsQuantity = parseInt(result.responseText.additionalQuantity);
                    this.showBlockChecked = true;
                    this.showBlockUnchecked = false;
                } else {
                    this.totalItemsQuantity = parseInt(result.responseText.additionalQuantity);
                    this.itemsQuantity = parseInt(result.responseText.quantity);
                    this.showBlockChecked = false;
                    this.showBlockUnchecked = true;
                }
            }
        },
        async getInitialData()
        {
            if (Object.keys(this.checkedItemsData).length === 0) {
                showMessage(this.$t('message.pleaseChooseAtLeastOneLead'), true, 3000);
                this.closeMassAction();
            }

            await this.countLeads();

            if (this.itemsQuantity > 0) {
                this.loadedScreen = true;
            }

            if(this.configSmsLimit && this.configSmsLimit < this.itemsQuantity) {
                showMessage(this.$t('message.smsLimitExceeded'), true, 3000);
            }

        },
        initUploadPhotos() {
            let allowedUploadData = {
                'fileSize':5,
                'fileUploads':1
            };

            let options = {
                runtimes: 'html5,html4',
                browse_button: 'upload-mms-button',
                container: 'uploader-mms-images-block',
                rename         : true,
                max_file_size  : allowedUploadData.fileSize+'mb',
                max_file_count : allowedUploadData.fileUploads,
                url: this.websiteUrl+'api/leads/leadmms/',
                multi_selection: false,
                unique_names: false,
                multipart_params: {
                    'secureToken':document.getElementById('leads-screen-config-token').value,
                    'leadId':Object.keys(this.checkedItemsData).join(','),
                    'mmsMassAction': 1
                }
            };

            if (this.mmsPicturesUploader === '') {

                this.mmsPicturesUploader = new plupload.Uploader(options);

                this.mmsPicturesUploader.init();

                this.mmsPicturesUploader.bind('BeforeUpload', _.bind(this.beforePhotoUpload, this));
                this.mmsPicturesUploader.bind('FilesAdded', _.bind(this.filesPhotoAdded, this));
                this.mmsPicturesUploader.bind('UploadProgress', _.bind(this.uploadPhotoProgress, this));
                this.mmsPicturesUploader.bind('FileUploaded', _.bind(this.filePhotoUploaded, this));
                this.mmsPicturesUploader.bind('Error', _.bind(this.handleUploadErrorsPhoto, this));
                this.mmsPicturesUploader.bind('UploadComplete', _.bind(this.uploadCompletePhoto, this));
            }
        },
        beforePhotoUpload: function(up, file) {
            if (this.maxUploadedFiles >= 10) {
                let extraFile = up.getFile(file.id);
                up.removeFile(extraFile);
                up.stop();
                showMessage(this.$t('message.smsSubMessagesLimit'), true, 500);
                return false;
            }
        },
        filesPhotoAdded (up, files) {
            let failedFilesUploadAdditionalFiltered = [];

            this.failedFilesUploadAdditional = {};

            if (files.length) {
                _.each(this.failedFilesUploadAdditional, function (fileName, key) {
                    _.each(files, function (fileN, k) {
                        if (parseInt(fileN.id) === parseInt(key)) {
                            failedFilesUploadAdditionalFiltered.push(fileName);
                        }
                    });

                });

                if (failedFilesUploadAdditionalFiltered.length) {
                    this.failedFilesUploadAdditional = failedFilesUploadAdditionalFiltered;
                } else {
                    this.failedFilesUploadAdditional = {};
                }
            }

            this.mmsPicturesUploader.settings.multipart_params.multipleFiles = 0;
            if (files.length > 1) {
                this.mmsPicturesUploader.settings.multipart_params.multipleFiles = 1;
            }

            this.mmsPicturesUploader.settings.multipart_params.generalFileSize = this.uploadedSizeCount;
            this.mmsPicturesUploader.settings.multipart_params.secureToken = document.getElementById('leads-screen-config-token').value;
            this.failedFilesUpload = [];
            this.mmsPicturesUploader.start();
        },
        uploadPhotoProgress: function(up, file) {

        },
        filePhotoUploaded: function (up, file, info) {
            if (this.maxUploadedFiles < 10) {
                let response = JSON.parse(info.response);
                if (parseInt(response.error) === 0) {
                    this.uploadedSizeCount = parseFloat(response.generalFileSize.toFixed(2));

                    this.uploadedFiles.push(response.fileStoredName);
                    this.uploadedFilesList.push({
                        'name': file.name,
                        'fileStoredName': response.fileStoredName,
                        'size': file.size
                    });
                    this.maxUploadedFiles += 1;
                } else {
                    let errorMessage = '';
                    if (typeof response.fileName !== 'undefined' && response.fileName != '') {
                        if (typeof (response.message) === 'object') {
                            for (var i in response.message) {
                                errorMessage += '<li>' + response.message[i] + '</li>';
                            }
                        } else {
                            errorMessage += '<li> ' + 'File' + ' \'' + response.fileName + '\' (' + response.message + ')' + '</li>';
                        }
                    }

                    if (typeof response.fileName !== 'undefined' && response.type === 'mmsMaxSize') {
                        if (errorMessage !== '') {
                            errorMessage + '</br>' + response.message;
                        } else {
                            errorMessage = response.message;
                        }
                    }

                    this.failedFilesUpload.push(errorMessage);
                }
            }
        },
        handleUploadErrorsPhoto: function(up, err) {
            this.failedFilesUploadAdditional = {};

            let errorMessage = '';

            if (err.code === -600) {
                errorMessage = '<li> ' + 'The file ' + ' \'\"' + (err.file ? err.file.name : "") + '\" size exceeds the limit allowed and cannot be uploaded' + '</li>';
            } else {
                errorMessage = '<li> ' + 'File' + ' \'' + (err.file ? err.file.name : "") + '\' (' + err.message + ')' + '</li>';
            }

            this.failedFilesUploadAdditional[err.file.id] = errorMessage;
            showMessage(errorMessage, true, 3000);
        },
        uploadCompletePhoto: function(up, files, response) {
            if (this.maxUploadedFiles  < 10) {
                $('#progressbar-uploader-photo-documents-file').delay(800).fadeOut();
                $('#progressbar-uploader-photo-documents-text').delay(800).fadeOut();
                let msg = '';
                if (this.failedFilesUploadAdditional.length) {
                    let msg = 'Photos uploaded';
                    if (this.failedFilesUpload.length) {
                        _.each(this.failedFilesUpload, function (fileName, key) {
                            msg += fileName;
                        });
                    }
                    msg += '</ul>';
                    showMessage(msg, true, 3000);
                } else {
                    if (this.failedFilesUpload.length) {
                        if (up.files.length === this.failedFilesUpload.length) {
                            if (up.files.length > 1) {
                                let msg = this.$t('message.smsSubFilesNotUploaded') + '</br>';
                            } else {
                                let msg = this.$t('message.smsSubFilesNotUploaded') + '</br>';
                            }

                            msg += '<ul>';
                            _.each(this.failedFilesUpload, function (fileName, key) {
                                msg += fileName;
                            });
                            msg += '</ul>';

                            showMessage(msg, true, 3000);
                        } else if (up.files.length > this.failedFilesUpload.length) {
                            let msg = 'Photos uploaded';
                            msg += ' </br>' + 'Except:' + '</br>';
                            msg += '<ul>';
                            _.each(this.failedFilesUpload, function (fileName, key) {
                                msg += fileName;
                            });
                            msg += '</ul>';
                            showMessage(msg, true, 3000);
                        }
                    } else {

                    }
                }

                if (!this.failedFilesUpload.length && !this.failedFilesUploadAdditional.length) {
                    showMessage(this.$t('message.smsSubFilesUploaded'), false, 3000);
                }

                this.failedFilesUploadAdditional = {};
                this.mmsPicturesUploader.splice();
            }
        },
        switchMmsUploader(event)
        {
            if (event.target.checked) {
                let self = this;
                this.showMmsUploader = true;
                setTimeout(() => self.initUploadPhotos(),  300);
            } else {
                this.mmsPicturesUploader = '';
                this.showMmsUploader = false;
            }
        },
        async deleteTemporaryMmsImg(index, fileName, fileSize)
        {
            let self= this;

            showConfirm(this.$t('message.smsSubAreYouSureYouWantToDeleteFile'), async () => {
                const result = await this.$store.dispatch('deleteSmsFile', {
                    'router': this.$router,
                    'leadId': Object.keys(this.checkedItemsData).join(','),
                    'fileName': fileName,
                    'fileSize': fileSize,
                    'generalFileSize': this.uploadedSizeCount,
                    'mmsMassAction': 1
                });

                if (result.error === 1) {
                    showMessage(result.message, true, 5000);
                    return false;
                } else {
                    self.uploadedFiles.splice(index, 1);
                    self.uploadedFilesList.splice(index, 1);
                    self.maxUploadedFiles -= 1;
                    this.uploadedSizeCount = parseFloat(result.generalFileSize.toFixed(2));
                    showMessage(result.message, false, 2000);
                }
            }, async () => {
                return false;
            });
        }
    },
    async created(){
        if (typeof this.localeMapping[this.locale] !== 'undefined') {
            this.$i18n.locale = this.localeMapping[this.locale];
        }

        this.getInitialData();
    },
    async updated() {
        this.$nextTick(function () {
            if (typeof checkboxRadioStyle !== 'undefined' && typeof checkboxRadioStyle() === "function") {
                checkboxRadioStyle();
            }
        })
    }
}
