import {mapGetters} from 'vuex';
import lodash from 'lodash';
import localeMapping from '../../../localizationLanguages';
import pagination from '../../pagination';
import moment from 'moment';
import { isProxy, toRaw } from 'vue';

export default {
    data () {
        return {
            loadedScreen: false,
            websiteUrl: $('#website_url').val(),
            localeMapping: localeMapping,
            locale: $('#dashboard-system-language').val(),
            itemsQuantity:0,
            defaultConfig:[],
            additionalLeadsExportConfig:[],
            additionalLeadsExportCustomParamsConfig:[],
            customParamChecked:[],
            disableCustomParamsPrefix:0,
            infoBlock:true,
            filter:'',
            useCustomParams:0,
            allLeads:0,
            formData:{},

        }
    },
    components: {

    },
    computed: {
        ...mapGetters({
            configDataInfo:'getConfigDataInfo',
            additionalInfo:'getAdditionalInfo',
            truncateText: 'truncateText',
            unescapeValue:'unescapeValue',
            checkedItemsData:'getCheckedItems',
            totalFoundItems:'getTotalItemsFound',
            filterData:'getFilterData',
            ucFirstAllText:'ucFirstAllText',
        })
    },
    watch: {

    },
    methods: {
        closeMassAction() {
            this.$store.commit('setActiveMassAction', 0);
        },
        objectToQueryString(obj) {
            const params = new URLSearchParams();

            for (const key in obj) {
                if (!obj.hasOwnProperty(key)) continue;

                let param = obj[key];

                // Skip undefined/null to avoid "?key=" with nothing
                if (param == null) continue;

                // Handle arrays correctly for GET query
                if (Array.isArray(param)) {
                    param.forEach(v => {
                        if (v != null) params.append(`${key}[]`, v);
                    });
                } else {
                    params.append(key, param);
                }
            }

            return params.toString();
        },
        async countLeads(event)
        {
            let isChecked = event.target.checked;

            if (isChecked === true) {
                let filters = toRaw(this.filterData);

                if (Object.keys(filters).length === 0) {
                    filters = {};
                }

                const result = await this.$store.dispatch('countLeadsMassAction', {
                    'router': this.$router,
                    'filters': filters,
                    'leadIds': [],
                    'existMobileNumber': 0,
                });

                if(result.error != 1) {
                    this.allLeads = 1;
                    this.itemsQuantity = parseInt(result.responseText.quantity);
                }
            } else {
                this.allLeads = 0;
                this.itemsQuantity = parseInt(Object.keys(this.checkedItemsData).length);
            }
        },
        async checkDisableCustomParamsPrefix(event)
        {
            let isChecked = event.target.checked;

            if (isChecked === true) {
                this.disableCustomParamsPrefix = 1;
                this.infoBlock = false;
            } else {
                this.infoBlock = true;
                this.disableCustomParamsPrefix = 0;
            }
        },
        async checkCustomParam(event, paramName)
        {
            let isChecked = event.target.checked;
            if (isChecked === true) {
                this.customParamChecked.push(paramName);
                this.useCustomParams = 1;
            } else {
                const index = this.customParamChecked.indexOf(paramName);
                if (index > -1) {
                    this.customParamChecked.splice(index, 1);
                }
            }

            if(this.customParamChecked.length) {
                this.useCustomParams = 1;
            } else {
                this.useCustomParams = 0;
                this.infoBlock = true;
                this.disableCustomParamsPrefix = 0;
            }
        },
        async getLeadsData()
        {
            const result = await this.$store.dispatch('getExportLeadsTabDataMassAction', {
                'router': this.$router,
            });

            if (result.error === 1) {
                showMessage(this.$t('message.leadsHaveNotFound'), true, 5000);
                this.closeMassAction();
                return false;
            } else {
                var self = this;
                this.defaultConfig = result.responseText.defaultConfig;
                this.additionalLeadsExportConfig = result.responseText.additionalLeadsExportConfig;
                this.additionalLeadsExportCustomParamsConfig = result.responseText.additionalLeadsExportCustomParamsConfig;
                this.itemsQuantity = parseInt(Object.keys(this.checkedItemsData).length);

                let filters = toRaw(this.filterData);

                if (Object.keys(filters).length === 0) {
                    filters = {};
                }

                filters = this.objectToQueryString(toRaw(this.filterData));
                this.filter = (_.isEmpty(Object.keys(this.checkedItemsData))) ? 'filters/'+filters : 'leadIds/'+Object.keys(this.checkedItemsData).join(',')+'/filters/'+filters;

                if(!_.isEmpty(this.defaultConfig)) {
                    _.each(this.defaultConfig, function (defaultConf, name) {
                        if(defaultConf === null) {
                            self.formData[name] = name;
                        } else if(typeof defaultConf.label_name !== 'undefined') {
                            self.formData[name] = defaultConf.label;
                        } else {
                            self.formData[name] = name;
                        }
                    });
                }

                if(!_.isEmpty(this.additionalLeadsExportConfig)) {
                    _.each(this.additionalLeadsExportConfig, function (additionalConf, name) {
                        if(additionalConf === null) {
                            self.formData[name] = name;
                        } else if(typeof additionalConf.label_name !== 'undefined') {
                            self.formData[name] = additionalConf.label;
                        } else {
                            self.formData[name] = name;
                        }
                    });
                }

                if(!_.isEmpty(this.additionalLeadsExportCustomParamsConfig)) {
                    _.each(this.additionalLeadsExportCustomParamsConfig, function (additionalCustomParamConf, name) {
                        if(additionalCustomParamConf === null) {
                            self.formData['custom_'+name] = name;
                        } else if(typeof additionalCustomParamConf.param_name !== 'undefined') {
                            self.formData['custom_'+name] = additionalCustomParamConf.param_name;
                        } else {
                            self.formData['custom_'+name] = name;
                        }
                    });
                }
            }
        },
        async getInitialData()
        {
            await this.getLeadsData();

            if (this.itemsQuantity > 0) {
                this.loadedScreen = true;

                $('.info-block').trigger('mouseover');
            }
        },
    },
    async created(){
        if (typeof this.localeMapping[this.locale] !== 'undefined') {
            this.$i18n.locale = this.localeMapping[this.locale];
        }

        this.getInitialData();
    },
    async updated() {
        this.$nextTick(function () {
            if (typeof checkboxRadioStyle !== 'undefined' && typeof checkboxRadioStyle() === "function") {
                checkboxRadioStyle();
            }
        });
    }
}
