import {mapGetters} from 'vuex';
import lodash from 'lodash';
import localeMapping from '../../../localizationLanguages';
import pagination from '../../pagination';
import moment from 'moment';
import { isProxy, toRaw } from 'vue';

export default {
    data () {
        return {
            loadedScreen: false,
            websiteUrl: $('#website_url').val(),
            localeMapping: localeMapping,
            locale: $('#dashboard-system-language').val(),
            itemsQuantity:0,
            filter:'',
            itemsProcessed:0,
            tags:[],
            selectedTagsFirstLoad:[],
            filterAddnewReprocessingFlag:'reprocessing',
            checkedSelectAllRecords:false,
            checkedAllTagsFilterLeads:false,
            checkedLeadTags:[],
            displayProcessedTags:false,
        }
    },
    components: {

    },
    computed: {
        ...mapGetters({
            configDataInfo:'getConfigDataInfo',
            additionalInfo:'getAdditionalInfo',
            sortByColumn: 'sortByColumn',
            truncateText: 'truncateText',
            unescapeValue:'unescapeValue',
            checkedItemsData:'getCheckedItems',
            totalFoundItems:'getTotalItemsFound',
            filterData:'getFilterData',
            alphabeticalSort:'alphabeticalSort',
            ucFirstAllText:'ucFirstAllText',
        })
    },
    watch: {

    },
    methods: {
        closeMassAction() {
            this.$store.commit('setActiveMassAction', 0);
        },
        async submitRegularForm()
        {
            let tagsMsg = '',
                filters = toRaw(this.filterData),
                self = this;

            if(this.filterAddnewReprocessingFlag == 'reprocessing'){
                tagsMsg = this.$t('message.allTagsWillProcess');
                if(this.checkedSelectAllRecords) {
                    tagsMsg = this.$t('message.allTagsWillProcessAllLeads');
                }
            }

            if(this.filterAddnewReprocessingFlag == 'addnew'){
                if(this.checkedLeadTags.length < 1) {
                    showMessage(this.$t('message.selectOneLeadTag'), true, 3000);
                    return false;
                }

                tagsMsg = this.$t('message.allTagsWillAdds');
                if(this.checkedSelectAllRecords) {
                    tagsMsg = this.$t('message.allTagsWillAddsAllLeads');
                }
            }

            showConfirm(tagsMsg, async () => {
                if(self.checkedSelectAllRecords) {
                    this.displayProcessedTags = true;
                    await this.processLeadTags(0);
                } else {
                    let tagsType = '';

                    if(this.checkedAllTagsFilterLeads) {
                        tagsType = 'allTagsFilterLeads';
                    }

                    const result = await this.$store.dispatch('addLeadTagsMassAction', {
                        'router': this.$router,
                        'tagsIds': this.checkedLeadTags,
                        'leadIds': Object.keys(this.checkedItemsData).join(','),
                        'tagsFunction':this.filterAddnewReprocessingFlag,
                        'filters': filters,
                        'tagsType': tagsType,
                    });

                    showMessage(this.$t('message.done'), false, 5000);
                    this.closeMassAction();
                }

            });
        },
        async processLeadTags(offset)
        {
            let quantity = 0,
                filters = toRaw(this.filterData);

            if (Object.keys(filters).length === 0) {
                filters = {};
            }

            const result = await this.$store.dispatch('addLeadTagsMassAction', {
                'router': this.$router,
                'tagsIds': this.checkedLeadTags,
                'tagsFunction':this.filterAddnewReprocessingFlag,
                'offset': offset,
                'allRecords': 1
            });

            if(typeof result.responseText.offset !== 'undefined') {
                quantity = parseInt(result.responseText.leadsCount);
                this.itemsProcessed = this.itemsProcessed + quantity;
                await this.processLeadTags(result.responseText.offset);
            } else {
                showMessage(this.$t('message.done'), false, 5000);
                this.closeMassAction();
            }

        },
        async getLeadTags()
        {
            var self = this;

            const result = await this.$store.dispatch('getLeadTagsMassAction', {
                'router': this.$router,
                'leadIds': Object.keys(this.checkedItemsData).join(',')
            });

            if (result.error === 1) {
                showMessage(this.$t('message.smsNoMassActionRecordsFound'), true, 3000);
                this.closeMassAction();
                return false;
            } else {
                this.itemsQuantity = parseInt(Object.keys(this.checkedItemsData).length);
                this.tags = result.tags;
                this.selectedTagsFirstLoad = result.selectedTags;

                if(this.selectedTagsFirstLoad) {
                    _.each(this.selectedTagsFirstLoad, function (tag, id) {
                        self.checkedLeadTags.push(id);
                    });
                }

                if(_.isEmpty(this.tags)){
                    showMessage(this.$t('message.tagsNoMassActionRecordsFound'), true, 3000);
                }
            }
        },
        async clearLeadTags(event)
        {
            let isChecked = event.target.checked,
                self = this;

            this.checkedLeadTags = [];
            if (isChecked !== true) {
                _.each(this.selectedTagsFirstLoad, function (tag, id) {
                    self.checkedLeadTags.push(id);
                });
            }
        },
        async changeType(event, type)
        {
            let self = this;

            this.checkedLeadTags = [];
            $('.clear-lead-tags').prop('checked', false);
            if(type == 'addnew') {

            } else if(type == 'reprocessing') {
                _.each(this.selectedTagsFirstLoad, function (tag, id) {
                    self.checkedLeadTags.push(id);
                });
            }
            this.filterAddnewReprocessingFlag = type;
        },
        async selectRecords(event, type)
        {
            let isChecked = event.target.checked;
            this.checkedSelectAllRecords = false;
            this.checkedAllTagsFilterLeads = false;

            if(type == 'selectAllRecords') {
                $('#allTagsFilterLeads').prop('checked', false);
                if (isChecked === true) {
                    const result = await this.$store.dispatch('getAllLeadsMassAction', {
                        'router': this.$router
                    });
                    this.itemsQuantity = parseInt(result.totalRecords);
                    this.checkedSelectAllRecords = true;
                } else {
                    this.itemsQuantity = parseInt(Object.keys(this.checkedItemsData).length);
                }

            } else if (type == 'allTagsFilterLeads') {
                $('#selectAllRecords').prop('checked', false);
                if (isChecked === true) {
                    let filters = toRaw(this.filterData);

                    if (Object.keys(filters).length === 0) {
                        filters = {};
                    }

                    const result = await this.$store.dispatch('getAllTagsFilterLeadsMassAction', {
                        'router': this.$router,
                        'filters': filters,
                        'leadIds': Object.keys(this.checkedItemsData).join(','),
                    });

                    if(result.error != 1) {
                        this.itemsQuantity = parseInt(result.totalRecords);
                    }
                    this.checkedAllTagsFilterLeads = true;
                } else {
                    this.itemsQuantity = parseInt(Object.keys(this.checkedItemsData).length);
                }
            }

        },
        async getInitialData()
        {
            if (Object.keys(this.checkedItemsData).length === 0) {
                showMessage(this.$t('message.pleaseChooseAtLeastOneLead'), true, 3000);
                this.closeMassAction();
            }

            await this.getLeadTags();

            if (this.itemsQuantity > 0) {
                this.loadedScreen = true;
            }
        },
    },
    async created(){
        if (typeof this.localeMapping[this.locale] !== 'undefined') {
            this.$i18n.locale = this.localeMapping[this.locale];
        }

        this.getInitialData();
    },
    async updated() {
        this.$nextTick(function () {
            if (typeof checkboxRadioStyle !== 'undefined' && typeof checkboxRadioStyle() === "function") {
                checkboxRadioStyle();
            }
        })
    }
}
