import {mapGetters} from 'vuex';
import lodash from 'lodash';
import localeMapping from '../../../localizationLanguages';
import pagination from '../../pagination';
import leadsgridtable from '../../leadsgridtable';
import moment from 'moment';
import { isProxy, toRaw } from 'vue';
export default {
    data () {
        return {
            loadedScreen: false,
            websiteUrl: $('#website_url').val(),
            localeMapping: localeMapping,
            locale: $('#dashboard-system-language').val(),
            searchData:[],
            filterByName:'',
            filterByPlanId: 0,
            filterByActiveMembers: false,
            showAdditionalFiltersBlock:false,
            filterBy:'attributes',
            filterOrderBy:'id',
            filterIncludeCustomLeadFields:0,
            filterIncludeCustomNotes:0,
            filterIncludeCallTranscript:0,
            searchTerm:'',
            filterLeadOwnerId:0,
            componentKey: 0,
            componentKeyActivity: 0,
            componentKeyOpportunity: 0,
            componentKeyValidation: 0,
            componentKeySequenceDate: 0,
            minDateCreationDate: null,
            maxDateCreationDate: null,
            minDateActivityDate: null,
            maxDateActivityDate: null,
            minDateSequenceDate: null,
            maxDateSequenceDate: null,
            minDateOpportunityDate: null,
            maxDateOpportunityDate: null,
            disableDatepicker: 0,
            filterCreationDateFromForDatepicker:'',
            filterCreationDateToForDatepicker:'',
            filterActivityDateFromForDatepicker:'',
            filterActivityDateToForDatepicker:'',
            filterSequenceDateFromForDatepicker:'',
            filterSequenceDateToForDatepicker:'',
            filterOpportunityDateFromForDatepicker:'',
            filterOpportunityDateToForDatepicker:'',
            filterEmailValidationDatepicker:'',
            filterLastUpdatedFlag:'',
            filterOpportunityFlag:'creation_at',
            filterActivityTypesOptions:[],
            filterActivityTypes:[],
            filterLifecycles:[],
            listOfStatesOptions:[],
            lastNextActivitySwitcherValue:'last_activity',
            showInteractionEmailSubTypeFilter:false,
            filterEmailInteractionActivitySubtype: 0,
            filterByTaskStatus:0,
            filterByCountry:0,
            filterByCountryState:[],
            filterByIndustry:0,
            filterByEmailSequence:[],
            filterBySequenceType:'all',
            filterBySequenceTypeAction:'all',
            showEmailSequenceAdditionalBlock: false,
            emailSmsSequencesTypePeriod: '',
            filterByOpportunityOwnerId:0,
            filterByTotalOpportunityAmountFrom:'',
            filterByTotalOpportunityAmountTo:'',
            filterByTotalSpentPurchaseAmountFrom:'',
            filterByTotalSpentPurchaseAmountTo:'',
            filterByGroup:0,
            filterByTags:[],
            filterBySourceTypes:[],
            filterBySourceUtmValues:[],
            filterByCampaignUtmValues:[],
            filterByCity:'',
            filterByTitleOperator:'equal',
            byLeadTitle:'',
            filterByOpportunityStatus:[],
            filterByScoreFrom:'',
            filterByScoreTo:'',
            filterBySentimentScoreFrom:'',
            filterBySentimentScoreTo:'',
            filterByLeadType:0,
            displayCallDurationBlock: false,
            filterBySignCallDuration:'more',
            filterByCallDuration:'',
            filterByLeadSource:'',
            filterByExcludeTags:[],
            filterByLeadZip:'',
            filterByNpsScoreOperator:'equal',
            filterByNpsScore:'',
            filterByEmailValidation:0,
            displayFilterValidationAdditionalBlock:false,
            filterByOpportunityType:0,
            filterByEmailStatus:0,
            filterByLastInteractionType:0,
            urlPredefinedFilterParams:[],
            rangeOptions:0,
            leadCustomAttribute:0,
            organizationCustomAttribute:0,
            filterLeadCustomAttributesList: {},
            filterOrganizationCustomAttributesList: {},
            specialFilterType:'',
            specialTypeSwitcher:'',
            filterPreset:0,
            showFilterPresetInfoFlag: false,
            newFilterPresetName: '',
            isPresetDefaultFlag:0,
            filterPresetShowAll:'individual',
            savePresetFilterProcessing:false,
            showRecentlyViewedBlock: false,
            showQuickLeadForm:false,
            quickLeadEmail:'',
            quickLeadPrefix:'',
            quickLeadFirstName:'',
            quickLeadLastName:'',
            quickLeadZip:'',
            quickLeadMobileCountryCode:'',
            quickLeadMobile:'',
            quickLeadSource:'',
            quickLeadExistingLeadId:0,
            quickLeadOrganization:'',
            quickLeadFormProcessing:false,
            mainScreenLoaded:false,
            showLicenceDescription:false,
            quickLeadExistsByEmail:false,
            quickLeadExistsByPhone:false,
            quickLeadExistsByNameZip:false,

        }
    },
    components: {
        leadsgridtable: leadsgridtable,
    },
    computed: {
        ...mapGetters({
            formatDate: 'formatDate',
            formatOnlyDate: 'formatOnlyDate',
            formatTimeOnly: 'formatTimeOnly',
            configDataInfo:'getConfigDataInfo',
            additionalInfo:'getAdditionalInfo',
            truncateText: 'truncateText',
            sortByColumn: 'sortByColumn',
            filterData:'getFilterData',
            unescapeValue:'unescapeValue',
            defaultPresetEnabled:'getDefaultPresetEnabled',
            activeFilterPreset:'getActiveFilterPreset',
        }),
    },
    watch: {
        defaultPresetEnabled (defaultPresetData, originalData) {
            if (typeof defaultPresetData !== 'undefined') {
                let defaultPresetInfo = toRaw(defaultPresetData);

                if (typeof defaultPresetInfo.filterPresetData !== 'undefined') {
                    this.processPresetsData(defaultPresetInfo);
                }
            }
        },
    },
    methods: {
        async applyFilter()
        {
             this.searchData['searchTerm'] = this.searchTerm;
             this.searchData['filterBy'] = this.filterBy;
             this.searchData['filterOrderBy'] = this.filterOrderBy;
             this.searchData['filterLeadOwnerId'] = this.filterLeadOwnerId;
             this.searchData['filterIncludeCustomLeadFields'] = this.filterIncludeCustomLeadFields;
             this.searchData['filterIncludeCustomNotes'] = this.filterIncludeCustomNotes;
             this.searchData['filterIncludeCallTranscript'] = this.filterIncludeCallTranscript;
             this.searchData['lastUpdatedFlag'] = this.filterLastUpdatedFlag;

            let filterCreationDateFrom = moment(this.filterCreationDateFromForDatepicker).format('YYYY-MM-DD');
            let filterCreationDateTo = moment(this.filterCreationDateToForDatepicker).format('YYYY-MM-DD');
            let filterActivityDateFrom = moment(this.filterActivityDateFromForDatepicker).format('YYYY-MM-DD');
            let filterActivityDateTo = moment(this.filterActivityDateToForDatepicker).format('YYYY-MM-DD');
            let filterOpportunityDateFrom = moment(this.filterOpportunityDateFromForDatepicker).format('YYYY-MM-DD');
            let filterOpportunityDateTo = moment(this.filterOpportunityDateToForDatepicker).format('YYYY-MM-DD');
            let filterEmailValidationDatepicker = moment(this.filterEmailValidationDatepicker).format('YYYY-MM-DD');
            let filterSequenceDateFrom = moment(this.filterSequenceDateFromForDatepicker).format('YYYY-MM-DD');
            let filterSequenceDateTo = moment(this.filterSequenceDateToForDatepicker).format('YYYY-MM-DD');

            if (filterCreationDateFrom !== 'Invalid date') {
                this.searchData['filterCreationDateFrom'] = filterCreationDateFrom;
            }

            if (filterCreationDateTo !== 'Invalid date') {
                this.searchData['filterCreationDateTo'] = filterCreationDateTo;
            }

            if (filterActivityDateFrom !== 'Invalid date') {
                this.searchData['filterActivityDateFrom'] = filterActivityDateFrom;
            }

            if (filterActivityDateTo !== 'Invalid date') {
                this.searchData['filterActivityDateTo'] = filterActivityDateTo;
            }

            if (filterOpportunityDateFrom !== 'Invalid date') {
                this.searchData['filterOpportunityDateFrom'] = filterOpportunityDateFrom;
            }

            if (filterOpportunityDateTo !== 'Invalid date') {
                this.searchData['filterOpportunityDateTo'] = filterOpportunityDateTo;
            }

            if (filterEmailValidationDatepicker !== 'Invalid date') {
                this.searchData['filterEmailValidationDatepicker'] = filterEmailValidationDatepicker;
            }

            if (filterSequenceDateFrom !== 'Invalid date') {
                this.searchData['filterSequenceDateFrom'] = filterSequenceDateFrom;
            } else {
                this.searchData['filterSequenceDateFrom'] = '';
            }

            if (filterSequenceDateTo !== 'Invalid date') {
                this.searchData['filterSequenceDateTo'] = filterSequenceDateTo;
            } else {
                this.searchData['filterSequenceDateTo'] = '';
            }

            this.searchData['emailInteractionActivitySubtype'] = this.filterEmailInteractionActivitySubtype;
            this.searchData['filterByTaskStatus'] = this.filterByTaskStatus;
            this.searchData['filterByCountry'] = this.filterByCountry;
            this.searchData['filterByIndustry'] = this.filterByIndustry;
            this.searchData['filterBySequenceType'] = this.filterBySequenceType;
            this.searchData['filterBySequenceTypeAction'] = this.filterBySequenceTypeAction;
            this.searchData['emailSmsSequencesTypePeriod'] = this.emailSmsSequencesTypePeriod;
            this.searchData['filterByOpportunityOwnerId'] = this.filterByOpportunityOwnerId;
            this.searchData['filterByTotalOpportunityAmountFrom'] = this.filterByTotalOpportunityAmountFrom;
            this.searchData['filterByTotalOpportunityAmountTo'] = this.filterByTotalOpportunityAmountTo;
            this.searchData['filterByTotalSpentPurchaseAmountFrom'] = this.filterByTotalSpentPurchaseAmountFrom;
            this.searchData['filterByTotalSpentPurchaseAmountTo'] = this.filterByTotalSpentPurchaseAmountTo;
            this.searchData['filterByGroup'] = this.filterByGroup;
            this.searchData['filterByCity'] = this.filterByCity;
            this.searchData['filterByTitleOperator'] = this.filterByTitleOperator;
            this.searchData['byLeadTitle'] = this.byLeadTitle;
            this.searchData['filterByScoreFrom'] = this.filterByScoreFrom;
            this.searchData['filterByScoreTo'] = this.filterByScoreTo;
            this.searchData['filterBySentimentScoreFrom'] = this.filterBySentimentScoreFrom;
            this.searchData['filterBySentimentScoreTo'] = this.filterBySentimentScoreTo;
            this.searchData['filterByLeadType'] = this.filterByLeadType;
            this.searchData['filterBySignCallDuration'] = this.filterBySignCallDuration;
            this.searchData['filterByCallDuration'] = this.filterByCallDuration;
            this.searchData['filterByLeadSource'] = this.filterByLeadSource;
            this.searchData['filterByLeadZip'] = this.filterByLeadZip;
            this.searchData['filterByNpsScoreOperator'] = this.filterByNpsScoreOperator;
            this.searchData['filterByNpsScore'] = this.filterByNpsScore;
            this.searchData['filterByEmailValidation'] = this.filterByEmailValidation;
            this.searchData['filterByOpportunityType'] = this.filterByOpportunityType;
            this.searchData['filterByEmailStatus'] = this.filterByEmailStatus;
            this.searchData['filterByLastInteractionType'] = this.filterByLastInteractionType;
            this.searchData['specialFilterType'] = this.specialFilterType;

            let filterLeadsCustomParams = this.getCustomParams('leads');
            let filterOrganizationsCustomParams = this.getCustomParams('organizations');

            this.searchData['filterLeadsCustomParams'] = filterLeadsCustomParams;
            this.searchData['filterOrganizationsCustomParams'] = filterOrganizationsCustomParams;

            let filterOpportunityFlag = this.filterOpportunityFlag;

            if (filterOpportunityFlag === 'creation_at') {
                this.searchData['creationAt'] = 'creation_at';
            }

            if (filterOpportunityFlag === 'state_change_at') {
                this.searchData['stateChangeAt'] = 'state_change_at';
            }

            if (filterOpportunityFlag === 'expected_at') {
                this.searchData['expectedAt'] = 'expected_at';
            }

            this.searchData['stageId'] = 'expected_at';

            let filterActivities = [];
            let filterLifecycles = [];
            let filterByCountryState = [];
            let filterByEmailSequence = [];
            let filterByTags = [];
            let filterBySourceTypes = [];
            let filterBySourceUtmValues = [];
            let filterByCampaignUtmValues = [];
            let filterByOpportunityStatus = [];
            let filterByExcludeTags = [];

            this.filterActivityTypes.forEach((element) => {
                filterActivities.push(element.id);
            });

            this.filterLifecycles.forEach((element) => {
                filterLifecycles.push(element.id);
            });

            this.filterByCountryState.forEach((element) => {
                filterByCountryState.push(element.state);
            });

            this.filterByEmailSequence.forEach((element) => {
                filterByEmailSequence.push(element.id);
            });

            this.filterByTags.forEach((element) => {
                filterByTags.push(element.id);
            });

            this.filterBySourceTypes.forEach((element) => {
                filterBySourceTypes.push(element.id);
            });

            this.filterBySourceUtmValues.forEach((element) => {
                filterBySourceUtmValues.push(element.id);
            });

            this.filterByCampaignUtmValues.forEach((element) => {
                filterByCampaignUtmValues.push(element.id);
            });

            this.filterByOpportunityStatus.forEach((element) => {
                filterByOpportunityStatus.push(element.id);
            });

            this.filterByExcludeTags.forEach((element) => {
                filterByExcludeTags.push(element.id);
            });

            this.searchData['filterActivities'] = filterActivities;
            this.searchData['filterLifecycles'] = filterLifecycles;
            this.searchData['filterByCountryState'] = filterByCountryState;
            this.searchData['filterByEmailSequence'] = filterByEmailSequence;
            this.searchData['filterByTags'] = filterByTags;
            this.searchData['filterBySourceTypes'] = filterBySourceTypes;
            this.searchData['filterBySourceUtmValues'] = filterBySourceUtmValues;
            this.searchData['filterByCampaignUtmValues'] = filterByCampaignUtmValues;
            this.searchData['filterByOpportunityStatus'] = filterByOpportunityStatus;
            this.searchData['filterByExcludeTags'] = filterByExcludeTags;


            this.searchData['rangeOptions'] = this.rangeOptions;
            this.searchData['switchLastNextActivityDate'] = this.lastNextActivitySwitcherValue;

            this.$store.commit('setChangeFilter', {
                 'searchData':this.searchData,
             });

            this.$store.commit('setCheckedItems', {});
        },
        async resetSearchBar()
        {
            this.searchTerm = '';
            this.applyFilter();
        },
        async resetFilter()
        {
            this.searchData = [];
            this.searchTerm = '';
            this.filterBy = 'attributes';
            this.filterOrderBy = 'id';
            this.filterLeadOwnerId = 0;
            this.filterIncludeCustomLeadFields = 0;
            this.filterIncludeCustomNotes = 0;
            this.filterIncludeCallTranscript = 0;
            this.minDateCreationDate = null;
            this.maxDateCreationDate = null;
            this.filterCreationDateFromForDatepicker = '';
            this.filterCreationDateToForDatepicker = '';
            this.filterActivityTypes = [];
            this.filterLastUpdatedFlag = '';
            this.minDateActivityDate = null;
            this.maxDateActivityDate = null;
            this.minDateOpportunityDate = null;
            this.maxDateOpportunityDate = null;
            this.filterOpportunityFlag = 'creation_at';
            this.filterLifecycles = [];
            this.filterEmailInteractionActivitySubtype = 0;
            this.filterByTaskStatus = 0;
            this.filterByCountry = 0;
            this.filterByCountryState = [];
            this.listOfStatesOptions = [];
            this.filterByIndustry = 0;
            this.filterByEmailSequence = [];
            this.filterBySequenceType = 'all';
            this.filterBySequenceTypeAction = 'all';
            this.emailSmsSequencesTypePeriod = '';
            this.showEmailSequenceAdditionalBlock = false;
            this.filterByOpportunityOwnerId = 0;
            this.filterByTotalOpportunityAmountFrom ='';
            this.filterByTotalOpportunityAmountTo ='';
            this.filterByTotalSpentPurchaseAmountFrom ='';
            this.filterByTotalSpentPurchaseAmountTo ='';
            this.filterByGroup = 0;
            this.filterByTags = [];
            this.filterBySourceTypes = [];
            this.filterBySourceUtmValues = [];
            this.filterByCampaignUtmValues = [];
            this.filterByCity = '';
            this.filterByTitleOperator = 'equal';
            this.byLeadTitle = '';
            this.filterByOpportunityStatus = [];
            this.filterByScoreFrom = '';
            this.filterByScoreTo = '';
            this.filterBySentimentScoreFrom = '';
            this.filterBySentimentScoreTo = '';
            this.filterByLeadType = 0;
            this.displayCallDurationBlock = false;
            this.filterBySignCallDuration = 'more';
            this.filterByCallDuration = '';
            this.filterByLeadSource = '';
            this.filterByExcludeTags = [];
            this.filterByLeadZip = '';
            this.filterByNpsScoreOperator = 'equal';
            this.filterByNpsScore = '';
            this.filterByEmailValidation = 0;
            this.displayFilterValidationAdditionalBlock = false;
            this.filterEmailValidationDatepicker = '';
            this.filterByOpportunityType = 0;
            this.filterByEmailStatus = 0;
            this.filterByLastInteractionType = 0;
            this.rangeOptions = 0;
            this.filterOpportunityDateFromForDatepicker = '';
            this.filterOpportunityDateToForDatepicker = '';
            this.leadCustomAttribute = 0;
            this.organizationCustomAttribute = 0;
            this.filterLeadCustomAttributesList = {};
            this.filterOrganizationCustomAttributesList = {};
            this.specialFilterType = '';
            this.specialTypeSwitcher = '';
            this.filterPreset = 0;
            this.showFilterPresetInfoFlag = false;
            this.newFilterPresetName = '';
            this.isPresetDefaultFlag = 0;
            this.filterPresetShowAll = 'individual';
            this.filterActivityDateFromForDatepicker = '';
            this.filterActivityDateToForDatepicker = '';
            this.filterSequenceDateFromForDatepicker = '';
            this.filterSequenceDateToForDatepicker = '';
            this.$store.commit('setActiveFilterPreset', '');
            this.applyFilter();
        },
        processPresetsData(defaultPresetInfo, skipApplyFilter)
        {
            if (typeof defaultPresetInfo.filterPresetData !== 'undefined') {

                let filterPresetData = defaultPresetInfo.filterPresetData;
                let self = this;

                this.newFilterPresetName = defaultPresetInfo.filterPresetName;
                this.isPresetDefaultFlag = parseInt(defaultPresetInfo.isDefault);
                this.filterPreset = defaultPresetInfo.id;
                this.showFilterPresetInfoFlag = true;

                this.$store.commit('setActiveFilterPreset', this.filterPreset);

                if (typeof defaultPresetInfo.access !== 'undefined') {
                    this.filterPresetShowAll = defaultPresetInfo.access;
                }

                if (typeof filterPresetData.activity_id !== 'undefined' && Object.keys(filterPresetData.activity_id).length > 0) {
                    let activityIds = filterPresetData.activity_id;
                    let filterActivityTypes = [];

                    activityIds.forEach(function(item) {
                        if (self.additionalInfo.activitiesTypes !== 'undefined' && self.additionalInfo.activitiesTypes[item] !== 'undefined')
                            filterActivityTypes.push(self.additionalInfo.activitiesTypes[item]);
                    });

                    this.filterActivityTypes = filterActivityTypes;
                } else {
                    this.filterActivityTypes = [];
                }

                if (typeof filterPresetData.call_duration !== 'undefined') {
                    this.filterByCallDuration = filterPresetData.call_duration;
                } else {
                    this.filterByCallDuration = '';
                }

                if (typeof filterPresetData.created_at !== 'undefined' && filterPresetData.created_at === 'created_at') {
                    this.filterLastUpdatedFlag = '';
                } else if (!_.isUndefined(filterPresetData.last_updated) && filterPresetData.last_updated === 'last_updated') {
                    this.filterLastUpdatedFlag = 'last_updated';
                } else {
                    this.filterLastUpdatedFlag = '';
                }

                if (typeof filterPresetData.created_at_from !== 'undefined') {
                    this.filterCreationDateFromForDatepicker = filterPresetData.created_at_from;
                } else {
                    this.filterCreationDateFromForDatepicker = '';
                }

                if (typeof filterPresetData.created_at_to !== 'undefined') {
                    this.filterCreationDateToForDatepicker = filterPresetData.created_at_to;
                } else {
                    this.filterCreationDateToForDatepicker = '';
                }

                if (typeof filterPresetData.created_at_to !== 'undefined') {
                    this.filterCreationDateFromToDatepicker = filterPresetData.created_at_to;
                } else {
                    this.filterCreationDateFromToDatepicker = '';
                }

                if (typeof filterPresetData.custom_organization_params_search !== 'undefined' && Object.keys(filterPresetData.custom_organization_params_search).length > 0) {
                    this.populateCustomAttributesFilters(filterPresetData.custom_organization_params_search, 'organization');
                } else {
                    this.filterOrganizationCustomAttributesList = {};
                }

                if (typeof filterPresetData.custom_params_search !== 'undefined' && Object.keys(filterPresetData.custom_params_search).length > 0) {
                    this.populateCustomAttributesFilters(filterPresetData.custom_params_search, 'lead');
                } else {
                    this.filterLeaadCustomAttributesList = {};
                }

                if (typeof filterPresetData.customer_group_id !== 'undefined') {
                    this.filterByGroup = filterPresetData.customer_group_id;
                } else {
                    this.filterByGroup = 0;
                }

                if (typeof filterPresetData.email_sequence_type !== 'undefined') {
                    this.filterBySequenceType = filterPresetData.email_sequence_type;
                } else {
                    this.filterBySequenceType = 'all';
                }

                if (typeof filterPresetData.email_sequence_type_action !== 'undefined') {
                    this.filterBySequenceTypeAction = filterPresetData.email_sequence_type_action;
                } else {
                    this.filterBySequenceTypeAction = 'all';
                }

                if (typeof filterPresetData.email_sms_sequences !== 'undefined') {
                    let emailSmsSequences = filterPresetData.email_sms_sequences;
                    let filterByEmailSmsSequence = [];

                    emailSmsSequences.forEach(function(item) {
                        if (self.additionalInfo.emailSmsSequences !== 'undefined' && self.additionalInfo.emailSmsSequences[item] !== 'undefined') {
                            filterByEmailSmsSequence.push(self.additionalInfo.emailSmsSequences[item]);
                        }
                    });

                    this.filterByEmailSequence = filterByEmailSmsSequence;
                    this.showEmailSequenceAdditionalBlock = true;
                } else {
                    this.filterByEmailSequence = [];
                    this.showEmailSequenceAdditionalBlock = false;
                }

                if (typeof filterPresetData.email_sms_sequences_type_period !== 'undefined') {
                    this.emailSmsSequencesTypePeriod = filterPresetData.email_sms_sequences_type_period;
                } else {
                    this.emailSmsSequencesTypePeriod = '';
                }

                if (typeof filterPresetData.email_status !== 'undefined') {
                    this.filterByEmailStatus = filterPresetData.email_status;
                } else {
                    this.filterByEmailStatus = 0;
                }

                if (typeof filterPresetData.email_validation_status !== 'undefined') {
                    this.filterByEmailValidation = filterPresetData.email_validation_status;
                    if (this.filterByEmailValidation === 'valid') {
                        this.displayFilterValidationAdditionalBlock = true;
                    }
                } else {
                    this.filterByEmailValidation = 0;
                }

                if (typeof filterPresetData.expected_at !== 'undefined' && filterPresetData.expected_at === 'expected_at') {
                    this.filterOpportunityFlag = 'expected_at';
                } else if (typeof filterPresetData.state_change_at !== 'undefined' && filterPresetData.state_change_at === 'state_change_at') {
                    this.filterOpportunityFlag = 'state_change_at';
                } else {
                    this.filterOpportunityFlag = 'creation_at';
                }

                if (typeof filterPresetData.industry_id !== 'undefined') {
                    this.filterByIndustry = filterPresetData.industry_id;
                } else {
                    this.filterByIndustry = 0;
                }

                if (typeof filterPresetData.interaction_value !== 'undefined' && filterPresetData.interaction_value !== null) {
                    this.filterOrderBy = filterPresetData.interaction_value;
                } else {
                    this.filterOrderBy = 'id';
                }

                if (typeof filterPresetData.last_activity_from !== 'undefined') {
                    this.filterActivityDateFromForDatepicker = filterPresetData.last_activity_from;
                } else {
                    this.filterActivityDateFromForDatepicker = '';
                }

                if (typeof filterPresetData.last_activity_to !== 'undefined') {
                    this.filterActivityDateToForDatepicker = filterPresetData.last_activity_to;
                } else {
                    this.filterActivityDateToForDatepicker = '';
                }

                if (typeof filterPresetData.last_sequence_from !== 'undefined') {
                    this.filterSequenceDateFromForDatepicker = filterPresetData.last_sequence_from;
                } else {
                    this.filterSequenceDateFromForDatepicker = '';
                }

                if (typeof filterPresetData.last_sequence_to !== 'undefined') {
                    this.filterSequenceDateToForDatepicker = filterPresetData.last_sequence_to;
                } else {
                    this.filterSequenceDateToForDatepicker = '';
                }

                if (typeof filterPresetData.last_interaction_id !== 'undefined') {
                    this.filterByLastInteractionType = filterPresetData.last_interaction_id;

                    if (typeof this.additionalInfo['lastInteractions'][this.filterByLastInteractionType]  !== 'undefined' && this.additionalInfo['lastInteractions'][this.filterByLastInteractionType]['type_name'] === 'outbound_email') {
                        this.showInteractionEmailSubTypeFilter = true;
                    } else {
                        this.showInteractionEmailSubTypeFilter = false;
                    }
                } else {
                    this.filterByLastInteractionType = 0;
                    this.showInteractionEmailSubTypeFilter = false;
                }

                if (typeof filterPresetData.lead_city !== 'undefined') {
                    this.filterByCity = filterPresetData.lead_city;
                } else {
                    this.filterByCity = '';
                }

                if (typeof filterPresetData.lead_country !== 'undefined') {
                    this.filterByCountry = filterPresetData.lead_country;
                } else {
                    this.filterByCountry = 0;
                }

                if (typeof filterPresetData.lead_country_state !== 'undefined' && Object.keys(filterPresetData.lead_country_state).length > 0) {
                    let states = [];

                    if (typeof this.filterByCountry !== 'undefined') {
                        this.listOfStatesOptions = this.additionalInfo.statesList[this.filterByCountry];
                        filterPresetData.lead_country_state.forEach(function (item) {
                            if (self.listOfStatesOptions !== 'undefined' && self.listOfStatesOptions[item] !== 'undefined') {
                                states.push(self.listOfStatesOptions[item]);
                            }
                        });

                        this.filterByCountryState = states;
                    }
                } else {
                    this.filterByCountryState = [];
                }

                if (typeof filterPresetData.lead_filter_nps_score !== 'undefined') {
                    this.filterByNpsScore = filterPresetData.lead_filter_nps_score;
                } else {
                    this.filterByNpsScore = '';
                }

                if (typeof filterPresetData.lead_filter_nps_score_operator !== 'undefined') {
                    this.filterByNpsScoreOperator = filterPresetData.lead_filter_nps_score_operator;
                } else {
                    this.filterByNpsScoreOperator = 'equal';
                }

                if (typeof filterPresetData.lead_filter_total_opportunity_amount_from !== 'undefined') {
                    this.filterByTotalOpportunityAmountFrom = filterPresetData.lead_filter_total_opportunity_amount_from;
                } else {
                    this.filterByTotalOpportunityAmountFrom = '';
                }

                if (typeof filterPresetData.lead_filter_total_opportunity_amount_to !== 'undefined') {
                    this.filterByTotalOpportunityAmountTo = filterPresetData.lead_filter_total_opportunity_amount_to;
                } else {
                    this.filterByTotalOpportunityAmountTo = '';
                }

                if (typeof filterPresetData.lead_filter_total_spent_purchase_amount_from !== 'undefined') {
                    this.filterByTotalSpentPurchaseAmountFrom = filterPresetData.lead_filter_total_spent_purchase_amount_from;
                } else {
                    this.filterByTotalSpentPurchaseAmountFrom = '';
                }

                if (typeof filterPresetData.lead_filter_total_spent_purchase_amount_to !== 'undefined') {
                    this.filterByTotalSpentPurchaseAmountTo = filterPresetData.lead_filter_total_spent_purchase_amount_to;
                } else {
                    this.filterByTotalSpentPurchaseAmountTo = '';
                }

                if (typeof filterPresetData.lead_opportunity_stages !== 'undefined') {
                    let leadOpportunityStages = filterPresetData.lead_opportunity_stages;
                    let filterByOpportunityStatus = [];

                    leadOpportunityStages.forEach(function(item) {
                        if (self.additionalInfo.leadOpportunityStatuses !== 'undefined' && self.additionalInfo.leadOpportunityStatuses[item] !== 'undefined')
                            filterByOpportunityStatus.push(self.additionalInfo.leadOpportunityStatuses[item]);
                    });

                    this.filterByOpportunityStatus = filterByOpportunityStatus;
                } else {
                    this.filterByOpportunityStatus = [];
                }

                if (typeof filterPresetData.lead_score_from !== 'undefined') {
                    this.filterByScoreFrom = filterPresetData.lead_score_from;
                } else {
                    this.filterByScoreFrom = '';
                }

                if (typeof filterPresetData.lead_sentiment_score_from !== 'undefined') {
                    this.filterBySentimentScoreFrom = filterPresetData.lead_sentiment_score_from;
                } else {
                    this.filterBySentimentScoreFrom = '';
                }

                if (typeof filterPresetData.lead_score_to !== 'undefined') {
                    this.filterByScoreTo = filterPresetData.lead_score_to;
                } else {
                    this.filterByScoreTo = '';
                }

                if (typeof filterPresetData.lead_sentiment_score_to !== 'undefined') {
                    this.filterBySentimentScoreTo = filterPresetData.lead_sentiment_score_to;
                } else {
                    this.filterBySentimentScoreTo = '';
                }

                if (typeof filterPresetData.lead_source !== 'undefined') {
                    this.filterByLeadSource = filterPresetData.lead_source;
                } else {
                    this.filterByLeadSource = '';
                }

                if (typeof filterPresetData.lead_source_type !== 'undefined') {
                    this.filterByLeadType = filterPresetData.lead_source_type;
                    if (typeof this.additionalInfo['leadSourcesTypes'][this.filterByLeadType] !== 'undefined' && (this.additionalInfo['leadSourcesTypes'][this.filterByLeadType]['type_name'] === 'inbound_call' || this.additionalInfo['leadSourcesTypes'][this.filterByLeadType]['type_name'] === 'outbound_call')) {
                        this.displayCallDurationBlock = true;
                    } else {
                        this.displayCallDurationBlock = false;
                    }
                } else {
                    this.filterByLeadType = 0;
                }

                if (typeof filterPresetData.lead_tags !== 'undefined') {
                    let leadTags = filterPresetData.lead_tags;
                    let filterByTags = [];

                    leadTags.forEach(function(item) {
                        if (self.additionalInfo.leadTags !== 'undefined' && self.additionalInfo.leadTags[item] !== 'undefined') {
                            filterByTags.push(self.additionalInfo.leadTags[item]);
                        }
                    });

                    this.filterByTags = filterByTags;
                } else {
                    this.filterByTags = [];
                }

                if (typeof filterPresetData.lead_source_type_and_utm !== 'undefined') {
                    let leadSourceTypeAndUtm = filterPresetData.lead_source_type_and_utm;
                    let filterBySourceTypes = [];

                    leadSourceTypeAndUtm.forEach(function(item) {
                        if (self.additionalInfo.sourceTypes !== 'undefined' && self.additionalInfo.sourceTypes[item] !== 'undefined') {
                            filterBySourceTypes.push(self.additionalInfo.sourceTypes[item]);
                        }
                    });

                    this.filterBySourceTypes = filterBySourceTypes;
                } else {
                    this.filterBySourceTypes = [];
                }

                if (typeof filterPresetData.lead_utm_source_value_id !== 'undefined') {
                    let leadUtmSourceValueId = filterPresetData.lead_utm_source_value_id;
                    let filterBySourceUtmValues = [];

                    leadUtmSourceValueId.forEach(function(item) {
                        if (self.additionalInfo.sourceValues !== 'undefined' && self.additionalInfo.sourceValues[item] !== 'undefined') {
                            if (self.additionalInfo.sourceValues[item]) {
                                filterBySourceUtmValues.push(self.additionalInfo.sourceValues[item]);
                            }
                        }
                    });

                    this.filterBySourceUtmValues = filterBySourceUtmValues;
                } else {
                    this.filterBySourceUtmValues = [];
                }

                if (typeof filterPresetData.lead_utm_campaign_value_id !== 'undefined') {
                    let leadUtmCampaignValueId = filterPresetData.lead_utm_campaign_value_id;
                    let filterByCampaignUtmValues = [];

                    leadUtmCampaignValueId.forEach(function(item) {
                        if (self.additionalInfo.campaignValues !== 'undefined' && self.additionalInfo.campaignValues[item] !== 'undefined') {
                            if (self.additionalInfo.campaignValues[item]) {
                                filterByCampaignUtmValues.push(self.additionalInfo.campaignValues[item]);
                            }
                        }
                    });

                    this.filterByCampaignUtmValues = filterByCampaignUtmValues;
                } else {
                    this.filterByCampaignUtmValues = [];
                }

                if (typeof filterPresetData.lead_tags_exclude !== 'undefined') {
                    let leadTags = filterPresetData.lead_tags_exclude;
                    let filterByTags = [];

                    leadTags.forEach(function(item) {
                        if (self.additionalInfo.leadTags !== 'undefined' && self.additionalInfo.leadTags[item] !== 'undefined') {
                            filterByTags.push(self.additionalInfo.leadTags[item]);
                        }
                    });

                    this.filterByExcludeTags = filterByTags;
                } else {
                    this.filterByExcludeTags = [];
                }

                if (typeof filterPresetData.lead_task !== 'undefined') {
                    this.filterByTaskStatus = filterPresetData.lead_task;
                } else {
                    this.filterByTaskStatus = 0;
                }

                if (typeof filterPresetData.lead_title_operator !== 'undefined') {
                    this.filterByTitleOperator = filterPresetData.lead_title_operator;
                } else {
                    this.filterByTitleOperator = 'equal';
                }

                if (typeof filterPresetData.lead_titles !== 'undefined') {
                    this.byLeadTitle = filterPresetData.lead_titles;
                } else {
                    this.byLeadTitle = '';
                }

                if (typeof filterPresetData.lead_zip !== 'undefined') {
                    this.filterByLeadZip = filterPresetData.lead_zip;
                } else {
                    this.filterByLeadZip = '';
                }

                if (typeof filterPresetData.more_less_call_duration !== 'undefined') {
                    this.filterBySignCallDuration = filterPresetData.more_less_call_duration;
                } else {
                    this.filterBySignCallDuration = 'more';
                }

                if (typeof filterPresetData.opportunity_date_from !== 'undefined') {
                    this.filterOpportunityDateFromForDatepicker = filterPresetData.opportunity_date_from;
                } else {
                    this.filterOpportunityDateFromForDatepicker = '';
                }

                if (typeof filterPresetData.opportunity_date_to !== 'undefined') {
                    this.filterOpportunityDateToForDatepicker = filterPresetData.opportunity_date_to;
                } else {
                    this.filterOpportunityDateToForDatepicker = '';
                }

                if (typeof filterPresetData.opportunity_owner_id !== 'undefined') {
                    this.filterByOpportunityOwnerId = filterPresetData.opportunity_owner_id;
                } else {
                    this.filterByOpportunityOwnerId = 0;
                }

                if (typeof filterPresetData.opportunity_type_id !== 'undefined') {
                    this.filterByOpportunityType = filterPresetData.opportunity_type_id;
                } else {
                    this.filterByOpportunityType = 0;
                }

                if (typeof filterPresetData.outbound_emails_sub_type !== 'undefined') {
                    this.filterEmailInteractionActivitySubtype = filterPresetData.outbound_emails_sub_type;
                } else {
                    this.filterEmailInteractionActivitySubtype = 0;
                }

                if (typeof filterPresetData.owner_id !== 'undefined') {
                    this.filterLeadOwnerId = filterPresetData.owner_id;
                } else {
                    this.filterLeadOwnerId = 0;
                }

                if (typeof filterPresetData.special_filter_type !== 'undefined') {
                    this.specialFilterType = filterPresetData.special_filter_type;
                    this.specialTypeSwitcher = filterPresetData.special_filter_type;
                } else {
                    this.specialFilterType = 0;
                    this.specialTypeSwitcher = '';
                }

                if (typeof filterPresetData.stage_id !== 'undefined') {
                    let leadStagesList = filterPresetData.stage_id;
                    let filterByleadStagesList = [];

                    leadStagesList.forEach(function(item) {
                        if (self.additionalInfo.lifeCyclesListPreset !== 'undefined' && self.additionalInfo.lifeCyclesListPreset[item] !== 'undefined') {
                            filterByleadStagesList.push(self.additionalInfo.lifeCyclesListPreset[item]);
                        }
                    });

                    this.filterLifecycles = filterByleadStagesList;
                } else {
                    this.filterLifecycles = [];
                }

                if (typeof filterPresetData.switch_last_next_activity_date !== 'undefined') {
                    if (filterPresetData.switch_last_next_activity_date === 'last-activity-date') {
                        this.lastNextActivitySwitcherValue = 'last_activity';
                    }

                    if (filterPresetData.switch_last_next_activity_date === 'next-activity-date') {
                        this.lastNextActivitySwitcherValue = 'next_activity';
                    }
                } else {
                    this.lastNextActivitySwitcherValue = 'last_activity';
                }

                if (typeof filterPresetData.validated_date_to !== 'undefined') {
                    this.filterEmailValidationDatepicker = filterPresetData.validated_date_to;
                } else {
                    this.filterEmailValidationDatepicker = '';
                }

                this.showAdditionalFiltersBlock = true;

                if (!skipApplyFilter) {
                    this.applyFilter();
                }
            }
        },
        cleanEmailSequenceDate(type)
        {
            if (type === 'from') {
                this.filterSequenceDateFromForDatepicker = '';
            } else {
                this.filterSequenceDateToForDatepicker = '';
            }

        },
        async reprocessPreset()
        {
            if (this.activeFilterPreset) {
                if (typeof this.additionalInfo.leadFiltersPresets[this.activeFilterPreset] !== 'undefined') {
                    const result = await this.$store.dispatch('getLeadFilterPreset', {
                        'router': this.$router,
                        'id': this.activeFilterPreset
                    });

                    if (typeof result.isDefault !== 'undefined') {
                        result.filterPresetData = JSON.parse(result.filterPresetData);
                        this.processPresetsData(result, true);
                    }
                }
            }
        },
        reprocessFilterFields()
        {
            let oldFilterData = toRaw(this.filterData);

            if (Object.keys(oldFilterData).length > 0) {

                let self = this,
                    showAdditionalFilters = false;

                if (typeof oldFilterData['filter-by'] !== 'undefined') {
                    this.filterBy = oldFilterData['filter-by'];
                }

                if (typeof oldFilterData['lead-attribute'] !== 'undefined') {
                    this.searchTerm = oldFilterData['lead-attribute'];
                }

                if (typeof oldFilterData.search_includes_custom_lead_fields !== 'undefined') {
                    this.filterIncludeCustomLeadFields = oldFilterData.search_includes_custom_lead_fields;
                }

                if (typeof oldFilterData.search_includes_notes !== 'undefined') {
                    this.filterIncludeCustomNotes = oldFilterData.search_includes_notes;
                }

                if (typeof oldFilterData.search_includes_call_transcript !== 'undefined') {
                    this.filterIncludeCallTranscript = oldFilterData.search_includes_call_transcript;
                }

                if (typeof oldFilterData.activity_id !== 'undefined' && Object.keys(oldFilterData.activity_id).length > 0) {
                    let activityIds = oldFilterData.activity_id;
                    let filterActivityTypes = [];

                    activityIds.forEach(function(item) {
                        if (self.additionalInfo.activitiesTypes !== 'undefined' && self.additionalInfo.activitiesTypes[item] !== 'undefined') {
                            filterActivityTypes.push(self.additionalInfo.activitiesTypes[item]);
                        }
                    });

                    this.filterActivityTypes = filterActivityTypes;
                    showAdditionalFilters = true;
                } else {
                    this.filterActivityTypes = [];
                }

                if (typeof oldFilterData.call_duration !== 'undefined' && oldFilterData.call_duration !== '') {
                    this.filterByCallDuration = oldFilterData.call_duration;
                    showAdditionalFilters = true;
                } else {
                    this.filterByCallDuration = '';
                }

                if (typeof oldFilterData.created_at !== 'undefined' && oldFilterData.created_at === 'created_at') {
                    this.filterLastUpdatedFlag = '';
                } else if (!_.isUndefined(oldFilterData.last_updated) && oldFilterData.last_updated === 'last_updated') {
                    this.filterLastUpdatedFlag = 'last_updated';
                } else {
                    this.filterLastUpdatedFlag = '';
                }

                if (typeof oldFilterData.created_at_from !== 'undefined') {
                    this.filterCreationDateFromForDatepicker = oldFilterData.created_at_from;
                    showAdditionalFilters = true;
                } else {
                    this.filterCreationDateFromForDatepicker = '';
                }

                if (typeof oldFilterData.created_at_to !== 'undefined') {
                    this.filterCreationDateToForDatepicker = oldFilterData.created_at_to;
                    showAdditionalFilters = true;
                } else {
                    this.filterCreationDateToForDatepicker = '';
                }

                if (typeof oldFilterData.created_at_to !== 'undefined') {
                    this.filterCreationDateFromToDatepicker = oldFilterData.created_at_to;
                    showAdditionalFilters = true;
                } else {
                    this.filterCreationDateFromToDatepicker = '';
                }

                if (typeof oldFilterData.custom_organization_params_search !== 'undefined' && Object.keys(oldFilterData.custom_organization_params_search).length > 0) {
                    this.populateCustomAttributesFilters(oldFilterData.custom_organization_params_search, 'organization');
                    showAdditionalFilters = true;
                } else {
                    this.filterOrganizationCustomAttributesList = {};
                }

                if (typeof oldFilterData.custom_params_search !== 'undefined' && Object.keys(oldFilterData.custom_params_search).length > 0) {
                    this.populateCustomAttributesFilters(oldFilterData.custom_params_search, 'lead');
                    showAdditionalFilters = true;
                } else {
                    this.filterLeaadCustomAttributesList = {};
                }

                if (typeof oldFilterData.customer_group_id !== 'undefined' && oldFilterData.customer_group_id !== 0) {
                    this.filterByGroup = oldFilterData.customer_group_id;
                    showAdditionalFilters = true;
                } else {
                    this.filterByGroup = 0;
                }

                if (typeof oldFilterData.email_sequence_type !== 'undefined' && oldFilterData.email_sequence_type !== 'all') {
                    this.filterBySequenceType = oldFilterData.email_sequence_type;
                    showAdditionalFilters = true;
                } else {
                    this.filterBySequenceType = 'all';
                }

                if (typeof oldFilterData.email_sequence_type_action !== 'undefined'  && oldFilterData.email_sequence_type_action !== 'all') {
                    this.filterBySequenceTypeAction = oldFilterData.email_sequence_type_action;
                    showAdditionalFilters = true;
                } else {
                    this.filterBySequenceTypeAction = 'all';
                }

                if (typeof oldFilterData.email_sms_sequences !== 'undefined') {
                    let emailSmsSequences = oldFilterData.email_sms_sequences;
                    let filterByEmailSmsSequence = [];

                    if (Object.keys(emailSmsSequences).length > 0) {
                        emailSmsSequences.forEach(function (item) {
                            if (self.additionalInfo.emailSmsSequences !== 'undefined' && self.additionalInfo.emailSmsSequences[item] !== 'undefined') {
                                filterByEmailSmsSequence.push(self.additionalInfo.emailSmsSequences[item]);
                            }
                        });

                        this.filterByEmailSequence = filterByEmailSmsSequence;
                        this.showEmailSequenceAdditionalBlock = true;
                        showAdditionalFilters = true;
                    }
                } else {
                    this.filterByEmailSequence = [];
                    this.showEmailSequenceAdditionalBlock = false;
                }

                if (typeof oldFilterData.email_sms_sequences_type_period !== 'undefined') {
                    this.emailSmsSequencesTypePeriod = oldFilterData.email_sms_sequences_type_period;
                    if (oldFilterData.email_sms_sequences_type_period) {
                        showAdditionalFilters = true;
                    }
                } else {
                    this.emailSmsSequencesTypePeriod = '';
                }

                if (typeof oldFilterData.email_status !== 'undefined' && oldFilterData.email_status !== 0) {
                    this.filterByEmailStatus = oldFilterData.email_status;
                    showAdditionalFilters = true;
                } else {
                    this.filterByEmailStatus = 0;
                }

                if (typeof oldFilterData.email_validation_status !== 'undefined' && oldFilterData.email_validation_status !== 0) {
                    this.filterByEmailValidation = oldFilterData.email_validation_status;
                    if (this.filterByEmailValidation === 'valid') {
                        this.displayFilterValidationAdditionalBlock = true;
                    }
                    showAdditionalFilters = true;
                } else {
                    this.filterByEmailValidation = 0;
                }

                if (typeof oldFilterData.expected_at !== 'undefined' && oldFilterData.expected_at === 'expected_at') {
                    this.filterOpportunityFlag = 'expected_at';
                } else if (typeof oldFilterData.state_change_at !== 'undefined' && oldFilterData.state_change_at === 'state_change_at') {
                    this.filterOpportunityFlag = 'state_change_at';
                } else {
                    this.filterOpportunityFlag = 'creation_at';
                }

                if (typeof oldFilterData.industry_id !== 'undefined' && oldFilterData.industry_id !== 0) {
                    this.filterByIndustry = oldFilterData.industry_id;
                    showAdditionalFilters = true;
                } else {
                    this.filterByIndustry = 0;
                }

                if (typeof oldFilterData.interaction_value !== 'undefined' && oldFilterData.interaction_value !== null && oldFilterData.interaction_value !== 'id') {
                    this.filterOrderBy = oldFilterData.interaction_value;
                } else {
                    this.filterOrderBy = 'id';
                }

                if (typeof oldFilterData.last_activity_from !== 'undefined') {
                    this.filterActivityDateFromForDatepicker = oldFilterData.last_activity_from;
                    showAdditionalFilters = true;
                } else {
                    this.filterActivityDateFromForDatepicker = '';
                }

                if (typeof oldFilterData.last_activity_to !== 'undefined') {
                    this.filterActivityDateToForDatepicker = oldFilterData.last_activity_to;
                    showAdditionalFilters = true;
                } else {
                    this.filterActivityDateToForDatepicker = '';
                }

                if (typeof oldFilterData.last_sequence_from !== 'undefined' && oldFilterData.last_sequence_from !== '') {
                    this.filterSequenceDateFromForDatepicker = oldFilterData.last_sequence_from;
                    showAdditionalFilters = true;
                } else {
                    this.filterSequenceDateFromForDatepicker = '';
                }

                if (typeof oldFilterData.last_sequence_to !== 'undefined' && oldFilterData.last_sequence_to !== '') {
                    this.filterSequenceDateToForDatepicker = oldFilterData.last_sequence_to;
                    showAdditionalFilters = true;
                } else {
                    this.filterSequenceDateToForDatepicker = '';
                }

                if (typeof oldFilterData.last_interaction_id !== 'undefined' && oldFilterData.last_interaction_id !== 0) {
                    this.filterByLastInteractionType = oldFilterData.last_interaction_id;

                    if (typeof this.additionalInfo['lastInteractions'][this.filterByLastInteractionType]  !== 'undefined' && this.additionalInfo['lastInteractions'][this.filterByLastInteractionType]['type_name'] === 'outbound_email') {
                        this.showInteractionEmailSubTypeFilter = true;
                    } else {
                        this.showInteractionEmailSubTypeFilter = false;
                    }
                    showAdditionalFilters = true;
                } else {
                    this.filterByLastInteractionType = 0;
                    this.showInteractionEmailSubTypeFilter = false;
                }

                if (typeof oldFilterData.lead_city !== 'undefined' && oldFilterData.lead_city !== '') {
                    this.filterByCity = oldFilterData.lead_city;
                    showAdditionalFilters = true;
                } else {
                    this.filterByCity = '';
                }

                if (typeof oldFilterData.lead_country !== 'undefined' && oldFilterData.lead_country !== 0) {
                    this.filterByCountry = oldFilterData.lead_country;
                    showAdditionalFilters = true;
                } else {
                    this.filterByCountry = 0;
                }

                if (typeof oldFilterData.lead_country_state !== 'undefined' && Object.keys(oldFilterData.lead_country_state).length > 0) {
                    let states = [];

                    if (typeof this.filterByCountry !== 'undefined') {
                        this.listOfStatesOptions = this.additionalInfo.statesList[this.filterByCountry];
                        oldFilterData.lead_country_state.forEach(function (item) {
                            if (self.listOfStatesOptions !== 'undefined' && self.listOfStatesOptions[item] !== 'undefined') {
                                states.push(self.listOfStatesOptions[item]);
                            }
                        });

                        this.filterByCountryState = states;
                        showAdditionalFilters = true;
                    }
                } else {
                    this.filterByCountryState = [];
                }

                if (typeof oldFilterData.nps_score !== 'undefined' && oldFilterData.nps_score !== '') {
                    this.filterByNpsScore = oldFilterData.nps_score;
                    showAdditionalFilters = true;
                } else {
                    this.filterByNpsScore = '';
                }

                if (typeof oldFilterData.lead_filter_nps_score_operator !== 'undefined' && oldFilterData.lead_filter_nps_score_operator !== 'equal') {
                    this.filterByNpsScoreOperator = oldFilterData.lead_filter_nps_score_operator;
                    showAdditionalFilters = true;
                } else {
                    this.filterByNpsScoreOperator = 'equal';
                }

                if (typeof oldFilterData.total_opportunity_amount_from !== 'undefined' && oldFilterData.total_opportunity_amount_from !== '') {
                    this.filterByTotalOpportunityAmountFrom = oldFilterData.total_opportunity_amount_from;
                    showAdditionalFilters = true;
                } else {
                    this.filterByTotalOpportunityAmountFrom = '';
                }

                if (typeof oldFilterData.total_opportunity_amount_to !== 'undefined' && oldFilterData.total_opportunity_amount_to !== '') {
                    this.filterByTotalOpportunityAmountTo = oldFilterData.total_opportunity_amount_to;
                    showAdditionalFilters = true;
                } else {
                    this.filterByTotalOpportunityAmountTo = '';
                }

                if (typeof oldFilterData.total_spent_purchase_amount_from !== 'undefined' && oldFilterData.total_spent_purchase_amount_from !== '') {
                    this.filterByTotalSpentPurchaseAmountFrom = oldFilterData.total_spent_purchase_amount_from;
                    showAdditionalFilters = true;
                } else {
                    this.filterByTotalSpentPurchaseAmountFrom = '';
                }

                if (typeof oldFilterData.total_spent_purchase_amount_to !== 'undefined' && oldFilterData.total_spent_purchase_amount_to !== '') {
                    this.filterByTotalSpentPurchaseAmountTo = oldFilterData.total_spent_purchase_amount_to;
                    showAdditionalFilters = true;
                } else {
                    this.filterByTotalSpentPurchaseAmountTo = '';
                }

                if (typeof oldFilterData.lead_opportunity_stages !== 'undefined') {
                    let leadOpportunityStages = oldFilterData.lead_opportunity_stages;
                    let filterByOpportunityStatus = [];

                    if (Object.keys(leadOpportunityStages).length > 0) {
                        leadOpportunityStages.forEach(function (item) {
                            if (self.additionalInfo.leadOpportunityStatuses !== 'undefined' && self.additionalInfo.leadOpportunityStatuses[item] !== 'undefined') {
                                filterByOpportunityStatus.push(self.additionalInfo.leadOpportunityStatuses[item]);
                            }
                        });

                        this.filterByOpportunityStatus = filterByOpportunityStatus;
                        showAdditionalFilters = true;
                    }
                } else {
                    this.filterByOpportunityStatus = [];
                }

                if (typeof oldFilterData.lead_score_from !== 'undefined' && oldFilterData.lead_score_from !== '') {
                    this.filterByScoreFrom = oldFilterData.lead_score_from;
                    showAdditionalFilters = true;
                } else {
                    this.filterByScoreFrom = '';
                }

                if (typeof oldFilterData.lead_sentiment_score_from !== 'undefined' && oldFilterData.lead_sentiment_score_from !== '') {
                    this.filterBySentimentScoreFrom = oldFilterData.lead_sentiment_score_from;
                    showAdditionalFilters = true;
                } else {
                    this.filterBySentimentScoreFrom = '';
                }

                if (typeof oldFilterData.lead_score_to !== 'undefined'  && oldFilterData.lead_score_to !== '') {
                    this.filterByScoreTo = oldFilterData.lead_score_to;
                    showAdditionalFilters = true;
                } else {
                    this.filterByScoreTo = '';
                }

                if (typeof oldFilterData.lead_sentiment_score_to !== 'undefined'  && oldFilterData.lead_sentiment_score_to !== '') {
                    this.filterBySentimentScoreTo = oldFilterData.lead_sentiment_score_to;
                    showAdditionalFilters = true;
                } else {
                    this.filterBySentimentScoreTo = '';
                }

                if (typeof oldFilterData.lead_source !== 'undefined' && oldFilterData.lead_source !== '') {
                    this.filterByLeadSource = oldFilterData.lead_source;
                    showAdditionalFilters = true;
                } else {
                    this.filterByLeadSource = '';
                }

                if (typeof oldFilterData.lead_source_type !== 'undefined' && oldFilterData.lead_source_type !== 0) {
                    this.filterByLeadType = oldFilterData.lead_source_type;
                    if (typeof this.additionalInfo['leadSourcesTypes'][this.filterByLeadType] !== 'undefined' && (this.additionalInfo['leadSourcesTypes'][this.filterByLeadType]['type_name'] === 'inbound_call' || this.additionalInfo['leadSourcesTypes'][this.filterByLeadType]['type_name'] === 'outbound_call')) {
                        this.displayCallDurationBlock = true;
                    } else {
                        this.displayCallDurationBlock = false;
                    }
                    showAdditionalFilters = true;
                } else {
                    this.filterByLeadType = 0;
                }

                if (typeof oldFilterData.lead_tags !== 'undefined') {
                    let leadTags = oldFilterData.lead_tags;
                    let filterByTags = [];

                    if (Object.keys(leadTags).length > 0) {
                        leadTags.forEach(function (item) {
                            if (self.additionalInfo.leadTags !== 'undefined' && self.additionalInfo.leadTags[item] !== 'undefined') {
                                filterByTags.push(self.additionalInfo.leadTags[item]);
                            }
                        });

                        this.filterByTags = filterByTags;
                        showAdditionalFilters = true;
                    }
                } else {
                    this.filterByTags = [];
                }

                if (typeof oldFilterData.lead_source_type_and_utm !== 'undefined') {
                    let leadSourceTypeAndUtms = oldFilterData.lead_source_type_and_utm;
                    let filterBySourceTypes = [];

                    if (Object.keys(leadSourceTypeAndUtms).length > 0) {
                        leadSourceTypeAndUtms.forEach(function (item) {
                            if (self.additionalInfo.sourceTypes !== 'undefined' && self.additionalInfo.sourceTypes[item] !== 'undefined') {
                                filterBySourceTypes.push(self.additionalInfo.sourceTypes[item]);
                            }
                        });

                        this.filterBySourceTypes = filterBySourceTypes;
                        showAdditionalFilters = true;
                    }
                } else {
                    this.filterBySourceTypes = [];
                }

                if (typeof oldFilterData.lead_utm_source_value_id !== 'undefined') {
                    let leadUtmSourceValueIds = oldFilterData.lead_utm_source_value_id;
                    let filterBySourceUtmValues = [];

                    if (Object.keys(leadUtmSourceValueIds).length > 0) {
                        leadUtmSourceValueIds.forEach(function (item) {
                            if (self.additionalInfo.sourceValues !== 'undefined' && self.additionalInfo.sourceValues[item] !== 'undefined') {
                                if (self.additionalInfo.sourceValues[item]) {
                                    filterBySourceUtmValues.push(self.additionalInfo.sourceValues[item]);
                                }
                            }
                        });

                        this.filterBySourceUtmValues = filterBySourceUtmValues;
                        showAdditionalFilters = true;
                    }
                } else {
                    this.filterBySourceUtmValues = [];
                }

                if (typeof oldFilterData.lead_utm_campaign_value_id !== 'undefined') {
                    let leadUtmCampaignValueIds = oldFilterData.lead_utm_campaign_value_id;
                    let filterByCampaignUtmValues = [];

                    if (Object.keys(leadUtmCampaignValueIds).length > 0) {
                        leadUtmCampaignValueIds.forEach(function (item) {
                            if (self.additionalInfo.campaignValues !== 'undefined' && self.additionalInfo.campaignValues[item] !== 'undefined') {
                                if (self.additionalInfo.campaignValues[item]) {
                                    filterByCampaignUtmValues.push(self.additionalInfo.campaignValues[item]);
                                }
                            }
                        });

                        this.filterByCampaignUtmValues = filterByCampaignUtmValues;
                        showAdditionalFilters = true;
                    }
                } else {
                    this.filterByCampaignUtmValues = [];
                }

                if (typeof oldFilterData.lead_tags_exclude !== 'undefined') {
                    let leadTags = oldFilterData.lead_tags_exclude;
                    let filterByTags = [];

                    if (Object.keys(leadTags).length > 0) {
                        leadTags.forEach(function (item) {
                            if (self.additionalInfo.leadTags !== 'undefined' && self.additionalInfo.leadTags[item] !== 'undefined') {
                                filterByTags.push(self.additionalInfo.leadTags[item]);
                            }
                        });

                        this.filterByExcludeTags = filterByTags;
                        showAdditionalFilters = true;
                    }
                } else {
                    this.filterByExcludeTags = [];
                }

                if (typeof oldFilterData.lead_task !== 'undefined' && oldFilterData.lead_task !== 0) {
                    this.filterByTaskStatus = oldFilterData.lead_task;
                    showAdditionalFilters = true;
                } else {
                    this.filterByTaskStatus = 0;
                }

                if (typeof oldFilterData.lead_title_operator !== 'undefined' && oldFilterData.lead_title_operator !== 'equal') {
                    this.filterByTitleOperator = oldFilterData.lead_title_operator;
                    showAdditionalFilters = true;
                } else {
                    this.filterByTitleOperator = 'equal';
                }

                if (typeof oldFilterData.lead_titles !== 'undefined' && oldFilterData.lead_titles !== '') {
                    this.byLeadTitle = oldFilterData.lead_titles;
                    showAdditionalFilters = true;
                } else {
                    this.byLeadTitle = '';
                }

                if (typeof oldFilterData.lead_zip !== 'undefined' && oldFilterData.lead_zip !== '') {
                    this.filterByLeadZip = oldFilterData.lead_zip;
                    showAdditionalFilters = true;
                } else {
                    this.filterByLeadZip = '';
                }

                if (typeof oldFilterData.more_less_call_duration !== 'undefined' && oldFilterData.more_less_call_duration !== 'more') {
                    this.filterBySignCallDuration = oldFilterData.more_less_call_duration;
                    showAdditionalFilters = true;
                } else {
                    this.filterBySignCallDuration = 'more';
                }

                if (typeof oldFilterData.opportunity_date_from !== 'undefined') {
                    this.filterOpportunityDateFromForDatepicker = oldFilterData.opportunity_date_from;
                    showAdditionalFilters = true;
                } else {
                    this.filterOpportunityDateFromForDatepicker = '';
                }

                if (typeof oldFilterData.opportunity_date_to !== 'undefined') {
                    this.filterOpportunityDateToForDatepicker = oldFilterData.opportunity_date_to;
                    showAdditionalFilters = true;
                } else {
                    this.filterOpportunityDateToForDatepicker = '';
                }

                if (typeof oldFilterData.opportunity_owner_id !== 'undefined' && oldFilterData.opportunity_owner_id !== 0) {
                    this.filterByOpportunityOwnerId = oldFilterData.opportunity_owner_id;
                    showAdditionalFilters = true;
                } else {
                    this.filterByOpportunityOwnerId = 0;
                }

                if (typeof oldFilterData.opportunity_type_id !== 'undefined' && oldFilterData.opportunity_type_id !== 0) {
                    this.filterByOpportunityType = oldFilterData.opportunity_type_id;
                    showAdditionalFilters = true;
                } else {
                    this.filterByOpportunityType = 0;
                }

                if (typeof oldFilterData.outbound_emails_sub_type !== 'undefined' && oldFilterData.outbound_emails_sub_type !== 0) {
                    this.filterEmailInteractionActivitySubtype = oldFilterData.outbound_emails_sub_type;
                    showAdditionalFilters = true;
                } else {
                    this.filterEmailInteractionActivitySubtype = 0;
                }

                if (typeof oldFilterData.owner_id !== 'undefined' && oldFilterData.owner_id !== 0) {
                    this.filterLeadOwnerId = oldFilterData.owner_id;
                    showAdditionalFilters = true;
                } else {
                    this.filterLeadOwnerId = 0;
                }

                if (typeof oldFilterData.special_filter_type !== 'undefined' && oldFilterData.special_filter_type !== 0 && oldFilterData.special_filter_type !== '') {
                    this.specialFilterType = oldFilterData.special_filter_type;
                    this.specialTypeSwitcher = oldFilterData.special_filter_type;
                    showAdditionalFilters = true;
                } else {
                    this.specialFilterType = 0;
                    this.specialTypeSwitcher = '';
                }

                if (typeof oldFilterData.stage_id !== 'undefined') {
                    let leadStagesList = oldFilterData.stage_id;
                    let filterByleadStagesList = [];

                    if (Object.keys(leadStagesList).length > 0) {
                        leadStagesList.forEach(function (item) {
                            if (self.additionalInfo.lifeCyclesListPreset !== 'undefined' && self.additionalInfo.lifeCyclesListPreset[item] !== 'undefined') {
                                filterByleadStagesList.push(self.additionalInfo.lifeCyclesListPreset[item]);
                            }
                        });

                        this.filterLifecycles = filterByleadStagesList;
                        showAdditionalFilters = true;
                    }
                } else {
                    this.filterLifecycles = [];
                }

                if (typeof oldFilterData.switch_last_next_activity_date !== 'undefined') {
                    if (oldFilterData.switch_last_next_activity_date === 'last-activity-date') {
                        this.lastNextActivitySwitcherValue = 'last_activity';
                    }

                    if (oldFilterData.switch_last_next_activity_date === 'next-activity-date') {
                        this.lastNextActivitySwitcherValue = 'next_activity';
                    }
                } else {
                    this.lastNextActivitySwitcherValue = 'last_activity';
                }

                if (typeof oldFilterData.range_options !== 'undefined') {
                    let rangeOptions = oldFilterData.range_options;
                    if (rangeOptions === 'custom') {
                        rangeOptions = 0;
                    }

                    this.rangeOptions = rangeOptions;
                }

                if (typeof oldFilterData.next_activity_from !== 'undefined') {
                    this.filterActivityDateFromForDatepicker = oldFilterData.next_activity_from;
                }

                if (typeof oldFilterData.next_activity_to !== 'undefined') {
                    this.filterActivityDateToForDatepicker = oldFilterData.next_activity_to;
                }

                if (typeof oldFilterData.next_sequence_from !== 'undefined') {
                    this.filterSequenceDateFromForDatepicker = oldFilterData.next_sequence_from;
                }

                if (typeof oldFilterData.next_sequence_to !== 'undefined') {
                    this.filterSequenceDateToForDatepicker = oldFilterData.next_sequence_to;
                }

                if (typeof oldFilterData.validated_date_to !== 'undefined') {
                    this.filterEmailValidationDatepicker = oldFilterData.validated_date_to;
                    showAdditionalFilters = true;
                } else {
                    this.filterEmailValidationDatepicker = '';
                }

                if (showAdditionalFilters === true) {
                    this.showAdditionalFiltersBlock = true;
                }

            }
        },
        async createNewLead(goToLead)
        {
            let goToProfile = goToLead || false;

            if (this.quickLeadFormProcessing === true) {
                return false;
            }

            this.quickLeadFormProcessing = true;

            const result = await this.$store.dispatch('createQuickNewLead', {
                'router':this.$router,
                'leadEmail':this.quickLeadEmail,
                'prefix':this.quickLeadPrefix,
                'leadFirstName':this.quickLeadFirstName,
                'leadLastName':this.quickLeadLastName,
                'leadZip':this.quickLeadZip,
                'organizationName':this.quickLeadOrganization,
                'leadMobileCountryCode':this.quickLeadMobileCountryCode,
                'leadMobile':this.quickLeadMobile,
                'leadSource':this.quickLeadSource,
            });

            if (parseInt(result.error) === 1) {
                showMessage(result.message, true, 2000);
                this.quickLeadFormProcessing = false;
                return false;
            } else {
                showMessage(result.responseText.message, false, 2000);
                this.resetQuickLeadForm();
                this.quickLeadFormProcessing = false;
                if (goToProfile === true) {
                    this.$router.push({ name: 'lead', params: {'id': parseInt(result.responseText.leadId)}, query:{'tabName': 'timeline'}});
                } else {
                    this.resetFilter();
                }
            }
        },
        resetQuickLeadForm()
        {
            this.quickLeadEmail = '';
            this.quickLeadPrefix = '';
            this.quickLeadFirstName = '';
            this.quickLeadLastName = '';
            this.quickLeadZip = '';
            this.quickLeadMobileCountryCode = this.additionalInfo.userDefaultMobileCountryCode;
            this.quickLeadMobile = '';
            this.quickLeadSource = '';
            this.quickLeadOrganization = '';
        },
        goToProfile()
        {
          if (this.quickLeadExistingLeadId > 0) {
              this.$router.push({ name: 'lead', params: {'id': this.quickLeadExistingLeadId}, query:{'tabName': 'timeline'}});
          }
        },
        setQuickLeadOrganization(event)
        {
            let value = event.target.value;
            this.quickLeadOrganization = value;
        },
        async getLeadOrganizations(query)
        {
            if (query.length < 3) {
                return [];
            }

            const result = await this.$store.dispatch('getLeadOrganizations', {'router':this.$router, 'searchTerm':query});

            if (result.error == '1') {
                return [];
            }

            let results = [],
                self = this;

            $.map(result, function(el) {
                if (typeof el.organization_name !== 'undefined') {
                    results.push(self.unescapeValue(el.organization_name));
                }
            });

            return results;
        },
        async getLeadEmailQuickLead()
        {
            if (this.quickLeadExistsByNameZip === false && this.quickLeadExistsByPhone === false) {
                let previousStatus = this.quickLeadExistsByEmail;

                if (this.quickLeadEmail) {
                    const result = await this.$store.dispatch('getLeadEmailQuickLead', {
                        'router': this.$router,
                        'email': this.quickLeadEmail
                    });

                    if (parseInt(result.totalRecords) === 1) {
                        this.quickLeadExistingLeadId = result.data['0'].id;
                        this.quickLeadExistsByEmail = true;
                    } else {
                        this.quickLeadExistingLeadId = 0;
                        this.quickLeadExistsByEmail = false;
                    }
                } else {
                    this.quickLeadExistingLeadId = 0;
                    this.quickLeadExistsByEmail = false;
                }

                if (previousStatus !== this.quickLeadExistsByEmail) {
                    await this.getLeadNameZipQuickLead();
                    await this.getLeadByMobileQuickLead();
                }
            }
        },
        async getLeadNameZipQuickLead()
        {
            if (this.quickLeadExistsByEmail === false && this.quickLeadExistsByPhone === false) {
                let previousStatus = this.quickLeadExistsByNameZip;

                if (this.quickLeadFirstName && this.quickLeadLastName && this.quickLeadZip) {
                    const result = await this.$store.dispatch('getByLeadNameZipQuickLead', {
                        'router': this.$router,
                        'leadFirstName': this.quickLeadFirstName,
                        'leadLastName': this.quickLeadLastName,
                        'leadZip': this.quickLeadZip,
                    });

                    if (parseInt(result.totalRecords) === 1) {
                        this.quickLeadExistingLeadId = result.data['0'].id;
                        this.quickLeadExistsByNameZip = true;
                    } else {
                        this.quickLeadExistingLeadId = 0;
                        this.quickLeadExistsByNameZip = false;
                    }
                } else {
                    this.quickLeadExistingLeadId = 0;
                    this.quickLeadExistsByNameZip = false;
                }

                if (previousStatus !== this.quickLeadExistsByNameZip) {
                    await this.getLeadEmailQuickLead();
                    await this.getLeadByMobileQuickLead();
                }
            }
        },
        async getLeadByMobileQuickLead(event)
        {
            if (this.quickLeadExistsByEmail === false && this.quickLeadExistsByNameZip === false && event) {
                let value = event.target.value;
                let previousStatus = this.quickLeadExistsByPhone;

                if (value) {
                    const result = await this.$store.dispatch('getLeadByMobileQuickLead', {
                        'router': this.$router,
                        'mobileCountryCode': this.quickLeadMobileCountryCode,
                        'mobile': value
                    });

                    this.quickLeadMobile = value;

                    if (parseInt(result.totalRecords) === 1) {
                        this.quickLeadExistingLeadId = result.data['0'].id;
                        this.quickLeadExistsByPhone = true;
                    } else {
                        this.quickLeadExistingLeadId = 0;
                        this.quickLeadExistsByPhone = false;
                    }
                } else {
                    this.quickLeadMobile = value;
                    this.quickLeadExistingLeadId = 0;
                    this.quickLeadExistsByPhone = false;
                }

                if (previousStatus !== this.quickLeadExistsByPhone) {
                    await this.getLeadEmailQuickLead();
                    await this.getLeadNameZipQuickLead();
                }
            }
        },
        processPhoneMobileCountryCodesSelectors() {
            let self = this;

            if (typeof self.additionalInfo.mobileMasks[this.quickLeadMobileCountryCode] !== 'undefined') {
                $(document).find('#lead-mobile-quick-lead').mask(self.additionalInfo.mobileMasks[this.quickLeadMobileCountryCode].mask_value, {autoclear: false});
            } else {
                $(document).find('#lead-mobile-quick-lead').mask('(999) 999 9999', {autoclear: false});
            }
        },
        switchQuickLeadForm()
        {
            if (this.showQuickLeadForm === false) {
                this.showQuickLeadForm = true
            } else {
                this.showQuickLeadForm = false
            }
        },
        switchRecentlyViewedBlock()
        {
          if (this.showRecentlyViewedBlock === true) {
              this.showRecentlyViewedBlock = false;
          } else {
              this.showRecentlyViewedBlock = true;
              this.showAdditionalFiltersBlock = false;
          }
        },
        populateCustomAttributesFilters(data, type)
        {
            let value = '';
            let customParamsData = {};

            for (const [key, customAttributesFilterData] of Object.entries(data)) {
                if (customAttributesFilterData.type !== 'date') {
                    customParamsData[customAttributesFilterData.id] = {
                        'fieldName': customAttributesFilterData.name,
                        'fieldOperator': customAttributesFilterData.operator,
                        'fieldValue': customAttributesFilterData.value,
                        'fieldType': customAttributesFilterData.type,
                        'id': customAttributesFilterData.id,
                        'fieldLabel': customAttributesFilterData.label,
                        'fieldDay':0,
                        'fieldMonth':0,
                        'fieldYear':0,
                    };
                } else {
                    value = JSON.parse(customAttributesFilterData.value);

                    customParamsData[customAttributesFilterData.id] = {
                        'fieldName': customAttributesFilterData.name,
                        'fieldOperator': customAttributesFilterData.operator,
                        'fieldValue': '',
                        'fieldType': customAttributesFilterData.type,
                        'id': customAttributesFilterData.id,
                        'fieldLabel': customAttributesFilterData.label,
                        'fieldDay':value.day,
                        'fieldMonth':value.month,
                        'fieldYear':value.year,
                    };
                }
            }

            if (type === 'organization') {
                this.filterOrganizationCustomAttributesList = customParamsData;
            } else {
                this.filterLeadCustomAttributesList = customParamsData;
            }

        },
        async changeFilterPreset(event)
        {
            let value = event.target.value;

            if (parseInt(value) === 0) {
                this.showFilterPresetInfoFlag = false;
                this.newFilterPresetName = '';
                this.resetFilter();
            } else {
                if (typeof this.additionalInfo.leadFiltersPresets[value] !== 'undefined') {
                    const result = await this.$store.dispatch('getLeadFilterPreset', {
                        'router': this.$router,
                        'id': value
                    });

                    if (typeof result.isDefault !== 'undefined') {
                        result.filterPresetData = JSON.parse(result.filterPresetData);
                        this.processPresetsData(result);
                    }
                }

                this.showFilterPresetInfoFlag = true;
            }

            this.$store.commit('setActiveFilterPreset', value);
        },
        async saveFilterPreset()
        {
            if (this.savePresetFilterProcessing === true) {
                return false;
            }

            if (this.newFilterPresetName.trim() === '') {
                showMessage(this.$t('message.pleaseSpecifyPresetName'), true, 2000);
                return false;
            }

            this.savePresetFilterProcessing = true;

            let access = this.filterPresetShowAll,
                presetData = {},
                createdAtFrom = '',
                createdAtTo = '',
                lastActivityFrom = '',
                lastActivityTo = '',
                lastSequenceFrom = '',
                lastSequenceTo = '',
                opportunityDateFrom = '',
                opportunityDateTo = '',
                validatedDateTo = '',
                filterActivities = [],
                filterLifecycles = [],
                filterByCountryState = [],
                filterByEmailSequence = [],
                filterByTags = [],
                filterBySourceTypes = [],
                filterBySourceUtmValues = [],
                filterByCampaignUtmValues = [],
                filterByOpportunityStatus = [],
                filterByExcludeTags = [],
                createdAt = '',
                lastUpdated = '',
                expectedAt = '',
                creationAt = '',
                stateChangeAt = '',
                switchLastNextActivityDate = '',
                result = [];

            if (this.additionalInfo['userRole'] !== 'admin' && this.additionalInfo['userRole'] !== 'superadmin') {
                access = 'individual';
            }

            if (this.filterLastUpdatedFlag === '') {
                createdAt = 'created_at;'
            }

            if (this.filterLastUpdatedFlag === 'last_updated') {
                lastUpdated = 'last_updated;'
            }

            if (this.filterOpportunityFlag === 'creation_at') {
                creationAt = 'creation_at';
            }

            if (this.filterOpportunityFlag === 'state_change_at') {
                stateChangeAt = 'state_change_at';
            }

            if (this.filterOpportunityFlag === 'expected_at') {
                expectedAt = 'expected_at';
            }

            if (this.lastNextActivitySwitcherValue === 'last_activity') {
                switchLastNextActivityDate = 'last-activity-date';
            }

            if (this.lastNextActivitySwitcherValue === 'next_activity') {
                switchLastNextActivityDate = 'next-activity-date';
            }

            let filterCreationDateFrom = moment(this.filterCreationDateFromForDatepicker).format('YYYY-MM-DD');
            let filterCreationDateTo = moment(this.filterCreationDateToForDatepicker).format('YYYY-MM-DD');
            let filterActivityDateFrom = moment(this.filterActivityDateFromForDatepicker).format('YYYY-MM-DD');
            let filterActivityDateTo = moment(this.filterActivityDateToForDatepicker).format('YYYY-MM-DD');
            let filterOpportunityDateFrom = moment(this.filterOpportunityDateFromForDatepicker).format('YYYY-MM-DD');
            let filterOpportunityDateTo = moment(this.filterOpportunityDateToForDatepicker).format('YYYY-MM-DD');
            let filterEmailValidationDatepicker = moment(this.filterEmailValidationDatepicker).format('YYYY-MM-DD');
            let filterSequenceDateFrom = moment(this.filterSequenceDateFromForDatepicker).format('YYYY-MM-DD');
            let filterSequenceDateTo = moment(this.filterSequenceDateToForDatepicker).format('YYYY-MM-DD');

            if (filterCreationDateFrom !== 'Invalid date') {
                createdAtFrom = filterCreationDateFrom;
            }

            if (filterCreationDateTo !== 'Invalid date') {
                createdAtTo = filterCreationDateTo;
            }

            if (filterActivityDateFrom !== 'Invalid date') {
                lastActivityFrom = filterActivityDateFrom;
            }

            if (filterActivityDateTo !== 'Invalid date') {
                lastActivityTo = filterActivityDateTo;
            }

            if (filterSequenceDateFrom !== 'Invalid date') {
                lastSequenceFrom = filterSequenceDateFrom;
            }

            if (filterSequenceDateTo !== 'Invalid date') {
                lastSequenceTo = filterSequenceDateTo;
            }

            if (filterOpportunityDateFrom !== 'Invalid date') {
                opportunityDateFrom = filterOpportunityDateFrom;
            }

            if (filterOpportunityDateTo !== 'Invalid date') {
                opportunityDateTo = filterOpportunityDateTo;
            }

            if (filterEmailValidationDatepicker !== 'Invalid date') {
                validatedDateTo = filterEmailValidationDatepicker;
            }

            this.filterActivityTypes.forEach((element) => {
                filterActivities.push(element.id);
            });

            this.filterLifecycles.forEach((element) => {
                filterLifecycles.push(element.id);
            });

            this.filterByCountryState.forEach((element) => {
                filterByCountryState.push(element.state);
            });

            this.filterByEmailSequence.forEach((element) => {
                filterByEmailSequence.push(element.id);
            });

            this.filterByTags.forEach((element) => {
                filterByTags.push(element.id);
            });

            this.filterBySourceTypes.forEach((element) => {
                filterBySourceTypes.push(element.id);
            });

            this.filterBySourceUtmValues.forEach((element) => {
                filterBySourceUtmValues.push(element.id);
            });

            this.filterByCampaignUtmValues.forEach((element) => {
                filterByCampaignUtmValues.push(element.id);
            });

            this.filterByOpportunityStatus.forEach((element) => {
                filterByOpportunityStatus.push(element.id);
            });

            this.filterByExcludeTags.forEach((element) => {
                filterByExcludeTags.push(element.id);
            });

            presetData = {
                'created_at_from' : createdAtFrom,
                'range_creation_option': 0,
                'activity_id': filterActivities,
                'created_at_to': createdAtTo,
                'last_activity_from': lastActivityFrom,
                'last_activity_to': lastActivityTo,
                'last_sequence_from': lastSequenceFrom,
                'last_sequence_to': lastSequenceTo,
                'range_activity_option': 0,
                'stage_id': filterLifecycles,
                'customer_group_id':this.filterByGroup,
                'lead_source_type': this.filterByLeadType,
                'lead_source': this.filterByLeadSource,
                'owner_id': this.filterLeadOwnerId,
                'opportunity_owner_id': this.filterByOpportunityOwnerId,
                'lead_zip': this.filterByLeadZip,
                'lead_country': this.filterByCountry,
                'lead_country_state': filterByCountryState,
                'lead_city': this.filterByCity,
                'lead_filter_total_opportunity_amount_from': this.filterByTotalOpportunityAmountFrom,
                'lead_filter_total_opportunity_amount_to': this.filterByTotalOpportunityAmountTo,
                'special_filter_type': this.specialTypeSwitcher,
                'created_at': createdAt,
                'last_updated': lastUpdated,
                'lead_tags': filterByTags,
                'lead_source_type_and_utm': filterBySourceTypes,
                'lead_utm_source_value_id': filterBySourceUtmValues,
                'lead_utm_campaign_value_id': filterByCampaignUtmValues,
                'email_sms_sequences': filterByEmailSequence,
                'lead_tags_exclude': filterByExcludeTags,
                'lead_opportunity_stages': filterByOpportunityStatus,
                'last_interaction_id':this.filterByLastInteractionType,
                'opportunity_type_id':this.filterByOpportunityType,
                'lead_task':this.filterByTaskStatus,
                'more_less_call_duration': this.filterBySignCallDuration,
                'call_duration':this.filterByCallDuration,
                'opportunity_date_from': opportunityDateFrom,
                'opportunity_date_to': opportunityDateTo,
                'expected_at': expectedAt,
                'creation_at': creationAt,
                'state_change_at': stateChangeAt,
                'interaction_value': this.filterOrderBy,
                'lead_score_from': this.filterByScoreFrom,
                'lead_score_to': this.filterByScoreTo,
                'lead_sentiment_score_from': this.filterBySentimentScoreFrom,
                'lead_sentiment_score_to': this.filterBySentimentScoreTo,
                'lead_filter_total_spent_purchase_amount_from': this.filterByTotalSpentPurchaseAmountFrom,
                'lead_filter_total_spent_purchase_amount_to': this.filterByTotalSpentPurchaseAmountTo,
                'outbound_emails_sub_type': this.filterEmailInteractionActivitySubtype,
                'industry_id': this.filterByIndustry,
                'custom_params_search': this.getCustomParams('leads'),
                'custom_organization_params_search': this.getCustomParams('organization'),
                'email_status': this.filterByEmailStatus,
                'lead_titles': this.byLeadTitle,
                'lead_title_operator': this.filterByTitleOperator,
                'lead_filter_nps_score_operator': this.filterByNpsScoreOperator,
                'lead_filter_nps_score': this.filterByNpsScore,
                'email_validation_status': this.filterByEmailValidation,
                'email_sequence_type':this.filterBySequenceType,
                'email_sequence_type_action':this.filterBySequenceTypeAction,
                'email_sms_sequences_type_period':this.emailSmsSequencesTypePeriod,
                'validated_date_to': validatedDateTo,
                'switch_last_next_activity_date': switchLastNextActivityDate
            };

            if (parseInt(this.filterPreset) === 0) {
                result = await this.$store.dispatch('saveFilterPreset', {
                    'router':this.$router,
                    'presetType':'lead',
                    'presetName':this.newFilterPresetName,
                    'isDefault':this.isPresetDefaultFlag,
                    'access':access,
                    'presetData':presetData,
                });
            } else {
                result = await this.$store.dispatch('updateFilterPreset', {
                    'router':this.$router,
                    'id': parseInt(this.filterPreset),
                    'presetType':'lead',
                    'presetName':this.newFilterPresetName,
                    'isDefault':this.isPresetDefaultFlag,
                    'access':access,
                    'presetData':presetData,
                });
            }

            if (parseInt(result.error) === 1) {
                showMessage(result.responseText.message, true, 2000);
                this.savePresetFilterProcessing = false;
                return false;
            } else {
                if (parseInt(this.filterPreset) === 0) {
                    this.filterPreset = result.responseText.id;
                }
                this.additionalInfo['leadFiltersPresets'][result.responseText.id] = result.responseText.filterPresetData;
                showMessage(result.responseText.message, false, 2000);
            }

            this.savePresetFilterProcessing = false;
        },
        async deleteFilterPreset()
        {
            if (parseInt(this.filterPreset) !== 0) {
                let self = this;

                showConfirm(this.$t('message.areYouSureWantToDeletePreset'), async () => {
                    const result = await this.$store.dispatch('deleteLeadFilterPreset', {'router':this.$router, 'id':self.filterPreset});
                    if (parseInt(result.error) === 1) {
                        showMessage(result.responseText, true, 2000);
                        return false;
                    } else {
                        showMessage(result.responseText, false, 2000);
                        delete self.additionalInfo['leadFiltersPresets'][self.filterPreset];
                        self.resetFilter();
                    }
                }, async () => {

                });
            }
        },
        changeFilterSpecialType(type)
        {
            if (type !== 'existing_client') {
                this.filterByTotalSpentPurchaseAmountFrom = '';
                this.filterByTotalSpentPurchaseAmountTo = '';
            }

            this.specialFilterType = type;
        },
        getCustomParams(type)
        {
            let customParamsData = [];
            let year = '';
            let month = '';
            let day = '';
            let value = '';
            let customAttributesFilterList = [];

            if (type === 'leads') {
                customAttributesFilterList = toRaw(this.filterLeadCustomAttributesList);
            } else {
                customAttributesFilterList = toRaw(this.filterOrganizationCustomAttributesList);
            }

            if (Object.keys(customAttributesFilterList).length > 0) {
                for (const [key, customAttributesFilterData] of Object.entries(customAttributesFilterList)) {
                    if (customAttributesFilterData.fieldType !== 'date') {
                        customParamsData.push({
                            'name': customAttributesFilterData.fieldName,
                            'operator': customAttributesFilterData.fieldOperator,
                            'value': customAttributesFilterData.fieldValue,
                            'type': customAttributesFilterData.fieldType,
                            'subtype': '',
                            'id': customAttributesFilterData.id,
                            'label': customAttributesFilterData.fieldLabel
                        });
                    } else {
                        year = customAttributesFilterData.fieldYear;
                        month = customAttributesFilterData.fieldMonth;
                        day = customAttributesFilterData.fieldDay;
                        value = JSON.stringify({'year': year, 'month': month, 'day': day});

                        customParamsData.push({
                            'name': customAttributesFilterData.fieldName,
                            'operator': customAttributesFilterData.fieldOperator,
                            'value': value,
                            'type': customAttributesFilterData.fieldType,
                            'subtype': '',
                            'id': customAttributesFilterData.id,
                            'label': customAttributesFilterData.fieldLabel
                        });
                    }
                }
            }

            return customParamsData;
        },
        generateCustomParamsYears()
        {
            let max = parseInt(new Date().getFullYear()) +10;
            let min = max - 99;
            let years = [];

            for (let i = max; i >= min; i--) {
                years.push(i);
            }

            return years;
        },
        addCustomAttribute(type)
        {
            let customAttributesList = [],
                customAttributeId = 0;

            if (type === 'lead') {
                customAttributesList = toRaw(this.additionalInfo['leadCustomAttributesNames']);
                customAttributeId = parseInt(this.leadCustomAttribute);
            } else {
                customAttributesList = toRaw(this.additionalInfo['organizationCustomAttributesNames']);
                customAttributeId = parseInt(this.organizationCustomAttribute);
            }

            if (customAttributeId !== 0) {
                if (typeof this.filterLeadCustomAttributesList[customAttributeId] === 'undefined' && type === 'lead') {
                    this.filterLeadCustomAttributesList[customAttributeId] = {
                        'id': customAttributesList[customAttributeId]['id'],
                        'fieldName': customAttributesList[customAttributeId]['param_name'],
                        'fieldLabel': customAttributesList[customAttributeId]['label'],
                        'fieldType': customAttributesList[customAttributeId]['param_type'],
                        'fieldValue': '',
                        'fieldOperator':'equal',
                        'fieldYear': 0,
                        'fieldMonth':0,
                        'fieldDay':0,
                    };
                } else if (typeof this.filterOrganizationCustomAttributesList[customAttributeId] === 'undefined' && type === 'organization') {
                    this.filterOrganizationCustomAttributesList[customAttributeId] = {
                        'id': customAttributesList[customAttributeId]['id'],
                        'fieldName': customAttributesList[customAttributeId]['param_name'],
                        'fieldLabel': customAttributesList[customAttributeId]['label'],
                        'fieldType': customAttributesList[customAttributeId]['param_type'],
                        'fieldValue': '',
                        'fieldOperator':'equal',
                        'fieldYear': 0,
                        'fieldMonth':0,
                        'fieldDay':0,
                    };
                } else {
                    showMessage(this.$t('message.fieldAlreadyExists'), true, 3000);
                }
            } else {
                return false;
            }
        },
        removeCustomLeadAttribute(id)
        {
            if (typeof this.filterLeadCustomAttributesList[id] !== 'undefined') {
                delete this.filterLeadCustomAttributesList[id];
            }
        },
        removeCustomOrganizationAttribute(id)
        {
            if (typeof this.filterOrganizationCustomAttributesList[id] !== 'undefined') {
                delete this.filterOrganizationCustomAttributesList[id];
            }
        },
        changeEmailSequence()
        {
            let sequencesInfo = [];

            this.filterByEmailSequence.forEach((element) => {
                sequencesInfo.push(element.id);
            });

            if (Object.keys(sequencesInfo).length > 0) {
                this.showEmailSequenceAdditionalBlock = true;
            } else {
                this.showEmailSequenceAdditionalBlock = false;
            }
        },
        changeFilterEmailValidationType(event)
        {
            let value = event.target.value;

            if (value === 'valid') {
                this.displayFilterValidationAdditionalBlock = true;
            } else {
                this.displayFilterValidationAdditionalBlock = false;
            }

            this.filterEmailValidationDatepicker = '';
        },
        changeFilterByLeadType(event)
        {
            let value = event.target.value;

            if (typeof this.additionalInfo['leadSourcesTypes'][value] !== 'undefined' && (this.additionalInfo['leadSourcesTypes'][value]['type_name'] === 'inbound_call' || this.additionalInfo['leadSourcesTypes'][value]['type_name'] === 'outbound_call')) {
                this.displayCallDurationBlock = true;
            } else {
                this.displayCallDurationBlock = false;
            }
        },
        changeLastInteractionType(event)
        {
            let value = event.target.value;

            if (typeof this.additionalInfo['lastInteractions'][value]  !== 'undefined' && this.additionalInfo['lastInteractions'][value]['type_name'] === 'outbound_email') {
                this.showInteractionEmailSubTypeFilter = true;
            } else {
                this.showInteractionEmailSubTypeFilter = false;
            }
        },
        changeRangeOption(event, type)
        {
            let value = event.target.value;

            this.setDateRange(value, type);
        },
        lastNextActivity(flagValue)
        {
            this.lastNextActivitySwitcherValue = flagValue;
            this.filterActivityDateFromForDatepicker = '';
            this.filterActivityDateToForDatepicker = '';
        },
        setDateRange (switchValue, type) {
            let startDate = '',
                endDate = '',
                date = moment(this.additionalInfo.userTime);

            switch (switchValue) {
                case "1"://Today
                    startDate =  date.startOf('day').toDate();
                    endDate = date.endOf('day').toDate();
                    break;
                case "2"://Yesterday
                    startDate =  date.subtract(1, 'days').startOf('day').toDate();
                    endDate = date.endOf('day').toDate();
                    break;
                case "3"://Last week
                    startDate =  date.subtract(7, 'days').startOf('week').toDate();
                    endDate = date.endOf('week').toDate();
                    break;
                case "4"://Last month
                    startDate = date.endOf('month').subtract(date.daysInMonth() + 1, 'days').startOf('month').toDate();
                    endDate = date.endOf('month').toDate();
                    break;
                case "5"://Last 7 days
                    endDate = date.subtract(0, 'days').endOf('day').toDate();
                    startDate = date.subtract(7, 'days').startOf('day').toDate();
                    break;
                case "6"://Last 30 days
                    endDate = date.subtract(0, 'days').endOf('day').toDate();
                    startDate = date.subtract(30, 'days').startOf('day').toDate();
                    break;
                case "7"://Tomorrow
                    startDate = date.add(1, 'days').startOf('day').toDate();
                    endDate = date.endOf('day').toDate();
                    break;
                case "8"://Next week
                    startDate = date.add(7, 'days').startOf('week').toDate();
                    endDate = date.endOf('week').toDate();
                    break;
                case "9"://Next month
                    startDate = date.startOf('month').add(date.daysInMonth() + 1, 'days').startOf('month').toDate();
                    endDate = date.endOf('month').toDate();
                    break;
                case "10"://Next 7 days
                    startDate = date.add(0, 'days').startOf('day').toDate();
                    endDate = date.add(7, 'days').endOf('day').toDate();
                    break;
                case "11"://Next 30 days
                    startDate =  date.add(0, 'days').startOf('day').toDate();
                    endDate = date.add(30, 'days').endOf('day').toDate();
                    break;
                default:
                    startDate = '';
                    endDate = '';
                    break;
            }

            if (type === 'activityBy') {
                this.filterActivityDateFromForDatepicker = startDate;
                this.filterActivityDateToForDatepicker = endDate;
            }
            if (type === 'leadsBy') {
                this.filterCreationDateFromForDatepicker = startDate;
                this.filterCreationDateToForDatepicker = endDate;
            }
        },
        showHideAdditionalFilters()
        {
            if (this.showAdditionalFiltersBlock === false) {
                this.showAdditionalFiltersBlock = true;
                this.showRecentlyViewedBlock = false;
            } else {
                this.showAdditionalFiltersBlock = false;
            }
        },
        recordRecentlyViewed(id, type)
        {
            const resultStats = this.$store.dispatch('logRecentlyViewed', {'router':this.$router, 'id':id, 'type':type});
            if (type === 'lead') {
                this.$router.push({name: 'lead', params: {'id': id}, query: {'tabName': 'timeline'}});
            }

            if (type === 'organization') {
                window.location.href = this.websiteUrl+'dashboard/organizations/#organization/'+id;
            }
        },
        changeCountry(event)
        {
            let value = event.target.value;

            this.filterByCountryState = [];

            if (typeof this.additionalInfo.statesList[value] !== 'undefined') {
                this.listOfStatesOptions = this.additionalInfo.statesList[value];
            } else {
                this.listOfStatesOptions = [];
            }
        },
        changeFilterBy(filterBy)
        {
            this.filterBy = filterBy;
            if (this.searchTerm) {
                this.applyFilter();
            }
        },
        selectedDatepickerCreationDate(selectedDate, datepickerType){
            if (datepickerType === 'date-from') {
                this.minDateCreationDate = selectedDate;
            } else {
                this.maxDateCreationDate = selectedDate;
            }
            this.componentKey += 1;
        },
        selectedDatepickerActivityDate(selectedDate, datepickerType){
            if (datepickerType === 'date-from') {
                this.minDateActivityDate = selectedDate;
            } else {
                this.maxDateActivityDate = selectedDate;
            }
            this.componentKeyActivity += 1;
        },
        selectedDatepickerSequenceDate(selectedDate, datepickerType){
            if (datepickerType === 'date-from') {
                this.minDateSequenceDate = selectedDate;
            } else {
                this.maxDateSequenceDate = selectedDate;
            }
            if (selectedDate) {
                this.emailSmsSequencesTypePeriod = '';
            }
            this.componentKeySequence += 1;
        },
        selectedOpportunityActivityDate(selectedDate, datepickerType){
            if (datepickerType === 'date-from') {
                this.minDateOpportunityDate = selectedDate;
            } else {
                this.maxDateOpportunityDate = selectedDate;
            }
            this.componentKeyOpportunity += 1;
        },
        changeSequenceType()
        {
            if (this.filterBySequenceType === 'sms' && this.filterBySequenceTypeAction !== 'all') {
                this.filterBySequenceTypeAction = 'sent';
            }
        },
        processUrlPredefinedParams()
        {
            if (isProxy(this.urlPredefinedFilterParams) && Object.keys(this.urlPredefinedFilterParams).length > 0) {
                let urlPredefinedFilterParams = toRaw(this.urlPredefinedFilterParams);
                if (typeof urlPredefinedFilterParams.filter !== 'undefined' && parseInt(urlPredefinedFilterParams.filter) === 1) {
                    console.log(urlPredefinedFilterParams);
                    this.showAdditionalFiltersBlock = true;

                    let self = this;

                    //assign filter values
                    if (typeof urlPredefinedFilterParams.lead_source_type !== 'undefined') {
                        this.filterByLeadType = urlPredefinedFilterParams.lead_source_type;
                        if (typeof this.additionalInfo['leadSourcesTypes'][this.filterByLeadType] !== 'undefined' && (this.additionalInfo['leadSourcesTypes'][this.filterByLeadType]['type_name'] === 'inbound_call' || this.additionalInfo['leadSourcesTypes'][this.filterByLeadType]['type_name'] === 'outbound_call')) {
                            this.displayCallDurationBlock = true;
                        } else {
                            this.displayCallDurationBlock = false;
                        }
                    }

                    if (typeof urlPredefinedFilterParams.last_interaction_id !== 'undefined') {
                        this.filterByLastInteractionType = urlPredefinedFilterParams.last_interaction_id;

                        if (typeof this.additionalInfo['lastInteractions'][this.filterByLastInteractionType]  !== 'undefined' && this.additionalInfo['lastInteractions'][this.filterByLastInteractionType]['type_name'] === 'outbound_email') {
                            this.showInteractionEmailSubTypeFilter = true;
                        } else {
                            this.showInteractionEmailSubTypeFilter = false;
                        }
                    }

                    if (typeof urlPredefinedFilterParams.created_at_from !== 'undefined') {
                        this.filterCreationDateFromForDatepicker = urlPredefinedFilterParams.created_at_from;
                    }

                    if (typeof urlPredefinedFilterParams.created_at_to !== 'undefined') {
                        this.filterCreationDateToForDatepicker = urlPredefinedFilterParams.created_at_to;
                    }

                    if (typeof urlPredefinedFilterParams.customer_group_id !== 'undefined') {
                        this.filterByGroup = urlPredefinedFilterParams.customer_group_id;
                    }

                    if (typeof urlPredefinedFilterParams.owner_id !== 'undefined') {
                        this.filterLeadOwnerId = urlPredefinedFilterParams.owner_id;
                    }

                    if (typeof urlPredefinedFilterParams.opportunity_owner_id !== 'undefined') {
                        this.filterByOpportunityOwnerId = urlPredefinedFilterParams.opportunity_owner_id;
                    }

                    if (typeof urlPredefinedFilterParams.total_opportunity_amount_from !== 'undefined') {
                        this.filterByTotalOpportunityAmountFrom = urlPredefinedFilterParams.total_opportunity_amount_from;
                    }

                    if (typeof urlPredefinedFilterParams.lead_opportunity_stages !== 'undefined') {
                        let leadOpportunityStages = urlPredefinedFilterParams.lead_opportunity_stages.split(',');
                        let filterByOpportunityStatus = [];

                        leadOpportunityStages.forEach(function(item) {
                            if (self.additionalInfo.leadOpportunityStatuses !== 'undefined' && self.additionalInfo.leadOpportunityStatuses[item] !== 'undefined')
                            filterByOpportunityStatus.push(self.additionalInfo.leadOpportunityStatuses[item]);
                        });

                        this.filterByOpportunityStatus = filterByOpportunityStatus;
                    }

                    if (typeof urlPredefinedFilterParams.lead_opportunity_types !== 'undefined') {
                        this.filterByOpportunityType = urlPredefinedFilterParams.lead_opportunity_types;
                    }

                    if (typeof urlPredefinedFilterParams.change_stage_date_to !== 'undefined') {
                        this.filterOpportunityDateToForDatepicker = urlPredefinedFilterParams.change_stage_date_to;
                        this.filterOpportunityFlag = 'state_change_at';
                    }

                    if (typeof urlPredefinedFilterParams.change_stage_date_from !== 'undefined') {
                        this.filterOpportunityDateFromForDatepicker = urlPredefinedFilterParams.change_stage_date_from;
                        this.filterOpportunityFlag = 'state_change_at';
                    }

                    if (typeof urlPredefinedFilterParams.expected_date_from !== 'undefined') {
                        this.filterOpportunityDateFromForDatepicker = urlPredefinedFilterParams.expected_date_from;
                        this.filterOpportunityFlag = 'expected_at';
                    }

                    if (typeof urlPredefinedFilterParams.expected_date_to !== 'undefined') {
                        this.filterOpportunityDateToForDatepicker = urlPredefinedFilterParams.expected_date_to;
                        this.filterOpportunityFlag = 'expected_at';
                    }

                    if (typeof urlPredefinedFilterParams.opportunity_created_at_from !== 'undefined') {
                        this.filterOpportunityDateFromForDatepicker = urlPredefinedFilterParams.opportunity_created_at_from;
                        this.filterOpportunityFlag = 'creation_at';
                    }

                    if (typeof urlPredefinedFilterParams.opportunity_created_at_to !== 'undefined') {
                        this.filterOpportunityDateToForDatepicker = urlPredefinedFilterParams.opportunity_created_at_to;
                        this.filterOpportunityFlag = 'creation_at';
                    }

                    if (typeof urlPredefinedFilterParams.lead_tag !== 'undefined') {
                        let leadTags = urlPredefinedFilterParams.lead_tag.split(',');
                        let filterByTags = [];

                        leadTags.forEach(function(item) {
                            if (self.additionalInfo.leadTags !== 'undefined' && self.additionalInfo.leadTags[item] !== 'undefined') {
                                filterByTags.push(self.additionalInfo.leadTags[item]);
                            }
                        });

                        this.filterByTags = filterByTags;
                    }

                    if (typeof urlPredefinedFilterParams.lead_source_type_and_utm !== 'undefined') {
                        let leadSources = urlPredefinedFilterParams.lead_source_type_and_utm.split(',');
                        let filterBySourceTypes = [];

                        leadSources.forEach(function(item) {
                            if (self.additionalInfo.sourceTypes !== 'undefined' && self.additionalInfo.sourceTypes[item] !== 'undefined') {
                                filterBySourceTypes.push(self.additionalInfo.sourceTypes[item]);
                            }
                        });

                        this.filterBySourceTypes = filterBySourceTypes;
                    }

                    if (typeof urlPredefinedFilterParams.lead_utm_source_value_id !== 'undefined') {
                        let utmSourceValue = urlPredefinedFilterParams.lead_utm_source_value_id.split(',');
                        let filterByUtmSourceValue = [];

                        utmSourceValue.forEach(function(item) {
                            if (self.additionalInfo.sourceValues !== 'undefined' && self.additionalInfo.sourceValues[item] !== 'undefined') {
                                if (self.additionalInfo.sourceValues[item]) {
                                    filterByUtmSourceValue.push(self.additionalInfo.sourceValues[item]);
                                }
                            }
                        });

                        this.filterBySourceUtmValues = filterByUtmSourceValue;
                    }

                    if (typeof urlPredefinedFilterParams.lead_utm_campaign_value_id !== 'undefined') {
                        let utmCampaignValue = urlPredefinedFilterParams.lead_utm_campaign_value_id.split(',');
                        let filterByUtmCampaignValue = [];

                        utmCampaignValue.forEach(function(item) {
                            if (self.additionalInfo.campaignValues !== 'undefined' && self.additionalInfo.campaignValues[item] !== 'undefined') {
                                if (self.additionalInfo.campaignValues[item]) {
                                    filterByUtmCampaignValue.push(self.additionalInfo.campaignValues[item]);
                                }
                            }
                        });

                        this.filterByCampaignUtmValues = filterByUtmCampaignValue;
                    }

                    if (typeof urlPredefinedFilterParams.email_sms_sequences !== 'undefined') {
                        let emailSmsSequences = urlPredefinedFilterParams.email_sms_sequences.split(',');
                        let filterByEmailSmsSequence = [];

                        emailSmsSequences.forEach(function(item) {
                            if (self.additionalInfo.emailSmsSequences !== 'undefined' && self.additionalInfo.emailSmsSequences[item] !== 'undefined') {
                                filterByEmailSmsSequence.push(self.additionalInfo.emailSmsSequences[item]);
                            }
                        });

                        this.filterByEmailSequence = filterByEmailSmsSequence;
                        this.showEmailSequenceAdditionalBlock = true;
                    }

                    if (typeof urlPredefinedFilterParams.email_sequence_type !== 'undefined') {
                        this.filterBySequenceType = urlPredefinedFilterParams.email_sequence_type;
                    }

                    if (typeof urlPredefinedFilterParams.email_sms_sequences_type_period !== 'undefined') {
                        this.emailSmsSequencesTypePeriod = urlPredefinedFilterParams.email_sms_sequences_type_period;
                    }

                    if (typeof urlPredefinedFilterParams.email_sequence_type_action !== 'undefined') {
                        this.filterBySequenceTypeAction = urlPredefinedFilterParams.email_sequence_type_action;
                    }

                    if (typeof urlPredefinedFilterParams.stage_id !== 'undefined') {
                        let leadStagesList = urlPredefinedFilterParams.stage_id.split(',');
                        let filterByleadStagesList = [];

                        leadStagesList.forEach(function(item) {
                            if (self.additionalInfo.lifeCyclesListPreset !== 'undefined' && self.additionalInfo.lifeCyclesListPreset[item] !== 'undefined') {
                                filterByleadStagesList.push(self.additionalInfo.lifeCyclesListPreset[item]);
                            }
                        });

                        this.filterLifecycles = filterByleadStagesList;
                    }

                    if (typeof urlPredefinedFilterParams.activity_id !== 'undefined') {
                        let activityTypes = urlPredefinedFilterParams.activity_id.split(',');
                        let filterByActivityTypes = [];

                        activityTypes.forEach(function(item) {
                            if (self.additionalInfo.activitiesTypes !== 'undefined' && self.additionalInfo.activitiesTypes[item] !== 'undefined') {
                                filterByActivityTypes.push(self.additionalInfo.activitiesTypes[item]);
                            }
                        });

                        this.filterActivityTypes = filterByActivityTypes;
                    }

                    if (typeof urlPredefinedFilterParams.range_options !== 'undefined') {
                        let rangeOptions = urlPredefinedFilterParams.range_options;
                        if (rangeOptions === 'custom') {
                            rangeOptions = 0;
                        }

                        this.rangeOptions = rangeOptions;
                    }

                    if (typeof urlPredefinedFilterParams.next_activity_from !== 'undefined') {
                        this.filterActivityDateFromForDatepicker = urlPredefinedFilterParams.next_activity_from;
                    }

                    if (typeof urlPredefinedFilterParams.next_activity_to !== 'undefined') {
                        this.filterActivityDateToForDatepicker = urlPredefinedFilterParams.next_activity_to;
                    }

                    if (typeof urlPredefinedFilterParams.next_sequence_from !== 'undefined') {
                        this.filterSequenceDateFromForDatepicker = urlPredefinedFilterParams.next_sequence_from;
                    }

                    if (typeof urlPredefinedFilterParams.next_sequence_to !== 'undefined') {
                        this.filterSequenceDateToForDatepicker = urlPredefinedFilterParams.next_sequence_to;
                    }

                    if (typeof urlPredefinedFilterParams.validated_date_to !== 'undefined') {
                        this.filterEmailValidationDatepicker = urlPredefinedFilterParams.validated_date_to;
                        this.displayFilterValidationAdditionalBlock = true;
                    }

                    this.applyFilter();

                    this.showAdditionalFiltersBlock = false;
                 }
            }
        },
        showFilterByUtmSource(typeNumber)
        {
            let flag = false;
            for (let i = 0; i < this.filterBySourceTypes.length; i++) {
                if (this.filterBySourceTypes[i].id === typeNumber) {
                    flag = true;
                    break;
                }
            }

            return flag;
        },
        showHideLicenceDescription()
        {

            if (this.showLicenceDescription === false) {
                this.showLicenceDescription = true;
            } else {
                this.showLicenceDescription = false;
            }
        },
        getParams(pathParams) {
            let result = {},
                tmpData = [];

            pathParams
                .split("&")
                .forEach(function (item) {
                    tmpData = item.split("=");
                    if (tmpData[0] !== '') {
                        result[decodeURIComponent(tmpData[0])] = decodeURIComponent(tmpData[1]);
                    }
                });
            return result;
        }
    },
    async created(){
        if (typeof this.localeMapping[this.locale] !== 'undefined') {
            this.$i18n.locale = this.localeMapping[this.locale];
        }

        const result = await this.$store.dispatch('getGeneralLeadsScreenData', {'router':this.$router});
        if(result.status === 'error') {
            showMessage('Please re-login', true, 3000);
        } else {
            let urlParamsString = window.location.search;

            if (urlParamsString !== '' && urlParamsString.indexOf('?') > -1) {
                this.urlPredefinedFilterParams = this.getParams(urlParamsString.replace('?', ''));
                this.processUrlPredefinedParams();
            } else {
                this.urlPredefinedFilterParams = [];
            }

            this.reprocessFilterFields();
            this.reprocessPreset();

            this.quickLeadMobileCountryCode = this.additionalInfo.userDefaultMobileCountryCode;
            this.loadedScreen = true;
            this.mainScreenLoaded = true;
        }

    },
    async updated() {
        this.$nextTick(function () {
            this.processPhoneMobileCountryCodesSelectors();
            if (typeof checkboxRadioStyle !== 'undefined' && typeof checkboxRadioStyle() === "function") {
                checkboxRadioStyle();
            }
        })
    }
}
