import {mapGetters} from 'vuex';
import lodash from 'lodash';
import localeMapping from '../../../localizationLanguages';
import pagination from '../../pagination';
import { isProxy, toRaw } from 'vue';

import tinymce from "tinymce/tinymce";
import 'tinymce/models/dom';
import 'tinymce/themes/silver';
import 'tinymce/icons/default';
import 'tinymce/skins/ui/oxide/skin.min.css';
import 'tinymce/skins/ui/oxide/content.min.css';
import 'tinymce/plugins/fullscreen';
import 'tinymce/plugins/code';
import 'tinymce/plugins/link';
import 'tinymce/plugins/advlist';
import 'tinymce/plugins/lists';
import 'tinymce/plugins/anchor';
import 'tinymce/plugins/image';
import 'tinymce/plugins/charmap';
import 'tinymce/plugins/visualblocks';
import 'tinymce/plugins/media';
import 'tinymce/plugins/table';
import 'tinymce/plugins/autolink';
import leadshortcode from '../../../../../../tinymce-vue-plugins/leadshortcode/plugin';
import spellcheck from '../../../../../../tinymce-vue-plugins/spellcheck/plugin';
import leadtestemail from '../../../../../../tinymce-vue-plugins/leadtestemail/plugin';
import leadgenerateemailreply from '../../../../../../tinymce-vue-plugins/leadgenerateemailreply/plugin';

import Editor from "@tinymce/tinymce-vue";

export default {
    props: ['leadId'],
    data () {
        return {
            loadedScreen: true,
            websiteUrl: $('#website_url').val(),
            locale: $('#dashboard-system-language').val(),
            localeMapping: localeMapping,
            emailFrom:'',
            emailTo:'',
            emailBcc:'',
            emailSubject:'',
            temporarySubject:0,
            emailPreviewPageUrl:'',
            emailPreviewPageUrlClass:'',
            emailTemplateClass:'',
            loadedScreenData:false,
            folderName:'0',
            activeFileImagesDetailsType:'',
            openFolderPath: 'backend/backend_media/uploadthings/',
            keyMediaLink:0,
            emailTemplateName:'default',
            previousTemplateValue:'default',
            emailTextData:'',
            regularEmailProcessing:false,
            emailSequences:[],
            imagesData:{},
            filesDataInfo:{},
            generateAiEmailReplyProcessing:''
        }
    },
    components: {
        editor: Editor
    },
    computed: {
        ...mapGetters({
            formatDate: 'formatDate',
            formatOnlyDate: 'formatOnlyDate',
            formatTimeOnly: 'formatTimeOnly',
            formatTimeOnlyWithPartOfTheDay: 'formatTimeOnlyWithPartOfTheDay',
            configDataInfo:'getAdditionalInfoDetailedScreen',
            sortByColumn: 'sortByColumn',
            truncateText: 'truncateText',
            toCurrency:'toCurrency',
            unescapeValue:'unescapeValue',
            additionalInfo:'getEmailAdditionalSubTabData',
            emailData: 'getEmailSubTabData',
            leadData:'getDetailedScreenLeadData',
            generalAdditionalInfo:'getAdditionalInfoDetailedScreen',
        })
    },
    watch:{
        folderName(newValue){
            if (newValue !== '0') {
                this.openFolderPath = 'backend/backend_media/uploadthings/folder/' + newValue+'/';
            } else {
                this.openFolderPath = 'backend/backend_media/uploadthings/';
            }

            ++this.keyMediaLink;
        }
    },
    methods: {
        async loadData() {

            this.emailFrom = this.leadData.currentUserEmail;
            this.emailTo = this.leadData.lead_email;

            const result = await this.$store.dispatch('getEmailTabData', {'router':this.$router, 'leadId': this.leadId});

            if (parseInt(result.error) === 1) {
                showMessage(result.message, true, 3000);
                return false;
            } else {
                if (this.emailData.defaultEmailMessagePageUrl !== '') {
                    this.emailPreviewPageUrlClass = '';
                    this.emailPreviewPageUrl = this.websiteUrl+this.emailData.defaultEmailMessagePageUrl;
                } else {
                    this.emailPreviewPageUrlClass = 'hidden';
                    this.emailPreviewPageUrl = 'javascript:;';
                }

                if (this.emailPreviewPageUrlClass === '') {
                    this.emailTemplateClass = 'grid_8';
                } else {
                    this.emailTemplateClass = 'grid_12 alpha omega t-grid_6 t-alpha t-omega';
                }

            }

            this.loadedScreenData = true;
        },
        async hideShowFileImagesDetails(type)
        {
            if (this.activeFileImagesDetailsType === type) {
                this.activeFileImagesDetailsType = '';
            } else {
                this.activeFileImagesDetailsType = type;
            }
        },
        async changeFolder()
        {
            if (this.folderName === '0') {
                this.imagesData = {};
            } else {
                const result = await this.$store.dispatch('loadImages', {
                    'router':this.$router,
                    'folderName': this.folderName,
                    'associativeFlag':1
                });

                if (parseInt(result.error) === 1) {

                } else {
                    await this.changeFiles();
                    this.imagesData = result.responseText;
                }
            }
        },
        async changeFiles()
        {
            const result = await this.$store.dispatch('loadFiles', {
                'router':this.$router,
                'folderName': this.folderName,
                'associativeFlag':1
            });

            if (parseInt(result.error) === 1) {

            } else {
                this.filesDataInfo = result.responseText;
            }
        },
        async refreshFoldersData()
        {
            await this.changeFolder();
        },
        async changeLeadEmailTemplate(event)
        {
            let value = event.target.value,
                self = this;

            if (this.emailTextData === '') {
                await self.changeTemplate(value);
                self.previousTemplateValue = value;
            } else {
                showConfirm(this.$t('message.emailSubYourChangesWillBeDiscarded'), async () => {
                    self.previousTemplateValue = value;
                    await self.changeTemplate(value);

                }, async () => {
                    self.emailTemplateName = self.previousTemplateValue;
                });
            }
        },
        async changeTemplate(templateId)
        {
            const result = await this.$store.dispatch('getEmailTemplate', {'router':this.$router, 'leadId': this.leadId, 'templateId':templateId});

            if (parseInt(result.error) === 1) {
                tinymce.activeEditor.execCommand(
                    'mceInsertContent',
                    false, '');

                showMessage(result.message, true, 3000);
                return false;
            } else {
                tinymce.activeEditor.dom.remove('email-default-message-template');
                if (result.responseText.emailDefaultMessage) {
                    tinymce.activeEditor.execCommand(
                        'mceInsertContent',
                        false, '<div id="email-default-message-template">'+result.responseText.emailDefaultMessage+'</div>');
                }

                if (result.responseText.pageUrl !== '') {
                    this.emailPreviewPageUrlClass = '';
                    this.emailPreviewPageUrl = this.websiteUrl+result.responseText.pageUrl;
                    this.emailTemplateClass = 'grid_8';
                    if ((this.temporarySubject === 1 || !this.emailSubject) && result.responseText.subject) {
                        this.emailSubject = result.responseText.subject;
                        this.temporarySubject = 1;
                    }
                } else {
                    this.emailPreviewPageUrlClass = 'hidden';
                    this.emailPreviewPageUrl = 'javascript:;';
                    this.emailTemplateClass = 'grid_12 alpha omega t-grid_6 t-alpha t-omega';
                }
            }
        },
        changeSubject()
        {
            this.temporarySubject = 0;
        },
        async sendTestEmail()
        {
            this.sendEmail(1)
        },
        async sendEmail(testEmailFlag)
        {
            if (this.regularEmailProcessing === true) {
                return false;
            }

            this.regularEmailProcessing = true;

            let emailSequenceId = 0,
                isTestEmail = testEmailFlag || 0;

            if (typeof this.emailSequences.id !== 'undefined') {
                emailSequenceId = this.emailSequences.id;
            }

            const result = await this.$store.dispatch('sendEmailFromEmailTab', {
                'router':this.$router,
                'leadId': this.leadId,
                'leadEmailFrom': this.emailFrom,
                'leadEmailTo': this.emailTo,
                'leadEmailBccTo': this.emailBcc,
                'leadEmailSubject': this.emailSubject,
                'leadEmailTemplate': this.emailTemplateName,
                'leadEmailFollowUpSequences': emailSequenceId,
                'emailContent': this.emailTextData,
                'testEmail': isTestEmail,
            });

            if (parseInt(result.error) === 1) {
                showMessage(result.responseText, true, 3000);
                this.regularEmailProcessing = false;
                return false;
            } else {
                showMessage(result.responseText, false, 3000);
                if (!isTestEmail) {
                    this.resetEmailForm();
                    await this.loadData();
                }
                this.regularEmailProcessing = false;
            }
        },
        resetEmailForm()
        {
            this.emailFrom = '';
            this.emailTo = '';
            this.emailBcc = '';
            this.emailSubject = '';
            this.emailTemplateName = 'default';
            this.emailSequences = [];
            this.emailTextData = '';
        },
        insertImage(index, type)
        {
            let imageData = toRaw(this.imagesData[type][index]),
                aElem = document.createElement("a"),
                imgElem = document.createElement("img");

            aElem.href = imageData['srcPath'] + '/original/'+imageData['image'];
            aElem.className = '_lbox';
            aElem.title = imageData['imageName'].replace('-', '&nbsp;');

            imgElem.src = imageData['srcPath'] + '/' + imageData['type'] + '/' + imageData['image'];
            imgElem.alt = imageData['imageName'].replace('-', '&nbsp;');
            imgElem.width = imageData['imageWidth'];
            imgElem.height = imageData['imageHeight'];

            aElem.appendChild(imgElem);

            tinymce.activeEditor.execCommand('mceInsertContent', false, aElem.outerHTML);
        },
        insertFileLink(index)
        {
            let fileName = this.filesDataInfo['files'][index];

            tinymce.activeEditor.execCommand(
                'mceInsertContent',
                false,
                '<a class="file-link-attachment" data-file-name="'+fileName+'" data-file-folder="'+this.filesDataInfo['fileFolder']+'" href="' + this.websiteUrl + 'media/' + this.filesDataInfo['fileFolder'] + '/' + fileName + '" title="' + fileName + '">' + fileName + '</a>'
            );
        },
        async generateAiEmailReply()
        {
            if (this.generateAiEmailReplyProcessing === true) {
                return false;
            }

            this.generateAiEmailReplyProcessing = true;

            const result = await this.$store.dispatch('generateAiEmailReply', {
                'router': this.$router, 'leadId': this.leadId, 'emailContent':this.emailTextData
            });

            if (parseInt(result.error) === 1) {
                showMessage(result.responseText, true, 3000);
                this.generateAiEmailReplyProcessing = false;
                return false;
            } else {
                showMessage(result.responseText.message, false, 2000);
                console.log(result);

                this.emailTextData = '';

                tinymce.activeEditor.execCommand('selectAll', false, null);
                tinymce.activeEditor.execCommand('delete', false, null);

                tinymce.activeEditor.execCommand(
                    'mceInsertContent',
                    false, result.responseText.emailReplyData.email_reply_data);

                this.generateAiEmailReplyProcessing = false;
            }
        },

    },
    async created(){
        if (typeof this.localeMapping[this.locale] !== 'undefined') {
            this.$i18n.locale = this.localeMapping[this.locale];
        }

        this.loadData();
    },
    async updated() {
        this.$nextTick(function () {
            if (typeof checkboxRadioStyle !== 'undefined' && typeof checkboxRadioStyle() === "function") {
                checkboxRadioStyle();
            }
        })
    }
}
