import merge from 'lodash/merge';
import mergeWith from 'lodash/mergeWith';
import isArray from 'lodash/isArray';

let state = {
    messages: [],
    creditBalance: null,
    resetDate: null,
}

const getters = {
    getState: (state) => {
        return state;
    },
};

const actions = {

    getCreditBalance: ({state, rootState, commit}) => {
        return new Promise((resolve, reject) => {
            $.ajax({
                type: "GET",
                url: $('#website_url').val() + 'api/leadsopenai/openaiservicecredits',
                data: {},
                dataType: 'json'
            }).done(function (response) {
                if (parseInt(response.error) === 1) {
                    commit('setState',{creditBalance: 0})
                } else {
                    commit('setState',{creditBalance: response.credits, resetDate: response.resetDate})
                }

                return resolve(response);
            }).fail(async function(response){
                resolve();
            });
        });
    },

    getHistoryAction: ({commit, rootState}, payload = []) => {
        return new Promise((resolve, reject) => {
            $.ajax({
                type: "GET",
                url: $('#website_url').val() + 'api/leadsopenai/openaiservicechat',
                data: {
                    ...payload
                },
                dataType: 'json'
            }).done(function (response) {
                if (parseInt(response.error) === 1) {
                    return resolve(response);
                }

                if (response.data.length > 0) {
                    response.data = response.data.map(item => {
                        if (item.content) {
                            // 1) Convert markdown-like ([text](url)) inside parentheses to <a>
                            item.content = item.content.replace(
                                /\(\[([^\]]+)\]\((https?:\/\/[^)]+)\)\)/g,
                                '<a href="$2" target="_blank" rel="noopener noreferrer">$1</a>'
                            );
                            // 1) Convert markdown-style ([text](url))
                            item.content = item.content.replace(
                                /\(\[([^\]]+)\]\((https?:\/\/[^)]+)\)\)/g,
                                '<a href="$2" target="_blank" rel="noopener noreferrer">$1</a>'
                            );

                            // 2) Remove utm_source=openai
                            item.content = item.content.replace(/[?&]utm_source=openai/g, '');

                            // --- Convert string to DOM ---
                            const parser = new DOMParser();
                            const doc = parser.parseFromString(item.content, 'text/html');

                            // --- Remove ONLY the second link when its text is "help.seosamba.com" ---
                            doc.querySelectorAll('*').forEach(parent => {
                                const links = parent.querySelectorAll(':scope > a'); // only direct children
                                if (links.length === 2) {
                                    const second = links[1];
                                    if (second.textContent.trim() === 'help.seosamba.com') {
                                        second.remove();
                                    }
                                }
                            });

                            // --- Back to string ---
                            item.content = doc.body.innerHTML;


                        }
                        return item;
                    });
                }

                commit('setState', {messages: response.data});
                return resolve(response);
            }).fail(async function(response){
                resolve();
            });
        });
    },
    postHistoryAction: ({rootState}, payload = []) => {
        return new Promise((resolve, reject) => {
            $.ajax({
                type: "POST",
                url: $('#website_url').val() + 'api/leadsopenai/openaiservicechat',
                data: {
                    ...payload
                },
                dataType: 'json'
            }).done(function (response) {
                console.log(response);
                if(response.error){
                    showMessage(response.message, response.error);
                    return resolve();
                }
                return resolve(response);
            }).fail(async function(response){
                resolve();
            });
        });
    },


};

const mutations = {
    setState: (state, payload) => {
        mergeWith(state, payload, (objValue, srcValue) => {
            if (isArray(objValue)) {
                return srcValue;
            }
        });
    },
}

export default {
    namespaced: true,
    state,
    getters,
    actions,
    mutations
};