export const saveConfigData = ({commit, state, dispatch}, payload) => {
    showLoader();
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val() + 'api/leads/leadwebhookurls/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'secureToken' : $('#webhookurls-tab-config-token').val(),
                'webhookName':payload.webhookName,
                'webhookType':payload.webhookType,
                'webhookActionType':payload.webhookActionType,
                'actionUrl':payload.actionUrl,
            }
        }).done(async function (response) {
            hideLoader();
            if (response.status === 'error') {
                resolve(response);
            } else {
                resolve(response);
            }

        }).fail(async function(response){
            hideLoader();
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};

export const updateConfigData = ({commit, state, dispatch}, payload) => {
    showLoader();
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val() + 'api/leads/leadwebhookurls/',
            'type': 'PUT',
            'dataType': 'json',
            'data': JSON.stringify({
                'secureToken' : $('#webhookurls-tab-config-token').val(),
                'webhookName':payload.webhookName,
                'webhookType':payload.webhookType,
                'webhookActionType':payload.webhookActionType,
                'actionUrl':payload.actionUrl,
                'id':payload.configId
            })
        }).done(async function (response) {
            hideLoader();
            if (response.status === 'error') {
                resolve(response);
            } else {
                resolve(response);
            }

        }).fail(async function(response){
            hideLoader();
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};

export const deleteConfigRecord = ({commit, state, dispatch}, payload) => {
        showLoader();
        return new Promise((resolve, reject) => {
            $.ajax({
                'url': $('#website_url').val() + 'api/leads/leadwebhookurls/id/' + payload.id,
                'type': 'DELETE',
                'dataType': 'json'
            }).done(async function (response) {
                hideLoader();
                if (response.status === 'error') {
                    resolve(response);
                } else {
                    resolve(response);
                }

            }).fail(async function (response) {
                hideLoader();
                resolve({name: 'login', 'message': 'Please re-login'});
            });
        });
};

export const getConfigSavedData = ({commit, state, dispatch}, payload) => {
    showLoader();

    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leadwebhookurls/',
            'type': 'GET',
            'dataType': 'json',
            'data': {
                'limit': state.pagination.webhookUrlsConfig.itemsPerPage,
                'offset': (state.pagination.webhookUrlsConfig.currentPage - 1) * state.pagination.webhookUrlsConfig.itemsPerPage,
                'id': payload.configId
            }
        }).done(async  function(response){
            hideLoader();
            if (response.status !== 'error') {
                commit('setPaginationData', {webhookUrlsConfig: {totalItems: response.totalRecords}});
                commit('setConfigDataInfo', response.data);
                commit('setAdditionalInfo', response.additionalInfo);
                resolve(response);
            } else {
                resolve({ name: 'login', 'message': 'Please re-login'});
            }
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};

