
export const saveConfigData = ({commit, state, dispatch}, payload) => {
    showLoader();
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val() + 'api/leads/leadstage/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'secureToken' : $('#lead-stage-secure-token').val(),
                'stageName': payload.stageName,
            }
        }).done(async function (response) {
            hideLoader();
            if (response.status === 'error') {
                resolve(response);
            } else {
                resolve(response);
            }

        }).fail(async function(response){
            hideLoader();
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
}

export const setDefaultStage = ({commit, state, dispatch}, payload) => {
    showLoader();
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val() + 'api/leads/leadstage/',
            'type': 'PUT',
            'dataType': 'json',
            'data': JSON.stringify({
                'secureToken' : $('#lead-stage-secure-token').val(),
                'id': payload.id,
                'default': '1',
            })
        }).done(async function (response) {
            hideLoader();
            if (response.status === 'error') {
                resolve(response);
            } else {
                resolve(response);
            }

        }).fail(async function(response){
            hideLoader();
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
}

export const deleteConfigRecord = ({commit, state, dispatch}, payload) => {
        showLoader();
        return new Promise((resolve, reject) => {
            $.ajax({
                'url': $('#website_url').val() + 'api/leads/leadstage/id/' + payload.id+'/secureToken/'+ $('#lead-stage-secure-token').val(),
                'type': 'DELETE',
                'dataType': 'json'
            }).done(async function (response) {
                hideLoader();
                if (response.status === 'error') {
                    resolve(response);
                } else {
                    resolve(response);
                }

            }).fail(async function (response) {
                hideLoader();
                resolve({name: 'login', 'message': 'Please re-login'});
            });
        });
}

export const getConfigSavedData = ({commit, state, dispatch}, payload) => {
    showLoader();

    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'/api/leads/leadstage/',
            'type': 'GET',
            'dataType': 'json',
            'data': {
                'limit': state.pagination.lifecycleStageConfig.itemsPerPage,
                'offset': (state.pagination.lifecycleStageConfig.currentPage - 1) * state.pagination.lifecycleStageConfig.itemsPerPage
            }
        }).done(async  function(response){
            hideLoader();
            if (response.status !== 'error') {
                commit('setPaginationData', {lifecycleStageConfig: {totalItems: response.lifecycleStageData.totalRecords}});
                commit('setConfigDataInfo', response.lifecycleStageData.data);
                commit('setLeadStages', response.leadStages);
                resolve(response);
            } else {
                resolve({ name: 'login', 'message': 'Please re-login'});
            }
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
}

export const updateStageName = ({commit, state, dispatch}, payload) => {
    showLoader();

    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leadstage/',
            'type': 'PUT',
            'dataType': 'json',
            'data': JSON.stringify({
                'id': payload.id,
                'stage_name': payload.stageName,
                'secureToken': $('#lead-stage-secure-token').val()
            })
        }).done(function(response){
            hideLoader();
            if (response.status === 'error') {
                resolve(response);
            } else {
                resolve(response);
            }
        }).fail(async function(response){
            hideLoader();
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
}

export const getOrganizeFieldsData = ({commit, state, dispatch}, payload) => {
    showLoader();
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val() + 'api/leads/leadcrmorganizeconfig/',
            'type': 'GET',
            'dataType': 'json',
            'data': {
                'type': payload.type,
                'secureToken': $('#lead-stage-secure-token').val()
            }
        }).done(async function (response) {
            hideLoader();
            if (response.status === 'error') {
                resolve(response);
            } else {
                resolve(response);
            }
        }).fail(async function (response) {
            hideLoader();
            resolve({name: 'login', 'message': 'Please re-login'});
        });
    });
}

export const setDraggableFieldsData = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        let fieldsSort = $('#organize-stages-fields-sortable').find('li'),
            draggableParamsIds = [];
        if(fieldsSort.length) {
            $.each(fieldsSort, function(key, liEl) {
                let paramId = $(liEl).data('param-id');
                draggableParamsIds.push(paramId);
            });
        }

        $.ajax({
            'url': $('#website_url').val() + 'api/leads/leadcrmorganizeconfig/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'type': payload.type,
                'draggableParamsIds': draggableParamsIds,
                'secureToken': $('#lead-stage-secure-token').val()
            }
        }).done(function (response) {
            if (response.responseText.status === 'error') {
                resolve(response);
            } else {
                resolve(response);
            }
        }).fail(function (response) {
            resolve({name: 'login', 'message': 'Please re-login'});
        });
    });
}
