import {mapGetters} from 'vuex';
import localeMapping from '../../../localizationLanguages';
import pagination from '../../pagination';
export default {
    data () {
        return {
            loadedForm: false,
            loadedGrid: false,
            addOrganizeFieldsGrid: false,
            websiteUrl: $('#website_url').val(),
            stageName: '',
            organizeParams: {},
            type: '',
            localeMapping: localeMapping,
            locale: $('#system-language-custom-fields').val()
        }
    },
    components: {
        pagination: pagination
    },
    computed: {
        configDataInfo: function() {
            return this.$store.getters.getConfigDataInfo;
        },
        leadStages: function() {
            return this.$store.getters.getLeadStages;
        }
    },
    methods: {
        async deleteConfigItem(id){
            showConfirm(this.$t('message.areYouShure'), async () => {
                const result = await this.$store.dispatch('deleteConfigRecord', {'id': id});
                console.log('deleteTab',result);
                if (result.status === 'error') {
                    showMessage(result.message, true, 2000);
                    return false;
                } else {
                    showMessage(result.message, false, 2000);
                    const resultConfigData = await this.$store.dispatch('getConfigSavedData', {'router':this.$router});
                    if(result.status === 'error') {

                    } else {
                        this.loadedGrid = true;
                    }
                }
            });
        },
        async setDefaultStage(event) {
            event.preventDefault();

            let stageId = event.target.value;
            const result = await this.$store.dispatch('setDefaultStage', {'id': stageId});
            console.log('setDefaultStage',result);
            if (result.status === 'error') {
                showMessage(result.message, true, 2000);
                return false;
            } else {
                showMessage(result.message, false, 2000);
                return true;
            }
        },
        async addNewStage(e){
            let stageName = this.stageName;

            if(stageName == '') {
                showMessage(this.$t('message.pleaseEnterLifecycleStageName'), true, 2000);
                return false;
            }

            const result = await this.$store.dispatch('saveConfigData', {
                'stageName':this.stageName.replace(/[^a-zA-Z0-9-_ ]/g, ''),
            });
            console.log('addNewStage',result);
            if (result.status === 'error') {
                showMessage(result.message, true, 2000);
                return false;
            } else {
                this.stageName = '';
                showMessage(result.message, false, 2000);
                const resultConfigData = await this.$store.dispatch('getConfigSavedData', {'router':this.$router});
                if(result.status === 'error') {

                } else {
                    this.loadedGrid = true;
                }
            }
        },
        async updateName(id, oldName, event) {
            let stageName = event.target.value;

            stageName = stageName.replace(/[^a-zA-Z0-9'-_ ]/g, '');

            if(stageName.length < 1) {
                showMessage(this.$t('message.lifecycleStageEmpty'), true, 2000);
                event.target.value = oldName;
                return false;
            } else {
                const result = await this.$store.dispatch('updateStageName', {'id': id, 'stageName': stageName});
                console.log('updateTabLabel',result);
                if (result.status === 'error') {
                    event.target.value = oldName;
                    showMessage(result.message, true, 2000);
                    return false;
                } else {
                    event.target.value = stageName;
                    showMessage(result.message, false, 2000);
                    return true;
                }
            }
        },
        async fieldOrganize(type){
            this.type = type;
            const result = await this.$store.dispatch('getOrganizeFieldsData', {'type': type});
            console.log('fieldOrganize', result);
            if(result.status === 'error') {
                showMessage('Please re-login', true, 3000);
            } else {
                $('#organize-stages-fields-sortable').sortable({
                    deactivate: this.processDragableCustomFieldsTab
                });
                this.loadedGrid = false;
                this.addOrganizeFieldsGrid = true;
                this.organizeParams = result.organizeFieldsData;
            }
        },
        backToMainGrid: function () {
            this.addOrganizeFieldsGrid = false;
            this.loadedGrid = true;
        },
        processDragableCustomFieldsTab: function () {
            const resultOrganizeFieldsData = this.$store.dispatch('setDraggableFieldsData', {'type': this.type});
        }
    },
    async created(){
        if (typeof this.localeMapping[this.locale] !== 'undefined') {
            this.$i18n.locale = this.localeMapping[this.locale];
        }

        const result = await this.$store.dispatch('getConfigSavedData', {'router':this.$router});
        console.log('created', result);
        if(result.status === 'error') {
            showMessage('Please re-login', true, 3000);
        } else {
            this.loadedForm = true;
        }
        if(result.status === 'error') {

        } else {
            this.loadedGrid = true;
        }
    },
    async updated() {
        this.$nextTick(function () {
            if (typeof checkboxRadioStyle !== 'undefined' && typeof checkboxRadioStyle() === "function") {
                checkboxRadioStyle();
            }
        })
    }
}
