-- 09/10/2017
-- version: 1.0.0
CREATE TABLE IF NOT EXISTS `plugin_leads_events` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `event_name` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL,
  `event_label` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_events_relation` (
  `event_id` INT(10) UNSIGNED NOT NULL,
  `external_id` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY(`event_id`, `external_id`),
  FOREIGN KEY(`event_id`) REFERENCES `plugin_leads_events` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_event_rules_general_config` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `event_id` INT(10) UNSIGNED NOT NULL,
  `rule_name` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL,
  `created_at` TIMESTAMP NOT NULL,
  `creator_id` INT(10) UNSIGNED DEFAULT NULL,
  `updated_at` TIMESTAMP NOT NULL,
  `editor_id` INT(10) UNSIGNED DEFAULT NULL,
  PRIMARY KEY(`id`),
  FOREIGN KEY (`creator_id`) REFERENCES `user` (`id`) ON DELETE SET NULL ON UPDATE NO ACTION,
  FOREIGN KEY (`editor_id`) REFERENCES `user` (`id`) ON DELETE SET NULL ON UPDATE NO ACTION,
  FOREIGN KEY (`event_id`) REFERENCES `plugin_leads_events` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION,
  UNIQUE (`rule_name`, `event_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_event_rules_config` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `rule_id` INT(10) UNSIGNED NOT NULL,
  `field_name` VARCHAR (255) COLLATE utf8_unicode_ci NOT NULL,
  `rule_comparison_operator` ENUM('equal', 'notequal', 'like', 'in') DEFAULT 'equal',
  `field_value` MEDIUMTEXT COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY(`id`),
  FOREIGN KEY (`rule_id`) REFERENCES `plugin_leads_event_rules_general_config` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_event_rules_actions` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `rule_id` INT(10) UNSIGNED NOT NULL,
  `action_type` ENUM ('assign_owner', 'assign_task', 'assign_tags', 'assign_lifecycle') DEFAULT 'assign_owner',
  `action_config` TEXT COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY(`id`),
  UNIQUE(`rule_id`, `action_type`),
  FOREIGN KEY (`rule_id`) REFERENCES `plugin_leads_event_rules_general_config` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

ALTER TABLE `plugin_leads_form_rules_actions` MODIFY COLUMN `action_type` ENUM ('assign_owner', 'assign_task', 'assign_tags', 'assign_lifecycle') DEFAULT 'assign_owner';
ALTER TABLE `plugin_leads_call_log` ADD COLUMN `call_source` VARCHAR(255) DEFAULT NULL;
ALTER TABLE `plugin_leads_call_log` ADD COLUMN `receiver` VARCHAR(20) COLLATE utf8_unicode_ci DEFAULT NULL;

-- 09/10/2017
-- version: 1.1.0
ALTER TABLE `plugin_leads_ips` MODIFY COLUMN `lead_ip_address` VARCHAR(45) NOT NULL;
ALTER TABLE `plugin_leads_last_viewed` MODIFY COLUMN `viewed_at` TIMESTAMP NOT NULL;

-- 16/11/2017
-- version: 1.2.0
ALTER TABLE `plugin_leads_form_rules_actions` MODIFY COLUMN `action_type` ENUM ('assign_owner', 'assign_task', 'assign_tags', 'assign_lifecycle', 'assign_sequence') DEFAULT 'assign_owner';
ALTER TABLE `plugin_leads_event_rules_actions` MODIFY COLUMN `action_type` ENUM ('assign_owner', 'assign_task', 'assign_tags', 'assign_lifecycle', 'assign_sequence') DEFAULT 'assign_owner';

-- 20/11/2017
-- version: 1.2.1
ALTER TABLE `plugin_leads_form_rules_actions` MODIFY COLUMN `action_type` ENUM ('assign_owner', 'assign_task', 'assign_tags', 'assign_lifecycle', 'assign_sequence', 'assign_email_copy') DEFAULT 'assign_owner';

-- 28/11/2017
-- version: 1.2.2
ALTER TABLE `plugin_leads_registration_log` MODIFY COLUMN `last_name` VARCHAR(255) COLLATE utf8_unicode_ci DEFAULT NULL;
ALTER TABLE `plugin_leads_registration_log` MODIFY COLUMN `mobile` VARCHAR(255) COLLATE utf8_unicode_ci DEFAULT NULL;

-- 16/11/2017
-- version: 1.2.3
ALTER TABLE `plugin_leads_event_rules_actions` MODIFY COLUMN `action_type` ENUM ('assign_owner', 'assign_task', 'assign_tags', 'assign_lifecycle', 'assign_sequence', 'assign_email_copy') DEFAULT 'assign_owner';

-- 09/11/2017
-- version: 1.2.4
CREATE TABLE IF NOT EXISTS `plugin_leads_builder_form_general_config` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `form_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `form_type` enum('internal','external') COLLATE utf8_unicode_ci DEFAULT 'internal',
  `form_title` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `form_domain` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `form_button_label` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `form_code` MEDIUMTEXT COLLATE utf8_unicode_ci,
  `form_signature` char(40) COLLATE utf8_unicode_ci NOT NULL,
  `recaptcha_public_key` VARCHAR(255) DEFAULT NULL,
  `recaptcha_private_key` VARCHAR(255) DEFAULT NULL,
  `success_url` VARCHAR(255) DEFAULT NULL,
  `fail_url` VARCHAR(255) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `creator_id` int(10) unsigned DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `editor_id` int(10) unsigned DEFAULT NULL,
  `send_email` ENUM('0', '1') DEFAULT '0',
  `send_auto_reply` ENUM('0', '1') DEFAULT '0',
  `send_email_config` MEDIUMTEXT COLLATE utf8_unicode_ci DEFAULT NULL,
  `send_auto_reply_config` MEDIUMTEXT COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `form_name` (`form_name`),
  KEY `creator_id` (`creator_id`),
  KEY `editor_id` (`editor_id`),
  CONSTRAINT `plugin_leads_builder_form_general_config_ibfk_1` FOREIGN KEY (`creator_id`) REFERENCES `user` (`id`) ON DELETE SET NULL ON UPDATE NO ACTION,
  CONSTRAINT `plugin_leads_builder_form_general_config_ibfk_2` FOREIGN KEY (`editor_id`) REFERENCES `user` (`id`) ON DELETE SET NULL ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_builder_form_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` int(10) unsigned NOT NULL,
  `field_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `field_label` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `field_value` mediumtext COLLATE utf8_unicode_ci DEFAULT NULL,
  `field_data` text COLLATE utf8_unicode_ci NOT NULL,
  `field_type` VARCHAR (255) COLLATE utf8_unicode_ci NOT NULL,
  `system_type` VARCHAR (255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `form_id` (`form_id`),
  CONSTRAINT `plugin_leads_builder_form_fields_ibfk_1` FOREIGN KEY (`form_id`) REFERENCES `plugin_leads_builder_form_general_config` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

ALTER TABLE `plugin_leads_form_log` ADD COLUMN `form_type` ENUM('internal', 'external') DEFAULT 'internal';

-- 22/01/2018
-- version: 1.2.5
ALTER TABLE `plugin_leads_data` CHANGE `suffix` `prefix` VARCHAR (255) COLLATE utf8_unicode_ci DEFAULT NULL;

-- 18/01/2018
-- version: 1.2.6
ALTER TABLE `plugin_leads_quote_log` MODIFY COLUMN `status` ENUM('new','sent','sold','lost', 'deleted') DEFAULT 'new';
ALTER TABLE `plugin_leads_quote_log` MODIFY COLUMN `quote_action_type` ENUM('view', 'change', 'deleted') DEFAULT 'change' NOT NULL;
ALTER TABLE `plugin_leads_quote_log` ADD COLUMN `is_deleted` ENUM('0', '1') DEFAULT '0';
ALTER TABLE `plugin_leads_quote_log` ADD COLUMN `deleted_by` int(10) unsigned DEFAULT NULL;

-- 27/11/2017
-- version: 1.2.7
ALTER TABLE `plugin_leads_data` ADD COLUMN `last_activity_outbound` TIMESTAMP NULL DEFAULT '0000-00-00 00:00:00';

UPDATE `plugin_leads_data` SET `last_activity_outbound` = `last_activity` WHERE `last_activity_type_id` IN(SELECT `id` FROM `plugin_leads_type` WHERE `type_name` IN(
'outbound_email',
'outbound_call',
'outbound_quote',
'outbound_meeting',
'outbound_task',
'outbound_opened',
'outbound_openattachment',
'opened',
'openattachment'));

-- 30/01/2018
-- version: 1.2.8
ALTER TABLE `plugin_leads_tasks` ADD COLUMN `is_task_completed` ENUM('0', '1') DEFAULT '0';
ALTER TABLE `plugin_leads_tasks` ADD COLUMN `task_completed_by` INT(10) UNSIGNED DEFAULT NULL;
ALTER TABLE `plugin_leads_tasks` ADD COLUMN `completion_comment` TEXT COLLATE utf8_unicode_ci DEFAULT NULL;
ALTER TABLE `plugin_leads_tasks` MODIFY `expired_at` TIMESTAMP NULL;
ALTER TABLE `plugin_leads_tasks_log` MODIFY `expired_at` TIMESTAMP NULL;
ALTER TABLE `plugin_leads_tasks_log` ADD COLUMN `is_task_completed` ENUM('0', '1') DEFAULT '0';
ALTER TABLE `plugin_leads_tasks_log` ADD COLUMN `task_completed_by` INT(10) UNSIGNED DEFAULT NULL;
ALTER TABLE `plugin_leads_tasks_log` ADD COLUMN `completion_comment` TEXT COLLATE utf8_unicode_ci DEFAULT NULL;

INSERT IGNORE INTO `email_triggers` (`enabled`, `trigger_name`, `observer`) VALUES
('1', 'leads_taskcompleted', 'Tools_LeadsMailWatchdog'),
('1', 'leads_taskreopened', 'Tools_LeadsMailWatchdog');

-- 27/02/2018
-- version: 1.2.9
UPDATE `plugin` SET `tags`='crm,hiddenemail,emaillog' WHERE `name` = 'leads';

-- 07/03/2018
-- version: 1.3.0
UPDATE `plugin_leads_tasks` SET `is_task_completed` = '0' WHERE `is_task_completed` IS NULL;
UPDATE `plugin_leads_tasks_log` SET `is_task_completed` = '0' WHERE `is_task_completed` IS NULL;

-- 23/01/2018
-- version: 1.3.1
ALTER TABLE `plugin_leads_email_log` ADD COLUMN `email_from_name` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL AFTER `email_from`;
ALTER TABLE `plugin_leads_email_log` ADD COLUMN `email_source_type` ENUM('internal', 'external') DEFAULT 'internal' NOT NULL;
ALTER TABLE `plugin_leads_email_log` ADD COLUMN `external_source_name` VARCHAR(255) COLLATE utf8_unicode_ci DEFAULT NULL;
ALTER TABLE `plugin_leads_email_log` ADD COLUMN `campaign_name` VARCHAR(255) COLLATE utf8_unicode_ci DEFAULT NULL;
ALTER TABLE `plugin_leads_email_log` ADD COLUMN `list_names` TEXT COLLATE utf8_unicode_ci DEFAULT NULL;
ALTER TABLE `plugin_leads_email_link_attachment_log` ADD COLUMN `source_type` ENUM('internal', 'external') DEFAULT 'internal' NOT NULL;

-- 14/05/2018
-- version: 1.3.2
UPDATE `plugin` SET `tags`='crm,hiddenemail,emaillog,userdelete' WHERE `name` = 'leads';
ALTER TABLE `plugin_leads_tasks` MODIFY `user_id` INT(10) UNSIGNED DEFAULT NULL;
ALTER TABLE `plugin_leads_tasks` DROP FOREIGN KEY `plugin_leads_tasks_ibfk_1`;
ALTER TABLE `plugin_leads_tasks` ADD CONSTRAINT `fk_plugin_leads_tasks_user_id` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE SET NULL ON UPDATE NO ACTION;
ALTER TABLE `plugin_leads_tasks` MODIFY `creator_id` INT(10) UNSIGNED DEFAULT NULL;
ALTER TABLE `plugin_leads_tasks` DROP FOREIGN KEY `plugin_leads_tasks_ibfk_2`;
ALTER TABLE `plugin_leads_tasks` ADD CONSTRAINT `fk_plugin_leads_tasks_creator_id` FOREIGN KEY (`creator_id`) REFERENCES `user` (`id`) ON DELETE SET NULL ON UPDATE NO ACTION;
ALTER TABLE `plugin_leads_tasks` DROP FOREIGN KEY `plugin_leads_tasks_ibfk_3`;
ALTER TABLE `plugin_leads_tasks` ADD CONSTRAINT `fk_plugin_leads_tasks_lead_id` FOREIGN KEY (`lead_id`) REFERENCES `plugin_leads_data` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION;

-- 17/05/2018
-- version: 1.3.3
ALTER TABLE `plugin_leads_quote_log` ADD COLUMN `force_display` ENUM('0', '1') DEFAULT '0';

-- 17/05/2018
-- version: 1.3.4
ALTER TABLE `plugin_leads_email_log` ADD COLUMN `creator_id` INT(10) UNSIGNED DEFAULT NULL;

-- 21/05/2018
-- version: 1.3.5
ALTER TABLE `plugin_leads_call_log` MODIFY `receiver` VARCHAR(255) COLLATE utf8_unicode_ci DEFAULT NULL;
ALTER TABLE `plugin_leads_call_log` ADD COLUMN `is_voip` ENUM('0', '1') DEFAULT '0';

-- 30/05/2018
-- version: 1.3.6
ALTER TABLE `plugin_leads_form_rules_config` MODIFY COLUMN `rule_comparison_operator` ENUM('equal', 'notequal', 'like', 'in', 'greaterthan', 'lessthan') DEFAULT 'equal';
ALTER TABLE `plugin_leads_event_rules_config` MODIFY COLUMN `rule_comparison_operator` ENUM('equal', 'notequal', 'like', 'in', 'greaterthan', 'lessthan') DEFAULT 'equal';

-- 15/06/2018
-- version: 1.3.7
INSERT IGNORE INTO `email_triggers` (`enabled`, `trigger_name`, `observer`) VALUES
('1', 'leads_taskcreated', 'Tools_LeadsMailWatchdog');

-- 10/07/2018
-- version: 1.3.8
INSERT IGNORE INTO `plugin_leads_type`  (`type_name`, `type_label`, `system`) VALUES
('inbound_chat', 'Inbound chat', '1');
UPDATE `plugin_leads_action_log` SET  `type` = 'chat', `lead_type` = 'inbound_chat'   WHERE `additional_content` LIKE '%' 'shortDescription":"olark chat", "fullDescription"' '%';

-- 05/07/2018
-- version: 1.3.9
ALTER TABLE `plugin_leads_stage` ADD COLUMN `default` ENUM('0', '1') DEFAULT '0';

-- 25/05/2018
-- version: 1.4.0
ALTER TABLE `plugin_leads_email_log` ADD COLUMN `message_id` TEXT COLLATE utf8_unicode_ci DEFAULT NULL;
ALTER TABLE `plugin_leads_email_log` ADD COLUMN `reply_id` TEXT COLLATE utf8_unicode_ci DEFAULT NULL;
ALTER TABLE `plugin_leads_email_log` ADD COLUMN `references` TEXT COLLATE utf8_unicode_ci DEFAULT NULL;
ALTER TABLE `plugin_leads_email_log` ADD COLUMN `uid` INT(10) UNSIGNED DEFAULT NULL;
ALTER TABLE `plugin_leads_email_log` ADD COLUMN `message_number` INT(10) UNSIGNED DEFAULT NULL;
ALTER TABLE `plugin_leads_email_log` ADD COLUMN `account_id` INT(10) UNSIGNED DEFAULT NULL;
ALTER TABLE `plugin_leads_email_log` ADD COLUMN `received_at` TIMESTAMP NULL;
ALTER TABLE `plugin_leads_email_log` ADD COLUMN `encoded_content` BLOB;

CREATE TABLE IF NOT EXISTS `plugin_leads_imap_config` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `service_name` VARCHAR (255) COLLATE utf8_unicode_ci NOT NULL,
  `owner_id` int(10) unsigned DEFAULT NULL,
  `host` VARCHAR (255) COLLATE utf8_unicode_ci NOT NULL,
  `encryption` ENUM('none', 'tls', 'ssl') NOT NULL DEFAULT 'none',
  `login` VARCHAR (255) COLLATE utf8_unicode_ci NOT NULL,
  `password` BLOB NOT NULL,
  `initial_data_processed` ENUM('0', '1') DEFAULT '0',
  `last_processed_date` TIMESTAMP NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

ALTER TABLE `plugin_leads_email_log` MODIFY `email_status` ENUM('sent', 'opened', 'openattachment', 'received');

CREATE TABLE IF NOT EXISTS `plugin_leads_additional_email_log` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `email_subject` VARCHAR (255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `content` TEXT DEFAULT NULL,
  `encoded_content` BLOB,
  `email_from` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL,
  `email_from_name` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL,
  `email_to` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL,
  `email_bcc` VARCHAR (255) COLLATE utf8_unicode_ci NOT NULL,
  `lead_id` INT(10) UNSIGNED NOT NULL,
  `email_status` ENUM('sent', 'opened', 'openattachment', 'received'),
  `email_source_type` ENUM('internal', 'external') DEFAULT 'internal' NOT NULL,
  `external_source_name` VARCHAR(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `message_id` TEXT COLLATE utf8_unicode_ci DEFAULT NULL,
  `reply_id` TEXT COLLATE utf8_unicode_ci DEFAULT NULL,
  `references` TEXT COLLATE utf8_unicode_ci DEFAULT NULL,
  `uid` INT(10) UNSIGNED DEFAULT NULL,
  `message_number` INT(10) UNSIGNED DEFAULT NULL,
  `account_id` INT(10) UNSIGNED DEFAULT NULL,
  `received_at` TIMESTAMP NULL,
  PRIMARY KEY(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 26/07/2018
-- version: 1.4.1
ALTER TABLE `plugin_leads_imap_config` ADD COLUMN `process_all_emails` ENUM('0', '1') DEFAULT '0';
ALTER TABLE `plugin_leads_additional_email_log` MODIFY `message_id` VARCHAR(998) COLLATE utf8_unicode_ci DEFAULT NULL;
ALTER TABLE `plugin_leads_additional_email_log` ADD INDEX (`message_id`);

-- 16/07/2018
-- version: 1.4.2
ALTER TABLE `plugin_leads_data` ADD COLUMN `score` INT(10) UNSIGNED DEFAULT NULL;
ALTER TABLE `plugin_leads_data` ADD COLUMN `score_processed_at` TIMESTAMP NULL;

CREATE TABLE IF NOT EXISTS `plugin_leads_score_rules_general_config` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `rule_name` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL,
  `created_at` TIMESTAMP NOT NULL,
  `creator_id` INT(10) UNSIGNED DEFAULT NULL,
  `updated_at` TIMESTAMP NOT NULL,
  `editor_id` INT(10) UNSIGNED DEFAULT NULL,
  `score` INT(10) UNSIGNED NOT NULL,
  `score_sign` ENUM('+', '-') DEFAULT '+',
  PRIMARY KEY(`id`),
  FOREIGN KEY (`creator_id`) REFERENCES `user` (`id`) ON DELETE SET NULL ON UPDATE NO ACTION,
  FOREIGN KEY (`editor_id`) REFERENCES `user` (`id`) ON DELETE SET NULL ON UPDATE NO ACTION,
  UNIQUE (`rule_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_score_rules_config` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `rule_id` INT(10) UNSIGNED NOT NULL,
  `rule_type` ENUM('lead_attribute', 'organization_attribute', 'action_type', 'lead_opportunities', 'lead_custom_attributes', 'organization_custom_attributes') DEFAULT 'lead_attribute',
  `rule_subtype` VARCHAR(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `field_name` VARCHAR (255) COLLATE utf8_unicode_ci NOT NULL,
  `rule_comparison_operator` ENUM('equal', 'notequal', 'like', 'in', 'greaterthan', 'lessthan', 'notin') DEFAULT 'equal',
  `field_value` MEDIUMTEXT COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY(`id`),
  FOREIGN KEY (`rule_id`) REFERENCES `plugin_leads_score_rules_general_config` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_score_rules_log` (
`lead_id` INT(10) UNSIGNED NOT NULL,
`rule_id` INT(10) UNSIGNED NOT NULL,
PRIMARY KEY(`lead_id`, `rule_id`),
FOREIGN KEY (`lead_id`) REFERENCES `plugin_leads_data`(`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 17/09/2018
-- version: 1.4.3
ALTER TABLE `plugin_leads_imap_config` ADD COLUMN `notification_sent` TIMESTAMP NULL;
INSERT IGNORE INTO `email_triggers` (`enabled`, `trigger_name`, `observer`) VALUES
('1', 'leads_imapcredentialsnotification', 'Tools_LeadsMailWatchdog');

-- 25/10/2018
-- version: 1.4.4
ALTER TABLE `plugin_leads_data` ADD COLUMN `remote_authorization_token` CHAR(40) DEFAULT NULL;

-- 27/12/2018
-- version: 1.4.5
ALTER TABLE `plugin_leads_notes` CHANGE `date_created` `date_created` timestamp NOT NULL AFTER `lead_id`;

-- 12/03/2019
-- version: 1.4.6
CREATE TABLE IF NOT EXISTS `plugin_leads_documents` (
 `id` INT(10) unsigned AUTO_INCREMENT,
 `lead_id` INT(10) UNSIGNED NOT NULL,
 `file_stored_name` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL COMMENT 'Stored file name',
 `file_hash` CHAR(40) NOT NULL COMMENT 'Hash for download link',
 `original_file_name` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL COMMENT 'Original file name',
 `display_file_name` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL COMMENT 'Display file name',
 `uploaded_at` TIMESTAMP NOT NULL COMMENT 'Upload date',
   PRIMARY KEY (`id`),
   UNIQUE(`file_hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 15/05/2019
-- version: 1.4.7
INSERT IGNORE INTO `plugin_crm_checklist` (`checklist_status`, `closed_by`, `checklist_name`) VALUES
('0', NULL, 'imap_service');

-- 13/06/2019
-- version: 1.4.8
ALTER TABLE `plugin_leads_form_rules_actions` MODIFY COLUMN `action_type` ENUM ('assign_owner', 'assign_task', 'assign_tags', 'assign_lifecycle', 'assign_sequence', 'assign_email_list', 'assign_email_copy') DEFAULT 'assign_owner';
ALTER TABLE `plugin_leads_event_rules_actions` MODIFY COLUMN `action_type` ENUM ('assign_owner', 'assign_task', 'assign_tags', 'assign_lifecycle', 'assign_sequence', 'assign_email_list', 'assign_email_copy') DEFAULT 'assign_owner';

-- 31/07/2019
-- version: 1.4.9
CREATE TABLE IF NOT EXISTS `plugin_leads_custom_tabs_config` (
`id` INT(10) unsigned AUTO_INCREMENT,
`tab_name` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL COMMENT 'Crm tab name',
`tab_label` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL COMMENT 'Crm tab label',
`tab_type` ENUM('lead', 'organization') DEFAULT 'lead',
PRIMARY KEY(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_custom_tabs_has_custom_params` (
`tab_id` INT(10) UNSIGNED NOT NULL,
`custom_param_id` INT(10) UNSIGNED NOT NULL,
PRIMARY KEY (`tab_id`, `custom_param_id`),
FOREIGN KEY(`tab_id`) REFERENCES `plugin_leads_custom_tabs_config` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 27/06/2019
-- version: 1.5.0
ALTER TABLE `plugin_leads_builder_form_general_config` ADD COLUMN `sms_mobile` VARCHAR(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Mobile numbers for sms';

-- 27/08/2019
-- version: 1.5.1
CREATE TABLE IF NOT EXISTS `plugin_leads_workflow_general_config` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `rule_name` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL,
  `created_at` TIMESTAMP NOT NULL,
  `creator_id` INT(10) UNSIGNED DEFAULT NULL,
  `updated_at` TIMESTAMP NOT NULL,
  `editor_id` INT(10) UNSIGNED DEFAULT NULL,
  `score` INT(10) UNSIGNED NOT NULL,
  `score_comparison_operator` ENUM('equal', 'greaterthan', 'lessthan') DEFAULT 'equal',
  PRIMARY KEY(`id`),
  FOREIGN KEY (`creator_id`) REFERENCES `user` (`id`) ON DELETE SET NULL ON UPDATE NO ACTION,
  FOREIGN KEY (`editor_id`) REFERENCES `user` (`id`) ON DELETE SET NULL ON UPDATE NO ACTION,
  UNIQUE (`rule_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_workflow_config` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `rule_id` INT(10) UNSIGNED NOT NULL,
  `rule_type` ENUM('lead_attribute', 'organization_attribute', 'action_type', 'lead_opportunities', 'lead_custom_attributes', 'organization_custom_attributes') DEFAULT 'lead_attribute',
  `rule_subtype` VARCHAR(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `field_name` VARCHAR (255) COLLATE utf8_unicode_ci NOT NULL,
  `rule_comparison_operator` ENUM('equal', 'notequal', 'like', 'in', 'greaterthan', 'lessthan', 'notin') DEFAULT 'equal',
  `field_value` MEDIUMTEXT COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY(`id`),
  FOREIGN KEY (`rule_id`) REFERENCES `plugin_leads_workflow_general_config` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


CREATE TABLE IF NOT EXISTS `plugin_leads_workflow_actions` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `rule_id` INT(10) UNSIGNED NOT NULL,
  `action_type` ENUM ('assign_owner', 'assign_task', 'assign_tags', 'assign_lifecycle', 'assign_sequence', 'assign_email_list', 'assign_email_copy') DEFAULT 'assign_owner',
  `action_config` TEXT COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY(`id`),
  UNIQUE(`rule_id`, `action_type`),
  FOREIGN KEY (`rule_id`) REFERENCES `plugin_leads_workflow_general_config` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_workflow_rules_log` (
`lead_id` INT(10) UNSIGNED NOT NULL,
`rule_id` INT(10) UNSIGNED NOT NULL,
PRIMARY KEY(`lead_id`, `rule_id`),
FOREIGN KEY (`lead_id`) REFERENCES `plugin_leads_data`(`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 03/10/2019
-- version: 1.5.2
ALTER TABLE `plugin_leads_data` ADD COLUMN `lead_secondary_email` VARCHAR(255) COLLATE utf8_unicode_ci DEFAULT NULL;

-- 27/08/2019
-- version: 1.5.3
CREATE TABLE IF NOT EXISTS `plugin_leads_users_api_access` (
`id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
`user_id` INT(10) UNSIGNED NOT NULL,
`ip_addresses` TEXT COLLATE utf8_unicode_ci NOT NULL,
PRIMARY KEY(`id`),
FOREIGN KEY (`user_id`) REFERENCES `user`(`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_users_api_tokens` (
`api_user_id` INT(10) UNSIGNED NOT NULL,
`token` CHAR (255) COLLATE utf8_unicode_ci NOT NULL,
`expiration_date` TIMESTAMP NOT NULL,
`creation_date` TIMESTAMP NOT NULL,
`ip_address` VARCHAR(45) NOT NULL,
PRIMARY KEY (`api_user_id`, `token`),
UNIQUE (`token`),
FOREIGN KEY (`api_user_id`) REFERENCES `plugin_leads_users_api_access`(`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_api_access_list` (
`api_user_id` INT(10) UNSIGNED NOT NULL,
`resource` VARCHAR (255) COLLATE utf8_unicode_ci NOT NULL,
PRIMARY KEY(`api_user_id`, `resource`),
FOREIGN KEY (`api_user_id`) REFERENCES `plugin_leads_users_api_access`(`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_api_request_log` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `token` CHAR (255) COLLATE utf8_unicode_ci NOT NULL,
  `request` TEXT COLLATE utf8_unicode_ci NOT NULL,
  `endpoint` VARCHAR (255) COLLATE utf8_unicode_ci NOT NULL,
  `request_type` VARCHAR (10) COLLATE utf8_unicode_ci NOT NULL,
  `api_user_id` INT(10) UNSIGNED NOT NULL,
  `created_at` TIMESTAMP NOT NULL,
  `ip_address` VARCHAR(45) NOT NULL,
  PRIMARY KEY(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

ALTER TABLE `plugin_leads_data` MODIFY COLUMN `creation_type` ENUM('local', 'import', 'user', 'api') DEFAULT 'local';

-- 19/09/2019
-- version: 1.5.4
ALTER TABLE `plugin_leads_lead_custom_params_config` MODIFY COLUMN `param_type` ENUM('text', 'date', 'input', 'checkbox', 'select', 'radio') DEFAULT 'input';
ALTER TABLE `plugin_leads_organization_custom_params_config` MODIFY COLUMN `param_type` ENUM('text', 'date', 'input', 'checkbox', 'select', 'radio') DEFAULT 'input';

-- 27/06/2019
-- version: 1.5.5
ALTER TABLE `plugin_leads_builder_form_general_config` ADD COLUMN `external_id` VARCHAR(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'External id';

-- 16/06/2019
-- version: 1.5.6
ALTER TABLE `plugin_leads_email_log` MODIFY `email_status` ENUM('sent', 'opened', 'openattachment', 'received', 'bounce', 'deferred', 'dropped', 'unsubscribed');

-- 23/12/2019
-- version: 1.5.7
CREATE TABLE IF NOT EXISTS `plugin_leads_organization_documents` (
 `id` INT(10) unsigned AUTO_INCREMENT,
 `organization_id` INT(10) UNSIGNED NOT NULL,
 `file_stored_name` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL COMMENT 'Stored file name',
 `file_hash` CHAR(40) NOT NULL COMMENT 'Hash for download link',
 `original_file_name` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL COMMENT 'Original file name',
 `display_file_name` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL COMMENT 'Display file name',
 `uploaded_at` TIMESTAMP NOT NULL COMMENT 'Upload date',
   PRIMARY KEY (`id`),
   FOREIGN KEY (`organization_id`) REFERENCES `plugin_lead_organization`(`id`) ON DELETE CASCADE ON UPDATE NO ACTION,
   UNIQUE(`file_hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 30/12/2019
-- version: 1.5.8
ALTER TABLE `plugin_lead_organization` ADD COLUMN `organization_domain1` VARCHAR (64) COLLATE utf8_unicode_ci DEFAULT NULL AFTER `organization_domain`;
ALTER TABLE `plugin_lead_organization` ADD COLUMN `organization_website1` VARCHAR (255) COLLATE utf8_unicode_ci DEFAULT NULL AFTER `organization_website`;

-- 10/03/2019
-- version: 1.5.9
UPDATE `plugin_leads_call_log` SET `type` = 'call' WHERE `type` = '';
INSERT IGNORE INTO `plugin_leads_type`  (`type_name`, `type_label`, `system`) VALUES
('inbound_sms', 'Inbound sms', '1'),
('outbound_sms', 'Outbound sms', '1');

-- 20/11/2019
-- version: 1.6.0
CREATE TABLE IF NOT EXISTS `plugin_leads_review_request` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `review_token` CHAR (40) COLLATE utf8_unicode_ci NOT NULL,
  `lead_id` INT(10) UNSIGNED NOT NULL,
  `status` ENUM('sent', 'reviewed') DEFAULT 'sent',
  `review_status` ENUM('sent', 'reviewed') DEFAULT NULL,
  `score` TINYINT DEFAULT '0' NOT NULL,
  `sent_at` TIMESTAMP NOT NULL,
  `reviewed_at` TIMESTAMP NOT NULL,
  `review_request_sent_at` TIMESTAMP NOT NULL,
  `request_reviewed_facebook_date` TIMESTAMP NOT NULL,
  `request_reviewed_gmb_date` TIMESTAMP NOT NULL,
  PRIMARY KEY(`id`),
  UNIQUE(`review_token`),
  FOREIGN KEY (`lead_id`) REFERENCES `plugin_leads_data`(`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT IGNORE INTO `email_triggers` (`enabled`, `trigger_name`, `observer`) VALUES
('1', 'leads_reviewrequest', 'Tools_LeadsMailWatchdog'),
('1', 'leads_npsreviewrequest', 'Tools_LeadsMailWatchdog');

-- 20/11/2020
-- version: 1.6.1
ALTER TABLE `plugin_leads_workflow_actions` MODIFY COLUMN `action_type` ENUM ('assign_owner', 'assign_task', 'assign_tags', 'assign_lifecycle', 'assign_sequence', 'assign_email_list', 'assign_email_copy', 'send_review_request') DEFAULT 'assign_owner';
INSERT IGNORE INTO `plugin_leads_workflow_general_config` (`id`, `rule_name`, `created_at`, `creator_id`, `updated_at`, `editor_id`, `score`, `score_comparison_operator`) VALUES
(10000,	'Review request',	'2020-04-06 00:00:00',	1,	'2020-04-06 00:00:00',	1,	0,	'equal');
INSERT IGNORE INTO `plugin_leads_workflow_config` (`id`, `rule_id`, `rule_type`, `rule_subtype`, `field_name`, `rule_comparison_operator`, `field_value`) VALUES
(10000,	10000,	'lead_attribute',	'',	'nps_review_score',	'greaterthan',	'9');
INSERT IGNORE INTO `plugin_leads_workflow_actions` (`id`, `rule_id`, `action_type`, `action_config`) VALUES
(10000,	10000,	'send_review_request',	'{\"sendReviewRequest\":\"1\"}');

INSERT IGNORE INTO `template` (`name`, `content`, `type`) VALUES
('NPS leave review system',	'<!DOCTYPE html>\n<html xmlns:v=\"urn:schemas-microsoft-com:vml\">\n<head>\n    <meta charset=\"UTF-8\">\n    <style type=\"”text/css”\">\n        v\\:* { behavior: url(#default#VML); display:inline-block}\n    </style>\n</head>\n<body>\n<style>\n    body{\n        margin: 0;\n        padding: 0 ;\n        background-color:#f8f8f8 ;\n    }\n    p{\n        margin : 5px 0;\n        line-height: 1.7em;\n    }\n    ul{\n        padding : 0 0 0 20px;\n        color: #83B21F;\n    }\n    ul li{\n        margin-bottom : 5px;\n    }\n    a{\n        margin : 0 0 5px;\n        color: #83B21F;\n    }\n    img{\n        border-style: none;\n    }\n    hr{\n        height: 1px;\n        background: #F4F4F4;\n        border: none;\n    }\n</style>\n<table cellpadding=\"0\" cellspacing=\"0\" bgcolor=\"#f8f8f8\" width=\"100%\" style=\" margin: 0; padding: 0 ; background-color:#f8f8f8 ; height : 100%;\">\n    <tr>\n        <td>&nbsp;</td>\n        <td style=\"width: 600px;\">\n            <table style=\"font-family: Arial, Helvetica, sans-serif; background: #ffffff; width: 600px; color: #7c7c7c; font-size: 14px; text-align: left; margin: 15px 0;\" border=\"0\" width=\"600px\" cellspacing=\"0\" cellpadding=\"0\" align=\"center\">\n                <!-- Header -->\n                <thead>\n                <tr>\n                    <td style=\"padding: 20px;\">\n            			<a target=\"_blank\" href=\"{$website:url}\">\n            				<img src=\"{$plugin:widcard:bizLogo:url}\" alt=\"{$plugin:widcard:BizOrgName:notag}\" height=\"75\" style=\"vertical-align:middle;\">\n            			</a>\n            		</td>\n            		<td style=\"text-align: center;\">\n            		<a style=\"text-decoration:none;\" rel=\"noopener\" target=\"_blank\" href=\"{$plugin:widcard:BizFbAccount:notag}\">\n            		    <img src=\"{$website:url}system/images/w-facebook.png\" alt=\"facebook\" />\n            		</a>\n            		<a style=\"text-decoration:none;\" rel=\"noopener\" target=\"_blank\" href=\"{$plugin:widcard:BizGmbusiness:notag}\">\n            		    <img src=\"{$website:url}system/images/w-gmb.png\" alt=\"GMB\" />\n            		</a> \n            		<a style=\"text-decoration:none;\" rel=\"noopener\" target=\"_blank\" href=\"{$plugin:widcard:BizTwitterAccount:notag}\">\n            		    <img src=\"{$website:url}system/images/w-twitter.png\" alt=\"twitter\" />\n            		</a> \n            		<a style=\"text-decoration:none;\" rel=\"noopener\" target=\"_blank\" href=\"{$plugin:widcard:bizLinkedInAccount:notag}\">\n            		    <img src=\"{$website:url}system/images/w-linkedin.png\" alt=\"linkedin\" />\n            		</a>\n            		</td>\n                </tr>\n                <tr style=\"background: #f8f8f8;\">\n                    <td> </td>\n                    <td> </td>\n                </tr>\n                </thead> \n                <!-- Content -->\n                <tbody>\n                <tr>\n                    <td style=\"padding: 25px; font-size: 16px;\" colspan=\"2\">\n                        <p style=\"font-size:24px; font-weight:bold; color:#000000; text-align:center;\">Hello {$lead:firstname} {$lead:lastname},</p><br/>\n                        {$content:email_text}\n                        {emailmessage}\n                         <table border=\"0\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\">\n                             <tr valign=\"top\">\n                                <td align=\"right\">\n                                    <a style=\"display:inline-block; background-color:#23589B; color: #fff; text-decoration: none; margin: 10px; font-size:0;\" href=\"{$widcard:param:facebook:readonly}\"><img src=\"{$website:url}system/images/fb-btn.jpg\" alt=\"facebook\" height=\"30px\" /></a>\n                                </td>\n                                <td>\n                                    <a style=\"display:inline-block; background-color:#4881E8; color: #fff; text-decoration: none; margin: 10px; font-size:0;\" href=\"{$widcard:param:google my business:readonly}\"><img  style=\"vertical-align: middle;\" src=\"{$website:url}system/images/gmb-btn.jpg\" alt=\"GMB\" height=\"30px\" /></a>\n                                </td>\n                             </tr>\n                         </table>\n                        <br/><br/>\n                    </td>\n                </tr>\n                </tbody>\n                <!-- Footer -->\n                <tfoot>\n                <tr>\n            		<td align=\"center\" bgcolor=\"#7c7c7c\" style=\"padding: 25px 25px 25px 25px; color: #ffffff; font-family: Arial, sans-serif; font-size: 12px; line-height: 20px;\"  colspan=\"2\">\n            			<address>\n            				<font color=\"#FFFFFF\">{$plugin:widcard:BizOrgName:notag} | {$plugin:widcard:BizAddress1:notag}, {$plugin:widcard:BizCity:notag}, {$plugin:widcard:BizState:notag} {$plugin:widcard:BizZip:notag} | Tel : <a style=\"color: #FFFFFF;\" href=\"tel:{$plugin:widcard:BizTelephone:notag}\">{$plugin:widcard:BizTelephone:notag}</a></address>\n            		</td>\n            	</tr>\n                </tfoot>\n                <!-- end Footer -->\n            </table>\n        </td>\n        <td>&nbsp;</td>\n    </tr>\n</table>\n</body>\n</html>',	'typemail'),
('NPS request system',	'<!DOCTYPE html>\n<html xmlns:v=\"urn:schemas-microsoft-com:vml\">\n<head>\n    <meta charset=\"UTF-8\">\n    <style type=\"”text/css”\">\n        v\\:* { behavior: url(#default#VML); display:inline-block}\n    </style>\n</head>\n<body>\n<style>\n    body{\n        margin: 0;\n        padding: 0 ;\n        background-color:#f8f8f8 ;\n    }\n    p{\n        margin : 5px 0;\n        line-height: 1.7em;\n    }\n    ul{\n        padding : 0 0 0 20px;\n        color: #83B21F;\n    }\n    ul li{\n        margin-bottom : 5px;\n    }\n    a{\n        margin : 0 0 5px;\n        color: #83B21F;\n    }\n    img{\n        border-style: none;\n    }\n    hr{\n        height: 1px;\n        background: #F4F4F4;\n        border: none;\n    }\n</style>\n<table cellpadding=\"0\" cellspacing=\"0\" bgcolor=\"#f8f8f8\" width=\"100%\" style=\" margin: 0; padding: 0 ; background-color:#f8f8f8 ; height : 100%;\">\n    <tr>\n        <td>&nbsp;</td>\n        <td style=\"width: 600px;\">\n            <table style=\"font-family: Arial, Helvetica, sans-serif; background: #ffffff; width: 600px; color: #7c7c7c; font-size: 14px; text-align: left; margin: 15px 0;\" border=\"0\" width=\"600px\" cellspacing=\"0\" cellpadding=\"0\" align=\"center\">\n                <!-- Header -->\n                <thead>\n                <tr>\n                    <td style=\"padding: 20px;\">\n            			<a target=\"_blank\" href=\"{$website:url}\">\n            				<img src=\"{$plugin:widcard:bizLogo:url}\" alt=\"{$plugin:widcard:BizOrgName:notag}\" height=\"75\" style=\"vertical-align:middle;\">\n            			</a>\n            		</td>\n            		<td style=\"text-align: center;\">\n            		<a style=\"text-decoration:none;\" rel=\"noopener\" target=\"_blank\" href=\"{$plugin:widcard:BizFbAccount:notag}\">\n            		    <img src=\"{$website:url}system/images/w-facebook.png\" alt=\"facebook\" />\n            		</a>\n            		<a style=\"text-decoration:none;\" rel=\"noopener\" target=\"_blank\" href=\"{$plugin:widcard:BizGmbusiness:notag}\">\n            		    <img src=\"{$website:url}system/images/w-gmb.png\" alt=\"GMB\" />\n            		</a> \n            		<a style=\"text-decoration:none;\" rel=\"noopener\" target=\"_blank\" href=\"{$plugin:widcard:BizTwitterAccount:notag}\">\n            		    <img src=\"{$website:url}system/images/w-twitter.png\" alt=\"twitter\" />\n            		</a> \n            		<a style=\"text-decoration:none;\" rel=\"noopener\" target=\"_blank\" href=\"{$plugin:widcard:bizLinkedInAccount:notag}\">\n            		    <img src=\"{$website:url}system/images/w-linkedin.png\" alt=\"linkedin\" />\n            		</a>\n            		</td>\n                </tr>\n                <tr style=\"background: #f8f8f8;\">\n                    <td> </td>\n                    <td> </td>\n                </tr>\n                </thead> \n                <!-- Content -->\n                <tbody>\n                <tr>\n                    <td style=\"padding: 25px; font-size: 16px;\" colspan=\"2\">\n                        <h1 style=\"font-size: 32px; text-align: center; margin-bottom:0; color:#000000;\">Hello, {$lead:firstname}!</h1>\n                        <p style=\"font-size: 32px; text-align: center; color:#000000;\">Help us to improve our services</p>\n                        <br/>\n                        <p style=\"text-align: center; font-weight:bold;\">\n                            How likely is it that you would recommend<br/>\n                            {$plugin:widcard:BizOrgName:notag} to a friend or collegue?\n                        </p>\n                        <br/><br/>\n                        <table cellpadding=\"0\" cellspacing=\"0\"  width=\"100%\" border=\"0\" align=\"center\" >\n                        <tr>\n                            <td width=\"9%\" bgcolor=\"#FE0000\" style=\"height:38px; text-align:center;; border:1px solid #ffffff;\"><a style=\"display: block; width: 100%; margin:0; padding:0;  text-decoration: none; color: #ffffff; font-weight: bold\" href=\"{$lead:npsreviewrequest:0}\">0</a></td>\n                            <td width=\"9%\" bgcolor=\"#FE0000\" style=\"height:38px; text-align:center; border:1px solid #ffffff;\"><a style=\"display: block; width: 100%; margin:0; padding:0; text-decoration: none; color: #ffffff; font-weight: bold;\" href=\"{$lead:npsreviewrequest:1}\">1</a></td>\n                            <td width=\"9%\" bgcolor=\"#FE0000\" style=\"height:38px; text-align:center; border:1px solid #ffffff;\"><a style=\"display: block; width: 100%; margin:0; padding:0; text-decoration: none; color: #ffffff; font-weight: bold;\" href=\"{$lead:npsreviewrequest:2}\">2</a></td>\n                            <td width=\"9%\" bgcolor=\"#FE0000\" style=\"height:38px; text-align:center; border:1px solid #ffffff;\"><a style=\"display: block; width: 100%; margin:0; padding:0; text-decoration: none; color: #ffffff; font-weight: bold;\" href=\"{$lead:npsreviewrequest:3}\">3</a></td>\n                            <td width=\"9%\" bgcolor=\"#FE0000\" style=\"height:38px; text-align:center; border:1px solid #ffffff;\"><a style=\"display: block; width: 100%; margin:0; padding:0; text-decoration: none; color: #ffffff; font-weight: bold;\" href=\"{$lead:npsreviewrequest:4}\">4</a></td>\n                            <td width=\"9%\" bgcolor=\"#FE0000\" style=\"height:38px; text-align:center; border:1px solid #ffffff;\"><a style=\"display: block; width: 100%; margin:0; padding:0; text-decoration: none; color: #ffffff; font-weight: bold;\" href=\"{$lead:npsreviewrequest:5}\">5</a></td>\n                            <td width=\"9%\" bgcolor=\"#FE0000\" style=\"height:38px; text-align:center; border:1px solid #ffffff;\"><a style=\"display: block; width: 100%; margin:0; padding:0; text-decoration: none; color: #ffffff; font-weight: bold;\" href=\"{$lead:npsreviewrequest:6}\">6</a></td>\n                            <td width=\"9%\" bgcolor=\"#F0C409\" style=\"height:38px; text-align:center; border:1px solid #ffffff;\"><a style=\"display: block; width: 100%; margin:0; padding:0; text-decoration: none; color: #ffffff; font-weight: bold;\" href=\"{$lead:npsreviewrequest:7}\">7</a></td>\n                            <td width=\"9%\" bgcolor=\"#F0C409\" style=\"height:38px; text-align:center; border:1px solid #ffffff;\"><a style=\"display: block; width: 100%; margin:0; padding:0; text-decoration: none; color: #ffffff; font-weight: bold;\" href=\"{$lead:npsreviewrequest:8}\">8</a></td>\n                            <td width=\"9%\" bgcolor=\"#02A401\" style=\"height:38px; text-align:center; border:1px solid #ffffff;\"><a style=\"display: block; width: 100%; margin:0; padding:0; text-decoration: none; color: #ffffff; font-weight: bold;\" href=\"{$lead:npsreviewrequest:9}\">9</a></td>\n                            <td width=\"9%\" bgcolor=\"#02A401\" style=\"height:38px; text-align:center; border:1px solid #ffffff;\"><a style=\"display: block; width: 100%; margin:0; padding:0; text-decoration: none; color: #ffffff; font-weight: bold;\" href=\"{$lead:npsreviewrequest:10}\">10</a></td>\n                        </tr>    \n                        </table><br/>\n                        <table cellpadding=\"0\" cellspacing=\"0\"  width=\"100%\" >\n                            <tr>\n                                <td align=\"left\" width=\"50%\">Very Unlikely</td>\n                                <td align=\"right\" width=\"50%\">Extremely Likely</td>\n                            </tr>\n                        </table>\n                        <br/><br/><br/><br/>\n                        {$content:email_text}\n                        {emailmessage}\n                    </td>\n                </tr>\n                </tbody>\n                <!-- Footer -->\n                <tfoot>\n                <tr>\n            		<td align=\"center\" bgcolor=\"#7c7c7c\" style=\"padding: 25px 25px 25px 25px; color: #ffffff; font-family: Arial, sans-serif; font-size: 12px; line-height: 20px;\"  colspan=\"2\">\n            			<address>\n            				<font color=\"#FFFFFF\">{$plugin:widcard:BizOrgName:notag} | {$plugin:widcard:BizAddress1:notag}, {$plugin:widcard:BizCity:notag}, {$plugin:widcard:BizState:notag} {$plugin:widcard:BizZip:notag} | Tel : <a style=\"color: #FFFFFF;\" href=\"tel:{$plugin:widcard:BizTelephone:notag}\">{$plugin:widcard:BizTelephone:notag}</a></address>\n            		</td>\n            	</tr>\n                </tfoot>\n                <!-- end Footer -->\n            </table>\n        </td>\n        <td>&nbsp;</td>\n    </tr>\n</table>\n</body>\n</html>',	'typemail');

INSERT IGNORE INTO `email_triggers_actions` (`service`, `trigger`, `template`, `recipient`, `message`, `from`, `subject`)
SELECT CONCAT('email'),	CONCAT('leads_npsreviewrequest'),	CONCAT('NPS request system'),	CONCAT('guest'),	CONCAT('<p>Thank you so much for being a valuable customer. Please help us improve by sharing with others your experience about  {$plugin:widcard:BizOrgName:notag}. We would be extremely grateful if you could write a quick review.</p>'),	CONCAT('{$leadowner:email}'),	CONCAT('Please share your experience with others') FROM email_triggers_actions
WHERE NOT EXISTS (SELECT `service`, `trigger`, `template`, `recipient`, `message`, `from`, `subject` FROM `email_triggers_actions`
WHERE `trigger` = 'leads_npsreviewrequest') LIMIT 1;

INSERT IGNORE INTO `email_triggers_actions` (`service`, `trigger`, `template`, `recipient`, `message`, `from`, `subject`)
SELECT CONCAT('email'),	CONCAT('leads_reviewrequest'),	CONCAT('NPS leave review system'),	CONCAT('guest'),	CONCAT('<p>Thank you so much for being a valuable customer. Please help us improve by sharing with others your experience about  {$plugin:widcard:BizOrgName:notag}. We would be extremely grateful if you could write a quick review.</p>'),	CONCAT('store@example.com'),	CONCAT('Please share your experience with others') FROM email_triggers_actions
WHERE NOT EXISTS (SELECT `service`, `trigger`, `template`, `recipient`, `message`, `from`, `subject` FROM `email_triggers_actions`
WHERE `trigger` = 'leads_reviewrequest') LIMIT 1;

INSERT IGNORE INTO `plugin_cartstatusemail_settings` (`id`, `cartStatus`, `type`, `period`, `productsIds`, `emailTemplate`, `emailFrom`, `productsRule`, `emailMessage`, `schedulePeriod`, `schedulePeriodType`, `lagType`, `sequenceOnly`, `triggerName`, `subject`) VALUES
(10000,	'no_cart',	'email',	1,	'',	'NPS request system',	'{$leadowner:email}',	'without',	'',	'sunday,monday,tuesday,wednesday,thursday,friday,saturday',	'anytime',	'hour',	'1',	'NPS request',	'Please share your experience with others');

INSERT IGNORE INTO `plugin_emailsequence_settings` (`id`, `sequence_name`, `archive`) VALUES
(10000,	'NPS request',	'0');

INSERT IGNORE INTO `plugin_emailsequence_triggers` (`sequence_settings_id`, `trigger_id`, `trigger_enabled`) VALUES
(10000,	10000,	'1');

-- 01/07/2020
-- version: 1.6.2
CREATE TABLE IF NOT EXISTS `plugin_leads_mobile_app_config` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `login` VARCHAR (255) COLLATE utf8_unicode_ci NOT NULL,
  `password` VARCHAR (255) NOT NULL,
  `status` ENUM('enabled', 'disabled') DEFAULT 'enabled' NOT NULL,
  `social_app_status` ENUM('enabled', 'disabled') DEFAULT 'enabled' NOT NULL,
  `created_at` TIMESTAMP NOT NULL,
  `updated_at` TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE (`login`),
  FOREIGN KEY (`user_id`) REFERENCES `user`(`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 19/08/2020
-- version: 1.6.3
UPDATE `plugin` SET `tags`='crm,hiddenemail,emaillog,userdelete,assigngroup' WHERE `name` = 'leads';

-- 14/09/2020
-- version: 1.6.4
CREATE TABLE IF NOT EXISTS `plugin_leads_advertiser_account_config` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `adv_id` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL,
  `adv_name` VARCHAR(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `adv_type` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL,
  `adv_status` ENUM('pending', 'connected') DEFAULT 'pending',
  `adv_verification_link` TEXT COLLATE utf8_unicode_ci DEFAULT NULL,
  `allow_delete` ENUM('0', '1') DEFAULT '1',
  PRIMARY KEY(`id`),
  UNIQUE(`adv_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 28/12/2020
-- version: 1.6.5
ALTER TABLE `plugin_leads_form_rules_actions` MODIFY COLUMN `action_type` ENUM ('assign_owner', 'assign_task', 'assign_tags', 'assign_lifecycle', 'assign_sequence', 'assign_email_list', 'assign_email_copy', 'assign_remarketing_list') DEFAULT 'assign_owner';
ALTER TABLE `plugin_leads_event_rules_actions` MODIFY COLUMN `action_type` ENUM ('assign_owner', 'assign_task', 'assign_tags', 'assign_lifecycle', 'assign_sequence', 'assign_email_list', 'assign_email_copy', 'assign_remarketing_list') DEFAULT 'assign_owner';
ALTER TABLE `plugin_leads_workflow_actions` MODIFY COLUMN `action_type` ENUM ('assign_owner', 'assign_task', 'assign_tags', 'assign_lifecycle', 'assign_sequence', 'assign_email_list', 'assign_email_copy', 'send_review_request', 'assign_remarketing_list') DEFAULT 'assign_owner';

-- 05/01/2021
-- version: 1.6.6
ALTER TABLE `plugin_leads_email_log` ADD INDEX (`tracking_code`);

-- 15/01/2021
-- version: 1.6.7
DELETE FROM `plugin_leads_social_services_config` WHERE `service_name` = 'gplus';
INSERT IGNORE INTO `plugin_leads_social_services_config` (`service_name`, `service_label`, `image_name`) VALUES
('gmb', 'google my business', 'icon-gmb.png');

-- 26/01/2021
-- version: 1.6.8
ALTER TABLE `plugin_leads_tasks` ADD COLUMN `is_task_overdue` ENUM('0', '1') DEFAULT '0';
ALTER TABLE `plugin_leads_tasks` ADD COLUMN `is_task_start_email_sent` ENUM('0', '1') DEFAULT '0';
ALTER TABLE `plugin_leads_tasks_log` ADD COLUMN `is_task_overdue` ENUM('0', '1') DEFAULT '0';
ALTER TABLE `plugin_leads_tasks_log` ADD COLUMN `due_date` TIMESTAMP NULL;
ALTER TABLE `plugin_leads_tasks` ADD COLUMN `due_date` TIMESTAMP NULL;

INSERT IGNORE INTO `email_triggers` (`enabled`, `trigger_name`, `observer`) VALUES
('1', 'leads_taskoverdue', 'Tools_LeadsMailWatchdog'),
('1', 'leads_taskstart', 'Tools_LeadsMailWatchdog');

-- 26/01/2021
-- version: 1.6.9
ALTER TABLE `plugin_leads_meeting` ADD COLUMN `first_notification_is_sent` ENUM('0', '1') DEFAULT '0';
ALTER TABLE `plugin_leads_meeting` ADD COLUMN `second_notification_is_sent` ENUM('0', '1') DEFAULT '0';
ALTER TABLE `plugin_leads_meeting` ADD COLUMN `send_notification_sms` ENUM('0', '1') DEFAULT '0';
ALTER TABLE `plugin_leads_meeting` ADD COLUMN `send_sms` ENUM('0', '1') DEFAULT '0';
ALTER TABLE `plugin_leads_meeting` ADD COLUMN `first_notification_date` TIMESTAMP NULL;
ALTER TABLE `plugin_leads_meeting` ADD COLUMN `second_notification_date` TIMESTAMP NULL;
ALTER TABLE `plugin_leads_meeting` ADD COLUMN `first_notification_sent_date` TIMESTAMP NULL;
ALTER TABLE `plugin_leads_meeting` ADD COLUMN `second_notification_sent_date` TIMESTAMP NULL;

-- 10/02/2021
-- version: 1.7.0
INSERT IGNORE INTO `email_triggers` (`enabled`, `trigger_name`, `observer`) VALUES
('1', 'leads_meetingreminder', 'Tools_LeadsMailWatchdog');

-- 15/02/2021
-- version: 1.7.1
CREATE TABLE IF NOT EXISTS `plugin_leads_external_notifications` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `status` ENUM('scheduled', 'sent', 'failed') DEFAULT 'scheduled' NOT NULL,
  `lead_id` int(10) unsigned NOT NULL,
  `additional_info` TEXT COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_at` TIMESTAMP NOT NULL,
  `updated_at` TIMESTAMP,
  PRIMARY KEY(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_external_notifications_endpoints` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `method_name` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT IGNORE INTO `plugin_leads_external_notifications_endpoints` (`method_name`) VALUES
('crmLeadInfo');

-- 01/04/2021
-- version: 1.7.2
ALTER TABLE `plugin_leads_documents` ADD COLUMN `external_url` TEXT DEFAULT NULL COMMENT 'External url';

-- 15/04/2021
-- version: 1.7.3
ALTER TABLE `plugin_leads_email_log` ADD INDEX (`message_id`(998));

-- 25/02/2021
-- version: 1.7.4
ALTER TABLE `plugin_leads_data` ADD COLUMN `email_validated_status` ENUM('not_verified', 'valid', 'invalid', 'risky') DEFAULT 'not_verified';
ALTER TABLE `plugin_leads_data` ADD COLUMN `email_validated_date` TIMESTAMP NULL;
ALTER TABLE `plugin_leads_data` ADD COLUMN `email_validated_score` FLOAT;

-- 29/06/2021
-- version: 1.7.5
UPDATE plugin_leads_data SET `lead_first_name` = CONCAT(UCASE(LEFT(`lead_first_name`, 1)), SUBSTRING(`lead_first_name`, 2));
UPDATE plugin_leads_data SET `lead_last_name` = CONCAT(UCASE(LEFT(`lead_last_name`, 1)), SUBSTRING(`lead_last_name`, 2));

-- 16/03/2021
-- version: 1.7.6
CREATE TABLE IF NOT EXISTS `plugin_leads_owner_goals` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `user_id` INT(10) UNSIGNED NOT NULL,
  `quote_objective` INT(10) UNSIGNED NOT NULL,
  `quotes_amount` INT(10) UNSIGNED NOT NULL,
  `meetings_held` INT(10) UNSIGNED NOT NULL,
  `calls_placed` INT(10) UNSIGNED NOT NULL,
  `emails_sent` INT(10) UNSIGNED NOT NULL,
PRIMARY KEY(`id`),
UNIQUE (`user_id`),
FOREIGN KEY (`user_id`) REFERENCES `user`(`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_owner_goals_opportunities` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `owner_goals_id` INT(10) UNSIGNED NOT NULL,
  `opportunity_amount` INT(10) UNSIGNED NOT NULL,
  `opportunity_count` INT(10) UNSIGNED NOT NULL,
  `opportunity_type_id` INT(10) UNSIGNED NOT NULL,
PRIMARY KEY(`id`),
FOREIGN KEY (`owner_goals_id`) REFERENCES `plugin_leads_owner_goals`(`id`) ON DELETE CASCADE ON UPDATE NO ACTION,
FOREIGN KEY (`opportunity_type_id`) REFERENCES `plugin_leads_opportunity_type`(`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 31/05/2021
-- version: 1.7.7
UPDATE `plugin_leads_opportunity` SET `change_stage_date` = NULL WHERE `change_stage_date` = '0000-00-00 00:00:00';

-- 21/07/2021
-- version: 1.7.8
UPDATE `email_triggers_actions` SET `message` = 'Congratulations! You''re getting noticed and folks are interested in what you''re doing.\r\n\r\nWe hope that you''re enjoying using our CRM at <a target=\"_blank\" href=\"{$website:url}\">{$website:host}</a>. Unfortunately, you''ve reached your software subscription limit.\r\nAs a result, no additional named lead contacts can be created. As it stands, you won''t be able to know what web pages your prospective clients have looked at, which documents they''ve downloaded, which emails and attachments they''ve opened. And you won''t have access to a history of phone conversations, all conveniently located under their client profiles.\r\nThe good news is that it''s super simple to fix this: Don''t lose any more valuable opportunities. Click <a href=\"{lead:subscriptionlink}\">here </a>to upgrade your CRM subscription now' WHERE `trigger` = 'leads_licenselimit';

-- 26/07/2021
-- version: 1.7.9
CREATE TABLE IF NOT EXISTS `plugin_leads_internal_notifications` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `status` ENUM('scheduled', 'sent', 'failed') DEFAULT 'scheduled' NOT NULL,
  `lead_id` int(10) unsigned NOT NULL,
  `additional_info` TEXT COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_at` TIMESTAMP NOT NULL,
  `updated_at` TIMESTAMP,
  PRIMARY KEY(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 16/08/2021
-- version: 1.8.0
ALTER TABLE `plugin_leads_meeting` ADD COLUMN `meeting_type` ENUM('auto', 'manual') DEFAULT 'auto';

-- 18/06/2021
-- version: 1.8.1
CREATE TABLE IF NOT EXISTS `plugin_leads_imap_rules_config` (
  `id` INT(10) unsigned AUTO_INCREMENT,
  `rule_name` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL COMMENT 'Rule name',
  `imap_config_id` int(10) unsigned NOT NULL COMMENT 'IMAP config id',
  `rule_email` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL COMMENT 'Rule email',
  `sub_rules_config` TEXT COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Rule subrules',
  `created_at` TIMESTAMP NOT NULL,
  `creator_id` INT(10) UNSIGNED DEFAULT NULL,
  `updated_at` TIMESTAMP NOT NULL,
  `editor_id` INT(10) UNSIGNED DEFAULT NULL,
PRIMARY KEY(`id`),
FOREIGN KEY (`creator_id`) REFERENCES `user` (`id`) ON DELETE SET NULL ON UPDATE NO ACTION,
FOREIGN KEY (`editor_id`) REFERENCES `user` (`id`) ON DELETE SET NULL ON UPDATE NO ACTION,
FOREIGN KEY (`imap_config_id`) REFERENCES `plugin_leads_imap_config` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 28/10/2021
-- version: 1.8.2
ALTER TABLE `plugin_leads_review_request` ADD INDEX `pllr_special_index` (`lead_id`,`score`,`reviewed_at`,`sent_at`,`status`,`review_request_sent_at`,`request_reviewed_facebook_date`,`request_reviewed_gmb_date`,`review_status`);

-- 08/10/2021
-- version: 1.8.3
CREATE TABLE IF NOT EXISTS `plugin_leads_hidden_opportunities` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `opportunity_id` int(10) UNSIGNED NOT NULL,
  PRIMARY KEY(`id`),
  FOREIGN KEY (`opportunity_id`) REFERENCES `plugin_leads_opportunity` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 24/11/2021
-- version: 1.8.4
ALTER TABLE `plugin_leads_additional_email_log` ADD COLUMN `encoded_content` BLOB;

-- 18/06/2021
-- version: 1.8.5
ALTER TABLE `plugin_leads_call_log` ADD COLUMN `sub_type` VARCHAR (255) DEFAULT NULL AFTER `type`;

-- 24/11/2021
-- version: 1.8.6
INSERT IGNORE INTO `config` (`name`, `value`) VALUES ('redirectAdminAfterLogin', 'dashboard');

-- 24/12/2021
-- version: 1.8.7
CREATE TABLE IF NOT EXISTS `plugin_leads_table_columns_order` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `table_name` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL,
  `preset_name` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL,
  `is_default` ENUM('0', '1') DEFAULT '0',
  `fields_data` TEXT COLLATE utf8_unicode_ci DEFAULT NULL,
  `user_id` INT(10) UNSIGNED DEFAULT NULL,
  `apply_to_all` ENUM('0', '1') DEFAULT '0',
  `created_at` TIMESTAMP NOT NULL,
  PRIMARY KEY(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `plugin_leads_table_columns_order` ( `table_name`, `preset_name`, `is_default`, `fields_data`, `user_id`, `apply_to_all`, `created_at`) VALUES
('dashboard_latest_leads',	'corporate',	'0',	'[\"placeholder\",\"id\",\"name\",\"organization\",\"leadEmail\",\"leadPhone\",\"leadCreatedAt\",\"leadType\",\"leadOwner\",\"actions\"]',	NULL,	'1',	'2022-01-27 11:29:02');

INSERT INTO `plugin_leads_table_columns_order` ( `table_name`, `preset_name`, `is_default`, `fields_data`, `user_id`, `apply_to_all`, `created_at`) VALUES
('dashboard_engaged_leads',	'corporate',	'0',	'[\"placeholder\",\"id\",\"score\",\"name\",\"organization\",\"leadEmail\",\"leadPhone\",\"totalOppsAmount\",\"leadLastActivity\",\"engagedLifecycle\",\"actions\"]',	NULL,	'1',	'2022-01-27 11:29:02');

-- 10/01/2022
-- version: 1.8.8
ALTER TABLE `plugin_leads_purchase_log` ADD COLUMN `is_partial` ENUM('0', '1') DEFAULT '0';
ALTER TABLE `plugin_leads_purchase_log` ADD COLUMN `is_manually_paid` ENUM('0', '1') DEFAULT '0';
ALTER TABLE `plugin_leads_purchase_log` ADD COLUMN `partially_paid_amount` DECIMAL(10,2) NOT NULL DEFAULT '0.00';
ALTER TABLE `plugin_leads_purchase_log` ADD COLUMN `gateway` VARCHAR(255) COLLATE utf8_unicode_ci DEFAULT NULL;
UPDATE `plugin_leads_purchase_log` SET `is_partial` = '1' WHERE `status` = 'partial';
UPDATE `plugin_leads_purchase_log` SET `partially_paid_amount` = `total` WHERE `status` = 'partial';
UPDATE `plugin_leads_purchase_log` as `plpl` INNER JOIN  (SELECT `cart_id` FROM `plugin_leads_purchase_log` WHERE `is_partial` = '1') as `plpl1`
SET `is_partial` = '1' WHERE `plpl`.`cart_id` =`plpl1`.`cart_id`;
UPDATE `plugin_leads_purchase_log` as `plpl` INNER JOIN  (SELECT `gateway`, `id` FROM `shopping_cart_session`) as `scs`
SET `plpl`.`gateway` = `scs`.`gateway` WHERE `plpl`.`cart_id` = `scs`.`id`;
UPDATE `plugin_leads_purchase_log` as `plpl` INNER JOIN  (SELECT `partial_paid_amount`, `id`, `total` FROM `shopping_cart_session` WHERE `is_partial` = '1') as `scs`
SET `plpl`.`partially_paid_amount` = `scs`.`total` - `scs`.`partial_paid_amount` WHERE `plpl`.`cart_id` = `scs`.`id` AND `plpl`.`status` = 'completed';

-- 10/01/2022
-- version: 1.8.9
ALTER TABLE `plugin_leads_workflow_config` MODIFY COLUMN `rule_type` ENUM('lead_attribute', 'organization_attribute', 'action_type', 'lead_opportunities', 'lead_custom_attributes', 'organization_custom_attributes', 'form_name') DEFAULT 'lead_attribute';

-- 25/03/2022
-- version: 1.9.0
ALTER TABLE `plugin_leads_quote_log` MODIFY COLUMN `status` ENUM('new','sent','sold','lost', 'deleted', 'signature_only_signed') DEFAULT 'new';
ALTER TABLE `plugin_leads_quote_log` ADD COLUMN `signed_only_by` INT(10) UNSIGNED DEFAULT '0';
ALTER TABLE `plugin_leads_purchase_log` ADD COLUMN `signed_only_by` INT(10) UNSIGNED DEFAULT '0';

-- 10/06/2022
-- version: 1.9.1
ALTER TABLE `plugin_leads_email_log` ADD INDEX (`reply_id`(998));

-- 17/06/2022
-- version: 1.9.2
CREATE TABLE IF NOT EXISTS `plugin_leads_remarketing_audiences` (
    `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
    `type` ENUM('facebook', 'adwords') DEFAULT 'facebook' NOT NULL,
    `action` ENUM('add', 'remove') DEFAULT 'add',
    `audience_id` TEXT COLLATE utf8_unicode_ci NOT NULL,
    `list_content` LONGTEXT COLLATE utf8_unicode_ci DEFAULT NULL,
    `additional_info` TEXT COLLATE utf8_unicode_ci DEFAULT NULL,
    `created_at` TIMESTAMP NOT NULL,
    PRIMARY KEY(`id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT IGNORE INTO `plugin_leads_config` (`name`, `value`) VALUES
    ('remarketingAudiencesFacebookProcessedDate', ''),
    ('remarketingAudiencesFacebookProcessedCount', '0'),
    ('remarketingAudiencesAdwordsProcessedDate', ''),
    ('remarketingAudiencesAdwordsProcessedCount', '0');

-- 30/05/2022
-- version: 1.9.3
INSERT IGNORE INTO `config` (`name`, `value`)
SELECT CONCAT('redirectAdminAfterLogin'),	CONCAT('dashboard') FROM config
WHERE EXISTS (SELECT `name`, `value` FROM `config`
WHERE `name` = 'redirectAdminAfterLogin' AND `value` = 'dashboard') LIMIT 1;

-- 08/08/2022
-- version: 1.9.4
ALTER TABLE `plugin_leads_advertiser_account_config` MODIFY COLUMN `adv_status` ENUM('pending', 'connected', 'disconnected') DEFAULT 'pending';

-- 05/08/2022
-- version: 1.9.5
CREATE TABLE IF NOT EXISTS `plugin_leads_hashed_address_coordinates` (
    `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
    `address_hash` CHAR(40) NOT NULL,
    `lat` VARCHAR(100) DEFAULT NULL,
    `lng` VARCHAR(100) DEFAULT NULL,
    PRIMARY KEY(`id`),
    UNIQUE (`address_hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

ALTER TABLE `plugin_leads_data` ADD COLUMN `address_hash` CHAR(40) NOT NULL;
ALTER TABLE `plugin_leads_data` ADD COLUMN `lat` VARCHAR(100) DEFAULT NULL;
ALTER TABLE `plugin_leads_data` ADD COLUMN `lng` VARCHAR(100) DEFAULT NULL;
ALTER TABLE `plugin_leads_data` ADD COLUMN `last_coordinates_processed_date` TIMESTAMP NULL DEFAULT '0000-00-00 00:00:00';
ALTER TABLE `plugin_lead_organization` ADD COLUMN `address_hash` CHAR(40) NOT NULL;
ALTER TABLE `plugin_lead_organization` ADD COLUMN `lat` VARCHAR(100) DEFAULT NULL;
ALTER TABLE `plugin_lead_organization` ADD COLUMN `lng` VARCHAR(100) DEFAULT NULL;
ALTER TABLE `plugin_lead_organization` ADD COLUMN `last_coordinates_processed_date` TIMESTAMP NULL DEFAULT '0000-00-00 00:00:00';

-- 29/09/2022
-- version: 1.9.6
ALTER TABLE `plugin_leads_email_log` ADD INDEX (`lead_id`);

-- 05/10/2022
-- version: 1.9.7
ALTER TABLE `plugin_leads_workflow_config` MODIFY COLUMN `rule_comparison_operator` ENUM('equal','notequal','like','in','greaterthan','lessthan','notin','datebefore','dateafter') DEFAULT 'equal';

-- 13/10/2022
-- version: 1.9.8
ALTER TABLE `plugin_leads_email_log` ADD INDEX (`follow_up_sequences_id`);

-- 01/11/2022
-- version: 1.9.9
ALTER TABLE `plugin_leads_email_log` ADD INDEX (`attachment_id`);

-- 03/11/2022
-- version: 2.0.0
CREATE TABLE IF NOT EXISTS `plugin_leads_clean_up_fields_log` (
    `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
    `created_at` TIMESTAMP NULL,
    `logged_user_id` INT(10) UNSIGNED NOT NULL,
    `type` VARCHAR(64) COLLATE utf8_unicode_ci NOT NULL,
    `ip_address` VARCHAR(45) NOT NULL,
    `deleted_items_info` MEDIUMTEXT COLLATE utf8_unicode_ci DEFAULT NULL,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 22/11/2022
-- version: 2.0.1
ALTER TABLE `plugin_leads_email_link_attachment_log` ADD COLUMN `file_link` TEXT COLLATE utf8_unicode_ci DEFAULT NULL AFTER `file_folder_name`;
ALTER TABLE `plugin_leads_email_link_attachment_log` ADD COLUMN `link_type` ENUM('click', 'attachment') DEFAULT 'attachment' NOT NULL;
ALTER TABLE `plugin_leads_email_log` MODIFY `email_status` ENUM('sent', 'click', 'opened', 'openattachment', 'received', 'bounce', 'deferred', 'dropped', 'unsubscribed');
ALTER TABLE `plugin_leads_email_link_attachment_log` ADD COLUMN `created_datetime` DATETIME NULL;
ALTER TABLE `plugin_leads_email_link_attachment_log` ADD COLUMN `archived` ENUM('0', '1') DEFAULT '0' NOT NULL;
UPDATE `plugin_leads_email_log` SET `email_status`='click' WHERE `email_source_type` = 'external' AND `email_source_type` = 'attachment';
UPDATE `plugin_leads_email_link_attachment_log` SET `link_type` ='click' WHERE `link_type` = 'attachment' AND `source_type` = 'external';
UPDATE `plugin_leads_email_link_attachment_log` SET `archived` ='1';

-- 14/02/2023
-- version: 2.0.2
ALTER TABLE `plugin_leads_custom_tabs_config` ADD COLUMN `draggable_params_ids` TEXT DEFAULT NULL COMMENT 'Draggable custom params ids';

CREATE TABLE IF NOT EXISTS `plugin_leads_organize_custom_fields_config` (
    `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
    `type` VARCHAR(255) DEFAULT NULL,
    `draggable_params_ids` TEXT DEFAULT NULL COMMENT 'Draggable custom params ids',
    PRIMARY KEY(`id`),
    UNIQUE (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 27/02/2023
-- version: 2.0.3
ALTER TABLE `plugin_leads_workflow_config` MODIFY COLUMN `rule_comparison_operator` ENUM('equal','notequal','like','in','greaterthan','lessthan','notin','datebefore','dateafter', 'dategreaterthan', 'datelessthan') DEFAULT 'equal';

-- 11/05/2023
-- version: 2.0.4
CREATE TABLE IF NOT EXISTS `plugin_leads_emailsequence_ban_ips` (
  `ip_address` VARCHAR(45) NOT NULL,
  PRIMARY KEY(`ip_address`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 23/05/2023
-- version: 2.0.5
UPDATE `plugin` SET `tags`='crm,hiddenemail,emaillog,userdelete,userupdate' WHERE `name` = 'leads';

-- 06/06/2023
-- version: 2.0.6
CREATE TABLE IF NOT EXISTS `plugin_leads_tasks_presets` (
  `id` INT(10) unsigned AUTO_INCREMENT,
  `preset_name` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL COMMENT 'Preset name',
  `task_title` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL COMMENT 'Task title',
  `task_note` TEXT COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Task notes',
  `created_at` TIMESTAMP NOT NULL,
  `creator_id` INT(10) UNSIGNED DEFAULT NULL,
  `updated_at` TIMESTAMP NOT NULL,
  `editor_id` INT(10) UNSIGNED DEFAULT NULL,
PRIMARY KEY(`id`),
FOREIGN KEY (`creator_id`) REFERENCES `user` (`id`) ON DELETE SET NULL ON UPDATE NO ACTION,
FOREIGN KEY (`editor_id`) REFERENCES `user` (`id`) ON DELETE SET NULL ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 11/08/2023
-- version: 2.0.7
ALTER TABLE `plugin_leads_call_log` ADD COLUMN `is_mms` ENUM('0', '1') DEFAULT '0';
ALTER TABLE `plugin_leads_call_log` ADD COLUMN `mms_files` TEXT DEFAULT NULL COLLATE 'utf8_unicode_ci';

-- 07/09/2023
-- version: 2.0.8
CREATE TABLE IF NOT EXISTS `plugin_leads_webhook_urls` (
    `id` INT(10) unsigned AUTO_INCREMENT,
    `webhook_name` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL,
    `webhook_type` ENUM('lead', 'organization') DEFAULT 'lead',
    `webhook_action_type` ENUM('creation', 'modification') DEFAULT 'creation',
    `action_url` TEXT COLLATE utf8_unicode_ci DEFAULT NULL,
    `created_at` TIMESTAMP NOT NULL,
    `creator_id` INT(10) UNSIGNED DEFAULT NULL,
    `updated_at` TIMESTAMP NOT NULL,
    `editor_id` INT(10) UNSIGNED DEFAULT NULL,
    PRIMARY KEY(`id`),
    FOREIGN KEY (`creator_id`) REFERENCES `user` (`id`) ON DELETE SET NULL ON UPDATE NO ACTION,
    FOREIGN KEY (`editor_id`) REFERENCES `user` (`id`) ON DELETE SET NULL ON UPDATE NO ACTION
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_webhook_notifications` (
    `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
    `status` ENUM('scheduled', 'sent', 'failed') DEFAULT 'scheduled' NOT NULL,
    `webhook_type` ENUM('lead', 'organization') DEFAULT 'lead',
    `resource_id` int(10) unsigned NOT NULL,
    `webhook_action_type` ENUM('creation', 'modification') DEFAULT 'creation',
    `additional_info` MEDIUMTEXT COLLATE utf8_unicode_ci DEFAULT NULL,
    `created_at` TIMESTAMP NOT NULL,
    `updated_at` TIMESTAMP,
    PRIMARY KEY(`id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 29/09/2023
-- version: 2.0.9
ALTER TABLE `plugin_leads_form_log` MODIFY COLUMN `form_name` VARCHAR(40) COLLATE utf8_unicode_ci;

-- 29/09/2023
-- version: 2.1.0
ALTER TABLE `plugin_leads_tasks_presets` MODIFY COLUMN `updated_at` TIMESTAMP NULL;

-- 29/09/2023
-- version: 2.1.1
ALTER TABLE `plugin_leads_imap_rules_config` MODIFY COLUMN `updated_at` TIMESTAMP NULL;

-- 01/02/2024
-- version: 2.1.2
CREATE TABLE IF NOT EXISTS `plugin_leads_validate_emails_queue` (
 `id` INT(10) unsigned AUTO_INCREMENT,
 `creator_id` INT(10) UNSIGNED DEFAULT NULL,
 `created_at` TIMESTAMP NOT NULL COMMENT 'Record added to queue date',
 `process_at` TIMESTAMP NOT NULL COMMENT 'To process item',
 `processed_at` TIMESTAMP NULL COMMENT 'Processed at item',
 `delayed_to` TIMESTAMP NULL COMMENT 'Delayed to item',
 `lead_ids` MEDIUMTEXT DEFAULT NULL,
 `status` ENUM('new', 'processing', 'delayed', 'processed', 'error') DEFAULT 'new' NOT NULL,
 `processed_leads` INT(10) UNSIGNED DEFAULT NULL,
 `not_processed_leads` INT(10) UNSIGNED DEFAULT NULL,
 `balance` INT(10) UNSIGNED DEFAULT NULL,
 `error_info` TEXT DEFAULT NULL,
 PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT IGNORE INTO `email_triggers` (`enabled`, `trigger_name`, `observer`) VALUES
('1', 'leads_emailsvalidationqueue', 'Tools_LeadsMailWatchdog');

-- 15/03/2024
-- version: 2.1.3
ALTER TABLE `plugin_leads_validate_emails_queue` MODIFY COLUMN `lead_ids` MEDIUMTEXT DEFAULT NULL;

CREATE TABLE IF NOT EXISTS `plugin_leads_mass_actions_queue` (
 `id` INT(10) unsigned AUTO_INCREMENT,
 `creator_id` INT(10) UNSIGNED DEFAULT NULL,
 `type` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL COMMENT 'Name of mass action',
 `created_at` TIMESTAMP NOT NULL COMMENT 'Record added to queue date',
 `process_at` TIMESTAMP NOT NULL COMMENT 'To process item',
 `processed_at` TIMESTAMP NULL COMMENT 'Processed at item',
 `delayed_to` TIMESTAMP NULL COMMENT 'Delayed to item',
 `lead_ids` MEDIUMTEXT DEFAULT NULL,
 `status` ENUM('new', 'processing', 'delayed', 'processed', 'error') DEFAULT 'new' NOT NULL,
 `processed_leads` INT(10) UNSIGNED DEFAULT NULL,
 `not_processed_leads` INT(10) UNSIGNED DEFAULT NULL,
 `additional_data` TEXT DEFAULT NULL,
 `error_info` TEXT DEFAULT NULL,
 PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT IGNORE INTO `email_triggers` (`enabled`, `trigger_name`, `observer`) VALUES
('1', 'leads_sequencemassactionnotification', 'Tools_LeadsMailWatchdog');

-- 27/04/2024
-- version: 2.1.4
ALTER TABLE `plugin_leads_meeting` ADD COLUMN `additional_notes` TEXT DEFAULT NULL;
ALTER TABLE `plugin_leads_meeting` ADD COLUMN `status` ENUM('no_show', 'rescheduled', 'completed') DEFAULT NULL;

UPDATE `plugin_leads_meeting` INNER JOIN `plugin_leads_meeting_log` ON `plugin_leads_meeting`.`id` = `plugin_leads_meeting_log`.`meeting_id`
SET `plugin_leads_meeting`.`additional_notes` = `plugin_leads_meeting_log`.`additional_content`
WHERE `plugin_leads_meeting_log`.`additional_content` IS NOT NULL AND `plugin_leads_meeting_log`.`additional_content` <> '';

-- 28/05/2024
-- version: 2.1.5
UPDATE `plugin` SET `tags`='crm,hiddenemail,emaillog,userdelete,assigngroup,userupdate' WHERE `name` = 'leads';

-- 27/04/2024
-- version: 2.1.6
UPDATE `plugin_leads_social_services_config` SET `service_name` = 'X' WHERE `service_name` = 'twitter';
UPDATE `plugin_leads_social_services_config` SET `service_label` = 'X' WHERE `service_label` = 'twitter';

-- 17/07/2024
-- version: 2.1.7
CREATE TABLE IF NOT EXISTS `plugin_leads_email_report_log` (
`id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
`user_id` INT(10) UNSIGNED NOT NULL,
`status` ENUM('processed', 'processing', 'delayed') DEFAULT 'processing' NOT NULL,
`sent_at_date` TIMESTAMP NOT NULL,
`processed_at` TIMESTAMP,
PRIMARY KEY(`id`),
FOREIGN KEY (`user_id`) REFERENCES `user`(`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT IGNORE INTO `email_triggers` (`enabled`, `trigger_name`, `observer`) VALUES
('1', 'leads_useremailreport', 'Tools_LeadsMailWatchdog');

-- 18/08/2024
-- version: 2.1.8
ALTER TABLE `plugin_leads_webhook_urls` MODIFY COLUMN `webhook_type` ENUM('lead', 'organization', 'order') DEFAULT 'lead';
ALTER TABLE `plugin_leads_webhook_urls` MODIFY COLUMN `webhook_action_type` VARCHAR (255) COLLATE utf8_unicode_ci NOT NULL;

ALTER TABLE `plugin_leads_webhook_notifications` MODIFY COLUMN `webhook_type` ENUM('lead', 'organization', 'order') DEFAULT 'lead';
ALTER TABLE `plugin_leads_webhook_notifications` MODIFY COLUMN `webhook_action_type` VARCHAR (255) COLLATE utf8_unicode_ci NOT NULL;
ALTER TABLE `plugin_leads_webhook_notifications` ADD COLUMN `sent_notifications_data` TEXT COLLATE utf8_unicode_ci NULL;
ALTER TABLE `plugin_leads_webhook_notifications` ADD COLUMN `sent_at` TIMESTAMP NULL;

-- 05/09/2024
-- version: 2.1.9
ALTER TABLE `plugin_leads_has_email_sequence` ADD INDEX (`sequence_id`);
ALTER TABLE `plugin_leads_has_email_sequence` ADD INDEX (`lead_id`);

-- 18/10/2024
-- version: 2.2.0
INSERT IGNORE INTO `plugin_leads_config` (`name`, `value`) VALUES
('enableAiChat', '1');

-- 11/11/2024
-- version: 2.2.1
ALTER TABLE `plugin_leads_imap_config` ADD COLUMN `is_oauth2` ENUM('0', '1') DEFAULT '0';
ALTER TABLE `plugin_leads_imap_config` ADD COLUMN `access_token` TEXT DEFAULT NULL;
ALTER TABLE `plugin_leads_imap_config` ADD COLUMN `refresh_token` TEXT DEFAULT NULL;
ALTER TABLE `plugin_leads_imap_config` ADD COLUMN `oauth2_service_app_name` VARCHAR (255) COLLATE utf8_unicode_ci NULL;
ALTER TABLE `plugin_leads_imap_config` ADD COLUMN `created_at` TIMESTAMP NOT NULL;
ALTER TABLE `plugin_leads_imap_config` ADD COLUMN `updated_at` TIMESTAMP NOT NULL;
ALTER TABLE `plugin_leads_imap_config` ADD COLUMN `is_temporary` ENUM('0', '1') DEFAULT '0';

CREATE TABLE IF NOT EXISTS `plugin_leads_oauth2_apps_config` (
`id` int(10) unsigned NOT NULL AUTO_INCREMENT,
`service_app_name` VARCHAR (255) COLLATE utf8_unicode_ci NOT NULL,
`client_secret` TEXT DEFAULT NULL,
`client_id` TEXT DEFAULT NULL,
`is_imap` ENUM('0', '1') DEFAULT '0',
`is_system` ENUM('0', '1') DEFAULT '0',
PRIMARY KEY (`id`),
UNIQUE (`service_app_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT IGNORE INTO `plugin_leads_oauth2_apps_config` (`id`, `service_app_name`, `client_secret`, `client_id`, `is_imap`, `is_system`) VALUES
(1,	'outlook',	'',	'',	'1', '1'),
(2,	'gmail',	'',	'',	'1', '1');

ALTER TABLE `plugin_leads_email_log` MODIFY COLUMN `encoded_content` MEDIUMBLOB;
ALTER TABLE `plugin_leads_additional_email_log` MODIFY COLUMN `encoded_content` MEDIUMBLOB;

-- 29/11/2024
-- version: 2.2.2
CREATE TABLE IF NOT EXISTS `plugin_leads_apps_notification_queue` (
`id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
`lead_id` INT(10) UNSIGNED NOT NULL,
`type` ENUM('new_lead', 'update_lead') DEFAULT 'new_lead' NOT NULL,
`status` ENUM('scheduled', 'sent', 'failed') DEFAULT 'scheduled' NOT NULL,
`created_at` TIMESTAMP NOT NULL,
PRIMARY KEY (`id`),
UNIQUE(`lead_id`, `type`),
FOREIGN KEY (`lead_id`) REFERENCES `plugin_leads_data`(`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 20/12/2024
-- version: 2.2.3
ALTER TABLE `plugin_leads_call_log` ADD COLUMN `call_transcription` MEDIUMTEXT DEFAULT NULL;
ALTER TABLE `plugin_leads_call_log` ADD COLUMN `call_transcription_details` MEDIUMTEXT DEFAULT NULL;
ALTER TABLE `plugin_leads_call_log` ADD COLUMN `sentiment` VARCHAR(50) DEFAULT NULL;

-- 25/02/2025
-- version: 2.2.4
ALTER TABLE `plugin_leads_call_log` ADD INDEX (`lead_id`);

-- 25/02/2025
-- version: 2.2.5
ALTER TABLE `plugin_leads_lead_custom_params_data` ADD INDEX (`param_value`);

-- 13/02/2025
-- version: 2.2.6
ALTER TABLE `plugin_leads_data` ADD COLUMN `lead_utm_source` TEXT COLLATE utf8_unicode_ci DEFAULT NULL AFTER `lead_source`;
ALTER TABLE `plugin_leads_data` ADD COLUMN `lead_utm_medium` TEXT COLLATE utf8_unicode_ci DEFAULT NULL AFTER `lead_utm_source`;
ALTER TABLE `plugin_leads_data` ADD COLUMN `lead_utm_campaign` TEXT COLLATE utf8_unicode_ci DEFAULT NULL AFTER `lead_utm_medium`;
ALTER TABLE `plugin_leads_data` ADD COLUMN `lead_utm_term` TEXT COLLATE utf8_unicode_ci DEFAULT NULL AFTER `lead_utm_campaign`;
ALTER TABLE `plugin_leads_data` ADD COLUMN `lead_utm_content` TEXT COLLATE utf8_unicode_ci DEFAULT NULL AFTER `lead_utm_term`;

INSERT IGNORE INTO `plugin_leads_config` (`name`, `value`) VALUES
('enableProcessLeadSourceUtmTags', '1');

-- 03/06/2025
-- version: 2.2.7
ALTER TABLE `plugin_leads_call_log` ADD COLUMN `call_summary` TEXT COLLATE utf8_unicode_ci NULL;

-- 10/02/2025
-- version: 2.2.8
INSERT INTO `plugin_leads_table_columns_order` ( `table_name`, `preset_name`, `is_default`, `fields_data`, `user_id`, `apply_to_all`, `created_at`) VALUES
('dashboard_leads_grid',	'corporate',	'0',	'[\"placeholder\",\"id\",\"name\",\"organization\",\"leadEmail\",\"leadMobile\",\"lifecycle\",\"totalOppsAmount\",\"leadGroup\",\"totalSpend\",\"leadType\",\"leadSource\",\"leadLastActivity\",\"leadNextAction\",\"actions\"]',	NULL,	'1',	'2025-02-10 11:29:02');

-- 11/06/2025
-- version: 2.2.9
ALTER TABLE `plugin_leads_data` ADD COLUMN `lead_sentiment_summary` TEXT COLLATE utf8_unicode_ci DEFAULT NULL;
ALTER TABLE `plugin_leads_data` ADD COLUMN `lead_sentiment_score` DECIMAL(10,2) DEFAULT NULL;
ALTER TABLE `plugin_leads_data` ADD COLUMN `lead_sentiment_score_processed_date` TIMESTAMP NULL;
ALTER TABLE `plugin_leads_data` ADD COLUMN `lead_sentiment_short_log` TEXT COLLATE utf8_unicode_ci DEFAULT NULL;
ALTER TABLE `plugin_leads_data` ADD COLUMN `lead_sentiment_cycle` INT(10) UNSIGNED DEFAULT NULL;

-- 11/08/2025
-- version: 2.3.0
ALTER TABLE `plugin_leads_email_log` ADD COLUMN `trigger_id` INT(10) UNSIGNED DEFAULT NULL AFTER `follow_up_sequences_id`;
ALTER TABLE `plugin_leads_email_log` ADD COLUMN `email_client` VARCHAR(255) COLLATE utf8_unicode_ci DEFAULT NULL AFTER `trigger_id`;
ALTER TABLE `plugin_leads_email_log` ADD INDEX (`trigger_id`);
ALTER TABLE `plugin_leads_email_log` ADD INDEX (`email_client`);

-- 20/10/2025
-- version: 2.3.1
ALTER TABLE `plugin_lead_organization` ADD COLUMN `organization_sentiment_summary` TEXT COLLATE utf8_unicode_ci DEFAULT NULL;
ALTER TABLE `plugin_lead_organization` ADD COLUMN `organization_sentiment_score` DECIMAL(10,2) DEFAULT NULL;
ALTER TABLE `plugin_lead_organization` ADD COLUMN `organization_sentiment_hash` CHAR(40) DEFAULT NULL;
ALTER TABLE `plugin_lead_organization` ADD COLUMN `organization_sentiment_score_processed_date` TIMESTAMP NULL;
ALTER TABLE `plugin_lead_organization` ADD COLUMN `organization_sentiment_cycle` INT(10) UNSIGNED DEFAULT NULL;
ALTER TABLE `plugin_lead_organization` ADD INDEX (`organization_sentiment_hash`);

-- 03/11/2025
-- version: 2.3.2
ALTER TABLE `plugin_leads_data` ADD COLUMN `lead_sentiment_score_decay_date` TIMESTAMP NULL;
ALTER TABLE `plugin_leads_data` ADD INDEX (`lead_sentiment_score_decay_date`);
ALTER TABLE `plugin_leads_data` ADD INDEX (`lead_sentiment_score_processed_date`);

-- 23/12/2025
-- version: 2.3.3
CREATE TABLE IF NOT EXISTS `plugin_leads_crm_organize_config` (
`id` INT(10) unsigned AUTO_INCREMENT,
`type` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL COMMENT 'Name of crm config tab',
`draggable_params_ids` TEXT DEFAULT NULL,
PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 12/01/2026
-- version: 2.3.4
ALTER TABLE `plugin_leads_mobile_app_config` ADD COLUMN `seosambapos_app_status` ENUM('enabled', 'disabled') DEFAULT 'disabled' NOT NULL AFTER `social_app_status`;

-- These alters are always the latest and updated version of the database
UPDATE `plugin` SET `version`='2.3.5' WHERE `name`='leads';
SELECT version FROM `plugin` WHERE `name` = 'leads';
