define([
	'backbone',
    '../../product/models/product',
    '../../product/collections/products_pager',
    '../../product/views/productlist',
    '../../product/collections/images',
    'text!../templates/product-paginator.html',
    'tinyMCE',
    'leadshortcode',
    'placeholder',
    'charlimit',
    'i18n!../../../nls/dashboard_'+$('#email-sequence-dashboard-system-language').val()+'_ln',
    'plupload',
    'pluploadhtml5',
    'pluploadhtml4'
], function(Backbone, ProductModel, ProductsCollection, ProductListView, ImagesCollection, ProductPaginatorTemplate, tinymce, leadshortcode, placeholder, charlimit, i18n, plupload, pluploadhtml5, pluploadhtml4){
    var EmailTriggerFormView = Backbone.View.extend({
        el: $('#email-triggers-form'),
        events: {
            'submit': 'submit',
            'click #test-status-email' : 'testStatusEmail',
            'click .show-list': 'toggleList',
            'click #product-list-back-link': 'hideProductList',
            'change #product-list-holder input.marker': 'markProducts',
            'keypress #product-list-search': 'filterProducts',
            'click .paginator .page': 'paginatorAction',
            'click .productlisting a': 'productAction',
            'click #massaction': 'massAction',
            'change #productsRulePrepare':'changedRule',
            'change #cart-status': 'chooseCartStatus',
            'change #trigger-email-template': 'changeEmailTemplatePreview',
            'click .delete-uploaded-mms-file': 'deleteUploadedMmsFile',
        },
        templates: {

        },
        initialize: function(){
            this.$el.unbind();
            //init products screen start
            this.initProduct();
            $('#product-list-search').ajaxStart(function(){
                $(this).attr('disabled', 'disabled');
            }).ajaxStop(function(){
                $(this).removeAttr('disabled');
            });
            this.images =  new ImagesCollection(),
                this.images.on('reset', this.renderImages, this);

            this.initProducts().pager();
            //init products screen end

            this.$el = $('#email-triggers-form');
            this.$el.attr('action', $('#website_url').val()+'api/emailtrigger/emailtrigger/');

            setTimeout(() => $('.ticon-info').tooltip({
                content: function () {
                    return $(this).attr("title");
                }
            }),  100);

        },
        render: function(){
            this.$el = $('#email-triggers-form');
            this.$el.attr('action', $('#website_url').val()+'api/emailtrigger/emailtrigger/');

            if(typeof this.mmsPicturesUploader !== 'undefined') {
                this.mmsPicturesUploader = undefined;
            }

            tinymce.remove();

            var websiteUrl = $('#website_url').val(),
                self = this;

            tinymce.init({
                script_url              : websiteUrl+'system/js/external/tinymce/tinymce.gzip.php',
                selector                : ".mceMessage",
                skin                    : 'seotoaster',
                menubar                 : false,
                browser_spellcheck      : true,
                resize                  : false,
                convert_urls            : false,
                relative_urls           : false,
                statusbar               : false,
                allow_script_urls       : false,
                force_p_newlines        : false,
                forced_root_block       : false,
                entity_encoding         : "raw",
                plugins                 : ["fullscreen leadshortcode placeholder charlimit code"],
                toolbar1                : "leadshortcode | fullscreen | spellcheckbtn | code",
                image_advtab            : false,
                extended_valid_elements : false,
                setup                   : function(ed){
                    var keyTime = null;
                    ed.on('change blur keyup paste', function(ed, e){
                        //@see content.js for this function
                        self.dispatchEditorKeyup(ed, e, keyTime);
                        this.save();
                    });

                    ed.addButton('spellcheckbtn', {
                        icon: true,
                        image: websiteUrl+'plugins/leads/web/images/spellcheck.ico',
                        tooltip: _.isUndefined(i18n['How do I enable spell-check in SeoToaster?'])?'How do I enable spell-check in SeoToaster?':i18n['How do I enable spell-check in SeoToaster?'],
                        onclick: function() {
                            window.open('https://www.seotoaster.com/questions-and-answers/crm-faq#lead-spellchecker', '_blank');
                        }
                    });
                }
            });

            self.initMmsPicturesUploader({'fileSize': 5, 'fileUploads': 1});

            return this;
        },
        initMmsPicturesUploader: function(allowedUploadData) {
            this.uploadedFiles = [];
            this.uploadedFilesOriginalNames = [];
            this.maxUploadedFiles = 0;

            var options = {
                runtimes: 'html5,flash,html4',
                browse_button: 'upload-mms-button',
                container: 'uploader-mms-images-block',
                rename         : true,
                max_file_size  : allowedUploadData.fileSize+'mb',
                max_file_count : allowedUploadData.fileUploads,
                url: $('#website_url').val()+'api/emailtrigger/emailtriggermms/',
                multipart_params: {
                    secureToken: $('#email-sequence-grid-token').val(),
                },
                multi_selection: false,
                unique_names: false,
            };

            if(_.isUndefined(this.mmsPicturesUploader)) {

                this.mmsPicturesUploader = new plupload.Uploader(options);

                this.mmsPicturesUploader.init();

                this.mmsPicturesUploader.bind('BeforeUpload', _.bind(this.beforeUpload, this));
                this.mmsPicturesUploader.bind('FilesAdded', _.bind(this.filesAdded, this));
                this.mmsPicturesUploader.bind('UploadProgress', _.bind(this.uploadProgress, this));
                this.mmsPicturesUploader.bind('FileUploaded', _.bind(this.fileUploaded, this));
                this.mmsPicturesUploader.bind('Error', _.bind(this.handleUploadErrors, this));
                this.mmsPicturesUploader.bind('UploadComplete', _.bind(this.uploadComplete, this));
            }
        },
        beforeUpload: function(up, file) {
            if(this.maxUploadedFiles >= 10) {
                var extraАile = up.getFile(file.id);
                up.removeFile(extraАile);
                up.stop();
                showMessage((_.isUndefined(i18n['Messages can include up to 10 media files!']) ? 'Messages can include up to 10 media files!' : i18n['Messages can include up to 10 media files!']), true, 500);
            }
        },
        filesAdded: function(up, files) {
            var failedFilesUploadAdditionalFiltered = [];

            if(files.length) {
                _.each(this.failedFilesUploadAdditional, function (fileName, key) {
                    _.each(files, function (fileN, k) {
                        if(fileN.id == key) {
                            failedFilesUploadAdditionalFiltered.push(fileName);
                        }
                    });

                });

                if(failedFilesUploadAdditionalFiltered.length) {
                    this.failedFilesUploadAdditional = failedFilesUploadAdditionalFiltered;
                } else {
                    this.failedFilesUploadAdditional = {};
                }
            }

            this.mmsPicturesUploader.settings.multipart_params.multipleFiles = 0;
            if(files.length > 1) {
                this.mmsPicturesUploader.settings.multipart_params.multipleFiles = 1;
            }
            this.mmsPicturesUploader.settings.multipart_params.generalFileSize = $('.uploaded-mms-size-count').text();
            this.mmsPicturesUploader.settings.multipart_params.secureToken = $('#email-sequence-grid-token').val();
            this.failedFilesUpload = [];
            this.mmsPicturesUploader.start();
        },
        uploadProgress: function(up, file) {

        },
        fileUploaded: function(up, file, info) {
            var response = jQuery.parseJSON(info.response),
                self = this;

            if (response.error == '0') {
                var fileEl = '<li><span class="grid_11">'+ file.name +'</span><a class="ticon-remove error icon14 alpha grid_1 delete-uploaded-mms-file" data-role="delete" data-file-name="'+ response.fileStoredName +'" data-file-size="'+ file.size +'" href="javascript:;"></a></li>';

                $('#lead-mms-media-files-list').append(fileEl);
                $('.uploaded-mms-size-count').text(parseFloat(response.generalFileSize.toFixed(2)));

                self.uploadedFiles.push(response.fileStoredName);
                self.uploadedFilesOriginalNames.push(response.fileNameOriginal);
                self.maxUploadedFiles +=1;

            } else {
                var errorMessage = '';
                if(typeof response.fileName !== 'undefined' && response.fileName != '') {
                    if  (typeof(response.message) == 'object') {
                        for (var i in response.message) {
                            errorMessage += '<li>'+response.message[i]+'</li>';
                        }
                    } else {
                        errorMessage += '<li> ' + (_.isUndefined(i18n['File']) ? 'File' : i18n['File']) + ' \'' + response.fileName + '\' (' + response.message + ')'+'</li>';
                    }
                }

                if(response.type = 'mmsMaxSize') {
                    if(errorMessage != '') {
                        errorMessage + '</br>' + response.message;
                    } else {
                        errorMessage = response.message;
                    }
                }

                self.failedFilesUpload.push(errorMessage);
            }
        },
        handleUploadErrors: function(up, err) {
            var errorMessage = '<li> ' + (_.isUndefined(i18n['File']) ? 'File' : i18n['File']) + ' \'' + (err.file ? err.file.name : "") + '\' (' + err.message + ')'+'</li>';
            this.failedFilesUploadAdditional[err.file.id] = errorMessage;
        },
        uploadComplete: function(up, files) {
            if(files.length) {
                if(this.failedFilesUploadAdditional.length) {
                    var msg = _.isUndefined(i18n['Files uploaded']) ? 'Files uploaded' : i18n['Files uploaded'];
                    msg += ' </br>' +(_.isUndefined(i18n['Except:']) ? 'Except:' : i18n['Except:']) + '</br>';
                    msg += '<ul>';
                    _.each(this.failedFilesUploadAdditional, function (fileName, key) {
                        msg += fileName;
                    });

                    if(this.failedFilesUpload.length) {
                        _.each(this.failedFilesUpload, function (fileName, key) {
                            msg += fileName;
                        });
                    }
                    msg += '</ul>';
                    showMessage(msg, true, 500);
                } else {
                    if(this.failedFilesUpload.length) {
                        if(up.files.length == this.failedFilesUpload.length) {
                            if(up.files.length > 1) {
                                var msg = (_.isUndefined(i18n['Files not uploaded.']) ? 'Files not uploaded.' : i18n['Files not uploaded.']) + '</br>';
                            } else {
                                var msg = (_.isUndefined(i18n['File not uploaded.']) ? 'File not uploaded.' : i18n['File not uploaded.']) + '</br>';
                            }

                            msg += '<ul>';
                            _.each(this.failedFilesUpload, function (fileName, key) {
                                msg += fileName;
                            });
                            msg += '</ul>';

                            showMessage(msg, true, 500);
                        } else if (up.files.length > this.failedFilesUpload.length) {
                            var msg = _.isUndefined(i18n['Files uploaded']) ? 'Files uploaded' : i18n['Files uploaded'];
                            msg += ' </br>' +(_.isUndefined(i18n['Except:']) ? 'Except:' : i18n['Except:']) + '</br>';
                            msg += '<ul>';
                            _.each(this.failedFilesUpload, function (fileName, key) {
                                msg += fileName;
                            });
                            msg += '</ul>';
                            showMessage(msg, true, 500);
                        }
                    } else {
                        showMessage(_.isUndefined(i18n['Files uploaded']) ? 'Files uploaded' : i18n['Files uploaded'], false, 500);
                    }
                }

                this.failedFilesUploadAdditional = {};
                this.mmsPicturesUploader.splice();
            }
        },
        deleteUploadedMmsFile: function (e) {
            e.preventDefault();
            var el = $(e.currentTarget),
                fileName = el.data('file-name'),
                fileSize = el.data('file-size'),
                self = this;

            showConfirm(_.isUndefined(i18n['Are you sure want to delete an uploaded file?'])?'Are you sure want to delete an uploaded file?':i18n['Are you sure want to delete an uploaded file?'], function(){
                $.ajax({
                    'url': $('#website_url').val()+'api/emailtrigger/emailtriggermms/fileName/'+fileName+'/fileSize/'+fileSize+'/generalFileSize/'+$('.uploaded-mms-size-count').text(),
                    'type':'DELETE',
                    'dataType':'json'
                }).done(function(response){
                    if (response.error === 1) {
                        showMessage(response.message, true, 5000);
                    } else {
                        showMessage(response.message, false, 3000);
                        _.each(self.uploadedFiles, function (fileName, key) {
                            if(fileName == response.deletedFile) {
                                self.uploadedFiles.splice(key, 1);
                                self.uploadedFilesOriginalNames.splice(key, 1);
                                var elToDelete = $('#lead-mms-media-files-list').find("[data-file-name='" + fileName + "']");
                                if(elToDelete.length) {
                                    $(elToDelete).closest('li').remove();
                                }
                                var generalFileSize = parseFloat(response.generalFileSize.toFixed(2));
                                self.maxUploadedFiles -= 1;
                                $('.uploaded-mms-size-count').text(generalFileSize);
                            }
                        });
                    }
                });
            });
        },
        dispatchEditorKeyup: function(editor, event, keyTime) {
            var keyTimer = keyTime;
            if(keyTimer === null) {
                keyTimer = setTimeout(function() {
                    keyTimer = null;
                }, 1000)
            }
        },
        initProduct: function () {
            this.model = new ProductModel();

            this.model.on('sync', function(){
                if (this.model.has('options')){
                    this.model.get('options').on('add', this.renderOption, this);
                    this.model.get('options').on('reset', this.renderOptions, this);
                }

                if (this.products !== null){
                    this.products.pager();
                }
                this.render();
                showMessage(_.isUndefined(i18n['Product saved. Go to your search engine optimized product landing page here.'])?'Product saved. Go to your search engine optimized product landing page here.':i18n['Product saved. Go to your search engine optimized product landing page here.']);
            }, this);
            this.model.on('error', this.processSaveError, this);
            this.model.get('options').on('add', this.renderOption, this);
            this.model.get('options').on('reset', this.renderOptions, this);
            return this;
        },
        initProducts: function(){
            if (this.products === null || _.isUndefined(this.products)) {
                this.products = new ProductsCollection();
                this.products.bind('add', this.renderProduct, this);
                this.products.bind('reset', this.renderProducts, this);
            }
            return this.products;
        },
        renderProduct: function(product){
            var productView = new ProductListView({model: product});

            this.$('#product-list-holder').append(productView.render().el);
            if (_.has(this.products, 'checked') && _.contains(this.products.checked, product.get('id'))){
                productView.$el.find('input.marker').prop('checked', true);
            }
        },
        chooseCartStatus: function(e)
        {
            var chosenStatus = $(e.currentTarget).val();
            if (chosenStatus === 'no_cart') {
                $('#productsRulePrepare').addClass('hidden');
                $('#productsRule').addClass('hidden');
                $('#cart-status-products-block').addClass('hidden');
                $('#sequence-only').prop('checked', true);
                $('.no-cart-description').removeClass('hidden');
            } else {
                $('#productsRulePrepare').removeClass('hidden');
                $('#productsRule').removeClass('hidden');
                $('#cart-status-products-block').removeClass('hidden');
                $('#sequence-only').prop('checked', false);
                $('.no-cart-description').addClass('hidden');
            }
        },
        renderProducts: function(){
            if (this.products.length){
                this.$('#product-list-holder').empty();
                this.products.each(this.renderProduct, this);
                var paginatorData = {
                    collection : 'products',
                    cssClass: 'mt5px'
                };
                paginatorData = _.extend(paginatorData, this.products.info());

                paginatorData.i18n = i18n;
                $('div.paginator', '#product-list').replaceWith(_.template(ProductPaginatorTemplate,  paginatorData));
            } else {
                $('#product-list-holder').html('<p class="nothing">'+$('#product-list-holder').data('emptymsg')+'</p>');
            }
        },
        markProducts: function (e) {
            var checked = [],
                checkedProductInfo = [],
                url = $('#website_url').val(),
                img = url + '/system/images/noimage.png',
                pid = 0;

                checked = _.has(this.products, 'checked') ? this.products.checked : [],
                checkedProductInfo = _.has(this.products, 'checkedProductInfo') ? this.products.checkedProductInfo : [],
                pid = parseInt(e.currentTarget.value);

            if (e.currentTarget.checked) {
                checked = _.union(checked, pid);

                if(checkedProductInfo.length) {
                    var checkedProductInfoTmp = checkedProductInfo;
                    _.each(checkedProductInfoTmp, function(productInfo, key){
                        if(pid == productInfo.pid) {
                            checkedProductInfoTmp.splice(key, 1);
                        }
                    });

                    checkedProductInfo = checkedProductInfoTmp;
                }

                checkedProductInfo = _.union(checkedProductInfo, {'pid': pid, 'img': e.target.dataset.imageUrl, 'alt': e.target.dataset.altImg});
            } else {
                checked = _.without(checked, pid);
            }

            this.products.checked = checked;
            this.products.checkedProductInfo = checkedProductInfo;
        },
        toggleList: function(e) {
            e.preventDefault();
            var self = this;
            this.initSearchIndex();
            $('.productlisting').find('input').prop('checked', false);

            self.products.checked = [];

            if(typeof self.products.checkedSavedProducts !== 'undefined') {
                var checkedProductInfo = [];
                _.each(self.products.checkedSavedProducts, function(productId, key){
                    self.products.checked = _.union(self.products.checked, productId);
                    $("a[data-pid=" + productId + "]").closest('.productlisting').find('input').prop('checked', true);

                    _.each(self.products.checkedProductInfo, function(prod, k){
                        if(productId == prod.pid) {
                            checkedProductInfo = _.union(checkedProductInfo, self.products.checkedProductInfo[k]);
                        }
                    });
                });

                self.products.checkedProductInfo = checkedProductInfo;
            } else {
                self.products.checkedProductInfo = [];
            }

            var listtype = $(e.currentTarget).data('listtype');

            $('#product-list').show('slide');
            $('#product-list-holder').data('type', listtype);
            if (this.products === null) {
                $('#product-list-holder').html('<div class="spinner"></div>');
                return this.initProducts().pager();
            }

        },
        hideProductList: function(){
            $('#product-list').hide('slide');
            //$('.productsIds').val('');
            var term = $.trim($('#product-list-search').val());
            if (term != this.products.key){
                if (term == ''){
                    $('#product-list-search').trigger('keypress', true);
                } else {
                    $('#product-list-search').val(this.products.key);
                }
            }
        },
        massAction: function() {
            var checked = [],
                checkedProductInfo = [],
                url = $('#website_url').val(),
                img = url + '/system/images/noimage.png';

            checked = _.has(this.products, 'checked') ? this.products.checked : [],
            checkedProductInfo = _.has(this.products, 'checkedProductInfo') ? this.products.checkedProductInfo : [];

            $('#checked-product-images').empty();

            if(checked.length && checkedProductInfo.length) {
                _.each(checked, function(productId){
                    _.each(checkedProductInfo, function(productInfo, key){
                        if(productId == productInfo.pid) {
                            $('#checked-product-images').append('<span class="productChekedImage productChekedImage-' + productInfo.pid +
                                '"><img src="' + productInfo.img + '" alt="' + productInfo.alt + '" title="' + productInfo.alt + '" /></span>');
                        }
                    });
                });
            }

            this.products.checkedSavedProducts = this.products.checked;
            $('.productsIds').val(this.products.checkedSavedProducts);
            $('#product-list').hide('slide');
            $('#checked-product-images').show();

            return false;
        },
        initSearchIndex: _.once(function(){
            $.getJSON($('#website_url').val() + '/plugin/shopping/run/searchindex', function(response){
                self.searchIndex = response;
                $('#product-list-search').autocomplete({
                    minLength: 2,
                    source: response,
                    select: function(event, ui){
                        $('#product-list-search').val(ui.item.value).trigger('keypress', true);
                    }
                });
            });
        }),
        paginatorAction:  function(e){
            var page = $(e.currentTarget).data('page');
            var collection = $(e.currentTarget).parent('.paginator').data('collection');
            if (!collection) return false;
            if (_.has(this, collection)){
                collection = this[collection];
            }

            switch (page) {
                case 'first':
                    collection.goTo(collection.firstPage);
                    break;
                case 'prev':
                    if (collection instanceof Backbone.Paginator.requestPager){
                        collection.requestPreviousPage();
                    } else {
                        collection.previousPage();
                    }
                    break;
                case 'next':
                    if (collection instanceof Backbone.Paginator.requestPager){
                        collection.requestNextPage();
                    } else {
                        collection.nextPage();
                    }
                    break;
                case 'last':
                    collection.goTo(collection.totalPages);
                    break;
                default:
                    var pageId = parseInt(page);
                    !_.isNaN(pageId) && collection.goTo(pageId);
                    break;
            }
            return false;
        },
        filterProducts: function(e, forceRun) {
            if (e.keyCode === 13 || forceRun === true) {
                $('#product-list-holder').html('<div class="spinner"></div>');
                this.products.key = e.currentTarget.value;
                this.products.goTo(this.products.firstPage);
                $(e.target).autocomplete('close');
            }
        },
        productAction:function(e){
            e.preventDefault();
            $(e.currentTarget).closest('.productlisting').find('.marker').trigger('click');

        },
        changedRule:function(e){
            var rules = $(e.currentTarget).val();
            if(rules == 'with'){
                $('#productsRule').show();
                $('.prodInfoLabel').show();
                $('.show-list').show();
                $('#checked-product-images').show();
            }else{
                $('#productsRule').hide();
                $('.prodInfoLabel').hide();
                $('.show-list').hide();
                $('#checked-product-images').hide();
            }

        },
        switchAnalyzeSubscribedUsers: function(e)
        {
            e.preventDefault();
            var self = this,
                analyzeSubscribe = 0;

            if ($(e.currentTarget).is(':checked')) {
                analyzeSubscribe = 1;
            }

            $.ajax({
                'url' : $('#website_url').val()+'/plugin/emailsequence/run/switchAnalyzeSubscribedUsers/',
                'type': 'POST',
                'data': {
                    'secureToken':$('#email-sequence-grid-token').val(),
                    'analyzeSubscribe': analyzeSubscribe
                },
                'dataType' : 'json'
            }).done(function(response){

            });

        },
        submit: function(e){
            e.preventDefault();
            var self = this,
                form = $(e.currentTarget),
                isValid = true;

            _.each(form.find('.required'), function(el){
                if (!$(el).val()){
                    isValid = false;
                }
            });

            if (!isValid){
                showMessage(_.isUndefined(i18n['Missing required field'])?'Missing required field':i18n['Missing required field'], true);
                return false;
            }

            if ($('#cart-status').val() === 'no_cart' && !$('#sequence-only').is(':checked')) {
                showMessage(_.isUndefined(i18n['You can use "No Cart" status only with Sequence only'])?'You can use "No Cart" status only with Sequence only':i18n['You can use "No Cart" status only with Sequence only'], true, 5000);
                return false;
            }

            if ($('#sequence-only').is(':checked') && $('#sequence-trigger-name').val() == '') {
                showMessage(_.isUndefined(i18n['Please provide a name for email sequence trigger'])?'Please provide a name for email sequence trigger':i18n['Please provide a name for email sequence trigger'], true, 5000);
                return false;
            }

            showSpinner();
            var data = this.$el.serialize(),
                period = $('#period').val(),
                cartStatus  = $('#cart-status').val(),
                productsRulePrepare = $('#productsRulePrepare').val(),
                productsRule = $('#productsRule').val(),
                emailTemplate = $('.emailTemplate').val(),
                emailFrom = $('#emailFrom').val(),
                emailFromLabel = $('#emailFromLabel').val(),
                emailMessage = $('#emailMessage').val(),
                productsIds = $('.productsIds').val(),
                secureToken = $('#email-sequence-grid-token').val(),
                cartId = $('#cartId').val(),
                schedulePeriodType = $('input.schedule-period-type:checked').val(),
                lagType = $('#lag-type').val(),
                sequenceOnlyStatus = $('#sequence-only').is(':checked'),
                sequenceOnly = 0,
                triggerName = $('#sequence-trigger-name').val(),
                schedulePeriod = [],
                subject = $('#subject').val(),
                preheader = $('#preheader').val(),
                triggerTabType = $('#trigger-tab-type').val(),
                smsMessage = $('#smsMessage').val();

            if (productsRulePrepare == 'without') {
                productsRule = productsRulePrepare;
            }

            if (sequenceOnlyStatus) {
                sequenceOnly = 1;
            }

            $.each($("input.schedule-period:checked"), function() {
                schedulePeriod.push($(this).val());
            });

            if (_.isEmpty(schedulePeriod)) {
                showMessage(_.isUndefined(i18n['Please choose at least one day of the week'])?'Please choose at least one day of the week':i18n['Please choose at least one day of the week'], true, 5000);
                hideSpinner();
                return false;
            }

            var mediaFiles = '';
            var mediaFilesOriginalNames = '';
            if(!$('.mms-images-block').hasClass('hide') && this.uploadedFiles.length) {
                var uploadedFiles = this.uploadedFiles.join(',');
                mediaFiles = uploadedFiles;

                var uploadedFilesOriginalNames = this.uploadedFilesOriginalNames.join(',');
                mediaFilesOriginalNames = uploadedFilesOriginalNames;
            }

            $.ajax({
                url: this.$el.attr('action'),
                data: {
                    period:            period,
                    cartStatus:        cartStatus,
                    productsRule:      productsRule,
                    emailTemplate:     emailTemplate,
                    emailFrom:         emailFrom,
                    emailFromLabel:    emailFromLabel,
                    emailMessage:      emailMessage,
                    productsIds:       productsIds,
                    secureToken:       secureToken,
                    cartId:            cartId,
                    schedulePeriod:    schedulePeriod,
                    schedulePeriodType:schedulePeriodType,
                    lagType:           lagType,
                    sequenceOnly:      sequenceOnly,
                    triggerName:       triggerName,
                    subject:           subject,
                    preheader:         preheader,
                    type:              triggerTabType,
                    smsMessage:        smsMessage,
                    mediaFiles:        mediaFiles,
                    mediaFilesOriginalNames: mediaFilesOriginalNames,
                },
                type: 'POST',
                dataType: 'json'
            }).done(function(response) {
                    if(response.error == 1) {
                        hideSpinner();
                        showMessage(response.responseText, true);
                    } else {
                        self.$el.trigger('reset');
                        self.$el.trigger('EmailTriggerForm:created');
                        $('.productsIds').val('');
                        $('#cartId').val('');
                        $('.productChekedImage').remove();
                        $('#productsRule').show();
                        $('.prodInfoLabel').show();
                        $('.show-list').show();
                        $('input.marker').attr('checked', false);
                        $('#productsRulePrepare').removeClass('hidden');
                        $('#productsRule').removeClass('hidden');
                        $('#cart-status-products-block').removeClass('hidden');
                        hideSpinner();
                        self.uploadedFiles = [];
                        self.uploadedFilesOriginalNames = [];
                        self.maxUploadedFiles = 0;
                        $('#lead-mms-media-files-list').empty();
                        $('.uploaded-mms-size-count').text('0');
                        showMessage(_.isUndefined(i18n['Saved'])?'Saved':i18n['Saved']);
                    }

            }).fail(function(response){
                    hideSpinner();
                    showMessage(response.responseText, true);
            });

        },
        testStatusEmail: function(e)
        {
            e.preventDefault();
            var data = this.$el.serialize(),
                period = $('#period').val(),
                cartStatus  = $('#cart-status').val(),
                productsRulePrepare = $('#productsRulePrepare').val(),
                productsRule = $('#productsRule').val(),
                emailTemplate = $('.emailTemplate').val(),
                emailFrom = $('#emailFrom').val(),
                emailFromLabel = $('#emailFromLabel').val(),
                emailMessage = $('#emailMessage').val(),
                productsIds = $('.productsIds').val(),
                secureToken = $('#email-sequence-grid-token').val(),
                cartId = $('#cartId').val(),
                schedulePeriodType = $('input.schedule-period-type:checked').val(),
                lagType = $('#lag-type').val(),
                sequenceOnlyStatus = $('#sequence-only').is(':checked'),
                sequenceOnly = 0,
                triggerName = $('#sequence-trigger-name').val(),
                schedulePeriod = [],
                subject = $('#subject').val(),
                preheader = $('#preheader').val(),
                triggerTabType = $('#trigger-tab-type').val(),
                smsMessage = $('#smsMessage').val();


            if (productsRulePrepare == 'without') {
                productsRule = productsRulePrepare;
            }

            if (sequenceOnlyStatus) {
                sequenceOnly = 1;
            }

            $.each($("input.schedule-period:checked"), function() {
                schedulePeriod.push($(this).val());
            });

            //showConfirm(_.isUndefined(i18n['Are you sure you want to send test notification?'])?'Are you sure you want to send test notification?':i18n['Are you sure you want to send test notification?'], function() {
                $.ajax({
                    'url': $('#website_url').val()+'plugin/emailsequence/run/testStatusEmail/',
                    'data': {
                        period:            period,
                        cartStatus:        cartStatus,
                        productsRule:      productsRule,
                        emailTemplate:     emailTemplate,
                        emailFrom:         emailFrom,
                        emailFromLabel:    emailFromLabel,
                        emailMessage:      emailMessage,
                        productsIds:       productsIds,
                        secureToken:       secureToken,
                        cartId:            cartId,
                        schedulePeriod:    schedulePeriod,
                        schedulePeriodType:schedulePeriodType,
                        lagType:           lagType,
                        sequenceOnly:      sequenceOnly,
                        triggerName:       triggerName,
                        subject:           subject,
                        preheader:         preheader,
                        type:              triggerTabType,
                        smsMessage:        smsMessage
                    },
                    'type' : 'POST',
                    'dataType': 'json'
                }).done(function(response){
                    if (response.error == '1') {
                        showMessage(response.responseText, true, 5000);
                    } else {
                        showMessage(response.responseText, false, 5000);
                    }
                });
            //});
        },
        validate: function(e){
            var el = $(e.currentTarget);
        },
        changeEmailTemplatePreview: function(e)
        {
            var el = $(e.currentTarget),
                templateName =  el.val();

            if (templateName == '0') {
                $('#trigger-email-template').removeClass('grid_4').addClass('grid_6');
                $('#email-message-preview-link').addClass('hidden');
                $('.actionmails').addClass('hidden');
                return false;
            } else {
                $('.actionmails').removeClass('hidden');
            }

            $.ajax({
                'url': $('#website_url').val()+'plugin/emailsequence/run/getEmailTemplateInfo/',
                'data': {
                    'templateName': templateName
                },
                'type' : 'POST',
                'dataType': 'json'
            }).done(function(response){
                if (response.error == '1') {
                    showMessage(response.responseText, true, 5000);
                } else {
                    if (response.responseText.templateInfo.url != null) {
                        $('#trigger-email-template').removeClass('grid_6').addClass('grid_4');
                        $('#email-message-preview-link').prop('href', $('#website_url').val()+response.responseText.templateInfo.url).removeClass('hidden');
                    } else {
                        $('#email-message-preview-link').addClass('hidden');
                        $('#trigger-email-template').removeClass('grid_4').addClass('grid_6');
                    }
                }
            });
        }

    });

    return EmailTriggerFormView;
});
