CREATE TABLE IF NOT EXISTS `plugin_cartstatusemail_settings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cartStatus` VARCHAR(255) DEFAULT NULL COLLATE 'utf8_unicode_ci',
  `type` ENUM('email', 'sms') NOT NULL DEFAULT 'email',
  `period` int(4) unsigned NOT NULL,
  `productsIds` VARCHAR(255) DEFAULT NULL COLLATE 'utf8_unicode_ci',
  `emailTemplate` VARCHAR(255) DEFAULT NULL COLLATE 'utf8_unicode_ci',
  `emailFrom` VARCHAR(255) DEFAULT NULL COLLATE 'utf8_unicode_ci',
  `emailFromLabel` TEXT DEFAULT NULL COLLATE 'utf8_unicode_ci' COMMENT 'Email from label',
  `productsRule` ENUM('all', 'any', 'without') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'all',
  `emailMessage` TEXT DEFAULT NULL COLLATE 'utf8_unicode_ci',
  `schedulePeriod` SET('sunday', 'monday', 'tuesday', 'wednesday', 'thursday', 'friday', 'saturday') NOT NULL,
  `schedulePeriodType` ENUM('operation_hours', 'anytime') DEFAULT 'anytime',
  `lagType` ENUM('hour', 'day', 'month') DEFAULT 'hour',
  `sequenceOnly` ENUM('0', '1') DEFAULT '0',
  `triggerName` VARCHAR(255) DEFAULT NULL,
  `subject` VARCHAR (255) DEFAULT NULL COLLATE 'utf8_unicode_ci',
  `preheader` TEXT COLLATE utf8_unicode_ci COMMENT 'Email preheader text is a small line of text that appears after the subject line in an email inbox.',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `plugin_cartstatusemail_queue` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cartStatusId` int(10) NOT NULL,
  `status` ENUM('0', '1', '2') COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `cartStatus` VARCHAR(255) DEFAULT NULL COLLATE 'utf8_unicode_ci',
  `cartId` int(10) NOT NULL,
  `type` ENUM('email', 'sms') NOT NULL DEFAULT 'email',
  `userEmail` VARCHAR(255) DEFAULT NULL COLLATE 'utf8_unicode_ci',
  `userFullName` VARCHAR(255) DEFAULT NULL COLLATE 'utf8_unicode_ci',
  `userPhoneNumber` VARCHAR(100) DEFAULT NULL COLLATE 'utf8_unicode_ci',
  `emailMessage` TEXT DEFAULT NULL COLLATE 'utf8_unicode_ci',
  `emailTemplate` VARCHAR(255) DEFAULT NULL COLLATE 'utf8_unicode_ci',
  `emailFrom` VARCHAR(255) DEFAULT NULL COLLATE 'utf8_unicode_ci',
  `emailFromLabel` TEXT DEFAULT NULL COLLATE 'utf8_unicode_ci' COMMENT 'Email from label',
  `sentAt` DATETIME DEFAULT NULL,
  `delayDelivery` ENUM('0', '1') DEFAULT '0',
  `delayedTo` DATETIME DEFAULT NULL,
  `externalId` INT(10) UNSIGNED DEFAULT NULL,
  `sequence_id` INT(10) UNSIGNED DEFAULT NULL,
  `externalType` VARCHAR (255) DEFAULT NULL COLLATE 'utf8_unicode_ci',
  `subject` VARCHAR (255) DEFAULT NULL COLLATE 'utf8_unicode_ci',
  `preheader` TEXT COLLATE utf8_unicode_ci COMMENT 'Email preheader text is a small line of text that appears after the subject line in an email inbox.',
  PRIMARY KEY (`id`),
  INDEX `externalId` (`externalId`),
  INDEX `sequence_id` (`sequence_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `plugin_cartstatusemail_restored_cart`(
`id` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
`cart_id` INT(10) UNSIGNED NOT NULL COMMENT 'Restored cart id',
`sent_at` DATETIME NOT NULL COMMENT 'sent link date',
`restored_at` DATETIME NOT NULL COMMENT 'restored cart date',
`code` CHAR(40) NOT NULL COMMENT 'Hash for restore cart link',
`user_id` INT(10) UNSIGNED NOT NULL COMMENT 'System user id',
`cart_status` VARCHAR(255) NOT NULL COMMENT 'Cart status',
PRIMARY KEY(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_cartstatusemail_subscribe`(
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `user_id` INT(10) UNSIGNED NOT NULL,
  `code` CHAR(40) NOT NULL COMMENT 'Hash for unsubscribe link',
  `status` ENUM('subscribed', 'unsubscribed') NOT NULL DEFAULT 'subscribed',
  `unsubscribed_at` TIMESTAMP NULL,
  `external` ENUM('0', '1') DEFAULT '0',
  `external_email` VARCHAR (255) DEFAULT NULL COLLATE 'utf8_unicode_ci',
  PRIMARY KEY(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_cartstatusemail_subscribe_sms`(
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `user_id` INT(10) UNSIGNED NOT NULL,
  `code` CHAR(40) NOT NULL COMMENT 'Hash for unsubscribe link',
  `status` ENUM('subscribed', 'unsubscribed') NOT NULL DEFAULT 'subscribed',
  `unsubscribed_at` TIMESTAMP NULL,
  `external` ENUM('0', '1') DEFAULT '0',
  `external_email` VARCHAR (255) DEFAULT NULL COLLATE 'utf8_unicode_ci',
  `mobile_number` VARCHAR(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_emailsequence_settings` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `sequence_name` VARCHAR(255) NOT NULL COLLATE 'utf8_unicode_ci',
  `archive` ENUM('0', '1') DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE (`sequence_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_emailsequence_triggers` (
  `sequence_settings_id` INT(10) UNSIGNED NOT NULL,
  `trigger_id` INT(10) UNSIGNED NOT NULL,
  `trigger_enabled` ENUM('0', '1') DEFAULT '0',
  PRIMARY KEY (`sequence_settings_id`, `trigger_id`),
  FOREIGN KEY (`sequence_settings_id`) REFERENCES `plugin_emailsequence_settings`(`id`) ON DELETE CASCADE ON UPDATE NO ACTION,
  FOREIGN KEY (`trigger_id`) REFERENCES `plugin_cartstatusemail_settings`(`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

UPDATE `email_triggers` SET `email_triggers`.`trigger_name` = REPLACE(`email_triggers`.`trigger_name`, 'cartstatusemail_', 'emailsequence_');
UPDATE `email_triggers` SET `email_triggers`.`observer` = REPLACE(`email_triggers`.`observer`, 'Cartstatusemail_Tools_CartstatusemailMailWatchdog', 'Tools_EmailsequenceMailWatchdog');

INSERT IGNORE INTO `email_triggers` (`id`, `enabled`, `trigger_name`, `observer`)
SELECT CONCAT(NULL), CONCAT('1'), CONCAT('emailsequence_abandoned'), CONCAT('Tools_EmailsequenceMailWatchdog') FROM email_triggers WHERE
NOT EXISTS (SELECT `id`, `enabled`, `trigger_name`, `observer` FROM `email_triggers`
WHERE `enabled` = '1' AND `trigger_name` = 'emailsequence_abandoned' AND `observer` = 'Tools_EmailsequenceMailWatchdog') LIMIT 1;

INSERT IGNORE INTO `email_triggers` (`id`, `enabled`, `trigger_name`, `observer`)
SELECT CONCAT(NULL), CONCAT('1'), CONCAT('emailsequence_newquote'), CONCAT('Tools_EmailsequenceMailWatchdog') FROM email_triggers WHERE
NOT EXISTS (SELECT `id`, `enabled`, `trigger_name`, `observer` FROM `email_triggers`
WHERE `enabled` = '1' AND `trigger_name` = 'emailsequence_newquote' AND `observer` = 'Tools_EmailsequenceMailWatchdog') LIMIT 1;

INSERT IGNORE INTO `email_triggers` (`id`, `enabled`, `trigger_name`, `observer`)
SELECT CONCAT(NULL), CONCAT('1'), CONCAT('emailsequence_quotesent'), CONCAT('Tools_EmailsequenceMailWatchdog') FROM email_triggers WHERE
NOT EXISTS (SELECT `id`, `enabled`, `trigger_name`, `observer` FROM `email_triggers`
WHERE `enabled` = '1' AND `trigger_name` = 'emailsequence_quotesent' AND `observer` = 'Tools_EmailsequenceMailWatchdog') LIMIT 1;

INSERT IGNORE INTO `email_triggers` (`id`, `enabled`, `trigger_name`, `observer`)
SELECT CONCAT(NULL), CONCAT('1'), CONCAT('emailsequence_paymentreceived'), CONCAT('Tools_EmailsequenceMailWatchdog') FROM email_triggers WHERE
NOT EXISTS (SELECT `id`, `enabled`, `trigger_name`, `observer` FROM `email_triggers`
WHERE `enabled` = '1' AND `trigger_name` = 'emailsequence_paymentreceived' AND `observer` = 'Tools_EmailsequenceMailWatchdog') LIMIT 1;

INSERT IGNORE INTO `email_triggers` (`id`, `enabled`, `trigger_name`, `observer`)
SELECT CONCAT(NULL), CONCAT('1'), CONCAT('emailsequence_itemsshipped'), CONCAT('Tools_EmailsequenceMailWatchdog') FROM email_triggers WHERE
NOT EXISTS (SELECT `id`, `enabled`, `trigger_name`, `observer` FROM `email_triggers`
WHERE `enabled` = '1' AND `trigger_name` = 'emailsequence_itemsshipped' AND `observer` = 'Tools_EmailsequenceMailWatchdog') LIMIT 1;

INSERT IGNORE INTO `email_triggers` (`id`, `enabled`, `trigger_name`, `observer`)
SELECT CONCAT(NULL), CONCAT('1'), CONCAT('emailsequence_itemsdelivered'), CONCAT('Tools_EmailsequenceMailWatchdog') FROM email_triggers WHERE
NOT EXISTS (SELECT `id`, `enabled`, `trigger_name`, `observer` FROM `email_triggers`
WHERE `enabled` = '1' AND `trigger_name` = 'emailsequence_itemsdelivered' AND `observer` = 'Tools_EmailsequenceMailWatchdog') LIMIT 1;

INSERT IGNORE INTO `email_triggers` (`id`, `enabled`, `trigger_name`, `observer`)
SELECT CONCAT(NULL), CONCAT('1'), CONCAT('emailsequence_refundedpurchase'), CONCAT('Tools_EmailsequenceMailWatchdog') FROM email_triggers WHERE
NOT EXISTS (SELECT `id`, `enabled`, `trigger_name`, `observer` FROM `email_triggers`
WHERE `enabled` = '1' AND `trigger_name` = 'emailsequence_refundedpurchase' AND `observer` = 'Tools_EmailsequenceMailWatchdog') LIMIT 1;

INSERT IGNORE INTO `email_triggers` (`id`, `enabled`, `trigger_name`, `observer`)
SELECT CONCAT(NULL), CONCAT('1'), CONCAT('emailsequence_actionrequire'), CONCAT('Tools_EmailsequenceMailWatchdog') FROM email_triggers WHERE
NOT EXISTS (SELECT `id`, `enabled`, `trigger_name`, `observer` FROM `email_triggers`
WHERE `enabled` = '1' AND `trigger_name` = 'emailsequence_actionrequire' AND `observer` = 'Tools_EmailsequenceMailWatchdog') LIMIT 1;

INSERT IGNORE INTO `email_triggers` (`id`, `enabled`, `trigger_name`, `observer`)
SELECT CONCAT(NULL), CONCAT('1'), CONCAT('emailsequence_technicalprocessing'), CONCAT('Tools_EmailsequenceMailWatchdog') FROM email_triggers WHERE
NOT EXISTS (SELECT `id`, `enabled`, `trigger_name`, `observer` FROM `email_triggers`
WHERE `enabled` = '1' AND `trigger_name` = 'emailsequence_technicalprocessing' AND `observer` = 'Tools_EmailsequenceMailWatchdog') LIMIT 1;

INSERT IGNORE INTO `email_triggers` (`id`, `enabled`, `trigger_name`, `observer`)
SELECT CONCAT(NULL), CONCAT('1'), CONCAT('emailsequence_lostopportunity'), CONCAT('Tools_EmailsequenceMailWatchdog') FROM email_triggers WHERE
NOT EXISTS (SELECT `id`, `enabled`, `trigger_name`, `observer` FROM `email_triggers`
WHERE `enabled` = '1' AND `trigger_name` = 'emailsequence_lostopportunity' AND `observer` = 'Tools_EmailsequenceMailWatchdog') LIMIT 1;

INSERT IGNORE INTO `email_triggers` (`id`, `enabled`, `trigger_name`, `observer`)
SELECT CONCAT(NULL), CONCAT('1'), CONCAT('emailsequence_nocart'), CONCAT('Tools_EmailsequenceMailWatchdog') FROM email_triggers WHERE
NOT EXISTS (SELECT `id`, `enabled`, `trigger_name`, `observer` FROM `email_triggers`
WHERE `enabled` = '1' AND `trigger_name` = 'emailsequence_nocart' AND `observer` = 'Tools_EmailsequenceMailWatchdog') LIMIT 1;

INSERT IGNORE INTO `email_triggers` (`id`, `enabled`, `trigger_name`, `observer`)
SELECT CONCAT(NULL), CONCAT('1'), CONCAT('emailsequence_unsubscribereport'), CONCAT('Tools_EmailsequenceMailWatchdog') FROM email_triggers WHERE
NOT EXISTS (SELECT `id`, `enabled`, `trigger_name`, `observer` FROM `email_triggers`
WHERE `enabled` = '1' AND `trigger_name` = 'emailsequence_unsubscribereport' AND `observer` = 'Tools_EmailsequenceMailWatchdog') LIMIT 1;

INSERT IGNORE INTO `email_triggers_actions` (`trigger`, `template`, `recipient`, `message`, `from`, `subject`)
SELECT CONCAT('emailsequence_abandoned'), CONCAT('default'), CONCAT('customer'), CONCAT('You’ve left something rather lovely in your shopping basket. {cart:basket} Ready to make it yours? Click here {cart:recovery}'), CONCAT('admin@example.com'), CONCAT('What’s that in your shopping basket? Do you see what we see?') FROM email_triggers_actions WHERE
NOT EXISTS (SELECT `trigger`, `template`, `recipient`, `message`, `from`, `subject` FROM `email_triggers_actions`
WHERE `trigger` = 'emailsequence_abandoned') LIMIT 1;

INSERT IGNORE INTO `email_triggers_actions` (`trigger`, `template`, `recipient`, `message`, `from`, `subject`)
SELECT CONCAT('emailsequence_quotesent'), CONCAT('default'), CONCAT('customer'), CONCAT('Don’t forget, you left something behind. To help you make up your mind, enjoy 15% off your quote when you call us at XXX XXX XXXX with coupon # Click here to view your private quote {cart:recovery} Hurry this offer ends on XX/XX/XXXX'), CONCAT('admin@example.com'), CONCAT('A little something to sweeten your day') FROM email_triggers_actions WHERE
NOT EXISTS (SELECT `trigger`, `template`, `recipient`, `message`, `from`, `subject` FROM `email_triggers_actions`
WHERE `trigger` = 'emailsequence_quotesent') LIMIT 1;

INSERT IGNORE INTO `email_triggers_actions` (`trigger`, `template`, `recipient`, `message`, `from`, `subject`)
SELECT CONCAT('emailsequence_paymentreceived'), CONCAT('default'), CONCAT('customer'), CONCAT('We wanted to thank you for your business with a free shipping voucher code for your next purchase. Next time you shop with us, please enter XXXXX in the promotional code field on the checkout page.'), CONCAT('admin@example.com'), CONCAT('Thank you for your payment') FROM email_triggers_actions WHERE
NOT EXISTS (SELECT `trigger`, `template`, `recipient`, `message`, `from`, `subject` FROM `email_triggers_actions`
WHERE `trigger` = 'emailsequence_paymentreceived') LIMIT 1;

CREATE TABLE IF NOT EXISTS `plugin_emailsequence_has_mms` (
    `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
    `sequence_id` INT(10) UNSIGNED NOT NULL,
    `mms_files` TEXT DEFAULT NULL COLLATE 'utf8_unicode_ci',
    `mms_files_original_names` MEDIUMTEXT DEFAULT NULL COLLATE 'utf8_unicode_ci',
    PRIMARY KEY(`id`),
    FOREIGN KEY(`sequence_id`) REFERENCES `plugin_cartstatusemail_settings` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

UPDATE `plugin` SET `status`='disabled' WHERE `name` = 'cartstatusemail';
UPDATE `plugin` SET `tags`='cartstatusemail' WHERE `name` = 'emailsequence';
UPDATE `plugin` SET `version` = '2.3.0' WHERE `name` = 'emailsequence';
