#!/usr/bin/env php
<?php

if (PHP_SAPI !== 'cli') {
    //TODO enable before relise
    die('direct access is not allowed');
}

/*if (!extension_loaded('imap')) {
    die('To use this functional you must have php imap extension installed');
}*/
/*************************************************************************
 * Necessary alter for pcre.backtrack_limit
 *
 ************************************************************************/
ini_set('pcre.backtrack_limit', '10000000000000');

ini_set('session.cookie_httponly', 1);

/*************************************************************************
 * Installation check
 *
 ************************************************************************/
//error_reporting(E_ALL | E_STRICT);

/*************************************************************************
 * Reading current core config
 *
 *************************************************************************/
$coreConfigPath = realpath(__DIR__.'/../../../../system/coreinfo.php');
if (file_exists($coreConfigPath)) {
    require_once realpath($coreConfigPath);
}
defined('CORE') || define('CORE', realpath(__DIR__.'/../../../../seotoaster_core/'));
defined('SITE_NAME') || define('SITE_NAME', '');

/* End reading current core config */

// Define path to application directory
defined('APPLICATION_PATH')
|| define('APPLICATION_PATH', CORE . 'application');

// Define application environment
defined('APPLICATION_ENV')
|| define('APPLICATION_ENV', (getenv('APPLICATION_ENV') ? getenv('APPLICATION_ENV') : 'testing'));

// header to prevent security issues in iframes (to avoid clickjacking attacks)
//header('X-Frame-Options: SAMEORIGIN');

// Ensure library/ is on include_path
set_include_path(
    implode(
        PATH_SEPARATOR,
        array(
            realpath(APPLICATION_PATH . '/../library'),
            get_include_path(),
        )
    )
);

/** Zend_Application */
require_once 'Zend/Application.php';

$application = new Zend_Application(
    APPLICATION_ENV,
    APPLICATION_PATH . '/configs/' . SITE_NAME . '.ini'
);

if (Zend_Registry::isRegistered('session')) {
    $session = Zend_Registry::get('session');
    $session->unLock();
    Zend_Session_Namespace::resetSingleInstance('toaster_' . SITE_NAME);
}

set_include_path(realpath(APPLICATION_PATH . '/app') . PATH_SEPARATOR . get_include_path());

$configIni = new Zend_Config_Ini(APPLICATION_PATH . '/configs/' . SITE_NAME . '.ini');
Zend_Registry::set('website', $configIni->website->website->toArray());
Zend_Registry::set('database', $configIni->database->database->toArray());
Zend_Registry::set('theme', $configIni->theme->theme->toArray());
Zend_Registry::set('news', $configIni->news->news->toArray());
Zend_Registry::set('misc', $configIni->misc->misc->toArray());

$autoloader = Zend_Loader_Autoloader::getInstance();
$autoloader->registerNamespace('Widgets_');
$autoloader->registerNamespace('MagicSpaces_');
$autoloader->registerNamespace('Interfaces_');
$autoloader->registerNamespace('Helpers_');
$autoloader->registerNamespace('Exceptions_');
$autoloader->registerNamespace('Tools_');
$autoloader->registerNamespace('Plugins_');
$autoloader->registerNamespace('Api_');
$autoloader->setFallbackAutoloader(true);

$session = new Zend_Session_Namespace('toaster_' . SITE_NAME, true);
Zend_Registry::set('session', $session);


$websiteConfig = $configIni->website->website->toArray();

Zend_Controller_Action_HelperBroker::addHelper(new Helpers_Action_Session());
Zend_Controller_Action_HelperBroker::addHelper(new Helpers_Action_Admin());
Zend_Controller_Action_HelperBroker::addHelper(new Helpers_Action_Response());
Zend_Controller_Action_HelperBroker::addHelper(new Helpers_Action_Language());
Zend_Controller_Action_HelperBroker::addHelper(new Helpers_Action_Mobile());
Zend_Controller_Action_HelperBroker::addHelper(new Helpers_Action_Website());


$dbConfig = $configIni->database->database->toArray();
$adapter = strtolower($dbConfig['adapter']);
if (!in_array($adapter, array('pdo_mysql', 'mysqli'))) {
    if (extension_loaded('pdo_mysql')) {
        $adapter = 'pdo_mysql';
    } elseif (extension_loaded('mysqli')) {
        $adapter = 'mysqli';
    } else {

    }
}
if ($adapter === 'pdo_mysql') {
    $dbConfig['params']['driver_options'] = array(
        PDO::MYSQL_ATTR_INIT_COMMAND => 'SET NAMES UTF8;',
        PDO::MYSQL_ATTR_USE_BUFFERED_QUERY => true
    );
}
$database = Zend_Db::factory($adapter, $dbConfig['params']);
if ($adapter === 'mysqli') {
    $database->query('SET NAMES UTF8');
    $database->query('SET CHARACTER SET utf8');
}
Zend_Db_Table_Abstract::setDefaultAdapter($database);
Zend_Registry::set('dbAdapter', $database);


$config = Application_Model_Mappers_ConfigMapper::getInstance()->getConfig();
$name = Zend_Locale::getLocaleToTerritory($config['language']);
if ($name !== null) {
    $locale = new Zend_Locale($name);
} else {
    $locale = new Zend_Locale();
}

Zend_Registry::set('Zend_Locale', $locale);


$session = Zend_Registry::get('session');

$locale = (isset($session->locale)) ? $session->locale : Zend_Registry::get('Zend_Locale');

$session->locale = $locale;

$translator = new Zend_Translate(array(
    'adapter' => 'array',
    'content' => $websiteConfig['path'] . 'system/languages/',
    'scan' => Zend_Translate::LOCALE_FILENAME,
    'locale' => $locale->getLanguage(),
    'ignore' => array('.'),
    'route' => array('fr' => 'en', 'it' => 'en', 'de' => 'en')
));

//		Zend_Form::setDefaultTranslator($translator);
Zend_Registry::set('Zend_Locale', $locale);
Zend_Registry::set('Zend_Translate', $translator);
Zend_Registry::set('session', $session);


$view = new Zend_View();
$website = Zend_Registry::get('website');
$misc = Zend_Registry::get('misc');
$url = preg_replace('~^https?://~', '', $website['url']);
$request = new Zend_Controller_Request_Http();
$protocol = $request->getScheme();

$view->addHelperPath('ZendX/JQuery/View/Helper/', 'ZendX_JQuery_View_Helper');
if ($misc['jquery'] == 'local') {
    $view->jQuery()->setLocalPath($protocol . '://' . $url . 'system/js/external/jquery/jquery.js');
} else {
    $view->jQuery()
        ->setCdnSsl($request->isSecure())
        ->setVersion($misc['jqversion']);
}
if ($misc['jqueryui'] == 'local') {
    $view->jQuery()->setUiLocalPath($protocol . '://' . $url . 'system/js/external/jquery/jquery-ui.js');
} else {
    $view->jQuery()->setUiVersion($misc['jquversion']);
}

$viewRenderer = new Zend_Controller_Action_Helper_ViewRenderer($view);
Zend_Controller_Action_HelperBroker::addHelper($viewRenderer);


$routesXmlPath = is_file(
    APPLICATION_PATH . '/configs/' . SITE_NAME . '.routes.xml'
) ? APPLICATION_PATH . '/configs/' . SITE_NAME . '.routes.xml' : APPLICATION_PATH . '/configs/routes.xml';
$routes = new Zend_Config_Xml($routesXmlPath);
$router = Zend_Controller_Front::getInstance()->getRouter();
$router->addConfig($routes, 'routes');

/*$application->bootstrap()
    ->run();*/

$acl = new Zend_Acl();

// roles: member, user, admin, super admin
$acl->addRole(new Zend_Acl_Role(Tools_Security_Acl::ROLE_GUEST));
$acl->addRole(new Zend_Acl_Role(Tools_Security_Acl::ROLE_MEMBER), Tools_Security_Acl::ROLE_GUEST);
$acl->addRole(new Zend_Acl_Role(Tools_Security_Acl::ROLE_USER), Tools_Security_Acl::ROLE_MEMBER);
$acl->addRole(new Zend_Acl_Role(Tools_Security_Acl::ROLE_ADMIN));
$acl->addRole(new Zend_Acl_Role(Tools_Security_Acl::ROLE_SUPERADMIN));

//resources
$acl->addResource(new Zend_Acl_Resource(Tools_Security_Acl::RESOURCE_CONTENT));
$acl->addResource(new Zend_Acl_Resource(Tools_Security_Acl::RESOURCE_WIDGETS));
$acl->addResource(new Zend_Acl_Resource(Tools_Security_Acl::RESOURCE_PAGE_PROTECTED));
$acl->addResource(new Zend_Acl_Resource(Tools_Security_Acl::RESOURCE_PAGE_PUBLIC));
$acl->addResource(new Zend_Acl_Resource(Tools_Security_Acl::RESOURCE_CACHE_PAGE));
$acl->addResource(new Zend_Acl_Resource(Tools_Security_Acl::RESOURCE_CODE));
$acl->addResource(new Zend_Acl_Resource(Tools_Security_Acl::RESOURCE_THEMES));
//resources of admin area
$acl->addResource(new Zend_Acl_Resource(Tools_Security_Acl::RESOURCE_ADMINPANEL));
$acl->addResource(new Zend_Acl_Resource(Tools_Security_Acl::RESOURCE_PAGES));
$acl->addResource(new Zend_Acl_Resource(Tools_Security_Acl::RESOURCE_MEDIA));
$acl->addResource(new Zend_Acl_Resource(Tools_Security_Acl::RESOURCE_SEO));
$acl->addResource(new Zend_Acl_Resource(Tools_Security_Acl::RESOURCE_LAYOUT));
$acl->addResource(new Zend_Acl_Resource(Tools_Security_Acl::RESOURCE_CONFIG));
$acl->addResource(new Zend_Acl_Resource(Tools_Security_Acl::RESOURCE_USERS));
$acl->addResource(new Zend_Acl_Resource(Tools_Security_Acl::RESOURCE_PLUGINS));
$acl->addResource(new Zend_Acl_Resource(Tools_Security_Acl::RESOURCE_PLUGINS_MENU));

//permissions
$acl->allow(Tools_Security_Acl::ROLE_GUEST, Tools_Security_Acl::RESOURCE_PAGE_PUBLIC);
$acl->allow(Tools_Security_Acl::ROLE_GUEST, Tools_Security_Acl::RESOURCE_CACHE_PAGE);

$acl->deny(Tools_Security_Acl::ROLE_MEMBER, Tools_Security_Acl::RESOURCE_CACHE_PAGE);
$acl->allow(Tools_Security_Acl::ROLE_MEMBER, Tools_Security_Acl::RESOURCE_PAGE_PROTECTED);
$acl->allow(Tools_Security_Acl::ROLE_MEMBER, Tools_Security_Acl::RESOURCE_ADMINPANEL);
$acl->allow(Tools_Security_Acl::ROLE_MEMBER, Tools_Security_Acl::RESOURCE_PLUGINS_MENU);

//user = copywriter
$acl->allow(Tools_Security_Acl::ROLE_USER, Tools_Security_Acl::RESOURCE_PLUGINS);
$acl->allow(Tools_Security_Acl::ROLE_USER, Tools_Security_Acl::RESOURCE_ADMINPANEL);
$acl->allow(Tools_Security_Acl::ROLE_USER, Tools_Security_Acl::RESOURCE_CONTENT);
$acl->allow(Tools_Security_Acl::ROLE_USER, Tools_Security_Acl::RESOURCE_MEDIA);
$acl->allow(Tools_Security_Acl::ROLE_USER, Tools_Security_Acl::RESOURCE_PAGES);
$acl->allow(Tools_Security_Acl::ROLE_USER, Tools_Security_Acl::RESOURCE_THEMES);

$acl->allow(Tools_Security_Acl::ROLE_ADMIN);
$acl->deny(Tools_Security_Acl::ROLE_ADMIN, Tools_Security_Acl::RESOURCE_CODE);
$acl->deny(Tools_Security_Acl::ROLE_ADMIN, Tools_Security_Acl::RESOURCE_CACHE_PAGE);

$acl->allow(Tools_Security_Acl::ROLE_SUPERADMIN);
$acl->deny(Tools_Security_Acl::ROLE_SUPERADMIN, Tools_Security_Acl::RESOURCE_CACHE_PAGE);

Zend_Registry::set('acl', $acl);


$_SERVER['DOCUMENT_ROOT'] = rtrim($websiteConfig['path'], "/");
$_SERVER['SCRIPT_FILENAME'] = $websiteConfig['path'] . 'index.php';
$_SERVER['HTTP_HOST'] = '';
$_SERVER['SCRIPT_NAME'] = '/index.php';
$_SERVER['QUERY_STRING'] = '';
$_SERVER['SERVER_NAME'] = '';
$_SERVER['HTTP_HOST'] = rtrim($websiteConfig['url'], '/');
$_SERVER['HTTP_ORIGIN'] = 'http://' . $_SERVER['HTTP_HOST'];
$_SERVER['REMOTE_ADDR'] = '127.0.0.1';


Zend_Controller_Front::getInstance()->registerPlugin(new Plugins_Plugin());
Zend_Controller_Front::getInstance()->setRequest($request);
Zend_Controller_Front::getInstance()->setResponse(new Zend_Controller_Response_Http());

//
$websiteConfig = $configIni->website->website->toArray();
$cacheFrontendOptions = $configIni->cache->cache->frontend->toArray();
$cacheBackendOptions = $configIni->cache->cache->backend->toArray();
$cacheBackendOptions['cache_dir'] = $websiteConfig['path'] .'plugins'.DIRECTORY_SEPARATOR.'emailsequence'.DIRECTORY_SEPARATOR.'workflowCache'.DIRECTORY_SEPARATOR;
$cache = Zend_Cache::factory('Core', 'File', $cacheFrontendOptions, $cacheBackendOptions);
Zend_Db_Table_Abstract::setDefaultMetadataCache($cache);
Zend_Registry::set('cache', $cache);

$cacheHelper = new Helpers_Action_Cache();
$cacheHelper->init();
Zend_Controller_Action_HelperBroker::addHelper($cacheHelper);

$pageHelper = new Helpers_Action_Page();
$pageHelper->init();
Zend_Controller_Action_HelperBroker::addHelper($pageHelper);

$configHelper = new Helpers_Action_Config();
$configHelper->init();
Zend_Controller_Action_HelperBroker::addHelper($configHelper);

Zend_Layout::startMvc();
Zend_Layout::getMvcInstance()->getLayoutPath();

$filePath = $configIni->website->website->path;
$pluginIncludePath = array(
    '0' => realpath($filePath.'plugins/leads/system/app'),
    '1' => realpath($filePath.'plugins/shopping/system/app'),
    '2' => realpath($filePath.'plugins/apps/system/app'),
    '3' => realpath($filePath.'plugins/api/system/app'),
    '4' => realpath($filePath.'plugins/emailsequence/system/app')
);
set_include_path(implode(PATH_SEPARATOR, $pluginIncludePath) . PATH_SEPARATOR . get_include_path());


set_include_path(implode(PATH_SEPARATOR, array(
    $filePath . '/plugins/leads',
    $filePath . '/plugins/shopping',
    $filePath . '/plugins/apps',
    $filePath . '/plugins/api',
    $filePath . '/plugins/emailsequence',
    get_include_path()
)));

$observerQueue = array();
$observersDbTable = new Application_Model_DbTable_ObserversQueue();
$data = $observersDbTable->fetchAll()->toArray();
if (sizeof($data)) {
    foreach ($data as $row) {
        $observable = $row['observable'];
        $observer = $row['observer'];

        if (!array_key_exists($observable, $observerQueue)) {
            $observerQueue[$observable] = array();
        }

        array_push($observerQueue[$observable], $observer);
        unset($observable, $observer);
    }
}

Zend_Registry::set('observers_queue', $observerQueue);


/**
 *  Should use for plugin actions hook
 *
 *  $reflection = new Zend_Reflection_Class(ucfirst($name));
 */
$plugin = new Plugins_Plugin();
$plugin->routeStartup($request);


function prepareEmailTriggerName($cartStatus){
        switch ($cartStatus) {
            case Models_Model_CartSession::CART_STATUS_NEW:
                $emailTriggerName = Tools_EmailsequenceMailWatchdog::TRIGGER_CART_STATUS_ABANDONED;
                break;
            case Models_Model_CartSession::CART_STATUS_PENDING:
                $emailTriggerName = Tools_EmailsequenceMailWatchdog::TRIGGER_CART_STATUS_ACTION_REQUIRE;
                break;
            case Models_Model_CartSession::CART_STATUS_PROCESSING:
                $emailTriggerName = Tools_EmailsequenceMailWatchdog::TRIGGER_CART_STATUS_TECHNICAL_PROCESSING;
                break;
            case Models_Model_CartSession::CART_STATUS_COMPLETED:
                $emailTriggerName = Tools_EmailsequenceMailWatchdog::TRIGGER_CART_STATUS_PAYMENT_RECEIVED;
                break;
            case Models_Model_CartSession::CART_STATUS_SHIPPED:
                $emailTriggerName = Tools_EmailsequenceMailWatchdog::TRIGGER_CART_STATUS_ITEMS_SHIPPED;
                break;
            case Models_Model_CartSession::CART_STATUS_DELIVERED:
                $emailTriggerName = Tools_EmailsequenceMailWatchdog::TRIGGER_CART_STATUS_ITEMS_DELIVERED;
                break;
            case Models_Model_CartSession::CART_STATUS_REFUNDED:
                $emailTriggerName = Tools_EmailsequenceMailWatchdog::TRIGGER_CART_STATUS_REFUNDED_PURCHASE;
                break;
            case Tools_Misc::CS_ALIAS_PENDING:
                $emailTriggerName = Tools_EmailsequenceMailWatchdog::TRIGGER_CART_STATUS_NEWQUOTE;
                break;
            case Tools_Misc::CS_ALIAS_PROCESSING:
                $emailTriggerName = Tools_EmailsequenceMailWatchdog::TRIGGER_CART_STATUS_QUOTESENT;
                break;
            case Tools_Misc::CS_ALIAS_LOST_OPPORTUNITY:
                $emailTriggerName = Tools_EmailsequenceMailWatchdog::TRIGGER_CART_STATUS_LOST_OPPORTUNITY;
                break;
            default:
                $emailTriggerName = Tools_EmailsequenceMailWatchdog::TRIGGER_CART_STATUS_DEFAULT;
                break;
        }
        return $emailTriggerName;
    }

$cartStatusQueueMapper  = Emailsequence_Models_Mapper_EmailsequenceQueueMapper::getInstance();
$shoppingConfigMapper =  Models_Mapper_ShoppingConfig::getInstance();
$storeTimezone = $shoppingConfigMapper->getConfigParam('timezone');

$inTime = Tools_System_Tools::convertDateFromTimezone('now');
$emailsToSend = $cartStatusQueueMapper->getAllQueue(false, $inTime, true);

$websiteHelper = Zend_Controller_Action_HelperBroker::getExistingHelper('website');
$websiteUrl = $websiteHelper->getUrl();

$selectActiveActionEmailTriggers = $cartStatusQueueMapper->getDbtable()->select()->setIntegrityCheck(false)->from('email_triggers_actions', array('trigger', 'id'));
$activeActionEmailTriggers = $cartStatusQueueMapper->getDbTable()->getAdapter()->fetchAssoc($selectActiveActionEmailTriggers);
if(!empty($emailsToSend)){
    $cartStatusEmailSettingsMapper = Emailsequence_Models_Mapper_EmailTriggerSettingsMapper::getInstance();
    foreach($emailsToSend as $email){
        $cartStatusSettingsId = $email->getCartStatusId();
        $cartStatusEmailSettingsModel = $cartStatusEmailSettingsMapper->find($cartStatusSettingsId);
        if (!$cartStatusEmailSettingsModel instanceof Emailsequence_Models_Models_EmailTriggerSettingsModel) {
            continue;
        }
        $schedulePeriod = $cartStatusEmailSettingsModel->getSchedulePeriod();
        $schedulePeriodType = $cartStatusEmailSettingsModel->getSchedulePeriodType();
        $delayedDelivery = $email->getDelayDelivery();
        $sendEmailNow = true;
        if (!empty($schedulePeriod)) {
            $operationalHoursStoreConfig = $shoppingConfigMapper->getConfigParam('operationalHours');
            $serverTimezone = date_default_timezone_get();
            if (empty($serverTimezone)) {
                $serverTimezone = 'UTC';
            }

            $notSentAt = false;
            $toSendAt = Tools_System_Tools::convertDateFromTimezone('now', $serverTimezone, 'UTC');
            $toSendAt = date(Tools_System_Tools::DATE_MYSQL, strtotime($toSendAt .'+'.Tools_EmailSequenceTools::getTimezoneShift('UTC', $storeTimezone).'hours'));
            if (!empty($delayedDelivery)) {
                $toSendAt = date(Tools_System_Tools::DATE_MYSQL, strtotime($email->getDelayedTo() .'+'.Tools_EmailSequenceTools::getTimezoneShift('UTC', $storeTimezone).'hours'));
                $dateDayOfTheWeek = strtolower(Tools_System_Tools::convertDateFromTimezone('now', false, 'UTC', 'l'));
                $delayedDayOfTheWeek = strtolower(date('l', strtotime($email->getDelayedTo())));
                if ($dateDayOfTheWeek !== $delayedDayOfTheWeek) {
                    $notSentAt = true;
                }
            }
            $schedulePeriodDataSet = explode(',', $schedulePeriod);
            $currentDayOfTheWeek = strtolower(date('l', strtotime($toSendAt)));
            $currentHourOfTheWeek = intval(strtolower(date('H', strtotime($toSendAt))));
            $sendEmailNow = false;
            $delayTodayOfTheWeek = false;
            $deliveryDates = array();
            $excludeDayOfTheWeek = '';
            if (!empty($operationalHoursStoreConfig) && $schedulePeriodType === Emailsequence_Models_Models_EmailTriggerSettingsModel::SCHEDULE_PERIOD_TYPE_OPERATION_HOURS) {
                $operationalHoursStoreConfig = unserialize($operationalHoursStoreConfig);
            } else {
                $operationalHoursStoreConfig = array();
            }
            foreach ($schedulePeriodDataSet as $key => $dayOfTheWeek) {
                $nextDeliveryDate = strtotime("next ".$dayOfTheWeek, strtotime($toSendAt));
                if(($nextDeliveryDate > strtotime($toSendAt)) && empty($delayTodayOfTheWeek) && $currentDayOfTheWeek !== $dayOfTheWeek) {
                    if ($excludeDayOfTheWeek !== $dayOfTheWeek) {
                        $deliveryDates[$dayOfTheWeek] = $nextDeliveryDate;
                    }
                } elseif($currentDayOfTheWeek === $dayOfTheWeek && $notSentAt === false){
                    $deliveryDates[$dayOfTheWeek] = strtotime($toSendAt);
                }
                if ($currentDayOfTheWeek === $dayOfTheWeek && empty($operationalHoursStoreConfig)) {
                    $sendEmailNow = true;
                } elseif($currentDayOfTheWeek === $dayOfTheWeek && !empty($operationalHoursStoreConfig) && !empty($operationalHoursStoreConfig[$currentDayOfTheWeek])) {
                    if (empty($operationalHoursStoreConfig[$currentDayOfTheWeek]['from']) && empty($operationalHoursStoreConfig[$currentDayOfTheWeek]['to'])) {
                        $sendEmailNow = true;
                    } else {
                        if (!empty($operationalHoursStoreConfig[$currentDayOfTheWeek]['from'])) {
                            $sendFromHours = $operationalHoursStoreConfig[$currentDayOfTheWeek]['from'] - 1;
                        } else {
                            $sendFromHours = 0;
                        }

                        if (!empty($operationalHoursStoreConfig[$currentDayOfTheWeek]['to'])) {
                            $sendToHours = $operationalHoursStoreConfig[$currentDayOfTheWeek]['to'] - 1;
                        } else {
                            $sendToHours = 24;
                        }

                        if ($currentHourOfTheWeek >= $sendFromHours && $sendToHours >= $currentHourOfTheWeek) {
                            $sendEmailNow = true;
                            break;
                        } elseif ($currentHourOfTheWeek < $sendFromHours) {
                            $deliveryDates[$dayOfTheWeek] = strtotime(date('Y-m-d H:i:s', strtotime(date('Y-m-d', strtotime($toSendAt)). ' '.$sendFromHours.':00:00')));
                        }
                        else
                        {
                            $currentScheduleDateOfTheWeekId = array_search($dayOfTheWeek, $schedulePeriodDataSet);
                            if (!empty($schedulePeriodDataSet[$currentScheduleDateOfTheWeekId + 1])) {
                                $dayOfTheWeek = $schedulePeriodDataSet[$currentScheduleDateOfTheWeekId + 1];
                            }
                            $excludeDayOfTheWeek = $dayOfTheWeek;
                            $deliveryDates[$dayOfTheWeek] = strtotime("next ".$dayOfTheWeek. "+".$sendFromHours." hour", strtotime($toSendAt));
                        }
                    }
                } elseif($currentDayOfTheWeek !== $dayOfTheWeek && !empty($operationalHoursStoreConfig) && !empty($operationalHoursStoreConfig[$dayOfTheWeek])) {
                    if (!empty($operationalHoursStoreConfig[$dayOfTheWeek]['from']) || !empty($operationalHoursStoreConfig[$dayOfTheWeek]['to'])) {
                        if (!empty($operationalHoursStoreConfig[$dayOfTheWeek]['from'])) {
                            $sendFromHours = $operationalHoursStoreConfig[$dayOfTheWeek]['from'] - 1;
                        } else {
                            $sendFromHours = 0;
                        }
                        if (!empty($operationalHoursStoreConfig[$dayOfTheWeek]['to'])) {
                            $sendToHours = $operationalHoursStoreConfig[$dayOfTheWeek]['to'] - 1;
                        } else {
                            $sendToHours = 24;
                        }
                        $sendEmailNow = false;
                        if ($currentHourOfTheWeek > $sendFromHours && $sendToHours > $currentHourOfTheWeek) {

                        } elseif ($currentHourOfTheWeek < $sendFromHours) {
                            $deliveryDates[$dayOfTheWeek] =  strtotime("next ".$dayOfTheWeek. "+".$sendFromHours." hour", strtotime($toSendAt));
                        }
                        else
                        {
                            $excludeDayOfTheWeek = $dayOfTheWeek;
                            $deliveryDates[$dayOfTheWeek] = strtotime("next ".$dayOfTheWeek. "+".$sendFromHours." hour", strtotime($toSendAt));
                        }
                    }
                }
            }
            if (!empty($deliveryDates)) {
                $delayTodayOfTheWeek = date(Tools_System_Tools::DATE_MYSQL, min($deliveryDates));
            }
        }

        if ($sendEmailNow === true) {
            $subscribeMapper = Emailsequence_Models_Mapper_SubscribeMapper::getInstance();
            $subscriptionExists = $subscribeMapper->findByEmail($email->getUserEmail());

            if(empty($subscriptionExists)) {
                $subscriptionExists = $subscribeMapper->findByExternalLeadEmail($email->getUserEmail());
            }
            $unsubscribeCode = '';
            if (!empty($subscriptionExists)) {
                $unsubscribeCode = $subscriptionExists['code'];
            }
            $orderId = $email->getCartId();
            $cartStatus = $email->getCartStatus();
            if (in_array($cartStatus, Emailsequence::$cartStatuses)) {
                if (!Zend_Registry::isRegistered('postPurchaseCart')) {
                    $cart = Models_Mapper_CartSessionMapper::getInstance()->find(
                        $orderId
                    );
                    if ($cart instanceof Models_Model_CartSession) {
                        $productMapper = Models_Mapper_ProductMapper::getInstance();
                        $cartContent = $cart->getCartContent();
                        foreach ($cartContent as $key => $product) {
                            $productObject = $productMapper->find($product['product_id']);
                            if ($productObject instanceof Models_Model_Product) {
                                $cartContent[$key]['mpn'] = $productObject->getMpn();
                                $cartContent[$key]['photo'] = $productObject->getPhoto();
                                $cartContent[$key]['productUrl'] = $productObject->getPage()->getUrl();
                                $cartContent[$key]['taxRate'] = Tools_Tax_Tax::calculateProductTax($productObject,
                                    null, true);
                            }
                        }
                        $cart->setCartContent($cartContent);
                        $billingAddressId = $cart->getBillingAddressId();
                        if (null !== $billingAddressId) {
                            $cart->setBillingAddressId(Tools_ShoppingCart::getAddressById($billingAddressId));
                        }
                        $shippingAddressId = $cart->getShippingAddressId();
                        if (null !== $shippingAddressId) {
                            $cart->setShippingAddressId(Tools_ShoppingCart::getAddressById($shippingAddressId));
                        }

                    }
                    Zend_Registry::set('postPurchaseCart', $cart);
                    if ($cart instanceof Models_Model_CartSession && !Zend_Registry::isRegistered('postPurchasePickup') && $cart->getShippingService() === 'pickup') {
                        $pickupLocationConfigMapper = Store_Mapper_PickupLocationConfigMapper::getInstance();
                        $pickupLocationData = $pickupLocationConfigMapper->getCartPickupLocationByCartId($cart->getId());
                        if (empty($pickupLocationData)) {
                            $shoppingConfig = Models_Mapper_ShoppingConfig::getInstance()->getConfigParams();
                            $pickupLocationData = array(
                                'name' => $shoppingConfig['company'],
                                'address1' => $shoppingConfig['address1'],
                                'address2' => $shoppingConfig['address2'],
                                'country' => $shoppingConfig['country'],
                                'city' => $shoppingConfig['city'],
                                'state' => $shoppingConfig['state'],
                                'zip' => $shoppingConfig['zip'],
                                'phone' => $shoppingConfig['phone']
                            );
                        }
                        $pickupLocationData['map_link'] = 'https://maps.google.com/?q=' . $pickupLocationData['address1'] . '+' . $pickupLocationData['city'] . '+' . $pickupLocationData['state'];
                        $pickupLocationData['map_src'] = Tools_Geo::generateStaticGmaps($pickupLocationData,
                            640,
                            300);
                        Zend_Registry::set('postPurchasePickup', $pickupLocationData);
                    }
                }

                $orderModel = Models_Mapper_CartSessionMapper::getInstance()->find($orderId);
                $userId = 0;
                if ($orderModel instanceof Models_Model_CartSession) {
                    $userId = $orderModel->getUserId();
                }
            }

            $emailTriggerName = prepareEmailTriggerName($email->getCartStatus());
            if (!array_key_exists($emailTriggerName, $activeActionEmailTriggers)) {
                echo 'missing action email trigger';
            }

            $type = $email->getType();

            if($type == Emailsequence::SEQUENCE_TYPE_EMAIL) {
                if (in_array($cartStatus, Emailsequence::$cartStatuses)) {
                    $email->registerObserver(new Tools_Mail_Watchdog(array(
                        'trigger' => $emailTriggerName,
                        'unsubscribeCode' => $unsubscribeCode,
                        'userId' => $userId,
                        'cartStatus' => $cartStatus
                    )));
                } else {
                    $email->registerObserver(new Tools_Mail_Watchdog(array(
                        'trigger' => $emailTriggerName,
                        'unsubscribeCode' => $unsubscribeCode
                    )));
                }
                $email->notifyObservers();
            } else if($type == Emailsequence::SEQUENCE_TYPE_SMS) {
                $mobilePhoneUser = $email->getUserPhoneNumber();
                $message = strip_tags($email->getEmailMessage());

                $currentQueueData =  $cartStatusQueueMapper->find($email->getId());

                if($currentQueueData instanceof Emailsequence_Models_Models_EmailsequenceQueueModel) {
                    if(!$currentQueueData->getStatus() && !empty($mobilePhoneUser)) {
                        $isPluginEnabled = Tools_EmailSequenceTools::verifyPluginEnabled('leads');

                        if($isPluginEnabled) {
                            $userEmail =  $email->getUserEmail();
                            $leadData = Tools_LeadTools::getLeadModelByIdAndEmail(null, '', $userEmail);

                            if($leadData instanceof Leads_Model_LeadsModel) {
                                $message = Tools_EmailSequenceTools::addDictionarySmsFields($message, $leadData, $websiteUrl);
                            }

                            if(!$leadData instanceof Leads_Model_LeadsModel) {
                                $leadData = Tools_LeadTools::findLeadByPhoneMobileNumber($mobilePhoneUser, true);

                                if($leadData instanceof Leads_Model_LeadsModel) {
                                    $message = Tools_EmailSequenceTools::addDictionarySmsFields($message, $leadData, $websiteUrl);
                                }
                            }
                        }

                        $subscriber['subscriber']['admin'] = array(
                            'phone' => array($mobilePhoneUser),
                            'message' => $message,
                            'owner_type' => Apps::SMS_OWNER_TYPE_ADMIN,
                            'custom_params' => array(),
                            'sequence' => '1'
                        );

                        $mmsFiles = $cartStatusEmailSettingsMapper->getMmsBySequence($cartStatusSettingsId);

                        $mmsMediaFilesLinks = [];
                        if(!empty($mmsFiles['mmsFiles'])) {
                            $mmsMediaFiles = explode(',', $mmsFiles['mmsFiles']);

                            if(!empty($mmsMediaFiles) && is_array($mmsMediaFiles)) {
                                $mmsMediaFilesPath = Tools_EmailSequenceTools::getMmsDirectoryPath($cartStatusSettingsId, true);
                                if(!empty($mmsMediaFilesPath)) {
                                    foreach ($mmsMediaFiles as $key => $mFile) {
                                        $mmsMediaFilesLinks[$key] = $mmsMediaFilesPath . DIRECTORY_SEPARATOR . $mFile;
                                    }
                                    $subscriber['mediaUrl'] = $mmsMediaFilesLinks;
                                }
                            }
                        }

                        $response = Apps::apiCall('POST', 'apps', array('twilioSms'), $subscriber);

                        if($response['twilioSms']['done']) {
                            if ($leadData instanceof Leads_Model_LeadsModel) {
                                $leadId = $leadData->getId();
                                $actionType = Leads_Model_LeadsActionLogModel::ACTION_TYPE_OUTBOUND;
                                $createdAt = Tools_System_Tools::convertDateFromTimezone('now');

                                $actionLedLogModel = Tools_LeadTools::logLeadAction(
                                    $type,
                                    $leadId,
                                    $actionType,
                                    $createdAt,
                                    Leads_Model_LeadsTypeModel::LEAD_TYPE_OUTBOUND_SMS
                                );

                                $callLogMapper = Leads_Mapper_LeadsCallLogMapper::getInstance();
                                $callLogModel = new Leads_Model_LeadsCallLogModel();
                                $callLogModel->setActionLogId($actionLedLogModel->getId());
                                $callLogModel->setCreatorId(null);
                                $callLogModel->setType(Leads_Model_LeadsCallLogModel::TYPE_SMS);
                                $callLogModel->setStatus('completed');
                                $callLogModel->setScore('valid');
                                $callLogModel->setDetails($message);
                                $callLogModel->setLeadId($leadId);
                                $callLogModel->setIsVoip('0');
                                if(!empty($mmsMediaFilesLinks)) {
                                    $callLogModel->setIsMms('1');
                                }
                                $callLogModel->setCaller('');
                                $callLogModel->setReceiver($mobilePhoneUser);
                                $callLogModel->setTimestamp($createdAt);
                                $callLogMapper->save($callLogModel);
                            }
                            $cartStatusQueueMapper->updateQueueStatus($email->getId(), 1, true);
                        } else {
                            $cartStatusQueueMapper->updateQueueStatus($email->getId(), 2, true);
                            echo 'Fail!';
                        }
                    } else {
                        echo 'Mobile phone doesn\'t exist';

                    }
                } else {
                    echo 'Fail!';
                }
            } else {
                $email->registerObserver(new Tools_Mail_Watchdog(array(
                    'trigger' => $emailTriggerName,
                    'unsubscribeCode' => $unsubscribeCode
                )));

                $email->notifyObservers();
            }
        } else {
            $hoursShift = Tools_EmailSequenceTools::getTimezoneShift('UTC', $storeTimezone);
            if ($hoursShift > 0) {
                $hoursShift = ' -'. $hoursShift;
            } else {
                $hoursShift = ' +'.abs($hoursShift);
            }

            $delayTodayOfTheWeek = date(Tools_System_Tools::DATE_MYSQL, strtotime($delayTodayOfTheWeek.$hoursShift.'hours'));
            $cartStatusQueueMapper->updateQueueDelivery($email->getId(), '1', $delayTodayOfTheWeek);
        }
    }
    echo 'Done!';
}else{
    echo 'Fail!';
}

$cacheHelper->clean();








