<?php


class Emailsequence_Models_Models_EmailTriggerSettingsModel extends Application_Model_Models_Abstract
{

    const LAG_TYPE_HOUR = 'hour';

    const LAG_TYPE_DAY = 'day';

    const LAG_TYPE_MONTH = 'month';

    const SCHEDULE_PERIOD_TYPE_OPERATION_HOURS = 'operation_hours';

    const SCHEDULE_PERIOD_TYPE_ANYTIME = 'anytime';

    const SCHEDULE_PERIOD_SUNDAY = 'sunday';

    const SCHEDULE_PERIOD_MONDAY = 'monday';

    const SCHEDULE_PERIOD_TUESDAY = 'tuesday';

    const SCHEDULE_PERIOD_WEDNESDAY = 'wednesday';

    const SCHEDULE_PERIOD_THURSDAY = 'thursday';

    const SCHEDULE_PERIOD_FRIDAY = 'friday';

    const SCHEDULE_PERIOD_SATURDAY = 'saturday';

    /**
     * Existing lag types
     *
     * @var array
     */
    public static $_lagTypes = array(self::LAG_TYPE_HOUR, self::LAG_TYPE_DAY, self::LAG_TYPE_MONTH);

    /**
     * Existing period of types
     *
     * @var array
     */
    public static $_schedulePeriodTypes = array(
        self::SCHEDULE_PERIOD_TYPE_OPERATION_HOURS,
        self::SCHEDULE_PERIOD_TYPE_ANYTIME
    );

    /**
     * Schedule periods
     *
     * @var array
     */
    public static $_schedulePeriods = array(
        self::SCHEDULE_PERIOD_SUNDAY,
        self::SCHEDULE_PERIOD_MONDAY,
        self::SCHEDULE_PERIOD_TUESDAY,
        self::SCHEDULE_PERIOD_WEDNESDAY,
        self::SCHEDULE_PERIOD_THURSDAY,
        self::SCHEDULE_PERIOD_FRIDAY,
        self::SCHEDULE_PERIOD_SATURDAY
    );

    protected $_cartStatus = '';
    protected $_type = '';
    protected $_period = '';
    protected $_productsIds = '';
    protected $_emailTemplate = '';
    protected $_emailFrom = '';
    protected $_emailFromLabel = '';
    protected $_emailMessage = '';
    protected $_productsRule = '';
    protected $_schedulePeriod = '';
    protected $_lagType = '';
    protected $_sequenceOnly = '';
    protected $_triggerName = '';
    protected $_schedulePeriodType = '';
    protected $_subject = '';
    protected $_preheader = '';


    /**
     * @return string
     */
    public function getCartStatus()
    {
        return $this->_cartStatus;
    }

    /**
     * @param string $cartStatus
     * @return string
     */
    public function setCartStatus($cartStatus)
    {
        $this->_cartStatus = $cartStatus;

        return $this;
    }

    /**
     * @return string
     */
    public function getType()
    {
        return $this->_type;
    }

    /**
     * @param $type
     * @return string
     */
    public function setType($type)
    {
        $this->_type = $type;

        return $this;
    }

    /**
     * @return string
     */
    public function getPeriod()
    {
        return $this->_period;
    }

    /**
     * @param string $period
     * @return string
     */
    public function setPeriod($period)
    {
        $this->_period = $period;

        return $this;
    }

    /**
     * @return string
     */
    public function getProductsIds()
    {
        return $this->_productsIds;
    }

    /**
     * @param string $productsIds
     * @return string
     */
    public function setProductsIds($productsIds)
    {
        $this->_productsIds = $productsIds;

        return $this;
    }

    /**
     * @return string
     */
    public function getEmailTemplate()
    {
        return $this->_emailTemplate;
    }

    /**
     * @param string $emailTemplate
     * @return string
     */
    public function setEmailTemplate($emailTemplate)
    {
        $this->_emailTemplate = $emailTemplate;

        return $this;
    }

    /**
     * @return string
     */
    public function getEmailFrom()
    {
        return $this->_emailFrom;
    }

    /**
     * @param string $emailFrom
     * @return string
     */
    public function setEmailFrom($emailFrom)
    {
        $this->_emailFrom = $emailFrom;

        return $this;
    }

    /**
     * @return string
     */
    public function getEmailMessage()
    {
        return $this->_emailMessage;
    }

    /**
     * @param string $emailMessage
     * @return string
     */
    public function setEmailMessage($emailMessage)
    {
        $this->_emailMessage = $emailMessage;

        return $this;
    }

    /**
     * @return string
     */
    public function getProductsRule()
    {
        return $this->_productsRule;
    }

    /**
     * @param string $productsRule
     * @return string
     */
    public function setProductsRule($productsRule)
    {
        $this->_productsRule = $productsRule;

        return $this;
    }

    /**
     * @return string
     */
    public function getSchedulePeriod()
    {
        return $this->_schedulePeriod;
    }

    /**
     * @param string $schedulePeriod
     * @return string
     */
    public function setSchedulePeriod($schedulePeriod)
    {
        $this->_schedulePeriod = $schedulePeriod;

        return $this;
    }

    /**
     * @return string
     */
    public function getLagType()
    {
        return $this->_lagType;
    }

    /**
     * @param string $lagType
     * @return string
     */
    public function setLagType($lagType)
    {
        $this->_lagType = $lagType;

        return $this;
    }

    /**
     * @return string
     */
    public function getSequenceOnly()
    {
        return $this->_sequenceOnly;
    }

    /**
     * @param string $sequenceOnly
     * @return string
     */
    public function setSequenceOnly($sequenceOnly)
    {
        $this->_sequenceOnly = $sequenceOnly;

        return $this;
    }

    /**
     * @return string
     */
    public function getTriggerName()
    {
        return $this->_triggerName;
    }

    /**
     * @param string $triggerName
     * @return string
     */
    public function setTriggerName($triggerName)
    {
        $this->_triggerName = $triggerName;

        return $this;
    }

    /**
     * @return string
     */
    public function getSchedulePeriodType()
    {
        return $this->_schedulePeriodType;
    }

    /**
     * @param string $schedulePeriodType
     * @return string
     */
    public function setSchedulePeriodType($schedulePeriodType)
    {
        $this->_schedulePeriodType = $schedulePeriodType;

        return $this;
    }

    /**
     * @return string
     */
    public function getSubject()
    {
        return $this->_subject;
    }

    /**
     * @param string $subject
     * @return string
     */
    public function setSubject($subject)
    {
        $this->_subject = $subject;

        return $this;
    }

    /**
     * @return string
     */
    public function getPreheader()
    {
        return $this->_preheader;
    }

    /**
     * @param string $preheader
     */
    public function setPreheader($preheader)
    {
        $this->_preheader = $preheader;

        return $this;
    }

    /**
     * @return string
     */
    public function getEmailFromLabel()
    {
        return $this->_emailFromLabel;
    }

    /**
     * @param string $emailFromLabel
     */
    public function setEmailFromLabel($emailFromLabel)
    {
        $this->_emailFromLabel = $emailFromLabel;
    }


}

