<?php


class Emailsequence_Models_Mapper_EmailSequenceSettingsMapper extends Application_Model_Mappers_Abstract
{

    protected $_dbTable = 'Emailsequence_Models_Dbtables_EmailSequenceSettingsDbtable';

    protected $_model = 'Emailsequence_Models_Models_EmailSequenceSettingsModel';

    public function save($model)
    {
        if (!$model instanceof $this->_model) {
            throw new Exceptions_SeotoasterException('Given parameter should be ' . $this->_model . ' instance');
        }
        $data = array(
            'sequence_name' => $model->getSequenceName(),
            'archive' => $model->getArchive()
        );

        $id = $model->getId();
        if (!empty($id)) {
            $where = $this->getDbTable()->getAdapter()->quoteInto('id = ?', $id);
            $this->getDbTable()->update($data, $where);
        } else {
            $id = $this->getDbTable()->insert($data);
            $model->setId($id);
        }

        return $model;

    }

    /**
     * Get all email sequence names
     *
     * @param string $where SQL where clause
     * @param string $order OPTIONAL An SQL ORDER clause.
     * @param int $limit OPTIONAL An SQL LIMIT count.
     * @param int $offset OPTIONAL An SQL LIMIT offset.
     * @param bool $withoutCount flag to get with or without records quantity
     * @param bool $singleRecord flag fetch single record
     *
     * @return mixed
     * @throws Exception
     */
    public function getEmailSequenceList(
        $where = null,
        $order = null,
        $limit = null,
        $offset = null,
        $withoutCount = false,
        $singleRecord = false
    ) {
        $select = $this->getDbTable()->getAdapter()->select()->from('plugin_emailsequence_settings',
            array('id', 'sequence_name'))->order('sequence_name');
        if (!empty($order)) {
            $select->order($order);
        }

        if (!empty($where)) {
            $select->where($where);
        }

        $select->limit($limit, $offset);

        $data = $this->getDbTable()->getAdapter()->fetchAll($select);
        if ($withoutCount === false) {
            $select->reset(Zend_Db_Select::COLUMNS);
            $select->reset(Zend_Db_Select::FROM);
            $select->reset(Zend_Db_Select::LIMIT_OFFSET);
            $select->reset(Zend_Db_Select::LIMIT_COUNT);

            $count = array('count' => new Zend_Db_Expr('COUNT(id)'));
            $select->from(array('pld' => 'plugin_emailsequence_settings'), $count);

            $count = $this->getDbTable()->getAdapter()->fetchRow($select);

            return array(
                'totalRecords' => $count['count'],
                'data' => $data,
                'offset' => $offset,
                'limit' => $limit
            );
        } else {
            return $data;
        }

    }

    /**
     * Get all sequence names
     * @param string $where MySql where statement
     *
     * @return mixed
     * @throws Exception
     */
    public function getSequences($where = null)
    {

        $select = $this->getDbTable()->getAdapter()->select()->from('plugin_emailsequence_settings');

        if (!empty($where)) {
            $select->where($where);
        }

        return $this->getDbTable()->getAdapter()->fetchAll($select);
    }

    /**
     * Get all sequence pairs
     *
     * @param bool $notArchive
     * @return mixed
     * @throws Exception
     */
    public function getSequencesPairs($notArchive = false)
    {
        $where = '';
        if($notArchive === true) {
            $where = $this->getDbTable()->getAdapter()->quoteInto('archive = ?', '0');
        }

        $select = $this->getDbTable()->getAdapter()->select()->from('plugin_emailsequence_settings');

        if(!empty($where)) {
            $select->where($where);
        }

        return $this->getDbTable()->getAdapter()->fetchPairs($select);
    }

    /**
     * Get all archived sequence pairs
     *
     * @return mixed
     * @throws Exception
     */
    public function getArchivedSequences()
    {
        $where = $this->getDbTable()->getAdapter()->quoteInto('archive = ?', '1');

        $select = $this->getDbTable()->getAdapter()->select()->from('plugin_emailsequence_settings')->where($where);

        return $this->getDbTable()->getAdapter()->fetchPairs($select);
    }

    /**
     * Find by sequence name
     *
     * @param string $sequenceName sequence name
     * @throws Exception
     * @return
     */
    public function findBySequenceName($sequenceName)
    {
        $where = $this->getDbTable()->getAdapter()->quoteInto('sequence_name = ?', $sequenceName);

        return $this->_findWhere($where);

    }

    /**
     * Get all triggers
     * @param bool $sequenceOnly flag for sequence only triggers
     * @throws Exception
     */
    public function getAllTriggers($sequenceOnly = true)
    {
        $select = $this->getDbTable()->getAdapter()->select()->from('plugin_cartstatusemail_settings',
            array(
                'id',
                new Zend_Db_Expr("CONCAT(triggerName, ' (', type, ')')")));
        if ($sequenceOnly === true) {
            $where = $this->getDbTable()->getAdapter()->quoteInto('sequenceOnly = ?', '1');
            $select->where($where)->order('triggerName');
        }

        return $this->getDbTable()->getAdapter()->fetchPairs($select);
    }

    /**
     * Delete sequence
     *
     * @param int $id id
     * @throws Exception
     */
    public function deleteSequence($id)
    {
        $where = $this->getDbTable()->getAdapter()->quoteInto('id = ?', $id);
        $this->getDbTable()->getAdapter()->delete('plugin_emailsequence_settings', $where);
    }


}

