<?php

class Widgets_Dashboard_Dashboard extends Widgets_Abstract
{

    /**
     * Website helper
     *
     * @var null
     */
    protected $_websiteHelper = null;

    /**
     * @var bool
     */
    protected $_cacheable = false;

    /**
     * Session helper
     *
     * @var bool
     */
    protected $_sessionHelper = false;

    /**
     * @var null
     */
    protected $_layout = null;

    /**
     * Dashboard tabs labels
     *
     * @var string[]
     */
    protected $_tabLabels = array(
        'index' => 'Dashboard',
        'crmreports' => 'CRM reports',
        'opportunitiespipeline' => 'Opportunities Pipeline',
        'leads' => 'Leads',
        'organizations' => 'Organizations',
        'workflows' => 'Workflows',
        'tools' => 'Tools',
        'emailandsmsdrip' => 'Email & SMS Drip',
        'quotes' => 'Quotes',
        'clients' => 'Clients',
        'orders' => 'Orders',
        'onlinesalesreports' => 'Online sales reports',
        'products' => 'Products',
        'suppliers' => 'Suppliers',
        'manageusers' => 'Manage users',
        'sales' => 'Sales',
    );

    public static $originalLabels = array(
        'Online & POS Sales' => 'Online sales reports'
    );

    protected function _init()
    {
        parent::_init();
        $this->_view = new Zend_View(array(
            'scriptPath' => __DIR__ . '/views/'
        ));


        $this->_layout = new Zend_Layout();
        $this->_layout->setLayoutPath(Zend_Layout::getMvcInstance()->getLayoutPath());

        $this->_websiteHelper = Zend_Controller_Action_HelperBroker::getStaticHelper('website');
        $this->_view->websiteUrl = $this->_websiteHelper->getUrl();
        $this->_websiteUrl = $this->_websiteHelper->getUrl();
        $this->_translator = Zend_Registry::get('Zend_Translate');

        $this->_view->setHelperPath(APPLICATION_PATH . '/views/helpers/');
        $this->_view->addHelperPath('ZendX/JQuery/View/Helper/', 'ZendX_JQuery_View_Helper');
        $this->_view->addScriptPath($this->_websiteHelper->getPath() . 'seotoaster_core/application/views/scripts/');
        // init helpers
        $this->_configHelper = Zend_Controller_Action_HelperBroker::getStaticHelper('config');
        $this->_sessionHelper = Zend_Controller_Action_HelperBroker::getStaticHelper('session');
    }

    protected function _load()
    {
        if (empty($this->_options[0])) {
            return $this->_translator->translate('Option not specified');
        }
        $methodName = '_render' . ucfirst($this->_options[0]);
        if (method_exists($this, $methodName)) {
            return $this->$methodName();

        }

        return $this->_translator->translate('Method doesn\'t exists');
    }

    protected function _renderChecksession()
    {
        if (Tools_Security_Acl::isAllowed(Shopping::RESOURCE_STORE_MANAGEMENT)) {
            return $this->_view->render('session-expired.phtml');
        }
    }

    protected function _renderLogout()
    {
        if (Tools_Security_Acl::isAllowed(Shopping::RESOURCE_STORE_MANAGEMENT)) {
            $websiteUrl = Zend_Controller_Action_HelperBroker::getStaticHelper('website')->getUrl();
            $sessionHelper = Zend_Controller_Action_HelperBroker::getStaticHelper('session');
            $currentUser = $sessionHelper->getCurrentUser();
            $roleId = $currentUser->getRoleId();
            $this->_view->websiteUrl = $websiteUrl;
            $this->_view->roleId = $roleId;
            return $this->_view->render('logout.phtml');
        }
    }

    protected function _renderLoggedusername()
    {
        if (Tools_Security_Acl::isAllowed(Shopping::RESOURCE_STORE_MANAGEMENT)) {
            $sessionHelper = Zend_Controller_Action_HelperBroker::getStaticHelper('session');
            $currentUser = $sessionHelper->getCurrentUser();
            $fullName = $currentUser->getFullName();
            $this->_view->fullName = $fullName;
            return $this->_view->render('logged-user-name.phtml');
        }
    }

    protected function _renderUserrole()
    {
        if (Tools_Security_Acl::isAllowed(Shopping::RESOURCE_STORE_MANAGEMENT)) {
            $sessionHelper = Zend_Controller_Action_HelperBroker::getStaticHelper('session');
            $currentUser = $sessionHelper->getCurrentUser();
            $roleId = $currentUser->getRoleId();
            $this->_view->roleId = $roleId;
            return $this->_view->render('user-role.phtml');
        }
    }

    protected function _renderGotowebsite()
    {
        if (Tools_Security_Acl::isAllowed(Shopping::RESOURCE_STORE_MANAGEMENT)) {
            $websiteUrl = Zend_Controller_Action_HelperBroker::getStaticHelper('website')->getUrl();
            $this->_view->websiteUrl = $websiteUrl;
            return $this->_view->render('go-to-website.phtml');
        }
    }

    protected function _renderTakeatour()
    {
        $configData = Application_Model_Mappers_ConfigMapper::getInstance()->getConfig();
        $takeATour = $configData['takeATour'];

        if (Tools_Security_Acl::isAllowed(Shopping::RESOURCE_STORE_MANAGEMENT) && !empty($takeATour)) {
            $websiteUrl = Zend_Controller_Action_HelperBroker::getStaticHelper('website')->getUrl();
            $this->_view->websiteUrl = $websiteUrl;
            $uploadMaxSize = ini_get('upload_max_filesize');
            $this->_view->uploadMaxSize = !empty($uploadMaxSize) ? $uploadMaxSize : '';
            return $this->_view->render('take-a-tour.phtml');
        }
    }

    protected function _renderCssversion()
    {
        $options = $this->_options;
        $themeName = 'dashboard';
        if (!empty($options[1])) {
            $themeName = $options[1];
        }

        $scriptPath = $this->_websiteHelper->getPath() . 'plugins' . DIRECTORY_SEPARATOR . 'dashboard' . DIRECTORY_SEPARATOR . 'web' . DIRECTORY_SEPARATOR . 'themes' . DIRECTORY_SEPARATOR . $themeName . DIRECTORY_SEPARATOR . 'version.json';
        try {
            $versionData = file_get_contents($scriptPath);
            if ($versionData === false) {
                return '0';
            }
            $versionData = json_decode($versionData, 1);
            if (!empty($versionData['version'])) {
                return $versionData['version'];
            }
        } catch (Exception $e) {
            return '0';
        }


        return '0';
    }

    protected function _renderTabname()
    {
        $options = $this->_options;
        $tabOptionName = $options[1];

        if (empty($options[1])) {
           return '';
        }

        $tabLabel = '';
        if(!empty($this->_tabLabels[$tabOptionName])) {
            $tabLabel = $this->_tabLabels[$tabOptionName];
        }

        if($tabOptionName == 'onlinesalesreports') {
            $enableSeosambaPosPlugin = false;

            $enabledSeosambaPosPlugin = Application_Model_Mappers_PluginMapper::getInstance()->findByName('seosambapos');
            if ($enabledSeosambaPosPlugin != null) {
                if ($enabledSeosambaPosPlugin->getStatus() == Application_Model_Models_Plugin::ENABLED) {
                    $enableSeosambaPosPlugin = true;
                }
            }

            if($enableSeosambaPosPlugin) {
                $tabLabel = 'Online & POS Sales';
            }
        }

        return $tabLabel;
    }

    /**
     * Get original dashboard tab name
     *
     * @param $tabName
     * @return string
     */
    public static function getOriginalTabLabel($tabName)
    {
       if(!empty(self::$originalLabels[$tabName])) {
            return self::$originalLabels[$tabName];
       }

       return $tabName;
    }

}
