<?php
class MagicSpaces_Dashboardmenu_Dashboardmenu extends Tools_MagicSpaces_Abstract {

	protected function _run() {
		
        $content = $this->_spaceContent;
        $nameOfHtml = explode("\n",$content);
        $websiteUrl = Zend_Controller_Action_HelperBroker::getStaticHelper('website')->getUrl();
        $sessionHelper = Zend_Controller_Action_HelperBroker::getStaticHelper('session');
        $configHelper = Zend_Controller_Action_HelperBroker::getStaticHelper('config');
        $request = Zend_Controller_Front::getInstance()->getRequest();
        $requestUri = $request->getPathInfo();
        $pageNavName = preg_replace('~\/~', '', $requestUri);
        if($pageNavName != 'dashboard' && $pageNavName != ''){
            $pageNavName = str_replace('%20', ' ', preg_replace('~dashboard~', '', $pageNavName));
        }
        $translator = Zend_Registry::get('Zend_Translate');
        if(isset($nameOfHtml) && !empty($nameOfHtml)){
            $preparedLink = '<ul id="dashboard-list">';
            foreach($nameOfHtml as $htmlFile){
                $htmlFile = trim($htmlFile);
                $originalTabName = Widgets_Dashboard_Dashboard::getOriginalTabLabel($htmlFile);
                $htmlFileClear = str_replace(' ', '-', $originalTabName);

                if($htmlFile !='' && $htmlFile != 'index'){
                    if($pageNavName == $htmlFile){
                        $preparedLink .= '<li><a href="'.$websiteUrl.'dashboard/'.$originalTabName.'/" class="current dashboard-link-'.$htmlFile.' icon-'. $htmlFileClear .' tab-'. $htmlFileClear .'"><span>'.ucfirst($translator->translate($htmlFile)).'</span></a></li>';
                    }else{
                        $preparedLink .= '<li><a href="'.$websiteUrl.'dashboard/'.$originalTabName.'/" class="dashboard-link-'.$htmlFile.' icon-'. $htmlFileClear .' tab-'. $htmlFileClear .'"><span>'.ucfirst($translator->translate($htmlFile)).'</span></a></li>';
                    }
                }
                if($htmlFile !='' && $htmlFile == 'index'){
                    if($pageNavName == 'dashboard'){
                        $preparedLink .= '<li><a href="'.$websiteUrl.'dashboard/" class="current dashboard-link-'.$htmlFile.' icon-'. $htmlFileClear .' tab-'. $htmlFileClear .'"><span>'.ucfirst($translator->translate($htmlFile)).'</span></a></li>';
                    }else{
                        $preparedLink .= '<li><a href="'.$websiteUrl.'dashboard/" class="dashboard-link-'.$htmlFile.' icon-'. $htmlFileClear .' tab-'. $htmlFileClear .'"><span>'.ucfirst($translator->translate($htmlFile)).'</span></a></li>';
                    }
                }
                
            }

            $preparedLink .= '</ul>';
        }
        $this->_spaceContent = $preparedLink;
        return $this->_spaceContent;
	}

}
