# SeoToaster CMS & CRM Ultimate

[![PHP](https://img.shields.io/badge/PHP-7.4%20to%208.2-blue)](https://www.php.net/)
[![MySQL](https://img.shields.io/badge/MySQL-5.x%20%2F%208.x-orange)](https://www.mysql.com/)
[![License](https://img.shields.io/badge/License-GPLv3%20%2F%20Commercial-lightgrey)](https://www.seotoaster.com/seotoaster-license.html)

[SeoToaster](https://www.seotoaster.com/) is a flexible and powerful CMS developed by **SeoSamba** ([seosamba.com](https://www.seosamba.com/)) for building and managing websites efficiently.  

The **SeoToaster CRM Ultimate** is built on top of SeoToaster CMS & Ecommerce and adds advanced CRM features to automate sales and track leads, opportunities, and interactions with your brand.

---

## Table of Contents

- [About](#about)
- [Why SeoToaster CRM Ultimate?](#why-seotoaster-crm-ultimate)
- [Try SeoToaster CMS Demo Website](#try-the-seotoaster-cms-demo-website)
- [Minimum Requirements](#minimum-requirements)
- [Download](#download)
- [Installation](#installation)
- [Usage](#usage)
- [Development Environment](#development-environment)
- [Contributing](#contributing)
- [License](#license)
- [Contact](#contact)

---

## About

SeoToaster CMS is feature-rich and ideal for small to medium businesses:  

- Intuitive admin panel  
- SEO-friendly website structure  
- E-commerce capabilities  
- Modular architecture with plugin support  

For more information, visit [SeoToaster website](https://www.seotoaster.com/).

---

## Why SeoToaster CRM Ultimate?

SeoToaster CRM Ultimate is a powerful **Customer Relationship Management (CRM)** software that lets you:  

- Track leads, activities, opportunities, and interactions with your brand  
- Automate your sales processes  

Built on top of **SeoToaster CMS** and **SeoToaster Ecommerce**, and connected to the **SambaSaaS marketing cloud**, it provides:  

- Built-in analytics  
- Call tracking  
- VOIP integration  
- Email newsletter integration  

This setup saves users thousands of dollars in integration fees and a lot of time.  

SeoToaster CRM Ultimate is ideal for web-centric organizations to:  

- Build one or more websites or web stores  
- Launch PPC campaigns quickly  

**Components:**  

- SeoToaster CMS – Free & open-source  
- SeoToaster Ecommerce – Free & open-source  
- SeoToaster CRM – Includes a free 250 named users sales automation license  

---

## Try the SeoToaster CMS Demo Website

Log in to our [SeoToaster CMS demo](https://www.seotoaster.com/demo-seotoaster-cms-free-seo-software.html) to explore its powerful content editing features and see it in action.

---
## Minimum Requirements

- **Web server:** Apache 2, Nginx, or any web server that supports URL rewrites and PHP  
- **Apache module:** `mod_rewrite` (Apache only)  
- **PHP versions:** 7.4.x – 8.2  
- **MySQL versions:** 5.x / 8.x  
  - Create an empty database (e.g., `SeoToaster`)  
  - Use UTF-8 Unicode if using multiple languages  
  - Deactivate MySQL strict mode if enabled ([instructions](https://dev.mysql.com/doc/refman/5.7/en/sql-mode.html#sql-mode-setting))  
- **Required PHP modules:** `curl`, `gd`, `json`, `mbstring`, `pdo-mysql`, `xml`, `gmp`, `zip`, `ioncube`, `mcrypt`  
- **Optional PHP extensions:** `imap` (needed only for email features)  

[Full requirements](https://www.seotoaster.com/seotoaster-install-requirements.html)

---

## Download

Get the latest version of SeoToaster CMS & CRM here: [Download Page](https://www.seotoaster.com/crm/download.html)

---

## Installation

1. Download the CMS/CRM package from the [Download Page](https://www.seotoaster.com/crm/download.html)  
2. Upload files to your web server  
3. Follow the installation wizard to configure the database and admin account  

Refer to the official documentation for detailed instructions.

---

## Usage

Access the admin panel at:


Manage pages, users, products, leads, opportunities, and more from the admin dashboard.

---

## Development Environment

To start the development environment for the first time:

### Clone the repository
Clone the current repository using:

    git clone https://github.com/seotoaster-team/seotoaster.git
    cd seotoaster

### Setup Dependencies
Install PHP dependencies using Composer. This will download ZendLib and all minimum required plugins, which will then be available in the admin panel for activation:

    composer install

### Installation Wizard

Run the installation wizard in your browser.

After finishing the installation wizard, go to the admin panel, open **Other → Plugins**, and activate all plugins. They are already downloaded and ready to use.  

**Alternatively**, you can run the following PHP script from the console to install default plugins automatically:

    php installDefaultPlugins.php

---

## Contributing

SeoToaster CMS & ECOMMERCE are developed by Seosamba under the **GPLv3 license**. We welcome and encourage contributions from everyone! For plugin, app, and core development, please follow our [development guidelines](https://www.seotoaster.com/develop-plugins-apps.html), check our [open issues](https://github.com/seotoaster-team/seotoaster/issues) to contribute, or contact the team to get involved.


---

## License

- **SeoToaster CMS & Ecommerce:** Free & open-source under [GNU GPLv3](https://www.gnu.org/licenses/gpl-3.0.en.html)  
- **SeoToaster CRM Ultimate:** Commercial software with a free 250-named user sales automation license. Additional licenses may be purchased for larger teams or extended features.  

For full licensing details, see: [SeoToaster License](https://www.seotoaster.com/seotoaster-license.html)

---

## Contact

**Seosamba**  
Website: [https://www.seosamba.com](https://www.seosamba.com)  
CMS Info: [https://www.seotoaster.com](https://www.seotoaster.com)
