<?php


class Widcard_Models_Mappers_WidcardCustomParamsMapper extends Application_Model_Mappers_Abstract
{

    protected $_dbTable = 'Widcard_Models_Dbtables_WidcardCustomParamsDbtable';

    protected $_model = 'Widcard_Models_Models_WidcardCustomParamsModel';

    /**
     * @param array $params
     * @throws Exception
     * @throws Exceptions_SeotoasterPluginException
     */
    public function save($params)
    {
        if (!is_array($params) || empty ($params)) {
            throw new Exceptions_SeotoasterPluginException('Given parameter should be non empty array');
        }

        array_walk($params, function ($value, $key, $dbTable) {
            $dbTable->updateParam($key, $value);
        }, $this->getDbTable());


    }

    /**
     * Get all custom params
     *
     * @return mixed
     * @throws Exception
     */
    public function getCustomParams()
    {
        return $this->getDbTable()->selectParams();
    }

    /**
     * Get single param by name
     *
     * @param string $name param name
     * @return null
     * @throws Exception
     */
    public function getCustomParam($name)
    {
        if (!$name) {
            return null;
        }

        $row = $this->getDbTable()->find($name);
        if ($row = $row->current()) {
            return $row->value;
        }

        return null;
    }

    /**
     * Delete all params data
     *
     * @return mixed
     * @throws Exception
     */
    public function deleteAll()
    {
       return $this->getDbTable()->getAdapter()->query('TRUNCATE TABLE '.$this->getDbTable()->info(Zend_Db_Table::NAME));
    }


}

