<?php

class Widgets_Imageonly_Imageonly extends Widgets_WebbuilderWidget
{

    const LINK_OPTION_URL = 'external';

    const LINK_OPTION_NOTHING = 'nothing';

    const LINK_OPTION_IMAGE = 'image';

    const LOCAL_PAGE_ID = 'localPageId';

    const LINK_ONLY_SRC = 'src';


    protected function _load()
    {
        $name = Webbuilder_Tools_Misc::toHash($this->_options[0] . __CLASS__);
        $pageId = (end($this->_options) == 'static') ? 0 : $this->_toasterOptions['id'];
        $type = ($pageId) ? Application_Model_Models_Container::TYPE_REGULARCONTENT : Application_Model_Models_Container::TYPE_STATICCONTENT;
        $container = Application_Model_Mappers_ContainerMapper::getInstance()->findByName($name, $pageId, $type);

        $config = Zend_Controller_Action_HelperBroker::getStaticHelper('config')->getConfig();
        $websiteHelper = Zend_Controller_Action_HelperBroker::getStaticHelper('website');

        if ($container instanceof Application_Model_Models_Container) {
            $ioData = Zend_Json::decode($container->getContent());
            $localLinkUrl = false;

            if (is_array($ioData) && !empty($ioData)) {
                foreach ($ioData as $key => $value) {
                    if ($key === self::LOCAL_PAGE_ID) {
                        $localPage = Application_Model_Mappers_PageMapper::getInstance()->find($value);
                        if ($localPage instanceof Application_Model_Models_Page) {
                            if(($ioData['externalUrl'] === $this->_websiteUrl.$localPage->getUrl()) && !(strpos($ioData['externalUrl'], '#'))){
                                $ioData['externalUrl'] = $this->_websiteHelper->getUrl() . $localPage->getUrl();
                            }
                            $localLinkUrl = true;
                        }
                    }
                    $this->_view->$key = $value;
                }
            }
            if ($localLinkUrl) {
                $this->_view->externalUrl = $ioData['externalUrl'];
            }
        }

        if (!empty($this->_options[1])) {
            $width = (!empty($this->_options[1]) && is_numeric($this->_options[1])) ? filter_var($this->_options[1], FILTER_SANITIZE_NUMBER_INT) : $this->_options[1];
        } else {
            $width = self::DEFAULT_THUMB_SIZE;
        }

        $height = (!empty($this->_options[2]) && is_numeric($this->_options[2])) ? filter_var($this->_options[2], FILTER_SANITIZE_NUMBER_INT) : self::DEFAULT_THUMB_SIZE_HEIGHT;
        $imgFolderName = '';

        if (!is_numeric($width)) {
            if(!empty($ioData['folder']) && !empty($ioData['image'])){
                $imgType = 'img' . ucfirst($width);
                if($imgType == 'imgOriginal'){
                    $imgData = getimagesize(
                        $this->_websiteHelper->getPath() . 'media/' . $ioData['folder'] . '/' . Webbuilder_Tools_Filesystem::IMG_ORIGINAL . '/' . $ioData['image']
                    );
                    $width = $imgData[0];
                    $height = $imgData[1];
                } elseif (!empty($config[$imgType])) {
                    $imgFolderName = $width;
                    $imgData = getimagesize(
                        $this->_websiteHelper->getPath() . 'media/' . $ioData['folder'] . '/'. $width .'/' . $ioData['image']
                    );
                    $width = $imgData[0];
                    $height = $imgData[1];
                }
            }
        }elseif (is_numeric($width)){
            $subFolder = Webbuilder_Tools_Filesystem::getMediaSubFolderByWidth($width);
            if(!empty($ioData['folder']) && !empty($ioData['image'])){
                $imgFolderName = $subFolder;

                $imgData = getimagesize(
                    $this->_websiteHelper->getPath() . 'media/' . $ioData['folder'] . '/'. $subFolder .'/' . $ioData['image']
                );
                $imgDataWidth = $imgData[0];
                $imgDataHeight = $imgData[1];
                $customWidth = $width;

                $resultHeight = $imgDataHeight/($imgDataWidth/$customWidth);
                $height = round($resultHeight);
            }else{
                if(!in_array('default_content', $this->_options)){
                    $width = self::DEFAULT_THUMB_SIZE;
                    $height = self::DEFAULT_THUMB_SIZE_HEIGHT;
                }
            }
        }

        /**
         * for special default option value with option default_content Widgets_Content_Content::DEFAULT_CONTENT
         */
        $defaultUrlFlag = false;

        if(is_null($container) && in_array(Widgets_Content_Content::DEFAULT_CONTENT, $this->_options)){

            $optionKey = array_search(Widgets_Content_Content::DEFAULT_CONTENT, $this->_options);
            if(isset($this->_options[$optionKey+1])){
                $nextOption = $this->_options[$optionKey+1];
                $defaultUrl = '';
                if($nextOption == 'http' || $nextOption == 'https'){
                    $defaultUrl .= $nextOption.':';
                }else{
                    $defaultUrl = 'http://'.$nextOption;
                }

                if(isset($this->_options[$optionKey+2])){
                    $defaultUrl .= $this->_options[$optionKey+2];
                }
            }
            if(!empty($defaultUrl)){
                $defaultUrlFlag = true;
                $this->_view->imgSrc = $defaultUrl;
                $this->_view->defaultAlt = $this->_options[0];
            }
        }
        if(empty($this->_view->description)){
            $this->_view->description = stristr($this->_view->image, '.', true);
        }

        $mediaSubFolder = Webbuilder_Tools_Filesystem::getMediaSubFolderByWidth($width);

        $useCrop = false;
        $cropFolder = '';

        if(!empty($ioData['cropImg']) && !empty($ioData['cropWidth']) && !empty($ioData['cropHeight'])) {
            $mediaSubFolder = 'crop';
            $cropFolder = $ioData['cropWidth'] . '-' . $ioData['cropHeight'];

            $imgFolderName = $mediaSubFolder. '/' . $cropFolder;

            $imgData = getimagesize(
                $this->_websiteHelper->getPath() . 'media/' . $ioData['folder'] . '/'. $mediaSubFolder .'/' . $cropFolder . '/' . $ioData['image']
            );
            if(!empty($imgData)) {
                $width = $imgData[0];
                $height = $imgData[1];

                $useCrop = true;
            }
        }

        $this->_view->useCrop = $useCrop;
        $this->_view->cropFolder = $cropFolder;

        $this->_view->defaultUrlFlag = $defaultUrlFlag;
        $this->_view->containerName = $name;
        $this->_view->width = $width;
        $this->_view->height = (!empty($height)) ? $height : '';
        $this->_view->mediaSubFolder = $mediaSubFolder;
        $this->_view->pageId = $pageId;

        $websiteUrlMediaServer = ($config['mediaServers'] ? Tools_Content_Tools::applyMediaServers($websiteHelper->getUrl()) : $websiteHelper->getUrl());

        if(in_array(self::LINK_ONLY_SRC, $this->_options) && !empty($ioData['folder']) && !empty($ioData['image'])) {
            if(!empty($ioData['externalUrl'])) {
                return $ioData['externalUrl'];
            }

            $folder = Webbuilder_Tools_Filesystem::IMG_ORIGINAL;
            if(!empty($imgFolderName) && !is_numeric($imgFolderName)) {
                $folder = $imgFolderName;
            }

            return $websiteUrlMediaServer . 'media/' . $ioData['folder'] . '/' . $folder . '/' . $ioData['image'];
        }

        $this->_view->websiteUrlMediaServer = $websiteUrlMediaServer;

        return $this->_view->render('imageonly.phtml');
    }
}
