<?php

/**
 * Paypal recurring payments mapper
 *
 * @method Paypal_Models_Mapper_PaypalRecurringPaymentsMapper   getInstance()   getInstance()   Returns an instance of itself
 * @method Zend_Db_Table    getDbTable()    getDbTable()    Returns an instance of DbTable
 */
class Paypal_Models_Mapper_PaypalRecurringPaymentsMapper extends Application_Model_Mappers_Abstract
{

    /**
     * @var string
     */
    protected $_dbTable = 'Paypal_Models_Dbtables_PaypalRecurringPaymentsDbtable';

    /**
     * @var string
     */
    protected $_model = 'Paypal_Models_Models_PaypalRecurringPaymentsModel';

    /**
     * Save recurring profile info
     *
     * @param Paypal_Models_Models_PaypalRecurringPaymentsModel $model
     * @throws Exceptions_SeotoasterException
     * @return Paypal_Models_Models_PaypalRecurringPaymentsModel
     * @throws Exceptions_SeotoasterException
     */
    public function save($model)
    {
        if (!$model instanceof $this->_model) {
            throw new Exceptions_SeotoasterException('Given parameter should be ' . $this->_model . ' instance');
        }
        $data = array(
            'user_id' => $model->getUserId(),
            'cart_id' => $model->getCartId(),
            'profile_id' => $model->getProfileId(),
            'status' => $model->getStatus(),
            'auto_bill_out_amt' => $model->getAutoBillOutAmt(),
            'desc' => $model->getDesc(),
            'max_failed_payments' => $model->getMaxFailedPayments(),
            'profile_start_date' => $model->getProfileStartDate(),
            'next_billing_date' => $model->getNextBillingDate(),
            'num_cycles_completed' => $model->getNumCyclesCompleted(),
            'num_cycles_remaining' => $model->getNumCyclesRemaining(),
            'outstanding_balance' => $model->getOutstandingBalance(),
            'failed_payment_count' => $model->getFailedPaymentCount(),
            'last_payment_date' => $model->getLastPaymentDate(),
            'last_payment_amt' => $model->getLastPaymentAmt(),
            'trial_amt_paid' => $model->getTrialAmtPaid(),
            'regular_amt_paid' => $model->getRegularAmtPaid(),
            'aggregate_amt' => $model->getAggregateAmt(),
            'aggregate_optional_amt' => $model->getAggregateOptionalAmt(),
            'final_payment_due_date' => $model->getFinalPaymentDueDate(),
            'timestamp' => $model->getTimestamp(),
            'correlation_id' => $model->getCorrelationId(),
            'billing_period' => $model->getBillingPeriod(),
            'billing_frequency' => $model->getBillingFrequency(),
            'total_billing_cycles' => $model->getTotalBillingCycles(),
            'currency_code' => $model->getCurrencyCode(),
            'amt' => $model->getAmt(),
            'shipping_amt' => $model->getShippingAmt(),
            'tax_amt' => $model->getTaxAmt(),
            'regular_billing_period' => $model->getRegularBillingPeriod(),
            'regular_billing_frequency' => $model->getRegularBillingFrequency(),
            'regular_total_billing_cycles' => $model->getRegularTotalBillingCycles(),
            'regular_currency_code' => $model->getRegularCurrencyCode(),
            'regular_amt' => $model->getRegularAmt(),
            'regular_shipping_amt' => $model->getRegularAmt(),
            'regular_tax_amt' => $model->getRegularTaxAmt(),
            'acct' => $model->getAcct(),
            'credit_card_type' => $model->getCreditCardType(),
            'exp_date' => $model->getExpDate(),
            'email' => $model->getEmail(),
            'street' => $model->getStreet(),
            'city' => $model->getCity(),
            'state' => $model->getState(),
            'zip' => $model->getZip(),
            'country_code' => $model->getCountryCode(),
            'country' => $model->getCountry(),
            'address_owner' => $model->getAddressOwner(),
            'address_status' => $model->getAddressStatus(),
            'payer_status' => $model->getPayerStatus()
        );

        $id = $model->getId();
        if ($id) {
            $where = $this->getDbTable()->getAdapter()->quoteInto('id = ?', $id);
            $this->getDbTable()->update($data, $where);
        } else {
            $this->getDbTable()->insert($data);
            $model->setId($id);
        }

        return $model;

    }

    /**
     * Update profile
     *
     * @param array $profileData
     * @param int $profileId subscription id
     */
    public function updateProfile($profileData, $profileId)
    {
        $where = $this->getDbTable()->getAdapter()->quoteInto('profile_id = ?', $profileId);
        $this->getDbTable()->update($profileData, $where);
    }

    /**
     * Find by profile id
     *
     * @param int $profileId profile id
     * @return Paypal_Models_Models_PaypalRecurringPaymentsModel
     */
    public function findByProfileId($profileId)
    {
        $where = $this->getDbTable()->getAdapter()->quoteInto('profile_id = ?', $profileId);

        return $this->_findWhere($where);
    }

    public function findRecurringCartByParentCartId($cartId)
    {
        $where = $this->getDbTable()->getAdapter()->quoteInto('cart_id = ?', $cartId);
        $select = $this->getDbTable()->getAdapter()->select()->from('shopping_cart_session_has_recurring')
            ->where($where);

        return $this->getDbTable()->getAdapter()->fetchAll($select);
    }

}

