<?php

class Notifier_Models_Mappers_NotifierPendingNewsMapper extends Application_Model_Mappers_Abstract
{

    protected $_dbTable = 'Notifier_Models_Dbtables_NotifierPendingNewsDbtable';

    protected $_model = 'Notifier_Models_Models_NotifierPendingNewsModel';

    public function save($model)
    {
        if (!$model instanceof $this->_model) {
            throw new Exceptions_SeotoasterException('Given parameter should be ' . $this->_model . ' instance');
        }
        $data = [
            'news_id' => $model->getNewsId(),
            'created_at' => date(Tools_System_Tools::DATE_MYSQL),
            'status' => $model->getStatus(),
        ];

        $pendingNews = $this->getByNewsId($data['news_id']);
        if (!$pendingNews instanceof Notifier_Models_Models_NotifierPendingNewsModel) {
            $id = $this->getDbTable()->insert($data);
            return $model->setId($id);
        }
        return $model;
    }

    public function updateStatus($model)
    {
        if (!$model instanceof $this->_model) {
            throw new Exceptions_SeotoasterException('Given parameter should be ' . $this->_model . ' instance');
        }

        $where = $this->getDbTable()->getAdapter()->quoteInto('news_id = ?', $model->getNewsId());

        return $this->getDbTable()->update(['status' => '1'], $where);
    }

    public function getByNewsId($newsId)
    {
        $where = $this->getDbTable()->getAdapter()->quoteInto('news_id = ?', $newsId);
        return $this->_findWhere($where);
    }

    public function deleteByNewsId($newsId)
    {
        if (!empty($newsId)) {
            $where = $this->getDbTable()->getAdapter()->quoteInto('news_id = ?', $newsId);
            return (bool)$this->getDbTable()->delete($where);
        }

        return null;
    }

    public function getUnprocessedNews()
    {
        $status = 0;
        $where = $this->getDbTable()->getAdapter()->quoteInto('status = ?', $status);
        return $this->fetchAll($where);
    }

}