tinymce.PluginManager.add('leadshortcode', function(editor, url) {
    var disableForSms = 0,
        withQuoteWidgets = 0;

    if(editor.id == 'lead-sms-tab-textarea') {
        disableForSms = 1
    }

    if (editor.id == 'copy-email-message-workflow' || editor.id == 'form-action-assign-task-notes-detailed-view-workflow' || editor.id == 'form-action-assign-task-notes-workflow') {
        withQuoteWidgets = 1;
    }

    function getValues() {
        if (typeof window.tinymcePluginShortCodes === 'undefined') {
            return new Promise((resolve, reject) => {
                $.ajax({
                    'url': window.location.protocol + '//' + window.location.host + '/plugin/leads/run/getLeadShortCode/disableForSms/' + disableForSms + '/withQuoteWidgets/' + withQuoteWidgets,
                    'type': 'POST',
                    'dataType': 'json',
                    'data': {}
                }).done(async function (response) {
                    window.tinymcePluginShortCodes = response;
                    let responseList = processList(response);
                    resolve(responseList);
                }).fail(async function (response) {
                    resolve({name: 'login', 'message': 'Please re-login'});
                });
            });
        } else {
            let response = window.tinymcePluginShortCodes;
            return processList(response);
        }
    }

    function processList(response)
    {
        var shortCodeList = [];

        for (var i in response) {
            for (var j in response[i]) {
                var newShortcode = {};
                if (typeof response[i][j].alias !== 'undefined') {
                    newShortcode['type'] = 'menuitem';
                    newShortcode['text'] = response[i][j].alias;
                    newShortcode['value'] = '{' + response[i][j].option + '}';
                    newShortcode['onSetup'] = function(buttonApi) {
                        var $this = this;
                        this.onAction = function() {
                            editor.insertContent($this.data.value);
                        };
                    }
                } else {
                    newShortcode['type'] = 'menuitem';
                    newShortcode['text'] = response[i][j];
                    newShortcode['value'] = '{' + response[i][j] + '}';
                    newShortcode['onSetup'] = function(buttonApi) {
                        var $this = this;
                        this.onAction = function() {
                            editor.insertContent($this.data.value);
                        };
                    }
                }

                shortCodeList.push(newShortcode)
            }
        }

        return shortCodeList;
    }

    // Add a button that opens a window
    editor.ui.registry.addMenuButton('leadshortcode', {
        text: 'Personalize',
        fetch: async function (callback) {
            let result = '';
            result = await getValues();
            callback(result);
        }
    });
});
