define([
    'backbone',
    '../models/organization-timeline',
    'backbone.paginator'
], function(Backbone, OrganizationTimelineModel){

    var OrganizationsTimelineCollection = Backbone.Paginator.requestPager.extend({
        model: OrganizationTimelineModel,
        paginator_core: {
            type: 'GET',
            dataType: 'json',
            url: function(){
                return $('#website_url').val() + 'api/leads/organizationstimeline/';
            }
        },
        paginator_ui: {
            firstPage:    0,
            currentPage:  0,
            perPage:     10,
            totalPages:  10
        },
        server_api: {
            count: true,
            limit: function() { return this.perPage; },
            offset: function() { return this.currentPage * this.perPage },
            key: function(){ return this.key; },
            timelineType:function(){return this.timelineType},
            organizationId:function(){return this.organizationId}

        },
        parse: function(response, xhr){
            if (this.server_api.count){
                this.totalRecords = response.totalRecords;
            } else {
                this.totalRecords = response.length;
            }
            this.moneyFormat = response.moneyFormat;
            this.customerGroups = response.groups;
            this.leadStages = response.stages;
            this.totalPages = Math.floor(this.totalRecords / this.perPage);
            this.usersList = response.users;
            this.currentUserId = response.currentUserId;
            this.currencySymbol = response.currencySymbol;
            this.leadInfo = response.leadInfo;
            this.userTimezoneOffset = response.userTimezoneOffset;
            this.gatewayLabelsList = response.gatewayLabelsList;
            return this.server_api.count ? response.data : response;
        }

    });

    return OrganizationsTimelineCollection;
});