define([
    'backbone',
    '../collections/leads-timeline',
    'text!../templates/paginator.html',
    'text!../templates/lead-timeline-upcoming.html',
    'i18n!../../../nls/dashboard_'+$('#main-dashboard-system-language').val()+'_ln',
    'moment',
    'accounting'
], function(Backbone,
            LeadTimelineCollection, PaginatorTmpl, LeadTimelineUpcomingTmpl, i18n, moment, accounting
){

    var LeadsTimelineUpcomingView = Backbone.View.extend({
        el: $('#lead-timeline-upcoming-events'),
        events: {
            'click a[data-role=delete]': 'deleteFromTimeline'
        },
        templates: {
        },
        initialize: function(leadModel){
            this.timelineUpcoming = new LeadTimelineCollection();
            this.timelineUpcoming.timelineType = 'upcoming';
            this.timelineUpcoming.leadId = leadModel.get('id');
            this.timelineUpcoming.userTimezoneOffset = leadModel.get('userTimezoneOffset');
            this.timelineUpcoming.on('reset', this.renderTimeline, this);
            this.timelineUpcoming.on('add', this.renderTimeline, this);
            this.timelineUpcoming.on('destroy', this.renderTimeline, this);
        },
        render: function(){
            this.timelineUpcoming.server_api = _.extend(this.timelineUpcoming.server_api, {
                'filter': function() {
                    return {
                        'filter-by-action-type': $('.timeline-filter-by-action-type:checked').val(),
                        'filter-by-type':  $('#filter-action-log-type-block-state').val(),
                        'filter-by-sub-type' : $('#filter-action-log-subtype-state').val()
                    };
                }
            });
            this.timelineUpcoming.pager();
            if(this.$el.find('style').length > 0) {
                this.$el.find('style').remove();
            }

        },
        renderTimeline: function(){
            this.$el.find('#lead-timeline-upcoming-events-body').empty();
            this.timelineUpcoming.each(this.renderTimelineItem, this);
            this.timelineUpcoming.info()['i18n'] = i18n;
            if(this.$el.find('style').length > 0) {
                this.$el.find('style').remove();
            }

            $('._lbox').magnificPopup({type: 'image'});
        },
        renderTimelineItem: function(TimelineItemData) {
            this.$el.find('#lead-timeline-upcoming-events-body').append(_.template(LeadTimelineUpcomingTmpl, {
                'timeLineItem': TimelineItemData,
                'monthRow': false,
                'users': this.timelineUpcoming.usersList,
                'currentUserId': this.timelineUpcoming.currentUserId,
                'accounting': accounting,
                'moneyFormat': this.timelineUpcoming.moneyFormat,
                'moment': moment,
                'i18n': i18n,
                'userTimezoneOffset': this.timelineUpcoming.userTimezoneOffset,
                'gatewayLabelsList':this.timelineUpcoming.gatewayLabelsList
            }));
        },
        deleteFromTimeline: function(e){
            var cid = $(e.currentTarget).data('timeline-id'),
                model = this.timelineUpcoming.get(cid);

            showConfirm(_.isUndefined(i18n['Are you sure want to delete'])?'Are you sure want to delete':i18n['Are you sure want to delete'], function(){
                if (model){
                    model.destroy();
                }
            });
        }
    });

    return LeadsTimelineUpcomingView;
});
