define([
    'backbone',
    '../collections/leads-profile',
    'text!../templates/paginator.html',
    'text!../templates/lead-profile-tab/lead-ip-address-list.html',
    'text!../templates/lead-profile-tab/lead-profile-timeline.html',
    'text!../templates/lead-profile-tab/lead-profile-stats.html',
    'text!../templates/lead-profile-tab/lead-profile-visits.html',
    '../collections/leads-profile-visits',
    'text!../templates/lead-profile-tab/lead-profile-map.html',
    'text!../templates/lead-profile-tab/lead-profile-map-stats.html',
    'text!../templates/lead-profile-tab/lead-profile-full-info-summary.html',
    'text!../templates/lead-profile-tab/lead-profile-full-info-first-visit.html',
    'text!../templates/lead-profile-tab/lead-profile-full-info-last-visit.html',
    'i18n!../../../nls/dashboard_'+$('#main-dashboard-system-language').val()+'_ln',
    'moment'
], function(Backbone,
            LeadProfileCollection, PaginatorTmpl, LeadIpAddressListTmpl, LeadProfileTimelineTmpl, LeadProfileStatsTmpl, LeadProfileVisitsRowsDetailedTmpl, LeadsProfileVisitCollection, ProfileVisitsInfoWindowTemplate, ProfileMapStatsTmpl, ProfileInfoSummaryTmpl, ProfileInfoFirstVisitTmpl, ProfileInfoLastVisitTmpl, i18n, moment
){

    var LeadsProfileView = Backbone.View.extend({
        el: $('#lead-profile-tab-content'),
        events: {
            'click td.lead-profile-grid-paginator a.page': 'navigate',
            'click .profile-visit-row': 'toggleVisits',
            'click #assign-ip-address': 'assignIpAddress',
            'click .delete-ip-address':'deleteIpAddress'
        },
        templates: {
            paginator: _.template(PaginatorTmpl)
        },
        initialize: function(leadId, currentPage, visitId){
            this.profile = new LeadProfileCollection();
            this.profile.leadId = leadId;
            if (!_.isUndefined(currentPage)) {
                this.profile.currentPage = currentPage;
            }
            this.profile.on('reset', this.renderProfile, this);
            this.profile.on('add', this.renderProfile, this);
            this.profile.on('destroy', this.renderProfile, this);
            this.visitIdPrecheked = visitId;
        },
        render: function(param){
            if(!_.isUndefined(param)) {
                this.profile.currentPage = 0;
            }
            this.profile.server_api = _.extend(this.profile.server_api, {
                'filter': function() {
                    return {
                    };
                }
            });
            this.profile.pager();
        },
        initMap: async function () {
            var myOptions = this.initOptionsMap();
            if(!_.isEmpty(this.profile.googleMapId)) {
                myOptions.mapId = this.profile.googleMapId;
            }

            this.map = new google.maps.Map(document.getElementById('full-visits-profile-map'), myOptions);
            this.visitLocations = [];
            this.infoWindowsData = [];
            this.mapBounds = [];
            this.mapMarkers = [];
            this.advancedMarkerElement = await google.maps.importLibrary("marker");

            this.getVisitLocations(this.profile.leadId);
        },
        initOptionsMap: function() {
            return {
                zoom: 12,
                mapId: 'DEMO_MAP_ID',
                center: new google.maps.LatLng(48, 2),
                mapTypeControlOptions: {
                    style: google.maps.MapTypeControlStyle.DROPDOWN_MENU
                },
                scaleControl: false,
                disableDefaultUI: true,
                zoomControl: true,
                scrollwheel: false,
                mapTypeId: google.maps.MapTypeId.ROADMAP,
                streetViewControl: false,
                panControl: true,
                fullscreenControl: true
            }
        },
        assignIpAddress: function(e)
        {
            var self = this,
                ipAddress = $('#add-profile-ip-address').val();

            $.ajax({
                'url': $('#website_url').val()+'api/leads/leadip/',
                'type':'POST',
                'dataType': 'json',
                'data': {
                    'leadId' : this.profile.leadId,
                    'secureToken': $('#lead-grid-token').val(),
                    'ipAddress': ipAddress
                }
            }).done(function(response){
                showMessage(response.responseText, false, 5000);
                self.profile.ipAddressesData.push({'lead_ip_address':ipAddress, 'lead_id':self.profile.leadId});
                self.$el.find('#ip-addresses-block').empty();
                self.$el.find('#ip-addresses-block').append(_.template(LeadIpAddressListTmpl, {
                    'ipAddresses': self.profile.ipAddressesData,
                    'moment': moment,
                    'i18n': i18n
                }));

            }).fail(function(response){
                showMessage(response.responseJSON, true, 5000);
            });
        },
        deleteIpAddress: function(e){
            var el = $(e.currentTarget),
                leadId = el.data('lead-id'),
                ipAddress = el.data('lead-ip-address'),
                self = this;

            showConfirm(_.isUndefined(i18n['Are you sure want to delete'])?'Are you sure want to delete':i18n['Are you sure want to delete'], function(){
                $.ajax({
                    'url': $('#website_url').val()+'api/leads/leadip/leadId/'+leadId+'/ipAddress/'+ipAddress,
                    'type':'DELETE',
                    'dataType':'json'
                }).done(function(response){
                    var ipAddressList = _.filter(self.profile.ipAddressesData, function(num){
                        return ipAddress !== num.lead_ip_address;
                    });

                    self.profile.ipAddressesData = ipAddressList;

                    self.$el.find('#ip-addresses-block').empty();
                    self.$el.find('#ip-addresses-block').append(_.template(LeadIpAddressListTmpl, {
                        'ipAddresses': self.profile.ipAddressesData,
                        'moment': moment,
                        'i18n': i18n
                    }));

                    showMessage(response.responseText, false, 5000);
                }).fail(function(response){
                    showMessage(response.responseJSON, true, 5000);
                });
            });
        },
        renderProfile: function(){
            this.$el.find('#lead-profile-main-table-body').empty();
            if (this.profile.currentPage === 0) {
                this.currentVisitId = 0;
            } else {
                this.currentVisitId = this.profile.paginator_ui.perPage*this.profile.currentPage;
            }

            if (!_.isUndefined(this.profile.ipAddressesData)) {
                this.$el.find('#ip-addresses-block').empty();
                this.$el.find('#ip-addresses-block').append(_.template(LeadIpAddressListTmpl, {
                    'ipAddresses': this.profile.ipAddressesData,
                    'moment': moment,
                    'i18n': i18n
                }));
            }

            if (_.isUndefined(this.profile.fullInfoRendered) && this.profile.length > 0) {
                this.$el.find('#lead-profile-full-info').empty();
                this.$el.find('#lead-profile-full-info-summary').empty();
                this.$el.find('#lead-profile-full-info-first-visit').empty();
                this.$el.find('#lead-profile-full-info-last-visit').empty();
                this.$el.find('#location-visits-map-details').empty();
                if (!_.isEmpty(this.profile.googleApiKey)) {
                    this.initMap();
                } else {
                    $('#full-visits-profile-map').addClass('hidden');
                }
                this.$el.find('#lead-profile-full-info').append(_.template(LeadProfileStatsTmpl, {
                    'stats': this.profile.stats,
                    'moment': moment,
                    'i18n': i18n
                }));
                this.$el.find('#lead-profile-full-info-summary').append(_.template(ProfileInfoSummaryTmpl, {
                    'stats': this.profile.stats,
                    'moment': moment,
                    'pageLoadAverage' : this.profile.pageLoadAverage,
                    'i18n': i18n
                }));
                this.$el.find('#lead-profile-full-info-first-visit').append(_.template(ProfileInfoFirstVisitTmpl, {
                    'stats': this.profile.firstVisitInfo,
                    'moment': moment,
                    'currentDate':this.profile.currentDate,
                    'i18n': i18n
                }));
                this.$el.find('#lead-profile-full-info-last-visit').append(_.template(ProfileInfoLastVisitTmpl, {
                    'stats': this.profile.lastVisitInfo,
                    'moment': moment,
                    'currentDate':this.profile.currentDate,
                    'i18n': i18n
                }));
                $('.profile-info').removeClass('hidden');
            } else if(this.profile.length < 1) {
                $.ajax({
                    'url': $('#website_url').val()+'plugin/leads/run/checkLeadProfileInfo/',
                    'type':'POST',
                    'dataType': 'json',
                    'data': {
                        'leadId' : this.profile.leadId,
                        'secureToken': $('#lead-grid-token').val()
                    }
                }).done(function(response){
                    if(response.error != 1) {
                        if(response.responseText.hasError == 1) {
                            var errorMsg = response.responseText.errorMsg;
                            $('.profile-info').addClass('hidden');
                            $('.error-profile-info-msg').empty().append('<p>' + errorMsg + '<br/>&nbsp;</p>');
                        } else {
                            $('.profile-info').removeClass('hidden');
                            $('.error-profile-info-msg').empty().addClass('hidden');
                        }
                    }
                });
            }
            this.profile.fullInfoRendered = true;
            this.profile.each(this.renderProfileItem, this);
            this.profile.info()['i18n'] = i18n;
            if (this.profile.information.totalRecords > 0) {
                this.$('td.lead-profile-grid-paginator').html(this.templates.paginator(this.profile.information));
                if (typeof tableResponsive === "function") {
                    tableResponsive();
                }
            } else {
                this.$('td.lead-profile-grid-paginator').html('');
            }

            if (typeof this.visitIdPrecheked !=='undefined') {
                $('.profile-visit-row-'+this.visitIdPrecheked).trigger('click');
                delete this.visitIdPrecheked;
            }
        },
        renderProfileItem: function(ProfileItemData) {
            this.currentVisitId += 1;
            this.$el.find('#lead-profile-main-table-body').append( _.template(LeadProfileTimelineTmpl, {
                'profileItem': ProfileItemData,
                'moment': moment,
                'visitId': this.currentVisitId,
                'i18n' : i18n
            }));
        },
        getVisitLocations: function(leadId){
            var self = this,
                totalVisits = 0,
                citiesInfo = {},
                cityKey = '';

            $.get($('#website_url').val()+'api/leads/leadprofile/map/true/leadId/'+leadId, function(response) {
                if(!_.isEmpty(response.data)){
                    if (!_.isEmpty(response.googleApiKey)) {
                        $.each(response.data, function (value, marker) {
                            self.visitLocations[marker.id] = marker;
                            if (!_.isNull(marker.latitude) || !_.isNull(marker.longitude)) {
                                self.addMarkers(marker, response.countryCodes);
                                totalVisits += parseInt(marker.locationsQuantity);
                            }
                            if (!_.isNull(marker.countryCode) && !_.isNull(marker.city)) {
                                cityKey = marker.countryCode + '_' + marker.city;
                                if (typeof citiesInfo[cityKey] !== 'undefined') {
                                    citiesInfo[cityKey] = {
                                        'quantity': citiesInfo[cityKey].quantity + marker.locationsQuantity,
                                        'city': marker.city,
                                        'countryCode': marker.countryCode
                                    };
                                } else {
                                    citiesInfo[cityKey] = {
                                        'quantity': marker.locationsQuantity,
                                        'city': marker.city,
                                        'countryCode': marker.countryCode
                                    };
                                }
                            }
                        });

                        var latLngBounds = new google.maps.LatLngBounds();
                        _.each(self.mapBounds, function (marker) {
                            latLngBounds.extend(marker);
                        });
                        google.maps.event.trigger(self.map, 'resize');
                        self.map.setCenter(latLngBounds.getCenter(), self.map.fitBounds(latLngBounds));

                        if(self.mapBounds.length == 1){
                            var zoom = _.isEmpty(response.googleMapDefaultZoom) ? 8 : parseInt(response.googleMapDefaultZoom);
                            self.map.setZoom(zoom);
                        }
                    }

                    self.$el.find('#location-visits-map-details').append(_.template(ProfileMapStatsTmpl, {
                        'totalVisits': totalVisits,
                        'citiesInfo' : citiesInfo,
                        'countryCodes': response.countryCodes,
                        'moment': moment,
                        'googleApiKey': response.googleApiKey,
                        'googleMapId': response.googleMapId,
                        'i18n' : i18n
                    }));
                }
            });
        },
        addMarkers: function(marker, countryCodes){
            //default image
            var latLng    = new google.maps.LatLng(parseFloat(marker.latitude), parseFloat(marker.longitude));

            marker.i18n = i18n;
            var infoWindow = new google.maps.InfoWindow({
                content: _.template(ProfileVisitsInfoWindowTemplate, {'marker' : marker, 'moment' : moment, 'countryCodes' : countryCodes, 'i18n' : i18n})
            });

            google.maps.event.addListener(this.map, 'click', function() {
                infoWindow.close();
            });
            //infoWindows data
            this.infoWindowsData.push(infoWindow);
            var newMarker = new google.maps.marker.AdvancedMarkerElement(
                {
                    map: this.map,
                    title: marker.name,
                    position: latLng,
                    gmpClickable: true
                });

            google.maps.event.addListener(newMarker, 'click', function() {
                infoWindow.setContent(infoWindow['content']);
                infoWindow.open(this.map, this);
            });

            google.maps.event.addListener(infoWindow,'open',function(){
                infoWindow.close();
            });

            this.mapBounds.push(latLng);
            this.mapMarkers.push(newMarker);
        },
        toggleVisits: function(e)
        {
            e.preventDefault();
            var currentElRow = $(e.currentTarget),
                visitId = currentElRow.data('profile-visit-id-row'),
                isActive = currentElRow.hasClass('active'),
                self = this;

            $('.profile-visit-row').removeClass('active');
            $('.visits-detailed-row').remove();

            if (!isActive) {
                this.leadProfileVisitCollection = new LeadsProfileVisitCollection();
                this.leadProfileVisitCollection.userProfileLogId = visitId;
                this.leadProfileVisitCollection.fetch({
                    success: function(response){
                        response.each(self.renderVisitDetailedRow, self);
                        currentElRow.addClass('active');
                    }
                });
            }
        },
        renderVisitDetailedRow: function(visitItem)
        {
            this.$el.find('.profile-visit-row-'+visitItem.get('userProfileLogId')).after(_.template(LeadProfileVisitsRowsDetailedTmpl, {'visitItem': visitItem, 'moment': moment, 'i18n': i18n}));
        },
        navigate: function(e){
            e.preventDefault();

            var page = $(e.currentTarget).data('page');
            if ($.isNumeric(page)){
                this.profile.goTo(page);
            } else {
                switch(page){
                    case 'first':
                        this.profile.goTo(this.profile.firstPage);
                        break;
                    case 'last':
                        this.profile.goTo(this.profile.totalPages);
                        break;
                    case 'prev':
                        this.profile.requestPreviousPage();
                        break;
                    case 'next':
                        this.profile.requestNextPage();
                        break;
                }
            }
        }
    });

    return LeadsProfileView;
});