define([
    'backbone',
    'text!../templates/lead-meeting-detailed-tab.html',
    'i18n!../../../nls/dashboard_'+$('#main-dashboard-system-language').val()+'_ln',
    'tinyMCE'
], function(Backbone, LeadMeetingTmpl, i18n, tinymce){
    var LeadMeetingFormView = Backbone.View.extend({
        el: $('#lead-detailed-view-config-tab-meeting'),
        events: {
            'submit #lead-meeting-detailed-form': 'submit',
            'submit #lead-meeting-manual-form': 'submitManual',
            'change #lead-meeting-allow-add-time': 'changeAllowTime',
            'change #lead-meeting-allow-add-time-manual': 'changeAllowTimeManual',
            'change #lead-meeting-start-time-time': 'changeMeetingStartTime',
            'change #lead-meeting-end-time-time': 'changeMeetingEndTime',
            'change #lead-meeting-start-time-minutes': 'changeMeetingEndMinutes',
            'click .lead-meeting-switcher' :'showMeetingSubTab'
        },
        templates: {

        },
        initialize: function(leadModel){
            this.leadModel = leadModel;
        },
        showMeetingSubTab: function(e){
             var el = $(e.currentTarget).data('meeting-form-block');
             this.$el.find('.meeting-form').addClass('hidden');
             $('#'+el).removeClass('hidden');
             $('.lead-meeting-switcher').removeClass('checked-btn');
             $(e.currentTarget).addClass('checked-btn');
        },
        render: function(){
            tinymce.remove();
            var websiteUrl = $('#website_url').val(),
                self = this;

            this.$el.empty();
            this.$el.append(_.template(LeadMeetingTmpl, {'leadModel': this.leadModel, 'i18n': i18n}));
            this.$el.find('form').attr('action', $('#website_url').val()+'api/leads/leadmeeting');

            tinymce.init({
                script_url              : websiteUrl+'system/js/external/tinymce/tinymce.gzip.php',
                selector                : "#lead-meeting-details",
                skin                    : 'seotoaster',
                menubar                 : false,
                browser_spellcheck      : true,
                resize                  : false,
                convert_urls            : false,
                relative_urls           : false,
                statusbar               : false,
                allow_script_urls       : false,
                force_p_newlines        : false,
                forced_root_block       : false,
                entity_encoding         : "raw",
                plugins                 :  ["fullscreen leadshortcode placeholder charlimit link anchor"],
                toolbar1                : "leadshortcode | fullscreen | spellcheckbtn | link unlink",
                image_advtab            : false,
                extended_valid_elements : false,
                setup                   : function(ed){
                    var keyTime = null;
                    ed.on('change blur keyup', function(ed, e){
                        //@see content.js for this function
                        self.dispatchEditorKeyup(ed, e, keyTime);
                        this.save();
                    });

                    ed.addButton('spellcheckbtn', {
                        icon: true,
                        image: websiteUrl+'plugins/leads/web/images/spellcheck.ico',
                        tooltip: _.isUndefined(i18n['How do I enable spell-check in SeoToaster?'])?'How do I enable spell-check in SeoToaster?':i18n['How do I enable spell-check in SeoToaster?'],
                        onclick: function() {
                            window.open('https://www.seotoaster.com/questions-and-answers/crm-faq#lead-spellchecker', '_blank');
                        }
                    })
                }
            });

            tinymce.init({
                script_url              : websiteUrl+'system/js/external/tinymce/tinymce.gzip.php',
                selector                : "#lead-meeting-details-manual",
                skin                    : 'seotoaster',
                menubar                 : false,
                browser_spellcheck      : true,
                resize                  : false,
                convert_urls            : false,
                relative_urls           : false,
                statusbar               : false,
                allow_script_urls       : false,
                force_p_newlines        : false,
                forced_root_block       : false,
                entity_encoding         : "raw",
                plugins                 :  ["fullscreen leadshortcode placeholder charlimit link anchor"],
                toolbar1                : "fullscreen | spellcheckbtn | link unlink",
                image_advtab            : false,
                extended_valid_elements : false,
                setup                   : function(ed){
                    var keyTime = null;
                    ed.on('change blur keyup', function(ed, e){
                        //@see content.js for this function
                        self.dispatchEditorKeyup(ed, e, keyTime);
                        this.save();
                    });

                    ed.addButton('spellcheckbtn', {
                        icon: true,
                        image: websiteUrl+'plugins/leads/web/images/spellcheck.ico',
                        tooltip: _.isUndefined(i18n['How do I enable spell-check in SeoToaster?'])?'How do I enable spell-check in SeoToaster?':i18n['How do I enable spell-check in SeoToaster?'],
                        onclick: function() {
                            window.open('https://www.seotoaster.com/questions-and-answers/crm-faq#lead-spellchecker', '_blank');
                        }
                    })
                }
            });

            var leadMeetingStartTime = $('#lead-meeting-start-time'),
                leadMeetingEndTime = $('#lead-meeting-end-time'),
                leadMeetingStartTimeManual = $('#lead-meeting-start-time-manual'),
                leadMeetingEndTimeManual = $('#lead-meeting-end-time-manual');

            leadMeetingStartTime.datepicker({
                dateFormat: 'd-M-yy',
                defaultDate: "+1w",
                changeMonth: true,
                changeYear: true,
                yearRange: "c-5:c+5",
                minDate: 0,
                onSelect: function(selectedDate){
                    if (leadMeetingEndTime.val() === '') {
                        leadMeetingEndTime.datepicker("setDate", selectedDate);
                    }
                    if (selectedDate !== '') {
                        leadMeetingEndTime.datepicker("option", "minDate", selectedDate);
                    }
                }
            });
            leadMeetingEndTime.datepicker({
                dateFormat: 'd-M-yy',
                defaultDate: "+1w",
                changeMonth: true,
                changeYear: true,
                yearRange: "c-5:c+5",
                onSelect: function(selectedDate){
                    if (selectedDate !== '') {
                        leadMeetingStartTime.datepicker("option", "maxDate", selectedDate);
                    }
                }
            });

            leadMeetingStartTimeManual.datepicker({
                dateFormat: 'd-M-yy',
                defaultDate: "+1w",
                changeMonth: true,
                changeYear: true,
                yearRange: "c-5:c+5",
                onSelect: function(selectedDate){
                    if (leadMeetingEndTimeManual.val() === '') {
                        leadMeetingEndTimeManual.datepicker("setDate", selectedDate);
                    }
                    if (selectedDate !== '') {
                        leadMeetingEndTimeManual.datepicker("option", "minDate", selectedDate);
                        if (new Date() > new Date($.datepicker.formatDate('yy/mm/dd', $('#lead-meeting-start-time-manual').datepicker("getDate")))) {
                            $(document).find('#meeting-status-block').removeClass('hidden');
                        } else {
                            $(document).find('#meeting-status-block').addClass('hidden');
                        }

                    }
                }
            });
            leadMeetingEndTimeManual.datepicker({
                dateFormat: 'd-M-yy',
                defaultDate: "+1w",
                changeMonth: true,
                changeYear: true,
                yearRange: "c-5:c+5",
                onSelect: function(selectedDate){
                    if (selectedDate !== '') {
                        leadMeetingStartTimeManual.datepicker("option", "maxDate", selectedDate);
                    }
                }
            });

            this.tinimce = tinymce;
        },
        dispatchEditorKeyup: function(editor, event, keyTime) {
            var keyTimer = keyTime;
            if(keyTimer === null) {
                keyTimer = setTimeout(function() {
                    keyTimer = null;
                }, 1000)
            }
        },
        submit: function(e){
            e.preventDefault();

            var self = this,
                form = $(e.currentTarget).closest('form'),
                isValid = true,
                params = {},
                period = 'fixed',
                googleCalendar = 0,
                startTimeDate = ($('#lead-meeting-start-time').val()) ? $.datepicker.formatDate('yy-mm-dd', $('#lead-meeting-start-time').datepicker("getDate")): '',
                startTime = $('#lead-meeting-start-time-time').val(),
                endTimeDate =  ($('#lead-meeting-end-time').val()) ? $.datepicker.formatDate('yy-mm-dd', $('#lead-meeting-end-time').datepicker("getDate")): '',
                endTime = $('#lead-meeting-end-time-time').val(),
                startTimeMinutes = $('#lead-meeting-start-time-minutes').val(),
                endTimeMinutes = $('#lead-meeting-end-time-minutes').val(),
                firstNotification = form.find('#lead-meeting-first-notification').val(),
                secondNotification = form.find('#lead-meeting-second-notification').val(),
                firstNotificationUnits = form.find('#lead-meeting-first-notification-units').val(),
                secondNotificationUnits = form.find('#lead-meeting-second-notification-units').val(),
                sendSms = 0,
                sendNotificationSms = 0;

            _.each(form.find('.required'), function(el){
                if (!$(el).val()){
                    isValid = false;
                }
            });

            if (!isValid){
                showMessage(_.isUndefined(i18n['Missing required field'])?'Missing required field':i18n['Missing required field'], true);
                return false;
            }


            if (_.isEmpty(startTimeDate) || _.isEmpty(endTimeDate)) {
                return false;
            }


            if ($('#lead-meeting-allow-add-time').is(':checked')) {
                period = 'all_day';
            } else {
                startTimeDate = startTimeDate+' '+startTime+':'+startTimeMinutes+':00';
                endTimeDate = endTimeDate+' '+endTime+':'+endTimeMinutes+':00';
            }

            if ($('#lead-meeting-send-google-calendar').is(':checked')) {
                googleCalendar = 1;
            }

            if ($('#lead-meeting-immediate-sms').is(':checked')) {
                sendSms = 1;
            }

            if ($('#lead-meeting-notification-sms').is(':checked')) {
                sendNotificationSms = 1;
            }

            params = {'lead_id':form.find('input[name=lead_id]').val(),
                'start_time_date':startTimeDate,
                'end_time_date':endTimeDate,
                'location':form.find('input[name=lead-meeting-location]').val(),
                'invite_attendees': form.find('input[name=lead-meeting-invite-attendees]').val(),
                'period': period,
                'subject':form.find('input[name=lead-meeting-subject]').val(),
                'details': tinymce.activeEditor.getContent(),
                'secureToken': $('#lead-grid-token').val(),
                'google_calendar' : googleCalendar,
                'startTime': startTime,
                'endTime':endTime,
                'firstNotification':firstNotification,
                'secondNotification':secondNotification,
                'firstNotificationUnits':firstNotificationUnits,
                'secondNotificationUnits':secondNotificationUnits,
                'sendSms':sendSms,
                'sendNotificationSms':sendNotificationSms
            };

            form.find('#add-lead-meeting').prop('disabled', true);

            $.ajax({
                url: form.attr('action'),
                type: 'POST',
                data: $.param(params),
                dataType: 'json'
            }).done(function(response) {
                 showMessage(response.responseText, false, 5000);
                 self.render();
            }).fail(function(response){
                showMessage(response.responseJSON, true, 5000);
                form.find('#add-lead-meeting').prop('disabled', false);
            });
            return false;

        },
        submitManual: function(e){
            e.preventDefault();

            var self = this,
                form = $(e.currentTarget).closest('form'),
                isValid = true,
                params = {},
                period = 'fixed',
                startTimeDate = ($('#lead-meeting-start-time-manual').val()) ? $.datepicker.formatDate('yy-mm-dd', $('#lead-meeting-start-time-manual').datepicker("getDate")): '',
                startTime = $('#lead-meeting-start-time-time-manual').val(),
                endTimeDate =  ($('#lead-meeting-end-time-manual').val()) ? $.datepicker.formatDate('yy-mm-dd', $('#lead-meeting-end-time-manual').datepicker("getDate")): '',
                endTime = $('#lead-meeting-end-time-time-manual').val(),
                startTimeMinutes = $('#lead-meeting-start-time-minutes-manual').val(),
                endTimeMinutes = $('#lead-meeting-end-time-minutes-manual').val(),
                meetingStatus = $('#set-meeting-status').val(),
                meetingNotes = $('#additional-meeting-info').val();

            _.each(form.find('.required'), function(el){
                if (!$(el).val()){
                    isValid = false;
                }
            });

            if (!isValid){
                showMessage(_.isUndefined(i18n['Missing required field'])?'Missing required field':i18n['Missing required field'], true);
                return false;
            }


            if (_.isEmpty(startTimeDate) || _.isEmpty(endTimeDate)) {
                return false;
            }

            if (new Date() > new Date($.datepicker.formatDate('yy/mm/dd', $('#lead-meeting-start-time-manual').datepicker("getDate"))) && meetingStatus == '0') {
                showMessage(_.isUndefined(i18n['Please specify meeting status'])?'Please specify meeting status':i18n['Please specify meeting status'], true);
                return false;
            }

            if (meetingStatus === 'completed' && !meetingNotes) {
                showMessage(_.isUndefined(i18n['Please add your meeting notes'])?'Please add your meeting notes':i18n['Please add your meeting notes'], true);
                return false;
            }


            if ($('#lead-meeting-allow-add-time-manual').is(':checked')) {
                period = 'all_day';
            } else {
                startTimeDate = startTimeDate+' '+startTime+':'+startTimeMinutes+':00';
                endTimeDate = endTimeDate+' '+endTime+':'+endTimeMinutes+':00';
            }

            params = {'lead_id':form.find('input[name=lead_id]').val(),
                'start_time_date':startTimeDate,
                'end_time_date':endTimeDate,
                'location':form.find('input[name=lead-meeting-location]').val(),
                'invite_attendees': form.find('input[name=lead-meeting-invite-attendees]').val(),
                'period': period,
                'subject':form.find('input[name=lead-meeting-subject]').val(),
                'details': tinymce.activeEditor.getContent(),
                'secureToken': $('#lead-grid-token').val(),
                'startTime': startTime,
                'endTime':endTime,
                'meeting_type':'manual',
                'manualMeeting':'1',
                'meetingStatus':meetingStatus,
                'additionalNotes':meetingNotes,
            };

            form.find('#add-lead-meeting-manual').prop('disabled', true);

            $.ajax({
                url: form.attr('action'),
                type: 'POST',
                data: $.param(params),
                dataType: 'json'
            }).done(function(response) {
                showMessage(response.responseText, false, 5000);
                self.render();
            }).fail(function(response){
                showMessage(response.responseJSON, true, 5000);
                form.find('#add-lead-meeting-manual').prop('disabled', false);
            });
            return false;

        },
        changeAllowTime: function(e){
            if ($(e.currentTarget).is(':checked')) {
               $('#lead-meeting-start-time-time').prop('disabled', true);
               $('#lead-meeting-end-time-time').prop('disabled', true);
               $('#lead-meeting-start-time-minutes').prop('disabled', true);
               $('#lead-meeting-end-time-minutes').prop('disabled', true);
            } else {
                $('#lead-meeting-start-time-time').prop('disabled', false);
                $('#lead-meeting-end-time-time').prop('disabled', false);
                $('#lead-meeting-start-time-minutes').prop('disabled', false);
                $('#lead-meeting-end-time-minutes').prop('disabled', false);
            }
        },
        changeAllowTimeManual: function(e){
            if ($(e.currentTarget).is(':checked')) {
                $('#lead-meeting-start-time-time-manual').prop('disabled', true);
                $('#lead-meeting-end-time-time-manual').prop('disabled', true);
                $('#lead-meeting-start-time-minutes-manual').prop('disabled', true);
                $('#lead-meeting-end-time-minutes-manual').prop('disabled', true);
            } else {
                $('#lead-meeting-start-time-time-manual').prop('disabled', false);
                $('#lead-meeting-end-time-time-manual').prop('disabled', false);
                $('#lead-meeting-start-time-minutes-manual').prop('disabled', false);
                $('#lead-meeting-end-time-minutes-manual').prop('disabled', false);
            }
        },
        changeMeetingStartTime: function (e) {
            e.preventDefault();
            var el = $(e.currentTarget),
                selectedTime = el.val(),
                meetingEndTimeOptions = $('#lead-meeting-end-time-time option'),
                meetingStartTimeHours = $('#lead-meeting-start-time-time option').val(),
                meetingEndTimeHours = $('#lead-meeting-end-time-time option').val();

            meetingEndTimeOptions.prop('disabled', false);

            if(selectedTime == '23') {
                meetingEndTimeOptions.prop('disabled', true);
            } else if(selectedTime == '00') {
                selectedTime = 1;
            } else {
                meetingEndTimeOptions.each(function() {
                    var hourOption = $(this);

                    if(hourOption.val() < parseInt(selectedTime) && meetingStartTimeHours === meetingEndTimeHours) {
                        hourOption.prop('disabled', true);
                    }
                });

                selectedTime = parseInt(selectedTime) + 1;
            }

            $('#lead-meeting-end-time-time').val(selectedTime);
        },
        changeMeetingEndTime: function (e) {
            e.preventDefault();

            var el = $(e.currentTarget),
                meetingEndTimeHours = el.val(),
                meetingEndTimeOptions = $('#lead-meeting-end-time-minutes option'),
                meetingStartTimeHours = $('#lead-meeting-start-time-time').val(),
                selectedMinutes = $('#lead-meeting-start-time-minutes').val();

                if (meetingStartTimeHours !== meetingEndTimeHours) {
                    meetingEndTimeOptions.prop('disabled', false);
                } else {
                    meetingEndTimeOptions.each(function() {
                        var minutesOption = $(this);

                        if(minutesOption.val() < parseInt(selectedMinutes)) {
                            minutesOption.prop('disabled', true);
                        }
                    });
                }
        },
        changeMeetingEndMinutes: function (e) {
            e.preventDefault();
            var el = $(e.currentTarget),
                selectedMinutes = el.val(),
                meetingEndTimeMinutes = $('#lead-meeting-end-time-minutes option'),
                meetingStartTimeHours = $('#lead-meeting-start-time-time').val(),
                meetingEndTimeHours = $('#lead-meeting-end-time-time').val();

            meetingEndTimeMinutes.prop('disabled', false);

            meetingEndTimeMinutes.each(function() {
                var minutesOption = $(this);

                if(minutesOption.val() < parseInt(selectedMinutes) && meetingStartTimeHours === meetingEndTimeHours) {
                    minutesOption.prop('disabled', true);
                }
            });

            $('#lead-meeting-end-time-minutes').val(selectedMinutes);
        }
    });

    return LeadMeetingFormView;
});
