define([
    'backbone',
    '../collections/lead-email-sequence-log',
    'text!../templates/email-sequence-tab/email-sequence-log.html',
    'text!../templates/email-sequence-tab/email-sequence-log-footer.html',
    'i18n!../../../nls/dashboard_'+$('#main-dashboard-system-language').val()+'_ln',
    'moment'
], function(Backbone, LeadEmailSequenceLogCollection, LeadEmailSequenceLogTmpl, LeadEmailSequenceLogFooterTmpl,
         i18n, moment
){

    var LeadEmailSequenceLogView = Backbone.View.extend({
        el: $('#lead-sequence-log-table'),
        events: {
        },
        templates: {
        },
        initialize: function(leadId, currentPage){
            this.emailSequenceLog = new LeadEmailSequenceLogCollection();
            this.emailSequenceLog.leadId = leadId;
            if (!_.isUndefined(currentPage)) {
                this.emailSequenceLog.currentPage = currentPage;
            }
            this.emailSequenceLog.on('reset', this.renderEmailSequenceLog, this);
            this.emailSequenceLog.on('add', this.renderEmailSequenceLog, this);
            this.emailSequenceLog.on('destroy', this.renderEmailSequenceLog, this);
        },
        render: function(param){
            this.$el = $('#lead-sequence-log-table');
            this.emailSequenceLog.fromYear = $('.email-sequence-filter-year-select').val();
            this.emailSequenceLog.fromMonth = $('.email-sequence-filter-month-select').val();
            this.emailSequenceLog.pager();
        },
        renderEmailSequenceLog: function(){
            this.$el.find('#lead-sequence-log-table-body').empty();
            this.$el.find('.lead-email-sequence-log-footer').empty();
            $('.email-sequence-filter-month-select').val(this.emailSequenceLog.currentMonth);
            $('.email-sequence-filter-year-select').val(this.emailSequenceLog.currentYear);

            var scrollTodayItem = false;

            if ($('#email-sequence-filter-today-top').hasClass('scroll-today-item')) {
                $('#email-sequence-filter-today-top').removeClass('scroll-today-item');
                scrollTodayItem = true;
            }


            var previousWeekId = '',
                newWeek = true,
                currentWeekId = 0,
                self = this;

            $.each(this.emailSequenceLog.listOfDays, function(date, item){
                currentWeekId = item.weekNumber;
                if (previousWeekId !== '') {
                    newWeek = false;
                    if (previousWeekId !== currentWeekId) {
                        newWeek = true;
                    }
                }

                previousWeekId = item.weekNumber;

                self.$el.find('tbody').append(_.template(LeadEmailSequenceLogTmpl, {
                    'newWeek' : newWeek,
                    'item': item,
                    'moment' : moment,
                    'currentWeekId': currentWeekId,
                    'listOfWeeks':self.emailSequenceLog.listOfWeeks,
                    'dateNow':self.emailSequenceLog.dateNow,
                    'currentUserTimeZone': self.emailSequenceLog.currentUserTimeZone,
                    'i18n': i18n
                }));

            });

            self.$el.find('.lead-email-sequence-log-footer').append(_.template(LeadEmailSequenceLogFooterTmpl, {
                'fullMonthName': self.emailSequenceLog.fullMonthName,
                'totalEmailsDelayed' : self.emailSequenceLog.totalEmailsDelayed,
                'totalSmsDelayed' : self.emailSequenceLog.totalSmsDelayed,
                'totalEmailsSent' : self.emailSequenceLog.totalEmailsSent,
                'totalSmsSent' : self.emailSequenceLog.totalSmsSent,
                'currentYear' : self.emailSequenceLog.currentYear,
                'i18n' : i18n
            }));

            if (scrollTodayItem === true) {
                $('body,html').animate({
                    scrollTop: $('.email-sequence-log-today').offset().top - 400
                }, 1000);
            }

        }
    });

    return LeadEmailSequenceLogView;
});