define([
    'backbone',
    '../models/lead-custom-params',
    '../collections/lead-custom-params',
    'text!../templates/paginator.html',
    'text!../templates/lead-custom-params.html',
    'text!../templates/lead-custom-options-params.html',
    'i18n!../../../nls/dashboard_'+$('#main-dashboard-system-language').val()+'_ln',
    'moment'
], function(Backbone,
            LeadCustomParamModel, LeadCustomParamsCollection, PaginatorTmpl, LeadCustomParamsTmpl, LeadCustomOptionsParamsTmpl, i18n, moment
){

    var LeadsCustomParamsView = Backbone.View.extend({
        el: $('#lead-detailed-view-statistics-tab-custom-params'),
        events: {
            'blur .lead-custom-param-input-data,.lead-custom-param-input-data-tab': 'saveLeadParamData',
            'change .lead-custom-param-option-data,.lead-custom-param-option-data-tab': 'saveLeadParamData',
            'change .lead-custom-param-date-data,.lead-custom-param-date-data-tab': 'saveLeadParamData',
            'change input.lead-custom-param-checkbox-data,input.lead-custom-param-checkbox-data-tab': 'saveLeadParamData',
            'change input.lead-custom-param-radio-data,input.lead-custom-param-radio-data-tab': 'saveLeadParamData'
        },
        templates: {
            paginator: _.template(PaginatorTmpl)
        },
        initialize: function(leadId, options){
            this.leadCustomParams = new LeadCustomParamsCollection();
            this.leadCustomParams.grid = options.grid || false;
            this.leadCustomParams.leadId = leadId || false;
            this.leadCustomParams.customTabId = options.customTabId || null;

            this.leadCustomParams.on('reset', this.renderCustomParams, this);
            this.leadCustomParams.on('add', this.renderCustomParams, this);
            this.leadCustomParams.on('destroy', this.renderCustomParams, this);
        },
        render: function(){
            this.leadCustomParams.pager();
        },
        renderCustomParams: function(){
            this.$el.empty();
            if (this.leadCustomParams.length === 0) {
                var emptyAttributesText = (_.isUndefined(i18n['Add custom lead fields to your setup first and they\'ll show up here']) ? 'Add custom lead fields to your setup first and they\'ll show up here':i18n['Add custom lead fields to your setup first and they\'ll show up here']);
                this.$el.append('<span class="text-center block larger" id="custom-attributes-empty-message"><b>'+emptyAttributesText+'</b></span>');
            } else {
                this.leadCustomParams.each(this.renderCustomParam, this);
            }
            this.leadCustomParams.info()['i18n'] = i18n;
        },
        renderCustomParam: function(leadCustomParamData)
        {
            var customAttributes = leadCustomParamData.attributes,
                customTabField = false;

            if(typeof customAttributes.visible !== 'undefined') {
                customTabField = true;
                if(!customAttributes.visible) {
                    return;
                }
            }
            if(customAttributes.param_type == 'text'){
                this.$el.append(_.template(LeadCustomParamsTmpl, {'paramsData': leadCustomParamData, 'customTabField': customTabField}));
            }else{
                this.$el.append(_.template(LeadCustomOptionsParamsTmpl, {'paramsData': leadCustomParamData, 'customTabField': customTabField}));
                if(customAttributes.param_type == 'date'){
                    var leadCustomParamDateData = $('#lead-custom-param-date-data'+customAttributes.param_id);
                    if(customTabField) {
                        leadCustomParamDateData = $('#lead-custom-param-date-data'+customAttributes.param_id+'-tab');
                    }

                    leadCustomParamDateData.datepicker({
                        dateFormat: 'd-M-yy',
                        changeMonth: true,
                        changeYear: true
                    });
                    if(customAttributes.param_value != null && customAttributes.param_value != ''){
                        leadCustomParamDateData.val(moment(customAttributes.param_value, 'YYYY-MM-DD HH:mm:ss').format('DD-MMMM-YYYY'));
                    }
                }
            }
        },
        saveLeadParamData: function(e)
        {
            var leadId = $('#lead-detailed-view-statistics-tab-custom-params').data('lead-id'),
                currentEl = $(e.currentTarget),
                paramId = currentEl.data('param-id'),
                paramType = currentEl.data('param-type'),
                id = currentEl.data('id'),
                oldParamValue = currentEl.data('old-value'),
                currentValue = currentEl.val(),
                self = this;

            /*if(paramType == 'date'){
                currentValue = (currentEl.val()) ? $.datepicker.formatDate('yy-mm-dd', currentEl.datepicker("getDate")): '';
            }*/

            if(paramType == 'checkbox'){
                currentValue = (currentEl.is( ":checked" )) ? currentValue: '';
            }

            if(paramType == 'radio'){
                oldParamValue = $('.lead-custom-param-radio-'+id).data('old-value');
            }

            if (oldParamValue === currentValue) {
                return false;
            }

            if(typeof id === 'undefined'){
                return false;
            }

            if (!id) {
                this.leadCustomParamModel = new LeadCustomParamModel();
            } else {
                this.leadCustomParamModel = new LeadCustomParamModel({'id':id});
            }

            this.leadCustomParamModel.set('lead_id', leadId);
            this.leadCustomParamModel.set('param_value', currentValue);
            this.leadCustomParamModel.set('param_id', paramId);
            this.leadCustomParamModel.set('secureToken', $('#lead-grid-token').val());
            this.leadCustomParamModel.set('param_type', paramType);
            this.leadCustomParamModel.save(null, {
                success: function(model, response){
                    showMessage(response.responseText.message, false, 5000);
                    if(paramType == 'radio') {
                        $('.lead-custom-param-radio-'+id).data('old-value', currentValue);
                    } else {
                        currentEl.data('old-value', currentValue);
                    }
                    if (self.leadCustomParamModel.isNew()) {
                        currentEl.data('id', response.responseText.id);
                    }
                },
                error: function(model, response){
                    showMessage(response.responseJSON, true, 5000);
                }
            });
        }
    });

    return LeadsCustomParamsView;
});
