define([
    'backbone',
    'text!../templates/score-rules/detailed-view.html',
    'text!../templates/score-rules/score-rules-field-row-detailed-view.html',
    'i18n!../../../nls/dashboard_'+$('#main-dashboard-system-language').val()+'_ln',
    'moment',
    'chosen'
], function(Backbone, ScoreRulesDetailedViewTmpl, LeadScoreRulesFieldRowTmpl, i18n, moment, chosen
){

    var ScoreRuleDetailedView = Backbone.View.extend({
        el: $('#lead-score-detailed-block'),
        events: {
            'click #add-score-field-attribute-detailed-view': 'addField',
            'click .score-field-rules-row-delete': 'deleteFieldRow',
            'click #create-lead-score-rule-detailed-view': 'updateLeadScoreRule',
            'change .score-field-operator-value' : 'changeRuleOperator',
            'change #score-field-action-selection-detailed-view': 'getActionTypesAttributes',
            'click #add-score-action-field-attribute-detailed-view': 'addActionField',
            'change #score-for-rules-detailed-view' : 'changeRule',
            'change .phone-countries-codes' : 'changeDesktopMask'
        },
        templates: {
        },
        initialize: function(scoreRuleModel){
            if (_.isEmpty(scoreRuleModel)) {
                return false;
            }
            this.scoreRuleModel = scoreRuleModel;
        },
        render: function() {
            this.$el.empty();
            this.scoreRuleModel.set('leadOwners', this.alphabeticalSort(this.scoreRuleModel.get('leadOwners')));
            this.scoreRuleModel.set('customerGroups', this.alphabeticalSort(this.scoreRuleModel.get('customerGroups')));
            this.scoreRuleModel.set('stages', this.alphabeticalSort(this.scoreRuleModel.get('stages')));
            this.scoreRuleModel.set('industries', this.alphabeticalSort(this.scoreRuleModel.get('industries')));
            this.scoreRuleModel.set('countryCodes', this.alphabeticalSort(this.scoreRuleModel.get('countryCodes')));
            this.scoreRuleModel.set('leadTags', this.alphabeticalSort(this.scoreRuleModel.get('leadTags')));
            this.scoreRuleModel.set('opportunityStages', this.alphabeticalSort(this.scoreRuleModel.get('opportunityStages')));
            this.scoreRuleModel.set('opportunityTypes', this.alphabeticalSort(this.scoreRuleModel.get('opportunityTypes')));
            this.scoreRuleModel.set('emailSequencies', this.alphabeticalSort(this.scoreRuleModel.get('emailSequencies')));
            this.$el.html( _.template(ScoreRulesDetailedViewTmpl, {'scoreRuleModel': this.scoreRuleModel.toJSON(), 'moment': moment, 'i18n':i18n}));
            var self = this,
                scoreLeadOrganizationLabels = this.scoreRuleModel.get('scoreAttributesLabels').lead_organization_attributes,
                scoreLeadCustomLabels = this.scoreRuleModel.get('scoreAttributesLabels').lead_custom_attributes,
                scoreLeadOrganizationCustomLabels = this.scoreRuleModel.get('scoreAttributesLabels').organization_custom_attributes,
                scoreActionLabels = this.scoreRuleModel.get('scoreAttributesLabels').actions_attributes;

            $.each(this.scoreRuleModel.get('rulesData'), function(key, rules) {
                if (rules.rule_subtype == '' || _.isNull(rules.rule_subtype)) {
                    var fieldName = rules.field_name;
                    if (rules.rule_type === 'lead_custom_attributes') {
                        self.addSingleField(fieldName, scoreLeadCustomLabels[fieldName], rules.rule_type, '', rules.rule_comparison_operator, rules.field_value);
                    } else if(rules.rule_type === 'organization_custom_attributes') {
                        self.addSingleField(fieldName, scoreLeadOrganizationCustomLabels[fieldName], rules.rule_type, '', rules.rule_comparison_operator, rules.field_value);
                    } else {
                        self.addSingleField(fieldName, scoreLeadOrganizationLabels[fieldName], rules.rule_type, '', rules.rule_comparison_operator, rules.field_value);
                    }
                } else {
                    var fieldName = rules.field_name;
                    self.addSingleActionField(fieldName, scoreActionLabels[fieldName], rules.rule_type, rules.rule_subtype, rules.rule_comparison_operator, rules.field_value);
                }
            });
            return this;
        },
        alphabeticalSort: function(obj){
            // convert object into array
            var sortable=[];
            for(var key in obj)
                if(obj.hasOwnProperty(key))
                    sortable.push([key, obj[key]]); // each item is an array in format [key, value]

            // sort items by value
            sortable.sort(function(a, b)
            {
                var x=a[1].toLowerCase(),
                    y=b[1].toLowerCase();
                return x<y ? -1 : x>y ? 1 : 0;
            });
            return sortable; // array in format [ [ key1, val1 ], [ key2, val2 ], ... ]
        },
        addField: function()
        {
            var fieldName = $('#score-field-attribute-selection-detailed-view').val(),
                fieldLabel = $('#score-field-attribute-selection-detailed-view').find(':selected').data('field-label'),
                fieldType = $('#score-for-rules-detailed-view').val(),
                fieldKey = fieldType+'-'+fieldName.replace(/\s/g, ''),
                blockFields = false,
                customComparisonOperators = [],
                specialElType = [],
                flagMultiSelect = false,
                placeholder = '';

            if (fieldName === 'organization_employees' || fieldName === 'opportunity_amount_cumulative' || fieldName === 'opportunity_amount') {
                customComparisonOperators['greaterthan'] = _.isUndefined(i18n['Greater Than']) ? 'Greater Than' : i18n['Greater Than'];
                customComparisonOperators['lessthan'] = _.isUndefined(i18n['Less Than']) ? 'Less Than' : i18n['Less Than'];
            }

            if (fieldName === 'last_activity_inbound' || fieldName === 'last_activity_outbound' || fieldName === 'opportunity_close_date') {
                blockFields = true;
            }

            if (fieldName === 'lead_state_code' || fieldName === 'lead_position' || fieldName === 'organization_state_code' || fieldName === 'lead_phone') {
                customComparisonOperators['equal'] = _.isUndefined(i18n['Equal']) ? 'Equal' : i18n['Equal'];
                customComparisonOperators['notequal'] = _.isUndefined(i18n['Not Equal']) ? 'Not Equal' : i18n['Not Equal'];
                customComparisonOperators['like'] = _.isUndefined(i18n['Contains']) ? 'Contains' : i18n['Contains'];
                customComparisonOperators['in'] = _.isUndefined(i18n['Any']) ? 'Any' : i18n['Any'];
            }

            if ((fieldName === 'lead_customer_group_id' || fieldName === 'organization_customer_group_id') && typeof this.scoreRuleModel.get('customerGroups') !== 'undefined') {
                specialElType['elementValues'] = this.scoreRuleModel.get('customerGroups');
                flagMultiSelect = true;
            }

            if ((fieldName === 'lead_country_code' || fieldName === 'organization_country_code') && typeof this.scoreRuleModel.get('countryCodes') !== 'undefined') {
                specialElType['elementValues'] = this.scoreRuleModel.get('countryCodes');
                flagMultiSelect = true;
            }

            if ((fieldName === 'owner_id') && typeof this.scoreRuleModel.get('leadOwners') !== 'undefined') {
                specialElType['elementValues'] = this.scoreRuleModel.get('leadOwners');
                flagMultiSelect = true;
            }

            if ((fieldName === 'stage_id') && typeof this.scoreRuleModel.get('stages') !== 'undefined') {
                specialElType['elementValues'] = this.scoreRuleModel.get('stages');
                flagMultiSelect = true;
            }

            if ((fieldName === 'organization_industry_id') && typeof this.scoreRuleModel.get('industries') !== 'undefined') {
                specialElType['elementValues'] = this.scoreRuleModel.get('industries');
                flagMultiSelect = true;
            }

            if ((fieldName === 'lead_tags') && typeof this.scoreRuleModel.get('leadTags') !== 'undefined') {
                specialElType['elementValues'] = this.scoreRuleModel.get('leadTags');
                flagMultiSelect = true;
            }

            if ((fieldName === 'opportunity_stage') && typeof this.scoreRuleModel.get('opportunityStages') !== 'undefined') {
                specialElType['elementValues'] = this.scoreRuleModel.get('opportunityStages');
                flagMultiSelect = true;
            }

            if ((fieldName === 'opportunity_type') && typeof this.scoreRuleModel.get('opportunityTypes') !== 'undefined') {
                specialElType['elementValues'] = this.scoreRuleModel.get('opportunityTypes');
                flagMultiSelect = true;
            }

            if (fieldName === 'opportunity_close_date') {
                specialElType['elementType'] = 'select';
                specialElType['elementValues'] = this.scoreRuleModel.get('leadsPredefinedValues')['opportunity_close_date'];
                customComparisonOperators['equal'] = _.isUndefined(i18n['Equal']) ? 'Equal' : i18n['Equal'];
            }

            if (flagMultiSelect === true) {
                specialElType['elementType'] = 'multiselect';
                customComparisonOperators['in'] = _.isUndefined(i18n['Any']) ? 'Any' : i18n['Any'];
                customComparisonOperators['notin'] = _.isUndefined(i18n['Excluding']) ? 'Excluding' : i18n['Excluding'];
            }

            if (fieldName === 'last_activity_inbound') {
                specialElType['elementType'] = 'select';
                specialElType['elementValues'] = this.scoreRuleModel.get('leadsPredefinedValues')['last_activity_inbound'];
                customComparisonOperators['equal'] = _.isUndefined(i18n['Equal']) ? 'Equal' : i18n['Equal'];
            }

            if (fieldName === 'last_activity_outbound') {
                specialElType['elementType'] = 'select';
                specialElType['elementValues'] = this.scoreRuleModel.get('leadsPredefinedValues')['last_activity_outbound'];
                customComparisonOperators['equal'] = _.isUndefined(i18n['Equal']) ? 'Equal' : i18n['Equal'];
            }

            if (fieldName === 'lead_state_code' || fieldName === 'organization_state_code') {
                placeholder = (_.isUndefined(i18n['Ex: AL']) ? 'Ex: AL' : i18n['Ex: AL']);
            }

            if (fieldName === 'lead_source') {
                customComparisonOperators['like'] = _.isUndefined(i18n['Contains']) ? 'Contains' : i18n['Contains'];
            }

            $('#score-field-rules-configuration-block-label-detailed-view').removeClass('hidden');
            if ($('#score-field-rule-row-block-detailed-view-'+fieldKey).length == '0') {
                $('#score-field-rules-configuration-block-rows-detailed-view').append( _.template(LeadScoreRulesFieldRowTmpl, {
                    'fieldKey': fieldKey,
                    'fieldName': fieldName,
                    'fieldLabel':fieldLabel,
                    'fieldType':fieldType,
                    'fieldSubtype': '',
                    'moment': moment,
                    'i18n':i18n,
                    'blockFields': blockFields,
                    'customComparisonOperators': customComparisonOperators,
                    'ruleComparisonOperator' : '',
                    'fieldValue':'',
                    'specialElType': specialElType,
                    'placeholder': placeholder,
                    'phoneCountryCodes' : this.scoreRuleModel.get('phoneCountryCodes'),
                    'defaultDesktopCountryCode' : this.scoreRuleModel.get('userDefaultPhoneMobileCode')
                }));

                if (flagMultiSelect === true) {
                    $('#score-field-rule-row-block-detailed-view-'+fieldKey).find('.score-field-rules-row-value').chosen();
                }

                var desktopMasks = this.scoreRuleModel.get('desktopMasks'),
                    defaultDesktopCountryCode = this.scoreRuleModel.get('userDefaultPhoneMobileCode');

                if (typeof desktopMasks[defaultDesktopCountryCode] !== 'undefined') {
                    $('.score-field-rules-row-value-desctop-mask-'+fieldName).mask(desktopMasks[defaultDesktopCountryCode].mask_value, {autoclear: true});
                } else {
                    $('.score-field-rules-row-value-desctop-mask-'+fieldName).mask('(999) 999 9999', {autoclear: false});
                }
            } else {
                showMessage(_.isUndefined(i18n['Field already exists']) ? 'Field already exists' : i18n['Field already exists'], true, 5000);
            }
        },
        addActionField: function()
        {
            var fieldName = $('#score-field-action-attribute-selection-detailed-view').val(),
                fieldSubtype = $('#score-field-action-selection-detailed-view').val(),
                fieldLabel = $('#score-field-action-attribute-selection-detailed-view').find(':selected').data('field-label'),
                fieldType = $('#score-for-rules-detailed-view').val(),
                blockFields = false,
                customComparisonOperators = [],
                fieldKey = fieldName.replace(/\s/g, '')+fieldSubtype.replace(/\s/g, ''),
                placeholder = '',
                specialElType = [],
                flagMultiSelect = false;


            if (fieldName === 'quote_requested' || fieldName === 'quote_view' || fieldName === 'registered' || fieldName === 'quote_sent' || fieldName === 'website_last_action_date_time') {
                blockFields = true;
            }

            if (fieldName === 'duration_placed' || fieldName === 'duration_received'
                || fieldName === 'purchase_amount_single' || fieldName === 'purchase_amount_cumulative' || fieldName === 'visit_duration'
                || fieldName === 'visit_duration_latest' || fieldName === 'action_number'
                || fieldName === 'action_number_latest' || fieldName === 'quote_amount_single'
                || fieldName === 'quote_amount_cumulative' || fieldName === 'email_sent' || fieldName === 'email_received') {
                customComparisonOperators['greaterthan'] = _.isUndefined(i18n['Greater Than']) ? 'Greater Than' : i18n['Greater Than'];
                customComparisonOperators['lessthan'] = _.isUndefined(i18n['Less Than']) ? 'Less Than' : i18n['Less Than'];
            }

            if (fieldName === 'email_opened') {
                customComparisonOperators['equal'] = _.isUndefined(i18n['Equal']) ? 'Equal' : i18n['Equal'];
                placeholder = (_.isUndefined(i18n['Opened \'Number of days\' ago']) ? 'Opened \'Number of days\' ago' : i18n['Opened \'Number of days\' ago']);
            }

            if (fieldName === 'email_link_clicked') {
                customComparisonOperators['equal'] = _.isUndefined(i18n['Equal']) ? 'Equal' : i18n['Equal'];
                placeholder = (_.isUndefined(i18n['Opened \'Number of days\' ago']) ? 'Opened \'Number of days\' ago' : i18n['Opened \'Number of days\' ago']);
            }

            if (fieldName === 'email_link_clicked_in_sequence') {
                specialElType['elementValues'] = this.scoreRuleModel.get('emailSequencies');
                flagMultiSelect = true;
            }

            if (fieldName === 'duration_placed' || fieldName === 'duration_received' || fieldName === 'visit_duration' || fieldName === 'visit_duration_latest') {
                placeholder = (_.isUndefined(i18n['in seconds']) ? 'in seconds' : i18n['in seconds']);
            }

            if (fieldName === 'purchase_products_sku') {
                customComparisonOperators['in'] = _.isUndefined(i18n['Any']) ? 'Any' : i18n['Any'];
                customComparisonOperators['notin'] = _.isUndefined(i18n['Excluding']) ? 'Excluding' : i18n['Excluding'];
                specialElType['elementType'] = 'textarea';
            }

            if (fieldName === 'file_name' || fieldName === 'tracking_number') {
                customComparisonOperators['equal'] = _.isUndefined(i18n['Equal']) ? 'Equal' : i18n['Equal'];
                customComparisonOperators['notequal'] = _.isUndefined(i18n['Not Equal']) ? 'Not Equal' : i18n['Not Equal'];
                customComparisonOperators['like'] = _.isUndefined(i18n['Contains']) ? 'Contains' : i18n['Contains'];
                customComparisonOperators['in'] = _.isUndefined(i18n['Any']) ? 'Any' : i18n['Any'];
            }

            if (fieldName === 'quote_view' || fieldName === 'quote_requested' || fieldName === 'registered' || fieldName === 'quote_sent') {
                specialElType['elementType'] = 'select';
                specialElType['elementValues'] = this.scoreRuleModel.get('leadsPredefinedValues')['yes_no_block'];
                customComparisonOperators['equal'] = _.isUndefined(i18n['Equal']) ? 'Equal' : i18n['Equal'];
            }

            if (fieldName === 'website_last_action_date_time') {
                specialElType['elementType'] = 'select';
                specialElType['elementValues'] = this.scoreRuleModel.get('leadsPredefinedValues')['website_last_action_date_time'];
                customComparisonOperators['equal'] = _.isUndefined(i18n['Equal']) ? 'Equal' : i18n['Equal'];
            }


            if (fieldName === 'quote_expiration_date') {
                specialElType['elementType'] = 'select';
                specialElType['elementValues'] = this.scoreRuleModel.get('leadsPredefinedValues')['quote_expiration_date'];
                customComparisonOperators['equal'] = _.isUndefined(i18n['Equal']) ? 'Equal' : i18n['Equal'];
            }

            if (fieldName === 'sms_keyword_sent' || fieldName === 'sms_keyword_received' || fieldName === 'transcribed_conversation') {
                customComparisonOperators['like'] = _.isUndefined(i18n['Contains']) ? 'Contains' : i18n['Contains'];
            }

            if (flagMultiSelect === true) {
                specialElType['elementType'] = 'multiselect';
                customComparisonOperators['in'] = _.isUndefined(i18n['Any']) ? 'Any' : i18n['Any'];
                customComparisonOperators['notin'] = _.isUndefined(i18n['Excluding']) ? 'Excluding' : i18n['Excluding'];
            }

            if (fieldName === 'email_link_clicked_in_sequence') {
                customComparisonOperators = [];
                customComparisonOperators['in'] = _.isUndefined(i18n['Any']) ? 'Any' : i18n['Any'];
            }

            $('#score-field-rules-configuration-block-label-detailed-view').removeClass('hidden');
            if ($('#score-field-rule-row-block-detailed-view-'+fieldKey).length == '0') {
                $('#score-field-rules-configuration-block-rows-detailed-view').append( _.template(LeadScoreRulesFieldRowTmpl, {
                    'fieldKey': fieldKey,
                    'fieldName': fieldName,
                    'fieldLabel':fieldLabel,
                    'fieldType':fieldType,
                    'fieldSubtype': fieldSubtype,
                    'moment': moment,
                    'i18n':i18n,
                    'blockFields': blockFields,
                    'customComparisonOperators': customComparisonOperators,
                    'ruleComparisonOperator' : '',
                    'fieldValue':'',
                    'placeholder': placeholder,
                    'specialElType': specialElType,
                    'phoneCountryCodes' : this.scoreRuleModel.get('phoneCountryCodes'),
                    'defaultDesktopCountryCode' : this.scoreRuleModel.get('userDefaultPhoneMobileCode')
                }));

                if (flagMultiSelect === true) {
                    $('#score-field-rule-row-block-detailed-view-'+fieldKey).find('.score-field-rules-row-value').chosen();
                }

                var desktopMasks = this.scoreRuleModel.get('desktopMasks'),
                    defaultDesktopCountryCode = this.scoreRuleModel.get('userDefaultPhoneMobileCode');

                if (typeof desktopMasks[defaultDesktopCountryCode] !== 'undefined') {
                    $('.score-field-rules-row-value-desctop-mask-'+fieldName).mask(desktopMasks[defaultDesktopCountryCode].mask_value, {autoclear: true});
                } else {
                    $('.score-field-rules-row-value-desctop-mask-'+fieldName).mask('(999) 999 9999', {autoclear: false});
                }
            } else {
                showMessage(_.isUndefined(i18n['Field already exists']) ? 'Field already exists' : i18n['Field already exists'], true, 5000);
            }
        },
        addSingleField: function(fieldName, fieldLabel, fieldType, fieldSubtype, ruleComparisonOperator, fieldValue)
        {
            var fieldKey = fieldType+'-'+fieldName.replace(/\s/g, ''),
                blockFields = false,
                customComparisonOperators = [],
                specialElType = [],
                flagMultiSelect = false,
                placeholder = '';

            if (fieldName === 'organization_employees' || fieldName === 'opportunity_amount_cumulative' || fieldName === 'opportunity_amount') {
                customComparisonOperators['greaterthan'] = _.isUndefined(i18n['Greater Than']) ? 'Greater Than' : i18n['Greater Than'];
                customComparisonOperators['lessthan'] = _.isUndefined(i18n['Less Than']) ? 'Less Than' : i18n['Less Than'];
            }

            if (fieldName === 'last_activity_inbound' || fieldName === 'last_activity_outbound' || fieldName === 'opportunity_close_date') {
                blockFields = true;
            }

            if (fieldName === 'lead_state_code' || fieldName === 'lead_position' || fieldName === 'organization_state_code' || fieldName === 'lead_phone') {
                customComparisonOperators['equal'] = _.isUndefined(i18n['Equal']) ? 'Equal' : i18n['Equal'];
                customComparisonOperators['notequal'] = _.isUndefined(i18n['Not Equal']) ? 'Not Equal' : i18n['Not Equal'];
                customComparisonOperators['like'] = _.isUndefined(i18n['Contains']) ? 'Contains' : i18n['Contains'];
                customComparisonOperators['in'] = _.isUndefined(i18n['Any']) ? 'Any' : i18n['Any'];
            }

            if ((fieldName === 'lead_customer_group_id' || fieldName === 'organization_customer_group_id') && typeof this.scoreRuleModel.get('customerGroups') !== 'undefined') {
                specialElType['elementValues'] = this.scoreRuleModel.get('customerGroups');
                flagMultiSelect = true;
            }

            if ((fieldName === 'lead_country_code' || fieldName === 'organization_country_code') && typeof this.scoreRuleModel.get('countryCodes') !== 'undefined') {
                specialElType['elementValues'] = this.scoreRuleModel.get('countryCodes');
                flagMultiSelect = true;
            }

            if ((fieldName === 'owner_id') && typeof this.scoreRuleModel.get('leadOwners') !== 'undefined') {
                specialElType['elementValues'] = this.scoreRuleModel.get('leadOwners');
                flagMultiSelect = true;
            }

            if ((fieldName === 'stage_id') && typeof this.scoreRuleModel.get('stages') !== 'undefined') {
                specialElType['elementValues'] = this.scoreRuleModel.get('stages');
                flagMultiSelect = true;
            }

            if ((fieldName === 'lead_tags') && typeof this.scoreRuleModel.get('leadTags') !== 'undefined') {
                specialElType['elementValues'] = this.scoreRuleModel.get('leadTags');
                flagMultiSelect = true;
            }

            if ((fieldName === 'organization_industry_id') && typeof this.scoreRuleModel.get('industries') !== 'undefined') {
                specialElType['elementValues'] = this.scoreRuleModel.get('industries');
                flagMultiSelect = true;
            }

            if ((fieldName === 'opportunity_stage') && typeof this.scoreRuleModel.get('opportunityStages') !== 'undefined') {
                specialElType['elementValues'] = this.scoreRuleModel.get('opportunityStages');
                flagMultiSelect = true;
            }

            if ((fieldName === 'opportunity_type') && typeof this.scoreRuleModel.get('opportunityTypes') !== 'undefined') {
                specialElType['elementValues'] = this.scoreRuleModel.get('opportunityTypes');
                flagMultiSelect = true;
            }

            if (flagMultiSelect === true) {
                specialElType['elementType'] = 'multiselect';
                customComparisonOperators['in'] = _.isUndefined(i18n['Any']) ? 'Any' : i18n['Any'];
                customComparisonOperators['notin'] = _.isUndefined(i18n['Excluding']) ? 'Excluding' : i18n['Excluding'];
            }

            if (fieldName === 'last_activity_inbound') {
                specialElType['elementType'] = 'select';
                specialElType['elementValues'] = this.scoreRuleModel.get('leadsPredefinedValues')['last_activity_inbound'];
                customComparisonOperators['equal'] = _.isUndefined(i18n['Equal']) ? 'Equal' : i18n['Equal'];
            }

            if (fieldName === 'last_activity_outbound') {
                specialElType['elementType'] = 'select';
                specialElType['elementValues'] = this.scoreRuleModel.get('leadsPredefinedValues')['last_activity_outbound'];
                customComparisonOperators['equal'] = _.isUndefined(i18n['Equal']) ? 'Equal' : i18n['Equal'];
            }

            if (fieldName === 'opportunity_close_date') {
                specialElType['elementType'] = 'select';
                specialElType['elementValues'] = this.scoreRuleModel.get('leadsPredefinedValues')['opportunity_close_date'];
                customComparisonOperators['equal'] = _.isUndefined(i18n['Equal']) ? 'Equal' : i18n['Equal'];
            }

            if (fieldName === 'lead_state_code' || fieldName === 'organization_state_code') {
                placeholder = (_.isUndefined(i18n['Ex: AL']) ? 'Ex: AL' : i18n['Ex: AL']);
            }

            if (fieldName === 'lead_source') {
                customComparisonOperators['like'] = _.isUndefined(i18n['Contains']) ? 'Contains' : i18n['Contains'];
            }

            $('#score-field-rules-configuration-block-label-detailed-view').removeClass('hidden');
            if ($('#score-field-rule-row-block-detailed-view-'+fieldKey).length == '0') {

                var userDefaultPhoneMobileCode = this.scoreRuleModel.get('userDefaultPhoneMobileCode'),
                    desktopMasks = this.scoreRuleModel.get('desktopMasks');

                if(fieldName == 'lead_phone' || fieldName == 'tracking_number') {
                    if(ruleComparisonOperator == 'equal' || ruleComparisonOperator == 'notequal') {
                        userDefaultPhoneMobileCode = fieldValue['country_code'];
                        fieldValue = fieldValue[fieldName];
                    }
                }

                $('#score-field-rules-configuration-block-rows-detailed-view').append( _.template(LeadScoreRulesFieldRowTmpl, {
                    'fieldKey': fieldKey,
                    'fieldName': fieldName,
                    'fieldLabel':fieldLabel,
                    'fieldType':fieldType,
                    'fieldSubtype': '',
                    'moment': moment,
                    'i18n':i18n,
                    'blockFields': blockFields,
                    'customComparisonOperators': customComparisonOperators,
                    'fieldValue': fieldValue,
                    'specialElType': specialElType,
                    'ruleComparisonOperator':ruleComparisonOperator,
                    'placeholder': placeholder,
                    'phoneCountryCodes' : this.scoreRuleModel.get('phoneCountryCodes'),
                    'defaultDesktopCountryCode' : userDefaultPhoneMobileCode
                }));

                if(fieldName == 'lead_phone' || fieldName == 'tracking_number') {
                    if(ruleComparisonOperator == 'equal' || ruleComparisonOperator == 'notequal') {
                        $('.score-field-rules-row-value-desctop-mask-'+fieldName).prop('placeholder', '');

                        if (typeof desktopMasks[userDefaultPhoneMobileCode] !== 'undefined') {
                            $('.score-field-rules-row-value-desctop-mask-'+fieldName).mask(desktopMasks[userDefaultPhoneMobileCode].mask_value, {autoclear: true});
                        } else {
                            $('.score-field-rules-row-value-desctop-mask-'+fieldName).mask('(999) 999 9999', {autoclear: false});
                        }
                    }

                    if(ruleComparisonOperator == 'like') {
                        placeholder = (_.isUndefined(i18n['+18774509...']) ? '+18774509...' : i18n['+18774509...']);
                    }

                    if(ruleComparisonOperator === 'in') {
                        placeholder = (_.isUndefined(i18n['separate the values with commas and enter phone with country code ex: +18774509...']) ? 'separate the values with commas and enter phone with country code ex: +18774509...' : i18n['separate the values with commas and enter phone with country code ex: +18774509...'])
                    }

                    $('.score-field-rules-row-value-desctop-mask-'+fieldName).prop('placeholder', placeholder);
                }

                if (flagMultiSelect === true) {
                    $('#score-field-rule-row-block-detailed-view-'+fieldKey).find('.score-field-rules-row-value').chosen();
                }
            }
        },
        addSingleActionField(fieldName, fieldLabel, fieldType, fieldSubtype, ruleComparisonOperator, fieldValue) {
            var blockFields = false,
                customComparisonOperators = [],
                fieldKey = fieldName.replace(/\s/g, '')+fieldSubtype.replace(/\s/g, ''),
                placeholder = '',
                specialElType = [],
                flagMultiSelect = false;

            if (fieldName === 'quote_requested' || fieldName === 'quote_view' || fieldName === 'registered' || fieldName === 'quote_sent' || fieldName === 'website_last_action_date_time') {
                blockFields = true;
            }

            if (fieldName === 'duration_placed' || fieldName === 'duration_received'
                || fieldName === 'purchase_amount_single' || fieldName === 'purchase_amount_cumulative' || fieldName === 'visit_duration'
                || fieldName === 'visit_duration_latest' || fieldName === 'action_number'
                || fieldName === 'action_number_latest' || fieldName === 'quote_amount_single'
                || fieldName === 'quote_amount_cumulative' || fieldName === 'email_sent' || fieldName === 'email_received') {
                customComparisonOperators['greaterthan'] = _.isUndefined(i18n['Greater Than']) ? 'Greater Than' : i18n['Greater Than'];
                customComparisonOperators['lessthan'] = _.isUndefined(i18n['Less Than']) ? 'Less Than' : i18n['Less Than'];
            }

            if (fieldName === 'email_opened') {
                customComparisonOperators['equal'] = _.isUndefined(i18n['Equal']) ? 'Equal' : i18n['Equal'];
                placeholder = (_.isUndefined(i18n['Opened \'Number of days\' ago']) ? 'Opened \'Number of days\' ago' : i18n['Opened \'Number of days\' ago']);
            }

            if (fieldName === 'email_link_clicked') {
                customComparisonOperators['equal'] = _.isUndefined(i18n['Equal']) ? 'Equal' : i18n['Equal'];
                placeholder = (_.isUndefined(i18n['Clicked \'Number of days\' ago']) ? 'Clicked \'Number of days\' ago' : i18n['Clicked \'Number of days\' ago']);
            }

            if (fieldName === 'email_link_clicked_in_sequence') {
                specialElType['elementValues'] = this.scoreRuleModel.get('emailSequencies');
                flagMultiSelect = true;
            }

            if (fieldName === 'duration_placed' || fieldName === 'duration_received' || fieldName === 'visit_duration' || fieldName === 'visit_duration_latest') {
                placeholder = (_.isUndefined(i18n['in seconds']) ? 'in seconds' : i18n['in seconds']);
            }

            if (fieldName === 'file_name' || fieldName === 'tracking_number') {
                customComparisonOperators['equal'] = _.isUndefined(i18n['Equal']) ? 'Equal' : i18n['Equal'];
                customComparisonOperators['notequal'] = _.isUndefined(i18n['Not Equal']) ? 'Not Equal' : i18n['Not Equal'];
                customComparisonOperators['like'] = _.isUndefined(i18n['Contains']) ? 'Contains' : i18n['Contains'];
                customComparisonOperators['in'] = _.isUndefined(i18n['Any']) ? 'Any' : i18n['Any'];
            }

            if (fieldName === 'quote_view' || fieldName === 'quote_requested' || fieldName === 'registered' || fieldName === 'quote_sent') {
                specialElType['elementType'] = 'select';
                specialElType['elementValues'] = this.scoreRuleModel.get('leadsPredefinedValues')['yes_no_block'];
                customComparisonOperators['equal'] = _.isUndefined(i18n['Equal']) ? 'Equal' : i18n['Equal'];
            }

            if (fieldName === 'purchase_products_sku') {
                customComparisonOperators['in'] = _.isUndefined(i18n['Any']) ? 'Any' : i18n['Any'];
                customComparisonOperators['notin'] = _.isUndefined(i18n['Excluding']) ? 'Excluding' : i18n['Excluding'];
                specialElType['elementType'] = 'textarea';
            }

            if (fieldName === 'quote_expiration_date') {
                specialElType['elementType'] = 'select';
                specialElType['elementValues'] = this.scoreRuleModel.get('leadsPredefinedValues')['quote_expiration_date'];
                customComparisonOperators['equal'] = _.isUndefined(i18n['Equal']) ? 'Equal' : i18n['Equal'];
            }

            if (fieldName === 'website_last_action_date_time') {
                specialElType['elementType'] = 'select';
                specialElType['elementValues'] = this.scoreRuleModel.get('leadsPredefinedValues')['website_last_action_date_time'];
                customComparisonOperators['equal'] = _.isUndefined(i18n['Equal']) ? 'Equal' : i18n['Equal'];
            }

            if (fieldName === 'sms_keyword_sent' || fieldName === 'sms_keyword_received' || fieldName === 'transcribed_conversation') {
                customComparisonOperators['like'] = _.isUndefined(i18n['Contains']) ? 'Contains' : i18n['Contains'];
            }

            if (flagMultiSelect === true) {
                specialElType['elementType'] = 'multiselect';
                customComparisonOperators['in'] = _.isUndefined(i18n['Any']) ? 'Any' : i18n['Any'];
                customComparisonOperators['notin'] = _.isUndefined(i18n['Excluding']) ? 'Excluding' : i18n['Excluding'];
            }

            if (fieldName === 'email_link_clicked_in_sequence') {
                customComparisonOperators = [];
                customComparisonOperators['in'] = _.isUndefined(i18n['Any']) ? 'Any' : i18n['Any'];
            }

            $('#score-field-rules-configuration-block-label-detailed-view').removeClass('hidden');
            if ($('#score-field-rule-row-block-detailed-view-'+fieldKey).length == '0') {

                var userDefaultPhoneMobileCode = this.scoreRuleModel.get('userDefaultPhoneMobileCode'),
                    desktopMasks = this.scoreRuleModel.get('desktopMasks');

                if(fieldName == 'lead_phone' || fieldName == 'tracking_number') {
                    if(ruleComparisonOperator == 'equal' || ruleComparisonOperator == 'notequal') {
                        userDefaultPhoneMobileCode = fieldValue['country_code'];
                        fieldValue = fieldValue[fieldName];
                    }
                }

                $('#score-field-rules-configuration-block-rows-detailed-view').append( _.template(LeadScoreRulesFieldRowTmpl, {
                    'fieldKey': fieldKey,
                    'fieldName': fieldName,
                    'fieldLabel':fieldLabel,
                    'fieldType':fieldType,
                    'fieldSubtype': fieldSubtype,
                    'moment': moment,
                    'i18n':i18n,
                    'blockFields': blockFields,
                    'customComparisonOperators': customComparisonOperators,
                    'fieldValue': fieldValue,
                    'ruleComparisonOperator':ruleComparisonOperator,
                    'placeholder': placeholder,
                    'specialElType': specialElType,
                    'phoneCountryCodes' : this.scoreRuleModel.get('phoneCountryCodes'),
                    'defaultDesktopCountryCode' : userDefaultPhoneMobileCode
                }));


                if (flagMultiSelect === true) {
                    $('#score-field-rule-row-block-detailed-view-'+fieldKey).find('.score-field-rules-row-value').chosen();
                }

                if(fieldName == 'lead_phone' || fieldName == 'tracking_number') {
                    if(ruleComparisonOperator == 'equal' || ruleComparisonOperator == 'notequal') {
                        $('.score-field-rules-row-value-desctop-mask-'+fieldName).prop('placeholder', '');

                        if (typeof desktopMasks[userDefaultPhoneMobileCode] !== 'undefined') {
                            $('.score-field-rules-row-value-desctop-mask-'+fieldName).mask(desktopMasks[userDefaultPhoneMobileCode].mask_value, {autoclear: true});
                        } else {
                            $('.score-field-rules-row-value-desctop-mask-'+fieldName).mask('(999) 999 9999', {autoclear: false});
                        }
                    }

                    if(ruleComparisonOperator == 'like') {
                        placeholder = (_.isUndefined(i18n['+18774509...']) ? '+18774509...' : i18n['+18774509...']);
                    }

                    if(ruleComparisonOperator === 'in') {
                        placeholder = (_.isUndefined(i18n['separate the values with commas and enter phone with country code ex: +18774509...']) ? 'separate the values with commas and enter phone with country code ex: +18774509...' : i18n['separate the values with commas and enter phone with country code ex: +18774509...'])
                    }

                    $('.score-field-rules-row-value-desctop-mask-'+fieldName).prop('placeholder', placeholder);
                }
            }
        },
        getActionTypesAttributes(e) {
            var el = $(e.currentTarget),
                actionType = el.val(),
                self = this;

            if (actionType == '0') {
                $('#score-field-action-attribute-selection-block-detailed-view').addClass('hidden');
                return false;
            }

            $.ajax({
                url: $('#website_url').val()+'plugin/leads/run/getActionAttributesForScore',
                type: 'POST',
                data: {'actionType' : actionType, 'excludeField':'email_received_imap,email_received_imap_from'},
                dataType: 'json'
            }).done(function(response) {
                var options = '';
                $('#score-field-action-attribute-selection-block-detailed-view').removeClass('hidden');
                $.each(response.responseText, function(fieldValue, fieldLabel){
                    options += '<option data-field-label="'+fieldLabel+'" value="'+fieldValue+'">'+fieldLabel+'</option>';
                });
                $('#score-field-action-attribute-selection-detailed-view').empty().append(options);
            }).fail(function(response){
                showMessage(response.responseJSON, true, 5000);
            });
            return false;
        },
        changeRule: function(e)
        {
            var el = $(e.currentTarget),
                type = el.val(),
                self = this;

            if (el.val() == '0') {
                $('#score-field-attribute-selection-block-detailed-view').addClass('hidden');
                $('#score-field-action-selection-block-detailed-view').addClass('hidden');
                $('#score-field-action-attribute-selection-block-detailed-view').addClass('hidden');
                return false;
            }

            if (type === 'lead_attribute' || type === 'organization_attribute' || type === 'lead_opportunities'
                ||  type === 'lead_custom_attributes' || type === 'organization_custom_attributes') {
                this.getAttributes(type);
            } else if(type === 'action_type') {
                $('#score-field-attribute-selection-block-detailed-view').addClass('hidden');
                $('#score-field-action-selection-block-detailed-view').removeClass('hidden');
            }

        },
        changeRuleOperator: function(e)
        {
            var el = $(e.currentTarget),
                ruleOperator = el.val(),
                valueEl = el.closest('div').find('.score-field-rules-row-value'),
                infoTooltip = window.appLeadToolsRouter.leadTooltipInfo(ruleOperator),
                rowType = el.closest('div').data('field-name'),
                placeholder = (_.isUndefined(i18n['separate the values with commas']) ? 'separate the values with commas' : i18n['separate the values with commas']),
                desctopMaskClass = '';

            el.prop('title', infoTooltip);

            if(rowType == 'lead_phone' || rowType == 'tracking_number') {
                desctopMaskClass = 'score-field-rules-row-value-desctop-mask-'+rowType;
            }

            if(ruleOperator === 'like') {
                placeholder = (_.isUndefined(i18n['+18774509...']) ? '+18774509...' : i18n['+18774509...']);
                $('.score-field-rules-row-value-desctop-mask-'+rowType).prop('placeholder', placeholder);
            }

            if(ruleOperator === 'in') {
                placeholder = (_.isUndefined(i18n['separate the values with commas and enter phone with country code ex: +18774509...']) ? 'separate the values with commas and enter phone with country code ex: +18774509...' : i18n['separate the values with commas and enter phone with country code ex: +18774509...'])
            }

            if ((ruleOperator === 'in' || ruleOperator === 'notin') && (valueEl.is('input') || valueEl.is('textarea'))) {
                valueEl.replaceWith('<textarea placeholder="'+ placeholder +'" class="score-field-rules-row-value ' + desctopMaskClass + ' field-rule-row-last grid_5 alpha omega" name="'+valueEl.prop('name')+'">'+valueEl.val()+'</textarea>');
            } else if(!valueEl.is('input') && !valueEl.is('select')) {
                valueEl.replaceWith('<input type="text" placeholder="'+ placeholder +'" class="score-field-rules-row-value ' + desctopMaskClass + ' field-rule-row-last grid_5 alpha omega" name="'+valueEl.prop('name')+'" value="'+valueEl.val()+'" />');
            }

            if(rowType == 'lead_phone' || rowType == 'tracking_number') {
                if(ruleOperator == 'equal' || ruleOperator == 'notequal') {
                    $('.score-field-rules-row-value-desctop-mask-'+rowType).prop('placeholder', '');

                    var desktopMasks = this.scoreRuleModel.get('desktopMasks'),
                        defaultDesktopCountryCode = this.scoreRuleModel.get('userDefaultPhoneMobileCode'),
                        selectedCountryCode = $('.phone-countries-codes-'+rowType).val();

                    if(selectedCountryCode == '' || selectedCountryCode == null) {
                        selectedCountryCode = defaultDesktopCountryCode;
                    }

                    if (typeof desktopMasks[selectedCountryCode] !== 'undefined') {
                        $('.score-field-rules-row-value-desctop-mask-'+rowType).mask(desktopMasks[selectedCountryCode].mask_value, {autoclear: true});
                    } else {
                        $('.score-field-rules-row-value-desctop-mask-'+rowType).mask('(999) 999 9999', {autoclear: true});
                    }

                    $('.phone-countries-codes-'+rowType).show();
                } else {
                    $('.phone-countries-codes-'+rowType).hide();

                    $('.score-field-rules-row-value-desctop-mask-'+rowType).unmask();
                    var valueElClean = valueEl.val().replace(/[^+0-9]/g, '');
                    $('.score-field-rules-row-value-desctop-mask-'+rowType).val(valueElClean);
                }
            }
        },
        getAttributes(type){
            $.ajax({
                url: $('#website_url').val()+'plugin/leads/run/getAttributesForScore',
                type: 'POST',
                data: {'attributesType' : type},
                dataType: 'json'
            }).done(function(response) {
                $('#score-field-attribute-selection-block-detailed-view').removeClass('hidden');
                $('#score-field-action-selection-block-detailed-view').addClass('hidden');
                $('#score-field-action-attribute-selection-detailed-view').empty();
                $('#score-field-action-attribute-selection-block-detailed-view').addClass('hidden');
                var options = '';
                $.each(response.responseText, function(fieldValue, fieldLabel){
                    options += '<option data-field-label="'+fieldLabel+'" value="'+fieldValue+'">'+fieldLabel+'</option>';
                });
                $('#score-field-attribute-selection-detailed-view').empty().append(options);
            }).fail(function(response){
                showMessage(response.responseJSON, true, 5000);
            });
            return false;
        },
        deleteFieldRow: function(e)
        {
            e.preventDefault();
            showConfirm(_.isUndefined(i18n['Are you sure want to delete?']) ? 'Are you sure want to delete?' : i18n['Are you sure want to delete?'], function () {
                $(e.currentTarget).closest('.score-field-rule-row-block').remove();
            });

        },
        updateLeadScoreRule: function(e)
        {
            e.preventDefault();
            var ruleConfigBlocks = $('#score-field-rules-configuration-block-rows-detailed-view').find('.score-field-rule-row-block'),
                error = false,
                fieldsConfigData = [],
                actionsData = [],
                ruleId = $('#score-rules-form-id-detailed-view').val(),
                scoreRuleName = $('#score-rule-name-general-detailed-view').val(),
                ruleSetScoreSign = $('#rule-set-score-sign-detailed-view').val(),
                ruleSetScore = parseInt($('#rule-set-score-detailed-view').val());

            if (ruleConfigBlocks.length === 0) {
                showMessage(_.isUndefined(i18n['Please create at least one rule']) ? 'Please create at least one rule' : i18n['Please create at least one rule'], true, false);
                return false;
            }

            $.each(ruleConfigBlocks, function(ruleConfigBlock) {
                var fieldValue = $(this).find('.score-field-rules-row-value').val(),
                    self = $(this),
                    countryCode = '';
                if($(this).data('field-name') == 'lead_phone' || $(this).data('field-name') == 'tracking_number') {
                    if($(this).find('.score-field-operator-value').val() == 'equal' || $(this).find('.score-field-operator-value').val() == 'notequal') {
                        countryCode = $('.phone-countries-codes-'+ $(this).data('field-name')).val();
                        fieldValue = fieldValue.replace(/[^0-9]/g, '');
                    } else if($(this).find('.score-field-operator-value').val() == 'in') {
                        var phoneNambers = $.trim(fieldValue).split(',');
                        if(phoneNambers.length) {
                            $.each(phoneNambers, function (key, number){
                                number = $.trim(number);

                                if(number.indexOf('+') !== 0) {
                                    showMessage($(self).data('field-name') + ' ' + (_.isUndefined(i18n[' must start with country code']) ? ' must start with country code' : i18n[' must start with country code']), true, false);
                                    error = true;
                                    return false;
                                }
                            });
                        }
                    }
                }

                fieldsConfigData.push({'field_name': $(this).data('field-name'), 'rule_comparison_operator' : $(this).find('.score-field-operator-value').val(), 'field_value' : fieldValue, 'rule_type':$(this).data('field-type'), 'rule_subtype': $(this).data('field-subtype'), 'country_code': countryCode});
            });

            if (error === true) {
                return false;
            }

            if (scoreRuleName === '') {
                showMessage(_.isUndefined(i18n['Please specify rule name']) ? 'Please specify rule name' : i18n['Please specify rule name'], true, false);
                return false;
            }

            var data = {'secureToken': $('#tools-leads-grid-token').val(), 'ruleId': ruleId, 'rule_name': scoreRuleName, 'score_sign':ruleSetScoreSign, 'score':ruleSetScore, 'fieldsData' : fieldsConfigData};

            $.ajax({
                url: $('#website_url').val()+'api/leads/leadscorerules',
                type: 'PUT',
                data: data,
                dataType: 'json'
            }).done(function(response) {
                showMessage(response.responseText.message, false, 5000);
                $('#lead-score-form-block').trigger('LeadScoreFormGrid:created');
            }).fail(function(response){
                showMessage(response.responseJSON, true, 5000);
            });
            return false;
        },
        hideLeadDetailsScreen: function(e)
        {
            var href = $(e.currentTarget).attr('href');
            if (href.match(/http(.*)/)) {
                window.location.href = href;
            } else {
                $('#lead-block-detailed-view').empty();
                $('#lead-table-block').show();
                $('.filters').show();
                $('#lead-grid-back-link').addClass('hidden');
                $('#lead-additional-filters').show();
            }
        },
        assign: function (selector, view) {
            var selectors;
            if (_.isObject(selector)) {
                selectors = selector;
            }
            else {
                selectors = {};
                selectors[selector] = view;
            }
            if (!selectors) return;
            _.each(selectors, function (view, selector) {
                view.setElement(this.$(selector)).render();
            }, this);
        },
        changeAttribute: function(e)
        {
            var el = $(e.currentTarget),
                attributeName = el.data('lead-attr'),
                oldVal = el.data('lead-old-val'),
                currentVal = el.val();

            if (oldVal == currentVal) {
                return false;
            }

            this.updateFormAttribute(el, attributeName, currentVal);
        },
        updateFormAttribute: function(el, attributeName, currentVal)
        {
            var self = this;

            this.leadModel.set(attributeName, currentVal);
            this.leadModel.set('secureToken', $('#lead-grid-token').val());
            this.leadModel.save(null,{
                success: function(model, response){
                    showMessage(response.responseText.message, false, 5000);
                    el.data('lead-old-val', currentVal);
                },
                error: function(model, response){
                    showMessage(response.responseJSON, true, 5000);
                }
            });
        },
        changeDesktopMask: function(e)
        {
            var selectionType = $(e.currentTarget).data('type'),
                fieldName = $(e.currentTarget).data('field-name'),
                value =  $(e.currentTarget).val();

            var //mobileMasks = this.scoreRuleModel.get(('mobileMasks'),
                desktopMasks = this.scoreRuleModel.get('desktopMasks');

            if (selectionType === 'mobile') {
                /*if (typeof mobileMasks[value] !== 'undefined') {
                    $('.lead-mobile-detailed-view').mask(mobileMasks[value].mask_value, {autoclear: false});
                } else {
                    $('.lead-mobile-detailed-view').mask('(999) 999 9999', {autoclear: false});
                }*/
            }

            if (selectionType === 'desktop') {
                if (typeof desktopMasks[value] !== 'undefined') {
                    $('.score-field-rules-row-value-desctop-mask-'+fieldName).mask(desktopMasks[value].mask_value, {autoclear: false});
                } else {
                    $('.score-field-rules-row-value-desctop-mask-'+fieldName).mask('(999) 999 9999', {autoclear: false});
                }
            }
        },
    });

    return ScoreRuleDetailedView;
});
